# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs

__all__ = [
    'GroupGroupKey',
    'GroupMembershipMemberKey',
    'GroupMembershipPreferredMemberKey',
    'GroupMembershipRole',
    'GetGroupMembershipsMembershipResult',
    'GetGroupMembershipsMembershipMemberKeyResult',
    'GetGroupMembershipsMembershipPreferredMemberKeyResult',
    'GetGroupMembershipsMembershipRoleResult',
    'GetGroupsGroupResult',
    'GetGroupsGroupGroupKeyResult',
]

@pulumi.output_type
class GroupGroupKey(dict):
    def __init__(__self__, *,
                 id: str,
                 namespace: Optional[str] = None):
        """
        :param str id: The ID of the entity.
               For Google-managed entities, the id must be the email address of an existing
               group or user.
               For external-identity-mapped entities, the id must be a string conforming
               to the Identity Source's requirements.
               Must be unique within a namespace.
        :param str namespace: The namespace in which the entity exists.
               If not specified, the EntityKey represents a Google-managed entity
               such as a Google user or a Google Group.
               If specified, the EntityKey represents an external-identity-mapped group.
               The namespace must correspond to an identity source created in Admin Console
               and must be in the form of `identitysources/{identity_source_id}`.
        """
        pulumi.set(__self__, "id", id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the entity.
        For Google-managed entities, the id must be the email address of an existing
        group or user.
        For external-identity-mapped entities, the id must be a string conforming
        to the Identity Source's requirements.
        Must be unique within a namespace.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace in which the entity exists.
        If not specified, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If specified, the EntityKey represents an external-identity-mapped group.
        The namespace must correspond to an identity source created in Admin Console
        and must be in the form of `identitysources/{identity_source_id}`.
        """
        return pulumi.get(self, "namespace")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GroupMembershipMemberKey(dict):
    def __init__(__self__, *,
                 id: str,
                 namespace: Optional[str] = None):
        """
        :param str id: The ID of the entity.
               For Google-managed entities, the id must be the email address of an existing
               group or user.
               For external-identity-mapped entities, the id must be a string conforming
               to the Identity Source's requirements.
               Must be unique within a namespace.
        :param str namespace: The namespace in which the entity exists.
               If not specified, the EntityKey represents a Google-managed entity
               such as a Google user or a Google Group.
               If specified, the EntityKey represents an external-identity-mapped group.
               The namespace must correspond to an identity source created in Admin Console
               and must be in the form of `identitysources/{identity_source_id}`.
        """
        pulumi.set(__self__, "id", id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the entity.
        For Google-managed entities, the id must be the email address of an existing
        group or user.
        For external-identity-mapped entities, the id must be a string conforming
        to the Identity Source's requirements.
        Must be unique within a namespace.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace in which the entity exists.
        If not specified, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If specified, the EntityKey represents an external-identity-mapped group.
        The namespace must correspond to an identity source created in Admin Console
        and must be in the form of `identitysources/{identity_source_id}`.
        """
        return pulumi.get(self, "namespace")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GroupMembershipPreferredMemberKey(dict):
    def __init__(__self__, *,
                 id: str,
                 namespace: Optional[str] = None):
        """
        :param str id: The ID of the entity.
               For Google-managed entities, the id must be the email address of an existing
               group or user.
               For external-identity-mapped entities, the id must be a string conforming
               to the Identity Source's requirements.
               Must be unique within a namespace.
        :param str namespace: The namespace in which the entity exists.
               If not specified, the EntityKey represents a Google-managed entity
               such as a Google user or a Google Group.
               If specified, the EntityKey represents an external-identity-mapped group.
               The namespace must correspond to an identity source created in Admin Console
               and must be in the form of `identitysources/{identity_source_id}`.
        """
        pulumi.set(__self__, "id", id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the entity.
        For Google-managed entities, the id must be the email address of an existing
        group or user.
        For external-identity-mapped entities, the id must be a string conforming
        to the Identity Source's requirements.
        Must be unique within a namespace.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace in which the entity exists.
        If not specified, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If specified, the EntityKey represents an external-identity-mapped group.
        The namespace must correspond to an identity source created in Admin Console
        and must be in the form of `identitysources/{identity_source_id}`.
        """
        return pulumi.get(self, "namespace")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GroupMembershipRole(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: The name of the MembershipRole. Must be one of OWNER, MANAGER, MEMBER.
               Possible values are `OWNER`, `MANAGER`, and `MEMBER`.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the MembershipRole. Must be one of OWNER, MANAGER, MEMBER.
        Possible values are `OWNER`, `MANAGER`, and `MEMBER`.
        """
        return pulumi.get(self, "name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GetGroupMembershipsMembershipResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 group: str,
                 member_keys: List['outputs.GetGroupMembershipsMembershipMemberKeyResult'],
                 name: str,
                 preferred_member_keys: List['outputs.GetGroupMembershipsMembershipPreferredMemberKeyResult'],
                 roles: List['outputs.GetGroupMembershipsMembershipRoleResult'],
                 type: str,
                 update_time: str):
        """
        :param str group: The parent Group resource under which to lookup the Membership names. Must be of the form groups/{group_id}.
        :param str name: The name of the MembershipRole. One of OWNER, MANAGER, MEMBER.
        :param List['GetGroupMembershipsMembershipRoleArgs'] roles: The MembershipRoles that apply to the Membership. Structure is documented below.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "member_keys", member_keys)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "preferred_member_keys", preferred_member_keys)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def group(self) -> str:
        """
        The parent Group resource under which to lookup the Membership names. Must be of the form groups/{group_id}.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="memberKeys")
    def member_keys(self) -> List['outputs.GetGroupMembershipsMembershipMemberKeyResult']:
        return pulumi.get(self, "member_keys")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the MembershipRole. One of OWNER, MANAGER, MEMBER.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="preferredMemberKeys")
    def preferred_member_keys(self) -> List['outputs.GetGroupMembershipsMembershipPreferredMemberKeyResult']:
        return pulumi.get(self, "preferred_member_keys")

    @property
    @pulumi.getter
    def roles(self) -> List['outputs.GetGroupMembershipsMembershipRoleResult']:
        """
        The MembershipRoles that apply to the Membership. Structure is documented below.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetGroupMembershipsMembershipMemberKeyResult(dict):
    def __init__(__self__, *,
                 id: str,
                 namespace: str):
        """
        :param str id: The ID of the entity. For Google-managed entities, the id is the email address of an existing
               group or user. For external-identity-mapped entities, the id is a string conforming
               to the Identity Source's requirements.
        :param str namespace: The namespace in which the entity exists.
               If not populated, the EntityKey represents a Google-managed entity
               such as a Google user or a Google Group.
               If populated, the EntityKey represents an external-identity-mapped group.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the entity. For Google-managed entities, the id is the email address of an existing
        group or user. For external-identity-mapped entities, the id is a string conforming
        to the Identity Source's requirements.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace in which the entity exists.
        If not populated, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If populated, the EntityKey represents an external-identity-mapped group.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetGroupMembershipsMembershipPreferredMemberKeyResult(dict):
    def __init__(__self__, *,
                 id: str,
                 namespace: str):
        """
        :param str id: The ID of the entity. For Google-managed entities, the id is the email address of an existing
               group or user. For external-identity-mapped entities, the id is a string conforming
               to the Identity Source's requirements.
        :param str namespace: The namespace in which the entity exists.
               If not populated, the EntityKey represents a Google-managed entity
               such as a Google user or a Google Group.
               If populated, the EntityKey represents an external-identity-mapped group.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the entity. For Google-managed entities, the id is the email address of an existing
        group or user. For external-identity-mapped entities, the id is a string conforming
        to the Identity Source's requirements.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace in which the entity exists.
        If not populated, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If populated, the EntityKey represents an external-identity-mapped group.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetGroupMembershipsMembershipRoleResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: The name of the MembershipRole. One of OWNER, MANAGER, MEMBER.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the MembershipRole. One of OWNER, MANAGER, MEMBER.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetGroupsGroupResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 description: str,
                 display_name: str,
                 group_keys: List['outputs.GetGroupsGroupGroupKeyResult'],
                 labels: Mapping[str, str],
                 name: str,
                 parent: str,
                 update_time: str):
        """
        :param str parent: The parent resource under which to list all Groups. Must be of the form identitysources/{identity_source_id} for external- identity-mapped groups or customers/{customer_id} for Google Groups.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "group_keys", group_keys)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="groupKeys")
    def group_keys(self) -> List['outputs.GetGroupsGroupGroupKeyResult']:
        return pulumi.get(self, "group_keys")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> str:
        """
        The parent resource under which to list all Groups. Must be of the form identitysources/{identity_source_id} for external- identity-mapped groups or customers/{customer_id} for Google Groups.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetGroupsGroupGroupKeyResult(dict):
    def __init__(__self__, *,
                 id: str,
                 namespace: str):
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")


