# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables

__all__ = [
    'QueueAppEngineRoutingOverride',
    'QueueRateLimits',
    'QueueRetryConfig',
]

@pulumi.output_type
class QueueAppEngineRoutingOverride(dict):
    def __init__(__self__, *,
                 host: Optional[str] = None,
                 instance: Optional[str] = None,
                 service: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str host: -
               The host that the task is sent to.
        :param str instance: App instance.
               By default, the task is sent to an instance which is available when the task is attempted.
        :param str service: App service.
               By default, the task is sent to the service which is the default service when the task is attempted.
        :param str version: App version.
               By default, the task is sent to the version which is the default version when the task is attempted.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        -
        The host that the task is sent to.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def instance(self) -> Optional[str]:
        """
        App instance.
        By default, the task is sent to an instance which is available when the task is attempted.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter
    def service(self) -> Optional[str]:
        """
        App service.
        By default, the task is sent to the service which is the default service when the task is attempted.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        App version.
        By default, the task is sent to the version which is the default version when the task is attempted.
        """
        return pulumi.get(self, "version")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class QueueRateLimits(dict):
    def __init__(__self__, *,
                 max_burst_size: Optional[float] = None,
                 max_concurrent_dispatches: Optional[float] = None,
                 max_dispatches_per_second: Optional[float] = None):
        """
        :param float max_burst_size: -
               The max burst size.
               Max burst size limits how fast tasks in queue are processed when many tasks are
               in the queue and the rate is high. This field allows the queue to have a high
               rate so processing starts shortly after a task is enqueued, but still limits
               resource usage when many tasks are enqueued in a short period of time.
        :param float max_concurrent_dispatches: The maximum number of concurrent tasks that Cloud Tasks allows to
               be dispatched for this queue. After this threshold has been
               reached, Cloud Tasks stops dispatching tasks until the number of
               concurrent requests decreases.
        :param float max_dispatches_per_second: The maximum rate at which tasks are dispatched from this queue.
               If unspecified when the queue is created, Cloud Tasks will pick the default.
        """
        if max_burst_size is not None:
            pulumi.set(__self__, "max_burst_size", max_burst_size)
        if max_concurrent_dispatches is not None:
            pulumi.set(__self__, "max_concurrent_dispatches", max_concurrent_dispatches)
        if max_dispatches_per_second is not None:
            pulumi.set(__self__, "max_dispatches_per_second", max_dispatches_per_second)

    @property
    @pulumi.getter(name="maxBurstSize")
    def max_burst_size(self) -> Optional[float]:
        """
        -
        The max burst size.
        Max burst size limits how fast tasks in queue are processed when many tasks are
        in the queue and the rate is high. This field allows the queue to have a high
        rate so processing starts shortly after a task is enqueued, but still limits
        resource usage when many tasks are enqueued in a short period of time.
        """
        return pulumi.get(self, "max_burst_size")

    @property
    @pulumi.getter(name="maxConcurrentDispatches")
    def max_concurrent_dispatches(self) -> Optional[float]:
        """
        The maximum number of concurrent tasks that Cloud Tasks allows to
        be dispatched for this queue. After this threshold has been
        reached, Cloud Tasks stops dispatching tasks until the number of
        concurrent requests decreases.
        """
        return pulumi.get(self, "max_concurrent_dispatches")

    @property
    @pulumi.getter(name="maxDispatchesPerSecond")
    def max_dispatches_per_second(self) -> Optional[float]:
        """
        The maximum rate at which tasks are dispatched from this queue.
        If unspecified when the queue is created, Cloud Tasks will pick the default.
        """
        return pulumi.get(self, "max_dispatches_per_second")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class QueueRetryConfig(dict):
    def __init__(__self__, *,
                 max_attempts: Optional[float] = None,
                 max_backoff: Optional[str] = None,
                 max_doublings: Optional[float] = None,
                 max_retry_duration: Optional[str] = None,
                 min_backoff: Optional[str] = None):
        """
        :param float max_attempts: Number of attempts per task.
               Cloud Tasks will attempt the task maxAttempts times (that is, if
               the first attempt fails, then there will be maxAttempts - 1
               retries). Must be >= -1.
               If unspecified when the queue is created, Cloud Tasks will pick
               the default.
               -1 indicates unlimited attempts.
        :param str max_backoff: A task will be scheduled for retry between minBackoff and
               maxBackoff duration after it fails, if the queue's RetryConfig
               specifies that the task should be retried.
        :param float max_doublings: The time between retries will double maxDoublings times.
               A task's retry interval starts at minBackoff, then doubles maxDoublings times,
               then increases linearly, and finally retries retries at intervals of maxBackoff
               up to maxAttempts times.
        :param str max_retry_duration: If positive, maxRetryDuration specifies the time limit for
               retrying a failed task, measured from when the task was first
               attempted. Once maxRetryDuration time has passed and the task has
               been attempted maxAttempts times, no further attempts will be
               made and the task will be deleted.
               If zero, then the task age is unlimited.
        :param str min_backoff: A task will be scheduled for retry between minBackoff and
               maxBackoff duration after it fails, if the queue's RetryConfig
               specifies that the task should be retried.
        """
        if max_attempts is not None:
            pulumi.set(__self__, "max_attempts", max_attempts)
        if max_backoff is not None:
            pulumi.set(__self__, "max_backoff", max_backoff)
        if max_doublings is not None:
            pulumi.set(__self__, "max_doublings", max_doublings)
        if max_retry_duration is not None:
            pulumi.set(__self__, "max_retry_duration", max_retry_duration)
        if min_backoff is not None:
            pulumi.set(__self__, "min_backoff", min_backoff)

    @property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> Optional[float]:
        """
        Number of attempts per task.
        Cloud Tasks will attempt the task maxAttempts times (that is, if
        the first attempt fails, then there will be maxAttempts - 1
        retries). Must be >= -1.
        If unspecified when the queue is created, Cloud Tasks will pick
        the default.
        -1 indicates unlimited attempts.
        """
        return pulumi.get(self, "max_attempts")

    @property
    @pulumi.getter(name="maxBackoff")
    def max_backoff(self) -> Optional[str]:
        """
        A task will be scheduled for retry between minBackoff and
        maxBackoff duration after it fails, if the queue's RetryConfig
        specifies that the task should be retried.
        """
        return pulumi.get(self, "max_backoff")

    @property
    @pulumi.getter(name="maxDoublings")
    def max_doublings(self) -> Optional[float]:
        """
        The time between retries will double maxDoublings times.
        A task's retry interval starts at minBackoff, then doubles maxDoublings times,
        then increases linearly, and finally retries retries at intervals of maxBackoff
        up to maxAttempts times.
        """
        return pulumi.get(self, "max_doublings")

    @property
    @pulumi.getter(name="maxRetryDuration")
    def max_retry_duration(self) -> Optional[str]:
        """
        If positive, maxRetryDuration specifies the time limit for
        retrying a failed task, measured from when the task was first
        attempted. Once maxRetryDuration time has passed and the task has
        been attempted maxAttempts times, no further attempts will be
        made and the task will be deleted.
        If zero, then the task age is unlimited.
        """
        return pulumi.get(self, "max_retry_duration")

    @property
    @pulumi.getter(name="minBackoff")
    def min_backoff(self) -> Optional[str]:
        """
        A task will be scheduled for retry between minBackoff and
        maxBackoff duration after it fails, if the queue's RetryConfig
        specifies that the task should be retried.
        """
        return pulumi.get(self, "min_backoff")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


