# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables

__all__ = ['SSLPolicy']


class SSLPolicy(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_features: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 min_tls_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Represents a SSL policy. SSL policies give you the ability to control the
        features of SSL that your SSL proxy or HTTPS load balancer negotiates.

        To get more information about SslPolicy, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/sslPolicies)
        * How-to Guides
            * [Using SSL Policies](https://cloud.google.com/compute/docs/load-balancing/ssl-policies)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[List[pulumi.Input[str]]] custom_features: Profile specifies the set of SSL features that can be used by the
               load balancer when negotiating SSL with clients. This can be one of
               `COMPATIBLE`, `MODERN`, `RESTRICTED`, or `CUSTOM`. If using `CUSTOM`,
               the set of SSL features to enable must be specified in the
               `customFeatures` field.
               See the [official documentation](https://cloud.google.com/compute/docs/load-balancing/ssl-policies#profilefeaturesupport)
               for which ciphers are available to use. **Note**: this argument
               *must* be present when using the `CUSTOM` profile. This argument
               *must not* be present when using any other profile.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] min_tls_version: The minimum version of SSL protocol that can be used by the clients
               to establish a connection with the load balancer.
               Default value is `TLS_1_0`.
               Possible values are `TLS_1_0`, `TLS_1_1`, and `TLS_1_2`.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] profile: Profile specifies the set of SSL features that can be used by the
               load balancer when negotiating SSL with clients. If using `CUSTOM`,
               the set of SSL features to enable must be specified in the
               `customFeatures` field.
               See the [official documentation](https://cloud.google.com/compute/docs/load-balancing/ssl-policies#profilefeaturesupport)
               for information on what cipher suites each profile provides. If
               `CUSTOM` is used, the `custom_features` attribute **must be set**.
               Default value is `COMPATIBLE`.
               Possible values are `COMPATIBLE`, `MODERN`, `RESTRICTED`, and `CUSTOM`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['custom_features'] = custom_features
            __props__['description'] = description
            __props__['min_tls_version'] = min_tls_version
            __props__['name'] = name
            __props__['profile'] = profile
            __props__['project'] = project
            __props__['creation_timestamp'] = None
            __props__['enabled_features'] = None
            __props__['fingerprint'] = None
            __props__['self_link'] = None
        super(SSLPolicy, __self__).__init__(
            'gcp:compute/sSLPolicy:SSLPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            custom_features: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled_features: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            fingerprint: Optional[pulumi.Input[str]] = None,
            min_tls_version: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            profile: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None) -> 'SSLPolicy':
        """
        Get an existing SSLPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[List[pulumi.Input[str]]] custom_features: Profile specifies the set of SSL features that can be used by the
               load balancer when negotiating SSL with clients. This can be one of
               `COMPATIBLE`, `MODERN`, `RESTRICTED`, or `CUSTOM`. If using `CUSTOM`,
               the set of SSL features to enable must be specified in the
               `customFeatures` field.
               See the [official documentation](https://cloud.google.com/compute/docs/load-balancing/ssl-policies#profilefeaturesupport)
               for which ciphers are available to use. **Note**: this argument
               *must* be present when using the `CUSTOM` profile. This argument
               *must not* be present when using any other profile.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[List[pulumi.Input[str]]] enabled_features: The list of features enabled in the SSL policy.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking.
        :param pulumi.Input[str] min_tls_version: The minimum version of SSL protocol that can be used by the clients
               to establish a connection with the load balancer.
               Default value is `TLS_1_0`.
               Possible values are `TLS_1_0`, `TLS_1_1`, and `TLS_1_2`.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] profile: Profile specifies the set of SSL features that can be used by the
               load balancer when negotiating SSL with clients. If using `CUSTOM`,
               the set of SSL features to enable must be specified in the
               `customFeatures` field.
               See the [official documentation](https://cloud.google.com/compute/docs/load-balancing/ssl-policies#profilefeaturesupport)
               for information on what cipher suites each profile provides. If
               `CUSTOM` is used, the `custom_features` attribute **must be set**.
               Default value is `COMPATIBLE`.
               Possible values are `COMPATIBLE`, `MODERN`, `RESTRICTED`, and `CUSTOM`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["creation_timestamp"] = creation_timestamp
        __props__["custom_features"] = custom_features
        __props__["description"] = description
        __props__["enabled_features"] = enabled_features
        __props__["fingerprint"] = fingerprint
        __props__["min_tls_version"] = min_tls_version
        __props__["name"] = name
        __props__["profile"] = profile
        __props__["project"] = project
        __props__["self_link"] = self_link
        return SSLPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="customFeatures")
    def custom_features(self) -> pulumi.Output[Optional[List[str]]]:
        """
        Profile specifies the set of SSL features that can be used by the
        load balancer when negotiating SSL with clients. This can be one of
        `COMPATIBLE`, `MODERN`, `RESTRICTED`, or `CUSTOM`. If using `CUSTOM`,
        the set of SSL features to enable must be specified in the
        `customFeatures` field.
        See the [official documentation](https://cloud.google.com/compute/docs/load-balancing/ssl-policies#profilefeaturesupport)
        for which ciphers are available to use. **Note**: this argument
        *must* be present when using the `CUSTOM` profile. This argument
        *must not* be present when using any other profile.
        """
        return pulumi.get(self, "custom_features")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enabledFeatures")
    def enabled_features(self) -> pulumi.Output[List[str]]:
        """
        The list of features enabled in the SSL policy.
        """
        return pulumi.get(self, "enabled_features")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> pulumi.Output[Optional[str]]:
        """
        The minimum version of SSL protocol that can be used by the clients
        to establish a connection with the load balancer.
        Default value is `TLS_1_0`.
        Possible values are `TLS_1_0`, `TLS_1_1`, and `TLS_1_2`.
        """
        return pulumi.get(self, "min_tls_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[str]]:
        """
        Profile specifies the set of SSL features that can be used by the
        load balancer when negotiating SSL with clients. If using `CUSTOM`,
        the set of SSL features to enable must be specified in the
        `customFeatures` field.
        See the [official documentation](https://cloud.google.com/compute/docs/load-balancing/ssl-policies#profilefeaturesupport)
        for information on what cipher suites each profile provides. If
        `CUSTOM` is used, the `custom_features` attribute **must be set**.
        Default value is `COMPATIBLE`.
        Possible values are `COMPATIBLE`, `MODERN`, `RESTRICTED`, and `CUSTOM`.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

