# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables

__all__ = [
    'AutoscalingPolicyBasicAlgorithmArgs',
    'AutoscalingPolicyBasicAlgorithmYarnConfigArgs',
    'AutoscalingPolicySecondaryWorkerConfigArgs',
    'AutoscalingPolicyWorkerConfigArgs',
    'ClusterClusterConfigArgs',
    'ClusterClusterConfigAutoscalingConfigArgs',
    'ClusterClusterConfigEncryptionConfigArgs',
    'ClusterClusterConfigEndpointConfigArgs',
    'ClusterClusterConfigGceClusterConfigArgs',
    'ClusterClusterConfigInitializationActionArgs',
    'ClusterClusterConfigLifecycleConfigArgs',
    'ClusterClusterConfigMasterConfigArgs',
    'ClusterClusterConfigMasterConfigAcceleratorArgs',
    'ClusterClusterConfigMasterConfigDiskConfigArgs',
    'ClusterClusterConfigPreemptibleWorkerConfigArgs',
    'ClusterClusterConfigPreemptibleWorkerConfigDiskConfigArgs',
    'ClusterClusterConfigSecurityConfigArgs',
    'ClusterClusterConfigSecurityConfigKerberosConfigArgs',
    'ClusterClusterConfigSoftwareConfigArgs',
    'ClusterClusterConfigWorkerConfigArgs',
    'ClusterClusterConfigWorkerConfigAcceleratorArgs',
    'ClusterClusterConfigWorkerConfigDiskConfigArgs',
    'ClusterIAMBindingConditionArgs',
    'ClusterIAMMemberConditionArgs',
    'JobHadoopConfigArgs',
    'JobHadoopConfigLoggingConfigArgs',
    'JobHiveConfigArgs',
    'JobIAMBindingConditionArgs',
    'JobIAMMemberConditionArgs',
    'JobPigConfigArgs',
    'JobPigConfigLoggingConfigArgs',
    'JobPlacementArgs',
    'JobPysparkConfigArgs',
    'JobPysparkConfigLoggingConfigArgs',
    'JobReferenceArgs',
    'JobSchedulingArgs',
    'JobSparkConfigArgs',
    'JobSparkConfigLoggingConfigArgs',
    'JobSparksqlConfigArgs',
    'JobSparksqlConfigLoggingConfigArgs',
    'JobStatusArgs',
]

@pulumi.input_type
class AutoscalingPolicyBasicAlgorithmArgs:
    def __init__(__self__, *,
                 yarn_config: pulumi.Input['AutoscalingPolicyBasicAlgorithmYarnConfigArgs'],
                 cooldown_period: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['AutoscalingPolicyBasicAlgorithmYarnConfigArgs'] yarn_config: YARN autoscaling configuration.
               Structure is documented below.
        :param pulumi.Input[str] cooldown_period: Duration between scaling events. A scaling period starts after the
               update operation from the previous event has completed.
               Bounds: [2m, 1d]. Default: 2m.
        """
        pulumi.set(__self__, "yarn_config", yarn_config)
        if cooldown_period is not None:
            pulumi.set(__self__, "cooldown_period", cooldown_period)

    @property
    @pulumi.getter(name="yarnConfig")
    def yarn_config(self) -> pulumi.Input['AutoscalingPolicyBasicAlgorithmYarnConfigArgs']:
        """
        YARN autoscaling configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "yarn_config")

    @yarn_config.setter
    def yarn_config(self, value: pulumi.Input['AutoscalingPolicyBasicAlgorithmYarnConfigArgs']):
        pulumi.set(self, "yarn_config", value)

    @property
    @pulumi.getter(name="cooldownPeriod")
    def cooldown_period(self) -> Optional[pulumi.Input[str]]:
        """
        Duration between scaling events. A scaling period starts after the
        update operation from the previous event has completed.
        Bounds: [2m, 1d]. Default: 2m.
        """
        return pulumi.get(self, "cooldown_period")

    @cooldown_period.setter
    def cooldown_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cooldown_period", value)


@pulumi.input_type
class AutoscalingPolicyBasicAlgorithmYarnConfigArgs:
    def __init__(__self__, *,
                 graceful_decommission_timeout: pulumi.Input[str],
                 scale_down_factor: pulumi.Input[float],
                 scale_up_factor: pulumi.Input[float],
                 scale_down_min_worker_fraction: Optional[pulumi.Input[float]] = None,
                 scale_up_min_worker_fraction: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] graceful_decommission_timeout: Timeout for YARN graceful decommissioning of Node Managers. Specifies the
               duration to wait for jobs to complete before forcefully removing workers
               (and potentially interrupting jobs). Only applicable to downscaling operations.
               Bounds: [0s, 1d].
        :param pulumi.Input[float] scale_down_factor: Fraction of average pending memory in the last cooldown period for which to
               remove workers. A scale-down factor of 1 will result in scaling down so that there
               is no available memory remaining after the update (more aggressive scaling).
               A scale-down factor of 0 disables removing workers, which can be beneficial for
               autoscaling a single job.
               Bounds: [0.0, 1.0].
        :param pulumi.Input[float] scale_up_factor: Fraction of average pending memory in the last cooldown period for which to
               add workers. A scale-up factor of 1.0 will result in scaling up so that there
               is no pending memory remaining after the update (more aggressive scaling).
               A scale-up factor closer to 0 will result in a smaller magnitude of scaling up
               (less aggressive scaling).
               Bounds: [0.0, 1.0].
        :param pulumi.Input[float] scale_down_min_worker_fraction: Minimum scale-down threshold as a fraction of total cluster size before scaling occurs.
               For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must
               recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0
               means the autoscaler will scale down on any recommended change.
               Bounds: [0.0, 1.0]. Default: 0.0.
        :param pulumi.Input[float] scale_up_min_worker_fraction: Minimum scale-up threshold as a fraction of total cluster size before scaling
               occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler
               must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of
               0 means the autoscaler will scale up on any recommended change.
               Bounds: [0.0, 1.0]. Default: 0.0.
        """
        pulumi.set(__self__, "graceful_decommission_timeout", graceful_decommission_timeout)
        pulumi.set(__self__, "scale_down_factor", scale_down_factor)
        pulumi.set(__self__, "scale_up_factor", scale_up_factor)
        if scale_down_min_worker_fraction is not None:
            pulumi.set(__self__, "scale_down_min_worker_fraction", scale_down_min_worker_fraction)
        if scale_up_min_worker_fraction is not None:
            pulumi.set(__self__, "scale_up_min_worker_fraction", scale_up_min_worker_fraction)

    @property
    @pulumi.getter(name="gracefulDecommissionTimeout")
    def graceful_decommission_timeout(self) -> pulumi.Input[str]:
        """
        Timeout for YARN graceful decommissioning of Node Managers. Specifies the
        duration to wait for jobs to complete before forcefully removing workers
        (and potentially interrupting jobs). Only applicable to downscaling operations.
        Bounds: [0s, 1d].
        """
        return pulumi.get(self, "graceful_decommission_timeout")

    @graceful_decommission_timeout.setter
    def graceful_decommission_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "graceful_decommission_timeout", value)

    @property
    @pulumi.getter(name="scaleDownFactor")
    def scale_down_factor(self) -> pulumi.Input[float]:
        """
        Fraction of average pending memory in the last cooldown period for which to
        remove workers. A scale-down factor of 1 will result in scaling down so that there
        is no available memory remaining after the update (more aggressive scaling).
        A scale-down factor of 0 disables removing workers, which can be beneficial for
        autoscaling a single job.
        Bounds: [0.0, 1.0].
        """
        return pulumi.get(self, "scale_down_factor")

    @scale_down_factor.setter
    def scale_down_factor(self, value: pulumi.Input[float]):
        pulumi.set(self, "scale_down_factor", value)

    @property
    @pulumi.getter(name="scaleUpFactor")
    def scale_up_factor(self) -> pulumi.Input[float]:
        """
        Fraction of average pending memory in the last cooldown period for which to
        add workers. A scale-up factor of 1.0 will result in scaling up so that there
        is no pending memory remaining after the update (more aggressive scaling).
        A scale-up factor closer to 0 will result in a smaller magnitude of scaling up
        (less aggressive scaling).
        Bounds: [0.0, 1.0].
        """
        return pulumi.get(self, "scale_up_factor")

    @scale_up_factor.setter
    def scale_up_factor(self, value: pulumi.Input[float]):
        pulumi.set(self, "scale_up_factor", value)

    @property
    @pulumi.getter(name="scaleDownMinWorkerFraction")
    def scale_down_min_worker_fraction(self) -> Optional[pulumi.Input[float]]:
        """
        Minimum scale-down threshold as a fraction of total cluster size before scaling occurs.
        For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must
        recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0
        means the autoscaler will scale down on any recommended change.
        Bounds: [0.0, 1.0]. Default: 0.0.
        """
        return pulumi.get(self, "scale_down_min_worker_fraction")

    @scale_down_min_worker_fraction.setter
    def scale_down_min_worker_fraction(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "scale_down_min_worker_fraction", value)

    @property
    @pulumi.getter(name="scaleUpMinWorkerFraction")
    def scale_up_min_worker_fraction(self) -> Optional[pulumi.Input[float]]:
        """
        Minimum scale-up threshold as a fraction of total cluster size before scaling
        occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler
        must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of
        0 means the autoscaler will scale up on any recommended change.
        Bounds: [0.0, 1.0]. Default: 0.0.
        """
        return pulumi.get(self, "scale_up_min_worker_fraction")

    @scale_up_min_worker_fraction.setter
    def scale_up_min_worker_fraction(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "scale_up_min_worker_fraction", value)


@pulumi.input_type
class AutoscalingPolicySecondaryWorkerConfigArgs:
    def __init__(__self__, *,
                 max_instances: Optional[pulumi.Input[float]] = None,
                 min_instances: Optional[pulumi.Input[float]] = None,
                 weight: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] max_instances: Maximum number of instances for this group. Note that by default, clusters will not use
               secondary workers. Required for secondary workers if the minimum secondary instances is set.
               Bounds: [minInstances, ). Defaults to 0.
        :param pulumi.Input[float] min_instances: Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
        :param pulumi.Input[float] weight: Weight for the instance group, which is used to determine the fraction of total workers
               in the cluster from this instance group. For example, if primary workers have weight 2,
               and secondary workers have weight 1, the cluster will have approximately 2 primary workers
               for each secondary worker.
               The cluster may not reach the specified balance if constrained by min/max bounds or other
               autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
               primary workers will be added. The cluster can also be out of balance when created.
               If weight is not set on any instance group, the cluster will default to equal weight for
               all groups: the cluster will attempt to maintain an equal number of workers in each group
               within the configured size bounds for each group. If weight is set for one group only,
               the cluster will default to zero weight on the unset group. For example if weight is set
               only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[float]]:
        """
        Maximum number of instances for this group. Note that by default, clusters will not use
        secondary workers. Required for secondary workers if the minimum secondary instances is set.
        Bounds: [minInstances, ). Defaults to 0.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_instances", value)

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[float]]:
        """
        Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "min_instances", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[float]]:
        """
        Weight for the instance group, which is used to determine the fraction of total workers
        in the cluster from this instance group. For example, if primary workers have weight 2,
        and secondary workers have weight 1, the cluster will have approximately 2 primary workers
        for each secondary worker.
        The cluster may not reach the specified balance if constrained by min/max bounds or other
        autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
        primary workers will be added. The cluster can also be out of balance when created.
        If weight is not set on any instance group, the cluster will default to equal weight for
        all groups: the cluster will attempt to maintain an equal number of workers in each group
        within the configured size bounds for each group. If weight is set for one group only,
        the cluster will default to zero weight on the unset group. For example if weight is set
        only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class AutoscalingPolicyWorkerConfigArgs:
    def __init__(__self__, *,
                 max_instances: pulumi.Input[float],
                 min_instances: Optional[pulumi.Input[float]] = None,
                 weight: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] max_instances: Maximum number of instances for this group. Note that by default, clusters will not use
               secondary workers. Required for secondary workers if the minimum secondary instances is set.
               Bounds: [minInstances, ). Defaults to 0.
        :param pulumi.Input[float] min_instances: Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
        :param pulumi.Input[float] weight: Weight for the instance group, which is used to determine the fraction of total workers
               in the cluster from this instance group. For example, if primary workers have weight 2,
               and secondary workers have weight 1, the cluster will have approximately 2 primary workers
               for each secondary worker.
               The cluster may not reach the specified balance if constrained by min/max bounds or other
               autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
               primary workers will be added. The cluster can also be out of balance when created.
               If weight is not set on any instance group, the cluster will default to equal weight for
               all groups: the cluster will attempt to maintain an equal number of workers in each group
               within the configured size bounds for each group. If weight is set for one group only,
               the cluster will default to zero weight on the unset group. For example if weight is set
               only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> pulumi.Input[float]:
        """
        Maximum number of instances for this group. Note that by default, clusters will not use
        secondary workers. Required for secondary workers if the minimum secondary instances is set.
        Bounds: [minInstances, ). Defaults to 0.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: pulumi.Input[float]):
        pulumi.set(self, "max_instances", value)

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[float]]:
        """
        Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "min_instances", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[float]]:
        """
        Weight for the instance group, which is used to determine the fraction of total workers
        in the cluster from this instance group. For example, if primary workers have weight 2,
        and secondary workers have weight 1, the cluster will have approximately 2 primary workers
        for each secondary worker.
        The cluster may not reach the specified balance if constrained by min/max bounds or other
        autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
        primary workers will be added. The cluster can also be out of balance when created.
        If weight is not set on any instance group, the cluster will default to equal weight for
        all groups: the cluster will attempt to maintain an equal number of workers in each group
        within the configured size bounds for each group. If weight is set for one group only,
        the cluster will default to zero weight on the unset group. For example if weight is set
        only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class ClusterClusterConfigArgs:
    def __init__(__self__, *,
                 autoscaling_config: Optional[pulumi.Input['ClusterClusterConfigAutoscalingConfigArgs']] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 encryption_config: Optional[pulumi.Input['ClusterClusterConfigEncryptionConfigArgs']] = None,
                 endpoint_config: Optional[pulumi.Input['ClusterClusterConfigEndpointConfigArgs']] = None,
                 gce_cluster_config: Optional[pulumi.Input['ClusterClusterConfigGceClusterConfigArgs']] = None,
                 initialization_actions: Optional[pulumi.Input[List[pulumi.Input['ClusterClusterConfigInitializationActionArgs']]]] = None,
                 lifecycle_config: Optional[pulumi.Input['ClusterClusterConfigLifecycleConfigArgs']] = None,
                 master_config: Optional[pulumi.Input['ClusterClusterConfigMasterConfigArgs']] = None,
                 preemptible_worker_config: Optional[pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigArgs']] = None,
                 security_config: Optional[pulumi.Input['ClusterClusterConfigSecurityConfigArgs']] = None,
                 software_config: Optional[pulumi.Input['ClusterClusterConfigSoftwareConfigArgs']] = None,
                 staging_bucket: Optional[pulumi.Input[str]] = None,
                 worker_config: Optional[pulumi.Input['ClusterClusterConfigWorkerConfigArgs']] = None):
        """
        :param pulumi.Input['ClusterClusterConfigAutoscalingConfigArgs'] autoscaling_config: The autoscaling policy config associated with the cluster.
               Note that once set, if `autoscaling_config` is the only field set in `cluster_config`, it can
               only be removed by setting `policy_uri = ""`, rather than removing the whole block.
               Structure defined below.
        :param pulumi.Input['ClusterClusterConfigEncryptionConfigArgs'] encryption_config: The Customer managed encryption keys settings for the cluster.
               Structure defined below.
        :param pulumi.Input['ClusterClusterConfigEndpointConfigArgs'] endpoint_config: The config settings for port access on the cluster.
               Structure defined below.
               - - -
        :param pulumi.Input['ClusterClusterConfigGceClusterConfigArgs'] gce_cluster_config: Common config settings for resources of Google Compute Engine cluster
               instances, applicable to all instances in the cluster. Structure defined below.
        :param pulumi.Input[List[pulumi.Input['ClusterClusterConfigInitializationActionArgs']]] initialization_actions: Commands to execute on each node after config is completed.
               You can specify multiple versions of these. Structure defined below.
        :param pulumi.Input['ClusterClusterConfigLifecycleConfigArgs'] lifecycle_config: The settings for auto deletion cluster schedule.
               Structure defined below.
        :param pulumi.Input['ClusterClusterConfigMasterConfigArgs'] master_config: The Google Compute Engine config settings for the master instances
               in a cluster.. Structure defined below.
        :param pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigArgs'] preemptible_worker_config: The Google Compute Engine config settings for the additional (aka
               preemptible) instances in a cluster. Structure defined below.
        :param pulumi.Input['ClusterClusterConfigSecurityConfigArgs'] security_config: Security related configuration. Structure defined below.
        :param pulumi.Input['ClusterClusterConfigSoftwareConfigArgs'] software_config: The config settings for software inside the cluster.
               Structure defined below.
        :param pulumi.Input[str] staging_bucket: The Cloud Storage staging bucket used to stage files,
               such as Hadoop jars, between client machines and the cluster.
               Note: If you don't explicitly specify a `staging_bucket`
               then GCP will auto create / assign one for you. However, you are not guaranteed
               an auto generated bucket which is solely dedicated to your cluster; it may be shared
               with other clusters in the same region/zone also choosing to use the auto generation
               option.
        :param pulumi.Input['ClusterClusterConfigWorkerConfigArgs'] worker_config: The Google Compute Engine config settings for the worker instances
               in a cluster.. Structure defined below.
        """
        if autoscaling_config is not None:
            pulumi.set(__self__, "autoscaling_config", autoscaling_config)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if endpoint_config is not None:
            pulumi.set(__self__, "endpoint_config", endpoint_config)
        if gce_cluster_config is not None:
            pulumi.set(__self__, "gce_cluster_config", gce_cluster_config)
        if initialization_actions is not None:
            pulumi.set(__self__, "initialization_actions", initialization_actions)
        if lifecycle_config is not None:
            pulumi.set(__self__, "lifecycle_config", lifecycle_config)
        if master_config is not None:
            pulumi.set(__self__, "master_config", master_config)
        if preemptible_worker_config is not None:
            pulumi.set(__self__, "preemptible_worker_config", preemptible_worker_config)
        if security_config is not None:
            pulumi.set(__self__, "security_config", security_config)
        if software_config is not None:
            pulumi.set(__self__, "software_config", software_config)
        if staging_bucket is not None:
            pulumi.set(__self__, "staging_bucket", staging_bucket)
        if worker_config is not None:
            pulumi.set(__self__, "worker_config", worker_config)

    @property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> Optional[pulumi.Input['ClusterClusterConfigAutoscalingConfigArgs']]:
        """
        The autoscaling policy config associated with the cluster.
        Note that once set, if `autoscaling_config` is the only field set in `cluster_config`, it can
        only be removed by setting `policy_uri = ""`, rather than removing the whole block.
        Structure defined below.
        """
        return pulumi.get(self, "autoscaling_config")

    @autoscaling_config.setter
    def autoscaling_config(self, value: Optional[pulumi.Input['ClusterClusterConfigAutoscalingConfigArgs']]):
        pulumi.set(self, "autoscaling_config", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['ClusterClusterConfigEncryptionConfigArgs']]:
        """
        The Customer managed encryption keys settings for the cluster.
        Structure defined below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['ClusterClusterConfigEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Optional[pulumi.Input['ClusterClusterConfigEndpointConfigArgs']]:
        """
        The config settings for port access on the cluster.
        Structure defined below.
        - - -
        """
        return pulumi.get(self, "endpoint_config")

    @endpoint_config.setter
    def endpoint_config(self, value: Optional[pulumi.Input['ClusterClusterConfigEndpointConfigArgs']]):
        pulumi.set(self, "endpoint_config", value)

    @property
    @pulumi.getter(name="gceClusterConfig")
    def gce_cluster_config(self) -> Optional[pulumi.Input['ClusterClusterConfigGceClusterConfigArgs']]:
        """
        Common config settings for resources of Google Compute Engine cluster
        instances, applicable to all instances in the cluster. Structure defined below.
        """
        return pulumi.get(self, "gce_cluster_config")

    @gce_cluster_config.setter
    def gce_cluster_config(self, value: Optional[pulumi.Input['ClusterClusterConfigGceClusterConfigArgs']]):
        pulumi.set(self, "gce_cluster_config", value)

    @property
    @pulumi.getter(name="initializationActions")
    def initialization_actions(self) -> Optional[pulumi.Input[List[pulumi.Input['ClusterClusterConfigInitializationActionArgs']]]]:
        """
        Commands to execute on each node after config is completed.
        You can specify multiple versions of these. Structure defined below.
        """
        return pulumi.get(self, "initialization_actions")

    @initialization_actions.setter
    def initialization_actions(self, value: Optional[pulumi.Input[List[pulumi.Input['ClusterClusterConfigInitializationActionArgs']]]]):
        pulumi.set(self, "initialization_actions", value)

    @property
    @pulumi.getter(name="lifecycleConfig")
    def lifecycle_config(self) -> Optional[pulumi.Input['ClusterClusterConfigLifecycleConfigArgs']]:
        """
        The settings for auto deletion cluster schedule.
        Structure defined below.
        """
        return pulumi.get(self, "lifecycle_config")

    @lifecycle_config.setter
    def lifecycle_config(self, value: Optional[pulumi.Input['ClusterClusterConfigLifecycleConfigArgs']]):
        pulumi.set(self, "lifecycle_config", value)

    @property
    @pulumi.getter(name="masterConfig")
    def master_config(self) -> Optional[pulumi.Input['ClusterClusterConfigMasterConfigArgs']]:
        """
        The Google Compute Engine config settings for the master instances
        in a cluster.. Structure defined below.
        """
        return pulumi.get(self, "master_config")

    @master_config.setter
    def master_config(self, value: Optional[pulumi.Input['ClusterClusterConfigMasterConfigArgs']]):
        pulumi.set(self, "master_config", value)

    @property
    @pulumi.getter(name="preemptibleWorkerConfig")
    def preemptible_worker_config(self) -> Optional[pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigArgs']]:
        """
        The Google Compute Engine config settings for the additional (aka
        preemptible) instances in a cluster. Structure defined below.
        """
        return pulumi.get(self, "preemptible_worker_config")

    @preemptible_worker_config.setter
    def preemptible_worker_config(self, value: Optional[pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigArgs']]):
        pulumi.set(self, "preemptible_worker_config", value)

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> Optional[pulumi.Input['ClusterClusterConfigSecurityConfigArgs']]:
        """
        Security related configuration. Structure defined below.
        """
        return pulumi.get(self, "security_config")

    @security_config.setter
    def security_config(self, value: Optional[pulumi.Input['ClusterClusterConfigSecurityConfigArgs']]):
        pulumi.set(self, "security_config", value)

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> Optional[pulumi.Input['ClusterClusterConfigSoftwareConfigArgs']]:
        """
        The config settings for software inside the cluster.
        Structure defined below.
        """
        return pulumi.get(self, "software_config")

    @software_config.setter
    def software_config(self, value: Optional[pulumi.Input['ClusterClusterConfigSoftwareConfigArgs']]):
        pulumi.set(self, "software_config", value)

    @property
    @pulumi.getter(name="stagingBucket")
    def staging_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage staging bucket used to stage files,
        such as Hadoop jars, between client machines and the cluster.
        Note: If you don't explicitly specify a `staging_bucket`
        then GCP will auto create / assign one for you. However, you are not guaranteed
        an auto generated bucket which is solely dedicated to your cluster; it may be shared
        with other clusters in the same region/zone also choosing to use the auto generation
        option.
        """
        return pulumi.get(self, "staging_bucket")

    @staging_bucket.setter
    def staging_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "staging_bucket", value)

    @property
    @pulumi.getter(name="workerConfig")
    def worker_config(self) -> Optional[pulumi.Input['ClusterClusterConfigWorkerConfigArgs']]:
        """
        The Google Compute Engine config settings for the worker instances
        in a cluster.. Structure defined below.
        """
        return pulumi.get(self, "worker_config")

    @worker_config.setter
    def worker_config(self, value: Optional[pulumi.Input['ClusterClusterConfigWorkerConfigArgs']]):
        pulumi.set(self, "worker_config", value)


@pulumi.input_type
class ClusterClusterConfigAutoscalingConfigArgs:
    def __init__(__self__, *,
                 policy_uri: pulumi.Input[str]):
        """
        :param pulumi.Input[str] policy_uri: The autoscaling policy used by the cluster.
        """
        pulumi.set(__self__, "policy_uri", policy_uri)

    @property
    @pulumi.getter(name="policyUri")
    def policy_uri(self) -> pulumi.Input[str]:
        """
        The autoscaling policy used by the cluster.
        """
        return pulumi.get(self, "policy_uri")

    @policy_uri.setter
    def policy_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_uri", value)


@pulumi.input_type
class ClusterClusterConfigEncryptionConfigArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] kms_key_name: The Cloud KMS key name to use for PD disk encryption for
               all instances in the cluster.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[str]:
        """
        The Cloud KMS key name to use for PD disk encryption for
        all instances in the cluster.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class ClusterClusterConfigEndpointConfigArgs:
    def __init__(__self__, *,
                 enable_http_port_access: pulumi.Input[bool],
                 http_ports: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[bool] enable_http_port_access: The flag to enable http access to specific ports
               on the cluster from external sources (aka Component Gateway). Defaults to false.
        """
        pulumi.set(__self__, "enable_http_port_access", enable_http_port_access)
        if http_ports is not None:
            pulumi.set(__self__, "http_ports", http_ports)

    @property
    @pulumi.getter(name="enableHttpPortAccess")
    def enable_http_port_access(self) -> pulumi.Input[bool]:
        """
        The flag to enable http access to specific ports
        on the cluster from external sources (aka Component Gateway). Defaults to false.
        """
        return pulumi.get(self, "enable_http_port_access")

    @enable_http_port_access.setter
    def enable_http_port_access(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_http_port_access", value)

    @property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        return pulumi.get(self, "http_ports")

    @http_ports.setter
    def http_ports(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "http_ports", value)


@pulumi.input_type
class ClusterClusterConfigGceClusterConfigArgs:
    def __init__(__self__, *,
                 internal_ip_only: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 service_account_scopes: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] internal_ip_only: By default, clusters are not restricted to internal IP addresses, 
               and will have ephemeral external IP addresses assigned to each instance. If set to true, all
               instances in the cluster will only have internal IP addresses. Note: Private Google Access
               (also known as `privateIpGoogleAccess`) must be enabled on the subnetwork that the cluster
               will be launched in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: A map of the Compute Engine metadata entries to add to all instances
               (see [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        :param pulumi.Input[str] network: The name or self_link of the Google Compute Engine
               network to the cluster will be part of. Conflicts with `subnetwork`.
               If neither is specified, this defaults to the "default" network.
        :param pulumi.Input[str] service_account: The service account to be used by the Node VMs.
               If not specified, the "default" service account is used.
        :param pulumi.Input[List[pulumi.Input[str]]] service_account_scopes: The set of Google API scopes
               to be made available on all of the node VMs under the `service_account`
               specified. These can be	either FQDNs, or scope aliases. The following scopes
               must be set if any other scopes are set. They're necessary to ensure the
               correct functioning ofthe cluster, and are set automatically by the API:
        :param pulumi.Input[str] subnetwork: The name or self_link of the Google Compute Engine
               subnetwork the cluster will be part of. Conflicts with `network`.
        :param pulumi.Input[List[pulumi.Input[str]]] tags: The list of instance tags applied to instances in the cluster.
               Tags are used to identify valid sources or targets for network firewalls.
        :param pulumi.Input[str] zone: The GCP zone where your data is stored and used (i.e. where
               the master and the worker nodes will be created in). If `region` is set to 'global' (default)
               then `zone` is mandatory, otherwise GCP is able to make use of [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/auto-zone)
               to determine this automatically for you.
               Note: This setting additionally determines and restricts
               which computing resources are available for use with other configs such as
               `cluster_config.master_config.machine_type` and `cluster_config.worker_config.machine_type`.
        """
        if internal_ip_only is not None:
            pulumi.set(__self__, "internal_ip_only", internal_ip_only)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_account_scopes is not None:
            pulumi.set(__self__, "service_account_scopes", service_account_scopes)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="internalIpOnly")
    def internal_ip_only(self) -> Optional[pulumi.Input[bool]]:
        """
        By default, clusters are not restricted to internal IP addresses, 
        and will have ephemeral external IP addresses assigned to each instance. If set to true, all
        instances in the cluster will only have internal IP addresses. Note: Private Google Access
        (also known as `privateIpGoogleAccess`) must be enabled on the subnetwork that the cluster
        will be launched in.
        """
        return pulumi.get(self, "internal_ip_only")

    @internal_ip_only.setter
    def internal_ip_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "internal_ip_only", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of the Compute Engine metadata entries to add to all instances
        (see [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The name or self_link of the Google Compute Engine
        network to the cluster will be part of. Conflicts with `subnetwork`.
        If neither is specified, this defaults to the "default" network.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        The service account to be used by the Node VMs.
        If not specified, the "default" service account is used.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="serviceAccountScopes")
    def service_account_scopes(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        The set of Google API scopes
        to be made available on all of the node VMs under the `service_account`
        specified. These can be	either FQDNs, or scope aliases. The following scopes
        must be set if any other scopes are set. They're necessary to ensure the
        correct functioning ofthe cluster, and are set automatically by the API:
        """
        return pulumi.get(self, "service_account_scopes")

    @service_account_scopes.setter
    def service_account_scopes(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "service_account_scopes", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        The name or self_link of the Google Compute Engine
        subnetwork the cluster will be part of. Conflicts with `network`.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        The list of instance tags applied to instances in the cluster.
        Tags are used to identify valid sources or targets for network firewalls.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The GCP zone where your data is stored and used (i.e. where
        the master and the worker nodes will be created in). If `region` is set to 'global' (default)
        then `zone` is mandatory, otherwise GCP is able to make use of [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/auto-zone)
        to determine this automatically for you.
        Note: This setting additionally determines and restricts
        which computing resources are available for use with other configs such as
        `cluster_config.master_config.machine_type` and `cluster_config.worker_config.machine_type`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class ClusterClusterConfigInitializationActionArgs:
    def __init__(__self__, *,
                 script: pulumi.Input[str],
                 timeout_sec: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] script: The script to be executed during initialization of the cluster.
               The script must be a GCS file with a gs:// prefix.
        :param pulumi.Input[float] timeout_sec: The maximum duration (in seconds) which `script` is
               allowed to take to execute its action. GCP will default to a predetermined
               computed value if not set (currently 300).
        """
        pulumi.set(__self__, "script", script)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)

    @property
    @pulumi.getter
    def script(self) -> pulumi.Input[str]:
        """
        The script to be executed during initialization of the cluster.
        The script must be a GCS file with a gs:// prefix.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: pulumi.Input[str]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum duration (in seconds) which `script` is
        allowed to take to execute its action. GCP will default to a predetermined
        computed value if not set (currently 300).
        """
        return pulumi.get(self, "timeout_sec")

    @timeout_sec.setter
    def timeout_sec(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "timeout_sec", value)


@pulumi.input_type
class ClusterClusterConfigLifecycleConfigArgs:
    def __init__(__self__, *,
                 auto_delete_time: Optional[pulumi.Input[str]] = None,
                 idle_delete_ttl: Optional[pulumi.Input[str]] = None,
                 idle_start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] auto_delete_time: The time when cluster will be auto-deleted.
               A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
               Example: "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] idle_delete_ttl: The duration to keep the cluster alive while idling
               (no jobs running). After this TTL, the cluster will be deleted. Valid range: [10m, 14d].
        """
        if auto_delete_time is not None:
            pulumi.set(__self__, "auto_delete_time", auto_delete_time)
        if idle_delete_ttl is not None:
            pulumi.set(__self__, "idle_delete_ttl", idle_delete_ttl)
        if idle_start_time is not None:
            pulumi.set(__self__, "idle_start_time", idle_start_time)

    @property
    @pulumi.getter(name="autoDeleteTime")
    def auto_delete_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when cluster will be auto-deleted.
        A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "auto_delete_time")

    @auto_delete_time.setter
    def auto_delete_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_delete_time", value)

    @property
    @pulumi.getter(name="idleDeleteTtl")
    def idle_delete_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        The duration to keep the cluster alive while idling
        (no jobs running). After this TTL, the cluster will be deleted. Valid range: [10m, 14d].
        """
        return pulumi.get(self, "idle_delete_ttl")

    @idle_delete_ttl.setter
    def idle_delete_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_delete_ttl", value)

    @property
    @pulumi.getter(name="idleStartTime")
    def idle_start_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "idle_start_time")

    @idle_start_time.setter
    def idle_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_start_time", value)


@pulumi.input_type
class ClusterClusterConfigMasterConfigArgs:
    def __init__(__self__, *,
                 accelerators: Optional[pulumi.Input[List[pulumi.Input['ClusterClusterConfigMasterConfigAcceleratorArgs']]]] = None,
                 disk_config: Optional[pulumi.Input['ClusterClusterConfigMasterConfigDiskConfigArgs']] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 instance_names: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 num_instances: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[List[pulumi.Input['ClusterClusterConfigMasterConfigAcceleratorArgs']]] accelerators: The Compute Engine accelerator configuration for these instances. Can be specified multiple times.
        :param pulumi.Input['ClusterClusterConfigMasterConfigDiskConfigArgs'] disk_config: Disk Config
        :param pulumi.Input[str] image_uri: The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
               for more information.
        :param pulumi.Input[str] machine_type: The name of a Google Compute Engine machine type
               to create for the worker nodes. If not specified, GCP will default to a predetermined
               computed value (currently `n1-standard-4`).
        :param pulumi.Input[str] min_cpu_platform: The name of a minimum generation of CPU family
               for the master. If not specified, GCP will default to a predetermined computed value
               for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
               for details about which CPU families are available (and defaulted) for each zone.
        :param pulumi.Input[float] num_instances: Specifies the number of preemptible nodes to create.
               Defaults to 0.
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input[List[pulumi.Input['ClusterClusterConfigMasterConfigAcceleratorArgs']]]]:
        """
        The Compute Engine accelerator configuration for these instances. Can be specified multiple times.
        """
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input[List[pulumi.Input['ClusterClusterConfigMasterConfigAcceleratorArgs']]]]):
        pulumi.set(self, "accelerators", value)

    @property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional[pulumi.Input['ClusterClusterConfigMasterConfigDiskConfigArgs']]:
        """
        Disk Config
        """
        return pulumi.get(self, "disk_config")

    @disk_config.setter
    def disk_config(self, value: Optional[pulumi.Input['ClusterClusterConfigMasterConfigDiskConfigArgs']]):
        pulumi.set(self, "disk_config", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
        for more information.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        return pulumi.get(self, "instance_names")

    @instance_names.setter
    def instance_names(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_names", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a Google Compute Engine machine type
        to create for the worker nodes. If not specified, GCP will default to a predetermined
        computed value (currently `n1-standard-4`).
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a minimum generation of CPU family
        for the master. If not specified, GCP will default to a predetermined computed value
        for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        for details about which CPU families are available (and defaulted) for each zone.
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the number of preemptible nodes to create.
        Defaults to 0.
        """
        return pulumi.get(self, "num_instances")

    @num_instances.setter
    def num_instances(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "num_instances", value)


@pulumi.input_type
class ClusterClusterConfigMasterConfigAcceleratorArgs:
    def __init__(__self__, *,
                 accelerator_count: pulumi.Input[float],
                 accelerator_type: pulumi.Input[str]):
        """
        :param pulumi.Input[float] accelerator_count: The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.
        :param pulumi.Input[str] accelerator_type: The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        pulumi.set(__self__, "accelerator_count", accelerator_count)
        pulumi.set(__self__, "accelerator_type", accelerator_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> pulumi.Input[float]:
        """
        The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.
        """
        return pulumi.get(self, "accelerator_count")

    @accelerator_count.setter
    def accelerator_count(self, value: pulumi.Input[float]):
        pulumi.set(self, "accelerator_count", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> pulumi.Input[str]:
        """
        The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "accelerator_type", value)


@pulumi.input_type
class ClusterClusterConfigMasterConfigDiskConfigArgs:
    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[pulumi.Input[float]] = None,
                 boot_disk_type: Optional[pulumi.Input[str]] = None,
                 num_local_ssds: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] boot_disk_size_gb: Size of the primary disk attached to each preemptible worker node, specified
               in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
               computed value if not set (currently 500GB). Note: If SSDs are not
               attached, it also contains the HDFS data blocks and Hadoop working directories.
        :param pulumi.Input[str] boot_disk_type: The disk type of the primary disk attached to each preemptible worker node.
               One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        :param pulumi.Input[float] num_local_ssds: The amount of local SSD disks that will be
               attached to each preemptible worker node. Defaults to 0.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Size of the primary disk attached to each preemptible worker node, specified
        in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
        computed value if not set (currently 500GB). Note: If SSDs are not
        attached, it also contains the HDFS data blocks and Hadoop working directories.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @boot_disk_size_gb.setter
    def boot_disk_size_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "boot_disk_size_gb", value)

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The disk type of the primary disk attached to each preemptible worker node.
        One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        """
        return pulumi.get(self, "boot_disk_type")

    @boot_disk_type.setter
    def boot_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_disk_type", value)

    @property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of local SSD disks that will be
        attached to each preemptible worker node. Defaults to 0.
        """
        return pulumi.get(self, "num_local_ssds")

    @num_local_ssds.setter
    def num_local_ssds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "num_local_ssds", value)


@pulumi.input_type
class ClusterClusterConfigPreemptibleWorkerConfigArgs:
    def __init__(__self__, *,
                 disk_config: Optional[pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigDiskConfigArgs']] = None,
                 instance_names: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 num_instances: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigDiskConfigArgs'] disk_config: Disk Config
        :param pulumi.Input[float] num_instances: Specifies the number of preemptible nodes to create.
               Defaults to 0.
        """
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)

    @property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional[pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigDiskConfigArgs']]:
        """
        Disk Config
        """
        return pulumi.get(self, "disk_config")

    @disk_config.setter
    def disk_config(self, value: Optional[pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigDiskConfigArgs']]):
        pulumi.set(self, "disk_config", value)

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        return pulumi.get(self, "instance_names")

    @instance_names.setter
    def instance_names(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_names", value)

    @property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the number of preemptible nodes to create.
        Defaults to 0.
        """
        return pulumi.get(self, "num_instances")

    @num_instances.setter
    def num_instances(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "num_instances", value)


@pulumi.input_type
class ClusterClusterConfigPreemptibleWorkerConfigDiskConfigArgs:
    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[pulumi.Input[float]] = None,
                 boot_disk_type: Optional[pulumi.Input[str]] = None,
                 num_local_ssds: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] boot_disk_size_gb: Size of the primary disk attached to each preemptible worker node, specified
               in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
               computed value if not set (currently 500GB). Note: If SSDs are not
               attached, it also contains the HDFS data blocks and Hadoop working directories.
        :param pulumi.Input[str] boot_disk_type: The disk type of the primary disk attached to each preemptible worker node.
               One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        :param pulumi.Input[float] num_local_ssds: The amount of local SSD disks that will be
               attached to each preemptible worker node. Defaults to 0.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Size of the primary disk attached to each preemptible worker node, specified
        in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
        computed value if not set (currently 500GB). Note: If SSDs are not
        attached, it also contains the HDFS data blocks and Hadoop working directories.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @boot_disk_size_gb.setter
    def boot_disk_size_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "boot_disk_size_gb", value)

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The disk type of the primary disk attached to each preemptible worker node.
        One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        """
        return pulumi.get(self, "boot_disk_type")

    @boot_disk_type.setter
    def boot_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_disk_type", value)

    @property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of local SSD disks that will be
        attached to each preemptible worker node. Defaults to 0.
        """
        return pulumi.get(self, "num_local_ssds")

    @num_local_ssds.setter
    def num_local_ssds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "num_local_ssds", value)


@pulumi.input_type
class ClusterClusterConfigSecurityConfigArgs:
    def __init__(__self__, *,
                 kerberos_config: pulumi.Input['ClusterClusterConfigSecurityConfigKerberosConfigArgs']):
        """
        :param pulumi.Input['ClusterClusterConfigSecurityConfigKerberosConfigArgs'] kerberos_config: Kerberos Configuration
        """
        pulumi.set(__self__, "kerberos_config", kerberos_config)

    @property
    @pulumi.getter(name="kerberosConfig")
    def kerberos_config(self) -> pulumi.Input['ClusterClusterConfigSecurityConfigKerberosConfigArgs']:
        """
        Kerberos Configuration
        """
        return pulumi.get(self, "kerberos_config")

    @kerberos_config.setter
    def kerberos_config(self, value: pulumi.Input['ClusterClusterConfigSecurityConfigKerberosConfigArgs']):
        pulumi.set(self, "kerberos_config", value)


@pulumi.input_type
class ClusterClusterConfigSecurityConfigKerberosConfigArgs:
    def __init__(__self__, *,
                 kms_key_uri: pulumi.Input[str],
                 root_principal_password_uri: pulumi.Input[str],
                 cross_realm_trust_admin_server: Optional[pulumi.Input[str]] = None,
                 cross_realm_trust_kdc: Optional[pulumi.Input[str]] = None,
                 cross_realm_trust_realm: Optional[pulumi.Input[str]] = None,
                 cross_realm_trust_shared_password_uri: Optional[pulumi.Input[str]] = None,
                 enable_kerberos: Optional[pulumi.Input[bool]] = None,
                 kdc_db_key_uri: Optional[pulumi.Input[str]] = None,
                 key_password_uri: Optional[pulumi.Input[str]] = None,
                 keystore_password_uri: Optional[pulumi.Input[str]] = None,
                 keystore_uri: Optional[pulumi.Input[str]] = None,
                 realm: Optional[pulumi.Input[str]] = None,
                 tgt_lifetime_hours: Optional[pulumi.Input[float]] = None,
                 truststore_password_uri: Optional[pulumi.Input[str]] = None,
                 truststore_uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key_uri: The URI of the KMS key used to encrypt various sensitive files.
        :param pulumi.Input[str] root_principal_password_uri: The Cloud Storage URI of a KMS encrypted file
               containing the root principal password.
        :param pulumi.Input[str] cross_realm_trust_admin_server: The admin server (IP or hostname) for the
               remote trusted realm in a cross realm trust relationship.
        :param pulumi.Input[str] cross_realm_trust_kdc: The KDC (IP or hostname) for the
               remote trusted realm in a cross realm trust relationship.
        :param pulumi.Input[str] cross_realm_trust_realm: The remote realm the Dataproc on-cluster KDC will
               trust, should the user enable cross realm trust.
        :param pulumi.Input[str] cross_realm_trust_shared_password_uri: The Cloud Storage URI of a KMS
               encrypted file containing the shared password between the on-cluster Kerberos realm
               and the remote trusted realm, in a cross realm trust relationship.
        :param pulumi.Input[bool] enable_kerberos: Flag to indicate whether to Kerberize the cluster.
        :param pulumi.Input[str] kdc_db_key_uri: The Cloud Storage URI of a KMS encrypted file containing
               the master key of the KDC database.
        :param pulumi.Input[str] key_password_uri: The Cloud Storage URI of a KMS encrypted file containing
               the password to the user provided key. For the self-signed certificate, this password
               is generated by Dataproc.
        :param pulumi.Input[str] keystore_password_uri: The Cloud Storage URI of a KMS encrypted file containing
               the password to the user provided keystore. For the self-signed certificated, the password
               is generated by Dataproc.
        :param pulumi.Input[str] keystore_uri: The Cloud Storage URI of the keystore file used for SSL encryption.
               If not provided, Dataproc will provide a self-signed certificate.
        :param pulumi.Input[str] realm: The name of the on-cluster Kerberos realm. If not specified, the
               uppercased domain of hostnames will be the realm.
        :param pulumi.Input[float] tgt_lifetime_hours: The lifetime of the ticket granting ticket, in hours.
        :param pulumi.Input[str] truststore_password_uri: The Cloud Storage URI of a KMS encrypted file
               containing the password to the user provided truststore. For the self-signed
               certificate, this password is generated by Dataproc.
        :param pulumi.Input[str] truststore_uri: The Cloud Storage URI of the truststore file used for
               SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        pulumi.set(__self__, "kms_key_uri", kms_key_uri)
        pulumi.set(__self__, "root_principal_password_uri", root_principal_password_uri)
        if cross_realm_trust_admin_server is not None:
            pulumi.set(__self__, "cross_realm_trust_admin_server", cross_realm_trust_admin_server)
        if cross_realm_trust_kdc is not None:
            pulumi.set(__self__, "cross_realm_trust_kdc", cross_realm_trust_kdc)
        if cross_realm_trust_realm is not None:
            pulumi.set(__self__, "cross_realm_trust_realm", cross_realm_trust_realm)
        if cross_realm_trust_shared_password_uri is not None:
            pulumi.set(__self__, "cross_realm_trust_shared_password_uri", cross_realm_trust_shared_password_uri)
        if enable_kerberos is not None:
            pulumi.set(__self__, "enable_kerberos", enable_kerberos)
        if kdc_db_key_uri is not None:
            pulumi.set(__self__, "kdc_db_key_uri", kdc_db_key_uri)
        if key_password_uri is not None:
            pulumi.set(__self__, "key_password_uri", key_password_uri)
        if keystore_password_uri is not None:
            pulumi.set(__self__, "keystore_password_uri", keystore_password_uri)
        if keystore_uri is not None:
            pulumi.set(__self__, "keystore_uri", keystore_uri)
        if realm is not None:
            pulumi.set(__self__, "realm", realm)
        if tgt_lifetime_hours is not None:
            pulumi.set(__self__, "tgt_lifetime_hours", tgt_lifetime_hours)
        if truststore_password_uri is not None:
            pulumi.set(__self__, "truststore_password_uri", truststore_password_uri)
        if truststore_uri is not None:
            pulumi.set(__self__, "truststore_uri", truststore_uri)

    @property
    @pulumi.getter(name="kmsKeyUri")
    def kms_key_uri(self) -> pulumi.Input[str]:
        """
        The URI of the KMS key used to encrypt various sensitive files.
        """
        return pulumi.get(self, "kms_key_uri")

    @kms_key_uri.setter
    def kms_key_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_uri", value)

    @property
    @pulumi.getter(name="rootPrincipalPasswordUri")
    def root_principal_password_uri(self) -> pulumi.Input[str]:
        """
        The Cloud Storage URI of a KMS encrypted file
        containing the root principal password.
        """
        return pulumi.get(self, "root_principal_password_uri")

    @root_principal_password_uri.setter
    def root_principal_password_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "root_principal_password_uri", value)

    @property
    @pulumi.getter(name="crossRealmTrustAdminServer")
    def cross_realm_trust_admin_server(self) -> Optional[pulumi.Input[str]]:
        """
        The admin server (IP or hostname) for the
        remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_admin_server")

    @cross_realm_trust_admin_server.setter
    def cross_realm_trust_admin_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_admin_server", value)

    @property
    @pulumi.getter(name="crossRealmTrustKdc")
    def cross_realm_trust_kdc(self) -> Optional[pulumi.Input[str]]:
        """
        The KDC (IP or hostname) for the
        remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_kdc")

    @cross_realm_trust_kdc.setter
    def cross_realm_trust_kdc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_kdc", value)

    @property
    @pulumi.getter(name="crossRealmTrustRealm")
    def cross_realm_trust_realm(self) -> Optional[pulumi.Input[str]]:
        """
        The remote realm the Dataproc on-cluster KDC will
        trust, should the user enable cross realm trust.
        """
        return pulumi.get(self, "cross_realm_trust_realm")

    @cross_realm_trust_realm.setter
    def cross_realm_trust_realm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_realm", value)

    @property
    @pulumi.getter(name="crossRealmTrustSharedPasswordUri")
    def cross_realm_trust_shared_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage URI of a KMS
        encrypted file containing the shared password between the on-cluster Kerberos realm
        and the remote trusted realm, in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_shared_password_uri")

    @cross_realm_trust_shared_password_uri.setter
    def cross_realm_trust_shared_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_shared_password_uri", value)

    @property
    @pulumi.getter(name="enableKerberos")
    def enable_kerberos(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to indicate whether to Kerberize the cluster.
        """
        return pulumi.get(self, "enable_kerberos")

    @enable_kerberos.setter
    def enable_kerberos(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_kerberos", value)

    @property
    @pulumi.getter(name="kdcDbKeyUri")
    def kdc_db_key_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage URI of a KMS encrypted file containing
        the master key of the KDC database.
        """
        return pulumi.get(self, "kdc_db_key_uri")

    @kdc_db_key_uri.setter
    def kdc_db_key_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kdc_db_key_uri", value)

    @property
    @pulumi.getter(name="keyPasswordUri")
    def key_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage URI of a KMS encrypted file containing
        the password to the user provided key. For the self-signed certificate, this password
        is generated by Dataproc.
        """
        return pulumi.get(self, "key_password_uri")

    @key_password_uri.setter
    def key_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_password_uri", value)

    @property
    @pulumi.getter(name="keystorePasswordUri")
    def keystore_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage URI of a KMS encrypted file containing
        the password to the user provided keystore. For the self-signed certificated, the password
        is generated by Dataproc.
        """
        return pulumi.get(self, "keystore_password_uri")

    @keystore_password_uri.setter
    def keystore_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keystore_password_uri", value)

    @property
    @pulumi.getter(name="keystoreUri")
    def keystore_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage URI of the keystore file used for SSL encryption.
        If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "keystore_uri")

    @keystore_uri.setter
    def keystore_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keystore_uri", value)

    @property
    @pulumi.getter
    def realm(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the on-cluster Kerberos realm. If not specified, the
        uppercased domain of hostnames will be the realm.
        """
        return pulumi.get(self, "realm")

    @realm.setter
    def realm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "realm", value)

    @property
    @pulumi.getter(name="tgtLifetimeHours")
    def tgt_lifetime_hours(self) -> Optional[pulumi.Input[float]]:
        """
        The lifetime of the ticket granting ticket, in hours.
        """
        return pulumi.get(self, "tgt_lifetime_hours")

    @tgt_lifetime_hours.setter
    def tgt_lifetime_hours(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "tgt_lifetime_hours", value)

    @property
    @pulumi.getter(name="truststorePasswordUri")
    def truststore_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage URI of a KMS encrypted file
        containing the password to the user provided truststore. For the self-signed
        certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "truststore_password_uri")

    @truststore_password_uri.setter
    def truststore_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "truststore_password_uri", value)

    @property
    @pulumi.getter(name="truststoreUri")
    def truststore_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage URI of the truststore file used for
        SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "truststore_uri")

    @truststore_uri.setter
    def truststore_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "truststore_uri", value)


@pulumi.input_type
class ClusterClusterConfigSoftwareConfigArgs:
    def __init__(__self__, *,
                 image_version: Optional[pulumi.Input[str]] = None,
                 optional_components: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 override_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[str] image_version: The Cloud Dataproc image version to use
               for the cluster - this controls the sets of software versions
               installed onto the nodes when you create clusters. If not specified, defaults to the
               latest version. For a list of valid versions see
               [Cloud Dataproc versions](https://cloud.google.com/dataproc/docs/concepts/dataproc-versions)
        :param pulumi.Input[List[pulumi.Input[str]]] optional_components: The set of optional components to activate on the cluster. 
               Accepted values are:
               * ANACONDA
               * DRUID
               * HBASE
               * HIVE_WEBHCAT
               * JUPYTER
               * KERBEROS
               * PRESTO
               * RANGER
               * SOLR
               * ZEPPELIN
               * ZOOKEEPER
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] override_properties: A list of override and additional properties (key/value pairs)
               used to modify various aspects of the common configuration files used when creating
               a cluster. For a list of valid properties please see
               [Cluster properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties)
        """
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if optional_components is not None:
            pulumi.set(__self__, "optional_components", optional_components)
        if override_properties is not None:
            pulumi.set(__self__, "override_properties", override_properties)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Dataproc image version to use
        for the cluster - this controls the sets of software versions
        installed onto the nodes when you create clusters. If not specified, defaults to the
        latest version. For a list of valid versions see
        [Cloud Dataproc versions](https://cloud.google.com/dataproc/docs/concepts/dataproc-versions)
        """
        return pulumi.get(self, "image_version")

    @image_version.setter
    def image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_version", value)

    @property
    @pulumi.getter(name="optionalComponents")
    def optional_components(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        The set of optional components to activate on the cluster. 
        Accepted values are:
        * ANACONDA
        * DRUID
        * HBASE
        * HIVE_WEBHCAT
        * JUPYTER
        * KERBEROS
        * PRESTO
        * RANGER
        * SOLR
        * ZEPPELIN
        * ZOOKEEPER
        """
        return pulumi.get(self, "optional_components")

    @optional_components.setter
    def optional_components(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "optional_components", value)

    @property
    @pulumi.getter(name="overrideProperties")
    def override_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A list of override and additional properties (key/value pairs)
        used to modify various aspects of the common configuration files used when creating
        a cluster. For a list of valid properties please see
        [Cluster properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties)
        """
        return pulumi.get(self, "override_properties")

    @override_properties.setter
    def override_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "override_properties", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class ClusterClusterConfigWorkerConfigArgs:
    def __init__(__self__, *,
                 accelerators: Optional[pulumi.Input[List[pulumi.Input['ClusterClusterConfigWorkerConfigAcceleratorArgs']]]] = None,
                 disk_config: Optional[pulumi.Input['ClusterClusterConfigWorkerConfigDiskConfigArgs']] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 instance_names: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 num_instances: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[List[pulumi.Input['ClusterClusterConfigWorkerConfigAcceleratorArgs']]] accelerators: The Compute Engine accelerator configuration for these instances. Can be specified multiple times.
        :param pulumi.Input['ClusterClusterConfigWorkerConfigDiskConfigArgs'] disk_config: Disk Config
        :param pulumi.Input[str] image_uri: The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
               for more information.
        :param pulumi.Input[str] machine_type: The name of a Google Compute Engine machine type
               to create for the worker nodes. If not specified, GCP will default to a predetermined
               computed value (currently `n1-standard-4`).
        :param pulumi.Input[str] min_cpu_platform: The name of a minimum generation of CPU family
               for the master. If not specified, GCP will default to a predetermined computed value
               for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
               for details about which CPU families are available (and defaulted) for each zone.
        :param pulumi.Input[float] num_instances: Specifies the number of preemptible nodes to create.
               Defaults to 0.
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input[List[pulumi.Input['ClusterClusterConfigWorkerConfigAcceleratorArgs']]]]:
        """
        The Compute Engine accelerator configuration for these instances. Can be specified multiple times.
        """
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input[List[pulumi.Input['ClusterClusterConfigWorkerConfigAcceleratorArgs']]]]):
        pulumi.set(self, "accelerators", value)

    @property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional[pulumi.Input['ClusterClusterConfigWorkerConfigDiskConfigArgs']]:
        """
        Disk Config
        """
        return pulumi.get(self, "disk_config")

    @disk_config.setter
    def disk_config(self, value: Optional[pulumi.Input['ClusterClusterConfigWorkerConfigDiskConfigArgs']]):
        pulumi.set(self, "disk_config", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
        for more information.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        return pulumi.get(self, "instance_names")

    @instance_names.setter
    def instance_names(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_names", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a Google Compute Engine machine type
        to create for the worker nodes. If not specified, GCP will default to a predetermined
        computed value (currently `n1-standard-4`).
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a minimum generation of CPU family
        for the master. If not specified, GCP will default to a predetermined computed value
        for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        for details about which CPU families are available (and defaulted) for each zone.
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the number of preemptible nodes to create.
        Defaults to 0.
        """
        return pulumi.get(self, "num_instances")

    @num_instances.setter
    def num_instances(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "num_instances", value)


@pulumi.input_type
class ClusterClusterConfigWorkerConfigAcceleratorArgs:
    def __init__(__self__, *,
                 accelerator_count: pulumi.Input[float],
                 accelerator_type: pulumi.Input[str]):
        """
        :param pulumi.Input[float] accelerator_count: The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.
        :param pulumi.Input[str] accelerator_type: The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        pulumi.set(__self__, "accelerator_count", accelerator_count)
        pulumi.set(__self__, "accelerator_type", accelerator_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> pulumi.Input[float]:
        """
        The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.
        """
        return pulumi.get(self, "accelerator_count")

    @accelerator_count.setter
    def accelerator_count(self, value: pulumi.Input[float]):
        pulumi.set(self, "accelerator_count", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> pulumi.Input[str]:
        """
        The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "accelerator_type", value)


@pulumi.input_type
class ClusterClusterConfigWorkerConfigDiskConfigArgs:
    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[pulumi.Input[float]] = None,
                 boot_disk_type: Optional[pulumi.Input[str]] = None,
                 num_local_ssds: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] boot_disk_size_gb: Size of the primary disk attached to each preemptible worker node, specified
               in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
               computed value if not set (currently 500GB). Note: If SSDs are not
               attached, it also contains the HDFS data blocks and Hadoop working directories.
        :param pulumi.Input[str] boot_disk_type: The disk type of the primary disk attached to each preemptible worker node.
               One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        :param pulumi.Input[float] num_local_ssds: The amount of local SSD disks that will be
               attached to each preemptible worker node. Defaults to 0.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Size of the primary disk attached to each preemptible worker node, specified
        in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
        computed value if not set (currently 500GB). Note: If SSDs are not
        attached, it also contains the HDFS data blocks and Hadoop working directories.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @boot_disk_size_gb.setter
    def boot_disk_size_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "boot_disk_size_gb", value)

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The disk type of the primary disk attached to each preemptible worker node.
        One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        """
        return pulumi.get(self, "boot_disk_type")

    @boot_disk_type.setter
    def boot_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_disk_type", value)

    @property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of local SSD disks that will be
        attached to each preemptible worker node. Defaults to 0.
        """
        return pulumi.get(self, "num_local_ssds")

    @num_local_ssds.setter
    def num_local_ssds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "num_local_ssds", value)


@pulumi.input_type
class ClusterIAMBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ClusterIAMMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class JobHadoopConfigArgs:
    def __init__(__self__, *,
                 archive_uris: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 args: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 jar_file_uris: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['JobHadoopConfigLoggingConfigArgs']] = None,
                 main_class: Optional[pulumi.Input[str]] = None,
                 main_jar_file_uri: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[List[pulumi.Input[str]]] archive_uris: HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        :param pulumi.Input[List[pulumi.Input[str]]] args: The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param pulumi.Input[List[pulumi.Input[str]]] file_uris: HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        :param pulumi.Input[List[pulumi.Input[str]]] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input[str] main_class: The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`. Conflicts with `main_jar_file_uri`
        :param pulumi.Input[str] main_jar_file_uri: The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'. Conflicts with `main_class`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['JobHadoopConfigLoggingConfigArgs']]:
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['JobHadoopConfigLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`. Conflicts with `main_jar_file_uri`
        """
        return pulumi.get(self, "main_class")

    @main_class.setter
    def main_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_class", value)

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'. Conflicts with `main_class`
        """
        return pulumi.get(self, "main_jar_file_uri")

    @main_jar_file_uri.setter
    def main_jar_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_jar_file_uri", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class JobHadoopConfigLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class JobHiveConfigArgs:
    def __init__(__self__, *,
                 continue_on_failure: Optional[pulumi.Input[bool]] = None,
                 jar_file_uris: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 query_file_uri: Optional[pulumi.Input[str]] = None,
                 query_lists: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 script_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] continue_on_failure: Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        :param pulumi.Input[List[pulumi.Input[str]]] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        :param pulumi.Input[str] query_file_uri: The HCFS URI of the script that contains SQL queries.
               Conflicts with `query_list`
        :param pulumi.Input[List[pulumi.Input[str]]] query_lists: The list of SQL queries or statements to execute as part of the job.
               Conflicts with `query_file_uri`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] script_variables: Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        """
        return pulumi.get(self, "continue_on_failure")

    @continue_on_failure.setter
    def continue_on_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continue_on_failure", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the script that contains SQL queries.
        Conflicts with `query_list`
        """
        return pulumi.get(self, "query_file_uri")

    @query_file_uri.setter
    def query_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_file_uri", value)

    @property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        The list of SQL queries or statements to execute as part of the job.
        Conflicts with `query_file_uri`
        """
        return pulumi.get(self, "query_lists")

    @query_lists.setter
    def query_lists(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "query_lists", value)

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        return pulumi.get(self, "script_variables")

    @script_variables.setter
    def script_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "script_variables", value)


@pulumi.input_type
class JobIAMBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class JobIAMMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class JobPigConfigArgs:
    def __init__(__self__, *,
                 continue_on_failure: Optional[pulumi.Input[bool]] = None,
                 jar_file_uris: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['JobPigConfigLoggingConfigArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 query_file_uri: Optional[pulumi.Input[str]] = None,
                 query_lists: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 script_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] continue_on_failure: Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        :param pulumi.Input[List[pulumi.Input[str]]] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        :param pulumi.Input[str] query_file_uri: The HCFS URI of the script that contains SQL queries.
               Conflicts with `query_list`
        :param pulumi.Input[List[pulumi.Input[str]]] query_lists: The list of SQL queries or statements to execute as part of the job.
               Conflicts with `query_file_uri`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] script_variables: Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        """
        return pulumi.get(self, "continue_on_failure")

    @continue_on_failure.setter
    def continue_on_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continue_on_failure", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['JobPigConfigLoggingConfigArgs']]:
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['JobPigConfigLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the script that contains SQL queries.
        Conflicts with `query_list`
        """
        return pulumi.get(self, "query_file_uri")

    @query_file_uri.setter
    def query_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_file_uri", value)

    @property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        The list of SQL queries or statements to execute as part of the job.
        Conflicts with `query_file_uri`
        """
        return pulumi.get(self, "query_lists")

    @query_lists.setter
    def query_lists(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "query_lists", value)

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        return pulumi.get(self, "script_variables")

    @script_variables.setter
    def script_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "script_variables", value)


@pulumi.input_type
class JobPigConfigLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class JobPlacementArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[str],
                 cluster_uuid: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_uuid is not None:
            pulumi.set(__self__, "cluster_uuid", cluster_uuid)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cluster_uuid")

    @cluster_uuid.setter
    def cluster_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_uuid", value)


@pulumi.input_type
class JobPysparkConfigArgs:
    def __init__(__self__, *,
                 main_python_file_uri: pulumi.Input[str],
                 archive_uris: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 args: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 jar_file_uris: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['JobPysparkConfigLoggingConfigArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 python_file_uris: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] main_python_file_uri: The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        :param pulumi.Input[List[pulumi.Input[str]]] archive_uris: HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        :param pulumi.Input[List[pulumi.Input[str]]] args: The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param pulumi.Input[List[pulumi.Input[str]]] file_uris: HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        :param pulumi.Input[List[pulumi.Input[str]]] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        :param pulumi.Input[List[pulumi.Input[str]]] python_file_uris: HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        pulumi.set(__self__, "main_python_file_uri", main_python_file_uri)
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if python_file_uris is not None:
            pulumi.set(__self__, "python_file_uris", python_file_uris)

    @property
    @pulumi.getter(name="mainPythonFileUri")
    def main_python_file_uri(self) -> pulumi.Input[str]:
        """
        The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        """
        return pulumi.get(self, "main_python_file_uri")

    @main_python_file_uri.setter
    def main_python_file_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "main_python_file_uri", value)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['JobPysparkConfigLoggingConfigArgs']]:
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['JobPysparkConfigLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="pythonFileUris")
    def python_file_uris(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        return pulumi.get(self, "python_file_uris")

    @python_file_uris.setter
    def python_file_uris(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "python_file_uris", value)


@pulumi.input_type
class JobPysparkConfigLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class JobReferenceArgs:
    def __init__(__self__, *,
                 job_id: Optional[pulumi.Input[str]] = None):
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_id", value)


@pulumi.input_type
class JobSchedulingArgs:
    def __init__(__self__, *,
                 max_failures_per_hour: pulumi.Input[float]):
        pulumi.set(__self__, "max_failures_per_hour", max_failures_per_hour)

    @property
    @pulumi.getter(name="maxFailuresPerHour")
    def max_failures_per_hour(self) -> pulumi.Input[float]:
        return pulumi.get(self, "max_failures_per_hour")

    @max_failures_per_hour.setter
    def max_failures_per_hour(self, value: pulumi.Input[float]):
        pulumi.set(self, "max_failures_per_hour", value)


@pulumi.input_type
class JobSparkConfigArgs:
    def __init__(__self__, *,
                 archive_uris: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 args: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 jar_file_uris: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['JobSparkConfigLoggingConfigArgs']] = None,
                 main_class: Optional[pulumi.Input[str]] = None,
                 main_jar_file_uri: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[List[pulumi.Input[str]]] archive_uris: HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        :param pulumi.Input[List[pulumi.Input[str]]] args: The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param pulumi.Input[List[pulumi.Input[str]]] file_uris: HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        :param pulumi.Input[List[pulumi.Input[str]]] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input[str] main_class: The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`. Conflicts with `main_jar_file_uri`
        :param pulumi.Input[str] main_jar_file_uri: The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'. Conflicts with `main_class`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['JobSparkConfigLoggingConfigArgs']]:
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['JobSparkConfigLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`. Conflicts with `main_jar_file_uri`
        """
        return pulumi.get(self, "main_class")

    @main_class.setter
    def main_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_class", value)

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'. Conflicts with `main_class`
        """
        return pulumi.get(self, "main_jar_file_uri")

    @main_jar_file_uri.setter
    def main_jar_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_jar_file_uri", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class JobSparkConfigLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class JobSparksqlConfigArgs:
    def __init__(__self__, *,
                 jar_file_uris: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['JobSparksqlConfigLoggingConfigArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 query_file_uri: Optional[pulumi.Input[str]] = None,
                 query_lists: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 script_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[List[pulumi.Input[str]]] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        :param pulumi.Input[str] query_file_uri: The HCFS URI of the script that contains SQL queries.
               Conflicts with `query_list`
        :param pulumi.Input[List[pulumi.Input[str]]] query_lists: The list of SQL queries or statements to execute as part of the job.
               Conflicts with `query_file_uri`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] script_variables: Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['JobSparksqlConfigLoggingConfigArgs']]:
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['JobSparksqlConfigLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the script that contains SQL queries.
        Conflicts with `query_list`
        """
        return pulumi.get(self, "query_file_uri")

    @query_file_uri.setter
    def query_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_file_uri", value)

    @property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        The list of SQL queries or statements to execute as part of the job.
        Conflicts with `query_file_uri`
        """
        return pulumi.get(self, "query_lists")

    @query_lists.setter
    def query_lists(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "query_lists", value)

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        return pulumi.get(self, "script_variables")

    @script_variables.setter
    def script_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "script_variables", value)


@pulumi.input_type
class JobSparksqlConfigLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class JobStatusArgs:
    def __init__(__self__, *,
                 details: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 state_start_time: Optional[pulumi.Input[str]] = None,
                 substate: Optional[pulumi.Input[str]] = None):
        if details is not None:
            pulumi.set(__self__, "details", details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_start_time is not None:
            pulumi.set(__self__, "state_start_time", state_start_time)
        if substate is not None:
            pulumi.set(__self__, "substate", substate)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateStartTime")
    def state_start_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state_start_time")

    @state_start_time.setter
    def state_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_start_time", value)

    @property
    @pulumi.getter
    def substate(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "substate")

    @substate.setter
    def substate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "substate", value)


