# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs

__all__ = [
    'AutoscalingPolicyBasicAlgorithm',
    'AutoscalingPolicyBasicAlgorithmYarnConfig',
    'AutoscalingPolicySecondaryWorkerConfig',
    'AutoscalingPolicyWorkerConfig',
    'ClusterClusterConfig',
    'ClusterClusterConfigAutoscalingConfig',
    'ClusterClusterConfigEncryptionConfig',
    'ClusterClusterConfigEndpointConfig',
    'ClusterClusterConfigGceClusterConfig',
    'ClusterClusterConfigInitializationAction',
    'ClusterClusterConfigLifecycleConfig',
    'ClusterClusterConfigMasterConfig',
    'ClusterClusterConfigMasterConfigAccelerator',
    'ClusterClusterConfigMasterConfigDiskConfig',
    'ClusterClusterConfigPreemptibleWorkerConfig',
    'ClusterClusterConfigPreemptibleWorkerConfigDiskConfig',
    'ClusterClusterConfigSecurityConfig',
    'ClusterClusterConfigSecurityConfigKerberosConfig',
    'ClusterClusterConfigSoftwareConfig',
    'ClusterClusterConfigWorkerConfig',
    'ClusterClusterConfigWorkerConfigAccelerator',
    'ClusterClusterConfigWorkerConfigDiskConfig',
    'ClusterIAMBindingCondition',
    'ClusterIAMMemberCondition',
    'JobHadoopConfig',
    'JobHadoopConfigLoggingConfig',
    'JobHiveConfig',
    'JobIAMBindingCondition',
    'JobIAMMemberCondition',
    'JobPigConfig',
    'JobPigConfigLoggingConfig',
    'JobPlacement',
    'JobPysparkConfig',
    'JobPysparkConfigLoggingConfig',
    'JobReference',
    'JobScheduling',
    'JobSparkConfig',
    'JobSparkConfigLoggingConfig',
    'JobSparksqlConfig',
    'JobSparksqlConfigLoggingConfig',
    'JobStatus',
]

@pulumi.output_type
class AutoscalingPolicyBasicAlgorithm(dict):
    def __init__(__self__, *,
                 yarn_config: 'outputs.AutoscalingPolicyBasicAlgorithmYarnConfig',
                 cooldown_period: Optional[str] = None):
        """
        :param 'AutoscalingPolicyBasicAlgorithmYarnConfigArgs' yarn_config: YARN autoscaling configuration.
               Structure is documented below.
        :param str cooldown_period: Duration between scaling events. A scaling period starts after the
               update operation from the previous event has completed.
               Bounds: [2m, 1d]. Default: 2m.
        """
        pulumi.set(__self__, "yarn_config", yarn_config)
        if cooldown_period is not None:
            pulumi.set(__self__, "cooldown_period", cooldown_period)

    @property
    @pulumi.getter(name="yarnConfig")
    def yarn_config(self) -> 'outputs.AutoscalingPolicyBasicAlgorithmYarnConfig':
        """
        YARN autoscaling configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "yarn_config")

    @property
    @pulumi.getter(name="cooldownPeriod")
    def cooldown_period(self) -> Optional[str]:
        """
        Duration between scaling events. A scaling period starts after the
        update operation from the previous event has completed.
        Bounds: [2m, 1d]. Default: 2m.
        """
        return pulumi.get(self, "cooldown_period")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AutoscalingPolicyBasicAlgorithmYarnConfig(dict):
    def __init__(__self__, *,
                 graceful_decommission_timeout: str,
                 scale_down_factor: float,
                 scale_up_factor: float,
                 scale_down_min_worker_fraction: Optional[float] = None,
                 scale_up_min_worker_fraction: Optional[float] = None):
        """
        :param str graceful_decommission_timeout: Timeout for YARN graceful decommissioning of Node Managers. Specifies the
               duration to wait for jobs to complete before forcefully removing workers
               (and potentially interrupting jobs). Only applicable to downscaling operations.
               Bounds: [0s, 1d].
        :param float scale_down_factor: Fraction of average pending memory in the last cooldown period for which to
               remove workers. A scale-down factor of 1 will result in scaling down so that there
               is no available memory remaining after the update (more aggressive scaling).
               A scale-down factor of 0 disables removing workers, which can be beneficial for
               autoscaling a single job.
               Bounds: [0.0, 1.0].
        :param float scale_up_factor: Fraction of average pending memory in the last cooldown period for which to
               add workers. A scale-up factor of 1.0 will result in scaling up so that there
               is no pending memory remaining after the update (more aggressive scaling).
               A scale-up factor closer to 0 will result in a smaller magnitude of scaling up
               (less aggressive scaling).
               Bounds: [0.0, 1.0].
        :param float scale_down_min_worker_fraction: Minimum scale-down threshold as a fraction of total cluster size before scaling occurs.
               For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must
               recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0
               means the autoscaler will scale down on any recommended change.
               Bounds: [0.0, 1.0]. Default: 0.0.
        :param float scale_up_min_worker_fraction: Minimum scale-up threshold as a fraction of total cluster size before scaling
               occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler
               must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of
               0 means the autoscaler will scale up on any recommended change.
               Bounds: [0.0, 1.0]. Default: 0.0.
        """
        pulumi.set(__self__, "graceful_decommission_timeout", graceful_decommission_timeout)
        pulumi.set(__self__, "scale_down_factor", scale_down_factor)
        pulumi.set(__self__, "scale_up_factor", scale_up_factor)
        if scale_down_min_worker_fraction is not None:
            pulumi.set(__self__, "scale_down_min_worker_fraction", scale_down_min_worker_fraction)
        if scale_up_min_worker_fraction is not None:
            pulumi.set(__self__, "scale_up_min_worker_fraction", scale_up_min_worker_fraction)

    @property
    @pulumi.getter(name="gracefulDecommissionTimeout")
    def graceful_decommission_timeout(self) -> str:
        """
        Timeout for YARN graceful decommissioning of Node Managers. Specifies the
        duration to wait for jobs to complete before forcefully removing workers
        (and potentially interrupting jobs). Only applicable to downscaling operations.
        Bounds: [0s, 1d].
        """
        return pulumi.get(self, "graceful_decommission_timeout")

    @property
    @pulumi.getter(name="scaleDownFactor")
    def scale_down_factor(self) -> float:
        """
        Fraction of average pending memory in the last cooldown period for which to
        remove workers. A scale-down factor of 1 will result in scaling down so that there
        is no available memory remaining after the update (more aggressive scaling).
        A scale-down factor of 0 disables removing workers, which can be beneficial for
        autoscaling a single job.
        Bounds: [0.0, 1.0].
        """
        return pulumi.get(self, "scale_down_factor")

    @property
    @pulumi.getter(name="scaleUpFactor")
    def scale_up_factor(self) -> float:
        """
        Fraction of average pending memory in the last cooldown period for which to
        add workers. A scale-up factor of 1.0 will result in scaling up so that there
        is no pending memory remaining after the update (more aggressive scaling).
        A scale-up factor closer to 0 will result in a smaller magnitude of scaling up
        (less aggressive scaling).
        Bounds: [0.0, 1.0].
        """
        return pulumi.get(self, "scale_up_factor")

    @property
    @pulumi.getter(name="scaleDownMinWorkerFraction")
    def scale_down_min_worker_fraction(self) -> Optional[float]:
        """
        Minimum scale-down threshold as a fraction of total cluster size before scaling occurs.
        For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must
        recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0
        means the autoscaler will scale down on any recommended change.
        Bounds: [0.0, 1.0]. Default: 0.0.
        """
        return pulumi.get(self, "scale_down_min_worker_fraction")

    @property
    @pulumi.getter(name="scaleUpMinWorkerFraction")
    def scale_up_min_worker_fraction(self) -> Optional[float]:
        """
        Minimum scale-up threshold as a fraction of total cluster size before scaling
        occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler
        must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of
        0 means the autoscaler will scale up on any recommended change.
        Bounds: [0.0, 1.0]. Default: 0.0.
        """
        return pulumi.get(self, "scale_up_min_worker_fraction")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AutoscalingPolicySecondaryWorkerConfig(dict):
    def __init__(__self__, *,
                 max_instances: Optional[float] = None,
                 min_instances: Optional[float] = None,
                 weight: Optional[float] = None):
        """
        :param float max_instances: Maximum number of instances for this group. Note that by default, clusters will not use
               secondary workers. Required for secondary workers if the minimum secondary instances is set.
               Bounds: [minInstances, ). Defaults to 0.
        :param float min_instances: Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
        :param float weight: Weight for the instance group, which is used to determine the fraction of total workers
               in the cluster from this instance group. For example, if primary workers have weight 2,
               and secondary workers have weight 1, the cluster will have approximately 2 primary workers
               for each secondary worker.
               The cluster may not reach the specified balance if constrained by min/max bounds or other
               autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
               primary workers will be added. The cluster can also be out of balance when created.
               If weight is not set on any instance group, the cluster will default to equal weight for
               all groups: the cluster will attempt to maintain an equal number of workers in each group
               within the configured size bounds for each group. If weight is set for one group only,
               the cluster will default to zero weight on the unset group. For example if weight is set
               only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[float]:
        """
        Maximum number of instances for this group. Note that by default, clusters will not use
        secondary workers. Required for secondary workers if the minimum secondary instances is set.
        Bounds: [minInstances, ). Defaults to 0.
        """
        return pulumi.get(self, "max_instances")

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[float]:
        """
        Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
        """
        return pulumi.get(self, "min_instances")

    @property
    @pulumi.getter
    def weight(self) -> Optional[float]:
        """
        Weight for the instance group, which is used to determine the fraction of total workers
        in the cluster from this instance group. For example, if primary workers have weight 2,
        and secondary workers have weight 1, the cluster will have approximately 2 primary workers
        for each secondary worker.
        The cluster may not reach the specified balance if constrained by min/max bounds or other
        autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
        primary workers will be added. The cluster can also be out of balance when created.
        If weight is not set on any instance group, the cluster will default to equal weight for
        all groups: the cluster will attempt to maintain an equal number of workers in each group
        within the configured size bounds for each group. If weight is set for one group only,
        the cluster will default to zero weight on the unset group. For example if weight is set
        only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        return pulumi.get(self, "weight")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AutoscalingPolicyWorkerConfig(dict):
    def __init__(__self__, *,
                 max_instances: float,
                 min_instances: Optional[float] = None,
                 weight: Optional[float] = None):
        """
        :param float max_instances: Maximum number of instances for this group. Note that by default, clusters will not use
               secondary workers. Required for secondary workers if the minimum secondary instances is set.
               Bounds: [minInstances, ). Defaults to 0.
        :param float min_instances: Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
        :param float weight: Weight for the instance group, which is used to determine the fraction of total workers
               in the cluster from this instance group. For example, if primary workers have weight 2,
               and secondary workers have weight 1, the cluster will have approximately 2 primary workers
               for each secondary worker.
               The cluster may not reach the specified balance if constrained by min/max bounds or other
               autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
               primary workers will be added. The cluster can also be out of balance when created.
               If weight is not set on any instance group, the cluster will default to equal weight for
               all groups: the cluster will attempt to maintain an equal number of workers in each group
               within the configured size bounds for each group. If weight is set for one group only,
               the cluster will default to zero weight on the unset group. For example if weight is set
               only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> float:
        """
        Maximum number of instances for this group. Note that by default, clusters will not use
        secondary workers. Required for secondary workers if the minimum secondary instances is set.
        Bounds: [minInstances, ). Defaults to 0.
        """
        return pulumi.get(self, "max_instances")

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[float]:
        """
        Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
        """
        return pulumi.get(self, "min_instances")

    @property
    @pulumi.getter
    def weight(self) -> Optional[float]:
        """
        Weight for the instance group, which is used to determine the fraction of total workers
        in the cluster from this instance group. For example, if primary workers have weight 2,
        and secondary workers have weight 1, the cluster will have approximately 2 primary workers
        for each secondary worker.
        The cluster may not reach the specified balance if constrained by min/max bounds or other
        autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
        primary workers will be added. The cluster can also be out of balance when created.
        If weight is not set on any instance group, the cluster will default to equal weight for
        all groups: the cluster will attempt to maintain an equal number of workers in each group
        within the configured size bounds for each group. If weight is set for one group only,
        the cluster will default to zero weight on the unset group. For example if weight is set
        only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        return pulumi.get(self, "weight")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfig(dict):
    def __init__(__self__, *,
                 autoscaling_config: Optional['outputs.ClusterClusterConfigAutoscalingConfig'] = None,
                 bucket: Optional[str] = None,
                 encryption_config: Optional['outputs.ClusterClusterConfigEncryptionConfig'] = None,
                 endpoint_config: Optional['outputs.ClusterClusterConfigEndpointConfig'] = None,
                 gce_cluster_config: Optional['outputs.ClusterClusterConfigGceClusterConfig'] = None,
                 initialization_actions: Optional[List['outputs.ClusterClusterConfigInitializationAction']] = None,
                 lifecycle_config: Optional['outputs.ClusterClusterConfigLifecycleConfig'] = None,
                 master_config: Optional['outputs.ClusterClusterConfigMasterConfig'] = None,
                 preemptible_worker_config: Optional['outputs.ClusterClusterConfigPreemptibleWorkerConfig'] = None,
                 security_config: Optional['outputs.ClusterClusterConfigSecurityConfig'] = None,
                 software_config: Optional['outputs.ClusterClusterConfigSoftwareConfig'] = None,
                 staging_bucket: Optional[str] = None,
                 worker_config: Optional['outputs.ClusterClusterConfigWorkerConfig'] = None):
        """
        :param 'ClusterClusterConfigAutoscalingConfigArgs' autoscaling_config: The autoscaling policy config associated with the cluster.
               Note that once set, if `autoscaling_config` is the only field set in `cluster_config`, it can
               only be removed by setting `policy_uri = ""`, rather than removing the whole block.
               Structure defined below.
        :param 'ClusterClusterConfigEncryptionConfigArgs' encryption_config: The Customer managed encryption keys settings for the cluster.
               Structure defined below.
        :param 'ClusterClusterConfigEndpointConfigArgs' endpoint_config: The config settings for port access on the cluster.
               Structure defined below.
               - - -
        :param 'ClusterClusterConfigGceClusterConfigArgs' gce_cluster_config: Common config settings for resources of Google Compute Engine cluster
               instances, applicable to all instances in the cluster. Structure defined below.
        :param List['ClusterClusterConfigInitializationActionArgs'] initialization_actions: Commands to execute on each node after config is completed.
               You can specify multiple versions of these. Structure defined below.
        :param 'ClusterClusterConfigLifecycleConfigArgs' lifecycle_config: The settings for auto deletion cluster schedule.
               Structure defined below.
        :param 'ClusterClusterConfigMasterConfigArgs' master_config: The Google Compute Engine config settings for the master instances
               in a cluster.. Structure defined below.
        :param 'ClusterClusterConfigPreemptibleWorkerConfigArgs' preemptible_worker_config: The Google Compute Engine config settings for the additional (aka
               preemptible) instances in a cluster. Structure defined below.
        :param 'ClusterClusterConfigSecurityConfigArgs' security_config: Security related configuration. Structure defined below.
        :param 'ClusterClusterConfigSoftwareConfigArgs' software_config: The config settings for software inside the cluster.
               Structure defined below.
        :param str staging_bucket: The Cloud Storage staging bucket used to stage files,
               such as Hadoop jars, between client machines and the cluster.
               Note: If you don't explicitly specify a `staging_bucket`
               then GCP will auto create / assign one for you. However, you are not guaranteed
               an auto generated bucket which is solely dedicated to your cluster; it may be shared
               with other clusters in the same region/zone also choosing to use the auto generation
               option.
        :param 'ClusterClusterConfigWorkerConfigArgs' worker_config: The Google Compute Engine config settings for the worker instances
               in a cluster.. Structure defined below.
        """
        if autoscaling_config is not None:
            pulumi.set(__self__, "autoscaling_config", autoscaling_config)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if endpoint_config is not None:
            pulumi.set(__self__, "endpoint_config", endpoint_config)
        if gce_cluster_config is not None:
            pulumi.set(__self__, "gce_cluster_config", gce_cluster_config)
        if initialization_actions is not None:
            pulumi.set(__self__, "initialization_actions", initialization_actions)
        if lifecycle_config is not None:
            pulumi.set(__self__, "lifecycle_config", lifecycle_config)
        if master_config is not None:
            pulumi.set(__self__, "master_config", master_config)
        if preemptible_worker_config is not None:
            pulumi.set(__self__, "preemptible_worker_config", preemptible_worker_config)
        if security_config is not None:
            pulumi.set(__self__, "security_config", security_config)
        if software_config is not None:
            pulumi.set(__self__, "software_config", software_config)
        if staging_bucket is not None:
            pulumi.set(__self__, "staging_bucket", staging_bucket)
        if worker_config is not None:
            pulumi.set(__self__, "worker_config", worker_config)

    @property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> Optional['outputs.ClusterClusterConfigAutoscalingConfig']:
        """
        The autoscaling policy config associated with the cluster.
        Note that once set, if `autoscaling_config` is the only field set in `cluster_config`, it can
        only be removed by setting `policy_uri = ""`, rather than removing the whole block.
        Structure defined below.
        """
        return pulumi.get(self, "autoscaling_config")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional['outputs.ClusterClusterConfigEncryptionConfig']:
        """
        The Customer managed encryption keys settings for the cluster.
        Structure defined below.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Optional['outputs.ClusterClusterConfigEndpointConfig']:
        """
        The config settings for port access on the cluster.
        Structure defined below.
        - - -
        """
        return pulumi.get(self, "endpoint_config")

    @property
    @pulumi.getter(name="gceClusterConfig")
    def gce_cluster_config(self) -> Optional['outputs.ClusterClusterConfigGceClusterConfig']:
        """
        Common config settings for resources of Google Compute Engine cluster
        instances, applicable to all instances in the cluster. Structure defined below.
        """
        return pulumi.get(self, "gce_cluster_config")

    @property
    @pulumi.getter(name="initializationActions")
    def initialization_actions(self) -> Optional[List['outputs.ClusterClusterConfigInitializationAction']]:
        """
        Commands to execute on each node after config is completed.
        You can specify multiple versions of these. Structure defined below.
        """
        return pulumi.get(self, "initialization_actions")

    @property
    @pulumi.getter(name="lifecycleConfig")
    def lifecycle_config(self) -> Optional['outputs.ClusterClusterConfigLifecycleConfig']:
        """
        The settings for auto deletion cluster schedule.
        Structure defined below.
        """
        return pulumi.get(self, "lifecycle_config")

    @property
    @pulumi.getter(name="masterConfig")
    def master_config(self) -> Optional['outputs.ClusterClusterConfigMasterConfig']:
        """
        The Google Compute Engine config settings for the master instances
        in a cluster.. Structure defined below.
        """
        return pulumi.get(self, "master_config")

    @property
    @pulumi.getter(name="preemptibleWorkerConfig")
    def preemptible_worker_config(self) -> Optional['outputs.ClusterClusterConfigPreemptibleWorkerConfig']:
        """
        The Google Compute Engine config settings for the additional (aka
        preemptible) instances in a cluster. Structure defined below.
        """
        return pulumi.get(self, "preemptible_worker_config")

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> Optional['outputs.ClusterClusterConfigSecurityConfig']:
        """
        Security related configuration. Structure defined below.
        """
        return pulumi.get(self, "security_config")

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> Optional['outputs.ClusterClusterConfigSoftwareConfig']:
        """
        The config settings for software inside the cluster.
        Structure defined below.
        """
        return pulumi.get(self, "software_config")

    @property
    @pulumi.getter(name="stagingBucket")
    def staging_bucket(self) -> Optional[str]:
        """
        The Cloud Storage staging bucket used to stage files,
        such as Hadoop jars, between client machines and the cluster.
        Note: If you don't explicitly specify a `staging_bucket`
        then GCP will auto create / assign one for you. However, you are not guaranteed
        an auto generated bucket which is solely dedicated to your cluster; it may be shared
        with other clusters in the same region/zone also choosing to use the auto generation
        option.
        """
        return pulumi.get(self, "staging_bucket")

    @property
    @pulumi.getter(name="workerConfig")
    def worker_config(self) -> Optional['outputs.ClusterClusterConfigWorkerConfig']:
        """
        The Google Compute Engine config settings for the worker instances
        in a cluster.. Structure defined below.
        """
        return pulumi.get(self, "worker_config")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigAutoscalingConfig(dict):
    def __init__(__self__, *,
                 policy_uri: str):
        """
        :param str policy_uri: The autoscaling policy used by the cluster.
        """
        pulumi.set(__self__, "policy_uri", policy_uri)

    @property
    @pulumi.getter(name="policyUri")
    def policy_uri(self) -> str:
        """
        The autoscaling policy used by the cluster.
        """
        return pulumi.get(self, "policy_uri")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigEncryptionConfig(dict):
    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: The Cloud KMS key name to use for PD disk encryption for
               all instances in the cluster.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        The Cloud KMS key name to use for PD disk encryption for
        all instances in the cluster.
        """
        return pulumi.get(self, "kms_key_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigEndpointConfig(dict):
    def __init__(__self__, *,
                 enable_http_port_access: bool,
                 http_ports: Optional[Mapping[str, Any]] = None):
        """
        :param bool enable_http_port_access: The flag to enable http access to specific ports
               on the cluster from external sources (aka Component Gateway). Defaults to false.
        """
        pulumi.set(__self__, "enable_http_port_access", enable_http_port_access)
        if http_ports is not None:
            pulumi.set(__self__, "http_ports", http_ports)

    @property
    @pulumi.getter(name="enableHttpPortAccess")
    def enable_http_port_access(self) -> bool:
        """
        The flag to enable http access to specific ports
        on the cluster from external sources (aka Component Gateway). Defaults to false.
        """
        return pulumi.get(self, "enable_http_port_access")

    @property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "http_ports")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigGceClusterConfig(dict):
    def __init__(__self__, *,
                 internal_ip_only: Optional[bool] = None,
                 metadata: Optional[Mapping[str, str]] = None,
                 network: Optional[str] = None,
                 service_account: Optional[str] = None,
                 service_account_scopes: Optional[List[str]] = None,
                 subnetwork: Optional[str] = None,
                 tags: Optional[List[str]] = None,
                 zone: Optional[str] = None):
        """
        :param bool internal_ip_only: By default, clusters are not restricted to internal IP addresses, 
               and will have ephemeral external IP addresses assigned to each instance. If set to true, all
               instances in the cluster will only have internal IP addresses. Note: Private Google Access
               (also known as `privateIpGoogleAccess`) must be enabled on the subnetwork that the cluster
               will be launched in.
        :param Mapping[str, str] metadata: A map of the Compute Engine metadata entries to add to all instances
               (see [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        :param str network: The name or self_link of the Google Compute Engine
               network to the cluster will be part of. Conflicts with `subnetwork`.
               If neither is specified, this defaults to the "default" network.
        :param str service_account: The service account to be used by the Node VMs.
               If not specified, the "default" service account is used.
        :param List[str] service_account_scopes: The set of Google API scopes
               to be made available on all of the node VMs under the `service_account`
               specified. These can be	either FQDNs, or scope aliases. The following scopes
               must be set if any other scopes are set. They're necessary to ensure the
               correct functioning ofthe cluster, and are set automatically by the API:
        :param str subnetwork: The name or self_link of the Google Compute Engine
               subnetwork the cluster will be part of. Conflicts with `network`.
        :param List[str] tags: The list of instance tags applied to instances in the cluster.
               Tags are used to identify valid sources or targets for network firewalls.
        :param str zone: The GCP zone where your data is stored and used (i.e. where
               the master and the worker nodes will be created in). If `region` is set to 'global' (default)
               then `zone` is mandatory, otherwise GCP is able to make use of [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/auto-zone)
               to determine this automatically for you.
               Note: This setting additionally determines and restricts
               which computing resources are available for use with other configs such as
               `cluster_config.master_config.machine_type` and `cluster_config.worker_config.machine_type`.
        """
        if internal_ip_only is not None:
            pulumi.set(__self__, "internal_ip_only", internal_ip_only)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_account_scopes is not None:
            pulumi.set(__self__, "service_account_scopes", service_account_scopes)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="internalIpOnly")
    def internal_ip_only(self) -> Optional[bool]:
        """
        By default, clusters are not restricted to internal IP addresses, 
        and will have ephemeral external IP addresses assigned to each instance. If set to true, all
        instances in the cluster will only have internal IP addresses. Note: Private Google Access
        (also known as `privateIpGoogleAccess`) must be enabled on the subnetwork that the cluster
        will be launched in.
        """
        return pulumi.get(self, "internal_ip_only")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, str]]:
        """
        A map of the Compute Engine metadata entries to add to all instances
        (see [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def network(self) -> Optional[str]:
        """
        The name or self_link of the Google Compute Engine
        network to the cluster will be part of. Conflicts with `subnetwork`.
        If neither is specified, this defaults to the "default" network.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[str]:
        """
        The service account to be used by the Node VMs.
        If not specified, the "default" service account is used.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="serviceAccountScopes")
    def service_account_scopes(self) -> Optional[List[str]]:
        """
        The set of Google API scopes
        to be made available on all of the node VMs under the `service_account`
        specified. These can be	either FQDNs, or scope aliases. The following scopes
        must be set if any other scopes are set. They're necessary to ensure the
        correct functioning ofthe cluster, and are set automatically by the API:
        """
        return pulumi.get(self, "service_account_scopes")

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[str]:
        """
        The name or self_link of the Google Compute Engine
        subnetwork the cluster will be part of. Conflicts with `network`.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter
    def tags(self) -> Optional[List[str]]:
        """
        The list of instance tags applied to instances in the cluster.
        Tags are used to identify valid sources or targets for network firewalls.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        The GCP zone where your data is stored and used (i.e. where
        the master and the worker nodes will be created in). If `region` is set to 'global' (default)
        then `zone` is mandatory, otherwise GCP is able to make use of [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/auto-zone)
        to determine this automatically for you.
        Note: This setting additionally determines and restricts
        which computing resources are available for use with other configs such as
        `cluster_config.master_config.machine_type` and `cluster_config.worker_config.machine_type`.
        """
        return pulumi.get(self, "zone")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigInitializationAction(dict):
    def __init__(__self__, *,
                 script: str,
                 timeout_sec: Optional[float] = None):
        """
        :param str script: The script to be executed during initialization of the cluster.
               The script must be a GCS file with a gs:// prefix.
        :param float timeout_sec: The maximum duration (in seconds) which `script` is
               allowed to take to execute its action. GCP will default to a predetermined
               computed value if not set (currently 300).
        """
        pulumi.set(__self__, "script", script)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)

    @property
    @pulumi.getter
    def script(self) -> str:
        """
        The script to be executed during initialization of the cluster.
        The script must be a GCS file with a gs:// prefix.
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[float]:
        """
        The maximum duration (in seconds) which `script` is
        allowed to take to execute its action. GCP will default to a predetermined
        computed value if not set (currently 300).
        """
        return pulumi.get(self, "timeout_sec")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigLifecycleConfig(dict):
    def __init__(__self__, *,
                 auto_delete_time: Optional[str] = None,
                 idle_delete_ttl: Optional[str] = None,
                 idle_start_time: Optional[str] = None):
        """
        :param str auto_delete_time: The time when cluster will be auto-deleted.
               A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
               Example: "2014-10-02T15:01:23.045123456Z".
        :param str idle_delete_ttl: The duration to keep the cluster alive while idling
               (no jobs running). After this TTL, the cluster will be deleted. Valid range: [10m, 14d].
        """
        if auto_delete_time is not None:
            pulumi.set(__self__, "auto_delete_time", auto_delete_time)
        if idle_delete_ttl is not None:
            pulumi.set(__self__, "idle_delete_ttl", idle_delete_ttl)
        if idle_start_time is not None:
            pulumi.set(__self__, "idle_start_time", idle_start_time)

    @property
    @pulumi.getter(name="autoDeleteTime")
    def auto_delete_time(self) -> Optional[str]:
        """
        The time when cluster will be auto-deleted.
        A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "auto_delete_time")

    @property
    @pulumi.getter(name="idleDeleteTtl")
    def idle_delete_ttl(self) -> Optional[str]:
        """
        The duration to keep the cluster alive while idling
        (no jobs running). After this TTL, the cluster will be deleted. Valid range: [10m, 14d].
        """
        return pulumi.get(self, "idle_delete_ttl")

    @property
    @pulumi.getter(name="idleStartTime")
    def idle_start_time(self) -> Optional[str]:
        return pulumi.get(self, "idle_start_time")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigMasterConfig(dict):
    def __init__(__self__, *,
                 accelerators: Optional[List['outputs.ClusterClusterConfigMasterConfigAccelerator']] = None,
                 disk_config: Optional['outputs.ClusterClusterConfigMasterConfigDiskConfig'] = None,
                 image_uri: Optional[str] = None,
                 instance_names: Optional[List[str]] = None,
                 machine_type: Optional[str] = None,
                 min_cpu_platform: Optional[str] = None,
                 num_instances: Optional[float] = None):
        """
        :param List['ClusterClusterConfigMasterConfigAcceleratorArgs'] accelerators: The Compute Engine accelerator configuration for these instances. Can be specified multiple times.
        :param 'ClusterClusterConfigMasterConfigDiskConfigArgs' disk_config: Disk Config
        :param str image_uri: The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
               for more information.
        :param str machine_type: The name of a Google Compute Engine machine type
               to create for the worker nodes. If not specified, GCP will default to a predetermined
               computed value (currently `n1-standard-4`).
        :param str min_cpu_platform: The name of a minimum generation of CPU family
               for the master. If not specified, GCP will default to a predetermined computed value
               for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
               for details about which CPU families are available (and defaulted) for each zone.
        :param float num_instances: Specifies the number of preemptible nodes to create.
               Defaults to 0.
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[List['outputs.ClusterClusterConfigMasterConfigAccelerator']]:
        """
        The Compute Engine accelerator configuration for these instances. Can be specified multiple times.
        """
        return pulumi.get(self, "accelerators")

    @property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional['outputs.ClusterClusterConfigMasterConfigDiskConfig']:
        """
        Disk Config
        """
        return pulumi.get(self, "disk_config")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[str]:
        """
        The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
        for more information.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[List[str]]:
        return pulumi.get(self, "instance_names")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[str]:
        """
        The name of a Google Compute Engine machine type
        to create for the worker nodes. If not specified, GCP will default to a predetermined
        computed value (currently `n1-standard-4`).
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[str]:
        """
        The name of a minimum generation of CPU family
        for the master. If not specified, GCP will default to a predetermined computed value
        for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        for details about which CPU families are available (and defaulted) for each zone.
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[float]:
        """
        Specifies the number of preemptible nodes to create.
        Defaults to 0.
        """
        return pulumi.get(self, "num_instances")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigMasterConfigAccelerator(dict):
    def __init__(__self__, *,
                 accelerator_count: float,
                 accelerator_type: str):
        """
        :param float accelerator_count: The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.
        :param str accelerator_type: The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        pulumi.set(__self__, "accelerator_count", accelerator_count)
        pulumi.set(__self__, "accelerator_type", accelerator_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> float:
        """
        The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.
        """
        return pulumi.get(self, "accelerator_count")

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> str:
        """
        The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "accelerator_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigMasterConfigDiskConfig(dict):
    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[float] = None,
                 boot_disk_type: Optional[str] = None,
                 num_local_ssds: Optional[float] = None):
        """
        :param float boot_disk_size_gb: Size of the primary disk attached to each preemptible worker node, specified
               in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
               computed value if not set (currently 500GB). Note: If SSDs are not
               attached, it also contains the HDFS data blocks and Hadoop working directories.
        :param str boot_disk_type: The disk type of the primary disk attached to each preemptible worker node.
               One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        :param float num_local_ssds: The amount of local SSD disks that will be
               attached to each preemptible worker node. Defaults to 0.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[float]:
        """
        Size of the primary disk attached to each preemptible worker node, specified
        in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
        computed value if not set (currently 500GB). Note: If SSDs are not
        attached, it also contains the HDFS data blocks and Hadoop working directories.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[str]:
        """
        The disk type of the primary disk attached to each preemptible worker node.
        One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        """
        return pulumi.get(self, "boot_disk_type")

    @property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[float]:
        """
        The amount of local SSD disks that will be
        attached to each preemptible worker node. Defaults to 0.
        """
        return pulumi.get(self, "num_local_ssds")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigPreemptibleWorkerConfig(dict):
    def __init__(__self__, *,
                 disk_config: Optional['outputs.ClusterClusterConfigPreemptibleWorkerConfigDiskConfig'] = None,
                 instance_names: Optional[List[str]] = None,
                 num_instances: Optional[float] = None):
        """
        :param 'ClusterClusterConfigPreemptibleWorkerConfigDiskConfigArgs' disk_config: Disk Config
        :param float num_instances: Specifies the number of preemptible nodes to create.
               Defaults to 0.
        """
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)

    @property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional['outputs.ClusterClusterConfigPreemptibleWorkerConfigDiskConfig']:
        """
        Disk Config
        """
        return pulumi.get(self, "disk_config")

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[List[str]]:
        return pulumi.get(self, "instance_names")

    @property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[float]:
        """
        Specifies the number of preemptible nodes to create.
        Defaults to 0.
        """
        return pulumi.get(self, "num_instances")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigPreemptibleWorkerConfigDiskConfig(dict):
    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[float] = None,
                 boot_disk_type: Optional[str] = None,
                 num_local_ssds: Optional[float] = None):
        """
        :param float boot_disk_size_gb: Size of the primary disk attached to each preemptible worker node, specified
               in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
               computed value if not set (currently 500GB). Note: If SSDs are not
               attached, it also contains the HDFS data blocks and Hadoop working directories.
        :param str boot_disk_type: The disk type of the primary disk attached to each preemptible worker node.
               One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        :param float num_local_ssds: The amount of local SSD disks that will be
               attached to each preemptible worker node. Defaults to 0.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[float]:
        """
        Size of the primary disk attached to each preemptible worker node, specified
        in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
        computed value if not set (currently 500GB). Note: If SSDs are not
        attached, it also contains the HDFS data blocks and Hadoop working directories.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[str]:
        """
        The disk type of the primary disk attached to each preemptible worker node.
        One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        """
        return pulumi.get(self, "boot_disk_type")

    @property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[float]:
        """
        The amount of local SSD disks that will be
        attached to each preemptible worker node. Defaults to 0.
        """
        return pulumi.get(self, "num_local_ssds")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigSecurityConfig(dict):
    def __init__(__self__, *,
                 kerberos_config: 'outputs.ClusterClusterConfigSecurityConfigKerberosConfig'):
        """
        :param 'ClusterClusterConfigSecurityConfigKerberosConfigArgs' kerberos_config: Kerberos Configuration
        """
        pulumi.set(__self__, "kerberos_config", kerberos_config)

    @property
    @pulumi.getter(name="kerberosConfig")
    def kerberos_config(self) -> 'outputs.ClusterClusterConfigSecurityConfigKerberosConfig':
        """
        Kerberos Configuration
        """
        return pulumi.get(self, "kerberos_config")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigSecurityConfigKerberosConfig(dict):
    def __init__(__self__, *,
                 kms_key_uri: str,
                 root_principal_password_uri: str,
                 cross_realm_trust_admin_server: Optional[str] = None,
                 cross_realm_trust_kdc: Optional[str] = None,
                 cross_realm_trust_realm: Optional[str] = None,
                 cross_realm_trust_shared_password_uri: Optional[str] = None,
                 enable_kerberos: Optional[bool] = None,
                 kdc_db_key_uri: Optional[str] = None,
                 key_password_uri: Optional[str] = None,
                 keystore_password_uri: Optional[str] = None,
                 keystore_uri: Optional[str] = None,
                 realm: Optional[str] = None,
                 tgt_lifetime_hours: Optional[float] = None,
                 truststore_password_uri: Optional[str] = None,
                 truststore_uri: Optional[str] = None):
        """
        :param str kms_key_uri: The URI of the KMS key used to encrypt various sensitive files.
        :param str root_principal_password_uri: The Cloud Storage URI of a KMS encrypted file
               containing the root principal password.
        :param str cross_realm_trust_admin_server: The admin server (IP or hostname) for the
               remote trusted realm in a cross realm trust relationship.
        :param str cross_realm_trust_kdc: The KDC (IP or hostname) for the
               remote trusted realm in a cross realm trust relationship.
        :param str cross_realm_trust_realm: The remote realm the Dataproc on-cluster KDC will
               trust, should the user enable cross realm trust.
        :param str cross_realm_trust_shared_password_uri: The Cloud Storage URI of a KMS
               encrypted file containing the shared password between the on-cluster Kerberos realm
               and the remote trusted realm, in a cross realm trust relationship.
        :param bool enable_kerberos: Flag to indicate whether to Kerberize the cluster.
        :param str kdc_db_key_uri: The Cloud Storage URI of a KMS encrypted file containing
               the master key of the KDC database.
        :param str key_password_uri: The Cloud Storage URI of a KMS encrypted file containing
               the password to the user provided key. For the self-signed certificate, this password
               is generated by Dataproc.
        :param str keystore_password_uri: The Cloud Storage URI of a KMS encrypted file containing
               the password to the user provided keystore. For the self-signed certificated, the password
               is generated by Dataproc.
        :param str keystore_uri: The Cloud Storage URI of the keystore file used for SSL encryption.
               If not provided, Dataproc will provide a self-signed certificate.
        :param str realm: The name of the on-cluster Kerberos realm. If not specified, the
               uppercased domain of hostnames will be the realm.
        :param float tgt_lifetime_hours: The lifetime of the ticket granting ticket, in hours.
        :param str truststore_password_uri: The Cloud Storage URI of a KMS encrypted file
               containing the password to the user provided truststore. For the self-signed
               certificate, this password is generated by Dataproc.
        :param str truststore_uri: The Cloud Storage URI of the truststore file used for
               SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        pulumi.set(__self__, "kms_key_uri", kms_key_uri)
        pulumi.set(__self__, "root_principal_password_uri", root_principal_password_uri)
        if cross_realm_trust_admin_server is not None:
            pulumi.set(__self__, "cross_realm_trust_admin_server", cross_realm_trust_admin_server)
        if cross_realm_trust_kdc is not None:
            pulumi.set(__self__, "cross_realm_trust_kdc", cross_realm_trust_kdc)
        if cross_realm_trust_realm is not None:
            pulumi.set(__self__, "cross_realm_trust_realm", cross_realm_trust_realm)
        if cross_realm_trust_shared_password_uri is not None:
            pulumi.set(__self__, "cross_realm_trust_shared_password_uri", cross_realm_trust_shared_password_uri)
        if enable_kerberos is not None:
            pulumi.set(__self__, "enable_kerberos", enable_kerberos)
        if kdc_db_key_uri is not None:
            pulumi.set(__self__, "kdc_db_key_uri", kdc_db_key_uri)
        if key_password_uri is not None:
            pulumi.set(__self__, "key_password_uri", key_password_uri)
        if keystore_password_uri is not None:
            pulumi.set(__self__, "keystore_password_uri", keystore_password_uri)
        if keystore_uri is not None:
            pulumi.set(__self__, "keystore_uri", keystore_uri)
        if realm is not None:
            pulumi.set(__self__, "realm", realm)
        if tgt_lifetime_hours is not None:
            pulumi.set(__self__, "tgt_lifetime_hours", tgt_lifetime_hours)
        if truststore_password_uri is not None:
            pulumi.set(__self__, "truststore_password_uri", truststore_password_uri)
        if truststore_uri is not None:
            pulumi.set(__self__, "truststore_uri", truststore_uri)

    @property
    @pulumi.getter(name="kmsKeyUri")
    def kms_key_uri(self) -> str:
        """
        The URI of the KMS key used to encrypt various sensitive files.
        """
        return pulumi.get(self, "kms_key_uri")

    @property
    @pulumi.getter(name="rootPrincipalPasswordUri")
    def root_principal_password_uri(self) -> str:
        """
        The Cloud Storage URI of a KMS encrypted file
        containing the root principal password.
        """
        return pulumi.get(self, "root_principal_password_uri")

    @property
    @pulumi.getter(name="crossRealmTrustAdminServer")
    def cross_realm_trust_admin_server(self) -> Optional[str]:
        """
        The admin server (IP or hostname) for the
        remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_admin_server")

    @property
    @pulumi.getter(name="crossRealmTrustKdc")
    def cross_realm_trust_kdc(self) -> Optional[str]:
        """
        The KDC (IP or hostname) for the
        remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_kdc")

    @property
    @pulumi.getter(name="crossRealmTrustRealm")
    def cross_realm_trust_realm(self) -> Optional[str]:
        """
        The remote realm the Dataproc on-cluster KDC will
        trust, should the user enable cross realm trust.
        """
        return pulumi.get(self, "cross_realm_trust_realm")

    @property
    @pulumi.getter(name="crossRealmTrustSharedPasswordUri")
    def cross_realm_trust_shared_password_uri(self) -> Optional[str]:
        """
        The Cloud Storage URI of a KMS
        encrypted file containing the shared password between the on-cluster Kerberos realm
        and the remote trusted realm, in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_shared_password_uri")

    @property
    @pulumi.getter(name="enableKerberos")
    def enable_kerberos(self) -> Optional[bool]:
        """
        Flag to indicate whether to Kerberize the cluster.
        """
        return pulumi.get(self, "enable_kerberos")

    @property
    @pulumi.getter(name="kdcDbKeyUri")
    def kdc_db_key_uri(self) -> Optional[str]:
        """
        The Cloud Storage URI of a KMS encrypted file containing
        the master key of the KDC database.
        """
        return pulumi.get(self, "kdc_db_key_uri")

    @property
    @pulumi.getter(name="keyPasswordUri")
    def key_password_uri(self) -> Optional[str]:
        """
        The Cloud Storage URI of a KMS encrypted file containing
        the password to the user provided key. For the self-signed certificate, this password
        is generated by Dataproc.
        """
        return pulumi.get(self, "key_password_uri")

    @property
    @pulumi.getter(name="keystorePasswordUri")
    def keystore_password_uri(self) -> Optional[str]:
        """
        The Cloud Storage URI of a KMS encrypted file containing
        the password to the user provided keystore. For the self-signed certificated, the password
        is generated by Dataproc.
        """
        return pulumi.get(self, "keystore_password_uri")

    @property
    @pulumi.getter(name="keystoreUri")
    def keystore_uri(self) -> Optional[str]:
        """
        The Cloud Storage URI of the keystore file used for SSL encryption.
        If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "keystore_uri")

    @property
    @pulumi.getter
    def realm(self) -> Optional[str]:
        """
        The name of the on-cluster Kerberos realm. If not specified, the
        uppercased domain of hostnames will be the realm.
        """
        return pulumi.get(self, "realm")

    @property
    @pulumi.getter(name="tgtLifetimeHours")
    def tgt_lifetime_hours(self) -> Optional[float]:
        """
        The lifetime of the ticket granting ticket, in hours.
        """
        return pulumi.get(self, "tgt_lifetime_hours")

    @property
    @pulumi.getter(name="truststorePasswordUri")
    def truststore_password_uri(self) -> Optional[str]:
        """
        The Cloud Storage URI of a KMS encrypted file
        containing the password to the user provided truststore. For the self-signed
        certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "truststore_password_uri")

    @property
    @pulumi.getter(name="truststoreUri")
    def truststore_uri(self) -> Optional[str]:
        """
        The Cloud Storage URI of the truststore file used for
        SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "truststore_uri")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigSoftwareConfig(dict):
    def __init__(__self__, *,
                 image_version: Optional[str] = None,
                 optional_components: Optional[List[str]] = None,
                 override_properties: Optional[Mapping[str, str]] = None,
                 properties: Optional[Mapping[str, Any]] = None):
        """
        :param str image_version: The Cloud Dataproc image version to use
               for the cluster - this controls the sets of software versions
               installed onto the nodes when you create clusters. If not specified, defaults to the
               latest version. For a list of valid versions see
               [Cloud Dataproc versions](https://cloud.google.com/dataproc/docs/concepts/dataproc-versions)
        :param List[str] optional_components: The set of optional components to activate on the cluster. 
               Accepted values are:
               * ANACONDA
               * DRUID
               * HBASE
               * HIVE_WEBHCAT
               * JUPYTER
               * KERBEROS
               * PRESTO
               * RANGER
               * SOLR
               * ZEPPELIN
               * ZOOKEEPER
        :param Mapping[str, str] override_properties: A list of override and additional properties (key/value pairs)
               used to modify various aspects of the common configuration files used when creating
               a cluster. For a list of valid properties please see
               [Cluster properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties)
        """
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if optional_components is not None:
            pulumi.set(__self__, "optional_components", optional_components)
        if override_properties is not None:
            pulumi.set(__self__, "override_properties", override_properties)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[str]:
        """
        The Cloud Dataproc image version to use
        for the cluster - this controls the sets of software versions
        installed onto the nodes when you create clusters. If not specified, defaults to the
        latest version. For a list of valid versions see
        [Cloud Dataproc versions](https://cloud.google.com/dataproc/docs/concepts/dataproc-versions)
        """
        return pulumi.get(self, "image_version")

    @property
    @pulumi.getter(name="optionalComponents")
    def optional_components(self) -> Optional[List[str]]:
        """
        The set of optional components to activate on the cluster. 
        Accepted values are:
        * ANACONDA
        * DRUID
        * HBASE
        * HIVE_WEBHCAT
        * JUPYTER
        * KERBEROS
        * PRESTO
        * RANGER
        * SOLR
        * ZEPPELIN
        * ZOOKEEPER
        """
        return pulumi.get(self, "optional_components")

    @property
    @pulumi.getter(name="overrideProperties")
    def override_properties(self) -> Optional[Mapping[str, str]]:
        """
        A list of override and additional properties (key/value pairs)
        used to modify various aspects of the common configuration files used when creating
        a cluster. For a list of valid properties please see
        [Cluster properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties)
        """
        return pulumi.get(self, "override_properties")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "properties")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigWorkerConfig(dict):
    def __init__(__self__, *,
                 accelerators: Optional[List['outputs.ClusterClusterConfigWorkerConfigAccelerator']] = None,
                 disk_config: Optional['outputs.ClusterClusterConfigWorkerConfigDiskConfig'] = None,
                 image_uri: Optional[str] = None,
                 instance_names: Optional[List[str]] = None,
                 machine_type: Optional[str] = None,
                 min_cpu_platform: Optional[str] = None,
                 num_instances: Optional[float] = None):
        """
        :param List['ClusterClusterConfigWorkerConfigAcceleratorArgs'] accelerators: The Compute Engine accelerator configuration for these instances. Can be specified multiple times.
        :param 'ClusterClusterConfigWorkerConfigDiskConfigArgs' disk_config: Disk Config
        :param str image_uri: The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
               for more information.
        :param str machine_type: The name of a Google Compute Engine machine type
               to create for the worker nodes. If not specified, GCP will default to a predetermined
               computed value (currently `n1-standard-4`).
        :param str min_cpu_platform: The name of a minimum generation of CPU family
               for the master. If not specified, GCP will default to a predetermined computed value
               for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
               for details about which CPU families are available (and defaulted) for each zone.
        :param float num_instances: Specifies the number of preemptible nodes to create.
               Defaults to 0.
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[List['outputs.ClusterClusterConfigWorkerConfigAccelerator']]:
        """
        The Compute Engine accelerator configuration for these instances. Can be specified multiple times.
        """
        return pulumi.get(self, "accelerators")

    @property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional['outputs.ClusterClusterConfigWorkerConfigDiskConfig']:
        """
        Disk Config
        """
        return pulumi.get(self, "disk_config")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[str]:
        """
        The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
        for more information.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[List[str]]:
        return pulumi.get(self, "instance_names")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[str]:
        """
        The name of a Google Compute Engine machine type
        to create for the worker nodes. If not specified, GCP will default to a predetermined
        computed value (currently `n1-standard-4`).
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[str]:
        """
        The name of a minimum generation of CPU family
        for the master. If not specified, GCP will default to a predetermined computed value
        for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        for details about which CPU families are available (and defaulted) for each zone.
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[float]:
        """
        Specifies the number of preemptible nodes to create.
        Defaults to 0.
        """
        return pulumi.get(self, "num_instances")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigWorkerConfigAccelerator(dict):
    def __init__(__self__, *,
                 accelerator_count: float,
                 accelerator_type: str):
        """
        :param float accelerator_count: The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.
        :param str accelerator_type: The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        pulumi.set(__self__, "accelerator_count", accelerator_count)
        pulumi.set(__self__, "accelerator_type", accelerator_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> float:
        """
        The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.
        """
        return pulumi.get(self, "accelerator_count")

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> str:
        """
        The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "accelerator_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterClusterConfigWorkerConfigDiskConfig(dict):
    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[float] = None,
                 boot_disk_type: Optional[str] = None,
                 num_local_ssds: Optional[float] = None):
        """
        :param float boot_disk_size_gb: Size of the primary disk attached to each preemptible worker node, specified
               in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
               computed value if not set (currently 500GB). Note: If SSDs are not
               attached, it also contains the HDFS data blocks and Hadoop working directories.
        :param str boot_disk_type: The disk type of the primary disk attached to each preemptible worker node.
               One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        :param float num_local_ssds: The amount of local SSD disks that will be
               attached to each preemptible worker node. Defaults to 0.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[float]:
        """
        Size of the primary disk attached to each preemptible worker node, specified
        in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
        computed value if not set (currently 500GB). Note: If SSDs are not
        attached, it also contains the HDFS data blocks and Hadoop working directories.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[str]:
        """
        The disk type of the primary disk attached to each preemptible worker node.
        One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        """
        return pulumi.get(self, "boot_disk_type")

    @property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[float]:
        """
        The amount of local SSD disks that will be
        attached to each preemptible worker node. Defaults to 0.
        """
        return pulumi.get(self, "num_local_ssds")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterIAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterIAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobHadoopConfig(dict):
    def __init__(__self__, *,
                 archive_uris: Optional[List[str]] = None,
                 args: Optional[List[str]] = None,
                 file_uris: Optional[List[str]] = None,
                 jar_file_uris: Optional[List[str]] = None,
                 logging_config: Optional['outputs.JobHadoopConfigLoggingConfig'] = None,
                 main_class: Optional[str] = None,
                 main_jar_file_uri: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None):
        """
        :param List[str] archive_uris: HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        :param List[str] args: The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param List[str] file_uris: HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        :param List[str] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param str main_class: The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`. Conflicts with `main_jar_file_uri`
        :param str main_jar_file_uri: The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'. Conflicts with `main_class`
        :param Mapping[str, str] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[List[str]]:
        """
        HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter
    def args(self) -> Optional[List[str]]:
        """
        The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[List[str]]:
        """
        HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[List[str]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.JobHadoopConfigLoggingConfig']:
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[str]:
        """
        The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`. Conflicts with `main_jar_file_uri`
        """
        return pulumi.get(self, "main_class")

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[str]:
        """
        The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'. Conflicts with `main_class`
        """
        return pulumi.get(self, "main_jar_file_uri")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobHadoopConfigLoggingConfig(dict):
    def __init__(__self__, *,
                 driver_log_levels: Mapping[str, str]):
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Mapping[str, str]:
        return pulumi.get(self, "driver_log_levels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobHiveConfig(dict):
    def __init__(__self__, *,
                 continue_on_failure: Optional[bool] = None,
                 jar_file_uris: Optional[List[str]] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 query_file_uri: Optional[str] = None,
                 query_lists: Optional[List[str]] = None,
                 script_variables: Optional[Mapping[str, str]] = None):
        """
        :param bool continue_on_failure: Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        :param List[str] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param Mapping[str, str] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        :param str query_file_uri: The HCFS URI of the script that contains SQL queries.
               Conflicts with `query_list`
        :param List[str] query_lists: The list of SQL queries or statements to execute as part of the job.
               Conflicts with `query_file_uri`
        :param Mapping[str, str] script_variables: Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[bool]:
        """
        Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        """
        return pulumi.get(self, "continue_on_failure")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[List[str]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[str]:
        """
        The HCFS URI of the script that contains SQL queries.
        Conflicts with `query_list`
        """
        return pulumi.get(self, "query_file_uri")

    @property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[List[str]]:
        """
        The list of SQL queries or statements to execute as part of the job.
        Conflicts with `query_file_uri`
        """
        return pulumi.get(self, "query_lists")

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[Mapping[str, str]]:
        """
        Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        return pulumi.get(self, "script_variables")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobIAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobIAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobPigConfig(dict):
    def __init__(__self__, *,
                 continue_on_failure: Optional[bool] = None,
                 jar_file_uris: Optional[List[str]] = None,
                 logging_config: Optional['outputs.JobPigConfigLoggingConfig'] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 query_file_uri: Optional[str] = None,
                 query_lists: Optional[List[str]] = None,
                 script_variables: Optional[Mapping[str, str]] = None):
        """
        :param bool continue_on_failure: Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        :param List[str] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param Mapping[str, str] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        :param str query_file_uri: The HCFS URI of the script that contains SQL queries.
               Conflicts with `query_list`
        :param List[str] query_lists: The list of SQL queries or statements to execute as part of the job.
               Conflicts with `query_file_uri`
        :param Mapping[str, str] script_variables: Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[bool]:
        """
        Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        """
        return pulumi.get(self, "continue_on_failure")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[List[str]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.JobPigConfigLoggingConfig']:
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[str]:
        """
        The HCFS URI of the script that contains SQL queries.
        Conflicts with `query_list`
        """
        return pulumi.get(self, "query_file_uri")

    @property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[List[str]]:
        """
        The list of SQL queries or statements to execute as part of the job.
        Conflicts with `query_file_uri`
        """
        return pulumi.get(self, "query_lists")

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[Mapping[str, str]]:
        """
        Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        return pulumi.get(self, "script_variables")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobPigConfigLoggingConfig(dict):
    def __init__(__self__, *,
                 driver_log_levels: Mapping[str, str]):
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Mapping[str, str]:
        return pulumi.get(self, "driver_log_levels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobPlacement(dict):
    def __init__(__self__, *,
                 cluster_name: str,
                 cluster_uuid: Optional[str] = None):
        pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_uuid is not None:
            pulumi.set(__self__, "cluster_uuid", cluster_uuid)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> Optional[str]:
        return pulumi.get(self, "cluster_uuid")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobPysparkConfig(dict):
    def __init__(__self__, *,
                 main_python_file_uri: str,
                 archive_uris: Optional[List[str]] = None,
                 args: Optional[List[str]] = None,
                 file_uris: Optional[List[str]] = None,
                 jar_file_uris: Optional[List[str]] = None,
                 logging_config: Optional['outputs.JobPysparkConfigLoggingConfig'] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 python_file_uris: Optional[List[str]] = None):
        """
        :param str main_python_file_uri: The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        :param List[str] archive_uris: HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        :param List[str] args: The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param List[str] file_uris: HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        :param List[str] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param Mapping[str, str] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        :param List[str] python_file_uris: HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        pulumi.set(__self__, "main_python_file_uri", main_python_file_uri)
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if python_file_uris is not None:
            pulumi.set(__self__, "python_file_uris", python_file_uris)

    @property
    @pulumi.getter(name="mainPythonFileUri")
    def main_python_file_uri(self) -> str:
        """
        The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        """
        return pulumi.get(self, "main_python_file_uri")

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[List[str]]:
        """
        HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter
    def args(self) -> Optional[List[str]]:
        """
        The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[List[str]]:
        """
        HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[List[str]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.JobPysparkConfigLoggingConfig']:
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="pythonFileUris")
    def python_file_uris(self) -> Optional[List[str]]:
        """
        HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        return pulumi.get(self, "python_file_uris")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobPysparkConfigLoggingConfig(dict):
    def __init__(__self__, *,
                 driver_log_levels: Mapping[str, str]):
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Mapping[str, str]:
        return pulumi.get(self, "driver_log_levels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobReference(dict):
    def __init__(__self__, *,
                 job_id: Optional[str] = None):
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[str]:
        return pulumi.get(self, "job_id")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobScheduling(dict):
    def __init__(__self__, *,
                 max_failures_per_hour: float):
        pulumi.set(__self__, "max_failures_per_hour", max_failures_per_hour)

    @property
    @pulumi.getter(name="maxFailuresPerHour")
    def max_failures_per_hour(self) -> float:
        return pulumi.get(self, "max_failures_per_hour")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobSparkConfig(dict):
    def __init__(__self__, *,
                 archive_uris: Optional[List[str]] = None,
                 args: Optional[List[str]] = None,
                 file_uris: Optional[List[str]] = None,
                 jar_file_uris: Optional[List[str]] = None,
                 logging_config: Optional['outputs.JobSparkConfigLoggingConfig'] = None,
                 main_class: Optional[str] = None,
                 main_jar_file_uri: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None):
        """
        :param List[str] archive_uris: HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        :param List[str] args: The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param List[str] file_uris: HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        :param List[str] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param str main_class: The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`. Conflicts with `main_jar_file_uri`
        :param str main_jar_file_uri: The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'. Conflicts with `main_class`
        :param Mapping[str, str] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[List[str]]:
        """
        HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter
    def args(self) -> Optional[List[str]]:
        """
        The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[List[str]]:
        """
        HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[List[str]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.JobSparkConfigLoggingConfig']:
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[str]:
        """
        The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`. Conflicts with `main_jar_file_uri`
        """
        return pulumi.get(self, "main_class")

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[str]:
        """
        The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'. Conflicts with `main_class`
        """
        return pulumi.get(self, "main_jar_file_uri")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobSparkConfigLoggingConfig(dict):
    def __init__(__self__, *,
                 driver_log_levels: Mapping[str, str]):
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Mapping[str, str]:
        return pulumi.get(self, "driver_log_levels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobSparksqlConfig(dict):
    def __init__(__self__, *,
                 jar_file_uris: Optional[List[str]] = None,
                 logging_config: Optional['outputs.JobSparksqlConfigLoggingConfig'] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 query_file_uri: Optional[str] = None,
                 query_lists: Optional[List[str]] = None,
                 script_variables: Optional[Mapping[str, str]] = None):
        """
        :param List[str] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param Mapping[str, str] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        :param str query_file_uri: The HCFS URI of the script that contains SQL queries.
               Conflicts with `query_list`
        :param List[str] query_lists: The list of SQL queries or statements to execute as part of the job.
               Conflicts with `query_file_uri`
        :param Mapping[str, str] script_variables: Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[List[str]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional['outputs.JobSparksqlConfigLoggingConfig']:
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[str]:
        """
        The HCFS URI of the script that contains SQL queries.
        Conflicts with `query_list`
        """
        return pulumi.get(self, "query_file_uri")

    @property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[List[str]]:
        """
        The list of SQL queries or statements to execute as part of the job.
        Conflicts with `query_file_uri`
        """
        return pulumi.get(self, "query_lists")

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[Mapping[str, str]]:
        """
        Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        return pulumi.get(self, "script_variables")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobSparksqlConfigLoggingConfig(dict):
    def __init__(__self__, *,
                 driver_log_levels: Mapping[str, str]):
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Mapping[str, str]:
        return pulumi.get(self, "driver_log_levels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobStatus(dict):
    def __init__(__self__, *,
                 details: Optional[str] = None,
                 state: Optional[str] = None,
                 state_start_time: Optional[str] = None,
                 substate: Optional[str] = None):
        if details is not None:
            pulumi.set(__self__, "details", details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_start_time is not None:
            pulumi.set(__self__, "state_start_time", state_start_time)
        if substate is not None:
            pulumi.set(__self__, "substate", substate)

    @property
    @pulumi.getter
    def details(self) -> Optional[str]:
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateStartTime")
    def state_start_time(self) -> Optional[str]:
        return pulumi.get(self, "state_start_time")

    @property
    @pulumi.getter
    def substate(self) -> Optional[str]:
        return pulumi.get(self, "substate")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


