# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs

__all__ = [
    'GetDatabaseInstanceResult',
    'AwaitableGetDatabaseInstanceResult',
    'get_database_instance',
]

@pulumi.output_type
class GetDatabaseInstanceResult:
    """
    A collection of values returned by getDatabaseInstance.
    """
    def __init__(__self__, connection_name=None, database_version=None, encryption_key_name=None, first_ip_address=None, id=None, ip_addresses=None, master_instance_name=None, name=None, private_ip_address=None, project=None, public_ip_address=None, region=None, replica_configurations=None, root_password=None, self_link=None, server_ca_certs=None, service_account_email_address=None, settings=None):
        if connection_name and not isinstance(connection_name, str):
            raise TypeError("Expected argument 'connection_name' to be a str")
        pulumi.set(__self__, "connection_name", connection_name)
        if database_version and not isinstance(database_version, str):
            raise TypeError("Expected argument 'database_version' to be a str")
        pulumi.set(__self__, "database_version", database_version)
        if encryption_key_name and not isinstance(encryption_key_name, str):
            raise TypeError("Expected argument 'encryption_key_name' to be a str")
        pulumi.set(__self__, "encryption_key_name", encryption_key_name)
        if first_ip_address and not isinstance(first_ip_address, str):
            raise TypeError("Expected argument 'first_ip_address' to be a str")
        pulumi.set(__self__, "first_ip_address", first_ip_address)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_addresses and not isinstance(ip_addresses, list):
            raise TypeError("Expected argument 'ip_addresses' to be a list")
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        if master_instance_name and not isinstance(master_instance_name, str):
            raise TypeError("Expected argument 'master_instance_name' to be a str")
        pulumi.set(__self__, "master_instance_name", master_instance_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if private_ip_address and not isinstance(private_ip_address, str):
            raise TypeError("Expected argument 'private_ip_address' to be a str")
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if public_ip_address and not isinstance(public_ip_address, str):
            raise TypeError("Expected argument 'public_ip_address' to be a str")
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if replica_configurations and not isinstance(replica_configurations, list):
            raise TypeError("Expected argument 'replica_configurations' to be a list")
        pulumi.set(__self__, "replica_configurations", replica_configurations)
        if root_password and not isinstance(root_password, str):
            raise TypeError("Expected argument 'root_password' to be a str")
        pulumi.set(__self__, "root_password", root_password)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if server_ca_certs and not isinstance(server_ca_certs, list):
            raise TypeError("Expected argument 'server_ca_certs' to be a list")
        pulumi.set(__self__, "server_ca_certs", server_ca_certs)
        if service_account_email_address and not isinstance(service_account_email_address, str):
            raise TypeError("Expected argument 'service_account_email_address' to be a str")
        pulumi.set(__self__, "service_account_email_address", service_account_email_address)
        if settings and not isinstance(settings, list):
            raise TypeError("Expected argument 'settings' to be a list")
        pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> str:
        """
        The connection name of the instance to be used in connection strings.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> str:
        """
        The MySQL, PostgreSQL or SQL Server (beta) version to use.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="encryptionKeyName")
    def encryption_key_name(self) -> str:
        """
        The full path to the encryption key used for the CMEK disk encryption.
        """
        return pulumi.get(self, "encryption_key_name")

    @property
    @pulumi.getter(name="firstIpAddress")
    def first_ip_address(self) -> str:
        """
        The first IPv4 address of any type assigned.
        """
        return pulumi.get(self, "first_ip_address")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> List['outputs.GetDatabaseInstanceIpAddressResult']:
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="masterInstanceName")
    def master_instance_name(self) -> str:
        """
        The name of the instance that will act as
        the master in the replication setup.
        """
        return pulumi.get(self, "master_instance_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name for this whitelist entry.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        """
        The first private (`PRIVATE`) IPv4 address assigned.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        The first public (`PRIMARY`) IPv4 address assigned.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicaConfigurations")
    def replica_configurations(self) -> List['outputs.GetDatabaseInstanceReplicaConfigurationResult']:
        """
        The configuration for replication. The
        configuration is detailed below.
        """
        return pulumi.get(self, "replica_configurations")

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> str:
        """
        Initial root password. Required for MS SQL Server, ignored by MySQL and PostgreSQL.
        """
        return pulumi.get(self, "root_password")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="serverCaCerts")
    def server_ca_certs(self) -> List['outputs.GetDatabaseInstanceServerCaCertResult']:
        return pulumi.get(self, "server_ca_certs")

    @property
    @pulumi.getter(name="serviceAccountEmailAddress")
    def service_account_email_address(self) -> str:
        """
        The service account email address assigned to the instance.
        """
        return pulumi.get(self, "service_account_email_address")

    @property
    @pulumi.getter
    def settings(self) -> List['outputs.GetDatabaseInstanceSettingResult']:
        """
        The settings to use for the database. The
        configuration is detailed below.
        """
        return pulumi.get(self, "settings")


class AwaitableGetDatabaseInstanceResult(GetDatabaseInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseInstanceResult(
            connection_name=self.connection_name,
            database_version=self.database_version,
            encryption_key_name=self.encryption_key_name,
            first_ip_address=self.first_ip_address,
            id=self.id,
            ip_addresses=self.ip_addresses,
            master_instance_name=self.master_instance_name,
            name=self.name,
            private_ip_address=self.private_ip_address,
            project=self.project,
            public_ip_address=self.public_ip_address,
            region=self.region,
            replica_configurations=self.replica_configurations,
            root_password=self.root_password,
            self_link=self.self_link,
            server_ca_certs=self.server_ca_certs,
            service_account_email_address=self.service_account_email_address,
            settings=self.settings)


def get_database_instance(name: Optional[str] = None,
                          project: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseInstanceResult:
    """
    Use this data source to get information about a Cloud SQL instance


    :param str name: The name of the instance.
    :param str project: The ID of the project in which the resource belongs.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('gcp:sql/getDatabaseInstance:getDatabaseInstance', __args__, opts=opts, typ=GetDatabaseInstanceResult).value

    return AwaitableGetDatabaseInstanceResult(
        connection_name=__ret__.connection_name,
        database_version=__ret__.database_version,
        encryption_key_name=__ret__.encryption_key_name,
        first_ip_address=__ret__.first_ip_address,
        id=__ret__.id,
        ip_addresses=__ret__.ip_addresses,
        master_instance_name=__ret__.master_instance_name,
        name=__ret__.name,
        private_ip_address=__ret__.private_ip_address,
        project=__ret__.project,
        public_ip_address=__ret__.public_ip_address,
        region=__ret__.region,
        replica_configurations=__ret__.replica_configurations,
        root_password=__ret__.root_password,
        self_link=__ret__.self_link,
        server_ca_certs=__ret__.server_ca_certs,
        service_account_email_address=__ret__.service_account_email_address,
        settings=__ret__.settings)
