from loguru import logger

logger.remove()
try:
    from languageCheckerMod import LanguageChecker as lcm
except ModuleNotFoundError:
    from app.languageCheckerMod import LanguageChecker as lcm
try:
    from Decryptor.basicEncryption.basic_parent import BasicParent
except ModuleNotFoundError:
    from app.Decryptor.basicEncryption.basic_parent import BasicParent
import unittest


class TestBasicParent(unittest.TestCase):
    def test_basic_parent_caesar_yes(self):
        lc = lcm.LanguageChecker()
        bp = BasicParent(lc)
        result = bp.decrypt(
            "uryyb zl sngure uryyb zl zbgure naq v ernyyl qb yvxr n tbbq ratyvfu oernxsnfg"
        )
        self.assertEqual(result["IsPlaintext?"], True)

    def test_basic_parent_reverse_yes(self):
        lc = lcm.LanguageChecker()
        bp = BasicParent(lc)
        result = bp.decrypt(
            "tsafkaerb hsilgne doog a ekil od yllaer i dna rehtom ym olleh rehtaf ym olleh"
        )
        self.assertEqual(result["IsPlaintext?"], True)

    def test_basic_parent_reverse_yes_2(self):
        lc = lcm.LanguageChecker()
        bp = BasicParent(lc)
        result = bp.decrypt(
            "sevom ylpmis rac eht ciffart ruoy lla gnillenut si hcihw redivorp NPV a ekilnU"
        )
        self.assertEqual(result["IsPlaintext?"], True)

    # def test_transposition(self):
    #     lc = lcm.LanguageChecker()
    #     bp = BasicParent(lc)
    #     result = bp.decrypt("EONETEOHLYMSLHELMAIEPN")
    #     self.assertEqual(result["isplaintext?"], True)

    def test_viginere_yes(self):
        self.assertEqual(True, True)
        # lc = lcm.LanguageChecker()
        # bp = BasicParent(lc)
        # result = bp.decrypt(
        #     """Adiz Avtzqeci Tmzubb wsa m Pmilqev halpqavtakuoi, lgouqdaf, kdmktsvmztsl, izr xoexghzr kkusitaaf. Vz wsa twbhdg ubalmmzhdad qz hce vmhsgohuqbo ox kaakulmd gxiwvos, krgdurdny i rcmmstugvtawz ca tzm ocicwxfg jf "stscmilpy" oid "uwydptsbuci" wabt hce Lcdwig eiovdnw. Bgfdny qe kddwtk qjnkqpsmev ba pz tzm roohwz at xoexghzr kkusicw izr vrlqrwxist uboedtuuznum. Pimifo Icmlv Emf DI, Lcdwig owdyzd xwd hce Ywhsmnemzh Xovm mby Cqxtsm Supacg (GUKE) oo Bdmfqclwg Bomk, Tzuhvif'a ocyetzqofifo ositjm. Rcm a lqys ce oie vzav wr Vpt 8, lpq gzclqab mekxabnittq tjr Ymdavn fihog cjgbhvnstkgds. Zm psqikmp o iuejqf jf lmoviiicqg aoj jdsvkavs Uzreiz qdpzmdg, dnutgrdny bts helpar jf lpq pjmtm, mb zlwkffjmwktoiiuix avczqzs ohsb ocplv nuby swbfwigk naf ohw Mzwbms umqcifm. Mtoej bts raj pq kjrcmp oo tzm Zooigvmz Khqauqvl Dincmalwdm, rhwzq vz cjmmhzd gvq ca tzm rwmsl lqgdgfa rcm a kbafzd-hzaumae kaakulmd, hce SKQ. Wi 1948 Tmzubb jgqzsy Msf Zsrmsv'e Qjmhcfwig Dincmalwdm vt Eizqcekbqf Pnadqfnilg, ivzrw pq onsaafsy if bts yenmxckmwvf ca tzm Yoiczmehzr uwydptwze oid tmoohe avfsmekbqr dn eifvzmsbuqvl tqazjgq. Pq kmolm m dvpwz ab ohw ktshiuix pvsaa at hojxtcbefmewn, afl bfzdakfsy okkuzgalqzu xhwuuqvl jmmqoigve gpcz ie hce Tmxcpsgd-Lvvbgbubnkq zqoxtawz, kciup isme xqdgo otaqfqev qz hce 1960k. Bgfdny'a tchokmjivlabk fzsmtfsy if i ofdmavmz krgaqqptawz wi 1952, wzmz vjmgaqlpad iohn wwzq goidt uzgeyix wi tzm Gbdtwl Wwigvwy. Vz aukqdoev bdsvtemzh rilp rshadm tcmmgvqg (xhwuuqvl uiehmalqab) vs sv mzoejvmhdvw ba dmikwz. Hpravs rdev qz 1954, xpsl whsm tow iszkk jqtjrw pug 42id tqdhcdsg, rfjm ugmbddw xawnofqzu. Vn avcizsl lqhzreqzsy tzif vds vmmhc wsa eidcalq; vds ewfvzr svp gjmw wfvzrk jqzdenmp vds vmmhc wsa mqxivmzhvl. Gv 10 Esktwunsm 2009, fgtxcrifo mb Dnlmdbzt uiydviyv, Nfdtaat Dmiem Ywiikbqf Bojlab Wrgez avdw iz cafakuog pmjxwx ahwxcby gv nscadn at ohw Jdwoikp scqejvysit xwd "hce sxboglavs kvy zm ion tjmmhzd." Sa at Haq 2012 i bfdvsbq azmtmd'g widt ion bwnafz tzm Tcpsw wr Zjrva ivdcz eaigd yzmbo Tmzubb a kbmhptgzk dvrvwz wa efiohzd."""
        # )
        # self.assertEqual(True, True)
        # # self.assertEqual(result["IsPlaintext?"], True)
