# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AwsPrivatelinkArgs', 'AwsPrivatelink']

@pulumi.input_type
class AwsPrivatelinkArgs:
    def __init__(__self__, *,
                 principals: pulumi.Input[Sequence[pulumi.Input[str]]],
                 project: pulumi.Input[str],
                 service_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a AwsPrivatelink resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] principals: list of allowed principals
        :param pulumi.Input[str] project: identifies the project the service belongs to. To set up proper dependency between the project
               and the service, refer to the project as shown in the above example. Project cannot be changed later without
               destroying and re-creating the service.
        :param pulumi.Input[str] service_name: specifies the actual name of the service. The name cannot be changed later without
               destroying and re-creating the service so name should be picked based on intended service usage rather than current
               attributes.
        """
        pulumi.set(__self__, "principals", principals)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def principals(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        list of allowed principals
        """
        return pulumi.get(self, "principals")

    @principals.setter
    def principals(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "principals", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        identifies the project the service belongs to. To set up proper dependency between the project
        and the service, refer to the project as shown in the above example. Project cannot be changed later without
        destroying and re-creating the service.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        specifies the actual name of the service. The name cannot be changed later without
        destroying and re-creating the service so name should be picked based on intended service usage rather than current
        attributes.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _AwsPrivatelinkState:
    def __init__(__self__, *,
                 aws_service_id: Optional[pulumi.Input[str]] = None,
                 aws_service_name: Optional[pulumi.Input[str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsPrivatelink resources.
        :param pulumi.Input[str] aws_service_id: AWS service ID.
        :param pulumi.Input[str] aws_service_name: AWS service name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] principals: list of allowed principals
        :param pulumi.Input[str] project: identifies the project the service belongs to. To set up proper dependency between the project
               and the service, refer to the project as shown in the above example. Project cannot be changed later without
               destroying and re-creating the service.
        :param pulumi.Input[str] service_name: specifies the actual name of the service. The name cannot be changed later without
               destroying and re-creating the service so name should be picked based on intended service usage rather than current
               attributes.
        """
        if aws_service_id is not None:
            pulumi.set(__self__, "aws_service_id", aws_service_id)
        if aws_service_name is not None:
            pulumi.set(__self__, "aws_service_name", aws_service_name)
        if principals is not None:
            pulumi.set(__self__, "principals", principals)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="awsServiceId")
    def aws_service_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS service ID.
        """
        return pulumi.get(self, "aws_service_id")

    @aws_service_id.setter
    def aws_service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_service_id", value)

    @property
    @pulumi.getter(name="awsServiceName")
    def aws_service_name(self) -> Optional[pulumi.Input[str]]:
        """
        AWS service name.
        """
        return pulumi.get(self, "aws_service_name")

    @aws_service_name.setter
    def aws_service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_service_name", value)

    @property
    @pulumi.getter
    def principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        list of allowed principals
        """
        return pulumi.get(self, "principals")

    @principals.setter
    def principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "principals", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        identifies the project the service belongs to. To set up proper dependency between the project
        and the service, refer to the project as shown in the above example. Project cannot be changed later without
        destroying and re-creating the service.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        specifies the actual name of the service. The name cannot be changed later without
        destroying and re-creating the service so name should be picked based on intended service usage rather than current
        attributes.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)


class AwsPrivatelink(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # AWS Privatelink Resource

        The AWS Privatelink resource allows the creation and management of Aiven AWS Privatelink for a services.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        foo = aiven.AwsPrivatelink("foo",
            project=data["aiven_project"]["foo"]["project"],
            service_name=aiven_kafka["bar"]["service_name"],
            principals=["arn:aws:iam::012345678901:user/mwf"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] principals: list of allowed principals
        :param pulumi.Input[str] project: identifies the project the service belongs to. To set up proper dependency between the project
               and the service, refer to the project as shown in the above example. Project cannot be changed later without
               destroying and re-creating the service.
        :param pulumi.Input[str] service_name: specifies the actual name of the service. The name cannot be changed later without
               destroying and re-creating the service so name should be picked based on intended service usage rather than current
               attributes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsPrivatelinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # AWS Privatelink Resource

        The AWS Privatelink resource allows the creation and management of Aiven AWS Privatelink for a services.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        foo = aiven.AwsPrivatelink("foo",
            project=data["aiven_project"]["foo"]["project"],
            service_name=aiven_kafka["bar"]["service_name"],
            principals=["arn:aws:iam::012345678901:user/mwf"])
        ```

        :param str resource_name: The name of the resource.
        :param AwsPrivatelinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsPrivatelinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsPrivatelinkArgs.__new__(AwsPrivatelinkArgs)

            if principals is None and not opts.urn:
                raise TypeError("Missing required property 'principals'")
            __props__.__dict__["principals"] = principals
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["aws_service_id"] = None
            __props__.__dict__["aws_service_name"] = None
        super(AwsPrivatelink, __self__).__init__(
            'aiven:index/awsPrivatelink:AwsPrivatelink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_service_id: Optional[pulumi.Input[str]] = None,
            aws_service_name: Optional[pulumi.Input[str]] = None,
            principals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None) -> 'AwsPrivatelink':
        """
        Get an existing AwsPrivatelink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aws_service_id: AWS service ID.
        :param pulumi.Input[str] aws_service_name: AWS service name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] principals: list of allowed principals
        :param pulumi.Input[str] project: identifies the project the service belongs to. To set up proper dependency between the project
               and the service, refer to the project as shown in the above example. Project cannot be changed later without
               destroying and re-creating the service.
        :param pulumi.Input[str] service_name: specifies the actual name of the service. The name cannot be changed later without
               destroying and re-creating the service so name should be picked based on intended service usage rather than current
               attributes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsPrivatelinkState.__new__(_AwsPrivatelinkState)

        __props__.__dict__["aws_service_id"] = aws_service_id
        __props__.__dict__["aws_service_name"] = aws_service_name
        __props__.__dict__["principals"] = principals
        __props__.__dict__["project"] = project
        __props__.__dict__["service_name"] = service_name
        return AwsPrivatelink(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsServiceId")
    def aws_service_id(self) -> pulumi.Output[str]:
        """
        AWS service ID.
        """
        return pulumi.get(self, "aws_service_id")

    @property
    @pulumi.getter(name="awsServiceName")
    def aws_service_name(self) -> pulumi.Output[str]:
        """
        AWS service name.
        """
        return pulumi.get(self, "aws_service_name")

    @property
    @pulumi.getter
    def principals(self) -> pulumi.Output[Sequence[str]]:
        """
        list of allowed principals
        """
        return pulumi.get(self, "principals")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        identifies the project the service belongs to. To set up proper dependency between the project
        and the service, refer to the project as shown in the above example. Project cannot be changed later without
        destroying and re-creating the service.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        specifies the actual name of the service. The name cannot be changed later without
        destroying and re-creating the service so name should be picked based on intended service usage rather than current
        attributes.
        """
        return pulumi.get(self, "service_name")

