# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetConnectionPoolResult',
    'AwaitableGetConnectionPoolResult',
    'get_connection_pool',
]

@pulumi.output_type
class GetConnectionPoolResult:
    """
    A collection of values returned by getConnectionPool.
    """
    def __init__(__self__, connection_uri=None, database_name=None, id=None, pool_mode=None, pool_name=None, pool_size=None, project=None, service_name=None, username=None):
        if connection_uri and not isinstance(connection_uri, str):
            raise TypeError("Expected argument 'connection_uri' to be a str")
        pulumi.set(__self__, "connection_uri", connection_uri)
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if pool_mode and not isinstance(pool_mode, str):
            raise TypeError("Expected argument 'pool_mode' to be a str")
        pulumi.set(__self__, "pool_mode", pool_mode)
        if pool_name and not isinstance(pool_name, str):
            raise TypeError("Expected argument 'pool_name' to be a str")
        pulumi.set(__self__, "pool_name", pool_name)
        if pool_size and not isinstance(pool_size, int):
            raise TypeError("Expected argument 'pool_size' to be a int")
        pulumi.set(__self__, "pool_size", pool_size)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="connectionUri")
    def connection_uri(self) -> str:
        """
        is a computed property that tells the URI for connecting to the pool.
        This value cannot be set, only read.
        """
        return pulumi.get(self, "connection_uri")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        is the name of the database the pool connects to. This should be
        defined using reference as shown above to set up dependencies correctly.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="poolMode")
    def pool_mode(self) -> Optional[str]:
        """
        is the mode the pool operates in (session, transaction, statement).
        """
        return pulumi.get(self, "pool_mode")

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> str:
        return pulumi.get(self, "pool_name")

    @property
    @pulumi.getter(name="poolSize")
    def pool_size(self) -> Optional[int]:
        """
        is the number of connections the pool may create towards the backend
        server. This does not affect the number of incoming connections, which is always a much
        larger number.
        """
        return pulumi.get(self, "pool_size")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        is the name of the service user used to connect to the database. This should
        be defined using reference as shown above to set up dependencies correctly.
        """
        return pulumi.get(self, "username")


class AwaitableGetConnectionPoolResult(GetConnectionPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionPoolResult(
            connection_uri=self.connection_uri,
            database_name=self.database_name,
            id=self.id,
            pool_mode=self.pool_mode,
            pool_name=self.pool_name,
            pool_size=self.pool_size,
            project=self.project,
            service_name=self.service_name,
            username=self.username)


def get_connection_pool(connection_uri: Optional[str] = None,
                        database_name: Optional[str] = None,
                        pool_mode: Optional[str] = None,
                        pool_name: Optional[str] = None,
                        pool_size: Optional[int] = None,
                        project: Optional[str] = None,
                        service_name: Optional[str] = None,
                        username: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionPoolResult:
    """
    ## # Connection Pool Data Source

    The Connection Pool data source provides information about the existing Aiven Connection Pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    mytestpool = aiven.get_connection_pool(project=aiven_project["myproject"]["project"],
        service_name=aiven_service["myservice"]["service_name"],
        pool_name="mypool")
    ```


    :param str connection_uri: is a computed property that tells the URI for connecting to the pool.
           This value cannot be set, only read.
    :param str database_name: is the name of the database the pool connects to. This should be
           defined using reference as shown above to set up dependencies correctly.
    :param str pool_mode: is the mode the pool operates in (session, transaction, statement).
    :param str pool_name: is the name of the pool.
    :param int pool_size: is the number of connections the pool may create towards the backend
           server. This does not affect the number of incoming connections, which is always a much
           larger number.
    :param str project: and `service_name` - (Required) define the project and service the connection pool
           belongs to. They should be defined using reference as shown above to set up dependencies
           correctly. These properties cannot be changed once the service is created. Doing so will
           result in the connection pool being deleted and new one created instead.
    :param str username: is the name of the service user used to connect to the database. This should
           be defined using reference as shown above to set up dependencies correctly.
    """
    __args__ = dict()
    __args__['connectionUri'] = connection_uri
    __args__['databaseName'] = database_name
    __args__['poolMode'] = pool_mode
    __args__['poolName'] = pool_name
    __args__['poolSize'] = pool_size
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['username'] = username
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aiven:index/getConnectionPool:getConnectionPool', __args__, opts=opts, typ=GetConnectionPoolResult).value

    return AwaitableGetConnectionPoolResult(
        connection_uri=__ret__.connection_uri,
        database_name=__ret__.database_name,
        id=__ret__.id,
        pool_mode=__ret__.pool_mode,
        pool_name=__ret__.pool_name,
        pool_size=__ret__.pool_size,
        project=__ret__.project,
        service_name=__ret__.service_name,
        username=__ret__.username)
