# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['M3AggregatorArgs', 'M3Aggregator']

@pulumi.input_type
class M3AggregatorArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 m3aggregator: Optional[pulumi.Input['M3AggregatorM3aggregatorArgs']] = None,
                 m3aggregator_user_config: Optional[pulumi.Input['M3AggregatorM3aggregatorUserConfigArgs']] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input['M3AggregatorServiceIntegrationArgs']]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a M3Aggregator resource.
        :param pulumi.Input[str] project: identifies the project the service belongs to. To set up proper dependency
               between the project and the service, refer to the project as shown in the above example.
               Project cannot be changed later without destroying and re-creating the service.
        :param pulumi.Input[str] service_name: specifies the actual name of the service. The name cannot be changed
               later without destroying and re-creating the service so name should be picked based on
               intended service usage rather than current attributes.
        :param pulumi.Input[str] cloud_name: defines where the cloud provider and region where the service is hosted
               in. This can be changed freely after service is created. Changing the value will trigger
               a potentially lengthy migration process for the service. Format is cloud provider name
               (`aws`, `azure`, `do` `google`, `upcloud`, etc.), dash, and the cloud provider
               specific region name. These are documented on each Cloud provider's own support articles,
               like [here for Google](https://cloud.google.com/compute/docs/regions-zones/) and
               [here for AWS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
        :param pulumi.Input['M3AggregatorM3aggregatorArgs'] m3aggregator: M3 Aggregator specific server provided values.
        :param pulumi.Input['M3AggregatorM3aggregatorUserConfigArgs'] m3aggregator_user_config: defines M3 Aggregator specific additional configuration options. 
               The following configuration options available:
        :param pulumi.Input[str] maintenance_window_dow: day of week when maintenance operations should be performed. 
               On monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: time of day when maintenance operations should be performed. 
               UTC time in HH:mm:ss format.
        :param pulumi.Input[str] plan: defines what kind of computing resources are allocated for the service. It can
               be changed after creation, though there are some restrictions when going to a smaller
               plan such as the new plan must have sufficient amount of disk space to store all current
               data and switching to a plan with fewer nodes might not be supported. The basic plan
               names are `hobbyist`, `startup-x`, `business-x` and `premium-x` where `x` is
               (roughly) the amount of memory on each node (also other attributes like number of CPUs
               and amount of disk space varies but naming is based on memory). The available options can be seem from the [Aiven pricing page](https://aiven.io/pricing).
        :param pulumi.Input[str] project_vpc_id: optionally specifies the VPC the service should run in. If the value
               is not set the service is not run inside a VPC. When set, the value should be given as a
               reference as shown above to set up dependencies correctly and the VPC must be in the same
               cloud and region as the service itself. Project can be freely moved to and from VPC after
               creation but doing so triggers migration to new servers so the operation can take
               significant amount of time to complete if the service has a lot of data.
        :param pulumi.Input[Sequence[pulumi.Input['M3AggregatorServiceIntegrationArgs']]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[bool] termination_protection: prevents the service from being deleted. It is recommended to
               set this to `true` for all production services to prevent unintentional service
               deletion. This does not shield against deleting databases or topics but for services
               with backups much of the content can at least be restored from backup in case accidental
               deletion is done.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        if cloud_name is not None:
            pulumi.set(__self__, "cloud_name", cloud_name)
        if m3aggregator is not None:
            pulumi.set(__self__, "m3aggregator", m3aggregator)
        if m3aggregator_user_config is not None:
            pulumi.set(__self__, "m3aggregator_user_config", m3aggregator_user_config)
        if maintenance_window_dow is not None:
            pulumi.set(__self__, "maintenance_window_dow", maintenance_window_dow)
        if maintenance_window_time is not None:
            pulumi.set(__self__, "maintenance_window_time", maintenance_window_time)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if project_vpc_id is not None:
            pulumi.set(__self__, "project_vpc_id", project_vpc_id)
        if service_integrations is not None:
            pulumi.set(__self__, "service_integrations", service_integrations)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        identifies the project the service belongs to. To set up proper dependency
        between the project and the service, refer to the project as shown in the above example.
        Project cannot be changed later without destroying and re-creating the service.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        specifies the actual name of the service. The name cannot be changed
        later without destroying and re-creating the service so name should be picked based on
        intended service usage rather than current attributes.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> Optional[pulumi.Input[str]]:
        """
        defines where the cloud provider and region where the service is hosted
        in. This can be changed freely after service is created. Changing the value will trigger
        a potentially lengthy migration process for the service. Format is cloud provider name
        (`aws`, `azure`, `do` `google`, `upcloud`, etc.), dash, and the cloud provider
        specific region name. These are documented on each Cloud provider's own support articles,
        like [here for Google](https://cloud.google.com/compute/docs/regions-zones/) and
        [here for AWS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
        """
        return pulumi.get(self, "cloud_name")

    @cloud_name.setter
    def cloud_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_name", value)

    @property
    @pulumi.getter
    def m3aggregator(self) -> Optional[pulumi.Input['M3AggregatorM3aggregatorArgs']]:
        """
        M3 Aggregator specific server provided values.
        """
        return pulumi.get(self, "m3aggregator")

    @m3aggregator.setter
    def m3aggregator(self, value: Optional[pulumi.Input['M3AggregatorM3aggregatorArgs']]):
        pulumi.set(self, "m3aggregator", value)

    @property
    @pulumi.getter(name="m3aggregatorUserConfig")
    def m3aggregator_user_config(self) -> Optional[pulumi.Input['M3AggregatorM3aggregatorUserConfigArgs']]:
        """
        defines M3 Aggregator specific additional configuration options. 
        The following configuration options available:
        """
        return pulumi.get(self, "m3aggregator_user_config")

    @m3aggregator_user_config.setter
    def m3aggregator_user_config(self, value: Optional[pulumi.Input['M3AggregatorM3aggregatorUserConfigArgs']]):
        pulumi.set(self, "m3aggregator_user_config", value)

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> Optional[pulumi.Input[str]]:
        """
        day of week when maintenance operations should be performed. 
        On monday, tuesday, wednesday, etc.
        """
        return pulumi.get(self, "maintenance_window_dow")

    @maintenance_window_dow.setter
    def maintenance_window_dow(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_dow", value)

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> Optional[pulumi.Input[str]]:
        """
        time of day when maintenance operations should be performed. 
        UTC time in HH:mm:ss format.
        """
        return pulumi.get(self, "maintenance_window_time")

    @maintenance_window_time.setter
    def maintenance_window_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_time", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        defines what kind of computing resources are allocated for the service. It can
        be changed after creation, though there are some restrictions when going to a smaller
        plan such as the new plan must have sufficient amount of disk space to store all current
        data and switching to a plan with fewer nodes might not be supported. The basic plan
        names are `hobbyist`, `startup-x`, `business-x` and `premium-x` where `x` is
        (roughly) the amount of memory on each node (also other attributes like number of CPUs
        and amount of disk space varies but naming is based on memory). The available options can be seem from the [Aiven pricing page](https://aiven.io/pricing).
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="projectVpcId")
    def project_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        optionally specifies the VPC the service should run in. If the value
        is not set the service is not run inside a VPC. When set, the value should be given as a
        reference as shown above to set up dependencies correctly and the VPC must be in the same
        cloud and region as the service itself. Project can be freely moved to and from VPC after
        creation but doing so triggers migration to new servers so the operation can take
        significant amount of time to complete if the service has a lot of data.
        """
        return pulumi.get(self, "project_vpc_id")

    @project_vpc_id.setter
    def project_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_vpc_id", value)

    @property
    @pulumi.getter(name="serviceIntegrations")
    def service_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['M3AggregatorServiceIntegrationArgs']]]]:
        """
        Service integrations to specify when creating a service. Not applied after initial service creation
        """
        return pulumi.get(self, "service_integrations")

    @service_integrations.setter
    def service_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['M3AggregatorServiceIntegrationArgs']]]]):
        pulumi.set(self, "service_integrations", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        prevents the service from being deleted. It is recommended to
        set this to `true` for all production services to prevent unintentional service
        deletion. This does not shield against deleting databases or topics but for services
        with backups much of the content can at least be restored from backup in case accidental
        deletion is done.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection", value)


@pulumi.input_type
class _M3AggregatorState:
    def __init__(__self__, *,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input['M3AggregatorComponentArgs']]]] = None,
                 m3aggregator: Optional[pulumi.Input['M3AggregatorM3aggregatorArgs']] = None,
                 m3aggregator_user_config: Optional[pulumi.Input['M3AggregatorM3aggregatorUserConfigArgs']] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 service_host: Optional[pulumi.Input[str]] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input['M3AggregatorServiceIntegrationArgs']]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 service_password: Optional[pulumi.Input[str]] = None,
                 service_port: Optional[pulumi.Input[int]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 service_uri: Optional[pulumi.Input[str]] = None,
                 service_username: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering M3Aggregator resources.
        :param pulumi.Input[str] cloud_name: defines where the cloud provider and region where the service is hosted
               in. This can be changed freely after service is created. Changing the value will trigger
               a potentially lengthy migration process for the service. Format is cloud provider name
               (`aws`, `azure`, `do` `google`, `upcloud`, etc.), dash, and the cloud provider
               specific region name. These are documented on each Cloud provider's own support articles,
               like [here for Google](https://cloud.google.com/compute/docs/regions-zones/) and
               [here for AWS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
        :param pulumi.Input[Sequence[pulumi.Input['M3AggregatorComponentArgs']]] components: Service component information objects
        :param pulumi.Input['M3AggregatorM3aggregatorArgs'] m3aggregator: M3 Aggregator specific server provided values.
        :param pulumi.Input['M3AggregatorM3aggregatorUserConfigArgs'] m3aggregator_user_config: defines M3 Aggregator specific additional configuration options. 
               The following configuration options available:
        :param pulumi.Input[str] maintenance_window_dow: day of week when maintenance operations should be performed. 
               On monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: time of day when maintenance operations should be performed. 
               UTC time in HH:mm:ss format.
        :param pulumi.Input[str] plan: defines what kind of computing resources are allocated for the service. It can
               be changed after creation, though there are some restrictions when going to a smaller
               plan such as the new plan must have sufficient amount of disk space to store all current
               data and switching to a plan with fewer nodes might not be supported. The basic plan
               names are `hobbyist`, `startup-x`, `business-x` and `premium-x` where `x` is
               (roughly) the amount of memory on each node (also other attributes like number of CPUs
               and amount of disk space varies but naming is based on memory). The available options can be seem from the [Aiven pricing page](https://aiven.io/pricing).
        :param pulumi.Input[str] project: identifies the project the service belongs to. To set up proper dependency
               between the project and the service, refer to the project as shown in the above example.
               Project cannot be changed later without destroying and re-creating the service.
        :param pulumi.Input[str] project_vpc_id: optionally specifies the VPC the service should run in. If the value
               is not set the service is not run inside a VPC. When set, the value should be given as a
               reference as shown above to set up dependencies correctly and the VPC must be in the same
               cloud and region as the service itself. Project can be freely moved to and from VPC after
               creation but doing so triggers migration to new servers so the operation can take
               significant amount of time to complete if the service has a lot of data.
        :param pulumi.Input[str] service_host: M3 Aggregator hostname.
        :param pulumi.Input[Sequence[pulumi.Input['M3AggregatorServiceIntegrationArgs']]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: specifies the actual name of the service. The name cannot be changed
               later without destroying and re-creating the service so name should be picked based on
               intended service usage rather than current attributes.
        :param pulumi.Input[str] service_password: Password used for connecting to the M3 Aggregator service, if applicable.
        :param pulumi.Input[int] service_port: M3 Aggregator port.
        :param pulumi.Input[str] service_type: Aiven internal service type code
        :param pulumi.Input[str] service_uri: URI for connecting to the M3 Aggregator service.
        :param pulumi.Input[str] service_username: Username used for connecting to the M3 Aggregator service, if applicable.
        :param pulumi.Input[str] state: Service state.
        :param pulumi.Input[bool] termination_protection: prevents the service from being deleted. It is recommended to
               set this to `true` for all production services to prevent unintentional service
               deletion. This does not shield against deleting databases or topics but for services
               with backups much of the content can at least be restored from backup in case accidental
               deletion is done.
        """
        if cloud_name is not None:
            pulumi.set(__self__, "cloud_name", cloud_name)
        if components is not None:
            pulumi.set(__self__, "components", components)
        if m3aggregator is not None:
            pulumi.set(__self__, "m3aggregator", m3aggregator)
        if m3aggregator_user_config is not None:
            pulumi.set(__self__, "m3aggregator_user_config", m3aggregator_user_config)
        if maintenance_window_dow is not None:
            pulumi.set(__self__, "maintenance_window_dow", maintenance_window_dow)
        if maintenance_window_time is not None:
            pulumi.set(__self__, "maintenance_window_time", maintenance_window_time)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_vpc_id is not None:
            pulumi.set(__self__, "project_vpc_id", project_vpc_id)
        if service_host is not None:
            pulumi.set(__self__, "service_host", service_host)
        if service_integrations is not None:
            pulumi.set(__self__, "service_integrations", service_integrations)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_password is not None:
            pulumi.set(__self__, "service_password", service_password)
        if service_port is not None:
            pulumi.set(__self__, "service_port", service_port)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)
        if service_username is not None:
            pulumi.set(__self__, "service_username", service_username)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> Optional[pulumi.Input[str]]:
        """
        defines where the cloud provider and region where the service is hosted
        in. This can be changed freely after service is created. Changing the value will trigger
        a potentially lengthy migration process for the service. Format is cloud provider name
        (`aws`, `azure`, `do` `google`, `upcloud`, etc.), dash, and the cloud provider
        specific region name. These are documented on each Cloud provider's own support articles,
        like [here for Google](https://cloud.google.com/compute/docs/regions-zones/) and
        [here for AWS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
        """
        return pulumi.get(self, "cloud_name")

    @cloud_name.setter
    def cloud_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_name", value)

    @property
    @pulumi.getter
    def components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['M3AggregatorComponentArgs']]]]:
        """
        Service component information objects
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['M3AggregatorComponentArgs']]]]):
        pulumi.set(self, "components", value)

    @property
    @pulumi.getter
    def m3aggregator(self) -> Optional[pulumi.Input['M3AggregatorM3aggregatorArgs']]:
        """
        M3 Aggregator specific server provided values.
        """
        return pulumi.get(self, "m3aggregator")

    @m3aggregator.setter
    def m3aggregator(self, value: Optional[pulumi.Input['M3AggregatorM3aggregatorArgs']]):
        pulumi.set(self, "m3aggregator", value)

    @property
    @pulumi.getter(name="m3aggregatorUserConfig")
    def m3aggregator_user_config(self) -> Optional[pulumi.Input['M3AggregatorM3aggregatorUserConfigArgs']]:
        """
        defines M3 Aggregator specific additional configuration options. 
        The following configuration options available:
        """
        return pulumi.get(self, "m3aggregator_user_config")

    @m3aggregator_user_config.setter
    def m3aggregator_user_config(self, value: Optional[pulumi.Input['M3AggregatorM3aggregatorUserConfigArgs']]):
        pulumi.set(self, "m3aggregator_user_config", value)

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> Optional[pulumi.Input[str]]:
        """
        day of week when maintenance operations should be performed. 
        On monday, tuesday, wednesday, etc.
        """
        return pulumi.get(self, "maintenance_window_dow")

    @maintenance_window_dow.setter
    def maintenance_window_dow(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_dow", value)

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> Optional[pulumi.Input[str]]:
        """
        time of day when maintenance operations should be performed. 
        UTC time in HH:mm:ss format.
        """
        return pulumi.get(self, "maintenance_window_time")

    @maintenance_window_time.setter
    def maintenance_window_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_time", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        defines what kind of computing resources are allocated for the service. It can
        be changed after creation, though there are some restrictions when going to a smaller
        plan such as the new plan must have sufficient amount of disk space to store all current
        data and switching to a plan with fewer nodes might not be supported. The basic plan
        names are `hobbyist`, `startup-x`, `business-x` and `premium-x` where `x` is
        (roughly) the amount of memory on each node (also other attributes like number of CPUs
        and amount of disk space varies but naming is based on memory). The available options can be seem from the [Aiven pricing page](https://aiven.io/pricing).
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        identifies the project the service belongs to. To set up proper dependency
        between the project and the service, refer to the project as shown in the above example.
        Project cannot be changed later without destroying and re-creating the service.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="projectVpcId")
    def project_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        optionally specifies the VPC the service should run in. If the value
        is not set the service is not run inside a VPC. When set, the value should be given as a
        reference as shown above to set up dependencies correctly and the VPC must be in the same
        cloud and region as the service itself. Project can be freely moved to and from VPC after
        creation but doing so triggers migration to new servers so the operation can take
        significant amount of time to complete if the service has a lot of data.
        """
        return pulumi.get(self, "project_vpc_id")

    @project_vpc_id.setter
    def project_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_vpc_id", value)

    @property
    @pulumi.getter(name="serviceHost")
    def service_host(self) -> Optional[pulumi.Input[str]]:
        """
        M3 Aggregator hostname.
        """
        return pulumi.get(self, "service_host")

    @service_host.setter
    def service_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_host", value)

    @property
    @pulumi.getter(name="serviceIntegrations")
    def service_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['M3AggregatorServiceIntegrationArgs']]]]:
        """
        Service integrations to specify when creating a service. Not applied after initial service creation
        """
        return pulumi.get(self, "service_integrations")

    @service_integrations.setter
    def service_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['M3AggregatorServiceIntegrationArgs']]]]):
        pulumi.set(self, "service_integrations", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        specifies the actual name of the service. The name cannot be changed
        later without destroying and re-creating the service so name should be picked based on
        intended service usage rather than current attributes.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password used for connecting to the M3 Aggregator service, if applicable.
        """
        return pulumi.get(self, "service_password")

    @service_password.setter
    def service_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_password", value)

    @property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> Optional[pulumi.Input[int]]:
        """
        M3 Aggregator port.
        """
        return pulumi.get(self, "service_port")

    @service_port.setter
    def service_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "service_port", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[str]]:
        """
        Aiven internal service type code
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI for connecting to the M3 Aggregator service.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_uri", value)

    @property
    @pulumi.getter(name="serviceUsername")
    def service_username(self) -> Optional[pulumi.Input[str]]:
        """
        Username used for connecting to the M3 Aggregator service, if applicable.
        """
        return pulumi.get(self, "service_username")

    @service_username.setter
    def service_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_username", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Service state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        prevents the service from being deleted. It is recommended to
        set this to `true` for all production services to prevent unintentional service
        deletion. This does not shield against deleting databases or topics but for services
        with backups much of the content can at least be restored from backup in case accidental
        deletion is done.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection", value)


class M3Aggregator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 m3aggregator: Optional[pulumi.Input[pulumi.InputType['M3AggregatorM3aggregatorArgs']]] = None,
                 m3aggregator_user_config: Optional[pulumi.Input[pulumi.InputType['M3AggregatorM3aggregatorUserConfigArgs']]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['M3AggregatorServiceIntegrationArgs']]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## # M3 Aggregator Resource

        The M3 Aggregator resource allows the creation and management of Aiven M3 Aggregator services.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        m3a = aiven.M3Aggregator("m3a",
            project=data["aiven_project"]["foo"]["project"],
            cloud_name="google-europe-west1",
            plan="business-8",
            service_name="my-m3a",
            maintenance_window_dow="monday",
            maintenance_window_time="10:00:00",
            m3aggregator_user_config=aiven.M3AggregatorM3aggregatorUserConfigArgs(
                m3aggregator_version="0.15",
            ))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cloud_name: defines where the cloud provider and region where the service is hosted
               in. This can be changed freely after service is created. Changing the value will trigger
               a potentially lengthy migration process for the service. Format is cloud provider name
               (`aws`, `azure`, `do` `google`, `upcloud`, etc.), dash, and the cloud provider
               specific region name. These are documented on each Cloud provider's own support articles,
               like [here for Google](https://cloud.google.com/compute/docs/regions-zones/) and
               [here for AWS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
        :param pulumi.Input[pulumi.InputType['M3AggregatorM3aggregatorArgs']] m3aggregator: M3 Aggregator specific server provided values.
        :param pulumi.Input[pulumi.InputType['M3AggregatorM3aggregatorUserConfigArgs']] m3aggregator_user_config: defines M3 Aggregator specific additional configuration options. 
               The following configuration options available:
        :param pulumi.Input[str] maintenance_window_dow: day of week when maintenance operations should be performed. 
               On monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: time of day when maintenance operations should be performed. 
               UTC time in HH:mm:ss format.
        :param pulumi.Input[str] plan: defines what kind of computing resources are allocated for the service. It can
               be changed after creation, though there are some restrictions when going to a smaller
               plan such as the new plan must have sufficient amount of disk space to store all current
               data and switching to a plan with fewer nodes might not be supported. The basic plan
               names are `hobbyist`, `startup-x`, `business-x` and `premium-x` where `x` is
               (roughly) the amount of memory on each node (also other attributes like number of CPUs
               and amount of disk space varies but naming is based on memory). The available options can be seem from the [Aiven pricing page](https://aiven.io/pricing).
        :param pulumi.Input[str] project: identifies the project the service belongs to. To set up proper dependency
               between the project and the service, refer to the project as shown in the above example.
               Project cannot be changed later without destroying and re-creating the service.
        :param pulumi.Input[str] project_vpc_id: optionally specifies the VPC the service should run in. If the value
               is not set the service is not run inside a VPC. When set, the value should be given as a
               reference as shown above to set up dependencies correctly and the VPC must be in the same
               cloud and region as the service itself. Project can be freely moved to and from VPC after
               creation but doing so triggers migration to new servers so the operation can take
               significant amount of time to complete if the service has a lot of data.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['M3AggregatorServiceIntegrationArgs']]]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: specifies the actual name of the service. The name cannot be changed
               later without destroying and re-creating the service so name should be picked based on
               intended service usage rather than current attributes.
        :param pulumi.Input[bool] termination_protection: prevents the service from being deleted. It is recommended to
               set this to `true` for all production services to prevent unintentional service
               deletion. This does not shield against deleting databases or topics but for services
               with backups much of the content can at least be restored from backup in case accidental
               deletion is done.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: M3AggregatorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # M3 Aggregator Resource

        The M3 Aggregator resource allows the creation and management of Aiven M3 Aggregator services.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        m3a = aiven.M3Aggregator("m3a",
            project=data["aiven_project"]["foo"]["project"],
            cloud_name="google-europe-west1",
            plan="business-8",
            service_name="my-m3a",
            maintenance_window_dow="monday",
            maintenance_window_time="10:00:00",
            m3aggregator_user_config=aiven.M3AggregatorM3aggregatorUserConfigArgs(
                m3aggregator_version="0.15",
            ))
        ```

        :param str resource_name: The name of the resource.
        :param M3AggregatorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(M3AggregatorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 m3aggregator: Optional[pulumi.Input[pulumi.InputType['M3AggregatorM3aggregatorArgs']]] = None,
                 m3aggregator_user_config: Optional[pulumi.Input[pulumi.InputType['M3AggregatorM3aggregatorUserConfigArgs']]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['M3AggregatorServiceIntegrationArgs']]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = M3AggregatorArgs.__new__(M3AggregatorArgs)

            __props__.__dict__["cloud_name"] = cloud_name
            __props__.__dict__["m3aggregator"] = m3aggregator
            __props__.__dict__["m3aggregator_user_config"] = m3aggregator_user_config
            __props__.__dict__["maintenance_window_dow"] = maintenance_window_dow
            __props__.__dict__["maintenance_window_time"] = maintenance_window_time
            __props__.__dict__["plan"] = plan
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["project_vpc_id"] = project_vpc_id
            __props__.__dict__["service_integrations"] = service_integrations
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["termination_protection"] = termination_protection
            __props__.__dict__["components"] = None
            __props__.__dict__["service_host"] = None
            __props__.__dict__["service_password"] = None
            __props__.__dict__["service_port"] = None
            __props__.__dict__["service_type"] = None
            __props__.__dict__["service_uri"] = None
            __props__.__dict__["service_username"] = None
            __props__.__dict__["state"] = None
        super(M3Aggregator, __self__).__init__(
            'aiven:index/m3Aggregator:M3Aggregator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_name: Optional[pulumi.Input[str]] = None,
            components: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['M3AggregatorComponentArgs']]]]] = None,
            m3aggregator: Optional[pulumi.Input[pulumi.InputType['M3AggregatorM3aggregatorArgs']]] = None,
            m3aggregator_user_config: Optional[pulumi.Input[pulumi.InputType['M3AggregatorM3aggregatorUserConfigArgs']]] = None,
            maintenance_window_dow: Optional[pulumi.Input[str]] = None,
            maintenance_window_time: Optional[pulumi.Input[str]] = None,
            plan: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            project_vpc_id: Optional[pulumi.Input[str]] = None,
            service_host: Optional[pulumi.Input[str]] = None,
            service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['M3AggregatorServiceIntegrationArgs']]]]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            service_password: Optional[pulumi.Input[str]] = None,
            service_port: Optional[pulumi.Input[int]] = None,
            service_type: Optional[pulumi.Input[str]] = None,
            service_uri: Optional[pulumi.Input[str]] = None,
            service_username: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            termination_protection: Optional[pulumi.Input[bool]] = None) -> 'M3Aggregator':
        """
        Get an existing M3Aggregator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cloud_name: defines where the cloud provider and region where the service is hosted
               in. This can be changed freely after service is created. Changing the value will trigger
               a potentially lengthy migration process for the service. Format is cloud provider name
               (`aws`, `azure`, `do` `google`, `upcloud`, etc.), dash, and the cloud provider
               specific region name. These are documented on each Cloud provider's own support articles,
               like [here for Google](https://cloud.google.com/compute/docs/regions-zones/) and
               [here for AWS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['M3AggregatorComponentArgs']]]] components: Service component information objects
        :param pulumi.Input[pulumi.InputType['M3AggregatorM3aggregatorArgs']] m3aggregator: M3 Aggregator specific server provided values.
        :param pulumi.Input[pulumi.InputType['M3AggregatorM3aggregatorUserConfigArgs']] m3aggregator_user_config: defines M3 Aggregator specific additional configuration options. 
               The following configuration options available:
        :param pulumi.Input[str] maintenance_window_dow: day of week when maintenance operations should be performed. 
               On monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: time of day when maintenance operations should be performed. 
               UTC time in HH:mm:ss format.
        :param pulumi.Input[str] plan: defines what kind of computing resources are allocated for the service. It can
               be changed after creation, though there are some restrictions when going to a smaller
               plan such as the new plan must have sufficient amount of disk space to store all current
               data and switching to a plan with fewer nodes might not be supported. The basic plan
               names are `hobbyist`, `startup-x`, `business-x` and `premium-x` where `x` is
               (roughly) the amount of memory on each node (also other attributes like number of CPUs
               and amount of disk space varies but naming is based on memory). The available options can be seem from the [Aiven pricing page](https://aiven.io/pricing).
        :param pulumi.Input[str] project: identifies the project the service belongs to. To set up proper dependency
               between the project and the service, refer to the project as shown in the above example.
               Project cannot be changed later without destroying and re-creating the service.
        :param pulumi.Input[str] project_vpc_id: optionally specifies the VPC the service should run in. If the value
               is not set the service is not run inside a VPC. When set, the value should be given as a
               reference as shown above to set up dependencies correctly and the VPC must be in the same
               cloud and region as the service itself. Project can be freely moved to and from VPC after
               creation but doing so triggers migration to new servers so the operation can take
               significant amount of time to complete if the service has a lot of data.
        :param pulumi.Input[str] service_host: M3 Aggregator hostname.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['M3AggregatorServiceIntegrationArgs']]]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: specifies the actual name of the service. The name cannot be changed
               later without destroying and re-creating the service so name should be picked based on
               intended service usage rather than current attributes.
        :param pulumi.Input[str] service_password: Password used for connecting to the M3 Aggregator service, if applicable.
        :param pulumi.Input[int] service_port: M3 Aggregator port.
        :param pulumi.Input[str] service_type: Aiven internal service type code
        :param pulumi.Input[str] service_uri: URI for connecting to the M3 Aggregator service.
        :param pulumi.Input[str] service_username: Username used for connecting to the M3 Aggregator service, if applicable.
        :param pulumi.Input[str] state: Service state.
        :param pulumi.Input[bool] termination_protection: prevents the service from being deleted. It is recommended to
               set this to `true` for all production services to prevent unintentional service
               deletion. This does not shield against deleting databases or topics but for services
               with backups much of the content can at least be restored from backup in case accidental
               deletion is done.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _M3AggregatorState.__new__(_M3AggregatorState)

        __props__.__dict__["cloud_name"] = cloud_name
        __props__.__dict__["components"] = components
        __props__.__dict__["m3aggregator"] = m3aggregator
        __props__.__dict__["m3aggregator_user_config"] = m3aggregator_user_config
        __props__.__dict__["maintenance_window_dow"] = maintenance_window_dow
        __props__.__dict__["maintenance_window_time"] = maintenance_window_time
        __props__.__dict__["plan"] = plan
        __props__.__dict__["project"] = project
        __props__.__dict__["project_vpc_id"] = project_vpc_id
        __props__.__dict__["service_host"] = service_host
        __props__.__dict__["service_integrations"] = service_integrations
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["service_password"] = service_password
        __props__.__dict__["service_port"] = service_port
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["service_uri"] = service_uri
        __props__.__dict__["service_username"] = service_username
        __props__.__dict__["state"] = state
        __props__.__dict__["termination_protection"] = termination_protection
        return M3Aggregator(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> pulumi.Output[Optional[str]]:
        """
        defines where the cloud provider and region where the service is hosted
        in. This can be changed freely after service is created. Changing the value will trigger
        a potentially lengthy migration process for the service. Format is cloud provider name
        (`aws`, `azure`, `do` `google`, `upcloud`, etc.), dash, and the cloud provider
        specific region name. These are documented on each Cloud provider's own support articles,
        like [here for Google](https://cloud.google.com/compute/docs/regions-zones/) and
        [here for AWS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
        """
        return pulumi.get(self, "cloud_name")

    @property
    @pulumi.getter
    def components(self) -> pulumi.Output[Sequence['outputs.M3AggregatorComponent']]:
        """
        Service component information objects
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter
    def m3aggregator(self) -> pulumi.Output['outputs.M3AggregatorM3aggregator']:
        """
        M3 Aggregator specific server provided values.
        """
        return pulumi.get(self, "m3aggregator")

    @property
    @pulumi.getter(name="m3aggregatorUserConfig")
    def m3aggregator_user_config(self) -> pulumi.Output[Optional['outputs.M3AggregatorM3aggregatorUserConfig']]:
        """
        defines M3 Aggregator specific additional configuration options. 
        The following configuration options available:
        """
        return pulumi.get(self, "m3aggregator_user_config")

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> pulumi.Output[Optional[str]]:
        """
        day of week when maintenance operations should be performed. 
        On monday, tuesday, wednesday, etc.
        """
        return pulumi.get(self, "maintenance_window_dow")

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> pulumi.Output[Optional[str]]:
        """
        time of day when maintenance operations should be performed. 
        UTC time in HH:mm:ss format.
        """
        return pulumi.get(self, "maintenance_window_time")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional[str]]:
        """
        defines what kind of computing resources are allocated for the service. It can
        be changed after creation, though there are some restrictions when going to a smaller
        plan such as the new plan must have sufficient amount of disk space to store all current
        data and switching to a plan with fewer nodes might not be supported. The basic plan
        names are `hobbyist`, `startup-x`, `business-x` and `premium-x` where `x` is
        (roughly) the amount of memory on each node (also other attributes like number of CPUs
        and amount of disk space varies but naming is based on memory). The available options can be seem from the [Aiven pricing page](https://aiven.io/pricing).
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        identifies the project the service belongs to. To set up proper dependency
        between the project and the service, refer to the project as shown in the above example.
        Project cannot be changed later without destroying and re-creating the service.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="projectVpcId")
    def project_vpc_id(self) -> pulumi.Output[Optional[str]]:
        """
        optionally specifies the VPC the service should run in. If the value
        is not set the service is not run inside a VPC. When set, the value should be given as a
        reference as shown above to set up dependencies correctly and the VPC must be in the same
        cloud and region as the service itself. Project can be freely moved to and from VPC after
        creation but doing so triggers migration to new servers so the operation can take
        significant amount of time to complete if the service has a lot of data.
        """
        return pulumi.get(self, "project_vpc_id")

    @property
    @pulumi.getter(name="serviceHost")
    def service_host(self) -> pulumi.Output[str]:
        """
        M3 Aggregator hostname.
        """
        return pulumi.get(self, "service_host")

    @property
    @pulumi.getter(name="serviceIntegrations")
    def service_integrations(self) -> pulumi.Output[Optional[Sequence['outputs.M3AggregatorServiceIntegration']]]:
        """
        Service integrations to specify when creating a service. Not applied after initial service creation
        """
        return pulumi.get(self, "service_integrations")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        specifies the actual name of the service. The name cannot be changed
        later without destroying and re-creating the service so name should be picked based on
        intended service usage rather than current attributes.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> pulumi.Output[str]:
        """
        Password used for connecting to the M3 Aggregator service, if applicable.
        """
        return pulumi.get(self, "service_password")

    @property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> pulumi.Output[int]:
        """
        M3 Aggregator port.
        """
        return pulumi.get(self, "service_port")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[str]:
        """
        Aiven internal service type code
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> pulumi.Output[str]:
        """
        URI for connecting to the M3 Aggregator service.
        """
        return pulumi.get(self, "service_uri")

    @property
    @pulumi.getter(name="serviceUsername")
    def service_username(self) -> pulumi.Output[str]:
        """
        Username used for connecting to the M3 Aggregator service, if applicable.
        """
        return pulumi.get(self, "service_username")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Service state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        prevents the service from being deleted. It is recommended to
        set this to `true` for all production services to prevent unintentional service
        deletion. This does not shield against deleting databases or topics but for services
        with backups much of the content can at least be restored from backup in case accidental
        deletion is done.
        """
        return pulumi.get(self, "termination_protection")

