#!/usr/bin/env python3.8
# @generated by pegen from ../../mingshe.gram

import ast
import sys
import tokenize

from typing import Any, Optional

from pegen.parser import memoize, memoize_left_rec, logger, Parser

import io
import itertools
import os
import sys
import token
from typing import (
    Any, Callable, Iterator, List, Literal, Tuple, TypeVar, Union, NoReturn
)

from pegen.tokenizer import Tokenizer

# Singleton ast nodes, created once for efficiency
Load = ast.Load()
Store = ast.Store()
Del = ast.Del()

Node = TypeVar("Node")
FC = TypeVar("FC", ast.FunctionDef, ast.AsyncFunctionDef, ast.ClassDef)

EXPR_NAME_MAPPING = {
    ast.Attribute: "attribute",
    ast.Subscript: "subscript",
    ast.Starred: "starred",
    ast.Name: "name",
    ast.List: "list",
    ast.Tuple: "tuple",
    ast.Lambda: "lambda",
    ast.Call: "function call",
    ast.BoolOp: "expression",
    ast.BinOp: "expression",
    ast.UnaryOp: "expression",
    ast.GeneratorExp: "generator expression",
    ast.Yield: "yield expression",
    ast.YieldFrom: "yield expression",
    ast.Await: "await expression",
    ast.ListComp: "list comprehension",
    ast.SetComp: "set comprehension",
    ast.DictComp: "dict comprehension",
    ast.Dict: "dict literal",
    ast.Set: "set display",
    ast.JoinedStr: "f-string expression",
    ast.FormattedValue: "f-string expression",
    ast.Compare: "comparison",
    ast.IfExp: "conditional expression",
    ast.NamedExpr: "named expression",
}


def parse_file(
    path: str,
    py_version: Optional[tuple]=None,
    token_stream_factory: Optional[
        Callable[[Callable[[], str]], Iterator[tokenize.TokenInfo]]
    ] = None,
    verbose:bool = False,
) -> ast.Module:
    """Parse a file."""
    with open(path) as f:
        tok_stream = (
            token_stream_factory(f.readline)
            if token_stream_factory else
            tokenize.generate_tokens(f.readline)
        )
        tokenizer = Tokenizer(tok_stream, verbose=verbose, path=path)
        parser = PythonParser(
            tokenizer,
            verbose=verbose,
            filename=os.path.basename(path),
            py_version=py_version
        )
        return parser.parse("file")


def parse_string(
    source: str,
    mode: Union[Literal["eval"], Literal["exec"]],
    py_version: Optional[tuple]=None,
    token_stream_factory: Optional[
        Callable[[Callable[[], str]], Iterator[tokenize.TokenInfo]]
    ] = None,
    verbose:bool = False,
) -> Any:
    """Parse a string."""
    tok_stream = (
        token_stream_factory(io.StringIO(source).readline)
        if token_stream_factory else
        tokenize.generate_tokens(io.StringIO(source).readline)
    )
    tokenizer = Tokenizer(tok_stream, verbose=verbose)
    parser = PythonParser(tokenizer, verbose=verbose, py_version=py_version)
    return parser.parse(mode if mode == "eval" else "file")


class Parser(Parser):

    #: Name of the source file, used in error reports
    filename : str

    def __init__(self,
        tokenizer: Tokenizer, *,
        verbose: bool = False,
        filename: str = "<unknown>",
        py_version: Optional[tuple] = None,
    ) -> None:
        super().__init__(tokenizer, verbose=verbose)
        self.filename = filename
        self.py_version = min(py_version, sys.version_info) if py_version else sys.version_info
        self._exception = None

    def parse(self, rule: str) -> Optional[ast.AST]:
        res = getattr(self, rule)()
        if res is None:
            if self._exception is not None:
                raise self._exception
            else:
                raise SyntaxError("invalid syntax")

        return res

    def check_version(self, min_version: Tuple[int, ...], error_msg: str, node: Node) -> Node:
        """Check that the python version is high enough for a rule to apply.

        """
        if self.py_version >= min_version:
            return node
        else:
            raise SyntaxError(
                f"{error_msg} only supported in Python {min_version} and above."
            )

    def raise_indentation_error(self, msg) -> None:
        """Raise an indentation error."""
        raise IndentationError(msg)

    def get_expr_name(self, node) -> str:
        """Get a descriptive name for an expression."""
        # See https://github.com/python/cpython/blob/master/Parser/pegen.c#L161
        assert node is not None
        node_t = type(node)
        if node_t is ast.Constant:
            v = node.value
            if v in (None, True, False, Ellipsis):
                return str(v)
            else:
                return "literal"

        try:
            return EXPR_NAME_MAPPING[node_t]
        except KeyError:
            raise ValueError(
                f"unexpected expression in assignment {type(node).__name__} "
                f"(line {node.lineno})."
            )

    def set_expr_context(self, node, context):
        """Set the context (Load, Store, Del) of an ast node."""
        node.ctx = context
        return node

    def ensure_real(self, number_str: str):
        number = ast.literal_eval(number_str)
        if number is not complex:
            self.store_syntax_error("real number required in complex literal")
        return number

    def ensure_imaginary(self, number_str: str):
        number = ast.literal_eval(number_str)
        if number is not complex:
            self.store_syntax_error("imaginary  number required in complex literal")
        return number

    def generate_ast_for_string(self, tokens):
        """Generate AST nodes for strings."""
        err_msg = ''
        line = 1
        col_offset = 0
        source = ''
        for t in tokens:
            n_line = t.start[0] - line
            if n_line:
                col_offset = 0
            source += """
""" * n_line + ' ' * (t.start[1] - col_offset) + t.string
            line, col_offset = t.end
        if source[0] == ' ':
            source = '(' + source[1:]
        else:
            source = '(' + source
        source += ')'
        try:
            m = ast.parse(source)
        except SyntaxError as e:
            err_msg = e.args[0]
            # Identify the line at which the error occurred to get a more
            # accurate line number
            for t in tokens:
                try:
                    m = ast.parse(t.string)
                except SyntaxError:
                    break

        # Avoid getting a triple nesting in the error report that does not
        # bring anything relevant to the traceback.
        if err_msg:
            self.store_syntax_error_known_location(err_msg, t)
            raise self._exception

        return m.body[0].value

    def extract_import_level(self, tokens: List[tokenize.TokenInfo]) -> int:
        """Extract the relative import level from the tokens preceding the module name.

        '.' count for one and '...' for 3.

        """
        level = 0
        for t in tokens:
            if t.string == ".":
                level += 1
            else:
                level += 3
        return level

    def set_decorators(self,
        target: FC,
        decorators: list
    ) -> FC:
        """Set the decorators on a function or class definition."""
        target.decorator_list = decorators
        return target

    def get_comparison_ops(self, pairs):
        return [op for op, _ in pairs]

    def get_comparators(self, pairs):
        return [comp for _, comp in pairs]

    def set_arg_type_comment(self, arg, type_comment):
        if type_comment or sys.version_info < (3, 9):
            arg.type_comment = type_comment
        return arg

    def make_partial_function(self,
        func: ast.Name,
        arguments: Tuple[list, list],
        **locations,
    ) -> Union[ast.Lambda, ast.Call]:
        """"Build a partial function"""
        args = arguments[0] if arguments else []
        kwargs = arguments[1] if arguments else []
        q_count = 0
        bind_args = []
        bind_kwargs = []
        for i in range(len(args)):
            if args[i] == "?":
                args[i] = ast.Name(id=f"_{q_count}", ctx=Load, **locations)
                q_count += 1
            elif isinstance(args[i], ast.Starred) and args[i].value == "?":
                args[i] = ast.Starred(
                    value=ast.Name(id=f"_{q_count}", ctx=Load, **locations),
                    ctx=Load,
                    **locations,
                )
                q_count += 1
            elif isinstance(args[i], ast.Constant):
                continue
            else:
                bind_args.append(args[i])
                args[i] = ast.Name(id=f"_p_{len(bind_args)-1}", ctx=Load, **locations)
        for i in range(len(kwargs)):
            if kwargs[i].value == "?":
                kwargs[i] = ast.keyword(
                    arg=kwargs[i].arg,
                    value=ast.Name(id=f"_{q_count}", ctx=Load, **locations),
                    **locations,
                )
                q_count += 1
            elif isinstance(kwargs[i].value, ast.Constant):
                continue
            else:
                bind_kwargs.append(kwargs[i])
                kwargs[i] = ast.keyword(
                    arg=kwargs[i].arg,
                    value=ast.Name(id=kwargs[i].arg, ctx=Load, **locations),
                    **locations,
                )

        result = ast.Call(func=func, args=args, keywords=kwargs, **locations)
        if q_count > 0:
            lambda_body = ast.Lambda(
                args=ast.arguments(
                    args=[ast.arg(arg=f"_{i}", **locations) for i in range(q_count)],
                    posonlyargs=[], kwonlyargs=[], defaults=[], vararg=None, kw_defaults=[], kwarg=None,
                    **locations,
                ),
                body=result,
                **locations,
            )
            result = ast.Call(
                func=ast.Lambda(
                    args=ast.arguments(
                        args=[ast.arg(arg=f"_p_{i}", **locations) for i in range(len(bind_args))]
                             + [ast.arg(arg=func.id, **locations)]
                             + [ast.arg(arg=bind_kwargs[i].arg, **locations) for i in range(len(bind_kwargs))],
                        posonlyargs=[], kwonlyargs=[], kw_defaults=[], defaults=[], vararg=None, kwarg=None,
                        **locations,
                    ),
                    body=lambda_body,
                    **locations,
                ),
                args=bind_args + [func],
                keywords=bind_kwargs,
                **locations,
            )
        return result

    def make_nullish_coalescing(self, array, **locations):
        result = array[0]
        for i, item in enumerate(array[1:]):
            if i == 0:
                if_not_null = ast.Compare(left=result, ops=[ast.IsNot()], comparators=[ast.Constant(value=None, **locations)], **locations)
                result = ast.IfExp(body=result, test=if_not_null, orelse=item, **locations)
            else:
                self.check_version((3, 8), "Chained use of ??", None)
                temporary = ast.NamedExpr(target=ast.Name(id=f'_{i}', ctx=Store, **locations), value=result, **locations)
                if_not_null = ast.Compare(left=temporary, ops=[ast.IsNot()], comparators=[ast.Constant(value=None, **locations)], **locations)
                result = ast.IfExp(body=ast.Name(id=f'_{i}', ctx=Load, **locations), test=if_not_null, orelse=item, **locations)
        return result

    def make_optional_chaining(self, left, node, **locations):
        if isinstance(left, ast.IfExp) and getattr(left, "_is_optional_chaining", False):
            self.check_version((3, 8), "Chained use of ?.", None)
            temporary = ast.NamedExpr(target=ast.Name(id='_', ctx=Store, **locations), value=left, **locations)
            if isinstance(node, ast.Call):
                node.func.value = ast.Name(id='_', ctx=Load, **locations)
            elif isinstance(node, ast.Attribute):
                node.value = ast.Name(id='_', ctx=Load, **locations)
            elif isinstance(node, ast.Subscript):
                node.value = ast.Name(id='_', ctx=Load, **locations)
        else:
            temporary = left
        if_null = ast.Compare(left=temporary, ops=[ast.Is()], comparators=[ast.Constant(value=None, **locations)], **locations)
        result = ast.IfExp(body=ast.Constant(value=None, **locations), test=if_null, orelse=node, **locations)
        result._is_optional_chaining = True
        return result

    def make_arguments(self,
        pos_only: Optional[List[Tuple[ast.arg, None]]],
        pos_only_with_default: List[Tuple[ast.arg, Any]],
        param_no_default: Optional[List[Tuple[ast.arg, None]]],
        param_default: Optional[List[Tuple[ast.arg, Any]]],
        after_star: Optional[Tuple[Optional[ast.arg], List[Tuple[ast.arg, Any]], Optional[ast.arg]]]
    ) -> ast.arguments:
        """Build a function definition arguments."""
        defaults = (
            [d for _, d in pos_only_with_default if d is not None]
            if pos_only_with_default else
            []
        )
        defaults += (
            [d for _, d in param_default if d is not None]
            if param_default else
            []
        )

        pos_only = pos_only or pos_only_with_default

        # Because we need to combine pos only with and without default even
        # the version with no default is a tuple
        pos_only = [p for p, _ in pos_only]
        params = (param_no_default or []) + ([p for p, _ in param_default] if param_default else [])

        # If after_star is None, make a default tuple
        after_star = after_star or (None, [], None)

        return ast.arguments(
            posonlyargs=pos_only,
            args=params,
            defaults=defaults,
            vararg=after_star[0],
            kwonlyargs=[p for p, _ in after_star[1]],
            kw_defaults=[d for _, d in after_star[1]],
            kwarg=after_star[2]
        )

    def _store_syntax_error(
        self,
        message: str,
        start: Optional[Tuple[int, int]] = None,
        end: Optional[Tuple[int, int]] = None
    ) -> None:
        line_from_token = start is None and end is None
        if start is None or end is None:
            tok = self._tokenizer.diagnose()
            start = start or tok.start
            end = end or tok.end

        if line_from_token:
            line = tok.line
        else:
            # End is used only to get the proper text
            line = "\n".join(
                self._tokenizer.get_lines(list(range(start[0], end[0] + 1)))
            )

        self._exception = SyntaxError(
            message,
            (self.filename, start[0], start[1], line)
        )

    def store_syntax_error(self, message: str) -> None:
        self._store_syntax_error(message)

    def make_syntax_error(self, message: str) -> None:
        self._store_syntax_error(message)
        return self._exception

    def store_syntax_error_known_location(self, message: str, node) -> None:
        """Store a syntax error that occured at a given AST node."""
        if isinstance(node, tokenize.TokenInfo):
            start = node.start
            end = node.end
        else:
            start = node.lineno, node.col_offset
            end = node.end_lineno, node.end_col_offset

        self._store_syntax_error(message, start, end)

    def store_syntax_error_known_range(
        self,
        message: str,
        start_node: Union[ast.AST, tokenize.TokenInfo],
        end_node: Union[ast.AST, tokenize.TokenInfo]
    ) -> None:
        if isinstance(start_node, tokenize.TokenInfo):
            start = start_node.start
        else:
            start = start_node.lineno, start_node.col_offset

        if isinstance(end_node, tokenize.TokenInfo):
            end = end_node.end
        else:
            end = end_node.end_lineno, end_node.end_col_offset

        self._store_syntax_error(message, start, end)

    def store_syntax_error_starting_from(
        self,
        message: str,
        start_node: Union[ast.AST, tokenize.TokenInfo]
    ) -> None:
        if isinstance(start_node, tokenize.TokenInfo):
            start = start_node.start
        else:
            start = start_node.lineno, start_node.col_offset

        self._store_syntax_error(message, start, None)

    def raise_syntax_error(self, message: str) -> NoReturn:
        self._store_syntax_error(message)
        raise self._exception

    def raise_syntax_error_known_location(
            self,
            message: str,
            node: Union[ast.AST, tokenize.TokenInfo]
        ) -> NoReturn:
        """Raise a syntax error that occured at a given AST node."""
        self.store_syntax_error_known_location(message, node)
        raise self._exception

    def raise_syntax_error_known_range(
        self,
        message: str,
        start_node: Union[ast.AST, tokenize.TokenInfo],
        end_node: Union[ast.AST, tokenize.TokenInfo]
    ) -> NoReturn:
        self.store_syntax_error_known_range(message, start_node, end_node)
        raise self._exception

    def raise_syntax_error_starting_from(
        self,
        message: str,
        start_node: Union[ast.AST, tokenize.TokenInfo]
    ) -> NoReturn:
        self.store_syntax_error_starting_from(message, start_node)
        raise self._exception


# Keywords and soft keywords are listed at the end of the parser definition.
class PythonParser(Parser):

    @memoize
    def start(self) -> Optional[Any]:
        # start: file
        mark = self._mark()
        if (
            (file := self.file())
        ):
            return file
        self._reset(mark)
        return None

    @memoize
    def file(self) -> Optional[ast . Module]:
        # file: statements? $
        mark = self._mark()
        if (
            (a := self.statements(),)
            and
            (_endmarker := self.expect('ENDMARKER'))
        ):
            return ast . Module ( body = a or [] , type_ignores = [] )
        self._reset(mark)
        return None

    @memoize
    def interactive(self) -> Optional[ast . Interactive]:
        # interactive: statement_newline
        mark = self._mark()
        if (
            (a := self.statement_newline())
        ):
            return ast . Interactive ( body = a )
        self._reset(mark)
        return None

    @memoize
    def eval(self) -> Optional[ast . Expression]:
        # eval: expressions NEWLINE* $
        mark = self._mark()
        if (
            (a := self.expressions())
            and
            (_loop0_1 := self._loop0_1(),)
            and
            (_endmarker := self.expect('ENDMARKER'))
        ):
            return ast . Expression ( body = a )
        self._reset(mark)
        return None

    @memoize
    def func_type(self) -> Optional[ast . FunctionType]:
        # func_type: '(' type_expressions? ')' '->' expression NEWLINE* $
        mark = self._mark()
        if (
            (literal := self.expect('('))
            and
            (a := self.type_expressions(),)
            and
            (literal_1 := self.expect(')'))
            and
            (literal_2 := self.expect('->'))
            and
            (b := self.expression())
            and
            (_loop0_2 := self._loop0_2(),)
            and
            (_endmarker := self.expect('ENDMARKER'))
        ):
            return ast . FunctionType ( argtypes = a , returns = b )
        self._reset(mark)
        return None

    @memoize
    def fstring(self) -> Optional[ast . Expr]:
        # fstring: star_expressions
        mark = self._mark()
        if (
            (star_expressions := self.star_expressions())
        ):
            return star_expressions
        self._reset(mark)
        return None

    @memoize
    def statements(self) -> Optional[list]:
        # statements: statement+
        mark = self._mark()
        if (
            (a := self._loop1_3())
        ):
            return list ( itertools . chain ( * a ) )
        self._reset(mark)
        return None

    @memoize
    def statement(self) -> Optional[list]:
        # statement: compound_stmt | simple_stmts
        mark = self._mark()
        if (
            (a := self.compound_stmt())
        ):
            return [a]
        self._reset(mark)
        if (
            (a := self.simple_stmts())
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def statement_newline(self) -> Optional[list]:
        # statement_newline: compound_stmt NEWLINE | simple_stmts | NEWLINE | $
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.compound_stmt())
            and
            (_newline := self.expect('NEWLINE'))
        ):
            return [a]
        self._reset(mark)
        if (
            (simple_stmts := self.simple_stmts())
        ):
            return simple_stmts
        self._reset(mark)
        if (
            (_newline := self.expect('NEWLINE'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return [ast . Pass ( lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )]
        self._reset(mark)
        if (
            (_endmarker := self.expect('ENDMARKER'))
        ):
            return None
        self._reset(mark)
        return None

    @memoize
    def simple_stmts(self) -> Optional[list]:
        # simple_stmts: simple_stmt !';' NEWLINE | ';'.simple_stmt+ ';'? NEWLINE
        mark = self._mark()
        if (
            (a := self.simple_stmt())
            and
            self.negative_lookahead(self.expect, ';')
            and
            (_newline := self.expect('NEWLINE'))
        ):
            return [a]
        self._reset(mark)
        if (
            (a := self._gather_4())
            and
            (opt := self.expect(';'),)
            and
            (_newline := self.expect('NEWLINE'))
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def simple_stmt(self) -> Optional[Any]:
        # simple_stmt: assignment | star_expressions | &'return' return_stmt | &('import' | 'from') import_stmt | &'raise' raise_stmt | 'pass' | &'del' del_stmt | &'yield' yield_stmt | &'assert' assert_stmt | 'break' | 'continue' | &'global' global_stmt | &'nonlocal' nonlocal_stmt
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (assignment := self.assignment())
        ):
            return assignment
        self._reset(mark)
        if (
            (e := self.star_expressions())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Expr ( value = e , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            self.positive_lookahead(self.expect, 'return')
            and
            (return_stmt := self.return_stmt())
        ):
            return return_stmt
        self._reset(mark)
        if (
            self.positive_lookahead(self._tmp_6, )
            and
            (import_stmt := self.import_stmt())
        ):
            return import_stmt
        self._reset(mark)
        if (
            self.positive_lookahead(self.expect, 'raise')
            and
            (raise_stmt := self.raise_stmt())
        ):
            return raise_stmt
        self._reset(mark)
        if (
            (literal := self.expect('pass'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Pass ( lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            self.positive_lookahead(self.expect, 'del')
            and
            (del_stmt := self.del_stmt())
        ):
            return del_stmt
        self._reset(mark)
        if (
            self.positive_lookahead(self.expect, 'yield')
            and
            (yield_stmt := self.yield_stmt())
        ):
            return yield_stmt
        self._reset(mark)
        if (
            self.positive_lookahead(self.expect, 'assert')
            and
            (assert_stmt := self.assert_stmt())
        ):
            return assert_stmt
        self._reset(mark)
        if (
            (literal := self.expect('break'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Break ( lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('continue'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Continue ( lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            self.positive_lookahead(self.expect, 'global')
            and
            (global_stmt := self.global_stmt())
        ):
            return global_stmt
        self._reset(mark)
        if (
            self.positive_lookahead(self.expect, 'nonlocal')
            and
            (nonlocal_stmt := self.nonlocal_stmt())
        ):
            return nonlocal_stmt
        self._reset(mark)
        return None

    @memoize
    def compound_stmt(self) -> Optional[Any]:
        # compound_stmt: &('def' | '@' | 'async') function_def | &'if' if_stmt | &('class' | '@') class_def | &('with' | 'async') with_stmt | &('for' | 'async') for_stmt | &'try' try_stmt | &'while' while_stmt | match_stmt
        mark = self._mark()
        if (
            self.positive_lookahead(self._tmp_7, )
            and
            (function_def := self.function_def())
        ):
            return function_def
        self._reset(mark)
        if (
            self.positive_lookahead(self.expect, 'if')
            and
            (if_stmt := self.if_stmt())
        ):
            return if_stmt
        self._reset(mark)
        if (
            self.positive_lookahead(self._tmp_8, )
            and
            (class_def := self.class_def())
        ):
            return class_def
        self._reset(mark)
        if (
            self.positive_lookahead(self._tmp_9, )
            and
            (with_stmt := self.with_stmt())
        ):
            return with_stmt
        self._reset(mark)
        if (
            self.positive_lookahead(self._tmp_10, )
            and
            (for_stmt := self.for_stmt())
        ):
            return for_stmt
        self._reset(mark)
        if (
            self.positive_lookahead(self.expect, 'try')
            and
            (try_stmt := self.try_stmt())
        ):
            return try_stmt
        self._reset(mark)
        if (
            self.positive_lookahead(self.expect, 'while')
            and
            (while_stmt := self.while_stmt())
        ):
            return while_stmt
        self._reset(mark)
        if (
            (match_stmt := self.match_stmt())
        ):
            return match_stmt
        self._reset(mark)
        return None

    @memoize
    def assignment(self) -> Optional[Any]:
        # assignment: NAME ':' expression ['=' annotated_rhs] | ('(' single_target ')' | single_subscript_attribute_target) ':' expression ['=' annotated_rhs] | ((star_targets '='))+ (yield_expr | star_expressions) !'=' TYPE_COMMENT? | single_target augassign ~ (yield_expr | star_expressions) | invalid_assignment
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.name())
            and
            (literal := self.expect(':'))
            and
            (b := self.expression())
            and
            (c := self._tmp_11(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . check_version ( ( 3 , 6 ) , "Variable annotation syntax is" , ast . AnnAssign ( target = ast . Name ( id = a . string , ctx = Store , lineno = a . start [0] , col_offset = a . start [1] , end_lineno = a . end [0] , end_col_offset = a . end [1] , ) , annotation = b , value = c , simple = 1 , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , ) )
        self._reset(mark)
        if (
            (a := self._tmp_12())
            and
            (literal := self.expect(':'))
            and
            (b := self.expression())
            and
            (c := self._tmp_13(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . check_version ( ( 3 , 6 ) , "Variable annotation syntax is" , ast . AnnAssign ( target = a , annotation = b , value = c , simple = 0 , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , ) )
        self._reset(mark)
        if (
            (a := self._loop1_14())
            and
            (b := self._tmp_15())
            and
            self.negative_lookahead(self.expect, '=')
            and
            (tc := self.type_comment(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Assign ( targets = a , value = b , type_comment = tc , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        cut = False
        if (
            (a := self.single_target())
            and
            (b := self.augassign())
            and
            (cut := True)
            and
            (c := self._tmp_16())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . AugAssign ( target = a , op = b , value = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if cut: return None
        if (
            (invalid_assignment := self.invalid_assignment())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def annotated_rhs(self) -> Optional[Any]:
        # annotated_rhs: yield_expr | star_expressions
        mark = self._mark()
        if (
            (yield_expr := self.yield_expr())
        ):
            return yield_expr
        self._reset(mark)
        if (
            (star_expressions := self.star_expressions())
        ):
            return star_expressions
        self._reset(mark)
        return None

    @memoize
    def augassign(self) -> Optional[Any]:
        # augassign: '+=' | '-=' | '*=' | '@=' | '/=' | '%=' | '&=' | '|=' | '^=' | '<<=' | '>>=' | '**=' | '//='
        mark = self._mark()
        if (
            (literal := self.expect('+='))
        ):
            return ast . Add ( )
        self._reset(mark)
        if (
            (literal := self.expect('-='))
        ):
            return ast . Sub ( )
        self._reset(mark)
        if (
            (literal := self.expect('*='))
        ):
            return ast . Mult ( )
        self._reset(mark)
        if (
            (literal := self.expect('@='))
        ):
            return self . check_version ( ( 3 , 5 ) , "The '@' operator is" , ast . MatMult ( ) )
        self._reset(mark)
        if (
            (literal := self.expect('/='))
        ):
            return ast . Div ( )
        self._reset(mark)
        if (
            (literal := self.expect('%='))
        ):
            return ast . Mod ( )
        self._reset(mark)
        if (
            (literal := self.expect('&='))
        ):
            return ast . BitAnd ( )
        self._reset(mark)
        if (
            (literal := self.expect('|='))
        ):
            return ast . BitOr ( )
        self._reset(mark)
        if (
            (literal := self.expect('^='))
        ):
            return ast . BitXor ( )
        self._reset(mark)
        if (
            (literal := self.expect('<<='))
        ):
            return ast . LShift ( )
        self._reset(mark)
        if (
            (literal := self.expect('>>='))
        ):
            return ast . RShift ( )
        self._reset(mark)
        if (
            (literal := self.expect('**='))
        ):
            return ast . Pow ( )
        self._reset(mark)
        if (
            (literal := self.expect('//='))
        ):
            return ast . FloorDiv ( )
        self._reset(mark)
        return None

    @memoize
    def return_stmt(self) -> Optional[ast . Return]:
        # return_stmt: 'return' star_expressions?
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('return'))
            and
            (a := self.star_expressions(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Return ( value = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def raise_stmt(self) -> Optional[ast . Raise]:
        # raise_stmt: 'raise' expression ['from' expression] | 'raise'
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('raise'))
            and
            (a := self.expression())
            and
            (b := self._tmp_17(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Raise ( exc = a , cause = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('raise'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Raise ( exc = None , cause = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def global_stmt(self) -> Optional[ast . Global]:
        # global_stmt: 'global' ','.NAME+
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('global'))
            and
            (a := self._gather_18())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Global ( names = [n . string for n in a] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def nonlocal_stmt(self) -> Optional[ast . Nonlocal]:
        # nonlocal_stmt: 'nonlocal' ','.NAME+
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('nonlocal'))
            and
            (a := self._gather_20())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Nonlocal ( names = [n . string for n in a] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def del_stmt(self) -> Optional[ast . Delete]:
        # del_stmt: 'del' del_targets &(';' | NEWLINE) | invalid_del_stmt
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('del'))
            and
            (a := self.del_targets())
            and
            self.positive_lookahead(self._tmp_22, )
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Delete ( targets = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (invalid_del_stmt := self.invalid_del_stmt())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def yield_stmt(self) -> Optional[ast . Expr]:
        # yield_stmt: yield_expr
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (y := self.yield_expr())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Expr ( value = y , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def assert_stmt(self) -> Optional[ast . Assert]:
        # assert_stmt: 'assert' expression [',' expression]
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('assert'))
            and
            (a := self.expression())
            and
            (b := self._tmp_23(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Assert ( test = a , msg = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def import_stmt(self) -> Optional[ast . Import]:
        # import_stmt: import_name | import_from
        mark = self._mark()
        if (
            (import_name := self.import_name())
        ):
            return import_name
        self._reset(mark)
        if (
            (import_from := self.import_from())
        ):
            return import_from
        self._reset(mark)
        return None

    @memoize
    def import_name(self) -> Optional[ast . Import]:
        # import_name: 'import' dotted_as_names
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('import'))
            and
            (a := self.dotted_as_names())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Import ( names = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def import_from(self) -> Optional[ast . ImportFrom]:
        # import_from: 'from' (('.' | '...'))* dotted_name 'import' import_from_targets | 'from' (('.' | '...'))+ 'import' import_from_targets
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('from'))
            and
            (a := self._loop0_24(),)
            and
            (b := self.dotted_name())
            and
            (literal_1 := self.expect('import'))
            and
            (c := self.import_from_targets())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . ImportFrom ( module = b , names = c , level = self . extract_import_level ( a ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('from'))
            and
            (a := self._loop1_25())
            and
            (literal_1 := self.expect('import'))
            and
            (b := self.import_from_targets())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . ImportFrom ( names = b , level = self . extract_import_level ( a ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) if sys . version_info >= ( 3 , 9 ) else ast . ImportFrom ( module = None , names = b , level = self . extract_import_level ( a ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def import_from_targets(self) -> Optional[List [ast . alias]]:
        # import_from_targets: '(' import_from_as_names ','? ')' | import_from_as_names !',' | '*' | invalid_import_from_targets
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('('))
            and
            (a := self.import_from_as_names())
            and
            (opt := self.expect(','),)
            and
            (literal_1 := self.expect(')'))
        ):
            return a
        self._reset(mark)
        if (
            (import_from_as_names := self.import_from_as_names())
            and
            self.negative_lookahead(self.expect, ',')
        ):
            return import_from_as_names
        self._reset(mark)
        if (
            (literal := self.expect('*'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return [ast . alias ( name = "*" , asname = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )]
        self._reset(mark)
        if (
            (invalid_import_from_targets := self.invalid_import_from_targets())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def import_from_as_names(self) -> Optional[List [ast . alias]]:
        # import_from_as_names: ','.import_from_as_name+
        mark = self._mark()
        if (
            (a := self._gather_26())
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def import_from_as_name(self) -> Optional[ast . alias]:
        # import_from_as_name: NAME ['as' NAME]
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.name())
            and
            (b := self._tmp_28(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . alias ( name = a . string , asname = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def dotted_as_names(self) -> Optional[List [ast . alias]]:
        # dotted_as_names: ','.dotted_as_name+
        mark = self._mark()
        if (
            (a := self._gather_29())
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def dotted_as_name(self) -> Optional[ast . alias]:
        # dotted_as_name: dotted_name ['as' NAME]
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.dotted_name())
            and
            (b := self._tmp_31(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . alias ( name = a , asname = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize_left_rec
    def dotted_name(self) -> Optional[str]:
        # dotted_name: dotted_name '.' NAME | NAME
        mark = self._mark()
        if (
            (a := self.dotted_name())
            and
            (literal := self.expect('.'))
            and
            (b := self.name())
        ):
            return a + "." + b . string
        self._reset(mark)
        if (
            (a := self.name())
        ):
            return a . string
        self._reset(mark)
        return None

    @memoize
    def block(self) -> Optional[list]:
        # block: NEWLINE INDENT statements DEDENT | simple_stmts | invalid_block
        mark = self._mark()
        if (
            (_newline := self.expect('NEWLINE'))
            and
            (_indent := self.expect('INDENT'))
            and
            (a := self.statements())
            and
            (_dedent := self.expect('DEDENT'))
        ):
            return a
        self._reset(mark)
        if (
            (simple_stmts := self.simple_stmts())
        ):
            return simple_stmts
        self._reset(mark)
        if (
            (invalid_block := self.invalid_block())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def decorators(self) -> Optional[Any]:
        # decorators: decorator+
        mark = self._mark()
        if (
            (_loop1_32 := self._loop1_32())
        ):
            return _loop1_32
        self._reset(mark)
        return None

    @memoize
    def decorator(self) -> Optional[Any]:
        # decorator: ('@' dec_maybe_call NEWLINE) | ('@' named_expression NEWLINE)
        mark = self._mark()
        if (
            (a := self._tmp_33())
        ):
            return a
        self._reset(mark)
        if (
            (a := self._tmp_34())
        ):
            return self . check_version ( ( 3 , 9 ) , "Generic decorator are" , a )
        self._reset(mark)
        return None

    @memoize
    def dec_maybe_call(self) -> Optional[Any]:
        # dec_maybe_call: dec_primary '(' arguments? ')' | dec_primary
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (dn := self.dec_primary())
            and
            (literal := self.expect('('))
            and
            (z := self.arguments(),)
            and
            (literal_1 := self.expect(')'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Call ( func = dn , args = z [0] if z else [] , keywords = z [1] if z else [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (dec_primary := self.dec_primary())
        ):
            return dec_primary
        self._reset(mark)
        return None

    @memoize_left_rec
    def dec_primary(self) -> Optional[Any]:
        # dec_primary: dec_primary '.' NAME | NAME
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.dec_primary())
            and
            (literal := self.expect('.'))
            and
            (b := self.name())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Attribute ( value = a , attr = b . string , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.name())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Name ( id = a . string , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def class_def(self) -> Optional[ast . ClassDef]:
        # class_def: decorators class_def_raw | class_def_raw
        mark = self._mark()
        if (
            (a := self.decorators())
            and
            (b := self.class_def_raw())
        ):
            return self . set_decorators ( b , a )
        self._reset(mark)
        if (
            (class_def_raw := self.class_def_raw())
        ):
            return class_def_raw
        self._reset(mark)
        return None

    @memoize
    def class_def_raw(self) -> Optional[ast . ClassDef]:
        # class_def_raw: invalid_class_def_raw | 'class' NAME ['(' arguments? ')'] &&':' block
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (invalid_class_def_raw := self.invalid_class_def_raw())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (literal := self.expect('class'))
            and
            (a := self.name())
            and
            (b := self._tmp_35(),)
            and
            (forced := self.expect_forced(self.expect(':'), "':'"))
            and
            (c := self.block())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . ClassDef ( a . string , bases = b [0] if b else [] , keywords = b [1] if b else [] , body = c , decorator_list = [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._reset(mark)
        return None

    @memoize
    def function_def(self) -> Optional[Union [ast . FunctionDef , ast . AsyncFunctionDef]]:
        # function_def: decorators function_def_raw | function_def_raw
        mark = self._mark()
        if (
            (d := self.decorators())
            and
            (f := self.function_def_raw())
        ):
            return self . set_decorators ( f , d )
        self._reset(mark)
        if (
            (f := self.function_def_raw())
        ):
            return self . set_decorators ( f , [] )
        self._reset(mark)
        return None

    @memoize
    def function_def_raw(self) -> Optional[Union [ast . FunctionDef , ast . AsyncFunctionDef]]:
        # function_def_raw: invalid_def_raw | 'def' NAME '(' params? ')' ['->' expression] &&':' func_type_comment? block | 'async' 'def' NAME '(' params? ')' ['->' expression] &&':' func_type_comment? block
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (invalid_def_raw := self.invalid_def_raw())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (literal := self.expect('def'))
            and
            (n := self.name())
            and
            (literal_1 := self.expect('('))
            and
            (params := self.params(),)
            and
            (literal_2 := self.expect(')'))
            and
            (a := self._tmp_36(),)
            and
            (forced := self.expect_forced(self.expect(':'), "':'"))
            and
            (tc := self.func_type_comment(),)
            and
            (b := self.block())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . FunctionDef ( name = n . string , args = params or self . make_arguments ( None , [] , None , [] , None ) , returns = a , body = b , type_comment = tc , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._reset(mark)
        if (
            (literal := self.expect('async'))
            and
            (literal_1 := self.expect('def'))
            and
            (n := self.name())
            and
            (literal_2 := self.expect('('))
            and
            (params := self.params(),)
            and
            (literal_3 := self.expect(')'))
            and
            (a := self._tmp_37(),)
            and
            (forced := self.expect_forced(self.expect(':'), "':'"))
            and
            (tc := self.func_type_comment(),)
            and
            (b := self.block())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . check_version ( ( 3 , 5 ) , "Async functions are" , ast . AsyncFunctionDef ( name = n . string , args = params or self . make_arguments ( None , [] , None , [] , None ) , returns = a , body = b , type_comment = tc , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , ) )
        self._reset(mark)
        return None

    @memoize
    def params(self) -> Optional[Any]:
        # params: invalid_parameters | parameters
        mark = self._mark()
        if (
            (invalid_parameters := self.invalid_parameters())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (parameters := self.parameters())
        ):
            return parameters
        self._reset(mark)
        return None

    @memoize
    def parameters(self) -> Optional[ast . arguments]:
        # parameters: slash_no_default param_no_default* param_with_default* star_etc? | slash_with_default param_with_default* star_etc? | param_no_default+ param_with_default* star_etc? | param_with_default+ star_etc? | star_etc
        mark = self._mark()
        if (
            (a := self.slash_no_default())
            and
            (b := self._loop0_38(),)
            and
            (c := self._loop0_39(),)
            and
            (d := self.star_etc(),)
        ):
            return self . check_version ( ( 3 , 8 ) , "Positional only arguments are" , self . make_arguments ( a , [] , b , c , d ) )
        self._reset(mark)
        if (
            (a := self.slash_with_default())
            and
            (b := self._loop0_40(),)
            and
            (c := self.star_etc(),)
        ):
            return self . check_version ( ( 3 , 8 ) , "Positional only arguments are" , self . make_arguments ( None , a , None , b , c ) , )
        self._reset(mark)
        if (
            (a := self._loop1_41())
            and
            (b := self._loop0_42(),)
            and
            (c := self.star_etc(),)
        ):
            return self . make_arguments ( None , [] , a , b , c )
        self._reset(mark)
        if (
            (a := self._loop1_43())
            and
            (b := self.star_etc(),)
        ):
            return self . make_arguments ( None , [] , None , a , b )
        self._reset(mark)
        if (
            (a := self.star_etc())
        ):
            return self . make_arguments ( None , [] , None , None , a )
        self._reset(mark)
        return None

    @memoize
    def slash_no_default(self) -> Optional[List [Tuple [ast . arg , None]]]:
        # slash_no_default: param_no_default+ '/' ',' | param_no_default+ '/' &')'
        mark = self._mark()
        if (
            (a := self._loop1_44())
            and
            (literal := self.expect('/'))
            and
            (literal_1 := self.expect(','))
        ):
            return [( p , None ) for p in a]
        self._reset(mark)
        if (
            (a := self._loop1_45())
            and
            (literal := self.expect('/'))
            and
            self.positive_lookahead(self.expect, ')')
        ):
            return [( p , None ) for p in a]
        self._reset(mark)
        return None

    @memoize
    def slash_with_default(self) -> Optional[List [Tuple [ast . arg , Any]]]:
        # slash_with_default: param_no_default* param_with_default+ '/' ',' | param_no_default* param_with_default+ '/' &')'
        mark = self._mark()
        if (
            (a := self._loop0_46(),)
            and
            (b := self._loop1_47())
            and
            (literal := self.expect('/'))
            and
            (literal_1 := self.expect(','))
        ):
            return ( [( p , None ) for p in a] if a else [] ) + b
        self._reset(mark)
        if (
            (a := self._loop0_48(),)
            and
            (b := self._loop1_49())
            and
            (literal := self.expect('/'))
            and
            self.positive_lookahead(self.expect, ')')
        ):
            return ( [( p , None ) for p in a] if a else [] ) + b
        self._reset(mark)
        return None

    @memoize
    def star_etc(self) -> Optional[Tuple [Optional [ast . arg] , List [Tuple [ast . arg , Any]] , Optional [ast . arg]]]:
        # star_etc: '*' param_no_default param_maybe_default* kwds? | '*' ',' param_maybe_default+ kwds? | kwds | invalid_star_etc
        mark = self._mark()
        if (
            (literal := self.expect('*'))
            and
            (a := self.param_no_default())
            and
            (b := self._loop0_50(),)
            and
            (c := self.kwds(),)
        ):
            return ( a , b , c )
        self._reset(mark)
        if (
            (literal := self.expect('*'))
            and
            (literal_1 := self.expect(','))
            and
            (b := self._loop1_51())
            and
            (c := self.kwds(),)
        ):
            return ( None , b , c )
        self._reset(mark)
        if (
            (a := self.kwds())
        ):
            return ( None , [] , a )
        self._reset(mark)
        if (
            (invalid_star_etc := self.invalid_star_etc())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def kwds(self) -> Optional[Any]:
        # kwds: '**' param_no_default
        mark = self._mark()
        if (
            (literal := self.expect('**'))
            and
            (a := self.param_no_default())
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def param_no_default(self) -> Optional[ast . arg]:
        # param_no_default: param ',' TYPE_COMMENT? | param TYPE_COMMENT? &')'
        mark = self._mark()
        if (
            (a := self.param())
            and
            (literal := self.expect(','))
            and
            (tc := self.type_comment(),)
        ):
            return self . set_arg_type_comment ( a , tc )
        self._reset(mark)
        if (
            (a := self.param())
            and
            (tc := self.type_comment(),)
            and
            self.positive_lookahead(self.expect, ')')
        ):
            return self . set_arg_type_comment ( a , tc )
        self._reset(mark)
        return None

    @memoize
    def param_with_default(self) -> Optional[Tuple [ast . arg , Any]]:
        # param_with_default: param default ',' TYPE_COMMENT? | param default TYPE_COMMENT? &')'
        mark = self._mark()
        if (
            (a := self.param())
            and
            (c := self.default())
            and
            (literal := self.expect(','))
            and
            (tc := self.type_comment(),)
        ):
            return ( self . set_arg_type_comment ( a , tc ) , c )
        self._reset(mark)
        if (
            (a := self.param())
            and
            (c := self.default())
            and
            (tc := self.type_comment(),)
            and
            self.positive_lookahead(self.expect, ')')
        ):
            return ( self . set_arg_type_comment ( a , tc ) , c )
        self._reset(mark)
        return None

    @memoize
    def param_maybe_default(self) -> Optional[Tuple [ast . arg , Any]]:
        # param_maybe_default: param default? ',' TYPE_COMMENT? | param default? TYPE_COMMENT? &')'
        mark = self._mark()
        if (
            (a := self.param())
            and
            (c := self.default(),)
            and
            (literal := self.expect(','))
            and
            (tc := self.type_comment(),)
        ):
            return ( self . set_arg_type_comment ( a , tc ) , c )
        self._reset(mark)
        if (
            (a := self.param())
            and
            (c := self.default(),)
            and
            (tc := self.type_comment(),)
            and
            self.positive_lookahead(self.expect, ')')
        ):
            return ( self . set_arg_type_comment ( a , tc ) , c )
        self._reset(mark)
        return None

    @memoize
    def param(self) -> Optional[Any]:
        # param: NAME annotation?
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.name())
            and
            (b := self.annotation(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . arg ( arg = a . string , annotation = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def annotation(self) -> Optional[Any]:
        # annotation: ':' expression
        mark = self._mark()
        if (
            (literal := self.expect(':'))
            and
            (a := self.expression())
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def default(self) -> Optional[Any]:
        # default: '=' expression
        mark = self._mark()
        if (
            (literal := self.expect('='))
            and
            (a := self.expression())
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def if_stmt(self) -> Optional[ast . If]:
        # if_stmt: invalid_if_stmt | 'if' named_expression ':' block elif_stmt | 'if' named_expression ':' block else_block?
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (invalid_if_stmt := self.invalid_if_stmt())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (literal := self.expect('if'))
            and
            (a := self.named_expression())
            and
            (literal_1 := self.expect(':'))
            and
            (b := self.block())
            and
            (c := self.elif_stmt())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . If ( test = a , body = b , orelse = c or [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('if'))
            and
            (a := self.named_expression())
            and
            (literal_1 := self.expect(':'))
            and
            (b := self.block())
            and
            (c := self.else_block(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . If ( test = a , body = b , orelse = c or [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def elif_stmt(self) -> Optional[List [ast . If]]:
        # elif_stmt: invalid_elif_stmt | 'elif' named_expression ':' block elif_stmt | 'elif' named_expression ':' block else_block?
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (invalid_elif_stmt := self.invalid_elif_stmt())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (literal := self.expect('elif'))
            and
            (a := self.named_expression())
            and
            (literal_1 := self.expect(':'))
            and
            (b := self.block())
            and
            (c := self.elif_stmt())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return [ast . If ( test = a , body = b , orelse = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )]
        self._reset(mark)
        if (
            (literal := self.expect('elif'))
            and
            (a := self.named_expression())
            and
            (literal_1 := self.expect(':'))
            and
            (b := self.block())
            and
            (c := self.else_block(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return [ast . If ( test = a , body = b , orelse = c or [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )]
        self._reset(mark)
        return None

    @memoize
    def else_block(self) -> Optional[list]:
        # else_block: invalid_else_stmt | 'else' &&':' block
        mark = self._mark()
        if (
            (invalid_else_stmt := self.invalid_else_stmt())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (literal := self.expect('else'))
            and
            (forced := self.expect_forced(self.expect(':'), "':'"))
            and
            (b := self.block())
        ):
            return b
        self._reset(mark)
        return None

    @memoize
    def while_stmt(self) -> Optional[ast . While]:
        # while_stmt: invalid_while_stmt | 'while' named_expression ':' block else_block?
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (invalid_while_stmt := self.invalid_while_stmt())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (literal := self.expect('while'))
            and
            (a := self.named_expression())
            and
            (literal_1 := self.expect(':'))
            and
            (b := self.block())
            and
            (c := self.else_block(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . While ( test = a , body = b , orelse = c or [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def for_stmt(self) -> Optional[Union [ast . For , ast . AsyncFor]]:
        # for_stmt: invalid_for_stmt | 'for' star_targets 'in' ~ star_expressions &&':' TYPE_COMMENT? block else_block? | 'async' 'for' star_targets 'in' ~ star_expressions ':' TYPE_COMMENT? block else_block? | invalid_for_target
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (invalid_for_stmt := self.invalid_for_stmt())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        cut = False
        if (
            (literal := self.expect('for'))
            and
            (t := self.star_targets())
            and
            (literal_1 := self.expect('in'))
            and
            (cut := True)
            and
            (ex := self.star_expressions())
            and
            (forced := self.expect_forced(self.expect(':'), "':'"))
            and
            (tc := self.type_comment(),)
            and
            (b := self.block())
            and
            (el := self.else_block(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . For ( target = t , iter = ex , body = b , orelse = el or [] , type_comment = tc , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if cut: return None
        cut = False
        if (
            (literal := self.expect('async'))
            and
            (literal_1 := self.expect('for'))
            and
            (t := self.star_targets())
            and
            (literal_2 := self.expect('in'))
            and
            (cut := True)
            and
            (ex := self.star_expressions())
            and
            (literal_3 := self.expect(':'))
            and
            (tc := self.type_comment(),)
            and
            (b := self.block())
            and
            (el := self.else_block(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . check_version ( ( 3 , 5 ) , "Async for loops are" , ast . AsyncFor ( target = t , iter = ex , body = b , orelse = el or [] , type_comment = tc , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._reset(mark)
        if cut: return None
        if (
            (invalid_for_target := self.invalid_for_target())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def with_stmt(self) -> Optional[Union [ast . With , ast . AsyncWith]]:
        # with_stmt: invalid_with_stmt_indent | 'with' '(' ','.with_item+ ','? ')' ':' block | 'with' ','.with_item+ ':' TYPE_COMMENT? block | 'async' 'with' '(' ','.with_item+ ','? ')' ':' block | 'async' 'with' ','.with_item+ ':' TYPE_COMMENT? block | invalid_with_stmt
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (invalid_with_stmt_indent := self.invalid_with_stmt_indent())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (literal := self.expect('with'))
            and
            (literal_1 := self.expect('('))
            and
            (a := self._gather_52())
            and
            (opt := self.expect(','),)
            and
            (literal_2 := self.expect(')'))
            and
            (literal_3 := self.expect(':'))
            and
            (b := self.block())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . check_version ( ( 3 , 9 ) , "Parenthesized with items" , ast . With ( items = a , body = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._reset(mark)
        if (
            (literal := self.expect('with'))
            and
            (a := self._gather_54())
            and
            (literal_1 := self.expect(':'))
            and
            (tc := self.type_comment(),)
            and
            (b := self.block())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . With ( items = a , body = b , type_comment = tc , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('async'))
            and
            (literal_1 := self.expect('with'))
            and
            (literal_2 := self.expect('('))
            and
            (a := self._gather_56())
            and
            (opt := self.expect(','),)
            and
            (literal_3 := self.expect(')'))
            and
            (literal_4 := self.expect(':'))
            and
            (b := self.block())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . check_version ( ( 3 , 9 ) , "Parenthesized with items" , ast . AsyncWith ( items = a , body = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._reset(mark)
        if (
            (literal := self.expect('async'))
            and
            (literal_1 := self.expect('with'))
            and
            (a := self._gather_58())
            and
            (literal_2 := self.expect(':'))
            and
            (tc := self.type_comment(),)
            and
            (b := self.block())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . check_version ( ( 3 , 5 ) , "Async with statements are" , ast . AsyncWith ( items = a , body = b , type_comment = tc , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._reset(mark)
        if (
            (invalid_with_stmt := self.invalid_with_stmt())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def with_item(self) -> Optional[ast . withitem]:
        # with_item: expression 'as' star_target &(',' | ')' | ':') | invalid_with_item | expression
        mark = self._mark()
        if (
            (e := self.expression())
            and
            (literal := self.expect('as'))
            and
            (t := self.star_target())
            and
            self.positive_lookahead(self._tmp_60, )
        ):
            return ast . withitem ( context_expr = e , optional_vars = t )
        self._reset(mark)
        if (
            (invalid_with_item := self.invalid_with_item())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (e := self.expression())
        ):
            return ast . withitem ( context_expr = e , optional_vars = None )
        self._reset(mark)
        return None

    @memoize
    def try_stmt(self) -> Optional[ast . Try]:
        # try_stmt: invalid_try_stmt | 'try' &&':' block finally_block | 'try' &&':' block except_block+ else_block? finally_block?
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (invalid_try_stmt := self.invalid_try_stmt())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (literal := self.expect('try'))
            and
            (forced := self.expect_forced(self.expect(':'), "':'"))
            and
            (b := self.block())
            and
            (f := self.finally_block())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Try ( body = b , handlers = [] , orelse = [] , finalbody = f , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('try'))
            and
            (forced := self.expect_forced(self.expect(':'), "':'"))
            and
            (b := self.block())
            and
            (ex := self._loop1_61())
            and
            (el := self.else_block(),)
            and
            (f := self.finally_block(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Try ( body = b , handlers = ex , orelse = el or [] , finalbody = f or [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def except_block(self) -> Optional[ast . ExceptHandler]:
        # except_block: invalid_except_stmt_indent | 'except' expression ['as' NAME] ':' block | 'except' ':' block | invalid_except_stmt
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (invalid_except_stmt_indent := self.invalid_except_stmt_indent())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (literal := self.expect('except'))
            and
            (e := self.expression())
            and
            (t := self._tmp_62(),)
            and
            (literal_1 := self.expect(':'))
            and
            (b := self.block())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . ExceptHandler ( type = e , name = t , body = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('except'))
            and
            (literal_1 := self.expect(':'))
            and
            (b := self.block())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . ExceptHandler ( type = None , name = None , body = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (invalid_except_stmt := self.invalid_except_stmt())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def finally_block(self) -> Optional[list]:
        # finally_block: invalid_finally_stmt | 'finally' &&':' block
        mark = self._mark()
        if (
            (invalid_finally_stmt := self.invalid_finally_stmt())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (literal := self.expect('finally'))
            and
            (forced := self.expect_forced(self.expect(':'), "':'"))
            and
            (a := self.block())
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def match_stmt(self) -> Optional["ast.Match"]:
        # match_stmt: "match" subject_expr ':' NEWLINE INDENT case_block+ DEDENT | invalid_match_stmt
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect("match"))
            and
            (subject := self.subject_expr())
            and
            (literal_1 := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            (_indent := self.expect('INDENT'))
            and
            (cases := self._loop1_63())
            and
            (_dedent := self.expect('DEDENT'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Match ( subject = subject , cases = cases , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (invalid_match_stmt := self.invalid_match_stmt())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def subject_expr(self) -> Optional[Any]:
        # subject_expr: star_named_expression ',' star_named_expressions? | named_expression
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (value := self.star_named_expression())
            and
            (literal := self.expect(','))
            and
            (values := self.star_named_expressions(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . check_version ( ( 3 , 10 ) , "Pattern matching is" , ast . Tuple ( elts = [value] + ( values or [] ) , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._reset(mark)
        if (
            (e := self.named_expression())
        ):
            return self . check_version ( ( 3 , 10 ) , "Pattern matching is" , e )
        self._reset(mark)
        return None

    @memoize
    def case_block(self) -> Optional["ast.match_case"]:
        # case_block: invalid_case_block | "case" patterns guard? ':' block
        mark = self._mark()
        if (
            (invalid_case_block := self.invalid_case_block())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (literal := self.expect("case"))
            and
            (pattern := self.patterns())
            and
            (guard := self.guard(),)
            and
            (literal_1 := self.expect(':'))
            and
            (body := self.block())
        ):
            return ast . match_case ( pattern = pattern , guard = guard , body = body )
        self._reset(mark)
        return None

    @memoize
    def guard(self) -> Optional[Any]:
        # guard: 'if' named_expression
        mark = self._mark()
        if (
            (literal := self.expect('if'))
            and
            (guard := self.named_expression())
        ):
            return guard
        self._reset(mark)
        return None

    @memoize
    def patterns(self) -> Optional[Any]:
        # patterns: open_sequence_pattern | pattern
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (patterns := self.open_sequence_pattern())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchSequence ( patterns = patterns , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (pattern := self.pattern())
        ):
            return pattern
        self._reset(mark)
        return None

    @memoize
    def pattern(self) -> Optional[Any]:
        # pattern: as_pattern | or_pattern
        mark = self._mark()
        if (
            (as_pattern := self.as_pattern())
        ):
            return as_pattern
        self._reset(mark)
        if (
            (or_pattern := self.or_pattern())
        ):
            return or_pattern
        self._reset(mark)
        return None

    @memoize
    def as_pattern(self) -> Optional["ast.MatchAs"]:
        # as_pattern: or_pattern 'as' pattern_capture_target | invalid_as_pattern
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (pattern := self.or_pattern())
            and
            (literal := self.expect('as'))
            and
            (target := self.pattern_capture_target())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchAs ( pattern = pattern , name = target , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (invalid_as_pattern := self.invalid_as_pattern())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def or_pattern(self) -> Optional["ast.MatchOr"]:
        # or_pattern: '|'.closed_pattern+
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (patterns := self._gather_64())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchOr ( patterns = patterns , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) if len ( patterns ) > 1 else patterns [0]
        self._reset(mark)
        return None

    @memoize
    def closed_pattern(self) -> Optional[Any]:
        # closed_pattern: literal_pattern | capture_pattern | wildcard_pattern | value_pattern | group_pattern | sequence_pattern | mapping_pattern | class_pattern
        mark = self._mark()
        if (
            (literal_pattern := self.literal_pattern())
        ):
            return literal_pattern
        self._reset(mark)
        if (
            (capture_pattern := self.capture_pattern())
        ):
            return capture_pattern
        self._reset(mark)
        if (
            (wildcard_pattern := self.wildcard_pattern())
        ):
            return wildcard_pattern
        self._reset(mark)
        if (
            (value_pattern := self.value_pattern())
        ):
            return value_pattern
        self._reset(mark)
        if (
            (group_pattern := self.group_pattern())
        ):
            return group_pattern
        self._reset(mark)
        if (
            (sequence_pattern := self.sequence_pattern())
        ):
            return sequence_pattern
        self._reset(mark)
        if (
            (mapping_pattern := self.mapping_pattern())
        ):
            return mapping_pattern
        self._reset(mark)
        if (
            (class_pattern := self.class_pattern())
        ):
            return class_pattern
        self._reset(mark)
        return None

    @memoize
    def literal_pattern(self) -> Optional[Any]:
        # literal_pattern: signed_number !('+' | '-') | complex_number | strings | 'None' | 'True' | 'False'
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (value := self.signed_number())
            and
            self.negative_lookahead(self._tmp_66, )
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchValue ( value = value , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (value := self.complex_number())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchValue ( value = value , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (value := self.strings())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchValue ( value = value , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('None'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchSingleton ( value = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('True'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchSingleton ( value = True , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('False'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchSingleton ( value = False , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def literal_expr(self) -> Optional[Any]:
        # literal_expr: signed_number !('+' | '-') | complex_number | strings | 'None' | 'True' | 'False'
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (signed_number := self.signed_number())
            and
            self.negative_lookahead(self._tmp_67, )
        ):
            return signed_number
        self._reset(mark)
        if (
            (complex_number := self.complex_number())
        ):
            return complex_number
        self._reset(mark)
        if (
            (strings := self.strings())
        ):
            return strings
        self._reset(mark)
        if (
            (literal := self.expect('None'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Constant ( value = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('True'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Constant ( value = True , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('False'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Constant ( value = False , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def complex_number(self) -> Optional[Any]:
        # complex_number: signed_real_number '+' imaginary_number | signed_real_number '-' imaginary_number
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (real := self.signed_real_number())
            and
            (literal := self.expect('+'))
            and
            (imag := self.imaginary_number())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BinOp ( left = real , op = ast . Add ( ) , right = imag , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (real := self.signed_real_number())
            and
            (literal := self.expect('-'))
            and
            (imag := self.imaginary_number())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BinOp ( left = real , op = ast . Sub ( ) , right = imag , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def signed_number(self) -> Optional[Any]:
        # signed_number: NUMBER | '-' NUMBER
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.number())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Constant ( value = ast . literal_eval ( a . string ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('-'))
            and
            (a := self.number())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . UnaryOp ( op = ast . USub ( ) , operand = ast . Constant ( value = ast . literal_eval ( a . string ) , lineno = a . start [0] , col_offset = a . start [1] , end_lineno = a . end [0] , end_col_offset = a . end [1] ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._reset(mark)
        return None

    @memoize
    def signed_real_number(self) -> Optional[Any]:
        # signed_real_number: real_number | '-' real_number
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (real_number := self.real_number())
        ):
            return real_number
        self._reset(mark)
        if (
            (literal := self.expect('-'))
            and
            (real := self.real_number())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . UnaryOp ( op = ast . USub ( ) , operand = real , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def real_number(self) -> Optional[ast . Constant]:
        # real_number: NUMBER
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (real := self.number())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Constant ( value = self . ensure_real ( real . string ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def imaginary_number(self) -> Optional[ast . Constant]:
        # imaginary_number: NUMBER
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (imag := self.number())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Constant ( value = self . ensure_imaginary ( imag . string ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def capture_pattern(self) -> Optional[Any]:
        # capture_pattern: pattern_capture_target
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (target := self.pattern_capture_target())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchAs ( pattern = None , name = target , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def pattern_capture_target(self) -> Optional[str]:
        # pattern_capture_target: !"_" NAME !('.' | '(' | '=')
        mark = self._mark()
        if (
            self.negative_lookahead(self.expect, "_")
            and
            (name := self.name())
            and
            self.negative_lookahead(self._tmp_68, )
        ):
            return name . string
        self._reset(mark)
        return None

    @memoize
    def wildcard_pattern(self) -> Optional["ast.MatchAs"]:
        # wildcard_pattern: "_"
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect("_"))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchAs ( pattern = None , target = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def value_pattern(self) -> Optional["ast.MatchValue"]:
        # value_pattern: attr !('.' | '(' | '=')
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (attr := self.attr())
            and
            self.negative_lookahead(self._tmp_69, )
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchValue ( value = attr , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize_left_rec
    def attr(self) -> Optional[ast . Attribute]:
        # attr: name_or_attr '.' NAME
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (value := self.name_or_attr())
            and
            (literal := self.expect('.'))
            and
            (attr := self.name())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Attribute ( value = value , attr = attr . string , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @logger
    def name_or_attr(self) -> Optional[Any]:
        # name_or_attr: attr | NAME
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (attr := self.attr())
        ):
            return attr
        self._reset(mark)
        if (
            (name := self.name())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Name ( id = name . string , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def group_pattern(self) -> Optional[Any]:
        # group_pattern: '(' pattern ')'
        mark = self._mark()
        if (
            (literal := self.expect('('))
            and
            (pattern := self.pattern())
            and
            (literal_1 := self.expect(')'))
        ):
            return pattern
        self._reset(mark)
        return None

    @memoize
    def sequence_pattern(self) -> Optional["ast.MatchSequence"]:
        # sequence_pattern: '[' maybe_sequence_pattern? ']' | '(' open_sequence_pattern? ')'
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('['))
            and
            (patterns := self.maybe_sequence_pattern(),)
            and
            (literal_1 := self.expect(']'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchSequence ( patterns = patterns or [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('('))
            and
            (patterns := self.open_sequence_pattern(),)
            and
            (literal_1 := self.expect(')'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchSequence ( patterns = patterns or [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def open_sequence_pattern(self) -> Optional[Any]:
        # open_sequence_pattern: maybe_star_pattern ',' maybe_sequence_pattern?
        mark = self._mark()
        if (
            (pattern := self.maybe_star_pattern())
            and
            (literal := self.expect(','))
            and
            (patterns := self.maybe_sequence_pattern(),)
        ):
            return [pattern] + ( patterns or [] )
        self._reset(mark)
        return None

    @memoize
    def maybe_sequence_pattern(self) -> Optional[Any]:
        # maybe_sequence_pattern: ','.maybe_star_pattern+ ','?
        mark = self._mark()
        if (
            (patterns := self._gather_70())
            and
            (opt := self.expect(','),)
        ):
            return patterns
        self._reset(mark)
        return None

    @memoize
    def maybe_star_pattern(self) -> Optional[Any]:
        # maybe_star_pattern: star_pattern | pattern
        mark = self._mark()
        if (
            (star_pattern := self.star_pattern())
        ):
            return star_pattern
        self._reset(mark)
        if (
            (pattern := self.pattern())
        ):
            return pattern
        self._reset(mark)
        return None

    @memoize
    def star_pattern(self) -> Optional[Any]:
        # star_pattern: '*' pattern_capture_target | '*' wildcard_pattern
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('*'))
            and
            (target := self.pattern_capture_target())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchStar ( name = target , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('*'))
            and
            (wildcard_pattern := self.wildcard_pattern())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchStar ( target = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def mapping_pattern(self) -> Optional[Any]:
        # mapping_pattern: '{' '}' | '{' double_star_pattern ','? '}' | '{' items_pattern ',' double_star_pattern ','? '}' | '{' items_pattern ','? '}'
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('{'))
            and
            (literal_1 := self.expect('}'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchMapping ( keys = [] , patterns = [] , rest = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('{'))
            and
            (rest := self.double_star_pattern())
            and
            (opt := self.expect(','),)
            and
            (literal_1 := self.expect('}'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchMapping ( keys = [] , patterns = [] , rest = rest , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('{'))
            and
            (items := self.items_pattern())
            and
            (literal_1 := self.expect(','))
            and
            (rest := self.double_star_pattern())
            and
            (opt := self.expect(','),)
            and
            (literal_2 := self.expect('}'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchMapping ( keys = [k for k , _ in items] , patterns = [p for _ , p in items] , rest = rest , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._reset(mark)
        if (
            (literal := self.expect('{'))
            and
            (items := self.items_pattern())
            and
            (opt := self.expect(','),)
            and
            (literal_1 := self.expect('}'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchMapping ( keys = [k for k , _ in items] , patterns = [p for _ , p in items] , rest = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._reset(mark)
        return None

    @memoize
    def items_pattern(self) -> Optional[Any]:
        # items_pattern: ','.key_value_pattern+
        mark = self._mark()
        if (
            (_gather_72 := self._gather_72())
        ):
            return _gather_72
        self._reset(mark)
        return None

    @memoize
    def key_value_pattern(self) -> Optional[Any]:
        # key_value_pattern: (literal_expr | attr) ':' pattern
        mark = self._mark()
        if (
            (key := self._tmp_74())
            and
            (literal := self.expect(':'))
            and
            (pattern := self.pattern())
        ):
            return ( key , pattern )
        self._reset(mark)
        return None

    @memoize
    def double_star_pattern(self) -> Optional[Any]:
        # double_star_pattern: '**' pattern_capture_target
        mark = self._mark()
        if (
            (literal := self.expect('**'))
            and
            (target := self.pattern_capture_target())
        ):
            return target
        self._reset(mark)
        return None

    @memoize
    def class_pattern(self) -> Optional["ast.MatchClass"]:
        # class_pattern: name_or_attr '(' ')' | name_or_attr '(' positional_patterns ','? ')' | name_or_attr '(' keyword_patterns ','? ')' | name_or_attr '(' positional_patterns ',' keyword_patterns ','? ')' | invalid_class_pattern
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (cls := self.name_or_attr())
            and
            (literal := self.expect('('))
            and
            (literal_1 := self.expect(')'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchClass ( cls = cls , patterns = [] , kwd_attrs = [] , kwd_patterns = [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (cls := self.name_or_attr())
            and
            (literal := self.expect('('))
            and
            (patterns := self.positional_patterns())
            and
            (opt := self.expect(','),)
            and
            (literal_1 := self.expect(')'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchClass ( cls = cls , patterns = patterns , kwd_attrs = [] , kwd_patterns = [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (cls := self.name_or_attr())
            and
            (literal := self.expect('('))
            and
            (keywords := self.keyword_patterns())
            and
            (opt := self.expect(','),)
            and
            (literal_1 := self.expect(')'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchClass ( cls = cls , patterns = [] , kwd_attrs = [k for k , _ in keywords] , kwd_patterns = [p for _ , p in keywords] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._reset(mark)
        if (
            (cls := self.name_or_attr())
            and
            (literal := self.expect('('))
            and
            (patterns := self.positional_patterns())
            and
            (literal_1 := self.expect(','))
            and
            (keywords := self.keyword_patterns())
            and
            (opt := self.expect(','),)
            and
            (literal_2 := self.expect(')'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . MatchClass ( cls = cls , patterns = patterns , kwd_attrs = [k for k , _ in keywords] , kwd_patterns = [p for _ , p in keywords] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._reset(mark)
        if (
            (invalid_class_pattern := self.invalid_class_pattern())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def positional_patterns(self) -> Optional[Any]:
        # positional_patterns: ','.pattern+
        mark = self._mark()
        if (
            (args := self._gather_75())
        ):
            return args
        self._reset(mark)
        return None

    @memoize
    def keyword_patterns(self) -> Optional[Any]:
        # keyword_patterns: ','.keyword_pattern+
        mark = self._mark()
        if (
            (_gather_77 := self._gather_77())
        ):
            return _gather_77
        self._reset(mark)
        return None

    @memoize
    def keyword_pattern(self) -> Optional[Any]:
        # keyword_pattern: NAME '=' pattern
        mark = self._mark()
        if (
            (arg := self.name())
            and
            (literal := self.expect('='))
            and
            (value := self.pattern())
        ):
            return ( arg . string , value )
        self._reset(mark)
        return None

    @memoize
    def expressions(self) -> Optional[Any]:
        # expressions: expression ((',' expression))+ ','? | expression ',' | expression
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.expression())
            and
            (b := self._loop1_79())
            and
            (opt := self.expect(','),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Tuple ( elts = [a] + b , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.expression())
            and
            (literal := self.expect(','))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Tuple ( elts = [a] , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (expression := self.expression())
        ):
            return expression
        self._reset(mark)
        return None

    @memoize
    def expression(self) -> Optional[Any]:
        # expression: invalid_expression | disjunction 'if' disjunction 'else' expression | disjunction '?' !'?' disjunction ':' expression | disjunction | lambdef
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (invalid_expression := self.invalid_expression())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (a := self.disjunction())
            and
            (literal := self.expect('if'))
            and
            (b := self.disjunction())
            and
            (literal_1 := self.expect('else'))
            and
            (c := self.expression())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . IfExp ( body = a , test = b , orelse = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (b := self.disjunction())
            and
            (literal := self.expect('?'))
            and
            self.negative_lookahead(self.expect, '?')
            and
            (a := self.disjunction())
            and
            (literal_1 := self.expect(':'))
            and
            (c := self.expression())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . IfExp ( body = a , test = b , orelse = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (disjunction := self.disjunction())
        ):
            return disjunction
        self._reset(mark)
        if (
            (lambdef := self.lambdef())
        ):
            return lambdef
        self._reset(mark)
        return None

    @memoize
    def yield_expr(self) -> Optional[Any]:
        # yield_expr: 'yield' 'from' expression | 'yield' star_expressions?
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('yield'))
            and
            (literal_1 := self.expect('from'))
            and
            (a := self.expression())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . YieldFrom ( value = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('yield'))
            and
            (a := self.star_expressions(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Yield ( value = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def star_expressions(self) -> Optional[Any]:
        # star_expressions: star_expression ((',' star_expression))+ ','? | star_expression ',' | star_expression
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.star_expression())
            and
            (b := self._loop1_80())
            and
            (opt := self.expect(','),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Tuple ( elts = [a] + b , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.star_expression())
            and
            (literal := self.expect(','))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Tuple ( elts = [a] , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (star_expression := self.star_expression())
        ):
            return star_expression
        self._reset(mark)
        return None

    @memoize
    def star_expression(self) -> Optional[Any]:
        # star_expression: '*' bitwise_or | expression
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('*'))
            and
            (a := self.bitwise_or())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Starred ( value = a , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (expression := self.expression())
        ):
            return expression
        self._reset(mark)
        return None

    @memoize
    def star_named_expressions(self) -> Optional[Any]:
        # star_named_expressions: ','.star_named_expression+ ','?
        mark = self._mark()
        if (
            (a := self._gather_81())
            and
            (opt := self.expect(','),)
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def star_named_expression(self) -> Optional[Any]:
        # star_named_expression: '*' bitwise_or | named_expression
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('*'))
            and
            (a := self.bitwise_or())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Starred ( value = a , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (named_expression := self.named_expression())
        ):
            return named_expression
        self._reset(mark)
        return None

    @memoize
    def assignment_expression(self) -> Optional[Any]:
        # assignment_expression: NAME ':=' ~ expression
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        cut = False
        if (
            (a := self.name())
            and
            (literal := self.expect(':='))
            and
            (cut := True)
            and
            (b := self.expression())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . check_version ( ( 3 , 8 ) , "The ':=' operator is" , ast . NamedExpr ( target = ast . Name ( id = a . string , ctx = Store , lineno = a . start [0] , col_offset = a . start [1] , end_lineno = a . end [0] , end_col_offset = a . end [1] ) , value = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , ) )
        self._reset(mark)
        if cut: return None
        return None

    @memoize
    def named_expression(self) -> Optional[Any]:
        # named_expression: assignment_expression | invalid_named_expression | expression !':='
        mark = self._mark()
        if (
            (assignment_expression := self.assignment_expression())
        ):
            return assignment_expression
        self._reset(mark)
        if (
            (invalid_named_expression := self.invalid_named_expression())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (a := self.expression())
            and
            self.negative_lookahead(self.expect, ':=')
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def disjunction(self) -> Optional[Any]:
        # disjunction: conjunction (('or' conjunction))+ | conjunction (('??' conjunction))+ | conjunction
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.conjunction())
            and
            (b := self._loop1_83())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BoolOp ( op = ast . Or ( ) , values = [a] + b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.conjunction())
            and
            (b := self._loop1_84())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . make_nullish_coalescing ( [a] + b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (conjunction := self.conjunction())
        ):
            return conjunction
        self._reset(mark)
        return None

    @memoize
    def conjunction(self) -> Optional[Any]:
        # conjunction: inversion (('and' inversion))+ | inversion
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.inversion())
            and
            (b := self._loop1_85())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BoolOp ( op = ast . And ( ) , values = [a] + b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (inversion := self.inversion())
        ):
            return inversion
        self._reset(mark)
        return None

    @memoize
    def inversion(self) -> Optional[Any]:
        # inversion: 'not' inversion | comparison
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('not'))
            and
            (a := self.inversion())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . UnaryOp ( op = ast . Not ( ) , operand = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (comparison := self.comparison())
        ):
            return comparison
        self._reset(mark)
        return None

    @memoize
    def comparison(self) -> Optional[Any]:
        # comparison: pipe_expression compare_op_pipe_expression_pair+ | pipe_expression
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.pipe_expression())
            and
            (b := self._loop1_86())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Compare ( left = a , ops = self . get_comparison_ops ( b ) , comparators = self . get_comparators ( b ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (pipe_expression := self.pipe_expression())
        ):
            return pipe_expression
        self._reset(mark)
        return None

    @memoize
    def compare_op_pipe_expression_pair(self) -> Optional[Any]:
        # compare_op_pipe_expression_pair: eq_pipe_expression | noteq_pipe_expression | lte_pipe_expression | lt_pipe_expression | gte_pipe_expression | gt_pipe_expression | notin_pipe_expression | in_pipe_expression | isnot_pipe_expression | is_pipe_expression
        mark = self._mark()
        if (
            (eq_pipe_expression := self.eq_pipe_expression())
        ):
            return eq_pipe_expression
        self._reset(mark)
        if (
            (noteq_pipe_expression := self.noteq_pipe_expression())
        ):
            return noteq_pipe_expression
        self._reset(mark)
        if (
            (lte_pipe_expression := self.lte_pipe_expression())
        ):
            return lte_pipe_expression
        self._reset(mark)
        if (
            (lt_pipe_expression := self.lt_pipe_expression())
        ):
            return lt_pipe_expression
        self._reset(mark)
        if (
            (gte_pipe_expression := self.gte_pipe_expression())
        ):
            return gte_pipe_expression
        self._reset(mark)
        if (
            (gt_pipe_expression := self.gt_pipe_expression())
        ):
            return gt_pipe_expression
        self._reset(mark)
        if (
            (notin_pipe_expression := self.notin_pipe_expression())
        ):
            return notin_pipe_expression
        self._reset(mark)
        if (
            (in_pipe_expression := self.in_pipe_expression())
        ):
            return in_pipe_expression
        self._reset(mark)
        if (
            (isnot_pipe_expression := self.isnot_pipe_expression())
        ):
            return isnot_pipe_expression
        self._reset(mark)
        if (
            (is_pipe_expression := self.is_pipe_expression())
        ):
            return is_pipe_expression
        self._reset(mark)
        return None

    @memoize
    def eq_pipe_expression(self) -> Optional[Any]:
        # eq_pipe_expression: '==' pipe_expression
        mark = self._mark()
        if (
            (literal := self.expect('=='))
            and
            (a := self.pipe_expression())
        ):
            return ( ast . Eq ( ) , a )
        self._reset(mark)
        return None

    @memoize
    def noteq_pipe_expression(self) -> Optional[tuple]:
        # noteq_pipe_expression: '!=' pipe_expression
        mark = self._mark()
        if (
            (literal := self.expect('!='))
            and
            (a := self.pipe_expression())
        ):
            return ( ast . NotEq ( ) , a )
        self._reset(mark)
        return None

    @memoize
    def lte_pipe_expression(self) -> Optional[Any]:
        # lte_pipe_expression: '<=' pipe_expression
        mark = self._mark()
        if (
            (literal := self.expect('<='))
            and
            (a := self.pipe_expression())
        ):
            return ( ast . LtE ( ) , a )
        self._reset(mark)
        return None

    @memoize
    def lt_pipe_expression(self) -> Optional[Any]:
        # lt_pipe_expression: '<' pipe_expression
        mark = self._mark()
        if (
            (literal := self.expect('<'))
            and
            (a := self.pipe_expression())
        ):
            return ( ast . Lt ( ) , a )
        self._reset(mark)
        return None

    @memoize
    def gte_pipe_expression(self) -> Optional[Any]:
        # gte_pipe_expression: '>=' pipe_expression
        mark = self._mark()
        if (
            (literal := self.expect('>='))
            and
            (a := self.pipe_expression())
        ):
            return ( ast . GtE ( ) , a )
        self._reset(mark)
        return None

    @memoize
    def gt_pipe_expression(self) -> Optional[Any]:
        # gt_pipe_expression: '>' pipe_expression
        mark = self._mark()
        if (
            (literal := self.expect('>'))
            and
            (a := self.pipe_expression())
        ):
            return ( ast . Gt ( ) , a )
        self._reset(mark)
        return None

    @memoize
    def notin_pipe_expression(self) -> Optional[Any]:
        # notin_pipe_expression: 'not' 'in' pipe_expression
        mark = self._mark()
        if (
            (literal := self.expect('not'))
            and
            (literal_1 := self.expect('in'))
            and
            (a := self.pipe_expression())
        ):
            return ( ast . NotIn ( ) , a )
        self._reset(mark)
        return None

    @memoize
    def in_pipe_expression(self) -> Optional[Any]:
        # in_pipe_expression: 'in' pipe_expression
        mark = self._mark()
        if (
            (literal := self.expect('in'))
            and
            (a := self.pipe_expression())
        ):
            return ( ast . In ( ) , a )
        self._reset(mark)
        return None

    @memoize
    def isnot_pipe_expression(self) -> Optional[Any]:
        # isnot_pipe_expression: 'is' 'not' pipe_expression
        mark = self._mark()
        if (
            (literal := self.expect('is'))
            and
            (literal_1 := self.expect('not'))
            and
            (a := self.pipe_expression())
        ):
            return ( ast . IsNot ( ) , a )
        self._reset(mark)
        return None

    @memoize
    def is_pipe_expression(self) -> Optional[Any]:
        # is_pipe_expression: 'is' pipe_expression
        mark = self._mark()
        if (
            (literal := self.expect('is'))
            and
            (a := self.pipe_expression())
        ):
            return ( ast . Is ( ) , a )
        self._reset(mark)
        return None

    @memoize_left_rec
    def pipe_expression(self) -> Optional[Any]:
        # pipe_expression: pipe_expression '|>' bitwise_or | bitwise_or
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.pipe_expression())
            and
            (literal := self.expect('|>'))
            and
            (b := self.bitwise_or())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Call ( func = b , args = [a] , keywords = [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (bitwise_or := self.bitwise_or())
        ):
            return bitwise_or
        self._reset(mark)
        return None

    @memoize_left_rec
    def bitwise_or(self) -> Optional[Any]:
        # bitwise_or: bitwise_or '|' bitwise_xor | bitwise_xor
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.bitwise_or())
            and
            (literal := self.expect('|'))
            and
            (b := self.bitwise_xor())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BinOp ( left = a , op = ast . BitOr ( ) , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (bitwise_xor := self.bitwise_xor())
        ):
            return bitwise_xor
        self._reset(mark)
        return None

    @memoize_left_rec
    def bitwise_xor(self) -> Optional[Any]:
        # bitwise_xor: bitwise_xor '^' bitwise_and | bitwise_and
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.bitwise_xor())
            and
            (literal := self.expect('^'))
            and
            (b := self.bitwise_and())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BinOp ( left = a , op = ast . BitXor ( ) , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (bitwise_and := self.bitwise_and())
        ):
            return bitwise_and
        self._reset(mark)
        return None

    @memoize_left_rec
    def bitwise_and(self) -> Optional[Any]:
        # bitwise_and: bitwise_and '&' shift_expr | shift_expr
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.bitwise_and())
            and
            (literal := self.expect('&'))
            and
            (b := self.shift_expr())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BinOp ( left = a , op = ast . BitAnd ( ) , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (shift_expr := self.shift_expr())
        ):
            return shift_expr
        self._reset(mark)
        return None

    @memoize_left_rec
    def shift_expr(self) -> Optional[Any]:
        # shift_expr: shift_expr '<<' sum | shift_expr '>>' sum | sum
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.shift_expr())
            and
            (literal := self.expect('<<'))
            and
            (b := self.sum())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BinOp ( left = a , op = ast . LShift ( ) , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.shift_expr())
            and
            (literal := self.expect('>>'))
            and
            (b := self.sum())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BinOp ( left = a , op = ast . RShift ( ) , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (sum := self.sum())
        ):
            return sum
        self._reset(mark)
        return None

    @memoize_left_rec
    def sum(self) -> Optional[Any]:
        # sum: sum '+' term | sum '-' term | term
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.sum())
            and
            (literal := self.expect('+'))
            and
            (b := self.term())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BinOp ( left = a , op = ast . Add ( ) , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.sum())
            and
            (literal := self.expect('-'))
            and
            (b := self.term())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BinOp ( left = a , op = ast . Sub ( ) , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (term := self.term())
        ):
            return term
        self._reset(mark)
        return None

    @memoize_left_rec
    def term(self) -> Optional[Any]:
        # term: term '*' factor | term '/' factor | term '//' factor | term '%' factor | term '@' factor | factor
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.term())
            and
            (literal := self.expect('*'))
            and
            (b := self.factor())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BinOp ( left = a , op = ast . Mult ( ) , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.term())
            and
            (literal := self.expect('/'))
            and
            (b := self.factor())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BinOp ( left = a , op = ast . Div ( ) , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.term())
            and
            (literal := self.expect('//'))
            and
            (b := self.factor())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BinOp ( left = a , op = ast . FloorDiv ( ) , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.term())
            and
            (literal := self.expect('%'))
            and
            (b := self.factor())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BinOp ( left = a , op = ast . Mod ( ) , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.term())
            and
            (literal := self.expect('@'))
            and
            (b := self.factor())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . check_version ( ( 3 , 5 ) , "The '@' operator is" , ast . BinOp ( left = a , op = ast . MatMult ( ) , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._reset(mark)
        if (
            (factor := self.factor())
        ):
            return factor
        self._reset(mark)
        return None

    @memoize
    def factor(self) -> Optional[Any]:
        # factor: '+' factor | '-' factor | '~' factor | power
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('+'))
            and
            (a := self.factor())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . UnaryOp ( op = ast . UAdd ( ) , operand = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('-'))
            and
            (a := self.factor())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . UnaryOp ( op = ast . USub ( ) , operand = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('~'))
            and
            (a := self.factor())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . UnaryOp ( op = ast . Invert ( ) , operand = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (power := self.power())
        ):
            return power
        self._reset(mark)
        return None

    @memoize
    def power(self) -> Optional[Any]:
        # power: await_primary '**' factor | await_primary
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.await_primary())
            and
            (literal := self.expect('**'))
            and
            (b := self.factor())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . BinOp ( left = a , op = ast . Pow ( ) , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (await_primary := self.await_primary())
        ):
            return await_primary
        self._reset(mark)
        return None

    @memoize
    def await_primary(self) -> Optional[Any]:
        # await_primary: 'await' primary | primary
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('await'))
            and
            (a := self.primary())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . check_version ( ( 3 , 5 ) , "Await expressions are" , ast . Await ( a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._reset(mark)
        if (
            (primary := self.primary())
        ):
            return primary
        self._reset(mark)
        return None

    @memoize_left_rec
    def primary(self) -> Optional[Any]:
        # primary: primary '.' NAME | primary '?' '.' NAME '(' arguments? ')' | primary '?' '.' NAME | primary genexp | primary '(' arguments? ')' | primary '(' partial_arguments ')' | primary '[' slices ']' | primary '?' '[' slice ']' | atom
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.primary())
            and
            (literal := self.expect('.'))
            and
            (b := self.name())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Attribute ( value = a , attr = b . string , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.primary())
            and
            (literal := self.expect('?'))
            and
            (literal_1 := self.expect('.'))
            and
            (b := self.name())
            and
            (literal_2 := self.expect('('))
            and
            (c := self.arguments(),)
            and
            (literal_3 := self.expect(')'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . make_optional_chaining ( a , ast . Call ( func = ast . Attribute ( value = a , attr = b . string , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) , args = c [0] if c else [] , keywords = c [1] if c else [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.primary())
            and
            (literal := self.expect('?'))
            and
            (literal_1 := self.expect('.'))
            and
            (b := self.name())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . make_optional_chaining ( a , ast . Attribute ( value = a , attr = b . string , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.primary())
            and
            (b := self.genexp())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Call ( func = a , args = [b] , keywords = [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.primary())
            and
            (literal := self.expect('('))
            and
            (b := self.arguments(),)
            and
            (literal_1 := self.expect(')'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Call ( func = a , args = b [0] if b else [] , keywords = b [1] if b else [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._reset(mark)
        if (
            (a := self.primary())
            and
            (literal := self.expect('('))
            and
            (b := self.partial_arguments())
            and
            (literal_1 := self.expect(')'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . make_partial_function ( a , b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.primary())
            and
            (literal := self.expect('['))
            and
            (b := self.slices())
            and
            (literal_1 := self.expect(']'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Subscript ( value = a , slice = b , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.primary())
            and
            (literal := self.expect('?'))
            and
            (literal_1 := self.expect('['))
            and
            (b := self.slice())
            and
            (literal_2 := self.expect(']'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . make_optional_chaining ( a , ast . Subscript ( value = a , slice = b , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (atom := self.atom())
        ):
            return atom
        self._reset(mark)
        return None

    @memoize
    def slices(self) -> Optional[Any]:
        # slices: slice !',' | ','.slice+ ','?
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.slice())
            and
            self.negative_lookahead(self.expect, ',')
        ):
            return a
        self._reset(mark)
        if (
            (a := self._gather_87())
            and
            (opt := self.expect(','),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Tuple ( elts = a , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) if sys . version_info >= ( 3 , 9 ) else ( ast . ExtSlice ( dims = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) if any ( isinstance ( e , ast . Slice ) for e in a ) else ast . Index ( value = ast . Tuple ( elts = [e . value for e in a] , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._reset(mark)
        return None

    @memoize
    def slice(self) -> Optional[Any]:
        # slice: expression? ':' expression? [':' expression?] | named_expression
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.expression(),)
            and
            (literal := self.expect(':'))
            and
            (b := self.expression(),)
            and
            (c := self._tmp_89(),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Slice ( lower = a , upper = b , step = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.named_expression())
        ):
            return a if sys . version_info >= ( 3 , 9 ) or isinstance ( a , ast . Slice ) else ast . Index ( value = a , lineno = a . lineno , col_offset = a . col_offset , end_lineno = a . end_lineno , end_col_offset = a . end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def atom(self) -> Optional[Any]:
        # atom: NAME | 'True' | 'False' | 'None' | &STRING strings | NUMBER | &'(' (tuple | group | genexp) | &'[' (list | listcomp) | &'{' (dict | set | dictcomp | setcomp) | '...'
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.name())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Name ( id = a . string , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('True'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Constant ( value = True , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) if sys . version_info >= ( 3 , 9 ) else ast . Constant ( value = True , kind = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('False'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Constant ( value = False , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) if sys . version_info >= ( 3 , 9 ) else ast . Constant ( value = False , kind = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('None'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Constant ( value = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) if sys . version_info >= ( 3 , 9 ) else ast . Constant ( value = None , kind = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            self.positive_lookahead(self.string, )
            and
            (strings := self.strings())
        ):
            return strings
        self._reset(mark)
        if (
            (a := self.number())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Constant ( value = ast . literal_eval ( a . string ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) if sys . version_info >= ( 3 , 9 ) else ast . Constant ( value = ast . literal_eval ( a . string ) , kind = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            self.positive_lookahead(self.expect, '(')
            and
            (_tmp_90 := self._tmp_90())
        ):
            return _tmp_90
        self._reset(mark)
        if (
            self.positive_lookahead(self.expect, '[')
            and
            (_tmp_91 := self._tmp_91())
        ):
            return _tmp_91
        self._reset(mark)
        if (
            self.positive_lookahead(self.expect, '{')
            and
            (_tmp_92 := self._tmp_92())
        ):
            return _tmp_92
        self._reset(mark)
        if (
            (literal := self.expect('...'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Constant ( value = Ellipsis , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) if sys . version_info >= ( 3 , 9 ) else ast . Constant ( value = Ellipsis , kind = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def group(self) -> Optional[Any]:
        # group: '(' (yield_expr | named_expression) ')' | invalid_group
        mark = self._mark()
        if (
            (literal := self.expect('('))
            and
            (a := self._tmp_93())
            and
            (literal_1 := self.expect(')'))
        ):
            return a
        self._reset(mark)
        if (
            (invalid_group := self.invalid_group())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def lambdef(self) -> Optional[Any]:
        # lambdef: 'lambda' lambda_params? ':' expression
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('lambda'))
            and
            (a := self.lambda_params(),)
            and
            (literal_1 := self.expect(':'))
            and
            (b := self.expression())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Lambda ( args = a or self . make_arguments ( None , [] , None , [] , ( None , [] , None ) ) , body = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def lambda_params(self) -> Optional[Any]:
        # lambda_params: invalid_lambda_parameters | lambda_parameters
        mark = self._mark()
        if (
            (invalid_lambda_parameters := self.invalid_lambda_parameters())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (lambda_parameters := self.lambda_parameters())
        ):
            return lambda_parameters
        self._reset(mark)
        return None

    @memoize
    def lambda_parameters(self) -> Optional[ast . arguments]:
        # lambda_parameters: lambda_slash_no_default lambda_param_no_default* lambda_param_with_default* lambda_star_etc? | lambda_slash_with_default lambda_param_with_default* lambda_star_etc? | lambda_param_no_default+ lambda_param_with_default* lambda_star_etc? | lambda_param_with_default+ lambda_star_etc? | lambda_star_etc
        mark = self._mark()
        if (
            (a := self.lambda_slash_no_default())
            and
            (b := self._loop0_94(),)
            and
            (c := self._loop0_95(),)
            and
            (d := self.lambda_star_etc(),)
        ):
            return self . make_arguments ( a , [] , b , c , d )
        self._reset(mark)
        if (
            (a := self.lambda_slash_with_default())
            and
            (b := self._loop0_96(),)
            and
            (c := self.lambda_star_etc(),)
        ):
            return self . make_arguments ( None , a , None , b , c )
        self._reset(mark)
        if (
            (a := self._loop1_97())
            and
            (b := self._loop0_98(),)
            and
            (c := self.lambda_star_etc(),)
        ):
            return self . make_arguments ( None , [] , a , b , c )
        self._reset(mark)
        if (
            (a := self._loop1_99())
            and
            (b := self.lambda_star_etc(),)
        ):
            return self . make_arguments ( None , [] , None , a , b )
        self._reset(mark)
        if (
            (a := self.lambda_star_etc())
        ):
            return self . make_arguments ( None , [] , None , [] , a )
        self._reset(mark)
        return None

    @memoize
    def lambda_slash_no_default(self) -> Optional[List [Tuple [ast . arg , None]]]:
        # lambda_slash_no_default: lambda_param_no_default+ '/' ',' | lambda_param_no_default+ '/' &':'
        mark = self._mark()
        if (
            (a := self._loop1_100())
            and
            (literal := self.expect('/'))
            and
            (literal_1 := self.expect(','))
        ):
            return [( p , None ) for p in a]
        self._reset(mark)
        if (
            (a := self._loop1_101())
            and
            (literal := self.expect('/'))
            and
            self.positive_lookahead(self.expect, ':')
        ):
            return [( p , None ) for p in a]
        self._reset(mark)
        return None

    @memoize
    def lambda_slash_with_default(self) -> Optional[List [Tuple [ast . arg , Any]]]:
        # lambda_slash_with_default: lambda_param_no_default* lambda_param_with_default+ '/' ',' | lambda_param_no_default* lambda_param_with_default+ '/' &':'
        mark = self._mark()
        if (
            (a := self._loop0_102(),)
            and
            (b := self._loop1_103())
            and
            (literal := self.expect('/'))
            and
            (literal_1 := self.expect(','))
        ):
            return ( [( p , None ) for p in a] if a else [] ) + b
        self._reset(mark)
        if (
            (a := self._loop0_104(),)
            and
            (b := self._loop1_105())
            and
            (literal := self.expect('/'))
            and
            self.positive_lookahead(self.expect, ':')
        ):
            return ( [( p , None ) for p in a] if a else [] ) + b
        self._reset(mark)
        return None

    @memoize
    def lambda_star_etc(self) -> Optional[Tuple [Optional [ast . arg] , List [Tuple [ast . arg , Any]] , Optional [ast . arg]]]:
        # lambda_star_etc: '*' lambda_param_no_default lambda_param_maybe_default* lambda_kwds? | '*' ',' lambda_param_maybe_default+ lambda_kwds? | lambda_kwds | invalid_lambda_star_etc
        mark = self._mark()
        if (
            (literal := self.expect('*'))
            and
            (a := self.lambda_param_no_default())
            and
            (b := self._loop0_106(),)
            and
            (c := self.lambda_kwds(),)
        ):
            return ( a , b , c )
        self._reset(mark)
        if (
            (literal := self.expect('*'))
            and
            (literal_1 := self.expect(','))
            and
            (b := self._loop1_107())
            and
            (c := self.lambda_kwds(),)
        ):
            return ( None , b , c )
        self._reset(mark)
        if (
            (a := self.lambda_kwds())
        ):
            return ( None , [] , a )
        self._reset(mark)
        if (
            (invalid_lambda_star_etc := self.invalid_lambda_star_etc())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def lambda_kwds(self) -> Optional[ast . arg]:
        # lambda_kwds: '**' lambda_param_no_default
        mark = self._mark()
        if (
            (literal := self.expect('**'))
            and
            (a := self.lambda_param_no_default())
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def lambda_param_no_default(self) -> Optional[ast . arg]:
        # lambda_param_no_default: lambda_param ',' | lambda_param &':'
        mark = self._mark()
        if (
            (a := self.lambda_param())
            and
            (literal := self.expect(','))
        ):
            return a
        self._reset(mark)
        if (
            (a := self.lambda_param())
            and
            self.positive_lookahead(self.expect, ':')
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def lambda_param_with_default(self) -> Optional[Tuple [ast . arg , Any]]:
        # lambda_param_with_default: lambda_param default ',' | lambda_param default &':'
        mark = self._mark()
        if (
            (a := self.lambda_param())
            and
            (c := self.default())
            and
            (literal := self.expect(','))
        ):
            return ( a , c )
        self._reset(mark)
        if (
            (a := self.lambda_param())
            and
            (c := self.default())
            and
            self.positive_lookahead(self.expect, ':')
        ):
            return ( a , c )
        self._reset(mark)
        return None

    @memoize
    def lambda_param_maybe_default(self) -> Optional[Tuple [ast . arg , Any]]:
        # lambda_param_maybe_default: lambda_param default? ',' | lambda_param default? &':'
        mark = self._mark()
        if (
            (a := self.lambda_param())
            and
            (c := self.default(),)
            and
            (literal := self.expect(','))
        ):
            return ( a , c )
        self._reset(mark)
        if (
            (a := self.lambda_param())
            and
            (c := self.default(),)
            and
            self.positive_lookahead(self.expect, ':')
        ):
            return ( a , c )
        self._reset(mark)
        return None

    @memoize
    def lambda_param(self) -> Optional[ast . arg]:
        # lambda_param: NAME
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.name())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . arg ( arg = a . string , annotation = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) if sys . version_info >= ( 3 , 9 ) else ast . arg ( arg = a . string , annotation = None , type_comment = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def strings(self) -> Optional[ast . Str]:
        # strings: STRING+
        mark = self._mark()
        if (
            (a := self._loop1_108())
        ):
            return self . generate_ast_for_string ( a )
        self._reset(mark)
        return None

    @memoize
    def list(self) -> Optional[ast . List]:
        # list: '[' star_named_expressions? ']'
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('['))
            and
            (a := self.star_named_expressions(),)
            and
            (literal_1 := self.expect(']'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . List ( elts = a or [] , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def tuple(self) -> Optional[ast . Tuple]:
        # tuple: '(' [star_named_expression ',' star_named_expressions?] ')'
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('('))
            and
            (a := self._tmp_109(),)
            and
            (literal_1 := self.expect(')'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Tuple ( elts = a or [] , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def set(self) -> Optional[ast . Set]:
        # set: '{' star_named_expressions '}'
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('{'))
            and
            (a := self.star_named_expressions())
            and
            (literal_1 := self.expect('}'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Set ( elts = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def dict(self) -> Optional[ast . Dict]:
        # dict: '{' double_starred_kvpairs? '}' | '{' invalid_double_starred_kvpairs '}'
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('{'))
            and
            (a := self.double_starred_kvpairs(),)
            and
            (literal_1 := self.expect('}'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Dict ( keys = [kv [0] for kv in ( a or [] )] , values = [kv [1] for kv in ( a or [] )] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('{'))
            and
            (invalid_double_starred_kvpairs := self.invalid_double_starred_kvpairs())
            and
            (literal_1 := self.expect('}'))
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def double_starred_kvpairs(self) -> Optional[list]:
        # double_starred_kvpairs: ','.double_starred_kvpair+ ','?
        mark = self._mark()
        if (
            (a := self._gather_110())
            and
            (opt := self.expect(','),)
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def double_starred_kvpair(self) -> Optional[Any]:
        # double_starred_kvpair: '**' bitwise_or | kvpair
        mark = self._mark()
        if (
            (literal := self.expect('**'))
            and
            (a := self.bitwise_or())
        ):
            return ( None , a )
        self._reset(mark)
        if (
            (kvpair := self.kvpair())
        ):
            return kvpair
        self._reset(mark)
        return None

    @memoize
    def kvpair(self) -> Optional[tuple]:
        # kvpair: expression ':' expression
        mark = self._mark()
        if (
            (a := self.expression())
            and
            (literal := self.expect(':'))
            and
            (b := self.expression())
        ):
            return ( a , b )
        self._reset(mark)
        return None

    @memoize
    def for_if_clauses(self) -> Optional[List [ast . comprehension]]:
        # for_if_clauses: for_if_clause+
        mark = self._mark()
        if (
            (a := self._loop1_112())
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def for_if_clause(self) -> Optional[ast . comprehension]:
        # for_if_clause: 'async' 'for' star_targets 'in' ~ disjunction (('if' disjunction))* | 'for' star_targets 'in' ~ disjunction (('if' disjunction))* | invalid_for_target
        mark = self._mark()
        cut = False
        if (
            (literal := self.expect('async'))
            and
            (literal_1 := self.expect('for'))
            and
            (a := self.star_targets())
            and
            (literal_2 := self.expect('in'))
            and
            (cut := True)
            and
            (b := self.disjunction())
            and
            (c := self._loop0_113(),)
        ):
            return self . check_version ( ( 3 , 6 ) , "Async comprehensions are" , ast . comprehension ( target = a , iter = b , ifs = c , is_async = 1 ) )
        self._reset(mark)
        if cut: return None
        cut = False
        if (
            (literal := self.expect('for'))
            and
            (a := self.star_targets())
            and
            (literal_1 := self.expect('in'))
            and
            (cut := True)
            and
            (b := self.disjunction())
            and
            (c := self._loop0_114(),)
        ):
            return ast . comprehension ( target = a , iter = b , ifs = c , is_async = 0 )
        self._reset(mark)
        if cut: return None
        if (
            (invalid_for_target := self.invalid_for_target())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def listcomp(self) -> Optional[ast . ListComp]:
        # listcomp: '[' named_expression for_if_clauses ']' | invalid_comprehension
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('['))
            and
            (a := self.named_expression())
            and
            (b := self.for_if_clauses())
            and
            (literal_1 := self.expect(']'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . ListComp ( elt = a , generators = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (invalid_comprehension := self.invalid_comprehension())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def setcomp(self) -> Optional[ast . SetComp]:
        # setcomp: '{' named_expression for_if_clauses '}' | invalid_comprehension
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('{'))
            and
            (a := self.named_expression())
            and
            (b := self.for_if_clauses())
            and
            (literal_1 := self.expect('}'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . SetComp ( elt = a , generators = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (invalid_comprehension := self.invalid_comprehension())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def genexp(self) -> Optional[ast . GeneratorExp]:
        # genexp: '(' (assignment_expression | expression !':=') for_if_clauses ')' | invalid_comprehension
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('('))
            and
            (a := self._tmp_115())
            and
            (b := self.for_if_clauses())
            and
            (literal_1 := self.expect(')'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . GeneratorExp ( elt = a , generators = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (invalid_comprehension := self.invalid_comprehension())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def dictcomp(self) -> Optional[ast . DictComp]:
        # dictcomp: '{' kvpair for_if_clauses '}' | invalid_dict_comprehension
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('{'))
            and
            (a := self.kvpair())
            and
            (b := self.for_if_clauses())
            and
            (literal_1 := self.expect('}'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . DictComp ( key = a [0] , value = a [1] , generators = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (invalid_dict_comprehension := self.invalid_dict_comprehension())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def arguments(self) -> Optional[Tuple [list , list]]:
        # arguments: args ','? &')' | invalid_arguments
        mark = self._mark()
        if (
            (a := self.args())
            and
            (opt := self.expect(','),)
            and
            self.positive_lookahead(self.expect, ')')
        ):
            return a
        self._reset(mark)
        if (
            (invalid_arguments := self.invalid_arguments())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def args(self) -> Optional[Tuple [list , list]]:
        # args: ','.(starred_expression | (assignment_expression | expression !':=') !'=')+ [',' kwargs] | kwargs
        mark = self._mark()
        if (
            (a := self._gather_116())
            and
            (b := self._tmp_118(),)
        ):
            return ( a + ( [e for e in b if isinstance ( e , ast . Starred )] if b else [] ) , ( [e for e in b if not isinstance ( e , ast . Starred )] if b else [] ) )
        self._reset(mark)
        if (
            (a := self.kwargs())
        ):
            return ( [e for e in a if isinstance ( e , ast . Starred )] , [e for e in a if not isinstance ( e , ast . Starred )] )
        self._reset(mark)
        return None

    @memoize
    def kwargs(self) -> Optional[list]:
        # kwargs: ','.kwarg_or_starred+ ',' ','.kwarg_or_double_starred+ | ','.kwarg_or_starred+ | ','.kwarg_or_double_starred+
        mark = self._mark()
        if (
            (a := self._gather_119())
            and
            (literal := self.expect(','))
            and
            (b := self._gather_121())
        ):
            return a + b
        self._reset(mark)
        if (
            (_gather_123 := self._gather_123())
        ):
            return _gather_123
        self._reset(mark)
        if (
            (_gather_125 := self._gather_125())
        ):
            return _gather_125
        self._reset(mark)
        return None

    @memoize
    def starred_expression(self) -> Optional[Any]:
        # starred_expression: '*' expression
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('*'))
            and
            (a := self.expression())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Starred ( value = a , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def kwarg_or_starred(self) -> Optional[Any]:
        # kwarg_or_starred: invalid_kwarg | NAME '=' expression | starred_expression
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (invalid_kwarg := self.invalid_kwarg())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (a := self.name())
            and
            (literal := self.expect('='))
            and
            (b := self.expression())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . keyword ( arg = a . string , value = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.starred_expression())
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def kwarg_or_double_starred(self) -> Optional[Any]:
        # kwarg_or_double_starred: invalid_kwarg | NAME '=' expression | '**' expression
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (invalid_kwarg := self.invalid_kwarg())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (a := self.name())
            and
            (literal := self.expect('='))
            and
            (b := self.expression())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . keyword ( arg = a . string , value = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('**'))
            and
            (a := self.expression())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . keyword ( arg = None , value = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def partial_arguments(self) -> Optional[Tuple [list , list]]:
        # partial_arguments: partial_args ','? &')' | invalid_arguments
        mark = self._mark()
        if (
            (a := self.partial_args())
            and
            (opt := self.expect(','),)
            and
            self.positive_lookahead(self.expect, ')')
        ):
            return a
        self._reset(mark)
        if (
            (invalid_arguments := self.invalid_arguments())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def partial_args(self) -> Optional[Tuple [list , list]]:
        # partial_args: ",".(partial_placeholder | partial_starred_expression | (assignment_expression | expression !':=') !'=')+ [',' partial_kwargs] | partial_kwargs
        mark = self._mark()
        if (
            (a := self._gather_127())
            and
            (b := self._tmp_129(),)
        ):
            return ( a + ( [e for e in b if isinstance ( e , ast . Starred )] if b else [] ) , ( [e for e in b if not isinstance ( e , ast . Starred )] if b else [] ) )
        self._reset(mark)
        if (
            (a := self.partial_kwargs())
        ):
            return ( [e for e in a if isinstance ( e , ast . Starred )] , [e for e in a if not isinstance ( e , ast . Starred )] )
        self._reset(mark)
        return None

    @memoize
    def partial_kwargs(self) -> Optional[list]:
        # partial_kwargs: ','.partial_kwarg_or_starred+ ',' ','.partial_kwarg_or_double_starred+ | ','.partial_kwarg_or_starred+ | ','.partial_kwarg_or_double_starred+
        mark = self._mark()
        if (
            (a := self._gather_130())
            and
            (literal := self.expect(','))
            and
            (b := self._gather_132())
        ):
            return a + b
        self._reset(mark)
        if (
            (_gather_134 := self._gather_134())
        ):
            return _gather_134
        self._reset(mark)
        if (
            (_gather_136 := self._gather_136())
        ):
            return _gather_136
        self._reset(mark)
        return None

    @memoize
    def partial_starred_expression(self) -> Optional[Any]:
        # partial_starred_expression: '*' (partial_placeholder | expression)
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('*'))
            and
            (a := self._tmp_138())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Starred ( value = a , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def partial_kwarg_or_starred(self) -> Optional[Any]:
        # partial_kwarg_or_starred: invalid_kwarg | NAME '=' (partial_placeholder | expression) | partial_starred_expression
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (invalid_kwarg := self.invalid_kwarg())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (a := self.name())
            and
            (literal := self.expect('='))
            and
            (b := self._tmp_139())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . keyword ( arg = a . string , value = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.partial_starred_expression())
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def partial_kwarg_or_double_starred(self) -> Optional[Any]:
        # partial_kwarg_or_double_starred: invalid_kwarg | NAME '=' (partial_placeholder | expression) | '**' (partial_placeholder | expression)
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (invalid_kwarg := self.invalid_kwarg())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (a := self.name())
            and
            (literal := self.expect('='))
            and
            (b := self._tmp_140())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . keyword ( arg = a . string , value = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('**'))
            and
            (a := self._tmp_141())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . keyword ( arg = None , value = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def partial_placeholder(self) -> Optional[Any]:
        # partial_placeholder: '?'
        mark = self._mark()
        if (
            (literal := self.expect('?'))
        ):
            return "?"
        self._reset(mark)
        return None

    @memoize
    def star_targets(self) -> Optional[Any]:
        # star_targets: star_target !',' | star_target ((',' star_target))* ','?
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.star_target())
            and
            self.negative_lookahead(self.expect, ',')
        ):
            return a
        self._reset(mark)
        if (
            (a := self.star_target())
            and
            (b := self._loop0_142(),)
            and
            (opt := self.expect(','),)
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Tuple ( elts = [a] + b , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def star_targets_list_seq(self) -> Optional[list]:
        # star_targets_list_seq: ','.star_target+ ','?
        mark = self._mark()
        if (
            (a := self._gather_143())
            and
            (opt := self.expect(','),)
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def star_targets_tuple_seq(self) -> Optional[list]:
        # star_targets_tuple_seq: star_target ((',' star_target))+ ','? | star_target ','
        mark = self._mark()
        if (
            (a := self.star_target())
            and
            (b := self._loop1_145())
            and
            (opt := self.expect(','),)
        ):
            return [a] + b
        self._reset(mark)
        if (
            (a := self.star_target())
            and
            (literal := self.expect(','))
        ):
            return [a]
        self._reset(mark)
        return None

    @memoize
    def star_target(self) -> Optional[Any]:
        # star_target: '*' (!'*' star_target) | target_with_star_atom
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (literal := self.expect('*'))
            and
            (a := self._tmp_146())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Starred ( value = self . set_expr_context ( a , Store ) , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (target_with_star_atom := self.target_with_star_atom())
        ):
            return target_with_star_atom
        self._reset(mark)
        return None

    @memoize
    def target_with_star_atom(self) -> Optional[Any]:
        # target_with_star_atom: t_primary '.' NAME !t_lookahead | t_primary '[' slices ']' !t_lookahead | star_atom
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.t_primary())
            and
            (literal := self.expect('.'))
            and
            (b := self.name())
            and
            self.negative_lookahead(self.t_lookahead, )
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Attribute ( value = a , attr = b . string , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.t_primary())
            and
            (literal := self.expect('['))
            and
            (b := self.slices())
            and
            (literal_1 := self.expect(']'))
            and
            self.negative_lookahead(self.t_lookahead, )
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Subscript ( value = a , slice = b , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (star_atom := self.star_atom())
        ):
            return star_atom
        self._reset(mark)
        return None

    @memoize
    def star_atom(self) -> Optional[Any]:
        # star_atom: NAME | '(' target_with_star_atom ')' | '(' star_targets_tuple_seq? ')' | '[' star_targets_list_seq? ']'
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.name())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Name ( id = a . string , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('('))
            and
            (a := self.target_with_star_atom())
            and
            (literal_1 := self.expect(')'))
        ):
            return self . set_expr_context ( a , Store )
        self._reset(mark)
        if (
            (literal := self.expect('('))
            and
            (a := self.star_targets_tuple_seq(),)
            and
            (literal_1 := self.expect(')'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Tuple ( elts = a , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('['))
            and
            (a := self.star_targets_list_seq(),)
            and
            (literal_1 := self.expect(']'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . List ( elts = a , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def single_target(self) -> Optional[Any]:
        # single_target: single_subscript_attribute_target | NAME | '(' single_target ')'
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (single_subscript_attribute_target := self.single_subscript_attribute_target())
        ):
            return single_subscript_attribute_target
        self._reset(mark)
        if (
            (a := self.name())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Name ( id = a . string , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('('))
            and
            (a := self.single_target())
            and
            (literal_1 := self.expect(')'))
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def single_subscript_attribute_target(self) -> Optional[Any]:
        # single_subscript_attribute_target: t_primary '.' NAME !t_lookahead | t_primary '[' slices ']' !t_lookahead
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.t_primary())
            and
            (literal := self.expect('.'))
            and
            (b := self.name())
            and
            self.negative_lookahead(self.t_lookahead, )
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Attribute ( value = a , attr = b . string , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.t_primary())
            and
            (literal := self.expect('['))
            and
            (b := self.slices())
            and
            (literal_1 := self.expect(']'))
            and
            self.negative_lookahead(self.t_lookahead, )
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Subscript ( value = a , slice = b , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize_left_rec
    def t_primary(self) -> Optional[Any]:
        # t_primary: t_primary '.' NAME &t_lookahead | t_primary '[' slices ']' &t_lookahead | t_primary genexp &t_lookahead | t_primary '(' arguments? ')' &t_lookahead | t_primary '(' partial_arguments ')' &t_lookahead | atom &t_lookahead
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.t_primary())
            and
            (literal := self.expect('.'))
            and
            (b := self.name())
            and
            self.positive_lookahead(self.t_lookahead, )
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Attribute ( value = a , attr = b . string , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.t_primary())
            and
            (literal := self.expect('['))
            and
            (b := self.slices())
            and
            (literal_1 := self.expect(']'))
            and
            self.positive_lookahead(self.t_lookahead, )
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Subscript ( value = a , slice = b , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.t_primary())
            and
            (b := self.genexp())
            and
            self.positive_lookahead(self.t_lookahead, )
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Call ( func = a , args = [b] , keywords = [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.t_primary())
            and
            (literal := self.expect('('))
            and
            (b := self.arguments(),)
            and
            (literal_1 := self.expect(')'))
            and
            self.positive_lookahead(self.t_lookahead, )
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Call ( func = a , args = b [0] if b else [] , keywords = b [1] if b else [] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._reset(mark)
        if (
            (a := self.t_primary())
            and
            (literal := self.expect('('))
            and
            (b := self.partial_arguments())
            and
            (literal_1 := self.expect(')'))
            and
            self.positive_lookahead(self.t_lookahead, )
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return self . make_partial_function ( a , b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.atom())
            and
            self.positive_lookahead(self.t_lookahead, )
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def t_lookahead(self) -> Optional[Any]:
        # t_lookahead: '(' | '[' | '.'
        mark = self._mark()
        if (
            (literal := self.expect('('))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('['))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('.'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def del_targets(self) -> Optional[Any]:
        # del_targets: ','.del_target+ ','?
        mark = self._mark()
        if (
            (a := self._gather_147())
            and
            (opt := self.expect(','),)
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def del_target(self) -> Optional[Any]:
        # del_target: t_primary '.' NAME !t_lookahead | t_primary '[' slices ']' !t_lookahead | del_t_atom
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.t_primary())
            and
            (literal := self.expect('.'))
            and
            (b := self.name())
            and
            self.negative_lookahead(self.t_lookahead, )
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Attribute ( value = a , attr = b . string , ctx = Del , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (a := self.t_primary())
            and
            (literal := self.expect('['))
            and
            (b := self.slices())
            and
            (literal_1 := self.expect(']'))
            and
            self.negative_lookahead(self.t_lookahead, )
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Subscript ( value = a , slice = b , ctx = Del , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (del_t_atom := self.del_t_atom())
        ):
            return del_t_atom
        self._reset(mark)
        return None

    @memoize
    def del_t_atom(self) -> Optional[Any]:
        # del_t_atom: NAME | '(' del_target ')' | '(' del_targets? ')' | '[' del_targets? ']'
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.name())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Name ( id = a . string , ctx = Del , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('('))
            and
            (a := self.del_target())
            and
            (literal_1 := self.expect(')'))
        ):
            return self . set_expr_context ( a , Del )
        self._reset(mark)
        if (
            (literal := self.expect('('))
            and
            (a := self.del_targets(),)
            and
            (literal_1 := self.expect(')'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . Tuple ( elts = a , ctx = Del , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (literal := self.expect('['))
            and
            (a := self.del_targets(),)
            and
            (literal_1 := self.expect(']'))
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . List ( elts = a , ctx = Del , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        return None

    @memoize
    def type_expressions(self) -> Optional[list]:
        # type_expressions: ','.expression+ ',' '*' expression ',' '**' expression | ','.expression+ ',' '*' expression | ','.expression+ ',' '**' expression | '*' expression ',' '**' expression | '*' expression | '**' expression | ','.expression+
        mark = self._mark()
        if (
            (a := self._gather_149())
            and
            (literal := self.expect(','))
            and
            (literal_1 := self.expect('*'))
            and
            (b := self.expression())
            and
            (literal_2 := self.expect(','))
            and
            (literal_3 := self.expect('**'))
            and
            (c := self.expression())
        ):
            return a + [b , c]
        self._reset(mark)
        if (
            (a := self._gather_151())
            and
            (literal := self.expect(','))
            and
            (literal_1 := self.expect('*'))
            and
            (b := self.expression())
        ):
            return a + [b]
        self._reset(mark)
        if (
            (a := self._gather_153())
            and
            (literal := self.expect(','))
            and
            (literal_1 := self.expect('**'))
            and
            (b := self.expression())
        ):
            return a + [b]
        self._reset(mark)
        if (
            (literal := self.expect('*'))
            and
            (a := self.expression())
            and
            (literal_1 := self.expect(','))
            and
            (literal_2 := self.expect('**'))
            and
            (b := self.expression())
        ):
            return [a , b]
        self._reset(mark)
        if (
            (literal := self.expect('*'))
            and
            (a := self.expression())
        ):
            return [a]
        self._reset(mark)
        if (
            (literal := self.expect('**'))
            and
            (a := self.expression())
        ):
            return [a]
        self._reset(mark)
        if (
            (a := self._gather_155())
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def func_type_comment(self) -> Optional[Any]:
        # func_type_comment: NEWLINE TYPE_COMMENT &(NEWLINE INDENT) | invalid_double_type_comments | TYPE_COMMENT
        mark = self._mark()
        if (
            (_newline := self.expect('NEWLINE'))
            and
            (t := self.type_comment())
            and
            self.positive_lookahead(self._tmp_157, )
        ):
            return t . string
        self._reset(mark)
        if (
            (invalid_double_type_comments := self.invalid_double_type_comments())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (type_comment := self.type_comment())
        ):
            return type_comment
        self._reset(mark)
        return None

    @memoize
    def invalid_arguments(self) -> Optional[NoReturn]:
        # invalid_arguments: args ',' '*' | expression for_if_clauses ',' [args | expression for_if_clauses] | NAME '=' expression for_if_clauses | args for_if_clauses | args ',' expression for_if_clauses | args ',' args
        mark = self._mark()
        if (
            (a := self.args())
            and
            (literal := self.expect(','))
            and
            (literal_1 := self.expect('*'))
        ):
            return self . store_syntax_error_known_location ( "iterable argument unpacking follows keyword argument unpacking" , a [1] [- 1] if a [1] else a [0] [- 1] , )
        self._reset(mark)
        if (
            (a := self.expression())
            and
            (b := self.for_if_clauses())
            and
            (literal := self.expect(','))
            and
            (opt := self._tmp_158(),)
        ):
            return self . store_syntax_error_known_range ( "Generator expression must be parenthesized" , a , b [- 1] . target )
        self._reset(mark)
        if (
            (a := self.name())
            and
            (b := self.expect('='))
            and
            (expression := self.expression())
            and
            (for_if_clauses := self.for_if_clauses())
        ):
            return self . store_syntax_error_known_range ( "invalid syntax. Maybe you meant '==' or ':=' instead of '='?" , a , b )
        self._reset(mark)
        if (
            (a := self.args())
            and
            (for_if_clauses := self.for_if_clauses())
        ):
            return self . store_syntax_error_starting_from ( "Generator expression must be parenthesized" , a [1] [- 1] if a [1] else a [0] [- 1] )
        self._reset(mark)
        if (
            (args := self.args())
            and
            (literal := self.expect(','))
            and
            (a := self.expression())
            and
            (b := self.for_if_clauses())
        ):
            return self . store_syntax_error_known_range ( "Generator expression must be parenthesized" , a , b [- 1] . target , )
        self._reset(mark)
        if (
            (a := self.args())
            and
            (literal := self.expect(','))
            and
            (args := self.args())
        ):
            return self . store_syntax_error ( "positional argument follows keyword argument unpacking" if a [1] [- 1] . arg is None else "positional argument follows keyword argument" , )
        self._reset(mark)
        return None

    @memoize
    def invalid_kwarg(self) -> Optional[NoReturn]:
        # invalid_kwarg: NAME '=' expression for_if_clauses | !(NAME '=') expression '='
        mark = self._mark()
        if (
            (a := self.name())
            and
            (b := self.expect('='))
            and
            (expression := self.expression())
            and
            (for_if_clauses := self.for_if_clauses())
        ):
            return self . store_syntax_error_known_range ( "invalid syntax. Maybe you meant '==' or ':=' instead of '='?" , a , b )
        self._reset(mark)
        if (
            self.negative_lookahead(self._tmp_159, )
            and
            (a := self.expression())
            and
            (b := self.expect('='))
        ):
            return self . store_syntax_error_known_range ( "expression cannot contain assignment, perhaps you meant \"==\"?" , a , b , )
        self._reset(mark)
        return None

    @memoize
    def expression_without_invalid(self) -> Optional[ast . AST]:
        # expression_without_invalid: disjunction 'if' disjunction 'else' expression | disjunction '?' disjunction ':' expression | disjunction | lambdef
        mark = self._mark()
        tok = self._tokenizer.peek()
        start_lineno, start_col_offset = tok.start
        if (
            (a := self.disjunction())
            and
            (literal := self.expect('if'))
            and
            (b := self.disjunction())
            and
            (literal_1 := self.expect('else'))
            and
            (c := self.expression())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . IfExp ( body = b , test = a , orelse = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (b := self.disjunction())
            and
            (literal := self.expect('?'))
            and
            (a := self.disjunction())
            and
            (literal_1 := self.expect(':'))
            and
            (c := self.expression())
        ):
            tok = self._tokenizer.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end
            return ast . IfExp ( body = a , test = b , orelse = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._reset(mark)
        if (
            (disjunction := self.disjunction())
        ):
            return disjunction
        self._reset(mark)
        if (
            (lambdef := self.lambdef())
        ):
            return lambdef
        self._reset(mark)
        return None

    @memoize
    def invalid_legacy_expression(self) -> Optional[Any]:
        # invalid_legacy_expression: NAME !'(' expression_without_invalid
        mark = self._mark()
        if (
            (a := self.name())
            and
            self.negative_lookahead(self.expect, '(')
            and
            (b := self.expression_without_invalid())
        ):
            return self . raise_syntax_error_known_range ( f"Missing parentheses in call to '{a.string}' . Did you mean {a.string}(...)?" , a , b , ) if a . string in ( "exec" , "print" ) else None
        self._reset(mark)
        return None

    @memoize
    def invalid_expression(self) -> Optional[NoReturn]:
        # invalid_expression: invalid_legacy_expression | !(NAME STRING | SOFT_KEYWORD) disjunction expression_without_invalid | disjunction 'if' disjunction !('else' | ':') | disjunction '?' !'?' disjunction !':'
        mark = self._mark()
        if (
            (invalid_legacy_expression := self.invalid_legacy_expression())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            self.negative_lookahead(self._tmp_160, )
            and
            (a := self.disjunction())
            and
            (b := self.expression_without_invalid())
        ):
            return self . store_syntax_error_known_range ( "invalid syntax. Perhaps you forgot a comma?" , a , b )
        self._reset(mark)
        if (
            (a := self.disjunction())
            and
            (literal := self.expect('if'))
            and
            (b := self.disjunction())
            and
            self.negative_lookahead(self._tmp_161, )
        ):
            return self . store_syntax_error_known_range ( "expected 'else' after 'if' expression" , a , b )
        self._reset(mark)
        if (
            (b := self.disjunction())
            and
            (literal := self.expect('?'))
            and
            self.negative_lookahead(self.expect, '?')
            and
            (a := self.disjunction())
            and
            self.negative_lookahead(self.expect, ':')
        ):
            return self . store_syntax_error_known_range ( "expected ':' after '?' expression" , b , a )
        self._reset(mark)
        return None

    @memoize
    def invalid_named_expression(self) -> Optional[NoReturn]:
        # invalid_named_expression: expression ':=' expression | NAME '=' bitwise_or !('=' | ':=') | !(list | tuple | genexp | 'True' | 'None' | 'False') bitwise_or '=' bitwise_or !('=' | ':=')
        mark = self._mark()
        if (
            (a := self.expression())
            and
            (literal := self.expect(':='))
            and
            (expression := self.expression())
        ):
            return self . store_syntax_error_known_location ( f"cannot use assignment expressions with {self.get_expr_name(a)}" , a )
        self._reset(mark)
        if (
            (a := self.name())
            and
            (literal := self.expect('='))
            and
            (b := self.bitwise_or())
            and
            self.negative_lookahead(self._tmp_162, )
        ):
            return ( None if self . in_recursive_rule else self . store_syntax_error_known_range ( "invalid syntax. Maybe you meant '==' or ':=' instead of '='?" , a , b ) )
        self._reset(mark)
        if (
            self.negative_lookahead(self._tmp_163, )
            and
            (a := self.bitwise_or())
            and
            (b := self.expect('='))
            and
            (bitwise_or := self.bitwise_or())
            and
            self.negative_lookahead(self._tmp_164, )
        ):
            return ( None if self . in_recursive_rule else self . store_syntax_error_known_range ( f"cannot assign to {self.get_expr_name(a)} here. Maybe you meant '==' instead of '='?" , a , b ) )
        self._reset(mark)
        return None

    @memoize
    def invalid_assignment(self) -> Optional[NoReturn]:
        # invalid_assignment: invalid_ann_assign_target ':' expression | star_named_expression ',' star_named_expressions* ':' expression | expression ':' expression | ((star_targets '='))* star_expressions '=' | ((star_targets '='))* yield_expr '=' | star_expressions augassign (yield_expr | star_expressions)
        mark = self._mark()
        if (
            (a := self.invalid_ann_assign_target())
            and
            (literal := self.expect(':'))
            and
            (expression := self.expression())
        ):
            return self . store_syntax_error_known_location ( f"only single target (not {self.get_expr_name(a)}) can be annotated" , a )
        self._reset(mark)
        if (
            (a := self.star_named_expression())
            and
            (literal := self.expect(','))
            and
            (_loop0_165 := self._loop0_165(),)
            and
            (literal_1 := self.expect(':'))
            and
            (expression := self.expression())
        ):
            return self . store_syntax_error_known_location ( "only single target (not tuple) can be annotated" , a )
        self._reset(mark)
        if (
            (a := self.expression())
            and
            (literal := self.expect(':'))
            and
            (expression := self.expression())
        ):
            return self . store_syntax_error_known_location ( "illegal target for annotation" , a )
        self._reset(mark)
        if (
            (_loop0_166 := self._loop0_166(),)
            and
            (a := self.star_expressions())
            and
            (literal := self.expect('='))
        ):
            return self . store_syntax_error_known_location ( f"cannot assign to {self.get_expr_name(a)}" , a )
        self._reset(mark)
        if (
            (_loop0_167 := self._loop0_167(),)
            and
            (a := self.yield_expr())
            and
            (literal := self.expect('='))
        ):
            return self . store_syntax_error_known_location ( "assignment to yield expression not possible" , a )
        self._reset(mark)
        if (
            (a := self.star_expressions())
            and
            (augassign := self.augassign())
            and
            (_tmp_168 := self._tmp_168())
        ):
            return self . store_syntax_error_known_location ( f"{self.get_expr_name(a)} is an illegal expression for augmented assignment" , a )
        self._reset(mark)
        return None

    @memoize
    def invalid_ann_assign_target(self) -> Optional[ast . AST]:
        # invalid_ann_assign_target: list | tuple | '(' invalid_ann_assign_target ')'
        mark = self._mark()
        if (
            (a := self.list())
        ):
            return a
        self._reset(mark)
        if (
            (a := self.tuple())
        ):
            return a
        self._reset(mark)
        if (
            (literal := self.expect('('))
            and
            (a := self.invalid_ann_assign_target())
            and
            (literal_1 := self.expect(')'))
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def invalid_del_stmt(self) -> Optional[NoReturn]:
        # invalid_del_stmt: 'del' star_expressions
        mark = self._mark()
        if (
            (literal := self.expect('del'))
            and
            (a := self.star_expressions())
        ):
            return self . raise_syntax_error_known_location ( f"cannot delete {self.get_expr_name(a)}" , a )
        self._reset(mark)
        return None

    @memoize
    def invalid_block(self) -> Optional[NoReturn]:
        # invalid_block: NEWLINE !INDENT
        mark = self._mark()
        if (
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . raise_indentation_error ( "expected an indented block" )
        self._reset(mark)
        return None

    @memoize
    def invalid_comprehension(self) -> Optional[NoReturn]:
        # invalid_comprehension: ('[' | '(' | '{') starred_expression for_if_clauses | ('[' | '{') star_named_expression ',' star_named_expressions for_if_clauses | ('[' | '{') star_named_expression ',' for_if_clauses
        mark = self._mark()
        if (
            (_tmp_169 := self._tmp_169())
            and
            (a := self.starred_expression())
            and
            (for_if_clauses := self.for_if_clauses())
        ):
            return self . raise_syntax_error_known_location ( "iterable unpacking cannot be used in comprehension" , a )
        self._reset(mark)
        if (
            (_tmp_170 := self._tmp_170())
            and
            (a := self.star_named_expression())
            and
            (literal := self.expect(','))
            and
            (b := self.star_named_expressions())
            and
            (for_if_clauses := self.for_if_clauses())
        ):
            return self . raise_syntax_error_known_range ( "did you forget parentheses around the comprehension target?" , a , b [- 1] )
        self._reset(mark)
        if (
            (_tmp_171 := self._tmp_171())
            and
            (a := self.star_named_expression())
            and
            (b := self.expect(','))
            and
            (for_if_clauses := self.for_if_clauses())
        ):
            return self . raise_syntax_error_known_range ( "did you forget parentheses around the comprehension target?" , a , b )
        self._reset(mark)
        return None

    @memoize
    def invalid_dict_comprehension(self) -> Optional[NoReturn]:
        # invalid_dict_comprehension: '{' '**' bitwise_or for_if_clauses '}'
        mark = self._mark()
        if (
            (literal := self.expect('{'))
            and
            (a := self.expect('**'))
            and
            (bitwise_or := self.bitwise_or())
            and
            (for_if_clauses := self.for_if_clauses())
            and
            (literal_1 := self.expect('}'))
        ):
            return self . raise_syntax_error_known_location ( "dict unpacking cannot be used in dict comprehension" , a )
        self._reset(mark)
        return None

    @memoize
    def invalid_parameters(self) -> Optional[NoReturn]:
        # invalid_parameters: param_no_default* invalid_parameters_helper param_no_default
        mark = self._mark()
        if (
            (_loop0_172 := self._loop0_172(),)
            and
            (invalid_parameters_helper := self.invalid_parameters_helper())
            and
            (a := self.param_no_default())
        ):
            return self . raise_syntax_error_known_location ( "non-default argument follows default argument" , a )
        self._reset(mark)
        return None

    @memoize
    def invalid_parameters_helper(self) -> Optional[Any]:
        # invalid_parameters_helper: slash_with_default | param_with_default+
        mark = self._mark()
        if (
            (a := self.slash_with_default())
        ):
            return [a]
        self._reset(mark)
        if (
            (a := self._loop1_173())
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def invalid_lambda_parameters(self) -> Optional[NoReturn]:
        # invalid_lambda_parameters: lambda_param_no_default* invalid_lambda_parameters_helper lambda_param_no_default
        mark = self._mark()
        if (
            (_loop0_174 := self._loop0_174(),)
            and
            (invalid_lambda_parameters_helper := self.invalid_lambda_parameters_helper())
            and
            (a := self.lambda_param_no_default())
        ):
            return self . raise_syntax_error_known_location ( "non-default argument follows default argument" , a )
        self._reset(mark)
        return None

    @memoize
    def invalid_lambda_parameters_helper(self) -> Optional[NoReturn]:
        # invalid_lambda_parameters_helper: lambda_slash_with_default | lambda_param_with_default+
        mark = self._mark()
        if (
            (a := self.lambda_slash_with_default())
        ):
            return [a]
        self._reset(mark)
        if (
            (a := self._loop1_175())
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def invalid_star_etc(self) -> Optional[NoReturn]:
        # invalid_star_etc: '*' (')' | ',' (')' | '**')) | '*' ',' TYPE_COMMENT
        mark = self._mark()
        if (
            (a := self.expect('*'))
            and
            (_tmp_176 := self._tmp_176())
        ):
            return self . store_syntax_error_known_location ( "named arguments must follow bare *" , a )
        self._reset(mark)
        if (
            (literal := self.expect('*'))
            and
            (literal_1 := self.expect(','))
            and
            (type_comment := self.type_comment())
        ):
            return self . store_syntax_error ( "bare * has associated type comment" )
        self._reset(mark)
        return None

    @memoize
    def invalid_lambda_star_etc(self) -> Optional[NoReturn]:
        # invalid_lambda_star_etc: '*' (':' | ',' (':' | '**'))
        mark = self._mark()
        if (
            (literal := self.expect('*'))
            and
            (_tmp_177 := self._tmp_177())
        ):
            return self . raise_syntax_error ( "named arguments must follow bare *" )
        self._reset(mark)
        return None

    @memoize
    def invalid_double_type_comments(self) -> Optional[NoReturn]:
        # invalid_double_type_comments: TYPE_COMMENT NEWLINE TYPE_COMMENT NEWLINE INDENT
        mark = self._mark()
        if (
            (type_comment := self.type_comment())
            and
            (_newline := self.expect('NEWLINE'))
            and
            (type_comment_1 := self.type_comment())
            and
            (_newline_1 := self.expect('NEWLINE'))
            and
            (_indent := self.expect('INDENT'))
        ):
            return self . raise_syntax_error ( "Cannot have two type comments on def" )
        self._reset(mark)
        return None

    @memoize
    def invalid_with_item(self) -> Optional[NoReturn]:
        # invalid_with_item: expression 'as' expression &(',' | ')' | ':')
        mark = self._mark()
        if (
            (expression := self.expression())
            and
            (literal := self.expect('as'))
            and
            (a := self.expression())
            and
            self.positive_lookahead(self._tmp_178, )
        ):
            return self . raise_syntax_error_known_location ( f"cannot assign to {self.get_expr_name(a)}" , a )
        self._reset(mark)
        return None

    @memoize
    def invalid_for_target(self) -> Optional[NoReturn]:
        # invalid_for_target: 'async'? 'for' star_expressions
        mark = self._mark()
        if (
            (opt := self.expect('async'),)
            and
            (literal := self.expect('for'))
            and
            (a := self.star_expressions())
        ):
            return self . raise_syntax_error_known_location ( f"cannot assign to {self.get_expr_name(a)}" , a )
        self._reset(mark)
        return None

    @memoize
    def invalid_group(self) -> Optional[NoReturn]:
        # invalid_group: '(' starred_expression ')' | '(' '**' expression ')'
        mark = self._mark()
        if (
            (literal := self.expect('('))
            and
            (a := self.starred_expression())
            and
            (literal_1 := self.expect(')'))
        ):
            return self . raise_syntax_error_known_location ( "cannot use starred expression here" , a )
        self._reset(mark)
        if (
            (literal := self.expect('('))
            and
            (a := self.expect('**'))
            and
            (expression := self.expression())
            and
            (literal_1 := self.expect(')'))
        ):
            return self . raise_syntax_error_known_location ( "cannot use double starred expression here" , a )
        self._reset(mark)
        return None

    @memoize
    def invalid_import_from_targets(self) -> Optional[NoReturn]:
        # invalid_import_from_targets: import_from_as_names ',' NEWLINE
        mark = self._mark()
        if (
            (import_from_as_names := self.import_from_as_names())
            and
            (literal := self.expect(','))
            and
            (_newline := self.expect('NEWLINE'))
        ):
            return self . raise_syntax_error ( "trailing comma not allowed without surrounding parentheses" )
        self._reset(mark)
        return None

    @memoize
    def invalid_with_stmt(self) -> Optional[None]:
        # invalid_with_stmt: 'async'? 'with' ','.(expression ['as' star_target])+ &&':' | 'async'? 'with' '(' ','.(expressions ['as' star_target])+ ','? ')' &&':'
        mark = self._mark()
        if (
            (opt := self.expect('async'),)
            and
            (literal := self.expect('with'))
            and
            (_gather_179 := self._gather_179())
            and
            (forced := self.expect_forced(self.expect(':'), "':'"))
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (opt := self.expect('async'),)
            and
            (literal := self.expect('with'))
            and
            (literal_1 := self.expect('('))
            and
            (_gather_181 := self._gather_181())
            and
            (opt_1 := self.expect(','),)
            and
            (literal_2 := self.expect(')'))
            and
            (forced := self.expect_forced(self.expect(':'), "':'"))
        ):
            return None  # pragma: no cover
        self._reset(mark)
        return None

    @memoize
    def invalid_with_stmt_indent(self) -> Optional[NoReturn]:
        # invalid_with_stmt_indent: 'async'? 'with' ','.(expression ['as' star_target])+ ':' NEWLINE !INDENT | 'async'? 'with' '(' ','.(expressions ['as' star_target])+ ','? ')' ':' NEWLINE !INDENT
        mark = self._mark()
        if (
            (opt := self.expect('async'),)
            and
            (a := self.expect('with'))
            and
            (_gather_183 := self._gather_183())
            and
            (literal := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . raise_indentation_error ( f"expected an indented block after 'with' statement on line {a.start[0]}" )
        self._reset(mark)
        if (
            (opt := self.expect('async'),)
            and
            (a := self.expect('with'))
            and
            (literal := self.expect('('))
            and
            (_gather_185 := self._gather_185())
            and
            (opt_1 := self.expect(','),)
            and
            (literal_1 := self.expect(')'))
            and
            (literal_2 := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . raise_indentation_error ( f"expected an indented block after 'with' statement on line {a.start[0]}" )
        self._reset(mark)
        return None

    @memoize
    def invalid_try_stmt(self) -> Optional[NoReturn]:
        # invalid_try_stmt: 'try' ':' NEWLINE !INDENT | 'try' ':' block !('except' | 'finally')
        mark = self._mark()
        if (
            (a := self.expect('try'))
            and
            (literal := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . raise_indentation_error ( f"expected an indented block after 'try' statement on line {a.start[0]}" , )
        self._reset(mark)
        if (
            (literal := self.expect('try'))
            and
            (literal_1 := self.expect(':'))
            and
            (block := self.block())
            and
            self.negative_lookahead(self._tmp_187, )
        ):
            return self . raise_syntax_error ( "expected 'except' or 'finally' block" )
        self._reset(mark)
        return None

    @memoize
    def invalid_except_stmt(self) -> Optional[None]:
        # invalid_except_stmt: 'except' expression ',' expressions ['as' NAME] ':' | 'except' expression ['as' NAME] NEWLINE | 'except' NEWLINE
        mark = self._mark()
        if (
            (literal := self.expect('except'))
            and
            (a := self.expression())
            and
            (literal_1 := self.expect(','))
            and
            (expressions := self.expressions())
            and
            (opt := self._tmp_188(),)
            and
            (literal_2 := self.expect(':'))
        ):
            return self . raise_syntax_error_starting_from ( "exception group must be parenthesized" , a )
        self._reset(mark)
        if (
            (a := self.expect('except'))
            and
            (expression := self.expression())
            and
            (opt := self._tmp_189(),)
            and
            (_newline := self.expect('NEWLINE'))
        ):
            return self . store_syntax_error ( "expected ':'" )
        self._reset(mark)
        if (
            (a := self.expect('except'))
            and
            (_newline := self.expect('NEWLINE'))
        ):
            return self . store_syntax_error ( "expected ':'" )
        self._reset(mark)
        return None

    @memoize
    def invalid_finally_stmt(self) -> Optional[NoReturn]:
        # invalid_finally_stmt: 'finally' ':' NEWLINE !INDENT
        mark = self._mark()
        if (
            (a := self.expect('finally'))
            and
            (literal := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . raise_indentation_error ( f"expected an indented block after 'finally' statement on line {a.start[0]}" )
        self._reset(mark)
        return None

    @memoize
    def invalid_except_stmt_indent(self) -> Optional[NoReturn]:
        # invalid_except_stmt_indent: 'except' expression ['as' NAME] ':' NEWLINE !INDENT | 'except' ':' NEWLINE !INDENT
        mark = self._mark()
        if (
            (a := self.expect('except'))
            and
            (expression := self.expression())
            and
            (opt := self._tmp_190(),)
            and
            (literal := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . raise_indentation_error ( f"expected an indented block after 'except' statement on line {a.start[0]}" )
        self._reset(mark)
        if (
            (a := self.expect('except'))
            and
            (literal := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . raise_indentation_error ( f"expected an indented block after 'except' statement on line {a.start[0]}" )
        self._reset(mark)
        return None

    @memoize
    def invalid_match_stmt(self) -> Optional[NoReturn]:
        # invalid_match_stmt: "match" subject_expr !':' | "match" subject_expr ':' NEWLINE !INDENT
        mark = self._mark()
        if (
            (literal := self.expect("match"))
            and
            (subject_expr := self.subject_expr())
            and
            self.negative_lookahead(self.expect, ':')
        ):
            return self . check_version ( ( 3 , 10 ) , "Pattern matching is" , self . raise_syntax_error ( "expected ':'" ) )
        self._reset(mark)
        if (
            (a := self.expect("match"))
            and
            (subject := self.subject_expr())
            and
            (literal := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . check_version ( ( 3 , 10 ) , "Pattern matching is" , self . raise_indentation_error ( f"expected an indented block after 'match' statement on line {a.start[0]}" ) )
        self._reset(mark)
        return None

    @memoize
    def invalid_case_block(self) -> Optional[NoReturn]:
        # invalid_case_block: "case" patterns guard? !':' | "case" patterns guard? ':' NEWLINE !INDENT
        mark = self._mark()
        if (
            (literal := self.expect("case"))
            and
            (patterns := self.patterns())
            and
            (opt := self.guard(),)
            and
            self.negative_lookahead(self.expect, ':')
        ):
            return self . store_syntax_error ( "expected ':'" )
        self._reset(mark)
        if (
            (a := self.expect("case"))
            and
            (patterns := self.patterns())
            and
            (opt := self.guard(),)
            and
            (literal := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . raise_indentation_error ( f"expected an indented block after 'case' statement on line {a.start[0]}" )
        self._reset(mark)
        return None

    @memoize
    def invalid_as_pattern(self) -> Optional[NoReturn]:
        # invalid_as_pattern: or_pattern 'as' "_" | or_pattern 'as' !NAME expression
        mark = self._mark()
        if (
            (or_pattern := self.or_pattern())
            and
            (literal := self.expect('as'))
            and
            (a := self.expect("_"))
        ):
            return self . raise_syntax_error_known_location ( "cannot use '_' as a target" , a )
        self._reset(mark)
        if (
            (or_pattern := self.or_pattern())
            and
            (literal := self.expect('as'))
            and
            self.negative_lookahead(self.name, )
            and
            (a := self.expression())
        ):
            return self . raise_syntax_error_known_location ( "invalid pattern target" , a )
        self._reset(mark)
        return None

    @memoize
    def invalid_class_pattern(self) -> Optional[NoReturn]:
        # invalid_class_pattern: name_or_attr '(' invalid_class_argument_pattern
        mark = self._mark()
        if (
            (name_or_attr := self.name_or_attr())
            and
            (literal := self.expect('('))
            and
            (a := self.invalid_class_argument_pattern())
        ):
            return self . raise_syntax_error_known_range ( "positional patterns follow keyword patterns" , a [0] , a [- 1] )
        self._reset(mark)
        return None

    @memoize
    def invalid_class_argument_pattern(self) -> Optional[list]:
        # invalid_class_argument_pattern: [positional_patterns ','] keyword_patterns ',' positional_patterns
        mark = self._mark()
        if (
            (opt := self._tmp_191(),)
            and
            (keyword_patterns := self.keyword_patterns())
            and
            (literal := self.expect(','))
            and
            (a := self.positional_patterns())
        ):
            return a
        self._reset(mark)
        return None

    @memoize
    def invalid_if_stmt(self) -> Optional[NoReturn]:
        # invalid_if_stmt: 'if' named_expression NEWLINE | 'if' named_expression ':' NEWLINE !INDENT
        mark = self._mark()
        if (
            (literal := self.expect('if'))
            and
            (named_expression := self.named_expression())
            and
            (_newline := self.expect('NEWLINE'))
        ):
            return self . raise_syntax_error ( "expected ':'" )
        self._reset(mark)
        if (
            (a := self.expect('if'))
            and
            (a_1 := self.named_expression())
            and
            (literal := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . raise_indentation_error ( f"expected an indented block after 'if' statement on line {a.start[0]}" )
        self._reset(mark)
        return None

    @memoize
    def invalid_elif_stmt(self) -> Optional[NoReturn]:
        # invalid_elif_stmt: 'elif' named_expression NEWLINE | 'elif' named_expression ':' NEWLINE !INDENT
        mark = self._mark()
        if (
            (literal := self.expect('elif'))
            and
            (named_expression := self.named_expression())
            and
            (_newline := self.expect('NEWLINE'))
        ):
            return self . raise_syntax_error ( "expected ':'" )
        self._reset(mark)
        if (
            (a := self.expect('elif'))
            and
            (named_expression := self.named_expression())
            and
            (literal := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . raise_indentation_error ( f"expected an indented block after 'elif' statement on line {a.start[0]}" )
        self._reset(mark)
        return None

    @memoize
    def invalid_else_stmt(self) -> Optional[NoReturn]:
        # invalid_else_stmt: 'else' ':' NEWLINE !INDENT
        mark = self._mark()
        if (
            (a := self.expect('else'))
            and
            (literal := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . raise_indentation_error ( f"expected an indented block after 'else' statement on line {a.start[0]}" )
        self._reset(mark)
        return None

    @memoize
    def invalid_while_stmt(self) -> Optional[NoReturn]:
        # invalid_while_stmt: 'while' named_expression NEWLINE | 'while' named_expression ':' NEWLINE !INDENT
        mark = self._mark()
        if (
            (literal := self.expect('while'))
            and
            (named_expression := self.named_expression())
            and
            (_newline := self.expect('NEWLINE'))
        ):
            return self . store_syntax_error ( "expected ':'" )
        self._reset(mark)
        if (
            (a := self.expect('while'))
            and
            (named_expression := self.named_expression())
            and
            (literal := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . raise_indentation_error ( f"expected an indented block after 'while' statement on line {a.start[0]}" )
        self._reset(mark)
        return None

    @memoize
    def invalid_for_stmt(self) -> Optional[NoReturn]:
        # invalid_for_stmt: 'async'? 'for' star_targets 'in' star_expressions ':' NEWLINE !INDENT
        mark = self._mark()
        if (
            (opt := self.expect('async'),)
            and
            (a := self.expect('for'))
            and
            (star_targets := self.star_targets())
            and
            (literal := self.expect('in'))
            and
            (star_expressions := self.star_expressions())
            and
            (literal_1 := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . raise_indentation_error ( f"expected an indented block after 'for' statement on line {a.start[0]}" )
        self._reset(mark)
        return None

    @memoize
    def invalid_def_raw(self) -> Optional[NoReturn]:
        # invalid_def_raw: 'async'? 'def' NAME '(' params? ')' ['->' expression] ':' NEWLINE !INDENT
        mark = self._mark()
        if (
            (opt := self.expect('async'),)
            and
            (a := self.expect('def'))
            and
            (name := self.name())
            and
            (literal := self.expect('('))
            and
            (opt_1 := self.params(),)
            and
            (literal_1 := self.expect(')'))
            and
            (opt_2 := self._tmp_192(),)
            and
            (literal_2 := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . raise_indentation_error ( f"expected an indented block after function definition on line {a.start[0]}" )
        self._reset(mark)
        return None

    @memoize
    def invalid_class_def_raw(self) -> Optional[NoReturn]:
        # invalid_class_def_raw: 'class' NAME ['(' arguments? ')'] ':' NEWLINE !INDENT
        mark = self._mark()
        if (
            (a := self.expect('class'))
            and
            (name := self.name())
            and
            (opt := self._tmp_193(),)
            and
            (literal := self.expect(':'))
            and
            (_newline := self.expect('NEWLINE'))
            and
            self.negative_lookahead(self.expect, 'INDENT')
        ):
            return self . raise_indentation_error ( f"expected an indented block after class definition on line {a.start[0]}" )
        self._reset(mark)
        return None

    @memoize
    def invalid_double_starred_kvpairs(self) -> Optional[None]:
        # invalid_double_starred_kvpairs: ','.double_starred_kvpair+ ',' invalid_kvpair | expression ':' '*' bitwise_or | expression ':' &('}' | ',')
        mark = self._mark()
        if (
            (_gather_194 := self._gather_194())
            and
            (literal := self.expect(','))
            and
            (invalid_kvpair := self.invalid_kvpair())
        ):
            return None  # pragma: no cover
        self._reset(mark)
        if (
            (expression := self.expression())
            and
            (literal := self.expect(':'))
            and
            (a := self.expect('*'))
            and
            (bitwise_or := self.bitwise_or())
        ):
            return self . store_syntax_error_starting_from ( "cannot use a starred expression in a dictionary value" , a )
        self._reset(mark)
        if (
            (expression := self.expression())
            and
            (a := self.expect(':'))
            and
            self.positive_lookahead(self._tmp_196, )
        ):
            return self . store_syntax_error_known_location ( "expression expected after dictionary key and ':'" , a )
        self._reset(mark)
        return None

    @memoize
    def invalid_kvpair(self) -> Optional[None]:
        # invalid_kvpair: expression !(':') | expression ':' '*' bitwise_or | expression ':'
        mark = self._mark()
        if (
            (a := self.expression())
            and
            self.negative_lookahead(self.expect, ':')
        ):
            return self . _store_syntax_error ( "':' expected after dictionary key" , ( a . lineno , a . col_offset - 1 ) , ( a . end_lineno , a . end_col_offset , - 1 ) )
        self._reset(mark)
        if (
            (expression := self.expression())
            and
            (literal := self.expect(':'))
            and
            (a := self.expect('*'))
            and
            (bitwise_or := self.bitwise_or())
        ):
            return self . store_syntax_error_starting_from ( "cannot use a starred expression in a dictionary value" , a )
        self._reset(mark)
        if (
            (expression := self.expression())
            and
            (a := self.expect(':'))
        ):
            return self . store_syntax_error_known_location ( "expression expected after dictionary key and ':'" , a )
        self._reset(mark)
        return None

    @memoize
    def _loop0_1(self) -> Optional[Any]:
        # _loop0_1: NEWLINE
        mark = self._mark()
        children = []
        while (
            (_newline := self.expect('NEWLINE'))
        ):
            children.append(_newline)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_2(self) -> Optional[Any]:
        # _loop0_2: NEWLINE
        mark = self._mark()
        children = []
        while (
            (_newline := self.expect('NEWLINE'))
        ):
            children.append(_newline)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_3(self) -> Optional[Any]:
        # _loop1_3: statement
        mark = self._mark()
        children = []
        while (
            (statement := self.statement())
        ):
            children.append(statement)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_5(self) -> Optional[Any]:
        # _loop0_5: ';' simple_stmt
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(';'))
            and
            (elem := self.simple_stmt())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_4(self) -> Optional[Any]:
        # _gather_4: simple_stmt _loop0_5
        mark = self._mark()
        if (
            (elem := self.simple_stmt())
            is not None
            and
            (seq := self._loop0_5())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _tmp_6(self) -> Optional[Any]:
        # _tmp_6: 'import' | 'from'
        mark = self._mark()
        if (
            (literal := self.expect('import'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('from'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_7(self) -> Optional[Any]:
        # _tmp_7: 'def' | '@' | 'async'
        mark = self._mark()
        if (
            (literal := self.expect('def'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('@'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('async'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_8(self) -> Optional[Any]:
        # _tmp_8: 'class' | '@'
        mark = self._mark()
        if (
            (literal := self.expect('class'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('@'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_9(self) -> Optional[Any]:
        # _tmp_9: 'with' | 'async'
        mark = self._mark()
        if (
            (literal := self.expect('with'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('async'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_10(self) -> Optional[Any]:
        # _tmp_10: 'for' | 'async'
        mark = self._mark()
        if (
            (literal := self.expect('for'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('async'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_11(self) -> Optional[Any]:
        # _tmp_11: '=' annotated_rhs
        mark = self._mark()
        if (
            (literal := self.expect('='))
            and
            (d := self.annotated_rhs())
        ):
            return d
        self._reset(mark)
        return None

    @memoize
    def _tmp_12(self) -> Optional[Any]:
        # _tmp_12: '(' single_target ')' | single_subscript_attribute_target
        mark = self._mark()
        if (
            (literal := self.expect('('))
            and
            (b := self.single_target())
            and
            (literal_1 := self.expect(')'))
        ):
            return b
        self._reset(mark)
        if (
            (single_subscript_attribute_target := self.single_subscript_attribute_target())
        ):
            return single_subscript_attribute_target
        self._reset(mark)
        return None

    @memoize
    def _tmp_13(self) -> Optional[Any]:
        # _tmp_13: '=' annotated_rhs
        mark = self._mark()
        if (
            (literal := self.expect('='))
            and
            (d := self.annotated_rhs())
        ):
            return d
        self._reset(mark)
        return None

    @memoize
    def _loop1_14(self) -> Optional[Any]:
        # _loop1_14: (star_targets '=')
        mark = self._mark()
        children = []
        while (
            (_tmp_197 := self._tmp_197())
        ):
            children.append(_tmp_197)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _tmp_15(self) -> Optional[Any]:
        # _tmp_15: yield_expr | star_expressions
        mark = self._mark()
        if (
            (yield_expr := self.yield_expr())
        ):
            return yield_expr
        self._reset(mark)
        if (
            (star_expressions := self.star_expressions())
        ):
            return star_expressions
        self._reset(mark)
        return None

    @memoize
    def _tmp_16(self) -> Optional[Any]:
        # _tmp_16: yield_expr | star_expressions
        mark = self._mark()
        if (
            (yield_expr := self.yield_expr())
        ):
            return yield_expr
        self._reset(mark)
        if (
            (star_expressions := self.star_expressions())
        ):
            return star_expressions
        self._reset(mark)
        return None

    @memoize
    def _tmp_17(self) -> Optional[Any]:
        # _tmp_17: 'from' expression
        mark = self._mark()
        if (
            (literal := self.expect('from'))
            and
            (z := self.expression())
        ):
            return z
        self._reset(mark)
        return None

    @memoize
    def _loop0_19(self) -> Optional[Any]:
        # _loop0_19: ',' NAME
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.name())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_18(self) -> Optional[Any]:
        # _gather_18: NAME _loop0_19
        mark = self._mark()
        if (
            (elem := self.name())
            is not None
            and
            (seq := self._loop0_19())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_21(self) -> Optional[Any]:
        # _loop0_21: ',' NAME
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.name())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_20(self) -> Optional[Any]:
        # _gather_20: NAME _loop0_21
        mark = self._mark()
        if (
            (elem := self.name())
            is not None
            and
            (seq := self._loop0_21())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _tmp_22(self) -> Optional[Any]:
        # _tmp_22: ';' | NEWLINE
        mark = self._mark()
        if (
            (literal := self.expect(';'))
        ):
            return literal
        self._reset(mark)
        if (
            (_newline := self.expect('NEWLINE'))
        ):
            return _newline
        self._reset(mark)
        return None

    @memoize
    def _tmp_23(self) -> Optional[Any]:
        # _tmp_23: ',' expression
        mark = self._mark()
        if (
            (literal := self.expect(','))
            and
            (z := self.expression())
        ):
            return z
        self._reset(mark)
        return None

    @memoize
    def _loop0_24(self) -> Optional[Any]:
        # _loop0_24: ('.' | '...')
        mark = self._mark()
        children = []
        while (
            (_tmp_198 := self._tmp_198())
        ):
            children.append(_tmp_198)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_25(self) -> Optional[Any]:
        # _loop1_25: ('.' | '...')
        mark = self._mark()
        children = []
        while (
            (_tmp_199 := self._tmp_199())
        ):
            children.append(_tmp_199)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_27(self) -> Optional[Any]:
        # _loop0_27: ',' import_from_as_name
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.import_from_as_name())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_26(self) -> Optional[Any]:
        # _gather_26: import_from_as_name _loop0_27
        mark = self._mark()
        if (
            (elem := self.import_from_as_name())
            is not None
            and
            (seq := self._loop0_27())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _tmp_28(self) -> Optional[Any]:
        # _tmp_28: 'as' NAME
        mark = self._mark()
        if (
            (literal := self.expect('as'))
            and
            (z := self.name())
        ):
            return z . string
        self._reset(mark)
        return None

    @memoize
    def _loop0_30(self) -> Optional[Any]:
        # _loop0_30: ',' dotted_as_name
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.dotted_as_name())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_29(self) -> Optional[Any]:
        # _gather_29: dotted_as_name _loop0_30
        mark = self._mark()
        if (
            (elem := self.dotted_as_name())
            is not None
            and
            (seq := self._loop0_30())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _tmp_31(self) -> Optional[Any]:
        # _tmp_31: 'as' NAME
        mark = self._mark()
        if (
            (literal := self.expect('as'))
            and
            (z := self.name())
        ):
            return z . string
        self._reset(mark)
        return None

    @memoize
    def _loop1_32(self) -> Optional[Any]:
        # _loop1_32: decorator
        mark = self._mark()
        children = []
        while (
            (decorator := self.decorator())
        ):
            children.append(decorator)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _tmp_33(self) -> Optional[Any]:
        # _tmp_33: '@' dec_maybe_call NEWLINE
        mark = self._mark()
        if (
            (literal := self.expect('@'))
            and
            (f := self.dec_maybe_call())
            and
            (_newline := self.expect('NEWLINE'))
        ):
            return f
        self._reset(mark)
        return None

    @memoize
    def _tmp_34(self) -> Optional[Any]:
        # _tmp_34: '@' named_expression NEWLINE
        mark = self._mark()
        if (
            (literal := self.expect('@'))
            and
            (f := self.named_expression())
            and
            (_newline := self.expect('NEWLINE'))
        ):
            return f
        self._reset(mark)
        return None

    @memoize
    def _tmp_35(self) -> Optional[Any]:
        # _tmp_35: '(' arguments? ')'
        mark = self._mark()
        if (
            (literal := self.expect('('))
            and
            (z := self.arguments(),)
            and
            (literal_1 := self.expect(')'))
        ):
            return z
        self._reset(mark)
        return None

    @memoize
    def _tmp_36(self) -> Optional[Any]:
        # _tmp_36: '->' expression
        mark = self._mark()
        if (
            (literal := self.expect('->'))
            and
            (z := self.expression())
        ):
            return z
        self._reset(mark)
        return None

    @memoize
    def _tmp_37(self) -> Optional[Any]:
        # _tmp_37: '->' expression
        mark = self._mark()
        if (
            (literal := self.expect('->'))
            and
            (z := self.expression())
        ):
            return z
        self._reset(mark)
        return None

    @memoize
    def _loop0_38(self) -> Optional[Any]:
        # _loop0_38: param_no_default
        mark = self._mark()
        children = []
        while (
            (param_no_default := self.param_no_default())
        ):
            children.append(param_no_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_39(self) -> Optional[Any]:
        # _loop0_39: param_with_default
        mark = self._mark()
        children = []
        while (
            (param_with_default := self.param_with_default())
        ):
            children.append(param_with_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_40(self) -> Optional[Any]:
        # _loop0_40: param_with_default
        mark = self._mark()
        children = []
        while (
            (param_with_default := self.param_with_default())
        ):
            children.append(param_with_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_41(self) -> Optional[Any]:
        # _loop1_41: param_no_default
        mark = self._mark()
        children = []
        while (
            (param_no_default := self.param_no_default())
        ):
            children.append(param_no_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_42(self) -> Optional[Any]:
        # _loop0_42: param_with_default
        mark = self._mark()
        children = []
        while (
            (param_with_default := self.param_with_default())
        ):
            children.append(param_with_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_43(self) -> Optional[Any]:
        # _loop1_43: param_with_default
        mark = self._mark()
        children = []
        while (
            (param_with_default := self.param_with_default())
        ):
            children.append(param_with_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_44(self) -> Optional[Any]:
        # _loop1_44: param_no_default
        mark = self._mark()
        children = []
        while (
            (param_no_default := self.param_no_default())
        ):
            children.append(param_no_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_45(self) -> Optional[Any]:
        # _loop1_45: param_no_default
        mark = self._mark()
        children = []
        while (
            (param_no_default := self.param_no_default())
        ):
            children.append(param_no_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_46(self) -> Optional[Any]:
        # _loop0_46: param_no_default
        mark = self._mark()
        children = []
        while (
            (param_no_default := self.param_no_default())
        ):
            children.append(param_no_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_47(self) -> Optional[Any]:
        # _loop1_47: param_with_default
        mark = self._mark()
        children = []
        while (
            (param_with_default := self.param_with_default())
        ):
            children.append(param_with_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_48(self) -> Optional[Any]:
        # _loop0_48: param_no_default
        mark = self._mark()
        children = []
        while (
            (param_no_default := self.param_no_default())
        ):
            children.append(param_no_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_49(self) -> Optional[Any]:
        # _loop1_49: param_with_default
        mark = self._mark()
        children = []
        while (
            (param_with_default := self.param_with_default())
        ):
            children.append(param_with_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_50(self) -> Optional[Any]:
        # _loop0_50: param_maybe_default
        mark = self._mark()
        children = []
        while (
            (param_maybe_default := self.param_maybe_default())
        ):
            children.append(param_maybe_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_51(self) -> Optional[Any]:
        # _loop1_51: param_maybe_default
        mark = self._mark()
        children = []
        while (
            (param_maybe_default := self.param_maybe_default())
        ):
            children.append(param_maybe_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_53(self) -> Optional[Any]:
        # _loop0_53: ',' with_item
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.with_item())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_52(self) -> Optional[Any]:
        # _gather_52: with_item _loop0_53
        mark = self._mark()
        if (
            (elem := self.with_item())
            is not None
            and
            (seq := self._loop0_53())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_55(self) -> Optional[Any]:
        # _loop0_55: ',' with_item
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.with_item())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_54(self) -> Optional[Any]:
        # _gather_54: with_item _loop0_55
        mark = self._mark()
        if (
            (elem := self.with_item())
            is not None
            and
            (seq := self._loop0_55())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_57(self) -> Optional[Any]:
        # _loop0_57: ',' with_item
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.with_item())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_56(self) -> Optional[Any]:
        # _gather_56: with_item _loop0_57
        mark = self._mark()
        if (
            (elem := self.with_item())
            is not None
            and
            (seq := self._loop0_57())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_59(self) -> Optional[Any]:
        # _loop0_59: ',' with_item
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.with_item())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_58(self) -> Optional[Any]:
        # _gather_58: with_item _loop0_59
        mark = self._mark()
        if (
            (elem := self.with_item())
            is not None
            and
            (seq := self._loop0_59())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _tmp_60(self) -> Optional[Any]:
        # _tmp_60: ',' | ')' | ':'
        mark = self._mark()
        if (
            (literal := self.expect(','))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect(')'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect(':'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _loop1_61(self) -> Optional[Any]:
        # _loop1_61: except_block
        mark = self._mark()
        children = []
        while (
            (except_block := self.except_block())
        ):
            children.append(except_block)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _tmp_62(self) -> Optional[Any]:
        # _tmp_62: 'as' NAME
        mark = self._mark()
        if (
            (literal := self.expect('as'))
            and
            (z := self.name())
        ):
            return z . string
        self._reset(mark)
        return None

    @memoize
    def _loop1_63(self) -> Optional[Any]:
        # _loop1_63: case_block
        mark = self._mark()
        children = []
        while (
            (case_block := self.case_block())
        ):
            children.append(case_block)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_65(self) -> Optional[Any]:
        # _loop0_65: '|' closed_pattern
        mark = self._mark()
        children = []
        while (
            (literal := self.expect('|'))
            and
            (elem := self.closed_pattern())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_64(self) -> Optional[Any]:
        # _gather_64: closed_pattern _loop0_65
        mark = self._mark()
        if (
            (elem := self.closed_pattern())
            is not None
            and
            (seq := self._loop0_65())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _tmp_66(self) -> Optional[Any]:
        # _tmp_66: '+' | '-'
        mark = self._mark()
        if (
            (literal := self.expect('+'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('-'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_67(self) -> Optional[Any]:
        # _tmp_67: '+' | '-'
        mark = self._mark()
        if (
            (literal := self.expect('+'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('-'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_68(self) -> Optional[Any]:
        # _tmp_68: '.' | '(' | '='
        mark = self._mark()
        if (
            (literal := self.expect('.'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('('))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('='))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_69(self) -> Optional[Any]:
        # _tmp_69: '.' | '(' | '='
        mark = self._mark()
        if (
            (literal := self.expect('.'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('('))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('='))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _loop0_71(self) -> Optional[Any]:
        # _loop0_71: ',' maybe_star_pattern
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.maybe_star_pattern())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_70(self) -> Optional[Any]:
        # _gather_70: maybe_star_pattern _loop0_71
        mark = self._mark()
        if (
            (elem := self.maybe_star_pattern())
            is not None
            and
            (seq := self._loop0_71())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_73(self) -> Optional[Any]:
        # _loop0_73: ',' key_value_pattern
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.key_value_pattern())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_72(self) -> Optional[Any]:
        # _gather_72: key_value_pattern _loop0_73
        mark = self._mark()
        if (
            (elem := self.key_value_pattern())
            is not None
            and
            (seq := self._loop0_73())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _tmp_74(self) -> Optional[Any]:
        # _tmp_74: literal_expr | attr
        mark = self._mark()
        if (
            (literal_expr := self.literal_expr())
        ):
            return literal_expr
        self._reset(mark)
        if (
            (attr := self.attr())
        ):
            return attr
        self._reset(mark)
        return None

    @memoize
    def _loop0_76(self) -> Optional[Any]:
        # _loop0_76: ',' pattern
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.pattern())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_75(self) -> Optional[Any]:
        # _gather_75: pattern _loop0_76
        mark = self._mark()
        if (
            (elem := self.pattern())
            is not None
            and
            (seq := self._loop0_76())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_78(self) -> Optional[Any]:
        # _loop0_78: ',' keyword_pattern
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.keyword_pattern())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_77(self) -> Optional[Any]:
        # _gather_77: keyword_pattern _loop0_78
        mark = self._mark()
        if (
            (elem := self.keyword_pattern())
            is not None
            and
            (seq := self._loop0_78())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop1_79(self) -> Optional[Any]:
        # _loop1_79: (',' expression)
        mark = self._mark()
        children = []
        while (
            (_tmp_200 := self._tmp_200())
        ):
            children.append(_tmp_200)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_80(self) -> Optional[Any]:
        # _loop1_80: (',' star_expression)
        mark = self._mark()
        children = []
        while (
            (_tmp_201 := self._tmp_201())
        ):
            children.append(_tmp_201)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_82(self) -> Optional[Any]:
        # _loop0_82: ',' star_named_expression
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.star_named_expression())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_81(self) -> Optional[Any]:
        # _gather_81: star_named_expression _loop0_82
        mark = self._mark()
        if (
            (elem := self.star_named_expression())
            is not None
            and
            (seq := self._loop0_82())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop1_83(self) -> Optional[Any]:
        # _loop1_83: ('or' conjunction)
        mark = self._mark()
        children = []
        while (
            (_tmp_202 := self._tmp_202())
        ):
            children.append(_tmp_202)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_84(self) -> Optional[Any]:
        # _loop1_84: ('??' conjunction)
        mark = self._mark()
        children = []
        while (
            (_tmp_203 := self._tmp_203())
        ):
            children.append(_tmp_203)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_85(self) -> Optional[Any]:
        # _loop1_85: ('and' inversion)
        mark = self._mark()
        children = []
        while (
            (_tmp_204 := self._tmp_204())
        ):
            children.append(_tmp_204)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_86(self) -> Optional[Any]:
        # _loop1_86: compare_op_pipe_expression_pair
        mark = self._mark()
        children = []
        while (
            (compare_op_pipe_expression_pair := self.compare_op_pipe_expression_pair())
        ):
            children.append(compare_op_pipe_expression_pair)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_88(self) -> Optional[Any]:
        # _loop0_88: ',' slice
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.slice())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_87(self) -> Optional[Any]:
        # _gather_87: slice _loop0_88
        mark = self._mark()
        if (
            (elem := self.slice())
            is not None
            and
            (seq := self._loop0_88())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _tmp_89(self) -> Optional[Any]:
        # _tmp_89: ':' expression?
        mark = self._mark()
        if (
            (literal := self.expect(':'))
            and
            (d := self.expression(),)
        ):
            return d
        self._reset(mark)
        return None

    @memoize
    def _tmp_90(self) -> Optional[Any]:
        # _tmp_90: tuple | group | genexp
        mark = self._mark()
        if (
            (tuple := self.tuple())
        ):
            return tuple
        self._reset(mark)
        if (
            (group := self.group())
        ):
            return group
        self._reset(mark)
        if (
            (genexp := self.genexp())
        ):
            return genexp
        self._reset(mark)
        return None

    @memoize
    def _tmp_91(self) -> Optional[Any]:
        # _tmp_91: list | listcomp
        mark = self._mark()
        if (
            (list := self.list())
        ):
            return list
        self._reset(mark)
        if (
            (listcomp := self.listcomp())
        ):
            return listcomp
        self._reset(mark)
        return None

    @memoize
    def _tmp_92(self) -> Optional[Any]:
        # _tmp_92: dict | set | dictcomp | setcomp
        mark = self._mark()
        if (
            (dict := self.dict())
        ):
            return dict
        self._reset(mark)
        if (
            (set := self.set())
        ):
            return set
        self._reset(mark)
        if (
            (dictcomp := self.dictcomp())
        ):
            return dictcomp
        self._reset(mark)
        if (
            (setcomp := self.setcomp())
        ):
            return setcomp
        self._reset(mark)
        return None

    @memoize
    def _tmp_93(self) -> Optional[Any]:
        # _tmp_93: yield_expr | named_expression
        mark = self._mark()
        if (
            (yield_expr := self.yield_expr())
        ):
            return yield_expr
        self._reset(mark)
        if (
            (named_expression := self.named_expression())
        ):
            return named_expression
        self._reset(mark)
        return None

    @memoize
    def _loop0_94(self) -> Optional[Any]:
        # _loop0_94: lambda_param_no_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_no_default := self.lambda_param_no_default())
        ):
            children.append(lambda_param_no_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_95(self) -> Optional[Any]:
        # _loop0_95: lambda_param_with_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_with_default := self.lambda_param_with_default())
        ):
            children.append(lambda_param_with_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_96(self) -> Optional[Any]:
        # _loop0_96: lambda_param_with_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_with_default := self.lambda_param_with_default())
        ):
            children.append(lambda_param_with_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_97(self) -> Optional[Any]:
        # _loop1_97: lambda_param_no_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_no_default := self.lambda_param_no_default())
        ):
            children.append(lambda_param_no_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_98(self) -> Optional[Any]:
        # _loop0_98: lambda_param_with_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_with_default := self.lambda_param_with_default())
        ):
            children.append(lambda_param_with_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_99(self) -> Optional[Any]:
        # _loop1_99: lambda_param_with_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_with_default := self.lambda_param_with_default())
        ):
            children.append(lambda_param_with_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_100(self) -> Optional[Any]:
        # _loop1_100: lambda_param_no_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_no_default := self.lambda_param_no_default())
        ):
            children.append(lambda_param_no_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_101(self) -> Optional[Any]:
        # _loop1_101: lambda_param_no_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_no_default := self.lambda_param_no_default())
        ):
            children.append(lambda_param_no_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_102(self) -> Optional[Any]:
        # _loop0_102: lambda_param_no_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_no_default := self.lambda_param_no_default())
        ):
            children.append(lambda_param_no_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_103(self) -> Optional[Any]:
        # _loop1_103: lambda_param_with_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_with_default := self.lambda_param_with_default())
        ):
            children.append(lambda_param_with_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_104(self) -> Optional[Any]:
        # _loop0_104: lambda_param_no_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_no_default := self.lambda_param_no_default())
        ):
            children.append(lambda_param_no_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_105(self) -> Optional[Any]:
        # _loop1_105: lambda_param_with_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_with_default := self.lambda_param_with_default())
        ):
            children.append(lambda_param_with_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_106(self) -> Optional[Any]:
        # _loop0_106: lambda_param_maybe_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_maybe_default := self.lambda_param_maybe_default())
        ):
            children.append(lambda_param_maybe_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_107(self) -> Optional[Any]:
        # _loop1_107: lambda_param_maybe_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_maybe_default := self.lambda_param_maybe_default())
        ):
            children.append(lambda_param_maybe_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_108(self) -> Optional[Any]:
        # _loop1_108: STRING
        mark = self._mark()
        children = []
        while (
            (string := self.string())
        ):
            children.append(string)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _tmp_109(self) -> Optional[Any]:
        # _tmp_109: star_named_expression ',' star_named_expressions?
        mark = self._mark()
        if (
            (y := self.star_named_expression())
            and
            (literal := self.expect(','))
            and
            (z := self.star_named_expressions(),)
        ):
            return [y] + ( z or [] )
        self._reset(mark)
        return None

    @memoize
    def _loop0_111(self) -> Optional[Any]:
        # _loop0_111: ',' double_starred_kvpair
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.double_starred_kvpair())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_110(self) -> Optional[Any]:
        # _gather_110: double_starred_kvpair _loop0_111
        mark = self._mark()
        if (
            (elem := self.double_starred_kvpair())
            is not None
            and
            (seq := self._loop0_111())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop1_112(self) -> Optional[Any]:
        # _loop1_112: for_if_clause
        mark = self._mark()
        children = []
        while (
            (for_if_clause := self.for_if_clause())
        ):
            children.append(for_if_clause)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_113(self) -> Optional[Any]:
        # _loop0_113: ('if' disjunction)
        mark = self._mark()
        children = []
        while (
            (_tmp_205 := self._tmp_205())
        ):
            children.append(_tmp_205)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_114(self) -> Optional[Any]:
        # _loop0_114: ('if' disjunction)
        mark = self._mark()
        children = []
        while (
            (_tmp_206 := self._tmp_206())
        ):
            children.append(_tmp_206)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _tmp_115(self) -> Optional[Any]:
        # _tmp_115: assignment_expression | expression !':='
        mark = self._mark()
        if (
            (assignment_expression := self.assignment_expression())
        ):
            return assignment_expression
        self._reset(mark)
        if (
            (expression := self.expression())
            and
            self.negative_lookahead(self.expect, ':=')
        ):
            return expression
        self._reset(mark)
        return None

    @memoize
    def _loop0_117(self) -> Optional[Any]:
        # _loop0_117: ',' (starred_expression | (assignment_expression | expression !':=') !'=')
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self._tmp_207())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_116(self) -> Optional[Any]:
        # _gather_116: (starred_expression | (assignment_expression | expression !':=') !'=') _loop0_117
        mark = self._mark()
        if (
            (elem := self._tmp_207())
            is not None
            and
            (seq := self._loop0_117())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _tmp_118(self) -> Optional[Any]:
        # _tmp_118: ',' kwargs
        mark = self._mark()
        if (
            (literal := self.expect(','))
            and
            (k := self.kwargs())
        ):
            return k
        self._reset(mark)
        return None

    @memoize
    def _loop0_120(self) -> Optional[Any]:
        # _loop0_120: ',' kwarg_or_starred
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.kwarg_or_starred())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_119(self) -> Optional[Any]:
        # _gather_119: kwarg_or_starred _loop0_120
        mark = self._mark()
        if (
            (elem := self.kwarg_or_starred())
            is not None
            and
            (seq := self._loop0_120())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_122(self) -> Optional[Any]:
        # _loop0_122: ',' kwarg_or_double_starred
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.kwarg_or_double_starred())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_121(self) -> Optional[Any]:
        # _gather_121: kwarg_or_double_starred _loop0_122
        mark = self._mark()
        if (
            (elem := self.kwarg_or_double_starred())
            is not None
            and
            (seq := self._loop0_122())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_124(self) -> Optional[Any]:
        # _loop0_124: ',' kwarg_or_starred
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.kwarg_or_starred())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_123(self) -> Optional[Any]:
        # _gather_123: kwarg_or_starred _loop0_124
        mark = self._mark()
        if (
            (elem := self.kwarg_or_starred())
            is not None
            and
            (seq := self._loop0_124())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_126(self) -> Optional[Any]:
        # _loop0_126: ',' kwarg_or_double_starred
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.kwarg_or_double_starred())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_125(self) -> Optional[Any]:
        # _gather_125: kwarg_or_double_starred _loop0_126
        mark = self._mark()
        if (
            (elem := self.kwarg_or_double_starred())
            is not None
            and
            (seq := self._loop0_126())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_128(self) -> Optional[Any]:
        # _loop0_128: "," (partial_placeholder | partial_starred_expression | (assignment_expression | expression !':=') !'=')
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(","))
            and
            (elem := self._tmp_208())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_127(self) -> Optional[Any]:
        # _gather_127: (partial_placeholder | partial_starred_expression | (assignment_expression | expression !':=') !'=') _loop0_128
        mark = self._mark()
        if (
            (elem := self._tmp_208())
            is not None
            and
            (seq := self._loop0_128())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _tmp_129(self) -> Optional[Any]:
        # _tmp_129: ',' partial_kwargs
        mark = self._mark()
        if (
            (literal := self.expect(','))
            and
            (k := self.partial_kwargs())
        ):
            return k
        self._reset(mark)
        return None

    @memoize
    def _loop0_131(self) -> Optional[Any]:
        # _loop0_131: ',' partial_kwarg_or_starred
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.partial_kwarg_or_starred())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_130(self) -> Optional[Any]:
        # _gather_130: partial_kwarg_or_starred _loop0_131
        mark = self._mark()
        if (
            (elem := self.partial_kwarg_or_starred())
            is not None
            and
            (seq := self._loop0_131())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_133(self) -> Optional[Any]:
        # _loop0_133: ',' partial_kwarg_or_double_starred
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.partial_kwarg_or_double_starred())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_132(self) -> Optional[Any]:
        # _gather_132: partial_kwarg_or_double_starred _loop0_133
        mark = self._mark()
        if (
            (elem := self.partial_kwarg_or_double_starred())
            is not None
            and
            (seq := self._loop0_133())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_135(self) -> Optional[Any]:
        # _loop0_135: ',' partial_kwarg_or_starred
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.partial_kwarg_or_starred())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_134(self) -> Optional[Any]:
        # _gather_134: partial_kwarg_or_starred _loop0_135
        mark = self._mark()
        if (
            (elem := self.partial_kwarg_or_starred())
            is not None
            and
            (seq := self._loop0_135())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_137(self) -> Optional[Any]:
        # _loop0_137: ',' partial_kwarg_or_double_starred
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.partial_kwarg_or_double_starred())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_136(self) -> Optional[Any]:
        # _gather_136: partial_kwarg_or_double_starred _loop0_137
        mark = self._mark()
        if (
            (elem := self.partial_kwarg_or_double_starred())
            is not None
            and
            (seq := self._loop0_137())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _tmp_138(self) -> Optional[Any]:
        # _tmp_138: partial_placeholder | expression
        mark = self._mark()
        if (
            (partial_placeholder := self.partial_placeholder())
        ):
            return partial_placeholder
        self._reset(mark)
        if (
            (expression := self.expression())
        ):
            return expression
        self._reset(mark)
        return None

    @memoize
    def _tmp_139(self) -> Optional[Any]:
        # _tmp_139: partial_placeholder | expression
        mark = self._mark()
        if (
            (partial_placeholder := self.partial_placeholder())
        ):
            return partial_placeholder
        self._reset(mark)
        if (
            (expression := self.expression())
        ):
            return expression
        self._reset(mark)
        return None

    @memoize
    def _tmp_140(self) -> Optional[Any]:
        # _tmp_140: partial_placeholder | expression
        mark = self._mark()
        if (
            (partial_placeholder := self.partial_placeholder())
        ):
            return partial_placeholder
        self._reset(mark)
        if (
            (expression := self.expression())
        ):
            return expression
        self._reset(mark)
        return None

    @memoize
    def _tmp_141(self) -> Optional[Any]:
        # _tmp_141: partial_placeholder | expression
        mark = self._mark()
        if (
            (partial_placeholder := self.partial_placeholder())
        ):
            return partial_placeholder
        self._reset(mark)
        if (
            (expression := self.expression())
        ):
            return expression
        self._reset(mark)
        return None

    @memoize
    def _loop0_142(self) -> Optional[Any]:
        # _loop0_142: (',' star_target)
        mark = self._mark()
        children = []
        while (
            (_tmp_209 := self._tmp_209())
        ):
            children.append(_tmp_209)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_144(self) -> Optional[Any]:
        # _loop0_144: ',' star_target
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.star_target())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_143(self) -> Optional[Any]:
        # _gather_143: star_target _loop0_144
        mark = self._mark()
        if (
            (elem := self.star_target())
            is not None
            and
            (seq := self._loop0_144())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop1_145(self) -> Optional[Any]:
        # _loop1_145: (',' star_target)
        mark = self._mark()
        children = []
        while (
            (_tmp_210 := self._tmp_210())
        ):
            children.append(_tmp_210)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _tmp_146(self) -> Optional[Any]:
        # _tmp_146: !'*' star_target
        mark = self._mark()
        if (
            self.negative_lookahead(self.expect, '*')
            and
            (star_target := self.star_target())
        ):
            return star_target
        self._reset(mark)
        return None

    @memoize
    def _loop0_148(self) -> Optional[Any]:
        # _loop0_148: ',' del_target
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.del_target())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_147(self) -> Optional[Any]:
        # _gather_147: del_target _loop0_148
        mark = self._mark()
        if (
            (elem := self.del_target())
            is not None
            and
            (seq := self._loop0_148())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_150(self) -> Optional[Any]:
        # _loop0_150: ',' expression
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.expression())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_149(self) -> Optional[Any]:
        # _gather_149: expression _loop0_150
        mark = self._mark()
        if (
            (elem := self.expression())
            is not None
            and
            (seq := self._loop0_150())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_152(self) -> Optional[Any]:
        # _loop0_152: ',' expression
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.expression())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_151(self) -> Optional[Any]:
        # _gather_151: expression _loop0_152
        mark = self._mark()
        if (
            (elem := self.expression())
            is not None
            and
            (seq := self._loop0_152())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_154(self) -> Optional[Any]:
        # _loop0_154: ',' expression
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.expression())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_153(self) -> Optional[Any]:
        # _gather_153: expression _loop0_154
        mark = self._mark()
        if (
            (elem := self.expression())
            is not None
            and
            (seq := self._loop0_154())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_156(self) -> Optional[Any]:
        # _loop0_156: ',' expression
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.expression())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_155(self) -> Optional[Any]:
        # _gather_155: expression _loop0_156
        mark = self._mark()
        if (
            (elem := self.expression())
            is not None
            and
            (seq := self._loop0_156())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _tmp_157(self) -> Optional[Any]:
        # _tmp_157: NEWLINE INDENT
        mark = self._mark()
        if (
            (_newline := self.expect('NEWLINE'))
            and
            (_indent := self.expect('INDENT'))
        ):
            return [_newline, _indent]
        self._reset(mark)
        return None

    @memoize
    def _tmp_158(self) -> Optional[Any]:
        # _tmp_158: args | expression for_if_clauses
        mark = self._mark()
        if (
            (args := self.args())
        ):
            return args
        self._reset(mark)
        if (
            (expression := self.expression())
            and
            (for_if_clauses := self.for_if_clauses())
        ):
            return [expression, for_if_clauses]
        self._reset(mark)
        return None

    @memoize
    def _tmp_159(self) -> Optional[Any]:
        # _tmp_159: NAME '='
        mark = self._mark()
        if (
            (name := self.name())
            and
            (literal := self.expect('='))
        ):
            return [name, literal]
        self._reset(mark)
        return None

    @memoize
    def _tmp_160(self) -> Optional[Any]:
        # _tmp_160: NAME STRING | SOFT_KEYWORD
        mark = self._mark()
        if (
            (name := self.name())
            and
            (string := self.string())
        ):
            return [name, string]
        self._reset(mark)
        if (
            (soft_keyword := self.soft_keyword())
        ):
            return soft_keyword
        self._reset(mark)
        return None

    @memoize
    def _tmp_161(self) -> Optional[Any]:
        # _tmp_161: 'else' | ':'
        mark = self._mark()
        if (
            (literal := self.expect('else'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect(':'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_162(self) -> Optional[Any]:
        # _tmp_162: '=' | ':='
        mark = self._mark()
        if (
            (literal := self.expect('='))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect(':='))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_163(self) -> Optional[Any]:
        # _tmp_163: list | tuple | genexp | 'True' | 'None' | 'False'
        mark = self._mark()
        if (
            (list := self.list())
        ):
            return list
        self._reset(mark)
        if (
            (tuple := self.tuple())
        ):
            return tuple
        self._reset(mark)
        if (
            (genexp := self.genexp())
        ):
            return genexp
        self._reset(mark)
        if (
            (literal := self.expect('True'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('None'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('False'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_164(self) -> Optional[Any]:
        # _tmp_164: '=' | ':='
        mark = self._mark()
        if (
            (literal := self.expect('='))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect(':='))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _loop0_165(self) -> Optional[Any]:
        # _loop0_165: star_named_expressions
        mark = self._mark()
        children = []
        while (
            (star_named_expressions := self.star_named_expressions())
        ):
            children.append(star_named_expressions)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_166(self) -> Optional[Any]:
        # _loop0_166: (star_targets '=')
        mark = self._mark()
        children = []
        while (
            (_tmp_211 := self._tmp_211())
        ):
            children.append(_tmp_211)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_167(self) -> Optional[Any]:
        # _loop0_167: (star_targets '=')
        mark = self._mark()
        children = []
        while (
            (_tmp_212 := self._tmp_212())
        ):
            children.append(_tmp_212)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _tmp_168(self) -> Optional[Any]:
        # _tmp_168: yield_expr | star_expressions
        mark = self._mark()
        if (
            (yield_expr := self.yield_expr())
        ):
            return yield_expr
        self._reset(mark)
        if (
            (star_expressions := self.star_expressions())
        ):
            return star_expressions
        self._reset(mark)
        return None

    @memoize
    def _tmp_169(self) -> Optional[Any]:
        # _tmp_169: '[' | '(' | '{'
        mark = self._mark()
        if (
            (literal := self.expect('['))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('('))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('{'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_170(self) -> Optional[Any]:
        # _tmp_170: '[' | '{'
        mark = self._mark()
        if (
            (literal := self.expect('['))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('{'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_171(self) -> Optional[Any]:
        # _tmp_171: '[' | '{'
        mark = self._mark()
        if (
            (literal := self.expect('['))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('{'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _loop0_172(self) -> Optional[Any]:
        # _loop0_172: param_no_default
        mark = self._mark()
        children = []
        while (
            (param_no_default := self.param_no_default())
        ):
            children.append(param_no_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_173(self) -> Optional[Any]:
        # _loop1_173: param_with_default
        mark = self._mark()
        children = []
        while (
            (param_with_default := self.param_with_default())
        ):
            children.append(param_with_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop0_174(self) -> Optional[Any]:
        # _loop0_174: lambda_param_no_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_no_default := self.lambda_param_no_default())
        ):
            children.append(lambda_param_no_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _loop1_175(self) -> Optional[Any]:
        # _loop1_175: lambda_param_with_default
        mark = self._mark()
        children = []
        while (
            (lambda_param_with_default := self.lambda_param_with_default())
        ):
            children.append(lambda_param_with_default)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _tmp_176(self) -> Optional[Any]:
        # _tmp_176: ')' | ',' (')' | '**')
        mark = self._mark()
        if (
            (literal := self.expect(')'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect(','))
            and
            (_tmp_213 := self._tmp_213())
        ):
            return [literal, _tmp_213]
        self._reset(mark)
        return None

    @memoize
    def _tmp_177(self) -> Optional[Any]:
        # _tmp_177: ':' | ',' (':' | '**')
        mark = self._mark()
        if (
            (literal := self.expect(':'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect(','))
            and
            (_tmp_214 := self._tmp_214())
        ):
            return [literal, _tmp_214]
        self._reset(mark)
        return None

    @memoize
    def _tmp_178(self) -> Optional[Any]:
        # _tmp_178: ',' | ')' | ':'
        mark = self._mark()
        if (
            (literal := self.expect(','))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect(')'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect(':'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _loop0_180(self) -> Optional[Any]:
        # _loop0_180: ',' (expression ['as' star_target])
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self._tmp_215())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_179(self) -> Optional[Any]:
        # _gather_179: (expression ['as' star_target]) _loop0_180
        mark = self._mark()
        if (
            (elem := self._tmp_215())
            is not None
            and
            (seq := self._loop0_180())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_182(self) -> Optional[Any]:
        # _loop0_182: ',' (expressions ['as' star_target])
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self._tmp_216())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_181(self) -> Optional[Any]:
        # _gather_181: (expressions ['as' star_target]) _loop0_182
        mark = self._mark()
        if (
            (elem := self._tmp_216())
            is not None
            and
            (seq := self._loop0_182())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_184(self) -> Optional[Any]:
        # _loop0_184: ',' (expression ['as' star_target])
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self._tmp_217())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_183(self) -> Optional[Any]:
        # _gather_183: (expression ['as' star_target]) _loop0_184
        mark = self._mark()
        if (
            (elem := self._tmp_217())
            is not None
            and
            (seq := self._loop0_184())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _loop0_186(self) -> Optional[Any]:
        # _loop0_186: ',' (expressions ['as' star_target])
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self._tmp_218())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_185(self) -> Optional[Any]:
        # _gather_185: (expressions ['as' star_target]) _loop0_186
        mark = self._mark()
        if (
            (elem := self._tmp_218())
            is not None
            and
            (seq := self._loop0_186())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _tmp_187(self) -> Optional[Any]:
        # _tmp_187: 'except' | 'finally'
        mark = self._mark()
        if (
            (literal := self.expect('except'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('finally'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_188(self) -> Optional[Any]:
        # _tmp_188: 'as' NAME
        mark = self._mark()
        if (
            (literal := self.expect('as'))
            and
            (name := self.name())
        ):
            return [literal, name]
        self._reset(mark)
        return None

    @memoize
    def _tmp_189(self) -> Optional[Any]:
        # _tmp_189: 'as' NAME
        mark = self._mark()
        if (
            (literal := self.expect('as'))
            and
            (name := self.name())
        ):
            return [literal, name]
        self._reset(mark)
        return None

    @memoize
    def _tmp_190(self) -> Optional[Any]:
        # _tmp_190: 'as' NAME
        mark = self._mark()
        if (
            (literal := self.expect('as'))
            and
            (name := self.name())
        ):
            return [literal, name]
        self._reset(mark)
        return None

    @memoize
    def _tmp_191(self) -> Optional[Any]:
        # _tmp_191: positional_patterns ','
        mark = self._mark()
        if (
            (positional_patterns := self.positional_patterns())
            and
            (literal := self.expect(','))
        ):
            return [positional_patterns, literal]
        self._reset(mark)
        return None

    @memoize
    def _tmp_192(self) -> Optional[Any]:
        # _tmp_192: '->' expression
        mark = self._mark()
        if (
            (literal := self.expect('->'))
            and
            (expression := self.expression())
        ):
            return [literal, expression]
        self._reset(mark)
        return None

    @memoize
    def _tmp_193(self) -> Optional[Any]:
        # _tmp_193: '(' arguments? ')'
        mark = self._mark()
        if (
            (literal := self.expect('('))
            and
            (opt := self.arguments(),)
            and
            (literal_1 := self.expect(')'))
        ):
            return [literal, opt, literal_1]
        self._reset(mark)
        return None

    @memoize
    def _loop0_195(self) -> Optional[Any]:
        # _loop0_195: ',' double_starred_kvpair
        mark = self._mark()
        children = []
        while (
            (literal := self.expect(','))
            and
            (elem := self.double_starred_kvpair())
        ):
            children.append(elem)
            mark = self._mark()
        self._reset(mark)
        return children

    @memoize
    def _gather_194(self) -> Optional[Any]:
        # _gather_194: double_starred_kvpair _loop0_195
        mark = self._mark()
        if (
            (elem := self.double_starred_kvpair())
            is not None
            and
            (seq := self._loop0_195())
            is not None
        ):
            return [elem] + seq
        self._reset(mark)
        return None

    @memoize
    def _tmp_196(self) -> Optional[Any]:
        # _tmp_196: '}' | ','
        mark = self._mark()
        if (
            (literal := self.expect('}'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect(','))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_197(self) -> Optional[Any]:
        # _tmp_197: star_targets '='
        mark = self._mark()
        if (
            (z := self.star_targets())
            and
            (literal := self.expect('='))
        ):
            return z
        self._reset(mark)
        return None

    @memoize
    def _tmp_198(self) -> Optional[Any]:
        # _tmp_198: '.' | '...'
        mark = self._mark()
        if (
            (literal := self.expect('.'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('...'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_199(self) -> Optional[Any]:
        # _tmp_199: '.' | '...'
        mark = self._mark()
        if (
            (literal := self.expect('.'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('...'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_200(self) -> Optional[Any]:
        # _tmp_200: ',' expression
        mark = self._mark()
        if (
            (literal := self.expect(','))
            and
            (c := self.expression())
        ):
            return c
        self._reset(mark)
        return None

    @memoize
    def _tmp_201(self) -> Optional[Any]:
        # _tmp_201: ',' star_expression
        mark = self._mark()
        if (
            (literal := self.expect(','))
            and
            (c := self.star_expression())
        ):
            return c
        self._reset(mark)
        return None

    @memoize
    def _tmp_202(self) -> Optional[Any]:
        # _tmp_202: 'or' conjunction
        mark = self._mark()
        if (
            (literal := self.expect('or'))
            and
            (c := self.conjunction())
        ):
            return c
        self._reset(mark)
        return None

    @memoize
    def _tmp_203(self) -> Optional[Any]:
        # _tmp_203: '??' conjunction
        mark = self._mark()
        if (
            (literal := self.expect('??'))
            and
            (c := self.conjunction())
        ):
            return c
        self._reset(mark)
        return None

    @memoize
    def _tmp_204(self) -> Optional[Any]:
        # _tmp_204: 'and' inversion
        mark = self._mark()
        if (
            (literal := self.expect('and'))
            and
            (c := self.inversion())
        ):
            return c
        self._reset(mark)
        return None

    @memoize
    def _tmp_205(self) -> Optional[Any]:
        # _tmp_205: 'if' disjunction
        mark = self._mark()
        if (
            (literal := self.expect('if'))
            and
            (z := self.disjunction())
        ):
            return z
        self._reset(mark)
        return None

    @memoize
    def _tmp_206(self) -> Optional[Any]:
        # _tmp_206: 'if' disjunction
        mark = self._mark()
        if (
            (literal := self.expect('if'))
            and
            (z := self.disjunction())
        ):
            return z
        self._reset(mark)
        return None

    @memoize
    def _tmp_207(self) -> Optional[Any]:
        # _tmp_207: starred_expression | (assignment_expression | expression !':=') !'='
        mark = self._mark()
        if (
            (starred_expression := self.starred_expression())
        ):
            return starred_expression
        self._reset(mark)
        if (
            (_tmp_219 := self._tmp_219())
            and
            self.negative_lookahead(self.expect, '=')
        ):
            return _tmp_219
        self._reset(mark)
        return None

    @memoize
    def _tmp_208(self) -> Optional[Any]:
        # _tmp_208: partial_placeholder | partial_starred_expression | (assignment_expression | expression !':=') !'='
        mark = self._mark()
        if (
            (partial_placeholder := self.partial_placeholder())
        ):
            return partial_placeholder
        self._reset(mark)
        if (
            (partial_starred_expression := self.partial_starred_expression())
        ):
            return partial_starred_expression
        self._reset(mark)
        if (
            (_tmp_220 := self._tmp_220())
            and
            self.negative_lookahead(self.expect, '=')
        ):
            return _tmp_220
        self._reset(mark)
        return None

    @memoize
    def _tmp_209(self) -> Optional[Any]:
        # _tmp_209: ',' star_target
        mark = self._mark()
        if (
            (literal := self.expect(','))
            and
            (c := self.star_target())
        ):
            return c
        self._reset(mark)
        return None

    @memoize
    def _tmp_210(self) -> Optional[Any]:
        # _tmp_210: ',' star_target
        mark = self._mark()
        if (
            (literal := self.expect(','))
            and
            (c := self.star_target())
        ):
            return c
        self._reset(mark)
        return None

    @memoize
    def _tmp_211(self) -> Optional[Any]:
        # _tmp_211: star_targets '='
        mark = self._mark()
        if (
            (star_targets := self.star_targets())
            and
            (literal := self.expect('='))
        ):
            return [star_targets, literal]
        self._reset(mark)
        return None

    @memoize
    def _tmp_212(self) -> Optional[Any]:
        # _tmp_212: star_targets '='
        mark = self._mark()
        if (
            (star_targets := self.star_targets())
            and
            (literal := self.expect('='))
        ):
            return [star_targets, literal]
        self._reset(mark)
        return None

    @memoize
    def _tmp_213(self) -> Optional[Any]:
        # _tmp_213: ')' | '**'
        mark = self._mark()
        if (
            (literal := self.expect(')'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('**'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_214(self) -> Optional[Any]:
        # _tmp_214: ':' | '**'
        mark = self._mark()
        if (
            (literal := self.expect(':'))
        ):
            return literal
        self._reset(mark)
        if (
            (literal := self.expect('**'))
        ):
            return literal
        self._reset(mark)
        return None

    @memoize
    def _tmp_215(self) -> Optional[Any]:
        # _tmp_215: expression ['as' star_target]
        mark = self._mark()
        if (
            (expression := self.expression())
            and
            (opt := self._tmp_221(),)
        ):
            return [expression, opt]
        self._reset(mark)
        return None

    @memoize
    def _tmp_216(self) -> Optional[Any]:
        # _tmp_216: expressions ['as' star_target]
        mark = self._mark()
        if (
            (expressions := self.expressions())
            and
            (opt := self._tmp_222(),)
        ):
            return [expressions, opt]
        self._reset(mark)
        return None

    @memoize
    def _tmp_217(self) -> Optional[Any]:
        # _tmp_217: expression ['as' star_target]
        mark = self._mark()
        if (
            (expression := self.expression())
            and
            (opt := self._tmp_223(),)
        ):
            return [expression, opt]
        self._reset(mark)
        return None

    @memoize
    def _tmp_218(self) -> Optional[Any]:
        # _tmp_218: expressions ['as' star_target]
        mark = self._mark()
        if (
            (expressions := self.expressions())
            and
            (opt := self._tmp_224(),)
        ):
            return [expressions, opt]
        self._reset(mark)
        return None

    @memoize
    def _tmp_219(self) -> Optional[Any]:
        # _tmp_219: assignment_expression | expression !':='
        mark = self._mark()
        if (
            (assignment_expression := self.assignment_expression())
        ):
            return assignment_expression
        self._reset(mark)
        if (
            (expression := self.expression())
            and
            self.negative_lookahead(self.expect, ':=')
        ):
            return expression
        self._reset(mark)
        return None

    @memoize
    def _tmp_220(self) -> Optional[Any]:
        # _tmp_220: assignment_expression | expression !':='
        mark = self._mark()
        if (
            (assignment_expression := self.assignment_expression())
        ):
            return assignment_expression
        self._reset(mark)
        if (
            (expression := self.expression())
            and
            self.negative_lookahead(self.expect, ':=')
        ):
            return expression
        self._reset(mark)
        return None

    @memoize
    def _tmp_221(self) -> Optional[Any]:
        # _tmp_221: 'as' star_target
        mark = self._mark()
        if (
            (literal := self.expect('as'))
            and
            (star_target := self.star_target())
        ):
            return [literal, star_target]
        self._reset(mark)
        return None

    @memoize
    def _tmp_222(self) -> Optional[Any]:
        # _tmp_222: 'as' star_target
        mark = self._mark()
        if (
            (literal := self.expect('as'))
            and
            (star_target := self.star_target())
        ):
            return [literal, star_target]
        self._reset(mark)
        return None

    @memoize
    def _tmp_223(self) -> Optional[Any]:
        # _tmp_223: 'as' star_target
        mark = self._mark()
        if (
            (literal := self.expect('as'))
            and
            (star_target := self.star_target())
        ):
            return [literal, star_target]
        self._reset(mark)
        return None

    @memoize
    def _tmp_224(self) -> Optional[Any]:
        # _tmp_224: 'as' star_target
        mark = self._mark()
        if (
            (literal := self.expect('as'))
            and
            (star_target := self.star_target())
        ):
            return [literal, star_target]
        self._reset(mark)
        return None

    KEYWORDS = ('pass', 'class', 'def', 'return', 'nonlocal', 'if', 'is', 'not', 'in', 'and', 'continue', 'del', 'global', 'raise', 'else', 'from', 'True', 'False', 'break', 'try', 'while', 'async', 'None', 'await', 'yield', 'lambda', 'elif', 'except', 'import', 'with', 'or', 'finally', 'for', 'assert', 'as')
    SOFT_KEYWORDS = ('_', 'case', 'match')


if __name__ == '__main__':
    from pegen.parser import simple_parser_main
    simple_parser_main(PythonParser)
