# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetDirectoryResult',
    'AwaitableGetDirectoryResult',
    'get_directory',
    'get_directory_output',
]

@pulumi.output_type
class GetDirectoryResult:
    """
    A collection of values returned by getDirectory.
    """
    def __init__(__self__, id=None, object_id=None, path=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if object_id and not isinstance(object_id, int):
            raise TypeError("Expected argument 'object_id' to be a int")
        pulumi.set(__self__, "object_id", object_id)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> int:
        """
        directory object ID
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")


class AwaitableGetDirectoryResult(GetDirectoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDirectoryResult(
            id=self.id,
            object_id=self.object_id,
            path=self.path)


def get_directory(object_id: Optional[int] = None,
                  path: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDirectoryResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    prod = databricks.get_directory(path="/Production")
    ```


    :param int object_id: directory object ID
    :param str path: Path to a directory in the workspace
    """
    __args__ = dict()
    __args__['objectId'] = object_id
    __args__['path'] = path
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getDirectory:getDirectory', __args__, opts=opts, typ=GetDirectoryResult).value

    return AwaitableGetDirectoryResult(
        id=__ret__.id,
        object_id=__ret__.object_id,
        path=__ret__.path)


@_utilities.lift_output_func(get_directory)
def get_directory_output(object_id: Optional[pulumi.Input[Optional[int]]] = None,
                         path: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDirectoryResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    prod = databricks.get_directory(path="/Production")
    ```


    :param int object_id: directory object ID
    :param str path: Path to a directory in the workspace
    """
    ...
