# References

```{admonition} Citation
:class: attention

If you use *FRETraj* in your work please cite the following paper:

F.D. Steffen, R.K.O. Sigel, R. Börner, *Phys. Chem. Chem. Phys.* **2016**, *18*, 29045-29055. [![](https://img.shields.io/badge/DOI-10.1039/C6CP04277E-blue.svg)](https://doi.org/10.1039/C6CP04277E)

```
Here, we introduce the contact volume (CV) as an extension of the accessible volume (AV).

```{image} images/Steffen_PCCP_2016.png
:width: 450px
:align: center
```
---


## Related projects
```{margin}
The **accessible volume (AV)** approach is described as a geometrical search based on Djikstra's algorithm.
```
- S. Sindbert, S. Kalinin, C.A.M. Seidel et al. *JACS*, **2011**, *133*, 2463-2480. [![](https://img.shields.io/badge/DOI-10.1021/ja105725e-blue.svg)](https://doi.org/10.1021/ja105725e)
- S. Kalinin, T. Peulen, C.A.M. Seidel et al. *Nat. Methods*, **2012**, *9*, 1218-1225. [![](https://img.shields.io/badge/DOI-10.1038/nmeth.2222-blue.svg)](https://doi.org/10.1038/nmeth.2222)

```{margin}
The **nano-positioning system (NPS)** uses a Bayesian model to locate the dye with respect to the biomolecule
```
- A. Muschielok, J. Jawhari, J. Michaelis, *Nat. Methods*, **2008**, *5*, 965-971. [![](https://img.shields.io/badge/DOI-10.1038/nmeth.1259-blue.svg)](https://doi.org/10.1038/nmeth.1259)
- T. Eilert, M. Beckers, F. Drechsler, J. Michaelis, *Comput. Phys. Commun.*, **2017**, *219*, 377–389. [![](https://img.shields.io/badge/DOI-10.1016/j.cpc.2017.05.027-blue.svg)](https://doi.org/10.1016/j.cpc.2017.05.027)

```{margin}
Review of different **dye-linker models** including the ACV
```
- M. Dimura, T. Peulen, C.A.M. Seidel et al. *Curr. Opin. Struct. Biol.* **2016**, *40*, 163-185. [![](https://img.shields.io/badge/DOI-10.1016/j.sbi.2016.11.012-blue.svg)](https://doi.org/10.1016/j.sbi.2016.11.012)
- T. Peulen, O. Opanasyuk, C.A.M Seidel, *J. Phys. Chem . B.*, **2017**, *121*, 8211-8241. [![](https://img.shields.io/badge/DOI-10.1021/acs.jpcb.7b03441-blue.svg)](https://doi.org/10.1021/acs.jpcb.7b03441)

```{margin}
A recent benchmark for **FRET-assisted modeling** of proteins
```
- M. Dimura, T. Peulen, C.A.M Seidel et al. *Nat. Commun.* **2020**, *11*, 5394. [![](https://img.shields.io/badge/DOI-10.1038/s41467--020--19023--1-blue.svg)](https://doi.org/10.1038/s41467-020-19023-1)



## Bibliography
```{bibliography}
:style: unsrt
```