import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service codeguru
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncodeguru.html
 */
export declare class Codeguru extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service codeguru
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncodeguru.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Gets free trial summary for the CodeGuru service which includes expiration date.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetCodeGuruFreeTrialSummary.html
     */
    getCodeGuruFreeTrialSummary(): this;
}
