"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service codeguru
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncodeguru.html
 */
class Codeguru extends shared_1.PolicyStatement {
    /**
     * Action provider for service codeguru
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncodeguru.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'codeguru';
        this.actions = {
            "GetCodeGuruFreeTrialSummary": {
                "url": "https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetCodeGuruFreeTrialSummary.html",
                "description": "Gets free trial summary for the CodeGuru service which includes expiration date.",
                "accessLevel": "Read"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Gets free trial summary for the CodeGuru service which includes expiration date.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetCodeGuruFreeTrialSummary.html
     */
    getCodeGuruFreeTrialSummary() {
        this.add('codeguru:GetCodeGuruFreeTrialSummary');
        return this;
    }
}
exports.Codeguru = Codeguru;
//# sourceMappingURL=data:application/json;base64,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