import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service gamelift
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazongamelift.html
 */
export declare class Gamelift extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service gamelift
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazongamelift.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Registers player acceptance or rejection of a proposed FlexMatch match.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_AcceptMatch.html
     */
    acceptMatch(): this;
    /**
     * Defines a new alias for a fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateAlias.html
     */
    createAlias(): this;
    /**
     * Creates a new game build using files stored in an Amazon S3 bucket.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateBuild.html
     */
    createBuild(): this;
    /**
     * Creates a new fleet of computing resources to run your game servers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateFleet.html
     */
    createFleet(): this;
    /**
     * Starts a new game session on a specified fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSession.html
     */
    createGameSession(): this;
    /**
     * Sets up a new queue for processing new game session placement requests.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html
     */
    createGameSessionQueue(): this;
    /**
     * Creates a new FlexMatch matchmaker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateMatchmakingConfiguration.html
     */
    createMatchmakingConfiguration(): this;
    /**
     * Creates a new matchmaking rule set for FlexMatch.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateMatchmakingRuleSet.html
     */
    createMatchmakingRuleSet(): this;
    /**
     * Reserves an available game session slot for a player.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSession.html
     */
    createPlayerSession(): this;
    /**
     * Reserves available game session slots for multiple players.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSessions.html
     */
    createPlayerSessions(): this;
    /**
     * Creates a new Realtime Servers script.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateScript.html
     */
    createScript(): this;
    /**
     * Allows GameLift to create or delete a peering connection between a GameLift fleet VPC and a VPC on another AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html
     */
    createVpcPeeringAuthorization(): this;
    /**
     * Establishes a peering connection between your GameLift fleet VPC and a VPC on another account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringConnection.html
     */
    createVpcPeeringConnection(): this;
    /**
     * Deletes an alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteAlias.html
     */
    deleteAlias(): this;
    /**
     * Deletes a game build.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteBuild.html
     */
    deleteBuild(): this;
    /**
     * Deletes an empty fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteFleet.html
     */
    deleteFleet(): this;
    /**
     * Deletes an existing game session queue.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html
     */
    deleteGameSessionQueue(): this;
    /**
     * Deletes an existing FlexMatch matchmaker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteMatchmakingConfiguration.html
     */
    deleteMatchmakingConfiguration(): this;
    /**
     * Deletes an existing FlexMatch matchmaking rule set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteMatchmakingRuleSet.html
     */
    deleteMatchmakingRuleSet(): this;
    /**
     * Deletes a set of auto-scaling rules.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteScalingPolicy.html
     */
    deleteScalingPolicy(): this;
    /**
     * Deletes a Realtime Servers script.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteScript.html
     */
    deleteScript(): this;
    /**
     * Cancels a VPC peering authorization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteVpcPeeringAuthorization.html
     */
    deleteVpcPeeringAuthorization(): this;
    /**
     * Removes a peering connection between VPCs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteVpcPeeringConnection.html
     */
    deleteVpcPeeringConnection(): this;
    /**
     * Retrieves properties for an alias.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeAlias.html
     */
    describeAlias(): this;
    /**
     * Retrieves properties for a game build.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeBuild.html
     */
    describeBuild(): this;
    /**
     * Retrieves the maximum allowed and current usage for EC2 instance types.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeEC2InstanceLimits.html
     */
    describeEC2InstanceLimits(): this;
    /**
     * Retrieves general properties, including status, for fleets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetAttributes.html
     */
    describeFleetAttributes(): this;
    /**
     * Retrieves the current capacity setting for fleets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html
     */
    describeFleetCapacity(): this;
    /**
     * Retrieves entries from a fleet's event log.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html
     */
    describeFleetEvents(): this;
    /**
     * Retrieves the inbound connection permissions for a fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetPortSettings.html
     */
    describeFleetPortSettings(): this;
    /**
     * Retrieves utilization statistics for fleets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetUtilization.html
     */
    describeFleetUtilization(): this;
    /**
     * Retrieves properties for game sessions in a fleet, including the protection policy.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionDetails.html
     */
    describeGameSessionDetails(): this;
    /**
     * Retrieves details of a game session placement request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionPlacement.html
     */
    describeGameSessionPlacement(): this;
    /**
     * Retrieves properties for game session queues.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html
     */
    describeGameSessionQueues(): this;
    /**
     * Retrieves properties for game sessions in a fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessions.html
     */
    describeGameSessions(): this;
    /**
     * Retrieves information about instances in a fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeInstances.html
     */
    describeInstances(): this;
    /**
     * Retrieves details of matchmaking tickets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeMatchmaking.html
     */
    describeMatchmaking(): this;
    /**
     * Retrieves properties for FlexMatch matchmakers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeMatchmakingConfigurations.html
     */
    describeMatchmakingConfigurations(): this;
    /**
     * Retrieves properties for FlexMatch matchmaking rule sets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeMatchmakingRuleSets.html
     */
    describeMatchmakingRuleSets(): this;
    /**
     * Retrieves properties for player sessions in a game session.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribePlayerSessions.html
     */
    describePlayerSessions(): this;
    /**
     * Retrieves the current runtime configuration for a fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeRuntimeConfiguration.html
     */
    describeRuntimeConfiguration(): this;
    /**
     * Retrieves all scaling policies that are applied to a fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeScalingPolicies.html
     */
    describeScalingPolicies(): this;
    /**
     * Retrieves properties for a Realtime Servers script.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeScript.html
     */
    describeScript(): this;
    /**
     * Retrieves valid VPC peering authorizations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeVpcPeeringAuthorizations.html
     */
    describeVpcPeeringAuthorizations(): this;
    /**
     * Retrieves details on active or pending VPC peering connections.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeVpcPeeringConnections.html
     */
    describeVpcPeeringConnections(): this;
    /**
     * Retrieves the location of stored logs for a game session.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetGameSessionLogUrl.html
     */
    getGameSessionLogUrl(): this;
    /**
     * Requests remote access to a specified fleet instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetInstanceAccess.html
     */
    getInstanceAccess(): this;
    /**
     * Retrieves all aliases that are defined in the current region.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListAliases.html
     */
    listAliases(): this;
    /**
     * Retrieves all game build in the current region.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListBuilds.html
     */
    listBuilds(): this;
    /**
     * Retrieves a list of fleet IDs for all fleets in the current region.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListFleets.html
     */
    listFleets(): this;
    /**
     * Retrieves properties for all Realtime Servers scripts in the current region.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListScripts.html
     */
    listScripts(): this;
    /**
     * List Tags for GameLift Resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListTagsForResource.html
     */
    listTagsForResource(): this;
    /**
     * Creates or updates a fleet auto-scaling policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_PutScalingPolicy.html
     */
    putScalingPolicy(): this;
    /**
     * Retrieves fresh upload credentials to use when uploading a new game build.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_RequestUploadCredentials.html
     */
    requestUploadCredentials(): this;
    /**
     * Retrieves the fleet ID associated with an alias.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ResolveAlias.html
     */
    resolveAlias(): this;
    /**
     * Retrieves game sessions that match a set of search criteria.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_SearchGameSessions.html
     */
    searchGameSessions(): this;
    /**
     * Resumes auto-scaling activity on a fleet after it was suspended with StopFleetActions().
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartFleetActions.html
     */
    startFleetActions(): this;
    /**
     * Sends a game session placement request to a game session queue.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html
     */
    startGameSessionPlacement(): this;
    /**
     * Requests FlexMatch matchmaking to fill available player slots in an existing game session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchBackfill.html
     */
    startMatchBackfill(): this;
    /**
     * Requests FlexMatch matchmaking for one or a group of players and game session placement for a resulting match.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchmaking.html
     */
    startMatchmaking(): this;
    /**
     * Suspends auto-scaling activity on a fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html
     */
    stopFleetActions(): this;
    /**
     * Cancels a game session placement request that is in progress.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopGameSessionPlacement.html
     */
    stopGameSessionPlacement(): this;
    /**
     * Cancels a matchmaking or match backfill request that is in progress.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopMatchmaking.html
     */
    stopMatchmaking(): this;
    /**
     * Tags GameLift Resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_TagResource.html
     */
    tagResource(): this;
    /**
     * Untagging GameLift Resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UntagResource.html
     */
    untagResource(): this;
    /**
     * Updates the properties of an existing alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateAlias.html
     */
    updateAlias(): this;
    /**
     * Updates an existing build's metadata.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateBuild.html
     */
    updateBuild(): this;
    /**
     * Updates the general properties of an existing fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetAttributes.html
     */
    updateFleetAttributes(): this;
    /**
     * Adjusts a fleet's capacity settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html
     */
    updateFleetCapacity(): this;
    /**
     * Adjusts a fleet's port settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetPortSettings.html
     */
    updateFleetPortSettings(): this;
    /**
     * Updates the properties of an existing game session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSession.html
     */
    updateGameSession(): this;
    /**
     * Updates properties of an existing game session queue.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html
     */
    updateGameSessionQueue(): this;
    /**
     * Updates properties of an existing FlexMatch matchmaking configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateMatchmakingConfiguration.html
     */
    updateMatchmakingConfiguration(): this;
    /**
     * Updates how server processes are configured on instances in an existing fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateRuntimeConfiguration.html
     */
    updateRuntimeConfiguration(): this;
    /**
     * Updates the metadata and content of an existing Realtime Servers script.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateScript.html
     */
    updateScript(): this;
    /**
     * Validates the syntax of a FlexMatch matchmaking rule set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ValidateMatchmakingRuleSet.html
     */
    validateMatchmakingRuleSet(): this;
    /**
     * Adds a resource of type alias to the statement
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/resources-defined.html
     *
     * @param aliasId - Identifier for the aliasId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onAlias(aliasId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type build to the statement
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/resources-defined.html
     *
     * @param buildId - Identifier for the buildId.
     * @param accountId - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onBuild(buildId: string, accountId?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type script to the statement
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/resources-defined.html
     *
     * @param scriptId - Identifier for the scriptId.
     * @param accountId - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onScript(scriptId: string, accountId?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type fleet to the statement
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/resources-defined.html
     *
     * @param fleetId - Identifier for the fleetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onFleet(fleetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type gameSessionQueue to the statement
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/resources-defined.html
     *
     * @param gameSessionQueueName - Identifier for the gameSessionQueueName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onGameSessionQueue(gameSessionQueueName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type matchmakingConfiguration to the statement
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/resources-defined.html
     *
     * @param matchmakingConfigurationName - Identifier for the matchmakingConfigurationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onMatchmakingConfiguration(matchmakingConfigurationName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type matchmakingRuleSet to the statement
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/resources-defined.html
     *
     * @param matchmakingRuleSetName - Identifier for the matchmakingRuleSetName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onMatchmakingRuleSet(matchmakingRuleSetName: string, account?: string, region?: string, partition?: string): this;
}
