"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service inspector
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoninspector.html
 */
class Inspector extends shared_1.PolicyStatement {
    /**
     * Action provider for service inspector
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoninspector.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'inspector';
        this.actions = {
            "AddAttributesToFindings": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_AddAttributesToFindings.html",
                "description": "Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.",
                "accessLevel": "Write"
            },
            "CreateAssessmentTarget": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTarget.html",
                "description": "Creates a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup.",
                "accessLevel": "Write"
            },
            "CreateAssessmentTemplate": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTemplate.html",
                "description": "Creates an assessment template for the assessment target that is specified by the ARN of the assessment target.",
                "accessLevel": "Write"
            },
            "CreateResourceGroup": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateResourceGroup.html",
                "description": "Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.",
                "accessLevel": "Write"
            },
            "DeleteAssessmentRun": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentRun.html",
                "description": "Deletes the assessment run that is specified by the ARN of the assessment run.",
                "accessLevel": "Write"
            },
            "DeleteAssessmentTarget": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTarget.html",
                "description": "Deletes the assessment target that is specified by the ARN of the assessment target.",
                "accessLevel": "Write"
            },
            "DeleteAssessmentTemplate": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTemplate.html",
                "description": "Deletes the assessment template that is specified by the ARN of the assessment template.",
                "accessLevel": "Write"
            },
            "DescribeAssessmentRuns": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentRuns.html",
                "description": "Describes the assessment runs that are specified by the ARNs of the assessment runs.",
                "accessLevel": "Read"
            },
            "DescribeAssessmentTargets": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTargets.html",
                "description": "Describes the assessment targets that are specified by the ARNs of the assessment targets.",
                "accessLevel": "Read"
            },
            "DescribeAssessmentTemplates": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTemplates.html",
                "description": "Describes the assessment templates that are specified by the ARNs of the assessment templates.",
                "accessLevel": "Read"
            },
            "DescribeCrossAccountAccessRole": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeCrossAccountAccessRole.html",
                "description": "Describes the IAM role that enables Amazon Inspector to access your AWS account.",
                "accessLevel": "Read"
            },
            "DescribeFindings": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeFindings.html",
                "description": "Describes the findings that are specified by the ARNs of the findings.",
                "accessLevel": "Read"
            },
            "DescribeResourceGroups": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeResourceGroups.html",
                "description": "Describes the resource groups that are specified by the ARNs of the resource groups.",
                "accessLevel": "Read"
            },
            "DescribeRulesPackages": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeRulesPackages.html",
                "description": "Describes the rules packages that are specified by the ARNs of the rules packages.",
                "accessLevel": "Read"
            },
            "GetTelemetryMetadata": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetTelemetryMetadata.html",
                "description": "Information about the data that is collected for the specified assessment run.",
                "accessLevel": "Read"
            },
            "ListAssessmentRunAgents": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRunAgents.html",
                "description": "Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.",
                "accessLevel": "List"
            },
            "ListAssessmentRuns": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRuns.html",
                "description": "Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates.",
                "accessLevel": "List"
            },
            "ListAssessmentTargets": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTargets.html",
                "description": "Lists the ARNs of the assessment targets within this AWS account.",
                "accessLevel": "List"
            },
            "ListAssessmentTemplates": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTemplates.html",
                "description": "Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.",
                "accessLevel": "List"
            },
            "ListEventSubscriptions": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListEventSubscriptions.html",
                "description": "Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template.",
                "accessLevel": "List"
            },
            "ListFindings": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListFindings.html",
                "description": "Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.",
                "accessLevel": "List"
            },
            "ListRulesPackages": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListRulesPackages.html",
                "description": "Lists all available Amazon Inspector rules packages.",
                "accessLevel": "List"
            },
            "ListTagsForResource": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListTagsForResource.html",
                "description": "Lists all tags associated with an assessment template.",
                "accessLevel": "List"
            },
            "PreviewAgents": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_PreviewAgents.html",
                "description": "Previews the agents installed on the EC2 instances that are part of the specified assessment target.",
                "accessLevel": "Read"
            },
            "RegisterCrossAccountAccessRole": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_RegisterCrossAccountAccessRole.html",
                "description": "Registers the IAM role that Amazon Inspector uses to list your EC2 instances at the start of the assessment run or when you call the PreviewAgents action.",
                "accessLevel": "Write"
            },
            "RemoveAttributesFromFindings": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_RemoveAttributesFromFindings.html",
                "description": "Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.",
                "accessLevel": "Write"
            },
            "SetTagsForResource": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_SetTagsForResource.html",
                "description": "Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.",
                "accessLevel": "Tagging"
            },
            "StartAssessmentRun": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_StartAssessmentRun.html",
                "description": "Starts the assessment run specified by the ARN of the assessment template.",
                "accessLevel": "Write"
            },
            "StopAssessmentRun": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_StopAssessmentRun.html",
                "description": "Stops the assessment run that is specified by the ARN of the assessment run.",
                "accessLevel": "Write"
            },
            "SubscribeToEvent": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_SubscribeToEvent.html",
                "description": "Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.",
                "accessLevel": "Write"
            },
            "UnsubscribeFromEvent": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_UnsubscribeFromEvent.html",
                "description": "Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.",
                "accessLevel": "Write"
            },
            "UpdateAssessmentTarget": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_UpdateAssessmentTarget.html",
                "description": "Updates the assessment target that is specified by the ARN of the assessment target.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_AddAttributesToFindings.html
     */
    addAttributesToFindings() {
        this.add('inspector:AddAttributesToFindings');
        return this;
    }
    /**
     * Creates a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTarget.html
     */
    createAssessmentTarget() {
        this.add('inspector:CreateAssessmentTarget');
        return this;
    }
    /**
     * Creates an assessment template for the assessment target that is specified by the ARN of the assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTemplate.html
     */
    createAssessmentTemplate() {
        this.add('inspector:CreateAssessmentTemplate');
        return this;
    }
    /**
     * Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateResourceGroup.html
     */
    createResourceGroup() {
        this.add('inspector:CreateResourceGroup');
        return this;
    }
    /**
     * Deletes the assessment run that is specified by the ARN of the assessment run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentRun.html
     */
    deleteAssessmentRun() {
        this.add('inspector:DeleteAssessmentRun');
        return this;
    }
    /**
     * Deletes the assessment target that is specified by the ARN of the assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTarget.html
     */
    deleteAssessmentTarget() {
        this.add('inspector:DeleteAssessmentTarget');
        return this;
    }
    /**
     * Deletes the assessment template that is specified by the ARN of the assessment template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTemplate.html
     */
    deleteAssessmentTemplate() {
        this.add('inspector:DeleteAssessmentTemplate');
        return this;
    }
    /**
     * Describes the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentRuns.html
     */
    describeAssessmentRuns() {
        this.add('inspector:DescribeAssessmentRuns');
        return this;
    }
    /**
     * Describes the assessment targets that are specified by the ARNs of the assessment targets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTargets.html
     */
    describeAssessmentTargets() {
        this.add('inspector:DescribeAssessmentTargets');
        return this;
    }
    /**
     * Describes the assessment templates that are specified by the ARNs of the assessment templates.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTemplates.html
     */
    describeAssessmentTemplates() {
        this.add('inspector:DescribeAssessmentTemplates');
        return this;
    }
    /**
     * Describes the IAM role that enables Amazon Inspector to access your AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeCrossAccountAccessRole.html
     */
    describeCrossAccountAccessRole() {
        this.add('inspector:DescribeCrossAccountAccessRole');
        return this;
    }
    /**
     * Describes the findings that are specified by the ARNs of the findings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeFindings.html
     */
    describeFindings() {
        this.add('inspector:DescribeFindings');
        return this;
    }
    /**
     * Describes the resource groups that are specified by the ARNs of the resource groups.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeResourceGroups.html
     */
    describeResourceGroups() {
        this.add('inspector:DescribeResourceGroups');
        return this;
    }
    /**
     * Describes the rules packages that are specified by the ARNs of the rules packages.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeRulesPackages.html
     */
    describeRulesPackages() {
        this.add('inspector:DescribeRulesPackages');
        return this;
    }
    /**
     * Information about the data that is collected for the specified assessment run.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetTelemetryMetadata.html
     */
    getTelemetryMetadata() {
        this.add('inspector:GetTelemetryMetadata');
        return this;
    }
    /**
     * Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRunAgents.html
     */
    listAssessmentRunAgents() {
        this.add('inspector:ListAssessmentRunAgents');
        return this;
    }
    /**
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRuns.html
     */
    listAssessmentRuns() {
        this.add('inspector:ListAssessmentRuns');
        return this;
    }
    /**
     * Lists the ARNs of the assessment targets within this AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTargets.html
     */
    listAssessmentTargets() {
        this.add('inspector:ListAssessmentTargets');
        return this;
    }
    /**
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTemplates.html
     */
    listAssessmentTemplates() {
        this.add('inspector:ListAssessmentTemplates');
        return this;
    }
    /**
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListEventSubscriptions.html
     */
    listEventSubscriptions() {
        this.add('inspector:ListEventSubscriptions');
        return this;
    }
    /**
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListFindings.html
     */
    listFindings() {
        this.add('inspector:ListFindings');
        return this;
    }
    /**
     * Lists all available Amazon Inspector rules packages.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListRulesPackages.html
     */
    listRulesPackages() {
        this.add('inspector:ListRulesPackages');
        return this;
    }
    /**
     * Lists all tags associated with an assessment template.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListTagsForResource.html
     */
    listTagsForResource() {
        this.add('inspector:ListTagsForResource');
        return this;
    }
    /**
     * Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_PreviewAgents.html
     */
    previewAgents() {
        this.add('inspector:PreviewAgents');
        return this;
    }
    /**
     * Registers the IAM role that Amazon Inspector uses to list your EC2 instances at the start of the assessment run or when you call the PreviewAgents action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RegisterCrossAccountAccessRole.html
     */
    registerCrossAccountAccessRole() {
        this.add('inspector:RegisterCrossAccountAccessRole');
        return this;
    }
    /**
     * Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RemoveAttributesFromFindings.html
     */
    removeAttributesFromFindings() {
        this.add('inspector:RemoveAttributesFromFindings');
        return this;
    }
    /**
     * Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SetTagsForResource.html
     */
    setTagsForResource() {
        this.add('inspector:SetTagsForResource');
        return this;
    }
    /**
     * Starts the assessment run specified by the ARN of the assessment template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StartAssessmentRun.html
     */
    startAssessmentRun() {
        this.add('inspector:StartAssessmentRun');
        return this;
    }
    /**
     * Stops the assessment run that is specified by the ARN of the assessment run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StopAssessmentRun.html
     */
    stopAssessmentRun() {
        this.add('inspector:StopAssessmentRun');
        return this;
    }
    /**
     * Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SubscribeToEvent.html
     */
    subscribeToEvent() {
        this.add('inspector:SubscribeToEvent');
        return this;
    }
    /**
     * Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UnsubscribeFromEvent.html
     */
    unsubscribeFromEvent() {
        this.add('inspector:UnsubscribeFromEvent');
        return this;
    }
    /**
     * Updates the assessment target that is specified by the ARN of the assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UpdateAssessmentTarget.html
     */
    updateAssessmentTarget() {
        this.add('inspector:UpdateAssessmentTarget');
        return this;
    }
}
exports.Inspector = Inspector;
//# sourceMappingURL=data:application/json;base64,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