"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service sms-voice
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonpinpointsmsandvoiceservice.html
 */
class SmsVoice extends shared_1.PolicyStatement {
    /**
     * Action provider for service sms-voice
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonpinpointsmsandvoiceservice.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'sms-voice';
        this.actions = {
            "CreateConfigurationSet": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets.html",
                "description": "Create a new configuration set. After you create the configuration set, you can add one or more event destinations to it.",
                "accessLevel": "Write"
            },
            "CreateConfigurationSetEventDestination": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations.html",
                "description": "Create a new event destination in a configuration set.",
                "accessLevel": "Write"
            },
            "DeleteConfigurationSet": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname.html",
                "description": "Deletes an existing configuration set.",
                "accessLevel": "Write"
            },
            "DeleteConfigurationSetEventDestination": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations-eventdestinationname.html",
                "description": "Deletes an event destination in a configuration set.",
                "accessLevel": "Write"
            },
            "GetConfigurationSetEventDestinations": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations.html",
                "description": "Obtain information about an event destination, including the types of events it reports, the Amazon Resource Name (ARN) of the destination, and the name of the event destination.",
                "accessLevel": "Read"
            },
            "ListConfigurationSets": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets.html",
                "description": "Return a list of configuration sets. This operation only returns the configuration sets that are associated with your account in the current AWS Region.",
                "accessLevel": "Read"
            },
            "SendVoiceMessage": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-voice-message.html",
                "description": "Create a new voice message and send it to a recipient's phone number.",
                "accessLevel": "Write"
            },
            "UpdateConfigurationSetEventDestination": {
                "url": "https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations-eventdestinationname.html",
                "description": "Update an event destination in a configuration set. An event destination is a location that you publish information about your voice calls to. For example, you can log an event to an Amazon CloudWatch destination when a call fails.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Create a new configuration set. After you create the configuration set, you can add one or more event destinations to it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets.html
     */
    createConfigurationSet() {
        this.add('sms-voice:CreateConfigurationSet');
        return this;
    }
    /**
     * Create a new event destination in a configuration set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations.html
     */
    createConfigurationSetEventDestination() {
        this.add('sms-voice:CreateConfigurationSetEventDestination');
        return this;
    }
    /**
     * Deletes an existing configuration set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname.html
     */
    deleteConfigurationSet() {
        this.add('sms-voice:DeleteConfigurationSet');
        return this;
    }
    /**
     * Deletes an event destination in a configuration set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations-eventdestinationname.html
     */
    deleteConfigurationSetEventDestination() {
        this.add('sms-voice:DeleteConfigurationSetEventDestination');
        return this;
    }
    /**
     * Obtain information about an event destination, including the types of events it reports, the Amazon Resource Name (ARN) of the destination, and the name of the event destination.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations.html
     */
    getConfigurationSetEventDestinations() {
        this.add('sms-voice:GetConfigurationSetEventDestinations');
        return this;
    }
    /**
     * Return a list of configuration sets. This operation only returns the configuration sets that are associated with your account in the current AWS Region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets.html
     */
    listConfigurationSets() {
        this.add('sms-voice:ListConfigurationSets');
        return this;
    }
    /**
     * Create a new voice message and send it to a recipient's phone number.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-voice-message.html
     */
    sendVoiceMessage() {
        this.add('sms-voice:SendVoiceMessage');
        return this;
    }
    /**
     * Update an event destination in a configuration set. An event destination is a location that you publish information about your voice calls to. For example, you can log an event to an Amazon CloudWatch destination when a call fails.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-sms-voice/latest/apireference/v1-sms-voice-configuration-sets-configurationsetname-event-destinations-eventdestinationname.html
     */
    updateConfigurationSetEventDestination() {
        this.add('sms-voice:UpdateConfigurationSetEventDestination');
        return this;
    }
}
exports.SmsVoice = SmsVoice;
//# sourceMappingURL=data:application/json;base64,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