import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service transcribe
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranscribe.html
 */
export declare class Transcribe extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service transcribe
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranscribe.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Creates a new custom vocabulary that you can use to change the way Amazon Transcribe Medical handles transcription of an audio file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateMedicalVocabulary.html
     */
    createMedicalVocabulary(): this;
    /**
     * Creates a new custom vocabulary that you can use to change the way Amazon Transcribe handles transcription of an audio file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabulary.html
     */
    createVocabulary(): this;
    /**
     * Creates a new vocabulary filter that you can use to filter out words from the transcription of an audio file generated by Amazon Transcribe
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabularyFilter.html
     */
    createVocabularyFilter(): this;
    /**
     * Deletes a previously submitted medical transcription job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalTranscriptionJob.html
     */
    deleteMedicalTranscriptionJob(): this;
    /**
     * Deletes medical a vocabulary from Amazon Transcribe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalVocabulary.html
     */
    deleteMedicalVocabulary(): this;
    /**
     * Deletes a previously submitted transcription job along with any other generated results such as the transcription, models, and so on.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteTranscriptionJob.html
     */
    deleteTranscriptionJob(): this;
    /**
     * Deletes a vocabulary from Amazon Transcribe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabulary.html
     */
    deleteVocabulary(): this;
    /**
     * Deletes a vocabulary filter from Amazon Transcribe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabularyFilter.html
     */
    deleteVocabularyFilter(): this;
    /**
     * Returns information about a medical transcription job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalTranscriptionJob.html
     */
    getMedicalTranscriptionJob(): this;
    /**
     * Gets information about a medical vocabulary.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalVocabulary.html
     */
    getMedicalVocabulary(): this;
    /**
     * Returns information about a transcription job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetTranscriptionJob.html
     */
    getTranscriptionJob(): this;
    /**
     * Gets information about a vocabulary.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabulary.html
     */
    getVocabulary(): this;
    /**
     * Gets information about a vocabulary filter.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabularyFilter.html
     */
    getVocabularyFilter(): this;
    /**
     * Lists medical transcription jobs with the specified status.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalTranscriptionJobs.html
     */
    listMedicalTranscriptionJobs(): this;
    /**
     * Returns a list of medical vocabularies that match the specified criteria. If no criteria are specified, returns the entire list of vocabularies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalVocabularies.html
     */
    listMedicalVocabularies(): this;
    /**
     * Lists transcription jobs with the specified status.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListTranscriptionJobs.html
     */
    listTranscriptionJobs(): this;
    /**
     * Returns a list of vocabularies that match the specified criteria. If no criteria are specified, returns the entire list of vocabularies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularies.html
     */
    listVocabularies(): this;
    /**
     * Returns a list of vocabulary filters that match the specified criteria. If no criteria are specified, returns the at most 5 vocabulary filters.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularyFilters.html
     */
    listVocabularyFilters(): this;
    /**
     * Starts a protocol where audio is streamed to Transcribe Medical and the transcription results are streamed to your application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscription.html
     */
    startMedicalStreamTranscription(): this;
    /**
     * Starts a WebSocket where audio is streamed to Transcribe Medical and the transcription results are streamed to your application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscriptionWebSocket.html
     */
    startMedicalStreamTranscriptionWebSocket(): this;
    /**
     * Starts an asynchronous job to transcribe medical speech to text.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_StartMedicalTranscriptionJob.html
     */
    startMedicalTranscriptionJob(): this;
    /**
     * Starts a bidirectional HTTP2 stream to transcribe speech to text in real time.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscription.html
     */
    startStreamTranscription(): this;
    /**
     * Starts a websocket stream to transcribe speech to text in real time.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscriptionWebSocket.html
     */
    startStreamTranscriptionWebSocket(): this;
    /**
     * Starts an asynchronous job to transcribe speech to text.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_StartTranscriptionJob.html
     */
    startTranscriptionJob(): this;
    /**
     * Updates an existing medical vocabulary with new values. The UpdateMedicalVocabulary operation overwrites all of the existing information with the values that you provide in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateMedicalVocabulary.html
     */
    updateMedicalVocabulary(): this;
    /**
     * Updates an existing vocabulary with new values. The UpdateVocabulary operation overwrites all of the existing information with the values that you provide in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabulary.html
     */
    updateVocabulary(): this;
    /**
     * Updates an existing vocabulary filter with new values. The UpdateVocabularyFilter operation overwrites all of the existing information with the values that you provide in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabularyFilter.html
     */
    updateVocabularyFilter(): this;
}
