import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service application-autoscaling
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationautoscaling.html
 */
export declare class ApplicationAutoscaling extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service application-autoscaling
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationautoscaling.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Deletes an Application Auto Scaling scaling policy that was previously created.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeleteScalingPolicy.html
     */
    deleteScalingPolicy(): this;
    /**
     * Deletes an Application Auto Scaling scheduled action that was previously created.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeleteScheduledAction.html
     */
    deleteScheduledAction(): this;
    /**
     * Deregisters a scalable target that was previously registered.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeregisterScalableTarget.html
     */
    deregisterScalableTarget(): this;
    /**
     * Provides descriptive information for scalable targets with a specified service namespace.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html
     */
    describeScalableTargets(): this;
    /**
     * Provides descriptive information for scaling activities with a specified service namespace for the previous six weeks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalingActivities.html
     */
    describeScalingActivities(): this;
    /**
     * Provides descriptive information for scaling policies with a specified service namespace.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalingPolicies.html
     */
    describeScalingPolicies(): this;
    /**
     * Provides descriptive information for scheduled actions with a specified service namespace.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScheduledActions.html
     */
    describeScheduledActions(): this;
    /**
     * Creates or updates a policy for an existing Application Auto Scaling scalable target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScalingPolicy.html
     */
    putScalingPolicy(): this;
    /**
     * Creates or updates a scheduled action for an existing Application Auto Scaling scalable target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html
     */
    putScheduledAction(): this;
    /**
     * Registers or updates a scalable target. A scalable target is a resource that can be scaled out or in with Application Auto Scaling.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html
     */
    registerScalableTarget(): this;
}
