import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service account
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsaccounts.html
 */
export declare class Account extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service account
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsaccounts.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Grants permission to disable a region
     *
     * Access Level: Write
     */
    disableRegion(): this;
    /**
     * Grants permission to enable a region
     *
     * Access Level: Write
     */
    enableRegion(): this;
    /**
     * Grants permission to list regions
     *
     * Access Level: List
     */
    listRegions(): this;
    /**
     * Filters access by a list of regions
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTargetRegion(value: string | string[], operator?: string): this;
}
