import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service awsconnector
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsconnectorservice.html
 */
export declare class Awsconnector extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service awsconnector
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsconnectorservice.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Retrieves all health metrics that were published from the Server Migration Connector.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     */
    getConnectorHealth(): this;
    /**
     * Registers AWS Connector with AWS Connector Service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     */
    registerConnector(): this;
    /**
     * Validates Server Migration Connector Id that was registered with AWS Connector Service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     */
    validateConnectorId(): this;
}
