"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service awsconnector
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsconnectorservice.html
 */
class Awsconnector extends shared_1.PolicyStatement {
    /**
     * Action provider for service awsconnector
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsconnectorservice.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'awsconnector';
        this.actions = {
            "GetConnectorHealth": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions",
                "description": "Retrieves all health metrics that were published from the Server Migration Connector.",
                "accessLevel": "Read"
            },
            "RegisterConnector": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions",
                "description": "Registers AWS Connector with AWS Connector Service.",
                "accessLevel": "Write"
            },
            "ValidateConnectorId": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions",
                "description": "Validates Server Migration Connector Id that was registered with AWS Connector Service.",
                "accessLevel": "Read"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Retrieves all health metrics that were published from the Server Migration Connector.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     */
    getConnectorHealth() {
        this.add('awsconnector:GetConnectorHealth');
        return this;
    }
    /**
     * Registers AWS Connector with AWS Connector Service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     */
    registerConnector() {
        this.add('awsconnector:RegisterConnector');
        return this;
    }
    /**
     * Validates Server Migration Connector Id that was registered with AWS Connector Service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     */
    validateConnectorId() {
        this.add('awsconnector:ValidateConnectorId');
        return this;
    }
}
exports.Awsconnector = Awsconnector;
//# sourceMappingURL=data:application/json;base64,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