import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service ce
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awscostexplorerservice.html
 */
export declare class Ce extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service ce
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awscostexplorerservice.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Grants permission to create a new Cost Category with the requested name and rules.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CreateCostCategoryDefinition.html
     */
    createCostCategoryDefinition(): this;
    /**
     * Grants permission to delete a Cost Category.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DeleteCostCategoryDefinition.html
     */
    deleteCostCategoryDefinition(): this;
    /**
     * Grants permission to retrieve descriptions such as the name, ARN, rules, definition, and effective dates of a Cost Category.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DescribeCostCategoryDefinition.html
     */
    describeCostCategoryDefinition(): this;
    /**
     * Grants permission to retrieve the cost and usage metrics for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetCostAndUsage.html
     */
    getCostAndUsage(): this;
    /**
     * Grants permission to retrieve the cost and usage metrics with resources for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetCostAndUsageWithResources.html
     */
    getCostAndUsageWithResources(): this;
    /**
     * Grants permission to retrieve a cost forecast for a forecast time period.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetCostForecast.html
     */
    getCostForecast(): this;
    /**
     * Grants permission to retrieve all available filter values for a filter for a period of time.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html
     */
    getDimensionValues(): this;
    /**
     * Grants permission to retrieve the reservation coverage for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetReservationCoverage.html
     */
    getReservationCoverage(): this;
    /**
     * Grants permission to retrieve the reservation recommendations for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetReservationPurchaseRecommendation.html
     */
    getReservationPurchaseRecommendation(): this;
    /**
     * Grants permission to retrieve the reservation utilization for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetReservationUtilization.html
     */
    getReservationUtilization(): this;
    /**
     * Grants permission to retrieve the rightsizing recommendations for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetRightsizingRecommendation.html
     */
    getRightsizingRecommendation(): this;
    /**
     * Grants permission to retrieve the Savings Plans coverage for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetSavingsPlansCoverage.html
     */
    getSavingsPlansCoverage(): this;
    /**
     * Grants permission to retrieve the Savings Plans recommendations for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetSavingsPlansPurchaseRecommendation.html
     */
    getSavingsPlansPurchaseRecommendation(): this;
    /**
     * Grants permission to retrieve the Savings Plans utilization for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetSavingsPlansUtilization.html
     */
    getSavingsPlansUtilization(): this;
    /**
     * Grants permission to retrieve the Savings Plans utilization details for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetSavingsPlansUtilizationDetails.html
     */
    getSavingsPlansUtilizationDetails(): this;
    /**
     * Grants permission to query tags for a specified time period.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetTags.html
     */
    getTags(): this;
    /**
     * Grants permission to retrieve a usage forecast for a forecast time period.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetUsageForecast.html
     */
    getUsageForecast(): this;
    /**
     * Grants permission to retrieve names, ARN, and effective dates for all Cost Categories.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_ListCostCategoryDefinitions.html
     */
    listCostCategoryDefinitions(): this;
    /**
     * Grants permission to update an existing Cost Category.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_UpdateCostCategoryDefinition.html
     */
    updateCostCategoryDefinition(): this;
}
