import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service deeplens
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsdeeplens.html
 */
export declare class Deeplens extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service deeplens
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsdeeplens.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Associates the user's account with IAM roles controlling various permissions needed by AWS DeepLens for proper functionality.
     *
     * Access Level: Permissions management
     */
    associateServiceRoleToAccount(): this;
    /**
     * Retrieves a list of AWS DeepLens devices.
     *
     * Access Level: Read
     */
    batchGetDevice(): this;
    /**
     * Retrieves a list of AWS DeepLens Models.
     *
     * Access Level: Read
     */
    batchGetModel(): this;
    /**
     * Retrieves a list of AWS DeepLens Projects.
     *
     * Access Level: Read
     */
    batchGetProject(): this;
    /**
     * Creates a certificate package that is used to successfully authenticate and Register an AWS DeepLens device.
     *
     * Access Level: Write
     */
    createDeviceCertificates(): this;
    /**
     * Creates a new AWS DeepLens Model.
     *
     * Access Level: Write
     */
    createModel(): this;
    /**
     * Creates a new AWS DeepLens Project.
     *
     * Access Level: Write
     */
    createProject(): this;
    /**
     * Deletes an AWS DeepLens Model.
     *
     * Access Level: Write
     */
    deleteModel(): this;
    /**
     * Deletes an AWS DeepLens Project.
     *
     * Access Level: Write
     */
    deleteProject(): this;
    /**
     * Deploys an AWS DeepLens project to a registered AWS DeepLens device.
     *
     * Access Level: Write
     */
    deployProject(): this;
    /**
     * Begins a device de-registration workflow for a registered AWS DeepLens device.
     *
     * Access Level: Write
     */
    deregisterDevice(): this;
    /**
     * Retrieves the account level resources associated with the user's account.
     *
     * Access Level: Read
     */
    getAssociatedResources(): this;
    /**
     * Retrieves the the deployment status of a particular AWS DeepLens device, along with any associated metadata.
     *
     * Access Level: Read
     */
    getDeploymentStatus(): this;
    /**
     * Retrieves information about an AWS DeepLens device.
     *
     * Access Level: Read
     */
    getDevice(): this;
    /**
     * Retrieves an AWS DeepLens Model.
     *
     * Access Level: Read
     */
    getModel(): this;
    /**
     * Retrieves an AWS DeepLens Project.
     *
     * Access Level: Read
     */
    getProject(): this;
    /**
     * Creates a new AWS DeepLens project from a sample project template.
     *
     * Access Level: Write
     */
    importProjectFromTemplate(): this;
    /**
     * Retrieves a list of AWS DeepLens Deployment identifiers.
     *
     * Access Level: List
     */
    listDeployments(): this;
    /**
     * Retrieves a list of AWS DeepLens device identifiers.
     *
     * Access Level: List
     */
    listDevices(): this;
    /**
     * Retrieves a list of AWS DeepLens Model identifiers.
     *
     * Access Level: List
     */
    listModels(): this;
    /**
     * Retrieves a list of AWS DeepLens Project identifiers.
     *
     * Access Level: List
     */
    listProjects(): this;
    /**
     * Begins a device registration workflow for an AWS DeepLens device.
     *
     * Access Level: Write
     */
    registerDevice(): this;
    /**
     * Removes a deployed AWS DeepLens project from an AWS DeepLens device.
     *
     * Access Level: Write
     */
    removeProject(): this;
    /**
     * Updates an existing AWS DeepLens Project.
     *
     * Access Level: Write
     */
    updateProject(): this;
    /**
     * Adds a resource of type device to the statement
     *
     * @param deviceName - Identifier for the deviceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onDevice(deviceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type project to the statement
     *
     * @param projectName - Identifier for the projectName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onProject(projectName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type model to the statement
     *
     * @param modelName - Identifier for the modelName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onModel(modelName: string, account?: string, region?: string, partition?: string): this;
}
