import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service importexport
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsimportexportdiskservice.html
 */
export declare class Importexport extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service importexport
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsimportexportdiskservice.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * This action cancels a specified job. Only the job owner can cancel it. The action fails if the job has already started or is complete.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCancelJob.html
     */
    cancelJob(): this;
    /**
     * This action initiates the process of scheduling an upload or download of your data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCreateJob.html
     */
    createJob(): this;
    /**
     * This action generates a pre-paid shipping label that you will use to ship your device to AWS for processing.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetShippingLabel.html
     */
    getShippingLabel(): this;
    /**
     * This action returns information about a job, including where the job is in the processing pipeline, the status of the results, and the signature value associated with the job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetStatus.html
     */
    getStatus(): this;
    /**
     * This action returns the jobs associated with the requester.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebListJobs.html
     */
    listJobs(): this;
    /**
     * You use this action to change the parameters specified in the original manifest file by supplying a new manifest file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebUpdateJob.html
     */
    updateJob(): this;
}
