"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service aws-marketplace-entitlement-service
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplaceentitlementservice.html
 */
class AwsMarketplaceEntitlementService extends shared_1.PolicyStatement {
    /**
     * Action provider for service aws-marketplace-entitlement-service
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplaceentitlementservice.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-marketplace-entitlement-service';
        this.actions = {
            "GetEntitlements": {
                "url": "",
                "description": "Retrieves entitlement values for a given product. The results can be filtered based on customer identifier or product dimensions",
                "accessLevel": "Read"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Retrieves entitlement values for a given product. The results can be filtered based on customer identifier or product dimensions
     *
     * Access Level: Read
     */
    getEntitlements() {
        this.add('aws-marketplace-entitlement-service:GetEntitlements');
        return this;
    }
}
exports.AwsMarketplaceEntitlementService = AwsMarketplaceEntitlementService;
//# sourceMappingURL=data:application/json;base64,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