"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service aws-marketplace-management
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplacemanagementportal.html
 */
class AwsMarketplaceManagement extends shared_1.PolicyStatement {
    /**
     * Action provider for service aws-marketplace-management
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplacemanagementportal.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-marketplace-management';
        this.actions = {
            "uploadFiles": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions",
                "description": "Allows a user to access the File Upload page inside the AWS Marketplace Management Portal.",
                "accessLevel": "Write"
            },
            "viewMarketing": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions",
                "description": "Allows a user to access the Marketing page inside the AWS Marketplace Management Portal.",
                "accessLevel": "List"
            },
            "viewReports": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions",
                "description": "Allows a user to access the Reports page inside the AWS Marketplace Management Portal.",
                "accessLevel": "List"
            },
            "viewSettings": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions",
                "description": "Allows a user to access the Settings page inside the AWS Marketplace Management Portal.",
                "accessLevel": "List"
            },
            "viewSupport": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions",
                "description": "Allows a user to access the Customer Support Eligibility page inside the AWS Marketplace Management Portal.",
                "accessLevel": "List"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Allows a user to access the File Upload page inside the AWS Marketplace Management Portal.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions
     */
    uploadFiles() {
        this.add('aws-marketplace-management:uploadFiles');
        return this;
    }
    /**
     * Allows a user to access the Marketing page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions
     */
    viewMarketing() {
        this.add('aws-marketplace-management:viewMarketing');
        return this;
    }
    /**
     * Allows a user to access the Reports page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions
     */
    viewReports() {
        this.add('aws-marketplace-management:viewReports');
        return this;
    }
    /**
     * Allows a user to access the Settings page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions
     */
    viewSettings() {
        this.add('aws-marketplace-management:viewSettings');
        return this;
    }
    /**
     * Allows a user to access the Customer Support Eligibility page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions
     */
    viewSupport() {
        this.add('aws-marketplace-management:viewSupport');
        return this;
    }
}
exports.AwsMarketplaceManagement = AwsMarketplaceManagement;
//# sourceMappingURL=data:application/json;base64,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