"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service aws-marketplace-metering-service
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplacemeteringservice.html
 */
class AwsMarketplaceMeteringService extends shared_1.PolicyStatement {
    /**
     * Action provider for service aws-marketplace-metering-service
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplacemeteringservice.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-marketplace-metering-service';
        this.actions = {
            "BatchMeterUsage": {
                "url": "https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_BatchMeterUsage.html",
                "description": "Called from a SaaS application listed on the AWS Marketplace to post metering records for a set of customers.",
                "accessLevel": "Write"
            },
            "MeterUsage": {
                "url": "https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_MeterUsage.html",
                "description": "Emits metering records.",
                "accessLevel": "Write"
            },
            "RegisterUsage": {
                "url": "https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_RegisterUsage.html",
                "description": "Allows you to verify that the customer running your paid software is subscribed to your product on AWS Marketplace, enabling you to guard against unauthorized use. Meters software use per ECS task, per hour, with usage prorated to the second.",
                "accessLevel": "Write"
            },
            "ResolveCustomer": {
                "url": "https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_ResolveCustomer.html",
                "description": "Resolves a registration token to obtain a CustomerIdentifier and product code.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Called from a SaaS application listed on the AWS Marketplace to post metering records for a set of customers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_BatchMeterUsage.html
     */
    batchMeterUsage() {
        this.add('aws-marketplace-metering-service:BatchMeterUsage');
        return this;
    }
    /**
     * Emits metering records.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_MeterUsage.html
     */
    meterUsage() {
        this.add('aws-marketplace-metering-service:MeterUsage');
        return this;
    }
    /**
     * Allows you to verify that the customer running your paid software is subscribed to your product on AWS Marketplace, enabling you to guard against unauthorized use. Meters software use per ECS task, per hour, with usage prorated to the second.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_RegisterUsage.html
     */
    registerUsage() {
        this.add('aws-marketplace-metering-service:RegisterUsage');
        return this;
    }
    /**
     * Resolves a registration token to obtain a CustomerIdentifier and product code.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_ResolveCustomer.html
     */
    resolveCustomer() {
        this.add('aws-marketplace-metering-service:ResolveCustomer');
        return this;
    }
}
exports.AwsMarketplaceMeteringService = AwsMarketplaceMeteringService;
//# sourceMappingURL=data:application/json;base64,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