"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service resource-explorer
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awstageditor.html
 */
class ResourceExplorer extends shared_1.PolicyStatement {
    /**
     * Action provider for service resource-explorer
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awstageditor.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'resource-explorer';
        this.actions = {
            "ListResourceTypes": {
                "url": "https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-prereqs.html#rg-permissions-te",
                "description": "Grants permission to retrieve the resource types currently supported by Tag Editor",
                "accessLevel": "List"
            },
            "ListResources": {
                "url": "https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-prereqs.html#rg-permissions-te",
                "description": "Grants permission to retrieve the identifiers of the resources in the AWS account",
                "accessLevel": "List"
            },
            "ListTags": {
                "url": "https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-prereqs.html#rg-permissions-te",
                "description": "Grants permission to retrieve the tags attached to the specified resource identifiers",
                "accessLevel": "Read"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Grants permission to retrieve the resource types currently supported by Tag Editor
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-prereqs.html#rg-permissions-te
     */
    listResourceTypes() {
        this.add('resource-explorer:ListResourceTypes');
        return this;
    }
    /**
     * Grants permission to retrieve the identifiers of the resources in the AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-prereqs.html#rg-permissions-te
     */
    listResources() {
        this.add('resource-explorer:ListResources');
        return this;
    }
    /**
     * Grants permission to retrieve the tags attached to the specified resource identifiers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-prereqs.html#rg-permissions-te
     */
    listTags() {
        this.add('resource-explorer:ListTags');
        return this;
    }
}
exports.ResourceExplorer = ResourceExplorer;
//# sourceMappingURL=data:application/json;base64,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