import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service xray
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsx-ray.html
 */
export declare class Xray extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service xray
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsx-ray.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Retrieves a list of traces specified by ID. Each trace is a collection of segment documents that originates from a single request. Use GetTraceSummaries to get a list of trace IDs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_BatchGetTraces.html
     */
    batchGetTraces(): this;
    /**
     * Creates a group resource with a name and a filter expression.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_CreateGroup.html
     */
    createGroup(): this;
    /**
     * Creates a rule to control sampling behavior for instrumented applications.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_CreateSamplingRule.html
     */
    createSamplingRule(): this;
    /**
     * Deletes a group resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_DeleteGroup.html
     */
    deleteGroup(): this;
    /**
     * Deletes a sampling rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_DeleteSamplingRule.html
     */
    deleteSamplingRule(): this;
    /**
     * Retrieves the current encryption configuration for X-Ray data.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_GetEncryptionConfig.html
     */
    getEncryptionConfig(): this;
    /**
     * Retrieves group resource details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_GetGroup.html
     */
    getGroup(): this;
    /**
     * Retrieves all active group details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_GetGroups.html
     */
    getGroups(): this;
    /**
     * Retrieves all sampling rules.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingRules.html
     */
    getSamplingRules(): this;
    /**
     * Retrieves information about recent sampling results for all sampling rules.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingStatisticSummaries.html
     */
    getSamplingStatisticSummaries(): this;
    /**
     * Requests a sampling quota for rules that the service is using to sample requests.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html
     */
    getSamplingTargets(): this;
    /**
     * Retrieves a document that describes services that process incoming requests, and downstream services that they call as a result.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_GetServiceGraph.html
     */
    getServiceGraph(): this;
    /**
     * Get an aggregation of service statistics defined by a specific time range bucketed into time intervals.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_GetTimeSeriesServiceStatistics.html
     */
    getTimeSeriesServiceStatistics(): this;
    /**
     * Retrieves a service graph for one or more specific trace IDs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_GetTraceGraph.html
     */
    getTraceGraph(): this;
    /**
     * Retrieves IDs and metadata for traces available for a specified time frame using an optional filter. To get the full traces, pass the trace IDs to BatchGetTraces.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_GetTraceSummaries.html
     */
    getTraceSummaries(): this;
    /**
     * Updates the encryption configuration for X-Ray data.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_PutEncryptionConfig.html
     */
    putEncryptionConfig(): this;
    /**
     * Used by the AWS X-Ray daemon to send telemetry to the service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_PutTelemetryRecords.html
     */
    putTelemetryRecords(): this;
    /**
     * Uploads segment documents to AWS X-Ray. The X-Ray SDK generates segment documents and sends them to the X-Ray daemon, which uploads them in batches.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_PutTraceSegments.html
     */
    putTraceSegments(): this;
    /**
     * Updates a group resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_UpdateGroup.html
     */
    updateGroup(): this;
    /**
     * Modifies a sampling rule's configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/xray/latest/api/API_UpdateSamplingRule.html
     */
    updateSamplingRule(): this;
    /**
     * Adds a resource of type group to the statement
     *
     * https://docs.aws.amazon.com/xray/latest/devguide/xray-concepts.html#xray-concepts-groups
     *
     * @param groupName - Identifier for the groupName.
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onGroup(groupName: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type sampling-rule to the statement
     *
     * https://docs.aws.amazon.com/xray/latest/devguide/xray-concepts.html#xray-concepts-sampling
     *
     * @param samplingRuleName - Identifier for the samplingRuleName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSamplingRule(samplingRuleName: string, account?: string, region?: string, partition?: string): this;
}
