"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Access level classifications for the actions in a service
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_understand-policy-summary-access-level-summaries.html#access_policies_access-level
 */
var AccessLevel;
(function (AccessLevel) {
    /**
     * Permission to list resources within the service to determine whether an object exists.
     *
     * Actions with this level of access can list objects but cannot see the contents of a resource.
     *
     * For example, the Amazon S3 action `ListBucket` has the List access level.
     */
    AccessLevel["LIST"] = "List";
    /**
     * Permission to read but not edit the contents and attributes of resources in the service.
     *
     * For example, the Amazon S3 actions `GetObject` and `GetBucketLocation` have the Read access level.
     */
    AccessLevel["READ"] = "Read";
    /**
     * Permission to create, delete, or modify resources in the service.
     *
     * For example, the Amazon S3 actions `CreateBucket`, `DeleteBucket` and `PutObject` have the Write access level.
     *
     * Write actions might also allow modifying a resource tag. However, an action that allows only changes to tags has the Tagging access level.
     */
    AccessLevel["WRITE"] = "Write";
    /**
     * Permission to grant or modify resource permissions in the service.
     *
     * For example, most IAM and AWS Organizations actions, as well as actions like the Amazon S3 actions `PutBucketPolicy` and `DeleteBucketPolicy` have the Permissions management access level.
     */
    AccessLevel["PERMISSION_MANAGEMENT"] = "Permissions management";
    /**
     * Permission to perform actions that only change the state of resource tags.
     *
     * For example, the IAM actions `TagRole` and `UntagRole` have the Tagging access level because they allow only tagging or untagging a role. However, the `CreateRole` action allows tagging a role resource when you create that role. Because the action does not only add a tag, it has the Write access level.
     */
    AccessLevel["TAGGING"] = "Tagging";
})(AccessLevel = exports.AccessLevel || (exports.AccessLevel = {}));
//# sourceMappingURL=data:application/json;base64,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