# -*- coding: utf-8 -*-

# TransportTools, a library for massive analyses of internal voids in biomolecules and ligand transport through them
# Copyright (C) 2021  Jan Brezovsky, Aravind Selvaram Thirunavukarasu, Carlos Eduardo Sequeiros-Borja, Bartlomiej
# Surpeta, Nishita Mandal, Cedrix Jurgal Dongmo Foumthuim, Dheeraj Kumar Sarkar, Nikhil Agrawal  <janbre@amu.edu.pl>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


__version__ = '0.9.0'
__author__ = 'Jan Brezovsky, Aravind Selvaram Thirunavukarasu, Carlos Eduardo Sequeiros-Borja, Bartlomiej Surpeta, ' \
             'Nishita Mandal, Cedrix Jurgal Dongmo Foumthuim, Dheeraj Kumar Sarkar, Nikhil Agrawal'
__mail__ = 'janbre@amu.edu.pl'

import numpy as np

color_pallete = [
    [0.0, 0.0, 1.0],
    [0.0, 1.0, 0.0],
    [1.0, 0.0, 0.0],
    [0.0, 1.0, 1.0],
    [1.0, 1.0, 0.0],
    [1.0, 0.0, 1.0],
    [0.71, 0.71, 0.97],
    [0.5, 0.99, 0.42],
    [0.99, 0.5, 0.42],
    [0.21, 0.5, 0.85],
    [0.5, 0.06, 0.87],
    [0.0, 0.87, 0.5],
    [0.86, 0.01, 0.5],
    [0.58, 0.82, 0.0],
    [0.89, 0.89, 0.6],
    [1.0, 0.41, 0.84],
    [0.41, 1.0, 0.85],
    [0.87, 0.49, 0.0],
    [0.62, 0.42, 0.69],
    [0.66, 0.67, 0.35],
    [0.4, 0.71, 0.62],
    [0.32, 1.0, 0.13],
    [0.72, 0.3, 1.0],
    [1.0, 0.82, 0.28],
    [0.96, 0.21, 0.25],
    [0.24, 0.22, 1.0],
    [0.0, 0.74, 0.79],
    [0.4, 0.71, 1.0],
    [0.75, 1.0, 0.2],
    [0.79, 0.07, 0.79],
    [0.87, 0.29, 0.6],
    [0.14, 1.0, 0.73],
    [0.45, 0.42, 1.0],
    [0.86, 0.59, 0.66],
    [0.61, 0.89, 0.66],
    [0.0, 0.36, 0.99],
    [0.86, 0.77, 0.03],
    [0.23, 0.99, 0.39],
    [1.0, 0.26, 0.0],
    [0.0, 0.98, 0.27],
    [0.15, 0.79, 1.0],
    [0.53, 0.62, 0.81],
    [0.88, 0.61, 0.22],
    [0.75, 0.47, 0.47],
    [0.73, 0.89, 0.42],
    [0.34, 0.94, 0.6],
    [0.77, 0.49, 0.87],
    [0.49, 0.85, 0.22],
    [0.69, 0.0, 1.0],
    [1.0, 0.1, 0.68],
    [0.24, 0.78, 0.78],
    [0.94, 0.23, 0.99],
    [0.87, 0.7, 0.46],
    [0.01, 0.6, 1.0],
    [0.33, 0.0, 1.0],
    [1.0, 0.42, 0.17],
    [0.61, 0.89, 0.89],
    [0.99, 0.0, 0.32],
    [0.22, 0.99, 0.96],
    [0.49, 0.28, 0.83],
    [0.48, 0.77, 0.43],
    [1.0, 0.17, 0.47],
    [0.91, 1.0, 0.36],
    [0.76, 0.28, 0.78],
    [0.7, 0.79, 0.18],
    [0.57, 1.0, 0.1],
    [0.79, 0.97, 0.0],
    [0.4, 0.47, 0.79],
    [0.19, 0.81, 0.56],
    [0.88, 0.33, 0.4],
    [0.62, 0.53, 1.0],
    [1.0, 0.45, 0.62],
    [0.43, 0.8, 0.81],
    [1.0, 0.73, 0.65],
    [0.91, 0.64, 0.84],
    [1.0, 0.63, 0.06],
    [0.44, 0.19, 1.0],
    [0.94, 0.97, 0.18],
    [0.23, 0.61, 1.0],
    [0.89, 0.41, 1.0],
    [0.05, 0.18, 0.99],
    [0.33, 0.64, 0.84],
    [0.94, 0.24, 0.8],
    [0.26, 0.4, 1.0],
    [0.01, 0.93, 0.83],
    [0.13, 0.99, 0.13],
    [0.42, 0.91, 0.0],
    [0.66, 0.16, 0.88],
    [0.78, 0.13, 0.62],
    [0.37, 0.9, 1.0],
    [0.13, 0.99, 0.54],
    [0.74, 1.0, 0.59],
    [0.32, 0.84, 0.45],
    [1.0, 0.86, 0.46],
    [0.96, 0.0, 0.82],
    [0.04, 0.57, 0.82],
    [0.62, 0.4, 0.88],
    [0.86, 0.42, 0.73],
    [0.85, 0.08, 0.96],
    [0.82, 0.79, 0.31],
    [0.05, 0.86, 0.67],
    [0.37, 0.96, 0.29],
    [0.61, 0.95, 0.29],
    [0.48, 0.99, 0.69],
    [0.82, 0.48, 0.31],
    [1.0, 0.08, 0.15],
    [0.63, 0.0, 0.78],
    [0.78, 0.62, 0.07],
    [1.0, 0.65, 0.34],
    [0.55, 0.77, 1.0],
    [1.0, 0.82, 0.11],
    [0.16, 0.05, 0.99],
    [0.48, 0.88, 0.55],
    [0.63, 0.8, 0.52],
    [0.98, 0.61, 0.54],
    [0.34, 0.3, 0.9],
    [0.14, 0.68, 0.88],
    [0.27, 0.94, 0.81],
    [0.11, 0.48, 0.99],
    [0.0, 0.84, 0.97],
    [0.88, 0.0, 0.66],
    [0.71, 0.31, 0.63],
    [1.0, 0.54, 0.75],
    [0.56, 0.3, 1.0],
    [0.45, 0.57, 0.94],
    [0.13, 0.69, 0.72],
    [0.22, 0.98, 0.0],
    [1.0, 0.33, 0.51],
    [0.57, 0.11, 1.0],
    [0.78, 0.8, 0.54],
    [0.67, 0.16, 0.73],
    [0.05, 1.0, 0.42],
    [0.75, 0.46, 0.63],
    [0.6, 0.8, 0.33],
    [0.14, 0.32, 0.94],
    [0.59, 1.0, 0.55],
    [0.85, 0.85, 0.17],
    [0.28, 0.79, 0.92],
    [0.78, 0.58, 1.0],
    [0.14, 0.88, 0.88],
    [1.0, 0.36, 0.32],
    [0.89, 0.44, 0.51],
    [0.85, 0.18, 0.5],
    [0.73, 0.65, 0.21],
    [1.0, 0.3, 0.67],
    [0.61, 0.99, 0.77],
    [0.7, 0.72, 0.0],
    [0.0, 1.0, 0.63],
    [0.23, 0.94, 0.24],
    [0.81, 0.22, 0.91],
    [0.28, 0.66, 0.7],
    [0.68, 0.91, 0.08],
    [0.42, 0.59, 0.72],
    [1.0, 0.41, 0.02],
    [0.8, 0.62, 0.35],
    [0.5, 0.8, 0.68],
    [0.35, 0.83, 0.69],
    [0.36, 0.99, 0.46],
    [0.98, 0.13, 0.89],
    [1.0, 0.01, 0.56],
    [0.67, 0.6, 0.88],
    [0.99, 0.7, 0.2],
    [0.86, 0.35, 0.87],
    [0.14, 0.89, 0.44],
    [0.99, 0.53, 0.27],
    [0.87, 0.48, 0.15],
    [0.58, 0.75, 0.86],
    [0.84, 0.58, 0.52],
    [0.85, 0.99, 0.49],
    [0.62, 0.29, 0.76],
    [0.74, 0.44, 1.0],
    [0.49, 1.0, 0.22],
    [0.32, 0.52, 0.94],
    [0.92, 0.51, 0.9],
    [0.93, 0.12, 0.36],
    [0.47, 0.0, 0.99],
    [0.95, 0.29, 0.14],
    [0.91, 0.9, 0.03],
    [0.21, 0.89, 0.68],
    [0.86, 0.85, 0.43],
    [0.73, 0.14, 1.0],
    [0.54, 0.49, 0.8],
    [0.87, 0.15, 0.71],
    [0.74, 0.68, 0.47],
    [0.33, 0.13, 0.94],
    [0.77, 1.0, 0.34],
    [0.73, 0.01, 0.68],
    [0.47, 0.89, 0.91],
    [0.56, 0.65, 0.95],
    [0.01, 0.46, 0.89],
    [0.99, 0.74, 0.51],
    [0.34, 1.0, 0.72],
    [0.64, 1.0, 0.42],
    [0.02, 0.71, 0.93],
    [0.72, 0.88, 0.28],
    [0.72, 0.41, 0.78],
    [0.46, 0.88, 0.36],
    [0.97, 0.2, 0.59],
    [0.79, 0.35, 0.51],
    [0.99, 0.13, 0.03],
    [0.88, 0.7, 0.59],
    [0.52, 0.89, 0.77],
    [0.83, 0.72, 0.16],
    [0.58, 0.82, 0.14],
    [0.12, 0.94, 0.32],
    [0.86, 0.92, 0.28],
    [0.89, 0.39, 0.24],
    [0.1, 1.0, 0.91],
    [0.0, 0.99, 0.14],
    [0.25, 0.93, 0.51],
    [0.99, 0.75, 0.0],
    [0.57, 0.88, 0.43],
    [0.42, 0.91, 0.13],
    [0.32, 0.79, 0.57],
    [0.62, 0.04, 0.9],
    [0.3, 0.42, 0.86],
    [0.53, 0.19, 0.9],
    [0.11, 0.81, 0.77],
    [0.86, 0.54, 0.78],
    [0.76, 0.84, 0.0],
    [0.48, 0.4, 0.87],
    [0.89, 0.62, 0.0],
    [0.71, 0.96, 0.71],
    [0.46, 0.71, 0.89],
    [0.99, 0.04, 0.44],
    [0.44, 1.0, 0.55],
    [0.64, 0.99, 0.0],
    [0.84, 1.0, 0.11],
    [0.2, 0.61, 0.79],
    [0.11, 0.91, 1.0],
    [0.9, 0.09, 0.58],
    [0.96, 0.76, 0.39],
    [0.7, 0.77, 0.39],
    [0.99, 0.25, 0.37],
    [0.76, 0.0, 0.9],
    [0.98, 0.51, 0.09],
    [1.0, 0.29, 0.89],
    [0.12, 0.66, 0.99],
    [0.62, 0.41, 1.0],
    [0.36, 0.88, 0.87],
    [0.94, 0.65, 0.73],
    [0.38, 0.71, 0.74],
    [0.62, 0.28, 0.9],
    [0.74, 0.35, 0.89],
    [0.91, 0.6, 0.41],
    [0.84, 0.3, 1.0],
    [0.91, 0.71, 0.28],
    [0.54, 0.49, 0.93],
    [0.86, 0.29, 0.72],
    [0.01, 0.74, 0.67],
    [0.24, 0.88, 1.0],
    [0.7, 0.89, 0.56],
    [0.71, 0.57, 0.42],
    [0.23, 1.0, 0.62],
    [0.98, 0.94, 0.29],
    [0.59, 0.72, 0.43],
    [0.48, 0.76, 0.55],
    [0.88, 0.14, 0.84],
    [0.44, 0.31, 0.96],
    [0.12, 0.57, 0.91],
    [0.35, 1.0, 0.0],
    [0.63, 0.21, 0.99],
    [0.66, 0.51, 0.8],
    [0.53, 0.37, 0.77],
    [0.51, 0.99, 0.0],
    [0.88, 0.48, 0.63],
    [0.21, 0.75, 0.67],
    [0.8, 0.61, 0.89],
    [0.33, 0.99, 0.93],
    [0.98, 0.41, 0.73],
    [0.59, 0.11, 0.8],
    [0.4, 0.91, 0.77],
    [0.31, 0.53, 0.79],
    [0.28, 0.9, 0.35],
    [0.78, 0.23, 0.68],
    [0.1, 0.88, 0.56],
    [0.52, 0.89, 0.06],
    [0.9, 0.8, 0.53],
    [0.44, 0.89, 0.65],
    [0.53, 0.97, 0.85],
    [0.65, 0.91, 0.19],
    [0.64, 0.73, 0.25],
    [0.97, 0.11, 1.0],
    [0.85, 0.5, 0.42],
    [0.3, 0.68, 0.94],
    [0.75, 0.17, 0.81],
    [0.41, 0.21, 0.89],
    [0.99, 0.1, 0.26],
    [0.94, 0.72, 0.1],
    [0.97, 0.55, 0.64],
    [0.92, 0.39, 0.09],
    [0.03, 0.99, 0.74],
    [0.99, 0.19, 0.13],
    [0.76, 0.5, 0.73],
    [0.24, 0.6, 0.89],
    [0.92, 0.44, 0.36],
    [0.65, 0.8, 0.94],
    [0.0, 0.99, 0.52],
    [0.9, 0.6, 0.11],
    [0.14, 0.42, 0.9],
    [0.33, 0.75, 0.83],
    [0.51, 0.73, 0.77],
    [0.05, 0.82, 0.87],
    [0.45, 0.81, 0.99],
    [0.71, 0.69, 0.12],
    [0.11, 1.0, 0.0],
    [0.99, 0.58, 0.18],
    [0.61, 1.0, 0.65],
    [0.81, 0.37, 0.65],
    [0.9, 0.28, 0.49],
    [0.36, 0.61, 1.0],
    [0.44, 0.57, 0.82],
    [0.97, 0.0, 0.71],
    [1.0, 0.14, 0.78],
    [0.22, 0.51, 0.99],
    [0.92, 0.01, 0.92],
    [0.74, 0.99, 0.48],
    [0.1, 0.78, 0.62],
    [1.0, 0.93, 0.09],
    [0.67, 0.49, 0.91],
    [0.18, 0.78, 0.88],
    [0.92, 0.78, 0.21],
    [0.76, 0.11, 0.9],
    [0.91, 0.3, 0.3],
    [0.79, 0.56, 0.26],
    [0.18, 1.0, 0.84],
    [0.42, 0.9, 0.46],
    [0.67, 0.8, 0.08],
    [0.79, 0.91, 0.63],
    [0.92, 0.37, 0.65],
    [0.4, 0.04, 0.92],
    [0.36, 0.37, 0.99],
    [0.35, 0.26, 1.0],
    [0.4, 0.78, 0.49],
    [0.17, 0.91, 0.78],
    [0.78, 0.9, 0.09],
    [0.1, 0.96, 0.64],
    [0.99, 0.5, 0.52],
    [0.01, 0.48, 1.0],
    [0.93, 0.87, 0.35],
    [0.75, 0.7, 0.31],
    [0.97, 0.21, 0.7],
    [0.9, 0.55, 0.31],
    [0.41, 0.48, 0.9],
    [0.24, 0.34, 0.91],
    [0.24, 0.69, 0.84],
    [0.77, 0.78, 0.1],
    [0.66, 1.0, 0.14],
    [0.92, 0.8, 0.63],
    [0.58, 0.0, 1.0],
    [0.0, 0.81, 0.59],
    [1.0, 0.39, 0.42],
    [0.43, 1.0, 0.07],
    [0.54, 0.92, 0.17],
    [0.68, 0.62, 1.0],
    [0.9, 1.0, 0.0],
    [0.87, 0.19, 0.62],
    [0.57, 0.21, 0.8],
    [0.69, 0.08, 0.83],
    [0.8, 0.9, 0.5],
    [0.33, 0.92, 0.2],
    [1.0, 0.88, 0.2],
    [0.0, 0.84, 0.76],
    [0.89, 0.05, 0.76],
    [0.59, 0.89, 0.54],
    [0.87, 0.45, 0.83],
    [0.1, 0.99, 0.23],
    [0.15, 0.16, 0.99],
    [0.47, 0.1, 0.96],
    [0.85, 0.18, 1.0],
    [0.85, 0.0, 0.84],
    [1.0, 0.86, 0.01],
    [0.92, 0.93, 0.45],
    [0.89, 0.22, 0.4],
    [1.0, 0.11, 0.55],
    [0.25, 0.11, 1.0],
    [0.38, 0.79, 0.91],
    [0.8, 0.77, 0.43],
    [0.78, 0.24, 0.57],
    [0.92, 0.11, 0.48],
    [0.99, 0.65, 0.45],
    [0.94, 0.34, 0.8],
    [0.95, 0.33, 0.97],
    [0.07, 0.66, 0.8],
    [0.47, 0.97, 0.32],
    [0.99, 0.55, 0.0],
    [0.99, 0.3, 0.23],
    [0.81, 0.41, 0.93],
    [0.22, 0.72, 0.99],
    [0.53, 0.93, 0.62],
    [0.42, 0.81, 0.6],
    [0.81, 0.4, 0.43],
    [0.91, 0.25, 0.9],
    [0.53, 0.56, 1.0],
    [0.75, 0.88, 0.19],
    [0.72, 0.24, 0.87],
    [0.64, 0.9, 0.36],
    [0.84, 0.23, 0.81],
    [0.02, 0.93, 0.93],
    [0.24, 0.98, 0.72],
    [0.15, 0.99, 0.45],
    [0.59, 0.83, 0.23],
    [0.85, 1.0, 0.21],
    [0.26, 0.89, 0.9],
    [0.81, 0.57, 0.16],
    [0.55, 0.38, 0.94],
    [0.07, 0.08, 1.0],
    [0.8, 0.88, 0.35],
    [0.81, 0.02, 0.59],
    [0.85, 0.5, 0.98],
    [0.31, 0.85, 0.79],
    [0.4, 0.51, 1.0],
    [0.05, 0.28, 0.97],
    [0.27, 0.87, 0.59],
    [0.64, 0.69, 0.91],
    [0.98, 0.0, 0.22],
    [0.79, 0.01, 1.0],
    [1.0, 0.51, 0.84],
    [0.79, 0.78, 0.22],
    [0.39, 1.0, 0.19],
    [0.47, 0.51, 0.73],
    [0.54, 0.88, 0.3],
    [0.57, 0.57, 0.89],
    [0.68, 0.4, 0.62],
    [0.81, 0.69, 0.0],
    [0.0, 0.55, 0.91],
    [0.75, 0.1, 0.71],
    [0.31, 0.74, 0.65],
    [0.66, 0.93, 0.49],
    [0.69, 0.35, 0.71],
    [0.69, 1.0, 0.28],
    [0.81, 0.48, 0.55],
    [0.92, 0.41, 0.9],
    [0.34, 0.79, 1.0],
    [0.01, 0.91, 0.59],
    [0.91, 0.49, 0.24],
    [0.16, 0.39, 1.0],
    [0.84, 0.71, 0.36],
    [0.55, 0.81, 0.6],
    [0.51, 0.8, 0.91],
    [0.23, 0.98, 0.15],
    [0.71, 0.99, 0.06],
    [0.39, 0.37, 0.85],
    [0.53, 0.2, 1.0],
    [0.62, 0.71, 1.0],
    [0.37, 0.87, 0.54],
    [0.09, 0.97, 0.82],
    [0.58, 1.0, 0.21],
    [0.41, 0.87, 0.27],
    [1.0, 0.0, 0.1],
    [0.49, 0.7, 1.0],
    [0.95, 0.65, 0.63],
    [0.81, 0.36, 0.79],
    [0.72, 0.78, 0.27],
    [0.69, 0.25, 0.7],
    [0.9, 0.16, 0.93],
    [0.92, 0.5, 0.71],
    [0.39, 0.08, 1.0],
    [0.28, 0.99, 0.31],
    [0.92, 0.36, 0.55],
    [0.96, 0.63, 0.26],
    [0.84, 0.94, 0.41],
    [0.39, 0.65, 0.91],
    [0.16, 0.73, 0.79],
    [0.93, 1.0, 0.09],
    [0.1, 0.77, 0.92],
    [0.0, 0.93, 0.36],
    [0.61, 0.9, 0.77],
    [0.98, 0.81, 0.57],
    [0.18, 0.91, 0.59],
    [0.91, 0.82, 0.09],
    [0.26, 0.31, 1.0],
    [0.54, 0.81, 0.49],
    [0.23, 0.87, 0.44],
    [0.14, 0.84, 0.68],
    [0.67, 0.33, 0.83],
    [0.6, 0.91, 0.02],
    [0.66, 0.09, 0.97],
    [0.1, 0.49, 0.86],
    [1.0, 0.33, 0.07],
    [0.71, 0.82, 0.48],
    [0.08, 0.9, 0.75],
    [0.37, 0.92, 0.38],
    [0.81, 0.67, 0.52],
    [0.3, 0.91, 0.7],
    [0.82, 0.68, 0.24],
    [0.44, 0.66, 0.8],
    [0.5, 0.8, 0.34],
    [0.07, 0.37, 0.93],
    [0.23, 0.44, 0.92],
    [0.91, 0.54, 0.48],
    [0.4, 1.0, 0.64],
    [0.05, 0.64, 0.89],
    [0.07, 0.94, 0.49],
    [0.73, 0.0, 0.79],
    [0.53, 0.29, 0.91],
    [0.62, 0.43, 0.79],
    [0.62, 0.81, 0.42],
    [0.57, 0.96, 0.37],
    [0.8, 0.62, 0.44],
    [0.55, 0.81, 0.79],
    [0.33, 0.61, 0.75],
    [0.58, 0.33, 0.83],
    [0.24, 0.0, 0.97],
    [0.51, 0.96, 0.5],
    [0.9, 0.55, 0.57],
    [0.9, 0.64, 0.52],
    [0.9, 0.91, 0.12],
    [0.56, 0.0, 0.84],
    [0.74, 0.42, 0.55],
    [0.13, 0.57, 0.82],
    [0.77, 0.53, 0.38],
    [0.99, 0.17, 0.33],
    [0.66, 0.35, 0.95],
    [0.82, 0.0, 0.73],
    [0.47, 0.99, 0.78],
    [0.46, 0.72, 0.69],
    [0.04, 0.76, 1.0],
    [0.36, 0.94, 0.06],
    [0.99, 0.57, 0.35],
    [1.0, 0.35, 0.6],
    [0.66, 0.22, 0.8],
    [0.3, 0.22, 0.93],
    [0.93, 0.03, 0.37],
    [1.0, 0.46, 0.33],
    [0.71, 0.53, 0.99],
    [0.73, 0.62, 0.3],
    [0.0, 0.67, 0.74],
    [0.9, 0.8, 0.3],
    [0.83, 0.08, 0.68],
    [0.7, 0.44, 0.7],
    [0.56, 0.85, 0.95],
    [0.84, 0.4, 0.57],
    [0.92, 0.37, 0.46],
    [0.91, 0.87, 0.22],
    [0.57, 0.94, 0.71],
    [0.14, 0.25, 1.0],
    [0.84, 0.54, 0.07],
    [0.91, 0.0, 0.58],
    [0.4, 0.83, 0.4],
    [0.26, 1.0, 0.88],
    [0.86, 0.67, 0.08],
    [0.16, 0.57, 0.99],
    [0.33, 0.45, 0.99],
    [0.65, 0.96, 0.59],
    [0.08, 0.74, 0.84],
    [0.94, 0.88, 0.52],
    [0.43, 0.83, 0.72],
    [0.26, 0.83, 0.51],
    [0.71, 0.92, 0.0],
    [0.78, 0.23, 0.99],
    [0.93, 0.68, 0.39],
    [0.78, 0.36, 0.99],
    [0.32, 0.77, 0.75],
    [0.33, 1.0, 0.82],
    [0.99, 0.73, 0.29],
    [0.91, 0.99, 0.28],
    [1.0, 0.04, 0.89],
    [0.53, 0.0, 0.92],
    [0.1, 0.0, 1.0],
    [0.06, 1.0, 0.07],
    [0.22, 0.85, 0.84],
    [0.98, 0.61, 0.8],
    [0.48, 1.0, 0.13],
    [0.91, 0.7, 0.02],
    [0.41, 0.94, 0.93],
    [0.21, 0.93, 0.33],
    [0.26, 0.82, 0.7],
    [0.37, 0.56, 0.88],
    [0.3, 1.0, 0.53],
    [0.91, 0.67, 0.17],
    [0.77, 0.94, 0.27],
    [0.83, 0.97, 0.58],
    [0.99, 0.21, 0.86],
    [0.73, 0.64, 0.93],
    [0.71, 0.42, 0.87],
    [0.99, 0.25, 0.52],
    [0.46, 0.92, 0.83],
    [0.98, 0.42, 0.5],
    [0.93, 0.81, 0.01],
    [0.82, 0.93, 0.17],
    [0.76, 0.31, 0.7],
    [0.3, 0.93, 0.43],
    [0.59, 0.12, 0.92],
    [0.17, 1.0, 0.28],
    [0.94, 0.47, 0.79],
    [0.92, 0.08, 0.68],
    [0.6, 0.49, 0.87],
    [0.84, 0.85, 0.04],
    [0.46, 0.14, 0.88],
    [0.92, 0.07, 0.86],
    [0.19, 0.84, 0.94],
    [0.37, 0.65, 0.67],
    [0.97, 0.5, 0.18],
    [0.41, 1.0, 0.39],
    [0.54, 0.86, 0.85],
    [0.94, 0.35, 0.0],
    [0.67, 0.07, 0.74],
    [0.41, 0.39, 0.93],
    [0.8, 0.85, 0.26],
    [0.66, 0.84, 0.0],
    [0.8, 0.29, 0.86],
    [0.6, 0.92, 0.11],
    [0.96, 0.3, 0.44],
    [1.0, 0.29, 0.76],
    [0.08, 0.86, 0.93],
    [0.48, 0.51, 0.86],
    [0.56, 0.85, 0.72],
    [0.81, 0.51, 0.66],
    [0.0, 1.0, 0.88],
    [0.88, 0.59, 0.91],
    [0.76, 0.71, 0.39],
    [0.88, 0.79, 0.38],
    [0.88, 0.01, 1.0],
    [0.68, 0.74, 0.46],
    [0.49, 0.86, 0.43],
    [0.5, 0.63, 0.89],
    [0.54, 0.72, 0.93],
    [0.97, 0.94, 0.38],
    [0.78, 0.76, 0.0],
    [0.44, 0.92, 0.21],
    [0.97, 0.42, 0.25],
    [0.92, 0.27, 0.66],
    [0.88, 0.64, 0.32],
    [0.22, 0.69, 0.75],
    [0.21, 0.27, 0.94],
    [0.6, 0.72, 0.35],
    [0.05, 1.0, 0.33],
    [0.69, 0.01, 0.86],
    [0.31, 1.0, 0.38],
    [0.26, 0.97, 0.07],
    [0.84, 0.08, 0.88],
    [0.98, 0.06, 0.76],
    [0.08, 0.76, 0.71],
    [0.22, 0.67, 0.92],
    [0.77, 0.41, 0.72],
    [0.43, 0.3, 0.88],
    [0.8, 0.16, 0.74],
    [0.92, 0.16, 0.54],
    [0.29, 1.0, 0.21],
    [1.0, 0.12, 0.4],
    [0.07, 0.55, 0.98],
    [0.73, 0.55, 0.91],
    [0.92, 0.46, 0.44],
    [1.0, 0.57, 0.46],
    [0.98, 0.04, 0.63],
    [0.71, 0.21, 0.95],
    [0.29, 0.94, 0.99],
    [0.0, 0.92, 0.71],
    [0.17, 0.93, 0.94],
    [0.8, 0.46, 0.79],
    [0.31, 0.69, 0.78],
    [0.44, 0.64, 0.99],
    [0.53, 0.44, 0.72],
    [0.35, 0.86, 0.62],
    [0.7, 0.96, 0.37],
    [0.76, 0.56, 0.49],
    [0.73, 0.95, 0.14],
    [0.75, 0.72, 0.19],
    [0.91, 0.47, 0.08],
    [0.78, 0.65, 0.15],
    [0.93, 0.37, 0.17],
    [0.82, 0.27, 0.5],
    [0.49, 0.86, 0.14],
    [0.85, 0.82, 0.59],
    [0.62, 0.77, 0.18],
    [0.85, 0.09, 0.52],
    [0.19, 0.88, 0.51],
    [0.16, 0.5, 0.92],
    [0.58, 0.99, 0.47],
    [0.92, 0.56, 0.83],
    [0.0, 0.94, 0.44],
    [0.77, 0.54, 0.8],
    [0.93, 0.81, 0.45],
    [0.32, 0.18, 1.0],
    [0.25, 0.8, 1.0],
    [1.0, 0.61, 0.69],
    [0.09, 0.92, 0.39],
    [0.87, 0.37, 0.33],
    [0.41, 0.95, 0.7],
    [0.63, 0.59, 0.95],
    [0.74, 0.06, 0.96],
    [0.03, 0.68, 1.0],
    [0.94, 0.04, 0.51],
    [0.82, 0.58, 0.0],
    [0.54, 0.44, 0.99],
    [0.95, 0.28, 0.59],
    [0.08, 0.89, 0.83],
    [0.07, 0.41, 1.0],
    [0.58, 0.67, 0.86],
    [0.77, 0.29, 0.94],
    [0.14, 0.92, 0.7],
    [0.73, 0.85, 0.12],
    [0.84, 0.74, 0.52],
    [0.48, 0.23, 0.94],
    [0.99, 0.43, 0.09],
    [0.99, 0.15, 0.2],
    [0.85, 0.63, 0.58],
    [0.3, 0.6, 0.95],
    [0.95, 0.74, 0.58],
    [1.0, 0.17, 0.96],
    [0.39, 0.76, 0.68],
    [0.85, 0.53, 0.87],
    [0.87, 0.92, 0.52],
    [0.91, 0.42, 0.01],
    [0.38, 0.55, 0.77],
    [0.47, 0.42, 0.78],
    [0.91, 0.52, 0.38],
    [0.94, 0.15, 0.65],
    [0.7, 0.91, 0.64],
    [0.24, 0.88, 0.76],
    [0.5, 0.36, 1.0],
    [0.33, 0.86, 0.95],
    [1.0, 0.83, 0.36],
    [0.19, 1.0, 0.07],
    [0.92, 0.55, 0.04],
    [0.68, 0.83, 0.34],
    [0.26, 1.0, 0.46],
    [0.99, 0.37, 0.92],
    [0.43, 0.98, 0.47],
    [0.25, 0.8, 0.62],
    [0.43, 0.92, 0.58],
    [0.48, 0.5, 0.98],
    [0.08, 0.99, 0.99],
    [0.41, 0.73, 0.83],
    [0.64, 0.29, 1.0],
    [0.79, 0.32, 0.59],
    [0.9, 0.58, 0.73],
    [0.34, 0.48, 0.85],
    [0.92, 0.21, 0.32],
    [0.84, 0.94, 0.06],
    [0.0, 0.68, 0.84],
    [0.06, 0.96, 0.56],
    [0.37, 0.96, 0.53],
    [0.56, 0.42, 0.83],
    [0.99, 0.25, 0.08],
    [0.93, 0.33, 0.71],
    [0.99, 0.24, 0.19],
    [0.5, 0.57, 0.77],
    [0.87, 0.35, 0.95],
    [0.99, 0.49, 0.69],
    [0.84, 0.01, 0.92],
    [0.79, 0.7, 0.08],
    [0.64, 0.87, 0.28],
    [0.92, 0.13, 0.77],
    [0.53, 0.94, 0.26],
    [0.73, 0.63, 0.38],
    [1.0, 0.78, 0.19],
    [0.21, 1.0, 0.54],
    [0.93, 0.09, 0.93],
    [0.3, 0.39, 0.93],
    [0.89, 0.22, 0.74],
    [0.92, 0.2, 0.47],
    [0.68, 0.42, 0.94],
    [0.36, 0.72, 0.9],
    [0.93, 0.43, 0.59],
    [0.96, 0.48, 0.02],
    [0.15, 0.71, 0.95],
    [0.3, 0.92, 0.28],
    [0.31, 0.99, 0.65],
    [0.91, 0.56, 0.17],
    [0.58, 0.55, 0.81],
    [0.86, 0.82, 0.24],
    [0.83, 0.99, 0.3],
    [0.73, 0.17, 0.67],
    [1.0, 0.68, 0.57],
    [0.87, 0.3, 0.8],
    [0.55, 0.81, 0.41],
    [0.6, 0.46, 0.94],
    [0.28, 0.52, 0.87],
    [0.26, 0.78, 0.85],
    [0.84, 0.51, 0.22],
    [0.5, 1.0, 0.59],
    [0.16, 0.78, 0.73],
    [0.0, 0.12, 0.99],
    [0.83, 0.55, 0.59],
    [0.74, 0.22, 0.75],
    [0.53, 0.13, 0.84],
    [0.87, 0.23, 0.55],
    [0.46, 0.82, 0.5],
    [0.97, 0.66, 0.13],
    [0.3, 0.73, 1.0],
    [0.94, 0.85, 0.15],
    [0.17, 0.93, 0.39],
    [0.69, 1.0, 0.53],
    [0.66, 0.98, 0.22],
    [0.91, 0.0, 0.44],
    [0.77, 0.49, 0.95],
    [0.5, 0.77, 0.84],
    [0.53, 0.81, 0.27],
    [0.51, 0.92, 0.4],
    [0.99, 0.08, 0.34],
    [0.94, 0.34, 0.87],
    [0.77, 0.81, 0.36],
    [0.85, 0.34, 0.47],
    [0.3, 0.06, 0.96],
    [0.65, 0.85, 0.14],
    [0.17, 1.0, 0.2],
    [0.95, 0.33, 0.36],
    [0.45, 0.89, 0.98],
    [0.59, 0.94, 0.83],
    [0.09, 0.34, 1.0],
    [0.66, 0.14, 0.8],
    [0.68, 0.66, 0.42],
    [0.85, 0.78, 0.12],
    [0.66, 0.87, 0.44],
    [0.51, 0.9, 0.69],
    [0.78, 0.41, 0.85],
    [0.46, 0.0, 0.89],
    [0.12, 0.99, 0.38],
    [0.76, 0.94, 0.55],
    [0.87, 0.24, 0.96],
    [0.41, 0.15, 0.94],
    [0.85, 0.56, 0.37],
    [0.68, 0.74, 0.33],
    [0.4, 0.98, 0.77],
    [0.83, 0.14, 0.91],
    [0.48, 0.21, 0.85],
    [0.27, 0.59, 0.82],
    [0.82, 0.15, 0.56],
    [0.6, 0.22, 0.87],
    [0.75, 0.75, 0.49],
    [0.92, 0.72, 0.52],
    [0.82, 0.42, 0.5],
    [0.47, 0.35, 0.81],
    [0.83, 0.44, 0.66],
    [0.62, 0.85, 0.07],
    [0.95, 0.72, 0.45],
    [0.33, 0.92, 0.77],
    [0.2, 0.92, 0.86],
    [0.13, 0.63, 0.77],
    [0.08, 0.83, 1.0],
    [0.69, 0.99, 0.64],
    [0.57, 0.24, 0.95],
    [0.16, 0.63, 0.94],
    [0.86, 0.65, 0.41],
    [0.41, 0.74, 0.55],
    [0.68, 0.09, 0.9],
    [0.97, 0.93, 0.0],
    [0.46, 0.93, 0.07],
    [0.82, 0.29, 0.66],
    [0.31, 0.94, 0.87],
    [1.0, 0.26, 0.3],
    [0.89, 0.93, 0.35],
    [0.03, 0.9, 1.0],
    [0.99, 0.67, 0.0],
    [0.67, 0.83, 0.24],
    [0.71, 0.37, 1.0],
    [0.63, 0.98, 0.07],
    [0.79, 0.85, 0.44],
    [0.0, 0.76, 0.87],
    [0.86, 0.85, 0.32],
    [0.43, 0.85, 0.86],
    [0.86, 0.74, 0.23],
    [0.16, 0.99, 0.65],
    [0.93, 0.56, 0.24],
    [0.84, 0.83, 0.49],
    [0.79, 1.0, 0.43],
    [0.8, 0.12, 1.0],
    [0.14, 0.84, 0.61],
    [0.3, 0.83, 0.86],
    [0.37, 0.82, 0.76],
    [0.46, 0.97, 0.89],
    [0.86, 0.46, 0.9],
    [0.61, 0.82, 0.88],
    [0.19, 0.32, 1.0],
    [0.73, 0.48, 0.81],
    [0.61, 0.36, 0.74],
    [0.12, 0.81, 0.85],
    [0.64, 1.0, 0.34],
    [0.17, 0.61, 0.87],
    [0.64, 0.94, 0.71],
    [0.44, 0.76, 0.75],
    [0.93, 0.44, 0.16],
    [0.46, 0.75, 0.62],
    [0.73, 0.38, 0.66],
    [0.88, 0.38, 0.79],
    [0.54, 0.99, 0.31],
    [1.0, 0.35, 0.14],
    [0.18, 0.83, 0.77],
    [0.32, 0.92, 0.51],
    [1.0, 0.07, 0.08],
    [0.54, 0.92, 0.9],
    [0.52, 0.05, 1.0],
    [0.4, 0.25, 0.95],
    [0.47, 0.91, 0.28],
    [0.84, 0.49, 0.73],
    [0.78, 0.87, 0.57],
    [0.0, 1.0, 0.81],
    [0.07, 0.49, 0.93],
    [0.28, 0.55, 1.0],
    [0.34, 0.45, 0.92],
    [0.48, 0.84, 0.61],
    [0.45, 0.76, 0.94],
    [0.82, 0.35, 0.72],
    [0.08, 0.69, 0.94],
    [0.82, 0.56, 0.93],
    [0.92, 0.33, 0.23],
    [0.43, 1.0, 0.27],
    [0.94, 0.44, 0.67],
    [0.8, 0.64, 0.95],
    [0.84, 0.43, 0.37],
    [0.95, 0.16, 0.83],
    [0.27, 0.95, 0.57],
    [1.0, 0.71, 0.06],
    [0.87, 0.78, 0.46],
    [1.0, 0.7, 0.4],
    [0.15, 0.93, 0.5],
    [0.7, 0.54, 0.85],
    [0.69, 0.67, 0.28],
    [0.8, 0.01, 0.66],
    [0.24, 0.74, 0.91],
    [0.93, 0.64, 0.06],
    [0.96, 0.18, 0.39],
    [0.81, 0.25, 0.74],
    [0.66, 0.47, 1.0],
    [0.37, 0.94, 0.83],
    [0.64, 0.87, 0.59],
    [0.85, 0.11, 0.78],
    [0.94, 0.49, 0.3],
    [0.37, 0.9, 0.67],
    [0.53, 0.89, 0.49],
    [0.2, 0.56, 0.94],
    [0.85, 0.59, 0.83],
    [0.01, 0.88, 0.89],
    [0.73, 0.9, 0.49],
    [0.38, 0.86, 0.34],
    [0.73, 0.18, 0.89],
    [0.26, 0.93, 0.65],
    [0.82, 0.16, 0.67],
    [0.19, 0.97, 0.78],
    [0.99, 0.09, 0.83],
    [0.49, 0.92, 0.0],
    [1.0, 0.33, 0.83],
    [0.7, 0.29, 0.93],
    [0.64, 0.77, 0.01],
    [0.4, 0.86, 0.93],
    [1.0, 0.38, 0.67],
    [0.95, 0.5, 0.59],
    [0.0, 0.23, 0.99],
    [0.06, 0.62, 0.96],
    [0.57, 0.98, 0.04],
    [0.09, 0.93, 0.88],
    [0.85, 0.29, 0.92],
    [0.97, 0.58, 0.11],
    [1.0, 0.78, 0.45],
    [0.81, 0.44, 1.0],
    [0.93, 0.72, 0.65],
    [0.72, 0.94, 0.23],
    [1.0, 0.95, 0.22],
    [0.67, 0.75, 0.13],
    [0.47, 0.44, 0.93],
    [0.75, 0.67, 0.03],
    [0.74, 0.35, 0.81],
    [0.51, 0.69, 0.84],
    [0.9, 0.13, 1.0],
    [0.61, 0.53, 0.93],
    [1.0, 0.55, 0.58],
    [0.0, 0.64, 0.94],
    [0.9, 0.14, 0.42],
    [0.85, 0.22, 0.68],
    [0.96, 0.87, 0.08],
    [0.8, 0.13, 0.84],
    [0.72, 0.75, 0.07],
    [0.52, 0.56, 0.93],
    [0.15, 1.0, 0.97],
    [0.93, 0.41, 0.83],
    [0.75, 0.05, 0.85],
    [0.84, 0.51, 0.49],
    [0.14, 0.74, 0.67],
    [0.07, 0.99, 0.16],
    [0.79, 1.0, 0.53],
    [0.0, 0.81, 0.69],
    [0.62, 0.05, 0.83],
    [0.59, 0.9, 0.24],
    [0.85, 0.64, 0.15],
    [1.0, 0.68, 0.7],
    [0.78, 0.82, 0.16],
    [0.61, 0.75, 0.93],
    [0.54, 0.07, 0.93],
    [1.0, 0.74, 0.13],
    [0.4, 0.01, 0.99],
    [0.81, 0.62, 0.28],
    [0.86, 0.58, 0.45],
    [0.72, 0.13, 0.77],
    [0.45, 0.66, 0.73],
    [0.39, 0.61, 0.8],
    [0.86, 0.26, 0.44],
    [0.8, 0.7, 0.45],
    [0.72, 0.89, 0.35],
    [0.98, 0.24, 0.44],
    [0.59, 0.77, 0.27],
    [1.0, 0.11, 0.48],
    [0.46, 0.83, 0.3],
    [0.18, 0.67, 0.81],
    [0.54, 0.98, 0.77],
    [0.99, 0.23, 0.93],
    [0.91, 0.46, 0.95],
    [0.26, 0.16, 0.95],
    [0.69, 0.28, 0.77],
    [0.49, 0.35, 0.91],
    [0.63, 0.22, 0.74],
    [0.96, 0.78, 0.07],
    [0.94, 0.04, 0.99],
    [0.54, 1.0, 0.65],
    [0.28, 0.29, 0.92]
]

coorinates = np.array(
    [[-0.272118037, 0.610992422, -0.106760832], [-0.0237478161, 0.305230346, 0.20117061],
     [0.224622404, -0.000531730023, 0.509102053], [0.472992625, -0.306293806, 0.817033496],
     [11.795952048071417, -4.678521065465036, 11.191945873604357],
     [11.823663178507395, -4.346610609053391, 11.002907206731464]]
)

cgo = [2.0, 3.0, 6.0, 0.0, 1.0, 0.0, 4.0, -0.272118037, 0.610992422, -0.106760832, 4.0, -0.0237478161, 0.305230346,
       0.20117061, 4.0, 0.224622404, -0.000531730023, 0.509102053, 4.0, 0.472992625, -0.306293806, 0.817033496, 4.0,
       11.795952048071417, -4.678521065465036, 11.191945873604357, 4.0, 11.823663178507395, -4.346610609053391,
       11.002907206731464, 3.0]

spheres = [(np.array([0., 0., 0.]), 0.5),
           (np.array([9.41943245e-04, 1.79272295e+00, -8.66500472e-01]), 1.7790397812941525),
           (np.array([-0.09170337, 3.40391327, -1.10537604]), 1.4390205615573952)
           ]

x_points = np.array([-0.97074315, -0.47074315, 0.02925685, 0.52925685, 1.02925685, 1.52925685, 2.02925685])
y_points = np.array([-0.87903978, -0.37903978, 0.12096022, 0.62096022, 1.12096022, 1.62096022, 2.12096022])
z_points = np.array([-2.48441582, -1.98441582, -1.48441582, -0.98441582, -0.48441582, 0.01558418, 0.51558418])

grid = np.array([[
    [0., 0., 0., 0., 0., 0., 0.], [0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0.],
    [0., 0., 1.08288584, 1.16521173, 1.13353996, 1.01119792, 0.],
    [0., 1.09385238, 1.33447551, 1.49857195, 1.43292794, 1.20671524, 0.],
    [0., 1.1930976, 1.52804767, 1.79019307, 1.68128752, 1.34415664, 1.04761246],
    [0., 1.17264448, 1.48577081, 1.72323542, 1.62545639, 1.31510945, 1.03368456]],
    [[0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 1.02183245, 1.00027127, 1.02820307, 0.],
     [0., 1.0546916, 1.26516052, 1.40233293, 1.34810431, 1.15473674, 0.],
     [0., 1.28274717, 1.7315772,  2.14535928, 1.96493151, 1.47648308, 1.10674347],
     [1.05019997, 1.45174587, 2.23463492, 3.45010227, 2.82004577, 1.75288672, 1.20988203],
     [1.03616999, 1.41534541, 1.03494235, 1.07131234, 2.57800661, 1.68988449, 1.18856894]],
    [[0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 0.,  0., 1.31410703, 0.],
     [0., 0., 0., 1.06138127, 1.0372782,  3.98660141, 0.],
     [0., 1.09834758, 1.34266235, 1.51019351, 1.44307806, 1.21275847, 0.],
     [1.01539844, 1.36373879, 1.9481942, 2.60619105, 2.30046106, 1.60401472, 1.15751077],
     [1.09327753, 1.57243998, 2.771226,  8.4612446, 4.23709605, 1.97869361, 1.27712401],
     [1.07747569, 1.52648176, 1.07131234, 1.11180753, 1.00599046, 1.88937506, 1.25213118]],
    [[0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 1.01241899, 0., 0., 0.],
     [0., 1.04434981, 1.24742383, 1.37829389, 1.3267061, 1.14120339, 0.],
     [0., 1.26427132, 1.68691804, 2.06212878, 1.90038585, 1.4485032, 1.09481138],
     [1.03998847, 1.42512391, 2.14103208, 3.13260216, 2.6385616, 1.70660236, 1.19434233],
     [1.02635852, 1.39064273, 2.02914965, 1.00599046, 2.43716651, 1.64829828, 1.17382622]],
    [[0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 1.06085608, 1.13789651, 1.10834498, 0., 0.],
     [0., 1.07116053, 1.29388438, 1.4417589, 1.38301835, 1.17645254, 0.],
     [0., 1.16382341, 1.46794986, 1.69560212, 1.60220374, 1.30270293, 1.02762728],
     [0., 1.14481562, 1.43034835, 1.63838096, 1.55366658, 1.27620936, 1.0144715]],
    [[0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 1.06300583, 1.03879441, 0., 0.],
     [0., 0., 1.07337366, 1.15338548, 1.12264322, 1.00343954 ,0.],
     [0., 0., 1.0584076, 1.13487649, 1.10555362, 0., 0.]],
    [[0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 0., 0., 0., 0.],
     [0., 0., 0., 0., 0., 0., 0.]]])


vertices = np.array([[-0.97074315, 0.12096022, -0.98441582],
                     [-0.47074315, -0.37903978, -0.98441582],
                     [-0.47074315, 0.12096022, -1.48441582],
                     [-0.97074315, 0.12096022, -0.48441582],
                     [-0.47074315, -0.37903978, -0.48441582],
                     [-0.97074315, 0.12096022, 0.01558418],
                     [-0.47074315, -0.37903978, 0.01558418],
                     [-0.47074315, 0.12096022, 0.01558418],
                     [-0.97074315, 0.62096022, -1.98441582],
                     [-0.47074315, 0.12096022, -1.98441582],
                     [-0.47074315, 0.62096022, -2.48441582],
                     [-0.47074315, 0.12096022, -1.48441582],
                     [-0.97074315, 0.12096022, -1.48441582],
                     [-0.97074315, 0.62096022, -1.98441582],
                     [-0.97074315, 0.12096022, -0.98441582],
                     [-0.97074315, 0.12096022, -0.48441582],
                     [-0.97074315, 0.12096022, 0.01558418],
                     [-0.47074315, 0.62096022, 0.01558418],
                     [-0.97074315, 0.62096022, 0.01558418],
                     [-0.47074315, 1.12096022, -2.48441582],
                     [-0.97074315, 0.62096022, -1.98441582],
                     [-0.97074315, 1.12096022, -2.48441582],
                     [-0.97074315, 1.12096022, 0.51558418],
                     [-0.47074315, 0.62096022, 0.51558418],
                     [-0.97074315, 1.12096022, 0.01558418],
                     [-0.47074315, 1.12096022, -2.48441582],
                     [-0.97074315, 1.62096022, -2.48441582],
                     [-0.97074315, 1.62096022, -2.48441582],
                     [-0.97074315, 1.12096022, 0.51558418],
                     [-0.97074315, 2.12096022, -2.48441582],
                     [-0.97074315, 2.12096022, -2.48441582],
                     [-0.47074315, -0.37903978, 0.01558418],
                     [0.02925685, -0.87903978, 0.01558418],
                     [0.02925685, -0.37903978, -0.48441582],
                     [0.02925685, -0.37903978, 0.01558418],
                     [0.02925685, -0.37903978, -0.98441582],
                     [0.02925685, 0.12096022, -1.48441582],
                     [0.02925685, -0.37903978, -0.48441582],
                     [0.02925685, 0.12096022, 0.01558418],
                     [0.02925685, 0.12096022, -1.98441582],
                     [0.02925685, 0.62096022, -2.48441582],
                     [0.02925685, 0.12096022, -1.48441582],
                     [0.02925685, 0.62096022, 0.01558418],
                     [0.02925685, 0.62096022, -2.48441582],
                     [-0.47074315, 1.12096022, -2.48441582],
                     [0.02925685, 0.62096022, 0.51558418],
                     [0.02925685, -0.37903978, 0.01558418],
                     [0.52925685, -0.37903978, -0.98441582],
                     [0.52925685, 0.12096022, -1.48441582],
                     [0.02925685, 0.12096022, -0.48441582],
                     [0.52925685, 0.12096022, -0.98441582],
                     [0.02925685, 0.12096022, 0.01558418],
                     [0.52925685, 0.12096022, -1.98441582],
                     [0.52925685, 0.62096022, -2.48441582],
                     [0.52925685, 0.12096022, -1.48441582],
                     [0.52925685, 0.12096022, -0.48441582],
                     [0.52925685, 0.12096022, 0.01558418],
                     [0.52925685, 0.62096022, 0.01558418],
                     [0.52925685, 1.12096022, -2.48441582],
                     [0.02925685, 1.12096022, -2.48441582],
                     [0.52925685, 0.62096022, 0.51558418],
                     [0.52925685, 1.12096022, -2.48441582],
                     [0.52925685, 0.12096022, -0.98441582],
                     [0.52925685, 0.62096022, -1.98441582],
                     [1.02925685, 0.12096022, -1.48441582],
                     [1.02925685, 0.62096022, -1.98441582],
                     [1.02925685, 0.12096022, -0.98441582],
                     [1.02925685, 0.12096022, -0.48441582],
                     [0.52925685, 0.62096022, 0.01558418],
                     [1.02925685, 0.62096022, -0.48441582],
                     [1.02925685, 0.62096022, -1.98441582],
                     [1.02925685, 1.12096022, -2.48441582],
                     [1.02925685, 0.62096022, 0.01558418],
                     [0.52925685, 1.12096022, 0.51558418],
                     [1.02925685, 1.12096022, 0.01558418],
                     [1.02925685, 1.62096022, -2.48441582],
                     [0.52925685, 1.62096022, -2.48441582],
                     [1.02925685, 1.12096022, 0.51558418],
                     [1.02925685, 2.12096022, -2.48441582],
                     [0.52925685, 2.12096022, -2.48441582],
                     [1.02925685, 0.62096022, -1.48441582],
                     [1.02925685, 0.62096022, -0.98441582],
                     [1.02925685, 0.62096022, -0.48441582],
                     [1.02925685, 1.12096022, -1.98441582],
                     [1.02925685, 1.12096022, -1.48441582],
                     [1.52925685, 0.62096022, -0.98441582],
                     [1.52925685, 1.12096022, -1.48441582],
                     [1.52925685, 0.62096022, -0.48441582],
                     [1.02925685, 1.12096022, 0.01558418],
                     [1.52925685, 1.12096022, -0.48441582],
                     [1.02925685, 1.62096022, -1.98441582],
                     [1.52925685, 1.12096022, -1.48441582],
                     [1.52925685, 1.62096022, -1.98441582],
                     [1.52925685, 1.12096022, 0.01558418],
                     [1.02925685, 1.62096022, 0.51558418],
                     [1.52925685, 1.62096022, 0.01558418],
                     [1.02925685, 2.12096022, -1.98441582],
                     [1.52925685, 2.12096022, -1.98441582],
                     [1.02925685, 2.12096022, 0.01558418],
                     [1.52925685, 1.62096022, 0.01558418],
                     [1.52925685, 2.12096022, -0.48441582],
                     [1.02925685, 2.12096022, 0.51558418],
                     [1.52925685, 1.12096022, -0.98441582],
                     [1.52925685, 1.12096022, -0.48441582],
                     [1.52925685, 1.62096022, -1.48441582],
                     [1.52925685, 1.62096022, -0.98441582],
                     [1.52925685, 1.62096022, -0.48441582],
                     [1.52925685, 1.62096022, 0.01558418],
                     [1.52925685, 2.12096022, -1.48441582],
                     [1.52925685, 2.12096022, -0.98441582],
                     [1.52925685, 2.12096022, -0.48441582]])

normals = np.array([[-0.66958948, -0.66958948, -0.32140295],
                    [-0.42926582, -0.85853165, -0.28045367],
                    [-0.2308687, -0.69260611, -0.68337136],
                    [-0.70707536, -0.70707536, 0.00942767],
                    [-0.51448365, -0.85747275, 0.00685978],
                    [-0.66366484, -0.66366484, 0.34510572],
                    [-0.33038045, -0.66076089, 0.67397611],
                    [0., 0., 1.],
                    [-0.58119892, -0.58119892, -0.56957495],
                    [-0.28641188, -0.85923563, -0.42388958],
                    [-0.2684102, -0.53682039, -0.79986238],
                    [0., -0.99991112, 0.01333215],
                    [-0.3025916, -0.9077748, -0.29048794],
                    [-0.58504547, -0.58504547, -0.56164365],
                    [0., -0.99920096, 0.03996804],
                    [0., 0., 1.],
                    [0., 0., 1.],
                    [-0.42407921, -0.63611882, 0.6446004],
                    [0., 0., 1.],
                    [0., 0., -1.],
                    [0., 0., 1.],
                    [-0.30483272, -0.30483272, -0.90230484],
                    [-0.70703608, -0.70703608, 0.01414072],
                    [-0.31620247, -0.94860741, 0.0126481],
                    [-0.56965494, -0.56965494, 0.59244114],
                    [0., 0., 1.],
                    [0., 0., 1.],
                    [0., 0., -1.],
                    [0., 0., 1.],
                    [0., 0., 1.],
                    [0., 0., 1.],
                    [-0.70682411, -0.70682411, 0.02827296],
                    [0., -0.99920096, 0.03996804],
                    [0.58504547, -0.58504547, -0.56164365],
                    [0., 0., 1.],
                    [0., -0.8605151, -0.50942494],
                    [0., -0.71183643, -0.70234528],
                    [0.40688076, -0.81376151, 0.41501837],
                    [0., 0., 1.],
                    [0., -0.89680588, -0.44242424],
                    [0., -0.44960991, -0.89322502],
                    [0., -0.99991112, 0.01333215],
                    [0., -0.70240855, 0.711774],
                    [0., 0., 1.],
                    [0., 0., 1.],
                    [0., -0.99991112, 0.01333215],
                    [0.99991112, 0., 0.01333215],
                    [0.53602546, -0.80403819, -0.25729222],
                    [0.41094194, -0.82188388, -0.39450426],
                    [0.68677402, -0.68677402, 0.23808166],
                    [0.66076089, -0.33038045, 0.67397611],
                    [0.56965494, -0.56965494, 0.59244114],
                    [0.3729267, -0.74585339, -0.55193151],
                    [0.37344643, -0.56016964, -0.73942392],
                    [0., -0.99995, 0.0099995],
                    [0., -0.999968, 0.00799974],
                    [0.42407921, -0.63611882, 0.6446004],
                    [0., -0.8269265, 0.56231002],
                    [0., 0., -1.],
                    [0., 0., -1.],
                    [0.57350161, -0.57350161, 0.58497164],
                    [0., 0., 1.],
                    [0.44714206, -0.89428412, 0.01788568],
                    [0.58119892, -0.58119892, -0.56957495],
                    [0.64191723, -0.64191723, -0.41938592],
                    [0.82188388, -0.41094194, -0.39450426],
                    [0.5999808, -0.7999744, 0.00799974],
                    [0.79945726, -0.53297151, 0.27714518],
                    [0.56965494, -0.56965494, 0.59244114],
                    [0.57350161, -0.57350161, 0.58497164],
                    [0.66958948, -0.66958948, -0.32140295],
                    [0.78808593, -0.19702148, -0.58318359],
                    [0.57478437, -0.57478437, 0.58244816],
                    [0.56965494, -0.56965494, 0.59244114],
                    [0.57350161, -0.57350161, 0.58497164],
                    [0.60385769, 0., -0.79709215],
                    [0., 0., -1.],
                    [0.57350161, -0.57350161, 0.58497164],
                    [0.72138732, 0., -0.69253183],
                    [0., 0., -1.],
                    [0.99997778, 0., 0.00666652],
                    [0.78564995, -0.58923746, -0.18855599],
                    [0.70682411, -0.70682411, 0.02827296],
                    [0.999968, 0., 0.00799974],
                    [0.57991617, -0.57991617, -0.57218395],
                    [0.48734703, -0.73102054, -0.47760009],
                    [0.82188388, -0.41094194, -0.39450426],
                    [0.68677402, -0.68677402, 0.23808166],
                    [0.56965494, -0.56965494, 0.59244114],
                    [0.66076089, -0.33038045, 0.67397611],
                    [0.74585339, -0.3729267, -0.55193151],
                    [0.33630596, -0.67261193, -0.65915969],
                    [0.69260611, -0.2308687, -0.68337136],
                    [0.66366484, -0.66366484, 0.34510572],
                    [0.79719597, 0.26573199, 0.54209326],
                    [0.70007141, 0., 0.71407284],
                    [0.71421284, 0., -0.69992858],
                    [0.72138732, 0., -0.69253183],
                    [0.72417306, 0.48278204, 0.49243768],
                    [0.57350161, 0.57350161, 0.58497164],
                    [0.56965494, 0.56965494, 0.59244114],
                    [0.99920096, 0., 0.03996804],
                    [0.99997778, 0., 0.00666652],
                    [0.999968, 0., 0.00799974],
                    [0.999968, 0., 0.00799974],
                    [0.99997778, 0., 0.00666652],
                    [0.999968, 0., 0.00799974],
                    [0.99991112, 0., 0.01333215],
                    [0.99995, 0., 0.0099995],
                    [0.99991112, 0., 0.01333215],
                    [0.99980006, 0., 0.019996]])

triangles = np.array([[2, 1, 0], [1, 4, 3], [0, 1, 3], [4, 6, 5], [3, 4, 5], [6, 7, 5], [10, 9, 8], [13, 8, 9], 
                      [13, 9, 12], [12, 9, 11], [0, 11, 2], [0, 14, 11], [14, 12, 11], [3, 14, 0], [15, 14, 3],
                      [5, 15, 3], [16, 15, 5], [16, 5, 7], [16, 7, 18], [18, 7, 17], [8, 20, 21], [8, 21, 10],
                      [10, 21, 19], [8, 13, 20], [22, 17, 23], [22, 24, 17], [24, 18, 17], [25, 27, 26],
                      [25, 19, 27], [19, 21, 27], [22, 28, 24], [26, 30, 29], [27, 30, 26], [33, 32, 31],
                      [32, 34, 31], [2, 36, 35], [1, 2, 35], [35, 37, 1], [1, 37, 4], [31, 37, 33],
                      [31, 6, 37], [6, 4, 37], [6, 31, 34], [6, 34, 7], [7, 34, 38], [10, 40, 39],
                      [9, 10, 39], [39, 41, 9], [9, 41, 11], [41, 2, 11], [36, 2, 41], [38, 42, 7],
                      [42, 17, 7], [43, 19, 44], [43, 40, 19], [40, 10, 19], [42, 23, 17], [45, 23, 42],
                      [44, 19, 25], [32, 33, 46], [32, 46, 34], [36, 48, 47], [35, 36, 47], [50, 49, 37],
                      [50, 37, 47], [47, 37, 35], [33, 37, 49], [33, 49, 46], [46, 49, 51], [46, 51, 38],
                      [34, 46, 38], [40, 53, 52], [39, 40, 52], [52, 54, 39], [39, 54, 41], [54, 36, 41],
                      [48, 36, 54], [50, 55, 49], [49, 56, 51], [55, 56, 49], [51, 56, 57], [51, 57, 38],
                      [38, 57, 42], [59, 40, 43], [59, 58, 40], [58, 53, 40], [57, 45, 42], [60, 45, 57],
                      [59, 61, 58], [47, 48, 62], [47, 62, 50], [52, 53, 63], [63, 65, 64], [63, 64, 52],
                      [52, 64, 54], [48, 66, 62], [48, 54, 66], [54, 64, 66], [62, 55, 50], [62, 66, 55],
                      [66, 67, 55], [69, 68, 56], [69, 56, 67], [67, 56, 55], [56, 68, 57], [70, 63, 53],
                      [70, 53, 71], [71, 53, 58], [63, 70, 65], [69, 72, 68], [74, 73, 60], [72, 74, 60],
                      [72, 60, 57], [72, 57, 68], [76, 58, 61], [76, 75, 58], [75, 71, 58], [74, 77, 73],
                      [75, 79, 78], [76, 79, 75], [64, 65, 80], [66, 64, 80], [81, 66, 80], [67, 66, 81],
                      [82, 67, 81], [67, 82, 69], [70, 71, 83], [65, 70, 83], [65, 83, 80], [80, 83, 84],
                      [85, 84, 86], [85, 81, 84], [81, 80, 84], [81, 87, 82], [85, 87, 81], [89, 88, 72],
                      [87, 89, 72], [87, 72, 69], [87, 69, 82], [72, 88, 74], [90, 83, 71], [75, 90, 71],
                      [91, 90, 92], [91, 84, 90], [84, 83, 90], [84, 91, 86], [89, 93, 88], [95, 94, 77],
                      [93, 95, 77], [93, 77, 74], [93, 74, 88], [96, 90, 75], [78, 96, 75], [92, 96, 97],
                      [90, 96, 92], [100, 98, 99], [99, 94, 95], [99, 98, 94], [98, 101, 94], [85, 86, 102],
                      [87, 85, 102], [103, 87, 102], [87, 103, 89], [91, 92, 104], [86, 91, 104], [86, 104, 102],
                      [102, 104, 105], [102, 105, 103], [103, 105, 106], [93, 89, 103], [93, 103, 107],
                      [107, 103, 106], [93, 107, 95], [108, 104, 92], [97, 108, 92], [104, 108, 105],
                      [105, 108, 109], [105, 109, 106], [106, 109, 110], [100, 99, 107],
                      [100, 107, 110], [110, 107, 106], [107, 99, 95]])

cgo_surf = [2.0, 4.0, 6.0, 0.0, 1.0, 0.0, 5.0, -0.6430960514818236, -0.4287307009878824, -0.634521437462066, 4.0,
            -1.4707431512941527, 1.1209602187058474, -1.9844158212941525, 5.0, -0.6896715738353066, -0.6896715738353066,
            -0.2206949036272981, 4.0, -1.4707431512941527, 0.6209602187058474, -1.4844158212941525, 5.0,
            -0.813663455180233, -0.3254653820720932, -0.48168876546669787, 4.0, -1.9707431512941527, 1.1209602187058474,
            -1.4844158212941525, 5.0, -0.6896715738353066, -0.6896715738353066, -0.2206949036272981, 4.0,
            -1.4707431512941527, 0.6209602187058474, -1.4844158212941525, 5.0, -0.7070753563134707, -0.7070753563134707,
            0.009427671417512943, 4.0, -1.4707431512941527, 0.6209602187058474, -0.9844158212941525, 5.0,
            -0.894411290496088, -0.447205645248044, 0.005962741936640587, 4.0, -1.9707431512941527, 1.1209602187058474,
            -0.9844158212941525, 5.0, -0.813663455180233, -0.3254653820720932, -0.48168876546669787, 4.0,
            -1.9707431512941527, 1.1209602187058474, -1.4844158212941525, 5.0, -0.6896715738353066, -0.6896715738353066,
            -0.2206949036272981, 4.0, -1.4707431512941527, 0.6209602187058474, -1.4844158212941525, 5.0,
            -0.894411290496088, -0.447205645248044, 0.005962741936640587, 4.0, -1.9707431512941527, 1.1209602187058474,
            -0.9844158212941525, 5.0, -0.7070753563134707, -0.7070753563134707, 0.009427671417512943, 4.0,
            -1.4707431512941527, 0.6209602187058474, -0.9844158212941525, 5.0, -0.811000402094099, -0.4055002010470495,
            0.4217202090889315, 4.0, -1.4707431512941527, 0.6209602187058474, -0.4844158212941525, 5.0,
            -0.8093879171754308, -0.4856327503052585, 0.3302302702075758, 4.0, -1.9707431512941527, 1.1209602187058474,
            -0.4844158212941525, 5.0, -0.894411290496088, -0.447205645248044, 0.005962741936640587, 4.0,
            -1.9707431512941527, 1.1209602187058474, -0.9844158212941525, 5.0, -0.7070753563134707, -0.7070753563134707,
            0.009427671417512943, 4.0, -1.4707431512941527, 0.6209602187058474, -0.9844158212941525, 5.0,
            -0.8093879171754308, -0.4856327503052585, 0.3302302702075758, 4.0, -1.9707431512941527, 1.1209602187058474,
            -0.4844158212941525, 5.0, -0.811000402094099, -0.4055002010470495, 0.4217202090889315, 4.0,
            -1.4707431512941527, 0.6209602187058474, -0.4844158212941525, 5.0, -0.5735016055486672, -0.5735016055486672,
            0.5849716376596406, 4.0, -1.4707431512941527, 1.1209602187058474, -0.4844158212941525, 5.0,
            -0.8093879171754308, -0.4856327503052585, 0.3302302702075758, 4.0, -1.9707431512941527, 1.1209602187058474,
            -0.4844158212941525, 5.0, -0.711836432832338, 0.0, -0.7023452803945736, 4.0, -1.4707431512941527,
            1.6209602187058474, -1.9844158212941525, 5.0, -0.6430960514818236, -0.4287307009878824, -0.634521437462066,
            4.0, -1.4707431512941527, 1.1209602187058474, -1.9844158212941525, 5.0, -0.813663455180233,
            -0.3254653820720932, -0.48168876546669787, 4.0, -1.9707431512941527, 1.1209602187058474,
            -1.4844158212941525, 5.0, -0.8968058847750245, 0.0, -0.4424242364890121, 4.0, -1.9707431512941527,
            1.6209602187058474, -1.4844158212941525, 5.0, -0.711836432832338, 0.0, -0.7023452803945736, 4.0,
            -1.4707431512941527, 1.6209602187058474, -1.9844158212941525, 5.0, -0.813663455180233, -0.3254653820720932,
            -0.48168876546669787, 4.0, -1.9707431512941527, 1.1209602187058474, -1.4844158212941525, 5.0,
            -0.813663455180233, -0.3254653820720932, -0.48168876546669787, 4.0, -1.9707431512941527, 1.1209602187058474,
            -1.4844158212941525, 5.0, -0.894411290496088, -0.447205645248044, 0.005962741936640587, 4.0,
            -1.9707431512941527, 1.1209602187058474, -0.9844158212941525, 5.0, -0.8968058847750245, 0.0,
            -0.4424242364890121, 4.0, -1.9707431512941527, 1.6209602187058474, -1.4844158212941525, 5.0,
            -0.894411290496088, -0.447205645248044, 0.005962741936640587, 4.0, -1.9707431512941527, 1.1209602187058474,
            -0.9844158212941525, 5.0, -0.999977778518491, 0.0, 0.006666518523456607, 4.0, -1.9707431512941527,
            1.6209602187058474, -0.9844158212941525, 5.0, -0.8968058847750245, 0.0, -0.4424242364890121, 4.0,
            -1.9707431512941527, 1.6209602187058474, -1.4844158212941525, 5.0, -0.894411290496088, -0.447205645248044,
            0.005962741936640587, 4.0, -1.9707431512941527, 1.1209602187058474, -0.9844158212941525, 5.0,
            -0.8093879171754308, -0.4856327503052585, 0.3302302702075758, 4.0, -1.9707431512941527, 1.1209602187058474,
            -0.4844158212941525, 5.0, -0.999977778518491, 0.0, 0.006666518523456607, 4.0, -1.9707431512941527,
            1.6209602187058474, -0.9844158212941525, 5.0, -0.8093879171754308, -0.4856327503052585, 0.3302302702075758,
            4.0, -1.9707431512941527, 1.1209602187058474, -0.4844158212941525, 5.0, -0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, -1.9707431512941527, 1.6209602187058474, -0.4844158212941525, 5.0,
            -0.999977778518491, 0.0, 0.006666518523456607, 4.0, -1.9707431512941527, 1.6209602187058474,
            -0.9844158212941525, 5.0, -0.5735016055486672, -0.5735016055486672, 0.5849716376596406, 4.0,
            -1.4707431512941527, 1.1209602187058474, -0.4844158212941525, 5.0, -0.811000402094099, -0.4055002010470495,
            0.4217202090889315, 4.0, -1.4707431512941527, 1.1209602187058474, 0.015584178705847496, 5.0,
            -0.7397064835246745, -0.36985324176233725, 0.5621769274787526, 4.0, -1.9707431512941527, 1.6209602187058474,
            0.015584178705847496, 5.0, -0.5735016055486672, -0.5735016055486672, 0.5849716376596406, 4.0,
            -1.4707431512941527, 1.1209602187058474, -0.4844158212941525, 5.0, -0.7397064835246745,
            -0.36985324176233725, 0.5621769274787526, 4.0, -1.9707431512941527, 1.6209602187058474,
            0.015584178705847496, 5.0, -0.8093879171754308, -0.4856327503052585, 0.3302302702075758, 4.0,
            -1.9707431512941527, 1.1209602187058474, -0.4844158212941525, 5.0, -0.8093879171754308, -0.4856327503052585,
            0.3302302702075758, 4.0, -1.9707431512941527, 1.1209602187058474, -0.4844158212941525, 5.0,
            -0.7397064835246745, -0.36985324176233725, 0.5621769274787526, 4.0, -1.9707431512941527, 1.6209602187058474,
            0.015584178705847496, 5.0, -0.9999680015359181, 0.0, 0.007999744012287346, 4.0, -1.9707431512941527,
            1.6209602187058474, -0.4844158212941525, 5.0, -0.811000402094099, -0.4055002010470495, 0.4217202090889315,
            4.0, -1.4707431512941527, 1.1209602187058474, 0.015584178705847496, 5.0, -0.7024085519692114, 0.0,
            0.7117739993288009, 4.0, -1.4707431512941527, 1.6209602187058474, 0.015584178705847496, 5.0,
            -0.7397064835246745, -0.36985324176233725, 0.5621769274787526, 4.0, -1.9707431512941527, 1.6209602187058474,
            0.015584178705847496, 5.0, -0.6726119268927181, 0.33630596344635905, -0.6591596883548637, 4.0,
            -1.4707431512941527, 2.1209602187058474, -1.9844158212941525, 5.0, -0.711836432832338, 0.0,
            -0.7023452803945736, 4.0, -1.4707431512941527, 1.6209602187058474, -1.9844158212941525, 5.0,
            -0.8968058847750245, 0.0, -0.4424242364890121, 4.0, -1.9707431512941527, 1.6209602187058474,
            -1.4844158212941525, 5.0, -0.813663455180233, 0.3254653820720932, -0.48168876546669787, 4.0,
            -1.9707431512941527, 2.1209602187058474, -1.4844158212941525, 5.0, -0.6726119268927181, 0.33630596344635905,
            -0.6591596883548637, 4.0, -1.4707431512941527, 2.1209602187058474, -1.9844158212941525, 5.0,
            -0.8968058847750245, 0.0, -0.4424242364890121, 4.0, -1.9707431512941527, 1.6209602187058474,
            -1.4844158212941525, 5.0, -0.8968058847750245, 0.0, -0.4424242364890121, 4.0, -1.9707431512941527,
            1.6209602187058474, -1.4844158212941525, 5.0, -0.999977778518491, 0.0, 0.006666518523456607, 4.0,
            -1.9707431512941527, 1.6209602187058474, -0.9844158212941525, 5.0, -0.813663455180233, 0.3254653820720932,
            -0.48168876546669787, 4.0, -1.9707431512941527, 2.1209602187058474, -1.4844158212941525, 5.0,
            -0.999977778518491, 0.0, 0.006666518523456607, 4.0, -1.9707431512941527, 1.6209602187058474,
            -0.9844158212941525, 5.0, -0.9999680015359181, 0.0, 0.007999744012287346, 4.0, -1.9707431512941527,
            2.1209602187058474, -0.9844158212941525, 5.0, -0.813663455180233, 0.3254653820720932, -0.48168876546669787,
            4.0, -1.9707431512941527, 2.1209602187058474, -1.4844158212941525, 5.0, -0.999977778518491, 0.0,
            0.006666518523456607, 4.0, -1.9707431512941527, 1.6209602187058474, -0.9844158212941525, 5.0,
            -0.9999680015359181, 0.0, 0.007999744012287346, 4.0, -1.9707431512941527, 1.6209602187058474,
            -0.4844158212941525, 5.0, -0.9999680015359181, 0.0, 0.007999744012287346, 4.0, -1.9707431512941527,
            2.1209602187058474, -0.9844158212941525, 5.0, -0.9999680015359181, 0.0, 0.007999744012287346, 4.0,
            -1.9707431512941527, 1.6209602187058474, -0.4844158212941525, 5.0, -0.999977778518491, 0.0,
            0.006666518523456607, 4.0, -1.9707431512941527, 2.1209602187058474, -0.4844158212941525, 5.0,
            -0.9999680015359181, 0.0, 0.007999744012287346, 4.0, -1.9707431512941527, 2.1209602187058474,
            -0.9844158212941525, 5.0, -0.9999680015359181, 0.0, 0.007999744012287346, 4.0, -1.9707431512941527,
            1.6209602187058474, -0.4844158212941525, 5.0, -0.7397064835246745, -0.36985324176233725, 0.5621769274787526,
            4.0, -1.9707431512941527, 1.6209602187058474, 0.015584178705847496, 5.0, -0.999977778518491, 0.0,
            0.006666518523456607, 4.0, -1.9707431512941527, 2.1209602187058474, -0.4844158212941525, 5.0,
            -0.7397064835246745, -0.36985324176233725, 0.5621769274787526, 4.0, -1.9707431512941527, 1.6209602187058474,
            0.015584178705847496, 5.0, -0.5299691672907444, 0.2649845836453722, 0.8055531342819315, 4.0,
            -1.9707431512941527, 2.1209602187058474, 0.015584178705847496, 5.0, -0.999977778518491, 0.0,
            0.006666518523456607, 4.0, -1.9707431512941527, 2.1209602187058474, -0.4844158212941525, 5.0,
            -0.7024085519692114, 0.0, 0.7117739993288009, 4.0, -1.4707431512941527, 1.6209602187058474,
            0.015584178705847496, 5.0, -0.6931087162517845, 0.0, 0.720833064901856, 4.0, -1.4707431512941527,
            2.1209602187058474, 0.015584178705847496, 5.0, -0.5299691672907444, 0.2649845836453722, 0.8055531342819315,
            4.0, -1.9707431512941527, 2.1209602187058474, 0.015584178705847496, 5.0, -0.7397064835246745,
            -0.36985324176233725, 0.5621769274787526, 4.0, -1.9707431512941527, 1.6209602187058474,
            0.015584178705847496, 5.0, -0.7024085519692114, 0.0, 0.7117739993288009, 4.0, -1.4707431512941527,
            1.6209602187058474, 0.015584178705847496, 5.0, -0.5299691672907444, 0.2649845836453722, 0.8055531342819315,
            4.0, -1.9707431512941527, 2.1209602187058474, 0.015584178705847496, 5.0, -0.6726119268927181,
            0.33630596344635905, -0.6591596883548637, 4.0, -1.4707431512941527, 2.1209602187058474, -1.9844158212941525,
            5.0, -0.813663455180233, 0.3254653820720932, -0.48168876546669787, 4.0, -1.9707431512941527,
            2.1209602187058474, -1.4844158212941525, 5.0, -0.5850454715011363, 0.5850454715011363, -0.5616436526410908,
            4.0, -1.4707431512941527, 2.1209602187058474, -1.4844158212941525, 5.0, -0.5391325220142579,
            0.26956626100712894, -0.7979161325811016, 4.0, -1.4707431512941527, 2.6209602187058474, -1.4844158212941525,
            5.0, -0.5850454715011363, 0.5850454715011363, -0.5616436526410908, 4.0, -1.4707431512941527,
            2.1209602187058474, -1.4844158212941525, 5.0, -0.813663455180233, 0.3254653820720932, -0.48168876546669787,
            4.0, -1.9707431512941527, 2.1209602187058474, -1.4844158212941525, 5.0, -0.5391325220142579,
            0.26956626100712894, -0.7979161325811016, 4.0, -1.4707431512941527, 2.6209602187058474, -1.4844158212941525,
            5.0, -0.813663455180233, 0.3254653820720932, -0.48168876546669787, 4.0, -1.9707431512941527,
            2.1209602187058474, -1.4844158212941525, 5.0, -0.9131691555566973, 0.13045273650809963,
            -0.38614010006397487, 4.0, -1.9707431512941527, 2.6209602187058474, -0.9844158212941525, 5.0,
            -0.9131691555566973, 0.13045273650809963, -0.38614010006397487, 4.0, -1.9707431512941527,
            2.6209602187058474, -0.9844158212941525, 5.0, -0.813663455180233, 0.3254653820720932, -0.48168876546669787,
            4.0, -1.9707431512941527, 2.1209602187058474, -1.4844158212941525, 5.0, -0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, -1.9707431512941527, 2.1209602187058474, -0.9844158212941525, 5.0,
            -0.9999680015359181, 0.0, 0.007999744012287346, 4.0, -1.9707431512941527, 2.1209602187058474,
            -0.9844158212941525, 5.0, -0.999977778518491, 0.0, 0.006666518523456607, 4.0, -1.9707431512941527,
            2.1209602187058474, -0.4844158212941525, 5.0, -0.9131691555566973, 0.13045273650809963,
            -0.38614010006397487, 4.0, -1.9707431512941527, 2.6209602187058474, -0.9844158212941525, 5.0,
            -0.999977778518491, 0.0, 0.006666518523456607, 4.0, -1.9707431512941527, 2.1209602187058474,
            -0.4844158212941525, 5.0, -0.5747843685791867, 0.5747843685791867, 0.5824481601602425, 4.0,
            -1.9707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0, -0.9131691555566973, 0.13045273650809963,
            -0.38614010006397487, 4.0, -1.9707431512941527, 2.6209602187058474, -0.9844158212941525, 5.0,
            -0.4240792104664812, 0.6361188156997218, 0.6446003999090515, 4.0, -1.4707431512941527, 2.1209602187058474,
            0.015584178705847496, 5.0, -0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0,
            -1.4707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0, -0.5747843685791867, 0.5747843685791867,
            0.5824481601602425, 4.0, -1.9707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0,
            -0.4240792104664812, 0.6361188156997218, 0.6446003999090515, 4.0, -1.4707431512941527, 2.1209602187058474,
            0.015584178705847496, 5.0, -0.5747843685791867, 0.5747843685791867, 0.5824481601602425, 4.0,
            -1.9707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0, -0.5299691672907444, 0.2649845836453722,
            0.8055531342819315, 4.0, -1.9707431512941527, 2.1209602187058474, 0.015584178705847496, 5.0,
            -0.5299691672907444, 0.2649845836453722, 0.8055531342819315, 4.0, -1.9707431512941527, 2.1209602187058474,
            0.015584178705847496, 5.0, -0.5747843685791867, 0.5747843685791867, 0.5824481601602425, 4.0,
            -1.9707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0, -0.999977778518491, 0.0,
            0.006666518523456607, 4.0, -1.9707431512941527, 2.1209602187058474, -0.4844158212941525, 5.0,
            -0.5299691672907444, 0.2649845836453722, 0.8055531342819315, 4.0, -1.9707431512941527, 2.1209602187058474,
            0.015584178705847496, 5.0, -0.6931087162517845, 0.0, 0.720833064901856, 4.0, -1.4707431512941527,
            2.1209602187058474, 0.015584178705847496, 5.0, -0.4240792104664812, 0.6361188156997218, 0.6446003999090515,
            4.0, -1.4707431512941527, 2.1209602187058474, 0.015584178705847496, 5.0, -0.711836432832338, 0.0,
            -0.7023452803945736, 4.0, -1.4707431512941527, 3.1209602187058474, -1.4844158212941525, 5.0,
            -0.5391325220142579, 0.26956626100712894, -0.7979161325811016, 4.0, -1.4707431512941527, 2.6209602187058474,
            -1.4844158212941525, 5.0, -0.9131691555566973, 0.13045273650809963, -0.38614010006397487, 4.0,
            -1.9707431512941527, 2.6209602187058474, -0.9844158212941525, 5.0, -0.894391416058758, 0.447195708029379,
            0.008943914160587587, 4.0, -1.9707431512941527, 3.1209602187058474, -0.9844158212941525, 5.0,
            -0.711836432832338, 0.0, -0.7023452803945736, 4.0, -1.4707431512941527, 3.1209602187058474,
            -1.4844158212941525, 5.0, -0.9131691555566973, 0.13045273650809963, -0.38614010006397487, 4.0,
            -1.9707431512941527, 2.6209602187058474, -0.9844158212941525, 5.0, -0.4240792104664812, 0.6361188156997218,
            0.6446003999090515, 4.0, -1.4707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0,
            -0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0, -1.4707431512941527, 3.1209602187058474,
            -0.9844158212941525, 5.0, -0.894391416058758, 0.447195708029379, 0.008943914160587587, 4.0,
            -1.9707431512941527, 3.1209602187058474, -0.9844158212941525, 5.0, -0.4240792104664812, 0.6361188156997218,
            0.6446003999090515, 4.0, -1.4707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0,
            -0.894391416058758, 0.447195708029379, 0.008943914160587587, 4.0, -1.9707431512941527, 3.1209602187058474,
            -0.9844158212941525, 5.0, -0.5747843685791867, 0.5747843685791867, 0.5824481601602425, 4.0,
            -1.9707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0, -0.5747843685791867, 0.5747843685791867,
            0.5824481601602425, 4.0, -1.9707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0,
            -0.894391416058758, 0.447195708029379, 0.008943914160587587, 4.0, -1.9707431512941527, 3.1209602187058474,
            -0.9844158212941525, 5.0, -0.9131691555566973, 0.13045273650809963, -0.38614010006397487, 4.0,
            -1.9707431512941527, 2.6209602187058474, -0.9844158212941525, 5.0, -0.5747843685791867, 0.5747843685791867,
            0.5824481601602425, 4.0, -1.9707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0,
            -0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, -1.4707431512941527, 2.6209602187058474,
            -0.4844158212941525, 5.0, -0.4240792104664812, 0.6361188156997218, 0.6446003999090515, 4.0,
            -1.4707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0, -0.6726119268927181, 0.33630596344635905,
            -0.6591596883548637, 4.0, -1.4707431512941527, 3.6209602187058474, -1.4844158212941525, 5.0,
            -0.711836432832338, 0.0, -0.7023452803945736, 4.0, -1.4707431512941527, 3.1209602187058474,
            -1.4844158212941525, 5.0, -0.894391416058758, 0.447195708029379, 0.008943914160587587, 4.0,
            -1.9707431512941527, 3.1209602187058474, -0.9844158212941525, 5.0, -0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, -1.9707431512941527, 3.6209602187058474, -0.9844158212941525, 5.0,
            -0.6726119268927181, 0.33630596344635905, -0.6591596883548637, 4.0, -1.4707431512941527, 3.6209602187058474,
            -1.4844158212941525, 5.0, -0.894391416058758, 0.447195708029379, 0.008943914160587587, 4.0,
            -1.9707431512941527, 3.1209602187058474, -0.9844158212941525, 5.0, -0.6839126923543284, 0.22797089745144278,
            0.6930315282523861, 4.0, -1.4707431512941527, 3.1209602187058474, -0.9844158212941525, 5.0,
            -0.8872168012345951, 0.0, 0.46135273664198945, 4.0, -1.4707431512941527, 3.6209602187058474,
            -0.9844158212941525, 5.0, -0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0,
            -1.9707431512941527, 3.6209602187058474, -0.9844158212941525, 5.0, -0.894391416058758, 0.447195708029379,
            0.008943914160587587, 4.0, -1.9707431512941527, 3.1209602187058474, -0.9844158212941525, 5.0,
            -0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0, -1.4707431512941527, 3.1209602187058474,
            -0.9844158212941525, 5.0, -0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0,
            -1.9707431512941527, 3.6209602187058474, -0.9844158212941525, 5.0, -0.6726119268927181, 0.33630596344635905,
            -0.6591596883548637, 4.0, -1.4707431512941527, 3.6209602187058474, -1.4844158212941525, 5.0,
            -0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, -1.9707431512941527, 3.6209602187058474,
            -0.9844158212941525, 5.0, -0.7068241080666424, 0.7068241080666424, 0.028272964322665697, 4.0,
            -1.4707431512941527, 3.6209602187058474, -0.9844158212941525, 5.0, -0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, -1.9707431512941527, 3.6209602187058474, -0.9844158212941525, 5.0,
            -0.8872168012345951, 0.0, 0.46135273664198945, 4.0, -1.4707431512941527, 3.6209602187058474,
            -0.9844158212941525, 5.0, -0.7068241080666424, 0.7068241080666424, 0.028272964322665697, 4.0,
            -1.4707431512941527, 3.6209602187058474, -0.9844158212941525, 5.0, -0.5799161682232067, -0.5799161682232067,
            -0.5721839526468974, 4.0, -0.9707431512941527, 0.6209602187058474, -1.9844158212941525, 5.0,
            -0.5352800588583708, -0.8029200882875562, -0.2622872288406017, 4.0, -0.9707431512941527,
            0.12096021870584739, -1.4844158212941525, 5.0, -0.6419172257455104, -0.6419172257455104,
            -0.4193859208204001, 4.0, -1.4707431512941527, 0.6209602187058474, -1.4844158212941525, 5.0,
            -0.5352800588583708, -0.8029200882875562, -0.2622872288406017, 4.0, -0.9707431512941527,
            0.12096021870584739, -1.4844158212941525, 5.0, -0.5999808009215509, -0.7999744012287345,
            0.007999744012287346, 4.0, -0.9707431512941527, 0.12096021870584739, -0.9844158212941525, 5.0,
            -0.7070753563134707, -0.7070753563134707, 0.009427671417512943, 4.0, -1.4707431512941527,
            0.6209602187058474, -0.9844158212941525, 5.0, -0.6419172257455104, -0.6419172257455104, -0.4193859208204001,
            4.0, -1.4707431512941527, 0.6209602187058474, -1.4844158212941525, 5.0, -0.5352800588583708,
            -0.8029200882875562, -0.2622872288406017, 4.0, -0.9707431512941527, 0.12096021870584739,
            -1.4844158212941525, 5.0, -0.7070753563134707, -0.7070753563134707, 0.009427671417512943, 4.0,
            -1.4707431512941527, 0.6209602187058474, -0.9844158212941525, 5.0, -0.5999808009215509, -0.7999744012287345,
            0.007999744012287346, 4.0, -0.9707431512941527, 0.12096021870584739, -0.9844158212941525, 5.0,
            -0.7070753563134707, -0.7070753563134707, 0.009427671417512943, 4.0, -0.9707431512941527,
            0.12096021870584739, -0.4844158212941525, 5.0, -0.7999744012287345, -0.5999808009215509,
            0.007999744012287346, 4.0, -1.4707431512941527, 0.6209602187058474, -0.4844158212941525, 5.0,
            -0.7070753563134707, -0.7070753563134707, 0.009427671417512943, 4.0, -1.4707431512941527,
            0.6209602187058474, -0.9844158212941525, 5.0, -0.5999808009215509, -0.7999744012287345,
            0.007999744012287346, 4.0, -0.9707431512941527, 0.12096021870584739, -0.9844158212941525, 5.0,
            -0.7999744012287345, -0.5999808009215509, 0.007999744012287346, 4.0, -1.4707431512941527,
            0.6209602187058474, -0.4844158212941525, 5.0, -0.7070753563134707, -0.7070753563134707,
            0.009427671417512943, 4.0, -0.9707431512941527, 0.12096021870584739, -0.4844158212941525, 5.0,
            -0.4028591660373982, -0.4028591660373982, 0.8218326987162923, 4.0, -0.9707431512941527, 0.12096021870584739,
            0.015584178705847496, 5.0, -0.7241730641828209, -0.48278204278854725, 0.49243768364431817, 4.0,
            -1.4707431512941527, 0.6209602187058474, 0.015584178705847496, 5.0, -0.7999744012287345,
            -0.5999808009215509, 0.007999744012287346, 4.0, -1.4707431512941527, 0.6209602187058474,
            -0.4844158212941525, 5.0, -0.7070753563134707, -0.7070753563134707, 0.009427671417512943, 4.0,
            -0.9707431512941527, 0.12096021870584739, -0.4844158212941525, 5.0, -0.7241730641828209,
            -0.48278204278854725, 0.49243768364431817, 4.0, -1.4707431512941527, 0.6209602187058474,
            0.015584178705847496, 5.0, -0.4028591660373982, -0.4028591660373982, 0.8218326987162923, 4.0,
            -0.9707431512941527, 0.12096021870584739, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.9707431512941527, 0.6209602187058474, 0.015584178705847496, 5.0, -0.7241730641828209,
            -0.48278204278854725, 0.49243768364431817, 4.0, -1.4707431512941527, 0.6209602187058474,
            0.015584178705847496, 5.0, -0.4892356456317602, -0.32615709708784013, -0.8088696007778434, 4.0,
            -0.9707431512941527, 1.1209602187058474, -2.4844158212941525, 5.0, -0.5850454715011363, -0.5850454715011363,
            -0.5616436526410908, 4.0, -0.9707431512941527, 0.6209602187058474, -1.9844158212941525, 5.0,
            -0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0, -1.4707431512941527, 1.1209602187058474,
            -1.9844158212941525, 5.0, -0.6419172257455104, -0.6419172257455104, -0.4193859208204001, 4.0,
            -1.4707431512941527, 0.6209602187058474, -1.4844158212941525, 5.0, -0.6896715738353066, -0.6896715738353066,
            -0.2206949036272981, 4.0, -1.4707431512941527, 0.6209602187058474, -1.4844158212941525, 5.0,
            -0.6430960514818236, -0.4287307009878824, -0.634521437462066, 4.0, -1.4707431512941527, 1.1209602187058474,
            -1.9844158212941525, 5.0, -0.5799161682232067, -0.5799161682232067, -0.5721839526468974, 4.0,
            -0.9707431512941527, 0.6209602187058474, -1.9844158212941525, 5.0, -0.6419172257455104, -0.6419172257455104,
            -0.4193859208204001, 4.0, -1.4707431512941527, 0.6209602187058474, -1.4844158212941525, 5.0,
            -0.6430960514818236, -0.4287307009878824, -0.634521437462066, 4.0, -1.4707431512941527, 1.1209602187058474,
            -1.9844158212941525, 5.0, -0.5799161682232067, -0.5799161682232067, -0.5721839526468974, 4.0,
            -0.9707431512941527, 0.6209602187058474, -1.9844158212941525, 5.0, -0.6430960514818236, -0.4287307009878824,
            -0.634521437462066, 4.0, -1.4707431512941527, 1.1209602187058474, -1.9844158212941525, 5.0,
            -0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0, -1.4707431512941527, 1.1209602187058474,
            -1.9844158212941525, 5.0, -0.5799161682232067, -0.5799161682232067, -0.5721839526468974, 4.0,
            -0.9707431512941527, 0.6209602187058474, -1.9844158212941525, 5.0, -0.692606109997351, -0.23086870333245033,
            -0.6833713618640529, 4.0, -1.4707431512941527, 1.1209602187058474, -1.9844158212941525, 5.0,
            -0.5850454715011363, -0.5850454715011363, -0.5616436526410908, 4.0, -0.9707431512941527, 0.6209602187058474,
            -1.9844158212941525, 5.0, -0.7070753563134707, -0.7070753563134707, 0.009427671417512943, 4.0,
            -1.4707431512941527, 0.6209602187058474, -0.9844158212941525, 5.0, -0.6896715738353066, -0.6896715738353066,
            -0.2206949036272981, 4.0, -1.4707431512941527, 0.6209602187058474, -1.4844158212941525, 5.0,
            -0.6419172257455104, -0.6419172257455104, -0.4193859208204001, 4.0, -1.4707431512941527, 0.6209602187058474,
            -1.4844158212941525, 5.0, -0.7070753563134707, -0.7070753563134707, 0.009427671417512943, 4.0,
            -1.4707431512941527, 0.6209602187058474, -0.9844158212941525, 5.0, -0.6896715738353066, -0.6896715738353066,
            -0.2206949036272981, 4.0, -1.4707431512941527, 0.6209602187058474, -1.4844158212941525, 5.0,
            -0.7070753563134707, -0.7070753563134707, 0.009427671417512943, 4.0, -1.4707431512941527,
            0.6209602187058474, -0.9844158212941525, 5.0, -0.7999744012287345, -0.5999808009215509,
            0.007999744012287346, 4.0, -1.4707431512941527, 0.6209602187058474, -0.4844158212941525, 5.0,
            -0.7070753563134707, -0.7070753563134707, 0.009427671417512943, 4.0, -1.4707431512941527,
            0.6209602187058474, -0.9844158212941525, 5.0, -0.7070753563134707, -0.7070753563134707,
            0.009427671417512943, 4.0, -1.4707431512941527, 0.6209602187058474, -0.9844158212941525, 5.0,
            -0.811000402094099, -0.4055002010470495, 0.4217202090889315, 4.0, -1.4707431512941527, 0.6209602187058474,
            -0.4844158212941525, 5.0, -0.7070753563134707, -0.7070753563134707, 0.009427671417512943, 4.0,
            -1.4707431512941527, 0.6209602187058474, -0.9844158212941525, 5.0, -0.7999744012287345, -0.5999808009215509,
            0.007999744012287346, 4.0, -1.4707431512941527, 0.6209602187058474, -0.4844158212941525, 5.0,
            -0.811000402094099, -0.4055002010470495, 0.4217202090889315, 4.0, -1.4707431512941527, 0.6209602187058474,
            -0.4844158212941525, 5.0, -0.6361188156997218, -0.4240792104664812, 0.6446003999090515, 4.0,
            -1.4707431512941527, 1.1209602187058474, 0.015584178705847496, 5.0, -0.5735016055486672,
            -0.5735016055486672, 0.5849716376596406, 4.0, -1.4707431512941527, 1.1209602187058474, -0.4844158212941525,
            5.0, -0.811000402094099, -0.4055002010470495, 0.4217202090889315, 4.0, -1.4707431512941527,
            0.6209602187058474, -0.4844158212941525, 5.0, -0.7999744012287345, -0.5999808009215509,
            0.007999744012287346, 4.0, -1.4707431512941527, 0.6209602187058474, -0.4844158212941525, 5.0,
            -0.6361188156997218, -0.4240792104664812, 0.6446003999090515, 4.0, -1.4707431512941527, 1.1209602187058474,
            0.015584178705847496, 5.0, -0.7999744012287345, -0.5999808009215509, 0.007999744012287346, 4.0,
            -1.4707431512941527, 0.6209602187058474, -0.4844158212941525, 5.0, -0.7241730641828209,
            -0.48278204278854725, 0.49243768364431817, 4.0, -1.4707431512941527, 0.6209602187058474,
            0.015584178705847496, 5.0, -0.6361188156997218, -0.4240792104664812, 0.6446003999090515, 4.0,
            -1.4707431512941527, 1.1209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, -0.9707431512941527,
            0.6209602187058474, 0.015584178705847496, 5.0, -0.33038044729990595, -0.6607608945998119,
            0.6739761124918081, 4.0, -0.9707431512941527, 1.1209602187058474, 0.015584178705847496, 5.0,
            -0.6361188156997218, -0.4240792104664812, 0.6446003999090515, 4.0, -1.4707431512941527, 1.1209602187058474,
            0.015584178705847496, 5.0, -0.7241730641828209, -0.48278204278854725, 0.49243768364431817, 4.0,
            -1.4707431512941527, 0.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, -0.9707431512941527,
            0.6209602187058474, 0.015584178705847496, 5.0, -0.6361188156997218, -0.4240792104664812, 0.6446003999090515,
            4.0, -1.4707431512941527, 1.1209602187058474, 0.015584178705847496, 5.0, -0.6038576879954624, 0.0,
            -0.7970921481540103, 4.0, -0.9707431512941527, 1.6209602187058474, -2.4844158212941525, 5.0,
            -0.4892356456317602, -0.32615709708784013, -0.8088696007778434, 4.0, -0.9707431512941527,
            1.1209602187058474, -2.4844158212941525, 5.0, -0.692606109997351, -0.23086870333245033, -0.6833713618640529,
            4.0, -1.4707431512941527, 1.1209602187058474, -1.9844158212941525, 5.0, -0.711836432832338, 0.0,
            -0.7023452803945736, 4.0, -1.4707431512941527, 1.6209602187058474, -1.9844158212941525, 5.0,
            -0.6038576879954624, 0.0, -0.7970921481540103, 4.0, -0.9707431512941527, 1.6209602187058474,
            -2.4844158212941525, 5.0, -0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0,
            -1.4707431512941527, 1.1209602187058474, -1.9844158212941525, 5.0, -0.692606109997351, -0.23086870333245033,
            -0.6833713618640529, 4.0, -1.4707431512941527, 1.1209602187058474, -1.9844158212941525, 5.0,
            -0.711836432832338, 0.0, -0.7023452803945736, 4.0, -1.4707431512941527, 1.6209602187058474,
            -1.9844158212941525, 5.0, -0.711836432832338, 0.0, -0.7023452803945736, 4.0, -1.4707431512941527,
            1.6209602187058474, -1.9844158212941525, 5.0, -0.6430960514818236, -0.4287307009878824, -0.634521437462066,
            4.0, -1.4707431512941527, 1.1209602187058474, -1.9844158212941525, 5.0, -0.711836432832338, 0.0,
            -0.7023452803945736, 4.0, -1.4707431512941527, 1.6209602187058474, -1.9844158212941525, 5.0,
            -0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0, -1.4707431512941527, 1.1209602187058474,
            -1.9844158212941525, 5.0, -0.6361188156997218, -0.4240792104664812, 0.6446003999090515, 4.0,
            -1.4707431512941527, 1.1209602187058474, 0.015584178705847496, 5.0, -0.811000402094099, -0.4055002010470495,
            0.4217202090889315, 4.0, -1.4707431512941527, 1.1209602187058474, 0.015584178705847496, 5.0,
            -0.5735016055486672, -0.5735016055486672, 0.5849716376596406, 4.0, -1.4707431512941527, 1.1209602187058474,
            -0.4844158212941525, 5.0, -0.811000402094099, -0.4055002010470495, 0.4217202090889315, 4.0,
            -1.4707431512941527, 1.1209602187058474, 0.015584178705847496, 5.0, -0.6839126923543284,
            -0.22797089745144278, 0.6930315282523861, 4.0, -1.4707431512941527, 1.6209602187058474, 0.5155841787058475,
            5.0, -0.7024085519692114, 0.0, 0.7117739993288009, 4.0, -1.4707431512941527, 1.6209602187058474,
            0.015584178705847496, 5.0, -0.6361188156997218, -0.4240792104664812, 0.6446003999090515, 4.0,
            -1.4707431512941527, 1.1209602187058474, 0.015584178705847496, 5.0, -0.6839126923543284,
            -0.22797089745144278, 0.6930315282523861, 4.0, -1.4707431512941527, 1.6209602187058474, 0.5155841787058475,
            5.0, -0.811000402094099, -0.4055002010470495, 0.4217202090889315, 4.0, -1.4707431512941527,
            1.1209602187058474, 0.015584178705847496, 5.0, -0.6361188156997218, -0.4240792104664812, 0.6446003999090515,
            4.0, -1.4707431512941527, 1.1209602187058474, 0.015584178705847496, 5.0, -0.2649845836453722,
            -0.5299691672907444, 0.8055531342819315, 4.0, -0.9707431512941527, 1.1209602187058474, 0.5155841787058475,
            5.0, -0.6839126923543284, -0.22797089745144278, 0.6930315282523861, 4.0, -1.4707431512941527,
            1.6209602187058474, 0.5155841787058475, 5.0, -0.6361188156997218, -0.4240792104664812, 0.6446003999090515,
            4.0, -1.4707431512941527, 1.1209602187058474, 0.015584178705847496, 5.0, -0.33038044729990595,
            -0.6607608945998119, 0.6739761124918081, 4.0, -0.9707431512941527, 1.1209602187058474, 0.015584178705847496,
            5.0, -0.2649845836453722, -0.5299691672907444, 0.8055531342819315, 4.0, -0.9707431512941527,
            1.1209602187058474, 0.5155841787058475, 5.0, -0.2649845836453722, -0.5299691672907444, 0.8055531342819315,
            4.0, -0.9707431512941527, 1.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.9707431512941527, 1.6209602187058474, 0.5155841787058475, 5.0, -0.6839126923543284, -0.22797089745144278,
            0.6930315282523861, 4.0, -1.4707431512941527, 1.6209602187058474, 0.5155841787058475, 5.0,
            -0.6038576879954624, 0.0, -0.7970921481540103, 4.0, -0.9707431512941527, 2.1209602187058474,
            -2.4844158212941525, 5.0, -0.6038576879954624, 0.0, -0.7970921481540103, 4.0, -0.9707431512941527,
            1.6209602187058474, -2.4844158212941525, 5.0, -0.711836432832338, 0.0, -0.7023452803945736, 4.0,
            -1.4707431512941527, 1.6209602187058474, -1.9844158212941525, 5.0, -0.8605150974154714, 0.0,
            -0.5094249376699591, 4.0, -1.4707431512941527, 2.1209602187058474, -1.9844158212941525, 5.0,
            -0.6038576879954624, 0.0, -0.7970921481540103, 4.0, -0.9707431512941527, 2.1209602187058474,
            -2.4844158212941525, 5.0, -0.711836432832338, 0.0, -0.7023452803945736, 4.0, -1.4707431512941527,
            1.6209602187058474, -1.9844158212941525, 5.0, -0.711836432832338, 0.0, -0.7023452803945736, 4.0,
            -1.4707431512941527, 1.6209602187058474, -1.9844158212941525, 5.0, -0.6726119268927181, 0.33630596344635905,
            -0.6591596883548637, 4.0, -1.4707431512941527, 2.1209602187058474, -1.9844158212941525, 5.0,
            -0.8605150974154714, 0.0, -0.5094249376699591, 4.0, -1.4707431512941527, 2.1209602187058474,
            -1.9844158212941525, 5.0, -0.711836432832338, 0.0, -0.7023452803945736, 4.0, -1.4707431512941527,
            1.6209602187058474, -1.9844158212941525, 5.0, -0.6726119268927181, 0.33630596344635905, -0.6591596883548637,
            4.0, -1.4707431512941527, 2.1209602187058474, -1.9844158212941525, 5.0, -0.711836432832338, 0.0,
            -0.7023452803945736, 4.0, -1.4707431512941527, 1.6209602187058474, -1.9844158212941525, 5.0,
            -0.6607608945998119, 0.33038044729990595, 0.6739761124918081, 4.0, -1.4707431512941527, 2.1209602187058474,
            0.5155841787058475, 5.0, -0.7024085519692114, 0.0, 0.7117739993288009, 4.0, -1.4707431512941527,
            1.6209602187058474, 0.015584178705847496, 5.0, -0.6839126923543284, -0.22797089745144278,
            0.6930315282523861, 4.0, -1.4707431512941527, 1.6209602187058474, 0.5155841787058475, 5.0,
            -0.6931087162517845, 0.0, 0.720833064901856, 4.0, -1.4707431512941527, 2.1209602187058474,
            0.015584178705847496, 5.0, -0.7024085519692114, 0.0, 0.7117739993288009, 4.0, -1.4707431512941527,
            1.6209602187058474, 0.015584178705847496, 5.0, -0.6607608945998119, 0.33038044729990595, 0.6739761124918081,
            4.0, -1.4707431512941527, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.9707431512941527, 1.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.9707431512941527,
            2.1209602187058474, 0.5155841787058475, 5.0, -0.6607608945998119, 0.33038044729990595, 0.6739761124918081,
            4.0, -1.4707431512941527, 2.1209602187058474, 0.5155841787058475, 5.0, -0.6839126923543284,
            -0.22797089745144278, 0.6930315282523861, 4.0, -1.4707431512941527, 1.6209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, -0.9707431512941527, 1.6209602187058474, 0.5155841787058475, 5.0,
            -0.6607608945998119, 0.33038044729990595, 0.6739761124918081, 4.0, -1.4707431512941527, 2.1209602187058474,
            0.5155841787058475, 5.0, -0.44960990782659727, 0.0, -0.8932250168821733, 4.0, -0.9707431512941527,
            2.6209602187058474, -2.4844158212941525, 5.0, -0.6038576879954624, 0.0, -0.7970921481540103, 4.0,
            -0.9707431512941527, 2.1209602187058474, -2.4844158212941525, 5.0, -0.8605150974154714, 0.0,
            -0.5094249376699591, 4.0, -1.4707431512941527, 2.1209602187058474, -1.9844158212941525, 5.0,
            -0.8605150974154714, 0.0, -0.5094249376699591, 4.0, -1.4707431512941527, 2.6209602187058474,
            -1.9844158212941525, 5.0, -0.44960990782659727, 0.0, -0.8932250168821733, 4.0, -0.9707431512941527,
            2.6209602187058474, -2.4844158212941525, 5.0, -0.8605150974154714, 0.0, -0.5094249376699591, 4.0,
            -1.4707431512941527, 2.1209602187058474, -1.9844158212941525, 5.0, -0.5850454715011363, 0.5850454715011363,
            -0.5616436526410908, 4.0, -1.4707431512941527, 2.1209602187058474, -1.4844158212941525, 5.0,
            -0.8605150974154714, 0.0, -0.5094249376699591, 4.0, -1.4707431512941527, 2.1209602187058474,
            -1.9844158212941525, 5.0, -0.6726119268927181, 0.33630596344635905, -0.6591596883548637, 4.0,
            -1.4707431512941527, 2.1209602187058474, -1.9844158212941525, 5.0, -0.5850454715011363, 0.5850454715011363,
            -0.5616436526410908, 4.0, -1.4707431512941527, 2.1209602187058474, -1.4844158212941525, 5.0,
            -0.9999500037496877, 0.0, 0.009999500037496877, 4.0, -1.4707431512941527, 2.6209602187058474,
            -1.4844158212941525, 5.0, -0.8605150974154714, 0.0, -0.5094249376699591, 4.0, -1.4707431512941527,
            2.1209602187058474, -1.9844158212941525, 5.0, -0.9999500037496877, 0.0, 0.009999500037496877, 4.0,
            -1.4707431512941527, 2.6209602187058474, -1.4844158212941525, 5.0, -0.8605150974154714, 0.0,
            -0.5094249376699591, 4.0, -1.4707431512941527, 2.6209602187058474, -1.9844158212941525, 5.0,
            -0.8605150974154714, 0.0, -0.5094249376699591, 4.0, -1.4707431512941527, 2.1209602187058474,
            -1.9844158212941525, 5.0, -0.5850454715011363, 0.5850454715011363, -0.5616436526410908, 4.0,
            -1.4707431512941527, 2.1209602187058474, -1.4844158212941525, 5.0, -0.5391325220142579, 0.26956626100712894,
            -0.7979161325811016, 4.0, -1.4707431512941527, 2.6209602187058474, -1.4844158212941525, 5.0,
            -0.9999500037496877, 0.0, 0.009999500037496877, 4.0, -1.4707431512941527, 2.6209602187058474,
            -1.4844158212941525, 5.0, -0.4240792104664812, 0.6361188156997218, 0.6446003999090515, 4.0,
            -1.4707431512941527, 2.1209602187058474, 0.015584178705847496, 5.0, -0.5735016055486672, 0.5735016055486672,
            0.5849716376596406, 4.0, -1.4707431512941527, 2.6209602187058474, 0.015584178705847496, 5.0,
            -0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, -1.4707431512941527, 2.6209602187058474,
            -0.4844158212941525, 5.0, -0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            -1.4707431512941527, 2.6209602187058474, 0.015584178705847496, 5.0, -0.5735016055486672, 0.5735016055486672,
            0.5849716376596406, 4.0, -0.9707431512941527, 2.1209602187058474, 0.5155841787058475, 5.0,
            -0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, -0.9707431512941527, 2.6209602187058474,
            0.015584178705847496, 5.0, -0.4240792104664812, 0.6361188156997218, 0.6446003999090515, 4.0,
            -1.4707431512941527, 2.1209602187058474, 0.015584178705847496, 5.0, -0.5735016055486672, 0.5735016055486672,
            0.5849716376596406, 4.0, -0.9707431512941527, 2.1209602187058474, 0.5155841787058475, 5.0,
            -0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, -1.4707431512941527, 2.6209602187058474,
            0.015584178705847496, 5.0, -0.4240792104664812, 0.6361188156997218, 0.6446003999090515, 4.0,
            -1.4707431512941527, 2.1209602187058474, 0.015584178705847496, 5.0, -0.6607608945998119,
            0.33038044729990595, 0.6739761124918081, 4.0, -1.4707431512941527, 2.1209602187058474, 0.5155841787058475,
            5.0, -0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, -0.9707431512941527,
            2.1209602187058474, 0.5155841787058475, 5.0, -0.4240792104664812, 0.6361188156997218, 0.6446003999090515,
            4.0, -1.4707431512941527, 2.1209602187058474, 0.015584178705847496, 5.0, -0.6931087162517845, 0.0,
            0.720833064901856, 4.0, -1.4707431512941527, 2.1209602187058474, 0.015584178705847496, 5.0,
            -0.6607608945998119, 0.33038044729990595, 0.6739761124918081, 4.0, -1.4707431512941527, 2.1209602187058474,
            0.5155841787058475, 5.0, -0.6607608945998119, 0.33038044729990595, 0.6739761124918081, 4.0,
            -1.4707431512941527, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.9707431512941527,
            2.1209602187058474, 0.5155841787058475, 5.0, -0.5735016055486672, 0.5735016055486672, 0.5849716376596406,
            4.0, -0.9707431512941527, 2.1209602187058474, 0.5155841787058475, 5.0, -0.44960990782659727, 0.0,
            -0.8932250168821733, 4.0, -0.9707431512941527, 3.1209602187058474, -2.4844158212941525, 5.0,
            -0.44960990782659727, 0.0, -0.8932250168821733, 4.0, -0.9707431512941527, 2.6209602187058474,
            -2.4844158212941525, 5.0, -0.8605150974154714, 0.0, -0.5094249376699591, 4.0, -1.4707431512941527,
            2.6209602187058474, -1.9844158212941525, 5.0, -0.8968058847750245, 0.0, -0.4424242364890121, 4.0,
            -1.4707431512941527, 3.1209602187058474, -1.9844158212941525, 5.0, -0.44960990782659727, 0.0,
            -0.8932250168821733, 4.0, -0.9707431512941527, 3.1209602187058474, -2.4844158212941525, 5.0,
            -0.8605150974154714, 0.0, -0.5094249376699591, 4.0, -1.4707431512941527, 2.6209602187058474,
            -1.9844158212941525, 5.0, -0.8605150974154714, 0.0, -0.5094249376699591, 4.0, -1.4707431512941527,
            2.6209602187058474, -1.9844158212941525, 5.0, -0.9999500037496877, 0.0, 0.009999500037496877, 4.0,
            -1.4707431512941527, 2.6209602187058474, -1.4844158212941525, 5.0, -0.8968058847750245, 0.0,
            -0.4424242364890121, 4.0, -1.4707431512941527, 3.1209602187058474, -1.9844158212941525, 5.0,
            -0.9999500037496877, 0.0, 0.009999500037496877, 4.0, -1.4707431512941527, 2.6209602187058474,
            -1.4844158212941525, 5.0, -0.9999111229612074, 0.0, 0.013332148306149432, 4.0, -1.4707431512941527,
            3.1209602187058474, -1.4844158212941525, 5.0, -0.8968058847750245, 0.0, -0.4424242364890121, 4.0,
            -1.4707431512941527, 3.1209602187058474, -1.9844158212941525, 5.0, -0.9999500037496877, 0.0,
            0.009999500037496877, 4.0, -1.4707431512941527, 2.6209602187058474, -1.4844158212941525, 5.0,
            -0.711836432832338, 0.0, -0.7023452803945736, 4.0, -1.4707431512941527, 3.1209602187058474,
            -1.4844158212941525, 5.0, -0.9999111229612074, 0.0, 0.013332148306149432, 4.0, -1.4707431512941527,
            3.1209602187058474, -1.4844158212941525, 5.0, -0.5391325220142579, 0.26956626100712894, -0.7979161325811016,
            4.0, -1.4707431512941527, 2.6209602187058474, -1.4844158212941525, 5.0, -0.711836432832338, 0.0,
            -0.7023452803945736, 4.0, -1.4707431512941527, 3.1209602187058474, -1.4844158212941525, 5.0,
            -0.9999500037496877, 0.0, 0.009999500037496877, 4.0, -1.4707431512941527, 2.6209602187058474,
            -1.4844158212941525, 5.0, -0.4240792104664812, 0.6361188156997218, 0.6446003999090515, 4.0,
            -1.4707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0, -0.6839126923543284, 0.22797089745144278,
            0.6930315282523861, 4.0, -1.4707431512941527, 3.1209602187058474, -0.4844158212941525, 5.0,
            -0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0, -1.4707431512941527, 3.1209602187058474,
            -0.9844158212941525, 5.0, -0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0,
            -1.4707431512941527, 3.1209602187058474, -0.4844158212941525, 5.0, -0.5747843685791867, 0.5747843685791867,
            0.5824481601602425, 4.0, -0.9707431512941527, 2.6209602187058474, 0.015584178705847496, 5.0,
            -0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0, -0.9707431512941527, 3.1209602187058474,
            -0.4844158212941525, 5.0, -0.4240792104664812, 0.6361188156997218, 0.6446003999090515, 4.0,
            -1.4707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0, -0.5747843685791867, 0.5747843685791867,
            0.5824481601602425, 4.0, -0.9707431512941527, 2.6209602187058474, 0.015584178705847496, 5.0,
            -0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0, -1.4707431512941527, 3.1209602187058474,
            -0.4844158212941525, 5.0, -0.4240792104664812, 0.6361188156997218, 0.6446003999090515, 4.0,
            -1.4707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0, -0.5735016055486672, 0.5735016055486672,
            0.5849716376596406, 4.0, -1.4707431512941527, 2.6209602187058474, 0.015584178705847496, 5.0,
            -0.5747843685791867, 0.5747843685791867, 0.5824481601602425, 4.0, -0.9707431512941527, 2.6209602187058474,
            0.015584178705847496, 5.0, -0.4240792104664812, 0.6361188156997218, 0.6446003999090515, 4.0,
            -1.4707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0, -0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, -1.4707431512941527, 2.6209602187058474, -0.4844158212941525, 5.0,
            -0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, -1.4707431512941527, 2.6209602187058474,
            0.015584178705847496, 5.0, -0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            -1.4707431512941527, 2.6209602187058474, 0.015584178705847496, 5.0, -0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, -0.9707431512941527, 2.6209602187058474, 0.015584178705847496, 5.0,
            -0.5747843685791867, 0.5747843685791867, 0.5824481601602425, 4.0, -0.9707431512941527, 2.6209602187058474,
            0.015584178705847496, 5.0, -0.44960990782659727, 0.0, -0.8932250168821733, 4.0, -0.9707431512941527,
            3.6209602187058474, -2.4844158212941525, 5.0, -0.44960990782659727, 0.0, -0.8932250168821733, 4.0,
            -0.9707431512941527, 3.1209602187058474, -2.4844158212941525, 5.0, -0.8968058847750245, 0.0,
            -0.4424242364890121, 4.0, -1.4707431512941527, 3.1209602187058474, -1.9844158212941525, 5.0,
            -0.8968058847750245, 0.0, -0.4424242364890121, 4.0, -1.4707431512941527, 3.6209602187058474,
            -1.9844158212941525, 5.0, -0.44960990782659727, 0.0, -0.8932250168821733, 4.0, -0.9707431512941527,
            3.6209602187058474, -2.4844158212941525, 5.0, -0.8968058847750245, 0.0, -0.4424242364890121, 4.0,
            -1.4707431512941527, 3.1209602187058474, -1.9844158212941525, 5.0, -0.8968058847750245, 0.0,
            -0.4424242364890121, 4.0, -1.4707431512941527, 3.1209602187058474, -1.9844158212941525, 5.0,
            -0.9999111229612074, 0.0, 0.013332148306149432, 4.0, -1.4707431512941527, 3.1209602187058474,
            -1.4844158212941525, 5.0, -0.8968058847750245, 0.0, -0.4424242364890121, 4.0, -1.4707431512941527,
            3.6209602187058474, -1.9844158212941525, 5.0, -0.9999111229612074, 0.0, 0.013332148306149432, 4.0,
            -1.4707431512941527, 3.1209602187058474, -1.4844158212941525, 5.0, -0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, -1.4707431512941527, 3.6209602187058474, -1.4844158212941525, 5.0,
            -0.8968058847750245, 0.0, -0.4424242364890121, 4.0, -1.4707431512941527, 3.6209602187058474,
            -1.9844158212941525, 5.0, -0.9999111229612074, 0.0, 0.013332148306149432, 4.0, -1.4707431512941527,
            3.1209602187058474, -1.4844158212941525, 5.0, -0.6726119268927181, 0.33630596344635905, -0.6591596883548637,
            4.0, -1.4707431512941527, 3.6209602187058474, -1.4844158212941525, 5.0, -0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, -1.4707431512941527, 3.6209602187058474, -1.4844158212941525, 5.0,
            -0.711836432832338, 0.0, -0.7023452803945736, 4.0, -1.4707431512941527, 3.1209602187058474,
            -1.4844158212941525, 5.0, -0.6726119268927181, 0.33630596344635905, -0.6591596883548637, 4.0,
            -1.4707431512941527, 3.6209602187058474, -1.4844158212941525, 5.0, -0.9999111229612074, 0.0,
            0.013332148306149432, 4.0, -1.4707431512941527, 3.1209602187058474, -1.4844158212941525, 5.0,
            -0.7961621941231025, 0.0, 0.6050832675335579, 4.0, -1.4707431512941527, 3.6209602187058474,
            -0.4844158212941525, 5.0, -0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0,
            -1.4707431512941527, 3.1209602187058474, -0.9844158212941525, 5.0, -0.6839126923543284, 0.22797089745144278,
            0.6930315282523861, 4.0, -1.4707431512941527, 3.1209602187058474, -0.4844158212941525, 5.0,
            -0.8872168012345951, 0.0, 0.46135273664198945, 4.0, -1.4707431512941527, 3.6209602187058474,
            -0.9844158212941525, 5.0, -0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0,
            -1.4707431512941527, 3.1209602187058474, -0.9844158212941525, 5.0, -0.7961621941231025, 0.0,
            0.6050832675335579, 4.0, -1.4707431512941527, 3.6209602187058474, -0.4844158212941525, 5.0,
            -0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0, -0.9707431512941527, 3.1209602187058474,
            -0.4844158212941525, 5.0, -0.7024085519692114, 0.0, 0.7117739993288009, 4.0, -0.9707431512941527,
            3.6209602187058474, -0.4844158212941525, 5.0, -0.7961621941231025, 0.0, 0.6050832675335579, 4.0,
            -1.4707431512941527, 3.6209602187058474, -0.4844158212941525, 5.0, -0.6839126923543284, 0.22797089745144278,
            0.6930315282523861, 4.0, -1.4707431512941527, 3.1209602187058474, -0.4844158212941525, 5.0,
            -0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0, -0.9707431512941527, 3.1209602187058474,
            -0.4844158212941525, 5.0, -0.7961621941231025, 0.0, 0.6050832675335579, 4.0, -1.4707431512941527,
            3.6209602187058474, -0.4844158212941525, 5.0, -0.48850865146712424, 0.48850865146712424,
            -0.7229928041713439, 4.0, -0.9707431512941527, 4.120960218705847, -2.4844158212941525, 5.0,
            -0.44960990782659727, 0.0, -0.8932250168821733, 4.0, -0.9707431512941527, 3.6209602187058474,
            -2.4844158212941525, 5.0, -0.8968058847750245, 0.0, -0.4424242364890121, 4.0, -1.4707431512941527,
            3.6209602187058474, -1.9844158212941525, 5.0, -0.6896715738353066, 0.6896715738353066, -0.2206949036272981,
            4.0, -1.4707431512941527, 4.120960218705847, -1.9844158212941525, 5.0, -0.48850865146712424,
            0.48850865146712424, -0.7229928041713439, 4.0, -0.9707431512941527, 4.120960218705847, -2.4844158212941525,
            5.0, -0.8968058847750245, 0.0, -0.4424242364890121, 4.0, -1.4707431512941527, 3.6209602187058474,
            -1.9844158212941525, 5.0, -0.8968058847750245, 0.0, -0.4424242364890121, 4.0, -1.4707431512941527,
            3.6209602187058474, -1.9844158212941525, 5.0, -0.9999680015359181, 0.0, 0.007999744012287346, 4.0,
            -1.4707431512941527, 3.6209602187058474, -1.4844158212941525, 5.0, -0.6896715738353066, 0.6896715738353066,
            -0.2206949036272981, 4.0, -1.4707431512941527, 4.120960218705847, -1.9844158212941525, 5.0,
            -0.9999680015359181, 0.0, 0.007999744012287346, 4.0, -1.4707431512941527, 3.6209602187058474,
            -1.4844158212941525, 5.0, -0.5546660639791748, 0.8319990959687623, 0.011093321279583498, 4.0,
            -1.4707431512941527, 4.120960218705847, -1.4844158212941525, 5.0, -0.6896715738353066, 0.6896715738353066,
            -0.2206949036272981, 4.0, -1.4707431512941527, 4.120960218705847, -1.9844158212941525, 5.0,
            -0.7068241080666424, 0.7068241080666424, 0.028272964322665697, 4.0, -1.4707431512941527, 3.6209602187058474,
            -0.9844158212941525, 5.0, -0.9999680015359181, 0.0, 0.007999744012287346, 4.0, -1.4707431512941527,
            3.6209602187058474, -1.4844158212941525, 5.0, -0.6726119268927181, 0.33630596344635905, -0.6591596883548637,
            4.0, -1.4707431512941527, 3.6209602187058474, -1.4844158212941525, 5.0, -0.7068241080666424,
            0.7068241080666424, 0.028272964322665697, 4.0, -1.4707431512941527, 3.6209602187058474, -0.9844158212941525,
            5.0, -0.7999744012287345, 0.5999808009215509, 0.007999744012287346, 4.0, -1.4707431512941527,
            4.120960218705847, -0.9844158212941525, 5.0, -0.9999680015359181, 0.0, 0.007999744012287346, 4.0,
            -1.4707431512941527, 3.6209602187058474, -1.4844158212941525, 5.0, -0.7999744012287345, 0.5999808009215509,
            0.007999744012287346, 4.0, -1.4707431512941527, 4.120960218705847, -0.9844158212941525, 5.0,
            -0.5546660639791748, 0.8319990959687623, 0.011093321279583498, 4.0, -1.4707431512941527, 4.120960218705847,
            -1.4844158212941525, 5.0, -0.9999680015359181, 0.0, 0.007999744012287346, 4.0, -1.4707431512941527,
            3.6209602187058474, -1.4844158212941525, 5.0, -0.8872168012345951, 0.0, 0.46135273664198945, 4.0,
            -1.4707431512941527, 3.6209602187058474, -0.9844158212941525, 5.0, -0.7999744012287345, 0.5999808009215509,
            0.007999744012287346, 4.0, -1.4707431512941527, 4.120960218705847, -0.9844158212941525, 5.0,
            -0.7068241080666424, 0.7068241080666424, 0.028272964322665697, 4.0, -1.4707431512941527, 3.6209602187058474,
            -0.9844158212941525, 5.0, -0.8872168012345951, 0.0, 0.46135273664198945, 4.0, -1.4707431512941527,
            3.6209602187058474, -0.9844158212941525, 5.0, -0.7961621941231025, 0.0, 0.6050832675335579, 4.0,
            -1.4707431512941527, 3.6209602187058474, -0.4844158212941525, 5.0, -0.7999744012287345, 0.5999808009215509,
            0.007999744012287346, 4.0, -1.4707431512941527, 4.120960218705847, -0.9844158212941525, 5.0,
            -0.7961621941231025, 0.0, 0.6050832675335579, 4.0, -1.4707431512941527, 3.6209602187058474,
            -0.4844158212941525, 5.0, -0.4028591660373982, 0.4028591660373982, 0.8218326987162923, 4.0,
            -1.4707431512941527, 4.120960218705847, -0.4844158212941525, 5.0, -0.7999744012287345, 0.5999808009215509,
            0.007999744012287346, 4.0, -1.4707431512941527, 4.120960218705847, -0.9844158212941525, 5.0,
            -0.7024085519692114, 0.0, 0.7117739993288009, 4.0, -0.9707431512941527, 3.6209602187058474,
            -0.4844158212941525, 5.0, -0.6931087162517845, 0.0, 0.720833064901856, 4.0, -0.9707431512941527,
            4.120960218705847, -0.4844158212941525, 5.0, -0.4028591660373982, 0.4028591660373982, 0.8218326987162923,
            4.0, -1.4707431512941527, 4.120960218705847, -0.4844158212941525, 5.0, -0.7961621941231025, 0.0,
            0.6050832675335579, 4.0, -1.4707431512941527, 3.6209602187058474, -0.4844158212941525, 5.0,
            -0.7024085519692114, 0.0, 0.7117739993288009, 4.0, -0.9707431512941527, 3.6209602187058474,
            -0.4844158212941525, 5.0, -0.4028591660373982, 0.4028591660373982, 0.8218326987162923, 4.0,
            -1.4707431512941527, 4.120960218705847, -0.4844158212941525, 5.0, -0.48850865146712424, 0.48850865146712424,
            -0.7229928041713439, 4.0, -0.9707431512941527, 4.120960218705847, -2.4844158212941525, 5.0,
            -0.6896715738353066, 0.6896715738353066, -0.2206949036272981, 4.0, -1.4707431512941527, 4.120960218705847,
            -1.9844158212941525, 5.0, 0.0, 0.9999680015359181, 0.007999744012287346, 4.0, -0.9707431512941527,
            4.120960218705847, -1.9844158212941525, 5.0, -0.6896715738353066, 0.6896715738353066, -0.2206949036272981,
            4.0, -1.4707431512941527, 4.120960218705847, -1.9844158212941525, 5.0, -0.5546660639791748,
            0.8319990959687623, 0.011093321279583498, 4.0, -1.4707431512941527, 4.120960218705847, -1.4844158212941525,
            5.0, -0.5586136967322369, 0.7448182623096493, -0.36496094853172817, 4.0, -0.9707431512941527,
            4.120960218705847, -1.4844158212941525, 5.0, 0.0, 0.9999680015359181, 0.007999744012287346, 4.0,
            -0.9707431512941527, 4.120960218705847, -1.9844158212941525, 5.0, -0.6896715738353066, 0.6896715738353066,
            -0.2206949036272981, 4.0, -1.4707431512941527, 4.120960218705847, -1.9844158212941525, 5.0,
            -0.5586136967322369, 0.7448182623096493, -0.36496094853172817, 4.0, -0.9707431512941527, 4.120960218705847,
            -1.4844158212941525, 5.0, -0.5546660639791748, 0.8319990959687623, 0.011093321279583498, 4.0,
            -1.4707431512941527, 4.120960218705847, -1.4844158212941525, 5.0, -0.7999744012287345, 0.5999808009215509,
            0.007999744012287346, 4.0, -1.4707431512941527, 4.120960218705847, -0.9844158212941525, 5.0,
            -0.7070753563134707, 0.7070753563134707, 0.009427671417512943, 4.0, -0.9707431512941527, 4.120960218705847,
            -0.9844158212941525, 5.0, -0.5586136967322369, 0.7448182623096493, -0.36496094853172817, 4.0,
            -0.9707431512941527, 4.120960218705847, -1.4844158212941525, 5.0, -0.5546660639791748, 0.8319990959687623,
            0.011093321279583498, 4.0, -1.4707431512941527, 4.120960218705847, -1.4844158212941525, 5.0,
            -0.7070753563134707, 0.7070753563134707, 0.009427671417512943, 4.0, -0.9707431512941527, 4.120960218705847,
            -0.9844158212941525, 5.0, -0.7999744012287345, 0.5999808009215509, 0.007999744012287346, 4.0,
            -1.4707431512941527, 4.120960218705847, -0.9844158212941525, 5.0, -0.4028591660373982, 0.4028591660373982,
            0.8218326987162923, 4.0, -1.4707431512941527, 4.120960218705847, -0.4844158212941525, 5.0,
            -0.6867740247905052, 0.6867740247905052, 0.23808166192737512, 4.0, -0.9707431512941527, 4.120960218705847,
            -0.4844158212941525, 5.0, -0.7070753563134707, 0.7070753563134707, 0.009427671417512943, 4.0,
            -0.9707431512941527, 4.120960218705847, -0.9844158212941525, 5.0, -0.7999744012287345, 0.5999808009215509,
            0.007999744012287346, 4.0, -1.4707431512941527, 4.120960218705847, -0.9844158212941525, 5.0,
            -0.6867740247905052, 0.6867740247905052, 0.23808166192737512, 4.0, -0.9707431512941527, 4.120960218705847,
            -0.4844158212941525, 5.0, -0.4028591660373982, 0.4028591660373982, 0.8218326987162923, 4.0,
            -1.4707431512941527, 4.120960218705847, -0.4844158212941525, 5.0, -0.6931087162517845, 0.0,
            0.720833064901856, 4.0, -0.9707431512941527, 4.120960218705847, -0.4844158212941525, 5.0,
            -0.6867740247905052, 0.6867740247905052, 0.23808166192737512, 4.0, -0.9707431512941527, 4.120960218705847,
            -0.4844158212941525, 5.0, -0.23086870333245033, -0.692606109997351, -0.6833713618640529, 4.0,
            -0.4707431512941527, 0.12096021870584739, -1.4844158212941525, 5.0, -0.42926582395046525,
            -0.8585316479009305, -0.2804536716476373, 4.0, -0.4707431512941527, -0.3790397812941526,
            -0.9844158212941525, 5.0, -0.6695894800069753, -0.6695894800069753, -0.3214029504033481, 4.0,
            -0.9707431512941527, 0.12096021870584739, -0.9844158212941525, 5.0, -0.42926582395046525,
            -0.8585316479009305, -0.2804536716476373, 4.0, -0.4707431512941527, -0.3790397812941526,
            -0.9844158212941525, 5.0, -0.514483650072292, -0.8574727501204867, 0.006859782000963894, 4.0,
            -0.4707431512941527, -0.3790397812941526, -0.4844158212941525, 5.0, -0.7070753563134707,
            -0.7070753563134707, 0.009427671417512943, 4.0, -0.9707431512941527, 0.12096021870584739,
            -0.4844158212941525, 5.0, -0.6695894800069753, -0.6695894800069753, -0.3214029504033481, 4.0,
            -0.9707431512941527, 0.12096021870584739, -0.9844158212941525, 5.0, -0.42926582395046525,
            -0.8585316479009305, -0.2804536716476373, 4.0, -0.4707431512941527, -0.3790397812941526,
            -0.9844158212941525, 5.0, -0.7070753563134707, -0.7070753563134707, 0.009427671417512943, 4.0,
            -0.9707431512941527, 0.12096021870584739, -0.4844158212941525, 5.0, -0.514483650072292, -0.8574727501204867,
            0.006859782000963894, 4.0, -0.4707431512941527, -0.3790397812941526, -0.4844158212941525, 5.0,
            -0.33038044729990595, -0.6607608945998119, 0.6739761124918081, 4.0, -0.4707431512941527,
            -0.3790397812941526, 0.015584178705847496, 5.0, -0.6636648415023736, -0.6636648415023736,
            0.34510571758123426, 4.0, -0.9707431512941527, 0.12096021870584739, 0.015584178705847496, 5.0,
            -0.7070753563134707, -0.7070753563134707, 0.009427671417512943, 4.0, -0.9707431512941527,
            0.12096021870584739, -0.4844158212941525, 5.0, -0.514483650072292, -0.8574727501204867,
            0.006859782000963894, 4.0, -0.4707431512941527, -0.3790397812941526, -0.4844158212941525, 5.0,
            -0.6636648415023736, -0.6636648415023736, 0.34510571758123426, 4.0, -0.9707431512941527,
            0.12096021870584739, 0.015584178705847496, 5.0, -0.33038044729990595, -0.6607608945998119,
            0.6739761124918081, 4.0, -0.4707431512941527, -0.3790397812941526, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0,
            4.0, -0.4707431512941527, 0.12096021870584739, 0.015584178705847496, 5.0, -0.6636648415023736,
            -0.6636648415023736, 0.34510571758123426, 4.0, -0.9707431512941527, 0.12096021870584739,
            0.015584178705847496, 5.0, -0.26841019599329863, -0.5368203919865973, -0.79986238406003, 4.0,
            -0.4707431512941527, 0.6209602187058474, -2.4844158212941525, 5.0, -0.2864118759732509, -0.8592356279197527,
            -0.4238895764404113, 4.0, -0.4707431512941527, 0.12096021870584739, -1.9844158212941525, 5.0,
            -0.5811989248480778, -0.5811989248480778, -0.5695749463511162, 4.0, -0.9707431512941527, 0.6209602187058474,
            -1.9844158212941525, 5.0, -0.5799161682232067, -0.5799161682232067, -0.5721839526468974, 4.0,
            -0.9707431512941527, 0.6209602187058474, -1.9844158212941525, 5.0, -0.5811989248480778, -0.5811989248480778,
            -0.5695749463511162, 4.0, -0.9707431512941527, 0.6209602187058474, -1.9844158212941525, 5.0,
            -0.2864118759732509, -0.8592356279197527, -0.4238895764404113, 4.0, -0.4707431512941527,
            0.12096021870584739, -1.9844158212941525, 5.0, -0.5799161682232067, -0.5799161682232067,
            -0.5721839526468974, 4.0, -0.9707431512941527, 0.6209602187058474, -1.9844158212941525, 5.0,
            -0.2864118759732509, -0.8592356279197527, -0.4238895764404113, 4.0, -0.4707431512941527,
            0.12096021870584739, -1.9844158212941525, 5.0, -0.5352800588583708, -0.8029200882875562,
            -0.2622872288406017, 4.0, -0.9707431512941527, 0.12096021870584739, -1.4844158212941525, 5.0,
            -0.5352800588583708, -0.8029200882875562, -0.2622872288406017, 4.0, -0.9707431512941527,
            0.12096021870584739, -1.4844158212941525, 5.0, -0.2864118759732509, -0.8592356279197527,
            -0.4238895764404113, 4.0, -0.4707431512941527, 0.12096021870584739, -1.9844158212941525, 5.0, 0.0,
            -0.9999111229612074, 0.013332148306149432, 4.0, -0.4707431512941527, 0.12096021870584739,
            -1.4844158212941525, 5.0, -0.6695894800069753, -0.6695894800069753, -0.3214029504033481, 4.0,
            -0.9707431512941527, 0.12096021870584739, -0.9844158212941525, 5.0, 0.0, -0.9999111229612074,
            0.013332148306149432, 4.0, -0.4707431512941527, 0.12096021870584739, -1.4844158212941525, 5.0,
            -0.23086870333245033, -0.692606109997351, -0.6833713618640529, 4.0, -0.4707431512941527,
            0.12096021870584739, -1.4844158212941525, 5.0, -0.6695894800069753, -0.6695894800069753,
            -0.3214029504033481, 4.0, -0.9707431512941527, 0.12096021870584739, -0.9844158212941525, 5.0,
            -0.5999808009215509, -0.7999744012287345, 0.007999744012287346, 4.0, -0.9707431512941527,
            0.12096021870584739, -0.9844158212941525, 5.0, 0.0, -0.9999111229612074, 0.013332148306149432, 4.0,
            -0.4707431512941527, 0.12096021870584739, -1.4844158212941525, 5.0, -0.5999808009215509,
            -0.7999744012287345, 0.007999744012287346, 4.0, -0.9707431512941527, 0.12096021870584739,
            -0.9844158212941525, 5.0, -0.5352800588583708, -0.8029200882875562, -0.2622872288406017, 4.0,
            -0.9707431512941527, 0.12096021870584739, -1.4844158212941525, 5.0, 0.0, -0.9999111229612074,
            0.013332148306149432, 4.0, -0.4707431512941527, 0.12096021870584739, -1.4844158212941525, 5.0,
            -0.7070753563134707, -0.7070753563134707, 0.009427671417512943, 4.0, -0.9707431512941527,
            0.12096021870584739, -0.4844158212941525, 5.0, -0.5999808009215509, -0.7999744012287345,
            0.007999744012287346, 4.0, -0.9707431512941527, 0.12096021870584739, -0.9844158212941525, 5.0,
            -0.6695894800069753, -0.6695894800069753, -0.3214029504033481, 4.0, -0.9707431512941527,
            0.12096021870584739, -0.9844158212941525, 5.0, -0.7070753563134707, -0.7070753563134707,
            0.009427671417512943, 4.0, -0.9707431512941527, 0.12096021870584739, -0.4844158212941525, 5.0,
            -0.5999808009215509, -0.7999744012287345, 0.007999744012287346, 4.0, -0.9707431512941527,
            0.12096021870584739, -0.9844158212941525, 5.0, -0.7070753563134707, -0.7070753563134707,
            0.009427671417512943, 4.0, -0.9707431512941527, 0.12096021870584739, -0.4844158212941525, 5.0,
            -0.6636648415023736, -0.6636648415023736, 0.34510571758123426, 4.0, -0.9707431512941527,
            0.12096021870584739, 0.015584178705847496, 5.0, -0.7070753563134707, -0.7070753563134707,
            0.009427671417512943, 4.0, -0.9707431512941527, 0.12096021870584739, -0.4844158212941525, 5.0,
            -0.7070753563134707, -0.7070753563134707, 0.009427671417512943, 4.0, -0.9707431512941527,
            0.12096021870584739, -0.4844158212941525, 5.0, -0.4028591660373982, -0.4028591660373982, 0.8218326987162923,
            4.0, -0.9707431512941527, 0.12096021870584739, 0.015584178705847496, 5.0, -0.7070753563134707,
            -0.7070753563134707, 0.009427671417512943, 4.0, -0.9707431512941527, 0.12096021870584739,
            -0.4844158212941525, 5.0, -0.6636648415023736, -0.6636648415023736, 0.34510571758123426, 4.0,
            -0.9707431512941527, 0.12096021870584739, 0.015584178705847496, 5.0, -0.4028591660373982,
            -0.4028591660373982, 0.8218326987162923, 4.0, -0.9707431512941527, 0.12096021870584739,
            0.015584178705847496, 5.0, -0.6636648415023736, -0.6636648415023736, 0.34510571758123426, 4.0,
            -0.9707431512941527, 0.12096021870584739, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.4707431512941527, 0.12096021870584739, 0.015584178705847496, 5.0, -0.4028591660373982,
            -0.4028591660373982, 0.8218326987162923, 4.0, -0.9707431512941527, 0.12096021870584739,
            0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 0.12096021870584739,
            0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, -0.9707431512941527, 0.6209602187058474,
            0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, -0.9707431512941527, 0.6209602187058474,
            0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 0.12096021870584739,
            0.015584178705847496, 5.0, -0.4240792104664812, -0.6361188156997218, 0.6446003999090515, 4.0,
            -0.4707431512941527, 0.6209602187058474, 0.015584178705847496, 5.0, -0.5811989248480778,
            -0.5811989248480778, -0.5695749463511162, 4.0, -0.9707431512941527, 0.6209602187058474, -1.9844158212941525,
            5.0, -0.5850454715011363, -0.5850454715011363, -0.5616436526410908, 4.0, -0.9707431512941527,
            0.6209602187058474, -1.9844158212941525, 5.0, -0.4892356456317602, -0.32615709708784013,
            -0.8088696007778434, 4.0, -0.9707431512941527, 1.1209602187058474, -2.4844158212941525, 5.0,
            -0.5811989248480778, -0.5811989248480778, -0.5695749463511162, 4.0, -0.9707431512941527, 0.6209602187058474,
            -1.9844158212941525, 5.0, -0.4892356456317602, -0.32615709708784013, -0.8088696007778434, 4.0,
            -0.9707431512941527, 1.1209602187058474, -2.4844158212941525, 5.0, -0.26841019599329863,
            -0.5368203919865973, -0.79986238406003, 4.0, -0.4707431512941527, 0.6209602187058474, -2.4844158212941525,
            5.0, -0.26841019599329863, -0.5368203919865973, -0.79986238406003, 4.0, -0.4707431512941527,
            0.6209602187058474, -2.4844158212941525, 5.0, -0.4892356456317602, -0.32615709708784013,
            -0.8088696007778434, 4.0, -0.9707431512941527, 1.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0,
            4.0, -0.4707431512941527, 1.1209602187058474, -2.4844158212941525, 5.0, -0.5811989248480778,
            -0.5811989248480778, -0.5695749463511162, 4.0, -0.9707431512941527, 0.6209602187058474, -1.9844158212941525,
            5.0, -0.5799161682232067, -0.5799161682232067, -0.5721839526468974, 4.0, -0.9707431512941527,
            0.6209602187058474, -1.9844158212941525, 5.0, -0.5850454715011363, -0.5850454715011363, -0.5616436526410908,
            4.0, -0.9707431512941527, 0.6209602187058474, -1.9844158212941525, 5.0, -0.6636648415023736,
            -0.6636648415023736, 0.34510571758123426, 4.0, -0.9707431512941527, 1.1209602187058474, 0.5155841787058475,
            5.0, -0.4240792104664812, -0.6361188156997218, 0.6446003999090515, 4.0, -0.4707431512941527,
            0.6209602187058474, 0.015584178705847496, 5.0, -0.22797089745144278, -0.6839126923543284,
            0.6930315282523861, 4.0, -0.4707431512941527, 0.6209602187058474, 0.5155841787058475, 5.0,
            -0.6636648415023736, -0.6636648415023736, 0.34510571758123426, 4.0, -0.9707431512941527, 1.1209602187058474,
            0.5155841787058475, 5.0, -0.33038044729990595, -0.6607608945998119, 0.6739761124918081, 4.0,
            -0.9707431512941527, 1.1209602187058474, 0.015584178705847496, 5.0, -0.4240792104664812,
            -0.6361188156997218, 0.6446003999090515, 4.0, -0.4707431512941527, 0.6209602187058474, 0.015584178705847496,
            5.0, -0.33038044729990595, -0.6607608945998119, 0.6739761124918081, 4.0, -0.9707431512941527,
            1.1209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, -0.9707431512941527, 0.6209602187058474,
            0.015584178705847496, 5.0, -0.4240792104664812, -0.6361188156997218, 0.6446003999090515, 4.0,
            -0.4707431512941527, 0.6209602187058474, 0.015584178705847496, 5.0, -0.22797089745144278,
            -0.6839126923543284, 0.6930315282523861, 4.0, -0.4707431512941527, 0.6209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 1.1209602187058474, 0.5155841787058475, 5.0,
            -0.6636648415023736, -0.6636648415023736, 0.34510571758123426, 4.0, -0.9707431512941527, 1.1209602187058474,
            0.5155841787058475, 5.0, -0.43067900206843196, -0.287119334712288, -0.8556156174426182, 4.0,
            -0.4707431512941527, 1.6209602187058474, -2.9844158212941525, 5.0, -0.5850454715011363, -0.5850454715011363,
            -0.5616436526410908, 4.0, -0.4707431512941527, 1.1209602187058474, -2.4844158212941525, 5.0,
            -0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0, -0.9707431512941527, 1.6209602187058474,
            -2.4844158212941525, 5.0, -0.5850454715011363, -0.5850454715011363, -0.5616436526410908, 4.0,
            -0.4707431512941527, 1.1209602187058474, -2.4844158212941525, 5.0, -0.6038576879954624, 0.0,
            -0.7970921481540103, 4.0, -0.9707431512941527, 1.6209602187058474, -2.4844158212941525, 5.0,
            -0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0, -0.9707431512941527, 1.6209602187058474,
            -2.4844158212941525, 5.0, -0.5850454715011363, -0.5850454715011363, -0.5616436526410908, 4.0,
            -0.4707431512941527, 1.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, -0.4707431512941527,
            1.1209602187058474, -2.4844158212941525, 5.0, -0.6038576879954624, 0.0, -0.7970921481540103, 4.0,
            -0.9707431512941527, 1.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, -0.4707431512941527,
            1.1209602187058474, -2.4844158212941525, 5.0, -0.4892356456317602, -0.32615709708784013,
            -0.8088696007778434, 4.0, -0.9707431512941527, 1.1209602187058474, -2.4844158212941525, 5.0,
            -0.6038576879954624, 0.0, -0.7970921481540103, 4.0, -0.9707431512941527, 1.6209602187058474,
            -2.4844158212941525, 5.0, -0.6636648415023736, -0.6636648415023736, 0.34510571758123426, 4.0,
            -0.9707431512941527, 1.1209602187058474, 0.5155841787058475, 5.0, -0.2649845836453722, -0.5299691672907444,
            0.8055531342819315, 4.0, -0.9707431512941527, 1.1209602187058474, 0.5155841787058475, 5.0,
            -0.33038044729990595, -0.6607608945998119, 0.6739761124918081, 4.0, -0.9707431512941527, 1.1209602187058474,
            0.015584178705847496, 5.0, -0.2649845836453722, -0.5299691672907444, 0.8055531342819315, 4.0,
            -0.9707431512941527, 1.1209602187058474, 0.5155841787058475, 5.0, -0.6636648415023736, -0.6636648415023736,
            0.34510571758123426, 4.0, -0.9707431512941527, 1.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0,
            4.0, -0.4707431512941527, 1.1209602187058474, 0.5155841787058475, 5.0, -0.2649845836453722,
            -0.5299691672907444, 0.8055531342819315, 4.0, -0.9707431512941527, 1.1209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 1.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0,
            4.0, -0.9707431512941527, 1.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.9707431512941527, 1.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527,
            1.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 1.6209602187058474,
            0.5155841787058475, 5.0, -0.48850865146712424, 0.48850865146712424, -0.7229928041713439, 4.0,
            -0.4707431512941527, 2.1209602187058474, -2.9844158212941525, 5.0, -0.43067900206843196, -0.287119334712288,
            -0.8556156174426182, 4.0, -0.4707431512941527, 1.6209602187058474, -2.9844158212941525, 5.0,
            -0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0, -0.9707431512941527, 1.6209602187058474,
            -2.4844158212941525, 5.0, -0.4137462706113611, 0.4137462706113611, -0.8109426903982677, 4.0,
            -0.9707431512941527, 2.1209602187058474, -2.4844158212941525, 5.0, -0.48850865146712424,
            0.48850865146712424, -0.7229928041713439, 4.0, -0.4707431512941527, 2.1209602187058474, -2.9844158212941525,
            5.0, -0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0, -0.9707431512941527,
            1.6209602187058474, -2.4844158212941525, 5.0, -0.692606109997351, -0.23086870333245033, -0.6833713618640529,
            4.0, -0.9707431512941527, 1.6209602187058474, -2.4844158212941525, 5.0, -0.6038576879954624, 0.0,
            -0.7970921481540103, 4.0, -0.9707431512941527, 2.1209602187058474, -2.4844158212941525, 5.0,
            -0.4137462706113611, 0.4137462706113611, -0.8109426903982677, 4.0, -0.9707431512941527, 2.1209602187058474,
            -2.4844158212941525, 5.0, -0.6038576879954624, 0.0, -0.7970921481540103, 4.0, -0.9707431512941527,
            1.6209602187058474, -2.4844158212941525, 5.0, -0.6038576879954624, 0.0, -0.7970921481540103, 4.0,
            -0.9707431512941527, 2.1209602187058474, -2.4844158212941525, 5.0, -0.692606109997351, -0.23086870333245033,
            -0.6833713618640529, 4.0, -0.9707431512941527, 1.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, 1.0,
            4.0, -0.4707431512941527, 1.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.4707431512941527, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.9707431512941527,
            1.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 2.1209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.9707431512941527, 2.1209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, -0.9707431512941527, 1.6209602187058474, 0.5155841787058475, 5.0,
            -0.48850865146712424, 0.48850865146712424, -0.7229928041713439, 4.0, -0.4707431512941527,
            2.1209602187058474, -2.9844158212941525, 5.0, -0.4137462706113611, 0.4137462706113611, -0.8109426903982677,
            4.0, -0.9707431512941527, 2.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.711836432832338,
            -0.7023452803945736, 4.0, -0.4707431512941527, 2.1209602187058474, -2.4844158212941525, 5.0,
            -0.4137462706113611, 0.4137462706113611, -0.8109426903982677, 4.0, -0.9707431512941527, 2.1209602187058474,
            -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, -0.4707431512941527, 2.6209602187058474, -2.4844158212941525,
            5.0, 0.0, 0.711836432832338, -0.7023452803945736, 4.0, -0.4707431512941527, 2.1209602187058474,
            -2.4844158212941525, 5.0, -0.4137462706113611, 0.4137462706113611, -0.8109426903982677, 4.0,
            -0.9707431512941527, 2.1209602187058474, -2.4844158212941525, 5.0, -0.6038576879954624, 0.0,
            -0.7970921481540103, 4.0, -0.9707431512941527, 2.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0,
            4.0, -0.4707431512941527, 2.6209602187058474, -2.4844158212941525, 5.0, -0.6038576879954624, 0.0,
            -0.7970921481540103, 4.0, -0.9707431512941527, 2.1209602187058474, -2.4844158212941525, 5.0,
            -0.44960990782659727, 0.0, -0.8932250168821733, 4.0, -0.9707431512941527, 2.6209602187058474,
            -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, -0.4707431512941527, 2.6209602187058474, -2.4844158212941525,
            5.0, -0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, -0.9707431512941527,
            2.1209602187058474, 0.5155841787058475, 5.0, -0.5696549391872194, 0.5696549391872194, 0.5924411367547082,
            4.0, -0.9707431512941527, 2.6209602187058474, 0.5155841787058475, 5.0, -0.5696549391872194,
            0.5696549391872194, 0.5924411367547082, 4.0, -0.9707431512941527, 2.6209602187058474, 0.015584178705847496,
            5.0, -0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, -0.9707431512941527,
            2.6209602187058474, 0.5155841787058475, 5.0, -0.5735016055486672, 0.5735016055486672, 0.5849716376596406,
            4.0, -0.9707431512941527, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.9707431512941527, 2.1209602187058474, 0.5155841787058475, 5.0, -0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, -0.9707431512941527, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0,
            4.0, -0.9707431512941527, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.4707431512941527, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527,
            2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.9707431512941527, 2.1209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 2.1209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, -1.0, 4.0, -0.4707431512941527, 2.6209602187058474, -2.4844158212941525, 5.0,
            -0.44960990782659727, 0.0, -0.8932250168821733, 4.0, -0.9707431512941527, 2.6209602187058474,
            -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, -0.4707431512941527, 3.1209602187058474, -2.4844158212941525,
            5.0, 0.0, 0.0, -1.0, 4.0, -0.4707431512941527, 3.1209602187058474, -2.4844158212941525, 5.0,
            -0.44960990782659727, 0.0, -0.8932250168821733, 4.0, -0.9707431512941527, 2.6209602187058474,
            -2.4844158212941525, 5.0, -0.44960990782659727, 0.0, -0.8932250168821733, 4.0, -0.9707431512941527,
            3.1209602187058474, -2.4844158212941525, 5.0, -0.5747843685791867, 0.5747843685791867, 0.5824481601602425,
            4.0, -0.9707431512941527, 2.6209602187058474, 0.015584178705847496, 5.0, -0.6839126923543284,
            0.22797089745144278, 0.6930315282523861, 4.0, -0.9707431512941527, 3.1209602187058474, 0.015584178705847496,
            5.0, -0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0, -0.9707431512941527,
            3.1209602187058474, -0.4844158212941525, 5.0, -0.6839126923543284, 0.22797089745144278, 0.6930315282523861,
            4.0, -0.9707431512941527, 3.1209602187058474, 0.015584178705847496, 5.0, -0.22797089745144278,
            0.6839126923543284, 0.6930315282523861, 4.0, -0.4707431512941527, 2.6209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.3920259246081505, 0.9199541697471265, 4.0, -0.4707431512941527, 3.1209602187058474,
            0.015584178705847496, 5.0, -0.5747843685791867, 0.5747843685791867, 0.5824481601602425, 4.0,
            -0.9707431512941527, 2.6209602187058474, 0.015584178705847496, 5.0, -0.22797089745144278,
            0.6839126923543284, 0.6930315282523861, 4.0, -0.4707431512941527, 2.6209602187058474, 0.5155841787058475,
            5.0, -0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0, -0.9707431512941527,
            3.1209602187058474, 0.015584178705847496, 5.0, -0.5747843685791867, 0.5747843685791867, 0.5824481601602425,
            4.0, -0.9707431512941527, 2.6209602187058474, 0.015584178705847496, 5.0, -0.5696549391872194,
            0.5696549391872194, 0.5924411367547082, 4.0, -0.9707431512941527, 2.6209602187058474, 0.5155841787058475,
            5.0, -0.22797089745144278, 0.6839126923543284, 0.6930315282523861, 4.0, -0.4707431512941527,
            2.6209602187058474, 0.5155841787058475, 5.0, -0.5747843685791867, 0.5747843685791867, 0.5824481601602425,
            4.0, -0.9707431512941527, 2.6209602187058474, 0.015584178705847496, 5.0, -0.5696549391872194,
            0.5696549391872194, 0.5924411367547082, 4.0, -0.9707431512941527, 2.6209602187058474, 0.015584178705847496,
            5.0, -0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, -0.9707431512941527,
            2.6209602187058474, 0.5155841787058475, 5.0, -0.5696549391872194, 0.5696549391872194, 0.5924411367547082,
            4.0, -0.9707431512941527, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.4707431512941527, 2.6209602187058474, 0.5155841787058475, 5.0, -0.22797089745144278, 0.6839126923543284,
            0.6930315282523861, 4.0, -0.4707431512941527, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, -1.0,
            4.0, -0.4707431512941527, 3.1209602187058474, -2.4844158212941525, 5.0, -0.44960990782659727, 0.0,
            -0.8932250168821733, 4.0, -0.9707431512941527, 3.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0,
            4.0, -0.4707431512941527, 3.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0,
            -0.4707431512941527, 3.6209602187058474, -2.4844158212941525, 5.0, -0.44960990782659727, 0.0,
            -0.8932250168821733, 4.0, -0.9707431512941527, 3.1209602187058474, -2.4844158212941525, 5.0,
            -0.44960990782659727, 0.0, -0.8932250168821733, 4.0, -0.9707431512941527, 3.6209602187058474,
            -2.4844158212941525, 5.0, -0.7024085519692114, 0.0, 0.7117739993288009, 4.0, -0.9707431512941527,
            3.6209602187058474, 0.015584178705847496, 5.0, -0.6839126923543284, 0.22797089745144278, 0.6930315282523861,
            4.0, -0.9707431512941527, 3.1209602187058474, -0.4844158212941525, 5.0, -0.6839126923543284,
            0.22797089745144278, 0.6930315282523861, 4.0, -0.9707431512941527, 3.1209602187058474, 0.015584178705847496,
            5.0, -0.7024085519692114, 0.0, 0.7117739993288009, 4.0, -0.9707431512941527, 3.6209602187058474,
            -0.4844158212941525, 5.0, -0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0,
            -0.9707431512941527, 3.1209602187058474, -0.4844158212941525, 5.0, -0.7024085519692114, 0.0,
            0.7117739993288009, 4.0, -0.9707431512941527, 3.6209602187058474, 0.015584178705847496, 5.0, 0.0,
            0.3920259246081505, 0.9199541697471265, 4.0, -0.4707431512941527, 3.1209602187058474, 0.015584178705847496,
            5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 3.6209602187058474, 0.015584178705847496, 5.0,
            -0.7024085519692114, 0.0, 0.7117739993288009, 4.0, -0.9707431512941527, 3.6209602187058474,
            0.015584178705847496, 5.0, -0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0,
            -0.9707431512941527, 3.1209602187058474, 0.015584178705847496, 5.0, 0.0, 0.3920259246081505,
            0.9199541697471265, 4.0, -0.4707431512941527, 3.1209602187058474, 0.015584178705847496, 5.0,
            -0.7024085519692114, 0.0, 0.7117739993288009, 4.0, -0.9707431512941527, 3.6209602187058474,
            0.015584178705847496, 5.0, 0.0, 0.0, -1.0, 4.0, -0.4707431512941527, 3.6209602187058474,
            -2.4844158212941525, 5.0, -0.44960990782659727, 0.0, -0.8932250168821733, 4.0, -0.9707431512941527,
            3.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.711836432832338, -0.7023452803945736, 4.0,
            -0.4707431512941527, 4.120960218705847, -2.4844158212941525, 5.0, 0.0, 0.711836432832338,
            -0.7023452803945736, 4.0, -0.4707431512941527, 4.120960218705847, -2.4844158212941525, 5.0,
            -0.44960990782659727, 0.0, -0.8932250168821733, 4.0, -0.9707431512941527, 3.6209602187058474,
            -2.4844158212941525, 5.0, -0.48850865146712424, 0.48850865146712424, -0.7229928041713439, 4.0,
            -0.9707431512941527, 4.120960218705847, -2.4844158212941525, 5.0, -0.6607608945998119, 0.33038044729990595,
            0.6739761124918081, 4.0, -0.9707431512941527, 4.120960218705847, 0.015584178705847496, 5.0,
            -0.7024085519692114, 0.0, 0.7117739993288009, 4.0, -0.9707431512941527, 3.6209602187058474,
            -0.4844158212941525, 5.0, -0.7024085519692114, 0.0, 0.7117739993288009, 4.0, -0.9707431512941527,
            3.6209602187058474, 0.015584178705847496, 5.0, -0.6931087162517845, 0.0, 0.720833064901856, 4.0,
            -0.9707431512941527, 4.120960218705847, -0.4844158212941525, 5.0, -0.7024085519692114, 0.0,
            0.7117739993288009, 4.0, -0.9707431512941527, 3.6209602187058474, -0.4844158212941525, 5.0,
            -0.6607608945998119, 0.33038044729990595, 0.6739761124918081, 4.0, -0.9707431512941527, 4.120960218705847,
            0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 3.6209602187058474,
            0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 4.120960218705847, 0.015584178705847496,
            5.0, -0.6607608945998119, 0.33038044729990595, 0.6739761124918081, 4.0, -0.9707431512941527,
            4.120960218705847, 0.015584178705847496, 5.0, -0.7024085519692114, 0.0, 0.7117739993288009, 4.0,
            -0.9707431512941527, 3.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527,
            3.6209602187058474, 0.015584178705847496, 5.0, -0.6607608945998119, 0.33038044729990595, 0.6739761124918081,
            4.0, -0.9707431512941527, 4.120960218705847, 0.015584178705847496, 5.0, 0.0, 0.711836432832338,
            -0.7023452803945736, 4.0, -0.4707431512941527, 4.120960218705847, -2.4844158212941525, 5.0,
            -0.48850865146712424, 0.48850865146712424, -0.7229928041713439, 4.0, -0.9707431512941527, 4.120960218705847,
            -2.4844158212941525, 5.0, 0.0, 0.9999680015359181, 0.007999744012287346, 4.0, -0.9707431512941527,
            4.120960218705847, -1.9844158212941525, 5.0, -0.19702148297518723, 0.7880859319007489, -0.5831835896065543,
            4.0, -0.4707431512941527, 4.120960218705847, -1.9844158212941525, 5.0, 0.0, 0.711836432832338,
            -0.7023452803945736, 4.0, -0.4707431512941527, 4.120960218705847, -2.4844158212941525, 5.0, 0.0,
            0.9999680015359181, 0.007999744012287346, 4.0, -0.9707431512941527, 4.120960218705847, -1.9844158212941525,
            5.0, -0.48850865146712424, 0.48850865146712424, -0.7229928041713439, 4.0, -0.4707431512941527,
            4.620960218705847, -1.9844158212941525, 5.0, -0.5586136967322369, 0.7448182623096493, -0.36496094853172817,
            4.0, -0.9707431512941527, 4.120960218705847, -1.4844158212941525, 5.0, -0.6896715738353066,
            0.6896715738353066, -0.2206949036272981, 4.0, -0.9707431512941527, 4.620960218705847, -1.4844158212941525,
            5.0, -0.48850865146712424, 0.48850865146712424, -0.7229928041713439, 4.0, -0.4707431512941527,
            4.620960218705847, -1.9844158212941525, 5.0, -0.19702148297518723, 0.7880859319007489, -0.5831835896065543,
            4.0, -0.4707431512941527, 4.120960218705847, -1.9844158212941525, 5.0, -0.5586136967322369,
            0.7448182623096493, -0.36496094853172817, 4.0, -0.9707431512941527, 4.120960218705847, -1.4844158212941525,
            5.0, -0.19702148297518723, 0.7880859319007489, -0.5831835896065543, 4.0, -0.4707431512941527,
            4.120960218705847, -1.9844158212941525, 5.0, 0.0, 0.9999680015359181, 0.007999744012287346, 4.0,
            -0.9707431512941527, 4.120960218705847, -1.9844158212941525, 5.0, -0.5586136967322369, 0.7448182623096493,
            -0.36496094853172817, 4.0, -0.9707431512941527, 4.120960218705847, -1.4844158212941525, 5.0,
            -0.7070753563134707, 0.7070753563134707, 0.009427671417512943, 4.0, -0.9707431512941527, 4.120960218705847,
            -0.9844158212941525, 5.0, -0.6896715738353066, 0.6896715738353066, -0.2206949036272981, 4.0,
            -0.9707431512941527, 4.620960218705847, -1.4844158212941525, 5.0, -0.5586136967322369, 0.7448182623096493,
            -0.36496094853172817, 4.0, -0.9707431512941527, 4.120960218705847, -1.4844158212941525, 5.0,
            -0.7070753563134707, 0.7070753563134707, 0.009427671417512943, 4.0, -0.9707431512941527, 4.620960218705847,
            -0.9844158212941525, 5.0, -0.6896715738353066, 0.6896715738353066, -0.2206949036272981, 4.0,
            -0.9707431512941527, 4.620960218705847, -1.4844158212941525, 5.0, -0.7070753563134707, 0.7070753563134707,
            0.009427671417512943, 4.0, -0.9707431512941527, 4.120960218705847, -0.9844158212941525, 5.0,
            -0.6867740247905052, 0.6867740247905052, 0.23808166192737512, 4.0, -0.9707431512941527, 4.120960218705847,
            -0.4844158212941525, 5.0, -0.7070753563134707, 0.7070753563134707, 0.009427671417512943, 4.0,
            -0.9707431512941527, 4.620960218705847, -0.9844158212941525, 5.0, -0.7070753563134707, 0.7070753563134707,
            0.009427671417512943, 4.0, -0.9707431512941527, 4.120960218705847, -0.9844158212941525, 5.0,
            -0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, -0.9707431512941527, 4.620960218705847,
            -0.4844158212941525, 5.0, -0.7070753563134707, 0.7070753563134707, 0.009427671417512943, 4.0,
            -0.9707431512941527, 4.620960218705847, -0.9844158212941525, 5.0, -0.6867740247905052, 0.6867740247905052,
            0.23808166192737512, 4.0, -0.9707431512941527, 4.120960218705847, -0.4844158212941525, 5.0,
            -0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, -0.9707431512941527, 4.620960218705847,
            -0.4844158212941525, 5.0, -0.22797089745144278, 0.6839126923543284, 0.6930315282523861, 4.0,
            -0.4707431512941527, 4.120960218705847, 0.015584178705847496, 5.0, 0.0, 0.7024085519692114,
            0.7117739993288009, 4.0, -0.4707431512941527, 4.620960218705847, -0.4844158212941525, 5.0,
            -0.6867740247905052, 0.6867740247905052, 0.23808166192737512, 4.0, -0.9707431512941527, 4.120960218705847,
            -0.4844158212941525, 5.0, -0.22797089745144278, 0.6839126923543284, 0.6930315282523861, 4.0,
            -0.4707431512941527, 4.120960218705847, 0.015584178705847496, 5.0, -0.5735016055486672, 0.5735016055486672,
            0.5849716376596406, 4.0, -0.9707431512941527, 4.620960218705847, -0.4844158212941525, 5.0,
            -0.6867740247905052, 0.6867740247905052, 0.23808166192737512, 4.0, -0.9707431512941527, 4.120960218705847,
            -0.4844158212941525, 5.0, -0.6607608945998119, 0.33038044729990595, 0.6739761124918081, 4.0,
            -0.9707431512941527, 4.120960218705847, 0.015584178705847496, 5.0, -0.22797089745144278, 0.6839126923543284,
            0.6930315282523861, 4.0, -0.4707431512941527, 4.120960218705847, 0.015584178705847496, 5.0,
            -0.6867740247905052, 0.6867740247905052, 0.23808166192737512, 4.0, -0.9707431512941527, 4.120960218705847,
            -0.4844158212941525, 5.0, -0.6931087162517845, 0.0, 0.720833064901856, 4.0, -0.9707431512941527,
            4.120960218705847, -0.4844158212941525, 5.0, -0.6607608945998119, 0.33038044729990595, 0.6739761124918081,
            4.0, -0.9707431512941527, 4.120960218705847, 0.015584178705847496, 5.0, -0.6607608945998119,
            0.33038044729990595, 0.6739761124918081, 4.0, -0.9707431512941527, 4.120960218705847, 0.015584178705847496,
            5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 4.120960218705847, 0.015584178705847496, 5.0,
            -0.22797089745144278, 0.6839126923543284, 0.6930315282523861, 4.0, -0.4707431512941527, 4.120960218705847,
            0.015584178705847496, 5.0, -0.48850865146712424, 0.48850865146712424, -0.7229928041713439, 4.0,
            -0.4707431512941527, 4.620960218705847, -1.9844158212941525, 5.0, -0.6896715738353066, 0.6896715738353066,
            -0.2206949036272981, 4.0, -0.9707431512941527, 4.620960218705847, -1.4844158212941525, 5.0, 0.0,
            0.999977778518491, 0.006666518523456607, 4.0, -0.4707431512941527, 4.620960218705847, -1.4844158212941525,
            5.0, -0.6896715738353066, 0.6896715738353066, -0.2206949036272981, 4.0, -0.9707431512941527,
            4.620960218705847, -1.4844158212941525, 5.0, -0.7070753563134707, 0.7070753563134707, 0.009427671417512943,
            4.0, -0.9707431512941527, 4.620960218705847, -0.9844158212941525, 5.0, 0.0, 0.999977778518491,
            0.006666518523456607, 4.0, -0.4707431512941527, 4.620960218705847, -0.9844158212941525, 5.0, 0.0,
            0.999977778518491, 0.006666518523456607, 4.0, -0.4707431512941527, 4.620960218705847, -1.4844158212941525,
            5.0, -0.6896715738353066, 0.6896715738353066, -0.2206949036272981, 4.0, -0.9707431512941527,
            4.620960218705847, -1.4844158212941525, 5.0, 0.0, 0.999977778518491, 0.006666518523456607, 4.0,
            -0.4707431512941527, 4.620960218705847, -0.9844158212941525, 5.0, -0.7070753563134707, 0.7070753563134707,
            0.009427671417512943, 4.0, -0.9707431512941527, 4.620960218705847, -0.9844158212941525, 5.0,
            -0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, -0.9707431512941527, 4.620960218705847,
            -0.4844158212941525, 5.0, 0.0, 0.9999111229612074, 0.013332148306149432, 4.0, -0.4707431512941527,
            4.620960218705847, -0.4844158212941525, 5.0, 0.0, 0.999977778518491, 0.006666518523456607, 4.0,
            -0.4707431512941527, 4.620960218705847, -0.9844158212941525, 5.0, -0.7070753563134707, 0.7070753563134707,
            0.009427671417512943, 4.0, -0.9707431512941527, 4.620960218705847, -0.9844158212941525, 5.0, 0.0,
            0.9999111229612074, 0.013332148306149432, 4.0, -0.4707431512941527, 4.620960218705847, -0.4844158212941525,
            5.0, -0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, -0.9707431512941527,
            4.620960218705847, -0.4844158212941525, 5.0, 0.0, 0.7024085519692114, 0.7117739993288009, 4.0,
            -0.4707431512941527, 4.620960218705847, -0.4844158212941525, 5.0, 0.0, 0.9999111229612074,
            0.013332148306149432, 4.0, -0.4707431512941527, 4.620960218705847, -0.4844158212941525, 5.0,
            0.5850454715011363, -0.5850454715011363, -0.5616436526410908, 4.0, 0.029256848705847327,
            -0.3790397812941526, -0.4844158212941525, 5.0, 0.0, -0.9992009587217893, 0.03996803834887161, 4.0,
            0.029256848705847327, -0.8790397812941526, 0.015584178705847496, 5.0, -0.7068241080666424,
            -0.7068241080666424, 0.02827296432266572, 4.0, -0.4707431512941527, -0.3790397812941526,
            0.015584178705847496, 5.0, 0.0, -0.9992009587217893, 0.03996803834887161, 4.0, 0.029256848705847327,
            -0.8790397812941526, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327,
            -0.3790397812941526, 0.015584178705847496, 5.0, -0.7068241080666424, -0.7068241080666424,
            0.02827296432266572, 4.0, -0.4707431512941527, -0.3790397812941526, 0.015584178705847496, 5.0,
            -0.23086870333245033, -0.692606109997351, -0.6833713618640529, 4.0, -0.4707431512941527,
            0.12096021870584739, -1.4844158212941525, 5.0, 0.0, -0.711836432832338, -0.7023452803945736, 4.0,
            0.029256848705847327, 0.12096021870584739, -1.4844158212941525, 5.0, 0.0, -0.8605150974154714,
            -0.5094249376699591, 4.0, 0.029256848705847327, -0.3790397812941526, -0.9844158212941525, 5.0,
            -0.42926582395046525, -0.8585316479009305, -0.2804536716476373, 4.0, -0.4707431512941527,
            -0.3790397812941526, -0.9844158212941525, 5.0, -0.23086870333245033, -0.692606109997351,
            -0.6833713618640529, 4.0, -0.4707431512941527, 0.12096021870584739, -1.4844158212941525, 5.0, 0.0,
            -0.8605150974154714, -0.5094249376699591, 4.0, 0.029256848705847327, -0.3790397812941526,
            -0.9844158212941525, 5.0, 0.0, -0.8605150974154714, -0.5094249376699591, 4.0, 0.029256848705847327,
            -0.3790397812941526, -0.9844158212941525, 5.0, 0.4068807567358935, -0.813761513471787, 0.4150183718706114,
            4.0, 0.029256848705847327, -0.3790397812941526, -0.4844158212941525, 5.0, -0.42926582395046525,
            -0.8585316479009305, -0.2804536716476373, 4.0, -0.4707431512941527, -0.3790397812941526,
            -0.9844158212941525, 5.0, -0.42926582395046525, -0.8585316479009305, -0.2804536716476373, 4.0,
            -0.4707431512941527, -0.3790397812941526, -0.9844158212941525, 5.0, 0.4068807567358935, -0.813761513471787,
            0.4150183718706114, 4.0, 0.029256848705847327, -0.3790397812941526, -0.4844158212941525, 5.0,
            -0.514483650072292, -0.8574727501204867, 0.006859782000963894, 4.0, -0.4707431512941527,
            -0.3790397812941526, -0.4844158212941525, 5.0, -0.7068241080666424, -0.7068241080666424,
            0.02827296432266572, 4.0, -0.4707431512941527, -0.3790397812941526, 0.015584178705847496, 5.0,
            0.4068807567358935, -0.813761513471787, 0.4150183718706114, 4.0, 0.029256848705847327, -0.3790397812941526,
            -0.4844158212941525, 5.0, 0.5850454715011363, -0.5850454715011363, -0.5616436526410908, 4.0,
            0.029256848705847327, -0.3790397812941526, -0.4844158212941525, 5.0, -0.7068241080666424,
            -0.7068241080666424, 0.02827296432266572, 4.0, -0.4707431512941527, -0.3790397812941526,
            0.015584178705847496, 5.0, -0.33038044729990595, -0.6607608945998119, 0.6739761124918081, 4.0,
            -0.4707431512941527, -0.3790397812941526, 0.015584178705847496, 5.0, 0.4068807567358935, -0.813761513471787,
            0.4150183718706114, 4.0, 0.029256848705847327, -0.3790397812941526, -0.4844158212941525, 5.0,
            -0.33038044729990595, -0.6607608945998119, 0.6739761124918081, 4.0, -0.4707431512941527,
            -0.3790397812941526, 0.015584178705847496, 5.0, -0.514483650072292, -0.8574727501204867,
            0.006859782000963894, 4.0, -0.4707431512941527, -0.3790397812941526, -0.4844158212941525, 5.0,
            0.4068807567358935, -0.813761513471787, 0.4150183718706114, 4.0, 0.029256848705847327, -0.3790397812941526,
            -0.4844158212941525, 5.0, -0.33038044729990595, -0.6607608945998119, 0.6739761124918081, 4.0,
            -0.4707431512941527, -0.3790397812941526, 0.015584178705847496, 5.0, -0.7068241080666424,
            -0.7068241080666424, 0.02827296432266572, 4.0, -0.4707431512941527, -0.3790397812941526,
            0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, -0.3790397812941526,
            0.015584178705847496, 5.0, -0.33038044729990595, -0.6607608945998119, 0.6739761124918081, 4.0,
            -0.4707431512941527, -0.3790397812941526, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0,
            0.029256848705847327, -0.3790397812941526, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.4707431512941527, 0.12096021870584739, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.4707431512941527, 0.12096021870584739, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0,
            0.029256848705847327, -0.3790397812941526, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0,
            0.029256848705847327, 0.12096021870584739, 0.015584178705847496, 5.0, -0.26841019599329863,
            -0.5368203919865973, -0.79986238406003, 4.0, -0.4707431512941527, 0.6209602187058474, -2.4844158212941525,
            5.0, 0.0, -0.44960990782659727, -0.8932250168821733, 4.0, 0.029256848705847327, 0.6209602187058474,
            -2.4844158212941525, 5.0, 0.0, -0.8968058847750245, -0.4424242364890121, 4.0, 0.029256848705847327,
            0.12096021870584739, -1.9844158212941525, 5.0, -0.2864118759732509, -0.8592356279197527,
            -0.4238895764404113, 4.0, -0.4707431512941527, 0.12096021870584739, -1.9844158212941525, 5.0,
            -0.26841019599329863, -0.5368203919865973, -0.79986238406003, 4.0, -0.4707431512941527, 0.6209602187058474,
            -2.4844158212941525, 5.0, 0.0, -0.8968058847750245, -0.4424242364890121, 4.0, 0.029256848705847327,
            0.12096021870584739, -1.9844158212941525, 5.0, 0.0, -0.8968058847750245, -0.4424242364890121, 4.0,
            0.029256848705847327, 0.12096021870584739, -1.9844158212941525, 5.0, 0.0, -0.9999111229612074,
            0.013332148306149432, 4.0, 0.029256848705847327, 0.12096021870584739, -1.4844158212941525, 5.0,
            -0.2864118759732509, -0.8592356279197527, -0.4238895764404113, 4.0, -0.4707431512941527,
            0.12096021870584739, -1.9844158212941525, 5.0, -0.2864118759732509, -0.8592356279197527,
            -0.4238895764404113, 4.0, -0.4707431512941527, 0.12096021870584739, -1.9844158212941525, 5.0, 0.0,
            -0.9999111229612074, 0.013332148306149432, 4.0, 0.029256848705847327, 0.12096021870584739,
            -1.4844158212941525, 5.0, 0.0, -0.9999111229612074, 0.013332148306149432, 4.0, -0.4707431512941527,
            0.12096021870584739, -1.4844158212941525, 5.0, 0.0, -0.9999111229612074, 0.013332148306149432, 4.0,
            0.029256848705847327, 0.12096021870584739, -1.4844158212941525, 5.0, -0.23086870333245033,
            -0.692606109997351, -0.6833713618640529, 4.0, -0.4707431512941527, 0.12096021870584739, -1.4844158212941525,
            5.0, 0.0, -0.9999111229612074, 0.013332148306149432, 4.0, -0.4707431512941527, 0.12096021870584739,
            -1.4844158212941525, 5.0, 0.0, -0.711836432832338, -0.7023452803945736, 4.0, 0.029256848705847327,
            0.12096021870584739, -1.4844158212941525, 5.0, -0.23086870333245033, -0.692606109997351,
            -0.6833713618640529, 4.0, -0.4707431512941527, 0.12096021870584739, -1.4844158212941525, 5.0, 0.0,
            -0.9999111229612074, 0.013332148306149432, 4.0, 0.029256848705847327, 0.12096021870584739,
            -1.4844158212941525, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 0.12096021870584739,
            0.015584178705847496, 5.0, 0.0, -0.7024085519692114, 0.7117739993288009, 4.0, 0.029256848705847327,
            0.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 0.12096021870584739,
            0.015584178705847496, 5.0, 0.0, -0.7024085519692114, 0.7117739993288009, 4.0, 0.029256848705847327,
            0.6209602187058474, 0.015584178705847496, 5.0, -0.4240792104664812, -0.6361188156997218, 0.6446003999090515,
            4.0, -0.4707431512941527, 0.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.4707431512941527, 0.12096021870584739, 0.015584178705847496, 5.0, 0.0, -0.6277524511897817,
            -0.7784130394753294, 4.0, 0.029256848705847327, 1.1209602187058474, -2.9844158212941525, 5.0, 0.0,
            -0.7213873210309515, -0.6925318281897135, 4.0, 0.029256848705847327, 0.6209602187058474,
            -2.4844158212941525, 5.0, -0.5811989248480778, -0.5811989248480778, -0.5695749463511162, 4.0,
            -0.4707431512941527, 1.1209602187058474, -2.4844158212941525, 5.0, 0.0, -0.7213873210309515,
            -0.6925318281897135, 4.0, 0.029256848705847327, 0.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0,
            -1.0, 4.0, -0.4707431512941527, 1.1209602187058474, -2.4844158212941525, 5.0, -0.5811989248480778,
            -0.5811989248480778, -0.5695749463511162, 4.0, -0.4707431512941527, 1.1209602187058474, -2.4844158212941525,
            5.0, 0.0, -0.7213873210309515, -0.6925318281897135, 4.0, 0.029256848705847327, 0.6209602187058474,
            -2.4844158212941525, 5.0, 0.0, -0.44960990782659727, -0.8932250168821733, 4.0, 0.029256848705847327,
            0.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, -0.4707431512941527, 1.1209602187058474,
            -2.4844158212941525, 5.0, 0.0, -0.44960990782659727, -0.8932250168821733, 4.0, 0.029256848705847327,
            0.6209602187058474, -2.4844158212941525, 5.0, -0.26841019599329863, -0.5368203919865973, -0.79986238406003,
            4.0, -0.4707431512941527, 0.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0,
            -0.4707431512941527, 1.1209602187058474, -2.4844158212941525, 5.0, 0.0, -0.7024085519692114,
            0.7117739993288009, 4.0, 0.029256848705847327, 0.6209602187058474, 0.015584178705847496, 5.0,
            -0.22797089745144278, -0.6839126923543284, 0.6930315282523861, 4.0, -0.4707431512941527, 0.6209602187058474,
            0.5155841787058475, 5.0, -0.4240792104664812, -0.6361188156997218, 0.6446003999090515, 4.0,
            -0.4707431512941527, 0.6209602187058474, 0.015584178705847496, 5.0, 0.0, -0.7024085519692114,
            0.7117739993288009, 4.0, 0.029256848705847327, 0.6209602187058474, 0.5155841787058475, 5.0,
            -0.22797089745144278, -0.6839126923543284, 0.6930315282523861, 4.0, -0.4707431512941527, 0.6209602187058474,
            0.5155841787058475, 5.0, 0.0, -0.7024085519692114, 0.7117739993288009, 4.0, 0.029256848705847327,
            0.6209602187058474, 0.015584178705847496, 5.0, -0.22797089745144278, -0.6839126923543284,
            0.6930315282523861, 4.0, -0.4707431512941527, 0.6209602187058474, 0.5155841787058475, 5.0, 0.0,
            -0.7024085519692114, 0.7117739993288009, 4.0, 0.029256848705847327, 0.6209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 1.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0,
            4.0, -0.4707431512941527, 1.1209602187058474, 0.5155841787058475, 5.0, -0.22797089745144278,
            -0.6839126923543284, 0.6930315282523861, 4.0, -0.4707431512941527, 0.6209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 1.1209602187058474, 0.5155841787058475, 5.0,
            -0.5811989248480778, -0.5811989248480778, -0.5695749463511162, 4.0, -0.4707431512941527, 1.1209602187058474,
            -2.4844158212941525, 5.0, -0.5850454715011363, -0.5850454715011363, -0.5616436526410908, 4.0,
            -0.4707431512941527, 1.1209602187058474, -2.4844158212941525, 5.0, -0.43067900206843196, -0.287119334712288,
            -0.8556156174426182, 4.0, -0.4707431512941527, 1.6209602187058474, -2.9844158212941525, 5.0,
            -0.5811989248480778, -0.5811989248480778, -0.5695749463511162, 4.0, -0.4707431512941527, 1.1209602187058474,
            -2.4844158212941525, 5.0, -0.43067900206843196, -0.287119334712288, -0.8556156174426182, 4.0,
            -0.4707431512941527, 1.6209602187058474, -2.9844158212941525, 5.0, 0.0, -0.6277524511897817,
            -0.7784130394753294, 4.0, 0.029256848705847327, 1.1209602187058474, -2.9844158212941525, 5.0, 0.0,
            -0.6277524511897817, -0.7784130394753294, 4.0, 0.029256848705847327, 1.1209602187058474,
            -2.9844158212941525, 5.0, -0.43067900206843196, -0.287119334712288, -0.8556156174426182, 4.0,
            -0.4707431512941527, 1.6209602187058474, -2.9844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0,
            0.029256848705847327, 1.6209602187058474, -2.9844158212941525, 5.0, -0.5811989248480778,
            -0.5811989248480778, -0.5695749463511162, 4.0, -0.4707431512941527, 1.1209602187058474, -2.4844158212941525,
            5.0, 0.0, 0.0, -1.0, 4.0, -0.4707431512941527, 1.1209602187058474, -2.4844158212941525, 5.0,
            -0.5850454715011363, -0.5850454715011363, -0.5616436526410908, 4.0, -0.4707431512941527, 1.1209602187058474,
            -2.4844158212941525, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 1.1209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 1.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0,
            4.0, -0.4707431512941527, 1.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0,
            0.029256848705847327, 1.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527,
            1.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 1.1209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.0, -1.0, 4.0, 0.029256848705847327, 1.6209602187058474, -2.9844158212941525,
            5.0, -0.43067900206843196, -0.287119334712288, -0.8556156174426182, 4.0, -0.4707431512941527,
            1.6209602187058474, -2.9844158212941525, 5.0, 0.0, 0.711836432832338, -0.7023452803945736, 4.0,
            0.029256848705847327, 2.1209602187058474, -2.9844158212941525, 5.0, 0.0, 0.711836432832338,
            -0.7023452803945736, 4.0, 0.029256848705847327, 2.1209602187058474, -2.9844158212941525, 5.0,
            -0.43067900206843196, -0.287119334712288, -0.8556156174426182, 4.0, -0.4707431512941527, 1.6209602187058474,
            -2.9844158212941525, 5.0, -0.48850865146712424, 0.48850865146712424, -0.7229928041713439, 4.0,
            -0.4707431512941527, 2.1209602187058474, -2.9844158212941525, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327,
            1.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 2.1209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 1.6209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0,
            4.0, -0.4707431512941527, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.4707431512941527, 1.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.711836432832338,
            -0.7023452803945736, 4.0, 0.029256848705847327, 2.1209602187058474, -2.9844158212941525, 5.0,
            -0.48850865146712424, 0.48850865146712424, -0.7229928041713439, 4.0, -0.4707431512941527,
            2.1209602187058474, -2.9844158212941525, 5.0, 0.0, 0.711836432832338, -0.7023452803945736, 4.0,
            -0.4707431512941527, 2.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.711836432832338,
            -0.7023452803945736, 4.0, 0.029256848705847327, 2.1209602187058474, -2.4844158212941525, 5.0, 0.0,
            0.711836432832338, -0.7023452803945736, 4.0, 0.029256848705847327, 2.1209602187058474, -2.9844158212941525,
            5.0, 0.0, 0.711836432832338, -0.7023452803945736, 4.0, -0.4707431512941527, 2.1209602187058474,
            -2.4844158212941525, 5.0, 0.0, 0.711836432832338, -0.7023452803945736, 4.0, -0.4707431512941527,
            2.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, 0.029256848705847327, 2.6209602187058474,
            -2.4844158212941525, 5.0, 0.0, 0.711836432832338, -0.7023452803945736, 4.0, 0.029256848705847327,
            2.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, -0.4707431512941527, 2.6209602187058474,
            -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, 0.029256848705847327, 2.6209602187058474,
            -2.4844158212941525, 5.0, 0.0, 0.711836432832338, -0.7023452803945736, 4.0, -0.4707431512941527,
            2.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 2.1209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 2.6209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0,
            4.0, 0.029256848705847327, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.4707431512941527, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527,
            2.1209602187058474, 0.5155841787058475, 5.0, 0.4137462706113611, -0.4137462706113611, -0.8109426903982677,
            4.0, 0.029256848705847327, 3.1209602187058474, -2.9844158212941525, 5.0, 0.0, -0.7213873210309515,
            -0.6925318281897135, 4.0, 0.029256848705847327, 2.6209602187058474, -2.4844158212941525, 5.0,
            -0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0, -0.4707431512941527, 3.1209602187058474,
            -2.4844158212941525, 5.0, 0.0, -0.7213873210309515, -0.6925318281897135, 4.0, 0.029256848705847327,
            2.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, -0.4707431512941527, 3.1209602187058474,
            -2.4844158212941525, 5.0, -0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0,
            -0.4707431512941527, 3.1209602187058474, -2.4844158212941525, 5.0, 0.0, -0.7213873210309515,
            -0.6925318281897135, 4.0, 0.029256848705847327, 2.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0,
            -1.0, 4.0, 0.029256848705847327, 2.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0,
            -0.4707431512941527, 3.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0,
            0.029256848705847327, 2.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0,
            -0.4707431512941527, 2.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, -0.4707431512941527,
            3.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.3920259246081505, 0.9199541697471265, 4.0,
            -0.4707431512941527, 3.1209602187058474, 0.015584178705847496, 5.0, 0.0, 0.7024085519692114,
            0.7117739993288009, 4.0, 0.029256848705847327, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0,
            0.44483954467016196, 0.8956102832692594, 4.0, 0.029256848705847327, 3.1209602187058474,
            0.015584178705847496, 5.0, -0.22797089745144278, 0.6839126923543284, 0.6930315282523861, 4.0,
            -0.4707431512941527, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.7024085519692114,
            0.7117739993288009, 4.0, 0.029256848705847327, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0,
            0.3920259246081505, 0.9199541697471265, 4.0, -0.4707431512941527, 3.1209602187058474, 0.015584178705847496,
            5.0, 0.0, 0.7024085519692114, 0.7117739993288009, 4.0, 0.029256848705847327, 2.6209602187058474,
            0.5155841787058475, 5.0, -0.22797089745144278, 0.6839126923543284, 0.6930315282523861, 4.0,
            -0.4707431512941527, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527,
            2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 2.6209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.7024085519692114, 0.7117739993288009, 4.0, 0.029256848705847327,
            2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 2.6209602187058474,
            0.5155841787058475, 5.0, -0.4137462706113611, 0.4137462706113611, -0.8109426903982677, 4.0,
            0.029256848705847327, 3.6209602187058474, -2.9844158212941525, 5.0, 0.4137462706113611, -0.4137462706113611,
            -0.8109426903982677, 4.0, 0.029256848705847327, 3.1209602187058474, -2.9844158212941525, 5.0,
            -0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0, -0.4707431512941527, 3.1209602187058474,
            -2.4844158212941525, 5.0, -0.4137462706113611, 0.4137462706113611, -0.8109426903982677, 4.0,
            -0.4707431512941527, 3.6209602187058474, -2.4844158212941525, 5.0, -0.4137462706113611, 0.4137462706113611,
            -0.8109426903982677, 4.0, 0.029256848705847327, 3.6209602187058474, -2.9844158212941525, 5.0,
            -0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0, -0.4707431512941527, 3.1209602187058474,
            -2.4844158212941525, 5.0, -0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0,
            -0.4707431512941527, 3.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, -0.4707431512941527,
            3.6209602187058474, -2.4844158212941525, 5.0, -0.4137462706113611, 0.4137462706113611, -0.8109426903982677,
            4.0, -0.4707431512941527, 3.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0,
            -0.4707431512941527, 3.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, -0.4707431512941527,
            3.6209602187058474, -2.4844158212941525, 5.0, -0.692606109997351, -0.23086870333245033, -0.6833713618640529,
            4.0, -0.4707431512941527, 3.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.44483954467016196,
            0.8956102832692594, 4.0, 0.029256848705847327, 3.1209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0,
            4.0, 0.029256848705847327, 3.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.3920259246081505,
            0.9199541697471265, 4.0, -0.4707431512941527, 3.1209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0,
            4.0, 0.029256848705847327, 3.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.4707431512941527, 3.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.3920259246081505,
            0.9199541697471265, 4.0, -0.4707431512941527, 3.1209602187058474, 0.015584178705847496, 5.0,
            -0.4137462706113611, 0.4137462706113611, -0.8109426903982677, 4.0, 0.029256848705847327, 3.6209602187058474,
            -2.9844158212941525, 5.0, -0.4137462706113611, 0.4137462706113611, -0.8109426903982677, 4.0,
            -0.4707431512941527, 3.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.454470341687874,
            -0.890761869708233, 4.0, 0.029256848705847327, 3.6209602187058474, -2.4844158212941525, 5.0,
            -0.4137462706113611, 0.4137462706113611, -0.8109426903982677, 4.0, -0.4707431512941527, 3.6209602187058474,
            -2.4844158212941525, 5.0, 0.0, 0.6038576879954624, -0.7970921481540103, 4.0, 0.029256848705847327,
            4.120960218705847, -2.4844158212941525, 5.0, 0.0, 0.454470341687874, -0.890761869708233, 4.0,
            0.029256848705847327, 3.6209602187058474, -2.4844158212941525, 5.0, -0.4137462706113611, 0.4137462706113611,
            -0.8109426903982677, 4.0, -0.4707431512941527, 3.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0,
            4.0, -0.4707431512941527, 3.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.6038576879954624,
            -0.7970921481540103, 4.0, 0.029256848705847327, 4.120960218705847, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0,
            4.0, -0.4707431512941527, 3.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.711836432832338,
            -0.7023452803945736, 4.0, -0.4707431512941527, 4.120960218705847, -2.4844158212941525, 5.0, 0.0,
            0.6038576879954624, -0.7970921481540103, 4.0, 0.029256848705847327, 4.120960218705847, -2.4844158212941525,
            5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 3.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0,
            4.0, 0.029256848705847327, 4.120960218705847, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0,
            -0.4707431512941527, 3.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0,
            0.029256848705847327, 4.120960218705847, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527,
            4.120960218705847, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 3.6209602187058474,
            0.015584178705847496, 5.0, 0.0, 0.6038576879954624, -0.7970921481540103, 4.0, 0.029256848705847327,
            4.120960218705847, -2.4844158212941525, 5.0, 0.0, 0.711836432832338, -0.7023452803945736, 4.0,
            -0.4707431512941527, 4.120960218705847, -2.4844158212941525, 5.0, -0.19702148297518723, 0.7880859319007489,
            -0.5831835896065543, 4.0, -0.4707431512941527, 4.120960218705847, -1.9844158212941525, 5.0, 0.0,
            0.711836432832338, -0.7023452803945736, 4.0, 0.029256848705847327, 4.120960218705847, -1.9844158212941525,
            5.0, 0.0, 0.6038576879954624, -0.7970921481540103, 4.0, 0.029256848705847327, 4.120960218705847,
            -2.4844158212941525, 5.0, -0.19702148297518723, 0.7880859319007489, -0.5831835896065543, 4.0,
            -0.4707431512941527, 4.120960218705847, -1.9844158212941525, 5.0, -0.19702148297518723, 0.7880859319007489,
            -0.5831835896065543, 4.0, -0.4707431512941527, 4.120960218705847, -1.9844158212941525, 5.0, 0.0,
            0.711836432832338, -0.7023452803945736, 4.0, 0.029256848705847327, 4.620960218705847, -1.9844158212941525,
            5.0, 0.0, 0.711836432832338, -0.7023452803945736, 4.0, 0.029256848705847327, 4.120960218705847,
            -1.9844158212941525, 5.0, -0.48850865146712424, 0.48850865146712424, -0.7229928041713439, 4.0,
            -0.4707431512941527, 4.620960218705847, -1.9844158212941525, 5.0, 0.0, 0.711836432832338,
            -0.7023452803945736, 4.0, 0.029256848705847327, 4.620960218705847, -1.9844158212941525, 5.0,
            -0.19702148297518723, 0.7880859319007489, -0.5831835896065543, 4.0, -0.4707431512941527, 4.120960218705847,
            -1.9844158212941525, 5.0, 0.0, 0.7024085519692114, 0.7117739993288009, 4.0, -0.4707431512941527,
            4.620960218705847, -0.4844158212941525, 5.0, 0.0, 0.7000714109260575, 0.7140728391445786, 4.0,
            0.029256848705847327, 4.120960218705847, 0.015584178705847496, 5.0, 0.33038044729990595, 0.6607608945998119,
            0.6739761124918081, 4.0, 0.029256848705847327, 4.620960218705847, -0.4844158212941525, 5.0,
            -0.22797089745144278, 0.6839126923543284, 0.6930315282523861, 4.0, -0.4707431512941527, 4.120960218705847,
            0.015584178705847496, 5.0, 0.0, 0.7000714109260575, 0.7140728391445786, 4.0, 0.029256848705847327,
            4.120960218705847, 0.015584178705847496, 5.0, 0.0, 0.7024085519692114, 0.7117739993288009, 4.0,
            -0.4707431512941527, 4.620960218705847, -0.4844158212941525, 5.0, 0.0, 0.7000714109260575,
            0.7140728391445786, 4.0, 0.029256848705847327, 4.120960218705847, 0.015584178705847496, 5.0,
            -0.22797089745144278, 0.6839126923543284, 0.6930315282523861, 4.0, -0.4707431512941527, 4.120960218705847,
            0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 4.120960218705847, 0.015584178705847496,
            5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 4.120960218705847, 0.015584178705847496, 5.0, 0.0,
            0.7000714109260575, 0.7140728391445786, 4.0, 0.029256848705847327, 4.120960218705847, 0.015584178705847496,
            5.0, 0.0, 0.0, 1.0, 4.0, -0.4707431512941527, 4.120960218705847, 0.015584178705847496, 5.0, 0.0,
            0.711836432832338, -0.7023452803945736, 4.0, 0.029256848705847327, 4.620960218705847, -1.9844158212941525,
            5.0, -0.48850865146712424, 0.48850865146712424, -0.7229928041713439, 4.0, -0.4707431512941527,
            4.620960218705847, -1.9844158212941525, 5.0, 0.0, 0.999977778518491, 0.006666518523456607, 4.0,
            -0.4707431512941527, 4.620960218705847, -1.4844158212941525, 5.0, 0.0, 0.999977778518491,
            0.006666518523456607, 4.0, 0.029256848705847327, 4.620960218705847, -1.4844158212941525, 5.0, 0.0,
            0.711836432832338, -0.7023452803945736, 4.0, 0.029256848705847327, 4.620960218705847, -1.9844158212941525,
            5.0, 0.0, 0.999977778518491, 0.006666518523456607, 4.0, -0.4707431512941527, 4.620960218705847,
            -1.4844158212941525, 5.0, 0.0, 0.999977778518491, 0.006666518523456607, 4.0, 0.029256848705847327,
            4.620960218705847, -1.4844158212941525, 5.0, 0.0, 0.999977778518491, 0.006666518523456607, 4.0,
            -0.4707431512941527, 4.620960218705847, -1.4844158212941525, 5.0, 0.0, 0.9999680015359181,
            0.007999744012287346, 4.0, 0.029256848705847327, 4.620960218705847, -0.9844158212941525, 5.0, 0.0,
            0.999977778518491, 0.006666518523456607, 4.0, -0.4707431512941527, 4.620960218705847, -1.4844158212941525,
            5.0, 0.0, 0.999977778518491, 0.006666518523456607, 4.0, -0.4707431512941527, 4.620960218705847,
            -0.9844158212941525, 5.0, 0.0, 0.9999680015359181, 0.007999744012287346, 4.0, 0.029256848705847327,
            4.620960218705847, -0.9844158212941525, 5.0, 0.0, 0.9999680015359181, 0.007999744012287346, 4.0,
            0.029256848705847327, 4.620960218705847, -0.9844158212941525, 5.0, 0.0, 0.999977778518491,
            0.006666518523456607, 4.0, -0.4707431512941527, 4.620960218705847, -0.9844158212941525, 5.0, 0.0,
            0.9999111229612074, 0.013332148306149432, 4.0, 0.029256848705847327, 4.620960218705847, -0.4844158212941525,
            5.0, 0.0, 0.999977778518491, 0.006666518523456607, 4.0, -0.4707431512941527, 4.620960218705847,
            -0.9844158212941525, 5.0, 0.0, 0.9999111229612074, 0.013332148306149432, 4.0, -0.4707431512941527,
            4.620960218705847, -0.4844158212941525, 5.0, 0.0, 0.9999111229612074, 0.013332148306149432, 4.0,
            0.029256848705847327, 4.620960218705847, -0.4844158212941525, 5.0, 0.0, 0.9999111229612074,
            0.013332148306149432, 4.0, 0.029256848705847327, 4.620960218705847, -0.4844158212941525, 5.0, 0.0,
            0.9999111229612074, 0.013332148306149432, 4.0, -0.4707431512941527, 4.620960218705847, -0.4844158212941525,
            5.0, 0.0, 0.7024085519692114, 0.7117739993288009, 4.0, -0.4707431512941527, 4.620960218705847,
            -0.4844158212941525, 5.0, 0.33038044729990595, 0.6607608945998119, 0.6739761124918081, 4.0,
            0.029256848705847327, 4.620960218705847, -0.4844158212941525, 5.0, 0.0, 0.9999111229612074,
            0.013332148306149432, 4.0, 0.029256848705847327, 4.620960218705847, -0.4844158212941525, 5.0, 0.0,
            0.7024085519692114, 0.7117739993288009, 4.0, -0.4707431512941527, 4.620960218705847, -0.4844158212941525,
            5.0, 0.0, -0.9992009587217893, 0.03996803834887161, 4.0, 0.029256848705847327, -0.8790397812941526,
            0.015584178705847496, 5.0, 0.5850454715011363, -0.5850454715011363, -0.5616436526410908, 4.0,
            0.029256848705847327, -0.3790397812941526, -0.4844158212941525, 5.0, 0.9999111229612074, 0.0,
            0.013332148306149432, 4.0, 0.029256848705847327, -0.3790397812941526, 0.015584178705847496, 5.0, 0.0,
            -0.9992009587217893, 0.03996803834887161, 4.0, 0.029256848705847327, -0.8790397812941526,
            0.015584178705847496, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 0.029256848705847327,
            -0.3790397812941526, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327,
            -0.3790397812941526, 0.015584178705847496, 5.0, 0.0, -0.711836432832338, -0.7023452803945736, 4.0,
            0.029256848705847327, 0.12096021870584739, -1.4844158212941525, 5.0, 0.41094193932059253,
            -0.8218838786411851, -0.3945042617477688, 4.0, 0.5292568487058473, 0.12096021870584739, -1.4844158212941525,
            5.0, 0.5360254622430297, -0.8040381933645446, -0.2572922218766543, 4.0, 0.5292568487058473,
            -0.3790397812941526, -0.9844158212941525, 5.0, 0.0, -0.8605150974154714, -0.5094249376699591, 4.0,
            0.029256848705847327, -0.3790397812941526, -0.9844158212941525, 5.0, 0.0, -0.711836432832338,
            -0.7023452803945736, 4.0, 0.029256848705847327, 0.12096021870584739, -1.4844158212941525, 5.0,
            0.5360254622430297, -0.8040381933645446, -0.2572922218766543, 4.0, 0.5292568487058473, -0.3790397812941526,
            -0.9844158212941525, 5.0, 0.6607608945998119, -0.33038044729990595, 0.6739761124918081, 4.0,
            0.5292568487058473, 0.12096021870584739, -0.9844158212941525, 5.0, 0.6867740247905052, -0.6867740247905052,
            0.23808166192737512, 4.0, 0.029256848705847327, 0.12096021870584739, -0.4844158212941525, 5.0,
            0.4068807567358935, -0.813761513471787, 0.4150183718706114, 4.0, 0.029256848705847327, -0.3790397812941526,
            -0.4844158212941525, 5.0, 0.6607608945998119, -0.33038044729990595, 0.6739761124918081, 4.0,
            0.5292568487058473, 0.12096021870584739, -0.9844158212941525, 5.0, 0.4068807567358935, -0.813761513471787,
            0.4150183718706114, 4.0, 0.029256848705847327, -0.3790397812941526, -0.4844158212941525, 5.0,
            0.5360254622430297, -0.8040381933645446, -0.2572922218766543, 4.0, 0.5292568487058473, -0.3790397812941526,
            -0.9844158212941525, 5.0, 0.5360254622430297, -0.8040381933645446, -0.2572922218766543, 4.0,
            0.5292568487058473, -0.3790397812941526, -0.9844158212941525, 5.0, 0.4068807567358935, -0.813761513471787,
            0.4150183718706114, 4.0, 0.029256848705847327, -0.3790397812941526, -0.4844158212941525, 5.0, 0.0,
            -0.8605150974154714, -0.5094249376699591, 4.0, 0.029256848705847327, -0.3790397812941526,
            -0.9844158212941525, 5.0, 0.5850454715011363, -0.5850454715011363, -0.5616436526410908, 4.0,
            0.029256848705847327, -0.3790397812941526, -0.4844158212941525, 5.0, 0.4068807567358935, -0.813761513471787,
            0.4150183718706114, 4.0, 0.029256848705847327, -0.3790397812941526, -0.4844158212941525, 5.0,
            0.6867740247905052, -0.6867740247905052, 0.23808166192737512, 4.0, 0.029256848705847327,
            0.12096021870584739, -0.4844158212941525, 5.0, 0.5850454715011363, -0.5850454715011363, -0.5616436526410908,
            4.0, 0.029256848705847327, -0.3790397812941526, -0.4844158212941525, 5.0, 0.6867740247905052,
            -0.6867740247905052, 0.23808166192737512, 4.0, 0.029256848705847327, 0.12096021870584739,
            -0.4844158212941525, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 0.029256848705847327,
            -0.3790397812941526, 0.015584178705847496, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0,
            0.029256848705847327, -0.3790397812941526, 0.015584178705847496, 5.0, 0.6867740247905052,
            -0.6867740247905052, 0.23808166192737512, 4.0, 0.029256848705847327, 0.12096021870584739,
            -0.4844158212941525, 5.0, 0.5696549391872194, -0.5696549391872194, 0.5924411367547082, 4.0,
            0.029256848705847327, 0.12096021870584739, 0.015584178705847496, 5.0, 0.9999111229612074, 0.0,
            0.013332148306149432, 4.0, 0.029256848705847327, -0.3790397812941526, 0.015584178705847496, 5.0,
            0.5696549391872194, -0.5696549391872194, 0.5924411367547082, 4.0, 0.029256848705847327, 0.12096021870584739,
            0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 0.12096021870584739,
            0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, -0.3790397812941526,
            0.015584178705847496, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 0.029256848705847327,
            -0.3790397812941526, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327,
            0.12096021870584739, 0.015584178705847496, 5.0, 0.0, -0.44960990782659727, -0.8932250168821733, 4.0,
            0.029256848705847327, 0.6209602187058474, -2.4844158212941525, 5.0, 0.3734464267162477, -0.5601696400743716,
            -0.7394239248981705, 4.0, 0.5292568487058473, 0.6209602187058474, -2.4844158212941525, 5.0,
            0.3729266969758427, -0.7458533939516854, -0.5519315115242471, 4.0, 0.5292568487058473, 0.12096021870584739,
            -1.9844158212941525, 5.0, 0.0, -0.8968058847750245, -0.4424242364890121, 4.0, 0.029256848705847327,
            0.12096021870584739, -1.9844158212941525, 5.0, 0.0, -0.44960990782659727, -0.8932250168821733, 4.0,
            0.029256848705847327, 0.6209602187058474, -2.4844158212941525, 5.0, 0.3729266969758427, -0.7458533939516854,
            -0.5519315115242471, 4.0, 0.5292568487058473, 0.12096021870584739, -1.9844158212941525, 5.0,
            0.3729266969758427, -0.7458533939516854, -0.5519315115242471, 4.0, 0.5292568487058473, 0.12096021870584739,
            -1.9844158212941525, 5.0, 0.0, -0.9999500037496877, 0.009999500037496877, 4.0, 0.5292568487058473,
            0.12096021870584739, -1.4844158212941525, 5.0, 0.0, -0.8968058847750245, -0.4424242364890121, 4.0,
            0.029256848705847327, 0.12096021870584739, -1.9844158212941525, 5.0, 0.0, -0.8968058847750245,
            -0.4424242364890121, 4.0, 0.029256848705847327, 0.12096021870584739, -1.9844158212941525, 5.0, 0.0,
            -0.9999500037496877, 0.009999500037496877, 4.0, 0.5292568487058473, 0.12096021870584739,
            -1.4844158212941525, 5.0, 0.0, -0.9999111229612074, 0.013332148306149432, 4.0, 0.029256848705847327,
            0.12096021870584739, -1.4844158212941525, 5.0, 0.0, -0.9999500037496877, 0.009999500037496877, 4.0,
            0.5292568487058473, 0.12096021870584739, -1.4844158212941525, 5.0, 0.0, -0.711836432832338,
            -0.7023452803945736, 4.0, 0.029256848705847327, 0.12096021870584739, -1.4844158212941525, 5.0, 0.0,
            -0.9999111229612074, 0.013332148306149432, 4.0, 0.029256848705847327, 0.12096021870584739,
            -1.4844158212941525, 5.0, 0.41094193932059253, -0.8218838786411851, -0.3945042617477688, 4.0,
            0.5292568487058473, 0.12096021870584739, -1.4844158212941525, 5.0, 0.0, -0.711836432832338,
            -0.7023452803945736, 4.0, 0.029256848705847327, 0.12096021870584739, -1.4844158212941525, 5.0, 0.0,
            -0.9999500037496877, 0.009999500037496877, 4.0, 0.5292568487058473, 0.12096021870584739,
            -1.4844158212941525, 5.0, 0.6607608945998119, -0.33038044729990595, 0.6739761124918081, 4.0,
            0.5292568487058473, 0.12096021870584739, -0.9844158212941525, 5.0, 0.0, -0.9999680015359181,
            0.007999744012287346, 4.0, 0.5292568487058473, 0.12096021870584739, -0.4844158212941525, 5.0,
            0.6867740247905052, -0.6867740247905052, 0.23808166192737512, 4.0, 0.029256848705847327,
            0.12096021870584739, -0.4844158212941525, 5.0, 0.6867740247905052, -0.6867740247905052, 0.23808166192737512,
            4.0, 0.029256848705847327, 0.12096021870584739, -0.4844158212941525, 5.0, 0.4240792104664812,
            -0.6361188156997218, 0.6446003999090515, 4.0, 0.5292568487058473, 0.12096021870584739, 0.015584178705847496,
            5.0, 0.5696549391872194, -0.5696549391872194, 0.5924411367547082, 4.0, 0.029256848705847327,
            0.12096021870584739, 0.015584178705847496, 5.0, 0.0, -0.9999680015359181, 0.007999744012287346, 4.0,
            0.5292568487058473, 0.12096021870584739, -0.4844158212941525, 5.0, 0.4240792104664812, -0.6361188156997218,
            0.6446003999090515, 4.0, 0.5292568487058473, 0.12096021870584739, 0.015584178705847496, 5.0,
            0.6867740247905052, -0.6867740247905052, 0.23808166192737512, 4.0, 0.029256848705847327,
            0.12096021870584739, -0.4844158212941525, 5.0, 0.5696549391872194, -0.5696549391872194, 0.5924411367547082,
            4.0, 0.029256848705847327, 0.12096021870584739, 0.015584178705847496, 5.0, 0.4240792104664812,
            -0.6361188156997218, 0.6446003999090515, 4.0, 0.5292568487058473, 0.12096021870584739, 0.015584178705847496,
            5.0, 0.0, -0.8269265020695281, 0.5623100214072791, 4.0, 0.5292568487058473, 0.6209602187058474,
            0.015584178705847496, 5.0, 0.5696549391872194, -0.5696549391872194, 0.5924411367547082, 4.0,
            0.029256848705847327, 0.12096021870584739, 0.015584178705847496, 5.0, 0.0, -0.8269265020695281,
            0.5623100214072791, 4.0, 0.5292568487058473, 0.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0,
            4.0, 0.029256848705847327, 0.12096021870584739, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0,
            0.029256848705847327, 0.12096021870584739, 0.015584178705847496, 5.0, 0.0, -0.8269265020695281,
            0.5623100214072791, 4.0, 0.5292568487058473, 0.6209602187058474, 0.015584178705847496, 5.0, 0.0,
            -0.7024085519692114, 0.7117739993288009, 4.0, 0.029256848705847327, 0.6209602187058474,
            0.015584178705847496, 5.0, 0.0, -0.7213873210309515, -0.6925318281897135, 4.0, 0.029256848705847327,
            0.6209602187058474, -2.4844158212941525, 5.0, 0.0, -0.6277524511897817, -0.7784130394753294, 4.0,
            0.029256848705847327, 1.1209602187058474, -2.9844158212941525, 5.0, 0.5850454715011363, -0.5850454715011363,
            -0.5616436526410908, 4.0, 0.029256848705847327, 1.1209602187058474, -2.4844158212941525, 5.0,
            0.5850454715011363, -0.5850454715011363, -0.5616436526410908, 4.0, 0.029256848705847327, 1.1209602187058474,
            -2.4844158212941525, 5.0, 0.0, -0.44960990782659727, -0.8932250168821733, 4.0, 0.029256848705847327,
            0.6209602187058474, -2.4844158212941525, 5.0, 0.0, -0.7213873210309515, -0.6925318281897135, 4.0,
            0.029256848705847327, 0.6209602187058474, -2.4844158212941525, 5.0, 0.5850454715011363, -0.5850454715011363,
            -0.5616436526410908, 4.0, 0.029256848705847327, 1.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0,
            -1.0, 4.0, 0.5292568487058473, 1.1209602187058474, -2.4844158212941525, 5.0, 0.0, -0.44960990782659727,
            -0.8932250168821733, 4.0, 0.029256848705847327, 0.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0,
            -1.0, 4.0, 0.5292568487058473, 1.1209602187058474, -2.4844158212941525, 5.0, 0.3734464267162477,
            -0.5601696400743716, -0.7394239248981705, 4.0, 0.5292568487058473, 0.6209602187058474, -2.4844158212941525,
            5.0, 0.0, -0.44960990782659727, -0.8932250168821733, 4.0, 0.029256848705847327, 0.6209602187058474,
            -2.4844158212941525, 5.0, 0.0, -0.8269265020695281, 0.5623100214072791, 4.0, 0.5292568487058473,
            0.6209602187058474, 0.015584178705847496, 5.0, 0.0, -0.7024085519692114, 0.7117739993288009, 4.0,
            0.029256848705847327, 0.6209602187058474, 0.5155841787058475, 5.0, 0.0, -0.7024085519692114,
            0.7117739993288009, 4.0, 0.029256848705847327, 0.6209602187058474, 0.015584178705847496, 5.0,
            0.4816607005330728, -0.4816607005330728, 0.7321242648102707, 4.0, 0.5292568487058473, 0.6209602187058474,
            0.5155841787058475, 5.0, 0.0, -0.7024085519692114, 0.7117739993288009, 4.0, 0.029256848705847327,
            0.6209602187058474, 0.5155841787058475, 5.0, 0.0, -0.8269265020695281, 0.5623100214072791, 4.0,
            0.5292568487058473, 0.6209602187058474, 0.015584178705847496, 5.0, 0.0, -0.7024085519692114,
            0.7117739993288009, 4.0, 0.029256848705847327, 0.6209602187058474, 0.5155841787058475, 5.0,
            0.4816607005330728, -0.4816607005330728, 0.7321242648102707, 4.0, 0.5292568487058473, 0.6209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473, 1.1209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 1.1209602187058474, 0.5155841787058475, 5.0, 0.0,
            -0.7024085519692114, 0.7117739993288009, 4.0, 0.029256848705847327, 0.6209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473, 1.1209602187058474, 0.5155841787058475, 5.0,
            0.6695894800069753, -0.6695894800069753, -0.3214029504033481, 4.0, 0.5292568487058473, 1.1209602187058474,
            -2.4844158212941525, 5.0, 0.5850454715011363, -0.5850454715011363, -0.5616436526410908, 4.0,
            0.029256848705847327, 1.1209602187058474, -2.4844158212941525, 5.0, 0.0, -0.6277524511897817,
            -0.7784130394753294, 4.0, 0.029256848705847327, 1.1209602187058474, -2.9844158212941525, 5.0,
            0.6695894800069753, -0.6695894800069753, -0.3214029504033481, 4.0, 0.5292568487058473, 1.1209602187058474,
            -2.4844158212941525, 5.0, 0.0, -0.6277524511897817, -0.7784130394753294, 4.0, 0.029256848705847327,
            1.1209602187058474, -2.9844158212941525, 5.0, 0.7880859319007489, -0.19702148297518723, -0.5831835896065543,
            4.0, 0.5292568487058473, 1.6209602187058474, -2.9844158212941525, 5.0, 0.7880859319007489,
            -0.19702148297518723, -0.5831835896065543, 4.0, 0.5292568487058473, 1.6209602187058474, -2.9844158212941525,
            5.0, 0.0, -0.6277524511897817, -0.7784130394753294, 4.0, 0.029256848705847327, 1.1209602187058474,
            -2.9844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, 0.029256848705847327, 1.6209602187058474,
            -2.9844158212941525, 5.0, 0.5850454715011363, -0.5850454715011363, -0.5616436526410908, 4.0,
            0.029256848705847327, 1.1209602187058474, -2.4844158212941525, 5.0, 0.6695894800069753, -0.6695894800069753,
            -0.3214029504033481, 4.0, 0.5292568487058473, 1.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0,
            4.0, 0.5292568487058473, 1.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, 1.0, 4.0,
            0.5292568487058473, 1.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473,
            1.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 1.1209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473, 1.6209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 1.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0,
            4.0, 0.029256848705847327, 1.1209602187058474, 0.5155841787058475, 5.0, 0.7880859319007489,
            -0.19702148297518723, -0.5831835896065543, 4.0, 0.5292568487058473, 1.6209602187058474, -2.9844158212941525,
            5.0, 0.0, 0.0, -1.0, 4.0, 0.029256848705847327, 1.6209602187058474, -2.9844158212941525, 5.0,
            0.33630596344635905, 0.6726119268927181, -0.6591596883548637, 4.0, 0.5292568487058473, 2.1209602187058474,
            -2.9844158212941525, 5.0, 0.33630596344635905, 0.6726119268927181, -0.6591596883548637, 4.0,
            0.5292568487058473, 2.1209602187058474, -2.9844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, 0.029256848705847327,
            1.6209602187058474, -2.9844158212941525, 5.0, 0.0, 0.711836432832338, -0.7023452803945736, 4.0,
            0.029256848705847327, 2.1209602187058474, -2.9844158212941525, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473,
            1.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473, 2.1209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 1.6209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0,
            4.0, 0.029256848705847327, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0,
            0.029256848705847327, 1.6209602187058474, 0.5155841787058475, 5.0, 0.33630596344635905, 0.6726119268927181,
            -0.6591596883548637, 4.0, 0.5292568487058473, 2.1209602187058474, -2.9844158212941525, 5.0, 0.0,
            0.711836432832338, -0.7023452803945736, 4.0, 0.029256848705847327, 2.1209602187058474, -2.9844158212941525,
            5.0, 0.0, 0.711836432832338, -0.7023452803945736, 4.0, 0.029256848705847327, 2.1209602187058474,
            -2.4844158212941525, 5.0, 0.0, 0.454470341687874, -0.890761869708233, 4.0, 0.5292568487058473,
            2.1209602187058474, -2.4844158212941525, 5.0, 0.33630596344635905, 0.6726119268927181, -0.6591596883548637,
            4.0, 0.5292568487058473, 2.1209602187058474, -2.9844158212941525, 5.0, 0.0, 0.711836432832338,
            -0.7023452803945736, 4.0, 0.029256848705847327, 2.1209602187058474, -2.4844158212941525, 5.0, 0.0,
            0.711836432832338, -0.7023452803945736, 4.0, 0.029256848705847327, 2.1209602187058474, -2.4844158212941525,
            5.0, 0.0, 0.0, -1.0, 4.0, 0.5292568487058473, 2.6209602187058474, -2.4844158212941525, 5.0, 0.0,
            0.454470341687874, -0.890761869708233, 4.0, 0.5292568487058473, 2.1209602187058474, -2.4844158212941525,
            5.0, 0.0, 0.0, -1.0, 4.0, 0.029256848705847327, 2.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0,
            -1.0, 4.0, 0.5292568487058473, 2.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.711836432832338,
            -0.7023452803945736, 4.0, 0.029256848705847327, 2.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, 1.0,
            4.0, 0.5292568487058473, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0,
            0.5292568487058473, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327,
            2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473, 2.6209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 2.6209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0,
            -0.7213873210309515, -0.6925318281897135, 4.0, 0.029256848705847327, 2.6209602187058474,
            -2.4844158212941525, 5.0, 0.4137462706113611, -0.4137462706113611, -0.8109426903982677, 4.0,
            0.029256848705847327, 3.1209602187058474, -2.9844158212941525, 5.0, 0.7142128391425071, 0.0,
            -0.699928582359657, 4.0, 0.029256848705847327, 3.1209602187058474, -2.4844158212941525, 5.0,
            0.7142128391425071, 0.0, -0.699928582359657, 4.0, 0.029256848705847327, 3.1209602187058474,
            -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, 0.029256848705847327, 2.6209602187058474,
            -2.4844158212941525, 5.0, 0.0, -0.7213873210309515, -0.6925318281897135, 4.0, 0.029256848705847327,
            2.6209602187058474, -2.4844158212941525, 5.0, 0.7142128391425071, 0.0, -0.699928582359657, 4.0,
            0.029256848705847327, 3.1209602187058474, -2.4844158212941525, 5.0, 0.5100035088362113, 0.1700011696120704,
            -0.8432058012758692, 4.0, 0.5292568487058473, 3.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0,
            4.0, 0.029256848705847327, 2.6209602187058474, -2.4844158212941525, 5.0, 0.5100035088362113,
            0.1700011696120704, -0.8432058012758692, 4.0, 0.5292568487058473, 3.1209602187058474, -2.4844158212941525,
            5.0, 0.0, 0.0, -1.0, 4.0, 0.5292568487058473, 2.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0,
            4.0, 0.029256848705847327, 2.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.44483954467016196,
            0.8956102832692594, 4.0, 0.029256848705847327, 3.1209602187058474, 0.015584178705847496, 5.0, 0.0,
            0.7000714109260575, 0.7140728391445786, 4.0, 0.5292568487058473, 2.6209602187058474, 0.5155841787058475,
            5.0, 0.2649845836453722, 0.5299691672907444, 0.8055531342819315, 4.0, 0.5292568487058473,
            3.1209602187058474, 0.015584178705847496, 5.0, 0.0, 0.7024085519692114, 0.7117739993288009, 4.0,
            0.029256848705847327, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.7000714109260575,
            0.7140728391445786, 4.0, 0.5292568487058473, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0,
            0.44483954467016196, 0.8956102832692594, 4.0, 0.029256848705847327, 3.1209602187058474,
            0.015584178705847496, 5.0, 0.0, 0.7000714109260575, 0.7140728391445786, 4.0, 0.5292568487058473,
            2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.7024085519692114, 0.7117739993288009, 4.0,
            0.029256848705847327, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327,
            2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473, 2.6209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.7000714109260575, 0.7140728391445786, 4.0, 0.5292568487058473,
            2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 2.6209602187058474,
            0.5155841787058475, 5.0, 0.7142128391425071, 0.0, -0.699928582359657, 4.0, 0.029256848705847327,
            3.6209602187058474, -2.4844158212941525, 5.0, 0.7142128391425071, 0.0, -0.699928582359657, 4.0,
            0.029256848705847327, 3.1209602187058474, -2.4844158212941525, 5.0, 0.4137462706113611, -0.4137462706113611,
            -0.8109426903982677, 4.0, 0.029256848705847327, 3.1209602187058474, -2.9844158212941525, 5.0,
            -0.4137462706113611, 0.4137462706113611, -0.8109426903982677, 4.0, 0.029256848705847327, 3.6209602187058474,
            -2.9844158212941525, 5.0, 0.7142128391425071, 0.0, -0.699928582359657, 4.0, 0.029256848705847327,
            3.6209602187058474, -2.4844158212941525, 5.0, 0.4137462706113611, -0.4137462706113611, -0.8109426903982677,
            4.0, 0.029256848705847327, 3.1209602187058474, -2.9844158212941525, 5.0, 0.5100035088362113,
            0.1700011696120704, -0.8432058012758692, 4.0, 0.5292568487058473, 3.1209602187058474, -2.4844158212941525,
            5.0, 0.7142128391425071, 0.0, -0.699928582359657, 4.0, 0.029256848705847327, 3.6209602187058474,
            -2.4844158212941525, 5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0, 0.5292568487058473,
            3.6209602187058474, -2.4844158212941525, 5.0, 0.7142128391425071, 0.0, -0.699928582359657, 4.0,
            0.029256848705847327, 3.1209602187058474, -2.4844158212941525, 5.0, 0.7142128391425071, 0.0,
            -0.699928582359657, 4.0, 0.029256848705847327, 3.6209602187058474, -2.4844158212941525, 5.0,
            0.5100035088362113, 0.1700011696120704, -0.8432058012758692, 4.0, 0.5292568487058473, 3.1209602187058474,
            -2.4844158212941525, 5.0, 0.2649845836453722, 0.5299691672907444, 0.8055531342819315, 4.0,
            0.5292568487058473, 3.1209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473,
            3.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.44483954467016196, 0.8956102832692594, 4.0,
            0.029256848705847327, 3.1209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473,
            3.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 3.6209602187058474,
            0.015584178705847496, 5.0, 0.0, 0.44483954467016196, 0.8956102832692594, 4.0, 0.029256848705847327,
            3.1209602187058474, 0.015584178705847496, 5.0, 0.7142128391425071, 0.0, -0.699928582359657, 4.0,
            0.029256848705847327, 3.6209602187058474, -2.4844158212941525, 5.0, -0.4137462706113611, 0.4137462706113611,
            -0.8109426903982677, 4.0, 0.029256848705847327, 3.6209602187058474, -2.9844158212941525, 5.0, 0.0,
            0.454470341687874, -0.890761869708233, 4.0, 0.029256848705847327, 3.6209602187058474, -2.4844158212941525,
            5.0, 0.0, 0.454470341687874, -0.890761869708233, 4.0, 0.029256848705847327, 3.6209602187058474,
            -2.4844158212941525, 5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0, 0.5292568487058473,
            3.6209602187058474, -2.4844158212941525, 5.0, 0.7142128391425071, 0.0, -0.699928582359657, 4.0,
            0.029256848705847327, 3.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.454470341687874,
            -0.890761869708233, 4.0, 0.029256848705847327, 3.6209602187058474, -2.4844158212941525, 5.0, 0.0,
            0.6038576879954624, -0.7970921481540103, 4.0, 0.029256848705847327, 4.120960218705847, -2.4844158212941525,
            5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0, 0.5292568487058473, 3.6209602187058474,
            -2.4844158212941525, 5.0, 0.0, 0.6038576879954624, -0.7970921481540103, 4.0, 0.029256848705847327,
            4.120960218705847, -2.4844158212941525, 5.0, 0.41094193932059253, 0.8218838786411851, -0.3945042617477688,
            4.0, 0.5292568487058473, 4.120960218705847, -2.4844158212941525, 5.0, 0.711836432832338, 0.0,
            -0.7023452803945736, 4.0, 0.5292568487058473, 3.6209602187058474, -2.4844158212941525, 5.0,
            0.5747843685791867, 0.5747843685791867, 0.5824481601602425, 4.0, 0.5292568487058473, 4.120960218705847,
            -0.4844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            0.029256848705847327, 4.120960218705847, 0.015584178705847496, 5.0, 0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, 0.5292568487058473, 3.6209602187058474, 0.015584178705847496, 5.0,
            0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, 0.5292568487058473, 3.6209602187058474,
            0.015584178705847496, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            0.029256848705847327, 4.120960218705847, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0,
            0.029256848705847327, 4.120960218705847, 0.015584178705847496, 5.0, 0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, 0.5292568487058473, 3.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0,
            4.0, 0.029256848705847327, 4.120960218705847, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0,
            0.5292568487058473, 3.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473,
            3.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 4.120960218705847,
            0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 3.6209602187058474,
            0.015584178705847496, 5.0, 0.41094193932059253, 0.8218838786411851, -0.3945042617477688, 4.0,
            0.5292568487058473, 4.120960218705847, -2.4844158212941525, 5.0, 0.0, 0.6038576879954624,
            -0.7970921481540103, 4.0, 0.029256848705847327, 4.120960218705847, -2.4844158212941525, 5.0, 0.0,
            0.711836432832338, -0.7023452803945736, 4.0, 0.029256848705847327, 4.120960218705847, -1.9844158212941525,
            5.0, 0.5850454715011363, 0.5850454715011363, -0.5616436526410908, 4.0, 0.5292568487058473,
            4.120960218705847, -1.9844158212941525, 5.0, 0.41094193932059253, 0.8218838786411851, -0.3945042617477688,
            4.0, 0.5292568487058473, 4.120960218705847, -2.4844158212941525, 5.0, 0.0, 0.711836432832338,
            -0.7023452803945736, 4.0, 0.029256848705847327, 4.120960218705847, -1.9844158212941525, 5.0, 0.0,
            0.711836432832338, -0.7023452803945736, 4.0, 0.029256848705847327, 4.120960218705847, -1.9844158212941525,
            5.0, 0.33630596344635905, 0.6726119268927181, -0.6591596883548637, 4.0, 0.5292568487058473,
            4.620960218705847, -1.9844158212941525, 5.0, 0.5850454715011363, 0.5850454715011363, -0.5616436526410908,
            4.0, 0.5292568487058473, 4.120960218705847, -1.9844158212941525, 5.0, 0.0, 0.711836432832338,
            -0.7023452803945736, 4.0, 0.029256848705847327, 4.620960218705847, -1.9844158212941525, 5.0,
            0.33630596344635905, 0.6726119268927181, -0.6591596883548637, 4.0, 0.5292568487058473, 4.620960218705847,
            -1.9844158212941525, 5.0, 0.0, 0.711836432832338, -0.7023452803945736, 4.0, 0.029256848705847327,
            4.120960218705847, -1.9844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406,
            4.0, 0.5292568487058473, 4.620960218705847, -0.9844158212941525, 5.0, 0.5696549391872194,
            0.5696549391872194, 0.5924411367547082, 4.0, 0.029256848705847327, 4.620960218705847, -0.4844158212941525,
            5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, 0.5292568487058473, 4.120960218705847,
            -0.4844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            0.029256848705847327, 4.120960218705847, 0.015584178705847496, 5.0, 0.33038044729990595, 0.6607608945998119,
            0.6739761124918081, 4.0, 0.029256848705847327, 4.620960218705847, -0.4844158212941525, 5.0, 0.0,
            0.7000714109260575, 0.7140728391445786, 4.0, 0.029256848705847327, 4.120960218705847, 0.015584178705847496,
            5.0, 0.5747843685791867, 0.5747843685791867, 0.5824481601602425, 4.0, 0.5292568487058473, 4.120960218705847,
            -0.4844158212941525, 5.0, 0.33038044729990595, 0.6607608945998119, 0.6739761124918081, 4.0,
            0.029256848705847327, 4.620960218705847, -0.4844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672,
            0.5849716376596406, 4.0, 0.029256848705847327, 4.120960218705847, 0.015584178705847496, 5.0,
            0.5747843685791867, 0.5747843685791867, 0.5824481601602425, 4.0, 0.5292568487058473, 4.120960218705847,
            -0.4844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0,
            0.029256848705847327, 4.620960218705847, -0.4844158212941525, 5.0, 0.33038044729990595, 0.6607608945998119,
            0.6739761124918081, 4.0, 0.029256848705847327, 4.620960218705847, -0.4844158212941525, 5.0,
            0.5747843685791867, 0.5747843685791867, 0.5824481601602425, 4.0, 0.5292568487058473, 4.120960218705847,
            -0.4844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0,
            0.5292568487058473, 4.120960218705847, -0.4844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, 0.029256848705847327, 4.620960218705847, -0.4844158212941525, 5.0,
            0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, 0.029256848705847327, 4.120960218705847,
            0.015584178705847496, 5.0, 0.0, 0.7000714109260575, 0.7140728391445786, 4.0, 0.029256848705847327,
            4.120960218705847, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, 0.029256848705847327, 4.120960218705847,
            0.015584178705847496, 5.0, 0.33630596344635905, 0.6726119268927181, -0.6591596883548637, 4.0,
            0.5292568487058473, 4.620960218705847, -1.9844158212941525, 5.0, 0.0, 0.711836432832338,
            -0.7023452803945736, 4.0, 0.029256848705847327, 4.620960218705847, -1.9844158212941525, 5.0, 0.0,
            0.999977778518491, 0.006666518523456607, 4.0, 0.029256848705847327, 4.620960218705847, -1.4844158212941525,
            5.0, 0.0, 0.9998000599800071, 0.01999600119960014, 4.0, 0.5292568487058473, 4.620960218705847,
            -1.4844158212941525, 5.0, 0.33630596344635905, 0.6726119268927181, -0.6591596883548637, 4.0,
            0.5292568487058473, 4.620960218705847, -1.9844158212941525, 5.0, 0.0, 0.999977778518491,
            0.006666518523456607, 4.0, 0.029256848705847327, 4.620960218705847, -1.4844158212941525, 5.0, 0.0,
            0.9998000599800071, 0.01999600119960014, 4.0, 0.5292568487058473, 4.620960218705847, -1.4844158212941525,
            5.0, 0.0, 0.999977778518491, 0.006666518523456607, 4.0, 0.029256848705847327, 4.620960218705847,
            -1.4844158212941525, 5.0, 0.0, 0.9999111229612074, 0.013332148306149432, 4.0, 0.5292568487058473,
            4.620960218705847, -0.9844158212941525, 5.0, 0.0, 0.999977778518491, 0.006666518523456607, 4.0,
            0.029256848705847327, 4.620960218705847, -1.4844158212941525, 5.0, 0.0, 0.9999680015359181,
            0.007999744012287346, 4.0, 0.029256848705847327, 4.620960218705847, -0.9844158212941525, 5.0, 0.0,
            0.9999111229612074, 0.013332148306149432, 4.0, 0.5292568487058473, 4.620960218705847, -0.9844158212941525,
            5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, 0.029256848705847327,
            4.620960218705847, -0.4844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406,
            4.0, 0.5292568487058473, 4.620960218705847, -0.9844158212941525, 5.0, 0.0, 0.9999111229612074,
            0.013332148306149432, 4.0, 0.5292568487058473, 4.620960218705847, -0.9844158212941525, 5.0,
            0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, 0.029256848705847327, 4.620960218705847,
            -0.4844158212941525, 5.0, 0.0, 0.9999111229612074, 0.013332148306149432, 4.0, 0.5292568487058473,
            4.620960218705847, -0.9844158212941525, 5.0, 0.0, 0.9999111229612074, 0.013332148306149432, 4.0,
            0.029256848705847327, 4.620960218705847, -0.4844158212941525, 5.0, 0.0, 0.9999111229612074,
            0.013332148306149432, 4.0, 0.029256848705847327, 4.620960218705847, -0.4844158212941525, 5.0, 0.0,
            0.9999111229612074, 0.013332148306149432, 4.0, 0.5292568487058473, 4.620960218705847, -0.9844158212941525,
            5.0, 0.0, 0.9999680015359181, 0.007999744012287346, 4.0, 0.029256848705847327, 4.620960218705847,
            -0.9844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0,
            0.029256848705847327, 4.620960218705847, -0.4844158212941525, 5.0, 0.0, 0.9999111229612074,
            0.013332148306149432, 4.0, 0.029256848705847327, 4.620960218705847, -0.4844158212941525, 5.0,
            0.33038044729990595, 0.6607608945998119, 0.6739761124918081, 4.0, 0.029256848705847327, 4.620960218705847,
            -0.4844158212941525, 5.0, 0.5360254622430297, -0.8040381933645446, -0.2572922218766543, 4.0,
            0.5292568487058473, -0.3790397812941526, -0.9844158212941525, 5.0, 0.41094193932059253, -0.8218838786411851,
            -0.3945042617477688, 4.0, 0.5292568487058473, 0.12096021870584739, -1.4844158212941525, 5.0,
            0.4471420584931018, -0.8942841169862036, 0.017885682339724072, 4.0, 0.5292568487058473, 0.12096021870584739,
            -0.9844158212941525, 5.0, 0.5360254622430297, -0.8040381933645446, -0.2572922218766543, 4.0,
            0.5292568487058473, -0.3790397812941526, -0.9844158212941525, 5.0, 0.4471420584931018, -0.8942841169862036,
            0.017885682339724072, 4.0, 0.5292568487058473, 0.12096021870584739, -0.9844158212941525, 5.0,
            0.6607608945998119, -0.33038044729990595, 0.6739761124918081, 4.0, 0.5292568487058473, 0.12096021870584739,
            -0.9844158212941525, 5.0, 0.3729266969758427, -0.7458533939516854, -0.5519315115242471, 4.0,
            0.5292568487058473, 0.12096021870584739, -1.9844158212941525, 5.0, 0.3734464267162477, -0.5601696400743716,
            -0.7394239248981705, 4.0, 0.5292568487058473, 0.6209602187058474, -2.4844158212941525, 5.0,
            0.5811989248480778, -0.5811989248480778, -0.5695749463511162, 4.0, 0.5292568487058473, 0.6209602187058474,
            -1.9844158212941525, 5.0, 0.5811989248480778, -0.5811989248480778, -0.5695749463511162, 4.0,
            0.5292568487058473, 0.6209602187058474, -1.9844158212941525, 5.0, 0.8218838786411851, -0.41094193932059253,
            -0.3945042617477688, 4.0, 1.0292568487058473, 0.6209602187058474, -1.9844158212941525, 5.0,
            0.6419172257455104, -0.6419172257455104, -0.4193859208204001, 4.0, 1.0292568487058473, 0.12096021870584739,
            -1.4844158212941525, 5.0, 0.5811989248480778, -0.5811989248480778, -0.5695749463511162, 4.0,
            0.5292568487058473, 0.6209602187058474, -1.9844158212941525, 5.0, 0.6419172257455104, -0.6419172257455104,
            -0.4193859208204001, 4.0, 1.0292568487058473, 0.12096021870584739, -1.4844158212941525, 5.0,
            0.3729266969758427, -0.7458533939516854, -0.5519315115242471, 4.0, 0.5292568487058473, 0.12096021870584739,
            -1.9844158212941525, 5.0, 0.3729266969758427, -0.7458533939516854, -0.5519315115242471, 4.0,
            0.5292568487058473, 0.12096021870584739, -1.9844158212941525, 5.0, 0.6419172257455104, -0.6419172257455104,
            -0.4193859208204001, 4.0, 1.0292568487058473, 0.12096021870584739, -1.4844158212941525, 5.0, 0.0,
            -0.9999500037496877, 0.009999500037496877, 4.0, 0.5292568487058473, 0.12096021870584739,
            -1.4844158212941525, 5.0, 0.41094193932059253, -0.8218838786411851, -0.3945042617477688, 4.0,
            0.5292568487058473, 0.12096021870584739, -1.4844158212941525, 5.0, 0.5999808009215509, -0.7999744012287345,
            0.007999744012287346, 4.0, 1.0292568487058473, 0.12096021870584739, -0.9844158212941525, 5.0,
            0.4471420584931018, -0.8942841169862036, 0.017885682339724072, 4.0, 0.5292568487058473, 0.12096021870584739,
            -0.9844158212941525, 5.0, 0.41094193932059253, -0.8218838786411851, -0.3945042617477688, 4.0,
            0.5292568487058473, 0.12096021870584739, -1.4844158212941525, 5.0, 0.0, -0.9999500037496877,
            0.009999500037496877, 4.0, 0.5292568487058473, 0.12096021870584739, -1.4844158212941525, 5.0,
            0.5999808009215509, -0.7999744012287345, 0.007999744012287346, 4.0, 1.0292568487058473, 0.12096021870584739,
            -0.9844158212941525, 5.0, 0.0, -0.9999500037496877, 0.009999500037496877, 4.0, 0.5292568487058473,
            0.12096021870584739, -1.4844158212941525, 5.0, 0.6419172257455104, -0.6419172257455104, -0.4193859208204001,
            4.0, 1.0292568487058473, 0.12096021870584739, -1.4844158212941525, 5.0, 0.5999808009215509,
            -0.7999744012287345, 0.007999744012287346, 4.0, 1.0292568487058473, 0.12096021870584739,
            -0.9844158212941525, 5.0, 0.4471420584931018, -0.8942841169862036, 0.017885682339724072, 4.0,
            0.5292568487058473, 0.12096021870584739, -0.9844158212941525, 5.0, 0.0, -0.9999680015359181,
            0.007999744012287346, 4.0, 0.5292568487058473, 0.12096021870584739, -0.4844158212941525, 5.0,
            0.6607608945998119, -0.33038044729990595, 0.6739761124918081, 4.0, 0.5292568487058473, 0.12096021870584739,
            -0.9844158212941525, 5.0, 0.4471420584931018, -0.8942841169862036, 0.017885682339724072, 4.0,
            0.5292568487058473, 0.12096021870584739, -0.9844158212941525, 5.0, 0.5999808009215509, -0.7999744012287345,
            0.007999744012287346, 4.0, 1.0292568487058473, 0.12096021870584739, -0.9844158212941525, 5.0, 0.0,
            -0.9999680015359181, 0.007999744012287346, 4.0, 0.5292568487058473, 0.12096021870584739,
            -0.4844158212941525, 5.0, 0.5999808009215509, -0.7999744012287345, 0.007999744012287346, 4.0,
            1.0292568487058473, 0.12096021870584739, -0.9844158212941525, 5.0, 0.799457263915735, -0.5329715092771566,
            0.2771451848241215, 4.0, 1.0292568487058473, 0.12096021870584739, -0.4844158212941525, 5.0, 0.0,
            -0.9999680015359181, 0.007999744012287346, 4.0, 0.5292568487058473, 0.12096021870584739,
            -0.4844158212941525, 5.0, 0.5735016055486672, -0.5735016055486672, 0.5849716376596406, 4.0,
            1.0292568487058473, 0.6209602187058474, -0.4844158212941525, 5.0, 0.5696549391872194, -0.5696549391872194,
            0.5924411367547082, 4.0, 0.5292568487058473, 0.6209602187058474, 0.015584178705847496, 5.0,
            0.4240792104664812, -0.6361188156997218, 0.6446003999090515, 4.0, 0.5292568487058473, 0.12096021870584739,
            0.015584178705847496, 5.0, 0.5735016055486672, -0.5735016055486672, 0.5849716376596406, 4.0,
            1.0292568487058473, 0.6209602187058474, -0.4844158212941525, 5.0, 0.4240792104664812, -0.6361188156997218,
            0.6446003999090515, 4.0, 0.5292568487058473, 0.12096021870584739, 0.015584178705847496, 5.0,
            0.799457263915735, -0.5329715092771566, 0.2771451848241215, 4.0, 1.0292568487058473, 0.12096021870584739,
            -0.4844158212941525, 5.0, 0.799457263915735, -0.5329715092771566, 0.2771451848241215, 4.0,
            1.0292568487058473, 0.12096021870584739, -0.4844158212941525, 5.0, 0.4240792104664812, -0.6361188156997218,
            0.6446003999090515, 4.0, 0.5292568487058473, 0.12096021870584739, 0.015584178705847496, 5.0, 0.0,
            -0.9999680015359181, 0.007999744012287346, 4.0, 0.5292568487058473, 0.12096021870584739,
            -0.4844158212941525, 5.0, 0.4240792104664812, -0.6361188156997218, 0.6446003999090515, 4.0,
            0.5292568487058473, 0.12096021870584739, 0.015584178705847496, 5.0, 0.5696549391872194, -0.5696549391872194,
            0.5924411367547082, 4.0, 0.5292568487058473, 0.6209602187058474, 0.015584178705847496, 5.0, 0.0,
            -0.8269265020695281, 0.5623100214072791, 4.0, 0.5292568487058473, 0.6209602187058474, 0.015584178705847496,
            5.0, 0.6695894800069753, -0.6695894800069753, -0.3214029504033481, 4.0, 1.0292568487058473,
            0.6209602187058474, -1.9844158212941525, 5.0, 0.5811989248480778, -0.5811989248480778, -0.5695749463511162,
            4.0, 0.5292568487058473, 0.6209602187058474, -1.9844158212941525, 5.0, 0.3734464267162477,
            -0.5601696400743716, -0.7394239248981705, 4.0, 0.5292568487058473, 0.6209602187058474, -2.4844158212941525,
            5.0, 0.6695894800069753, -0.6695894800069753, -0.3214029504033481, 4.0, 1.0292568487058473,
            0.6209602187058474, -1.9844158212941525, 5.0, 0.3734464267162477, -0.5601696400743716, -0.7394239248981705,
            4.0, 0.5292568487058473, 0.6209602187058474, -2.4844158212941525, 5.0, 0.7880859319007489,
            -0.19702148297518723, -0.5831835896065543, 4.0, 1.0292568487058473, 1.1209602187058474, -2.4844158212941525,
            5.0, 0.7880859319007489, -0.19702148297518723, -0.5831835896065543, 4.0, 1.0292568487058473,
            1.1209602187058474, -2.4844158212941525, 5.0, 0.3734464267162477, -0.5601696400743716, -0.7394239248981705,
            4.0, 0.5292568487058473, 0.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0,
            0.5292568487058473, 1.1209602187058474, -2.4844158212941525, 5.0, 0.5811989248480778, -0.5811989248480778,
            -0.5695749463511162, 4.0, 0.5292568487058473, 0.6209602187058474, -1.9844158212941525, 5.0,
            0.6695894800069753, -0.6695894800069753, -0.3214029504033481, 4.0, 1.0292568487058473, 0.6209602187058474,
            -1.9844158212941525, 5.0, 0.8218838786411851, -0.41094193932059253, -0.3945042617477688, 4.0,
            1.0292568487058473, 0.6209602187058474, -1.9844158212941525, 5.0, 0.5735016055486672, -0.5735016055486672,
            0.5849716376596406, 4.0, 1.0292568487058473, 0.6209602187058474, -0.4844158212941525, 5.0,
            0.5747843685791867, -0.5747843685791867, 0.5824481601602425, 4.0, 1.0292568487058473, 0.6209602187058474,
            0.015584178705847496, 5.0, 0.5696549391872194, -0.5696549391872194, 0.5924411367547082, 4.0,
            0.5292568487058473, 0.6209602187058474, 0.015584178705847496, 5.0, 0.5735016055486672, -0.5735016055486672,
            0.5849716376596406, 4.0, 1.0292568487058473, 1.1209602187058474, 0.015584178705847496, 5.0,
            0.4028591660373982, -0.4028591660373982, 0.8218326987162923, 4.0, 0.5292568487058473, 1.1209602187058474,
            0.5155841787058475, 5.0, 0.4816607005330728, -0.4816607005330728, 0.7321242648102707, 4.0,
            0.5292568487058473, 0.6209602187058474, 0.5155841787058475, 5.0, 0.5747843685791867, -0.5747843685791867,
            0.5824481601602425, 4.0, 1.0292568487058473, 0.6209602187058474, 0.015584178705847496, 5.0,
            0.5735016055486672, -0.5735016055486672, 0.5849716376596406, 4.0, 1.0292568487058473, 1.1209602187058474,
            0.015584178705847496, 5.0, 0.4816607005330728, -0.4816607005330728, 0.7321242648102707, 4.0,
            0.5292568487058473, 0.6209602187058474, 0.5155841787058475, 5.0, 0.5747843685791867, -0.5747843685791867,
            0.5824481601602425, 4.0, 1.0292568487058473, 0.6209602187058474, 0.015584178705847496, 5.0,
            0.4816607005330728, -0.4816607005330728, 0.7321242648102707, 4.0, 0.5292568487058473, 0.6209602187058474,
            0.5155841787058475, 5.0, 0.0, -0.8269265020695281, 0.5623100214072791, 4.0, 0.5292568487058473,
            0.6209602187058474, 0.015584178705847496, 5.0, 0.5747843685791867, -0.5747843685791867, 0.5824481601602425,
            4.0, 1.0292568487058473, 0.6209602187058474, 0.015584178705847496, 5.0, 0.0, -0.8269265020695281,
            0.5623100214072791, 4.0, 0.5292568487058473, 0.6209602187058474, 0.015584178705847496, 5.0,
            0.5696549391872194, -0.5696549391872194, 0.5924411367547082, 4.0, 0.5292568487058473, 0.6209602187058474,
            0.015584178705847496, 5.0, 0.4816607005330728, -0.4816607005330728, 0.7321242648102707, 4.0,
            0.5292568487058473, 0.6209602187058474, 0.5155841787058475, 5.0, 0.4028591660373982, -0.4028591660373982,
            0.8218326987162923, 4.0, 0.5292568487058473, 1.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0,
            4.0, 0.5292568487058473, 1.1209602187058474, 0.5155841787058475, 5.0, 0.6695894800069753,
            -0.6695894800069753, -0.3214029504033481, 4.0, 0.5292568487058473, 1.1209602187058474, -2.4844158212941525,
            5.0, 0.7880859319007489, -0.19702148297518723, -0.5831835896065543, 4.0, 0.5292568487058473,
            1.6209602187058474, -2.9844158212941525, 5.0, 0.7142128391425071, 0.0, -0.699928582359657, 4.0,
            0.5292568487058473, 1.6209602187058474, -2.4844158212941525, 5.0, 0.7142128391425071, 0.0,
            -0.699928582359657, 4.0, 0.5292568487058473, 1.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0,
            4.0, 0.5292568487058473, 1.1209602187058474, -2.4844158212941525, 5.0, 0.6695894800069753,
            -0.6695894800069753, -0.3214029504033481, 4.0, 0.5292568487058473, 1.1209602187058474, -2.4844158212941525,
            5.0, 0.7142128391425071, 0.0, -0.699928582359657, 4.0, 0.5292568487058473, 1.6209602187058474,
            -2.4844158212941525, 5.0, 0.6038576879954624, 0.0, -0.7970921481540103, 4.0, 1.0292568487058473,
            1.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, 0.5292568487058473, 1.1209602187058474,
            -2.4844158212941525, 5.0, 0.6038576879954624, 0.0, -0.7970921481540103, 4.0, 1.0292568487058473,
            1.6209602187058474, -2.4844158212941525, 5.0, 0.7880859319007489, -0.19702148297518723, -0.5831835896065543,
            4.0, 1.0292568487058473, 1.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0,
            0.5292568487058473, 1.1209602187058474, -2.4844158212941525, 5.0, 0.5735016055486672, -0.5735016055486672,
            0.5849716376596406, 4.0, 1.0292568487058473, 1.1209602187058474, 0.015584178705847496, 5.0,
            0.4816607005330728, -0.4816607005330728, 0.7321242648102707, 4.0, 1.0292568487058473, 1.1209602187058474,
            0.5155841787058475, 5.0, 0.4028591660373982, -0.4028591660373982, 0.8218326987162923, 4.0,
            0.5292568487058473, 1.1209602187058474, 0.5155841787058475, 5.0, 0.4028591660373982, -0.4028591660373982,
            0.8218326987162923, 4.0, 0.5292568487058473, 1.1209602187058474, 0.5155841787058475, 5.0,
            0.4816607005330728, -0.4816607005330728, 0.7321242648102707, 4.0, 1.0292568487058473, 1.1209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 1.0292568487058473, 1.6209602187058474, 0.5155841787058475,
            5.0, 0.4028591660373982, -0.4028591660373982, 0.8218326987162923, 4.0, 0.5292568487058473,
            1.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 1.0292568487058473, 1.6209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473, 1.1209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473, 1.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0,
            4.0, 1.0292568487058473, 1.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0,
            0.5292568487058473, 1.6209602187058474, 0.5155841787058475, 5.0, 0.7142128391425071, 0.0,
            -0.699928582359657, 4.0, 0.5292568487058473, 2.1209602187058474, -2.4844158212941525, 5.0,
            0.7142128391425071, 0.0, -0.699928582359657, 4.0, 0.5292568487058473, 1.6209602187058474,
            -2.4844158212941525, 5.0, 0.7880859319007489, -0.19702148297518723, -0.5831835896065543, 4.0,
            0.5292568487058473, 1.6209602187058474, -2.9844158212941525, 5.0, 0.33630596344635905, 0.6726119268927181,
            -0.6591596883548637, 4.0, 0.5292568487058473, 2.1209602187058474, -2.9844158212941525, 5.0,
            0.7142128391425071, 0.0, -0.699928582359657, 4.0, 0.5292568487058473, 2.1209602187058474,
            -2.4844158212941525, 5.0, 0.7880859319007489, -0.19702148297518723, -0.5831835896065543, 4.0,
            0.5292568487058473, 1.6209602187058474, -2.9844158212941525, 5.0, 0.6038576879954624, 0.0,
            -0.7970921481540103, 4.0, 1.0292568487058473, 1.6209602187058474, -2.4844158212941525, 5.0,
            0.7142128391425071, 0.0, -0.699928582359657, 4.0, 0.5292568487058473, 2.1209602187058474,
            -2.4844158212941525, 5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0, 1.0292568487058473,
            2.1209602187058474, -2.4844158212941525, 5.0, 0.7142128391425071, 0.0, -0.699928582359657, 4.0,
            0.5292568487058473, 1.6209602187058474, -2.4844158212941525, 5.0, 0.7142128391425071, 0.0,
            -0.699928582359657, 4.0, 0.5292568487058473, 2.1209602187058474, -2.4844158212941525, 5.0,
            0.6038576879954624, 0.0, -0.7970921481540103, 4.0, 1.0292568487058473, 1.6209602187058474,
            -2.4844158212941525, 5.0, 0.0, 0.0, 1.0, 4.0, 1.0292568487058473, 1.6209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, 1.0292568487058473, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0,
            4.0, 0.5292568487058473, 1.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0,
            1.0292568487058473, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473,
            2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473, 1.6209602187058474,
            0.5155841787058475, 5.0, 0.7142128391425071, 0.0, -0.699928582359657, 4.0, 0.5292568487058473,
            2.1209602187058474, -2.4844158212941525, 5.0, 0.33630596344635905, 0.6726119268927181, -0.6591596883548637,
            4.0, 0.5292568487058473, 2.1209602187058474, -2.9844158212941525, 5.0, 0.0, 0.454470341687874,
            -0.890761869708233, 4.0, 0.5292568487058473, 2.1209602187058474, -2.4844158212941525, 5.0, 0.0,
            0.454470341687874, -0.890761869708233, 4.0, 0.5292568487058473, 2.1209602187058474, -2.4844158212941525,
            5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0, 1.0292568487058473, 2.1209602187058474,
            -2.4844158212941525, 5.0, 0.7142128391425071, 0.0, -0.699928582359657, 4.0, 0.5292568487058473,
            2.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.454470341687874, -0.890761869708233, 4.0,
            0.5292568487058473, 2.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, 0.5292568487058473,
            2.6209602187058474, -2.4844158212941525, 5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0,
            1.0292568487058473, 2.1209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, 0.5292568487058473,
            2.6209602187058474, -2.4844158212941525, 5.0, 0.731020541251032, 0.48734702750068803, -0.47760008695067424,
            4.0, 1.0292568487058473, 2.6209602187058474, -2.4844158212941525, 5.0, 0.711836432832338, 0.0,
            -0.7023452803945736, 4.0, 1.0292568487058473, 2.1209602187058474, -2.4844158212941525, 5.0,
            0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, 1.0292568487058473, 2.6209602187058474,
            0.015584178705847496, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            0.5292568487058473, 2.6209602187058474, 0.5155841787058475, 5.0, 0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, 1.0292568487058473, 2.1209602187058474, 0.5155841787058475, 5.0,
            0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, 1.0292568487058473, 2.1209602187058474,
            0.5155841787058475, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            0.5292568487058473, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473,
            2.6209602187058474, 0.5155841787058475, 5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082,
            4.0, 1.0292568487058473, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0,
            0.5292568487058473, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 1.0292568487058473,
            2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 1.0292568487058473, 2.1209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473, 2.6209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473, 2.1209602187058474, 0.5155841787058475, 5.0, 0.731020541251032,
            0.48734702750068803, -0.47760008695067424, 4.0, 0.5292568487058473, 3.1209602187058474, -1.9844158212941525,
            5.0, 0.8218838786411851, 0.41094193932059253, -0.3945042617477688, 4.0, 1.0292568487058473,
            2.6209602187058474, -1.9844158212941525, 5.0, 0.731020541251032, 0.48734702750068803, -0.47760008695067424,
            4.0, 1.0292568487058473, 2.6209602187058474, -2.4844158212941525, 5.0, 0.731020541251032,
            0.48734702750068803, -0.47760008695067424, 4.0, 0.5292568487058473, 3.1209602187058474, -1.9844158212941525,
            5.0, 0.731020541251032, 0.48734702750068803, -0.47760008695067424, 4.0, 1.0292568487058473,
            2.6209602187058474, -2.4844158212941525, 5.0, 0.5100035088362113, 0.1700011696120704, -0.8432058012758692,
            4.0, 0.5292568487058473, 3.1209602187058474, -2.4844158212941525, 5.0, 0.5100035088362113,
            0.1700011696120704, -0.8432058012758692, 4.0, 0.5292568487058473, 3.1209602187058474, -2.4844158212941525,
            5.0, 0.731020541251032, 0.48734702750068803, -0.47760008695067424, 4.0, 1.0292568487058473,
            2.6209602187058474, -2.4844158212941525, 5.0, 0.0, 0.0, -1.0, 4.0, 0.5292568487058473, 2.6209602187058474,
            -2.4844158212941525, 5.0, 0.8218838786411851, 0.41094193932059253, -0.3945042617477688, 4.0,
            1.0292568487058473, 2.6209602187058474, -1.9844158212941525, 5.0, 0.731020541251032, 0.48734702750068803,
            -0.47760008695067424, 4.0, 0.5292568487058473, 3.1209602187058474, -1.9844158212941525, 5.0,
            0.711836432832338, 0.0, -0.7023452803945736, 4.0, 1.0292568487058473, 3.1209602187058474,
            -1.9844158212941525, 5.0, 0.6607608945998119, 0.33038044729990595, 0.6739761124918081, 4.0,
            1.0292568487058473, 3.1209602187058474, -0.4844158212941525, 5.0, 0.6839126923543284, 0.22797089745144278,
            0.6930315282523861, 4.0, 0.5292568487058473, 3.1209602187058474, 0.015584178705847496, 5.0,
            0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, 1.0292568487058473, 2.6209602187058474,
            0.015584178705847496, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            0.5292568487058473, 2.6209602187058474, 0.5155841787058475, 5.0, 0.2649845836453722, 0.5299691672907444,
            0.8055531342819315, 4.0, 0.5292568487058473, 3.1209602187058474, 0.015584178705847496, 5.0, 0.0,
            0.7000714109260575, 0.7140728391445786, 4.0, 0.5292568487058473, 2.6209602187058474, 0.5155841787058475,
            5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, 1.0292568487058473,
            2.6209602187058474, 0.015584178705847496, 5.0, 0.2649845836453722, 0.5299691672907444, 0.8055531342819315,
            4.0, 0.5292568487058473, 3.1209602187058474, 0.015584178705847496, 5.0, 0.5735016055486672,
            0.5735016055486672, 0.5849716376596406, 4.0, 0.5292568487058473, 2.6209602187058474, 0.5155841787058475,
            5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, 1.0292568487058473,
            2.6209602187058474, 0.015584178705847496, 5.0, 0.6839126923543284, 0.22797089745144278, 0.6930315282523861,
            4.0, 0.5292568487058473, 3.1209602187058474, 0.015584178705847496, 5.0, 0.2649845836453722,
            0.5299691672907444, 0.8055531342819315, 4.0, 0.5292568487058473, 3.1209602187058474, 0.015584178705847496,
            5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, 1.0292568487058473,
            2.6209602187058474, 0.015584178705847496, 5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082,
            4.0, 1.0292568487058473, 2.6209602187058474, 0.015584178705847496, 5.0, 0.6839126923543284,
            0.22797089745144278, 0.6930315282523861, 4.0, 0.5292568487058473, 3.1209602187058474, 0.015584178705847496,
            5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, 0.5292568487058473,
            2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.7000714109260575, 0.7140728391445786, 4.0,
            0.5292568487058473, 2.6209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473,
            2.6209602187058474, 0.5155841787058475, 5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0,
            0.5292568487058473, 3.6209602187058474, -1.9844158212941525, 5.0, 0.731020541251032, 0.48734702750068803,
            -0.47760008695067424, 4.0, 0.5292568487058473, 3.1209602187058474, -1.9844158212941525, 5.0,
            0.5100035088362113, 0.1700011696120704, -0.8432058012758692, 4.0, 0.5292568487058473, 3.1209602187058474,
            -2.4844158212941525, 5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0, 0.5292568487058473,
            3.6209602187058474, -2.4844158212941525, 5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0,
            0.5292568487058473, 3.6209602187058474, -1.9844158212941525, 5.0, 0.5100035088362113, 0.1700011696120704,
            -0.8432058012758692, 4.0, 0.5292568487058473, 3.1209602187058474, -2.4844158212941525, 5.0,
            0.711836432832338, 0.0, -0.7023452803945736, 4.0, 1.0292568487058473, 3.1209602187058474,
            -1.9844158212941525, 5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0, 0.5292568487058473,
            3.6209602187058474, -1.9844158212941525, 5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0,
            1.0292568487058473, 3.6209602187058474, -1.9844158212941525, 5.0, 0.731020541251032, 0.48734702750068803,
            -0.47760008695067424, 4.0, 0.5292568487058473, 3.1209602187058474, -1.9844158212941525, 5.0,
            0.711836432832338, 0.0, -0.7023452803945736, 4.0, 0.5292568487058473, 3.6209602187058474,
            -1.9844158212941525, 5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0, 1.0292568487058473,
            3.1209602187058474, -1.9844158212941525, 5.0, 0.6839126923543284, 0.22797089745144278, 0.6930315282523861,
            4.0, 1.0292568487058473, 3.6209602187058474, -0.4844158212941525, 5.0, 0.6839126923543284,
            0.22797089745144278, 0.6930315282523861, 4.0, 0.5292568487058473, 3.1209602187058474, 0.015584178705847496,
            5.0, 0.6607608945998119, 0.33038044729990595, 0.6739761124918081, 4.0, 1.0292568487058473,
            3.1209602187058474, -0.4844158212941525, 5.0, 0.6607608945998119, 0.33038044729990595, 0.6739761124918081,
            4.0, 0.5292568487058473, 3.6209602187058474, 0.015584178705847496, 5.0, 0.6839126923543284,
            0.22797089745144278, 0.6930315282523861, 4.0, 0.5292568487058473, 3.1209602187058474, 0.015584178705847496,
            5.0, 0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0, 1.0292568487058473,
            3.6209602187058474, -0.4844158212941525, 5.0, 0.6839126923543284, 0.22797089745144278, 0.6930315282523861,
            4.0, 0.5292568487058473, 3.1209602187058474, 0.015584178705847496, 5.0, 0.6607608945998119,
            0.33038044729990595, 0.6739761124918081, 4.0, 0.5292568487058473, 3.6209602187058474, 0.015584178705847496,
            5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473, 3.6209602187058474, 0.015584178705847496, 5.0,
            0.2649845836453722, 0.5299691672907444, 0.8055531342819315, 4.0, 0.5292568487058473, 3.1209602187058474,
            0.015584178705847496, 5.0, 0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0,
            0.5292568487058473, 3.1209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473,
            3.6209602187058474, 0.015584178705847496, 5.0, 0.6430960514818236, 0.4287307009878824, -0.634521437462066,
            4.0, 0.5292568487058473, 4.120960218705847, -1.9844158212941525, 5.0, 0.711836432832338, 0.0,
            -0.7023452803945736, 4.0, 0.5292568487058473, 3.6209602187058474, -1.9844158212941525, 5.0,
            0.711836432832338, 0.0, -0.7023452803945736, 4.0, 0.5292568487058473, 3.6209602187058474,
            -2.4844158212941525, 5.0, 0.41094193932059253, 0.8218838786411851, -0.3945042617477688, 4.0,
            0.5292568487058473, 4.120960218705847, -2.4844158212941525, 5.0, 0.6430960514818236, 0.4287307009878824,
            -0.634521437462066, 4.0, 0.5292568487058473, 4.120960218705847, -1.9844158212941525, 5.0, 0.711836432832338,
            0.0, -0.7023452803945736, 4.0, 0.5292568487058473, 3.6209602187058474, -2.4844158212941525, 5.0,
            0.711836432832338, 0.0, -0.7023452803945736, 4.0, 1.0292568487058473, 3.6209602187058474,
            -1.9844158212941525, 5.0, 0.6430960514818236, 0.4287307009878824, -0.634521437462066, 4.0,
            0.5292568487058473, 4.120960218705847, -1.9844158212941525, 5.0, 0.5850454715011363, 0.5850454715011363,
            -0.5616436526410908, 4.0, 1.0292568487058473, 4.120960218705847, -1.9844158212941525, 5.0,
            0.711836432832338, 0.0, -0.7023452803945736, 4.0, 0.5292568487058473, 3.6209602187058474,
            -1.9844158212941525, 5.0, 0.6430960514818236, 0.4287307009878824, -0.634521437462066, 4.0,
            0.5292568487058473, 4.120960218705847, -1.9844158212941525, 5.0, 0.711836432832338, 0.0,
            -0.7023452803945736, 4.0, 1.0292568487058473, 3.6209602187058474, -1.9844158212941525, 5.0,
            0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, 1.0292568487058473, 4.120960218705847,
            -0.9844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            0.5292568487058473, 4.120960218705847, -0.4844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, 1.0292568487058473, 3.6209602187058474, -0.4844158212941525, 5.0,
            0.6607608945998119, 0.33038044729990595, 0.6739761124918081, 4.0, 0.5292568487058473, 3.6209602187058474,
            0.015584178705847496, 5.0, 0.5747843685791867, 0.5747843685791867, 0.5824481601602425, 4.0,
            0.5292568487058473, 4.120960218705847, -0.4844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, 0.5292568487058473, 3.6209602187058474, 0.015584178705847496, 5.0,
            0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0, 1.0292568487058473, 3.6209602187058474,
            -0.4844158212941525, 5.0, 0.5747843685791867, 0.5747843685791867, 0.5824481601602425, 4.0,
            0.5292568487058473, 4.120960218705847, -0.4844158212941525, 5.0, 0.6607608945998119, 0.33038044729990595,
            0.6739761124918081, 4.0, 0.5292568487058473, 3.6209602187058474, 0.015584178705847496, 5.0,
            0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0, 1.0292568487058473, 3.6209602187058474,
            -0.4844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            0.5292568487058473, 4.120960218705847, -0.4844158212941525, 5.0, 0.5747843685791867, 0.5747843685791867,
            0.5824481601602425, 4.0, 0.5292568487058473, 4.120960218705847, -0.4844158212941525, 5.0,
            0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0, 1.0292568487058473, 3.6209602187058474,
            -0.4844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0,
            1.0292568487058473, 3.6209602187058474, -0.4844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672,
            0.5849716376596406, 4.0, 0.5292568487058473, 4.120960218705847, -0.4844158212941525, 5.0,
            0.6607608945998119, 0.33038044729990595, 0.6739761124918081, 4.0, 0.5292568487058473, 3.6209602187058474,
            0.015584178705847496, 5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0,
            0.5292568487058473, 3.6209602187058474, 0.015584178705847496, 5.0, 0.0, 0.0, 1.0, 4.0, 0.5292568487058473,
            3.6209602187058474, 0.015584178705847496, 5.0, 0.6430960514818236, 0.4287307009878824, -0.634521437462066,
            4.0, 0.5292568487058473, 4.120960218705847, -1.9844158212941525, 5.0, 0.41094193932059253,
            0.8218838786411851, -0.3945042617477688, 4.0, 0.5292568487058473, 4.120960218705847, -2.4844158212941525,
            5.0, 0.5850454715011363, 0.5850454715011363, -0.5616436526410908, 4.0, 0.5292568487058473,
            4.120960218705847, -1.9844158212941525, 5.0, 0.5850454715011363, 0.5850454715011363, -0.5616436526410908,
            4.0, 0.5292568487058473, 4.120960218705847, -1.9844158212941525, 5.0, 0.33630596344635905,
            0.6726119268927181, -0.6591596883548637, 4.0, 0.5292568487058473, 4.620960218705847, -1.9844158212941525,
            5.0, 0.8040381933645446, 0.5360254622430297, -0.2572922218766543, 4.0, 0.5292568487058473,
            4.620960218705847, -1.4844158212941525, 5.0, 0.6430960514818236, 0.4287307009878824, -0.634521437462066,
            4.0, 0.5292568487058473, 4.120960218705847, -1.9844158212941525, 5.0, 0.5850454715011363,
            0.5850454715011363, -0.5616436526410908, 4.0, 0.5292568487058473, 4.120960218705847, -1.9844158212941525,
            5.0, 0.8040381933645446, 0.5360254622430297, -0.2572922218766543, 4.0, 0.5292568487058473,
            4.620960218705847, -1.4844158212941525, 5.0, 0.6430960514818236, 0.4287307009878824, -0.634521437462066,
            4.0, 0.5292568487058473, 4.120960218705847, -1.9844158212941525, 5.0, 0.8040381933645446,
            0.5360254622430297, -0.2572922218766543, 4.0, 0.5292568487058473, 4.620960218705847, -1.4844158212941525,
            5.0, 0.5892374649279242, 0.7856499532372323, -0.18855598877693575, 4.0, 1.0292568487058473,
            4.120960218705847, -1.4844158212941525, 5.0, 0.6430960514818236, 0.4287307009878824, -0.634521437462066,
            4.0, 0.5292568487058473, 4.120960218705847, -1.9844158212941525, 5.0, 0.5892374649279242,
            0.7856499532372323, -0.18855598877693575, 4.0, 1.0292568487058473, 4.120960218705847, -1.4844158212941525,
            5.0, 0.5850454715011363, 0.5850454715011363, -0.5616436526410908, 4.0, 1.0292568487058473,
            4.120960218705847, -1.9844158212941525, 5.0, 0.5892374649279242, 0.7856499532372323, -0.18855598877693575,
            4.0, 1.0292568487058473, 4.120960218705847, -1.4844158212941525, 5.0, 0.7070360811132631,
            0.7070360811132631, 0.014140721622265262, 4.0, 0.5292568487058473, 4.620960218705847, -0.9844158212941525,
            5.0, 0.7068241080666424, 0.7068241080666424, 0.028272964322665697, 4.0, 1.0292568487058473,
            4.120960218705847, -0.9844158212941525, 5.0, 0.8040381933645446, 0.5360254622430297, -0.2572922218766543,
            4.0, 0.5292568487058473, 4.620960218705847, -1.4844158212941525, 5.0, 0.7070360811132631,
            0.7070360811132631, 0.014140721622265262, 4.0, 0.5292568487058473, 4.620960218705847, -0.9844158212941525,
            5.0, 0.5892374649279242, 0.7856499532372323, -0.18855598877693575, 4.0, 1.0292568487058473,
            4.120960218705847, -1.4844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406,
            4.0, 0.5292568487058473, 4.120960218705847, -0.4844158212941525, 5.0, 0.5735016055486672,
            0.5735016055486672, 0.5849716376596406, 4.0, 0.5292568487058473, 4.620960218705847, -0.9844158212941525,
            5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, 0.5292568487058473, 4.120960218705847,
            -0.4844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            1.0292568487058473, 4.120960218705847, -0.9844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672,
            0.5849716376596406, 4.0, 0.5292568487058473, 4.620960218705847, -0.9844158212941525, 5.0,
            0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, 0.5292568487058473, 4.120960218705847,
            -0.4844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            1.0292568487058473, 4.120960218705847, -0.9844158212941525, 5.0, 0.7070360811132631, 0.7070360811132631,
            0.014140721622265262, 4.0, 0.5292568487058473, 4.620960218705847, -0.9844158212941525, 5.0,
            0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, 0.5292568487058473, 4.620960218705847,
            -0.9844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            1.0292568487058473, 4.120960218705847, -0.9844158212941525, 5.0, 0.7068241080666424, 0.7068241080666424,
            0.028272964322665697, 4.0, 1.0292568487058473, 4.120960218705847, -0.9844158212941525, 5.0,
            0.7070360811132631, 0.7070360811132631, 0.014140721622265262, 4.0, 0.5292568487058473, 4.620960218705847,
            -0.9844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            0.5292568487058473, 4.120960218705847, -0.4844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, 0.5292568487058473, 4.120960218705847, -0.4844158212941525, 5.0,
            0.5747843685791867, 0.5747843685791867, 0.5824481601602425, 4.0, 0.5292568487058473, 4.120960218705847,
            -0.4844158212941525, 5.0, 0.8040381933645446, 0.5360254622430297, -0.2572922218766543, 4.0,
            0.5292568487058473, 4.620960218705847, -1.4844158212941525, 5.0, 0.33630596344635905, 0.6726119268927181,
            -0.6591596883548637, 4.0, 0.5292568487058473, 4.620960218705847, -1.9844158212941525, 5.0, 0.0,
            0.9998000599800071, 0.01999600119960014, 4.0, 0.5292568487058473, 4.620960218705847, -1.4844158212941525,
            5.0, 0.7070360811132631, 0.7070360811132631, 0.014140721622265262, 4.0, 0.5292568487058473,
            4.620960218705847, -0.9844158212941525, 5.0, 0.8040381933645446, 0.5360254622430297, -0.2572922218766543,
            4.0, 0.5292568487058473, 4.620960218705847, -1.4844158212941525, 5.0, 0.0, 0.9998000599800071,
            0.01999600119960014, 4.0, 0.5292568487058473, 4.620960218705847, -1.4844158212941525, 5.0, 0.0,
            0.9999111229612074, 0.013332148306149432, 4.0, 0.5292568487058473, 4.620960218705847, -0.9844158212941525,
            5.0, 0.7070360811132631, 0.7070360811132631, 0.014140721622265262, 4.0, 0.5292568487058473,
            4.620960218705847, -0.9844158212941525, 5.0, 0.0, 0.9998000599800071, 0.01999600119960014, 4.0,
            0.5292568487058473, 4.620960218705847, -1.4844158212941525, 5.0, 0.7070360811132631, 0.7070360811132631,
            0.014140721622265262, 4.0, 0.5292568487058473, 4.620960218705847, -0.9844158212941525, 5.0, 0.0,
            0.9999111229612074, 0.013332148306149432, 4.0, 0.5292568487058473, 4.620960218705847, -0.9844158212941525,
            5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, 0.5292568487058473, 4.620960218705847,
            -0.9844158212941525, 5.0, 0.6419172257455104, -0.6419172257455104, -0.4193859208204001, 4.0,
            1.0292568487058473, 0.12096021870584739, -1.4844158212941525, 5.0, 0.8218838786411851, -0.41094193932059253,
            -0.3945042617477688, 4.0, 1.0292568487058473, 0.6209602187058474, -1.9844158212941525, 5.0,
            0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.0292568487058473, 0.6209602187058474,
            -1.4844158212941525, 5.0, 0.5999808009215509, -0.7999744012287345, 0.007999744012287346, 4.0,
            1.0292568487058473, 0.12096021870584739, -0.9844158212941525, 5.0, 0.6419172257455104, -0.6419172257455104,
            -0.4193859208204001, 4.0, 1.0292568487058473, 0.12096021870584739, -1.4844158212941525, 5.0,
            0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.0292568487058473, 0.6209602187058474,
            -1.4844158212941525, 5.0, 0.7856499532372323, -0.5892374649279242, -0.18855598877693575, 4.0,
            1.0292568487058473, 0.6209602187058474, -0.9844158212941525, 5.0, 0.5999808009215509, -0.7999744012287345,
            0.007999744012287346, 4.0, 1.0292568487058473, 0.12096021870584739, -0.9844158212941525, 5.0,
            0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.0292568487058473, 0.6209602187058474,
            -1.4844158212941525, 5.0, 0.799457263915735, -0.5329715092771566, 0.2771451848241215, 4.0,
            1.0292568487058473, 0.12096021870584739, -0.4844158212941525, 5.0, 0.5999808009215509, -0.7999744012287345,
            0.007999744012287346, 4.0, 1.0292568487058473, 0.12096021870584739, -0.9844158212941525, 5.0,
            0.7856499532372323, -0.5892374649279242, -0.18855598877693575, 4.0, 1.0292568487058473, 0.6209602187058474,
            -0.9844158212941525, 5.0, 0.7068241080666424, -0.7068241080666424, 0.028272964322665697, 4.0,
            1.0292568487058473, 0.6209602187058474, -0.4844158212941525, 5.0, 0.799457263915735, -0.5329715092771566,
            0.2771451848241215, 4.0, 1.0292568487058473, 0.12096021870584739, -0.4844158212941525, 5.0,
            0.7856499532372323, -0.5892374649279242, -0.18855598877693575, 4.0, 1.0292568487058473, 0.6209602187058474,
            -0.9844158212941525, 5.0, 0.799457263915735, -0.5329715092771566, 0.2771451848241215, 4.0,
            1.0292568487058473, 0.12096021870584739, -0.4844158212941525, 5.0, 0.7068241080666424, -0.7068241080666424,
            0.028272964322665697, 4.0, 1.0292568487058473, 0.6209602187058474, -0.4844158212941525, 5.0,
            0.5735016055486672, -0.5735016055486672, 0.5849716376596406, 4.0, 1.0292568487058473, 0.6209602187058474,
            -0.4844158212941525, 5.0, 0.6695894800069753, -0.6695894800069753, -0.3214029504033481, 4.0,
            1.0292568487058473, 0.6209602187058474, -1.9844158212941525, 5.0, 0.7880859319007489, -0.19702148297518723,
            -0.5831835896065543, 4.0, 1.0292568487058473, 1.1209602187058474, -2.4844158212941525, 5.0,
            0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.0292568487058473, 1.1209602187058474,
            -1.9844158212941525, 5.0, 0.8218838786411851, -0.41094193932059253, -0.3945042617477688, 4.0,
            1.0292568487058473, 0.6209602187058474, -1.9844158212941525, 5.0, 0.6695894800069753, -0.6695894800069753,
            -0.3214029504033481, 4.0, 1.0292568487058473, 0.6209602187058474, -1.9844158212941525, 5.0,
            0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.0292568487058473, 1.1209602187058474,
            -1.9844158212941525, 5.0, 0.8218838786411851, -0.41094193932059253, -0.3945042617477688, 4.0,
            1.0292568487058473, 0.6209602187058474, -1.9844158212941525, 5.0, 0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, 1.0292568487058473, 1.1209602187058474, -1.9844158212941525, 5.0,
            0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.0292568487058473, 0.6209602187058474,
            -1.4844158212941525, 5.0, 0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.0292568487058473,
            0.6209602187058474, -1.4844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0,
            1.0292568487058473, 1.1209602187058474, -1.9844158212941525, 5.0, 0.5799161682232067, -0.5799161682232067,
            -0.5721839526468974, 4.0, 1.0292568487058473, 1.1209602187058474, -1.4844158212941525, 5.0,
            0.48734702750068803, -0.731020541251032, -0.47760008695067424, 4.0, 1.5292568487058473, 0.6209602187058474,
            -0.9844158212941525, 5.0, 0.5799161682232067, -0.5799161682232067, -0.5721839526468974, 4.0,
            1.0292568487058473, 1.1209602187058474, -1.4844158212941525, 5.0, 0.8218838786411851, -0.41094193932059253,
            -0.3945042617477688, 4.0, 1.5292568487058473, 1.1209602187058474, -1.4844158212941525, 5.0,
            0.48734702750068803, -0.731020541251032, -0.47760008695067424, 4.0, 1.5292568487058473, 0.6209602187058474,
            -0.9844158212941525, 5.0, 0.7856499532372323, -0.5892374649279242, -0.18855598877693575, 4.0,
            1.0292568487058473, 0.6209602187058474, -0.9844158212941525, 5.0, 0.5799161682232067, -0.5799161682232067,
            -0.5721839526468974, 4.0, 1.0292568487058473, 1.1209602187058474, -1.4844158212941525, 5.0,
            0.7856499532372323, -0.5892374649279242, -0.18855598877693575, 4.0, 1.0292568487058473, 0.6209602187058474,
            -0.9844158212941525, 5.0, 0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.0292568487058473,
            0.6209602187058474, -1.4844158212941525, 5.0, 0.5799161682232067, -0.5799161682232067, -0.5721839526468974,
            4.0, 1.0292568487058473, 1.1209602187058474, -1.4844158212941525, 5.0, 0.7856499532372323,
            -0.5892374649279242, -0.18855598877693575, 4.0, 1.0292568487058473, 0.6209602187058474, -0.9844158212941525,
            5.0, 0.6867740247905052, -0.6867740247905052, 0.23808166192737512, 4.0, 1.5292568487058473,
            0.6209602187058474, -0.4844158212941525, 5.0, 0.7068241080666424, -0.7068241080666424, 0.028272964322665697,
            4.0, 1.0292568487058473, 0.6209602187058474, -0.4844158212941525, 5.0, 0.48734702750068803,
            -0.731020541251032, -0.47760008695067424, 4.0, 1.5292568487058473, 0.6209602187058474, -0.9844158212941525,
            5.0, 0.6867740247905052, -0.6867740247905052, 0.23808166192737512, 4.0, 1.5292568487058473,
            0.6209602187058474, -0.4844158212941525, 5.0, 0.7856499532372323, -0.5892374649279242, -0.18855598877693575,
            4.0, 1.0292568487058473, 0.6209602187058474, -0.9844158212941525, 5.0, 0.6607608945998119,
            -0.33038044729990595, 0.6739761124918081, 4.0, 1.5292568487058473, 1.1209602187058474, -0.4844158212941525,
            5.0, 0.5696549391872194, -0.5696549391872194, 0.5924411367547082, 4.0, 1.0292568487058473,
            1.1209602187058474, 0.015584178705847496, 5.0, 0.5747843685791867, -0.5747843685791867, 0.5824481601602425,
            4.0, 1.0292568487058473, 0.6209602187058474, 0.015584178705847496, 5.0, 0.6867740247905052,
            -0.6867740247905052, 0.23808166192737512, 4.0, 1.5292568487058473, 0.6209602187058474, -0.4844158212941525,
            5.0, 0.6607608945998119, -0.33038044729990595, 0.6739761124918081, 4.0, 1.5292568487058473,
            1.1209602187058474, -0.4844158212941525, 5.0, 0.5747843685791867, -0.5747843685791867, 0.5824481601602425,
            4.0, 1.0292568487058473, 0.6209602187058474, 0.015584178705847496, 5.0, 0.6867740247905052,
            -0.6867740247905052, 0.23808166192737512, 4.0, 1.5292568487058473, 0.6209602187058474, -0.4844158212941525,
            5.0, 0.5747843685791867, -0.5747843685791867, 0.5824481601602425, 4.0, 1.0292568487058473,
            0.6209602187058474, 0.015584178705847496, 5.0, 0.5735016055486672, -0.5735016055486672, 0.5849716376596406,
            4.0, 1.0292568487058473, 0.6209602187058474, -0.4844158212941525, 5.0, 0.6867740247905052,
            -0.6867740247905052, 0.23808166192737512, 4.0, 1.5292568487058473, 0.6209602187058474, -0.4844158212941525,
            5.0, 0.5735016055486672, -0.5735016055486672, 0.5849716376596406, 4.0, 1.0292568487058473,
            0.6209602187058474, -0.4844158212941525, 5.0, 0.7068241080666424, -0.7068241080666424, 0.028272964322665697,
            4.0, 1.0292568487058473, 0.6209602187058474, -0.4844158212941525, 5.0, 0.5747843685791867,
            -0.5747843685791867, 0.5824481601602425, 4.0, 1.0292568487058473, 0.6209602187058474, 0.015584178705847496,
            5.0, 0.5696549391872194, -0.5696549391872194, 0.5924411367547082, 4.0, 1.0292568487058473,
            1.1209602187058474, 0.015584178705847496, 5.0, 0.5735016055486672, -0.5735016055486672, 0.5849716376596406,
            4.0, 1.0292568487058473, 1.1209602187058474, 0.015584178705847496, 5.0, 0.7458533939516854,
            -0.3729266969758427, -0.5519315115242471, 4.0, 1.0292568487058473, 1.6209602187058474, -1.9844158212941525,
            5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.0292568487058473, 1.1209602187058474,
            -1.9844158212941525, 5.0, 0.7880859319007489, -0.19702148297518723, -0.5831835896065543, 4.0,
            1.0292568487058473, 1.1209602187058474, -2.4844158212941525, 5.0, 0.6038576879954624, 0.0,
            -0.7970921481540103, 4.0, 1.0292568487058473, 1.6209602187058474, -2.4844158212941525, 5.0,
            0.7458533939516854, -0.3729266969758427, -0.5519315115242471, 4.0, 1.0292568487058473, 1.6209602187058474,
            -1.9844158212941525, 5.0, 0.7880859319007489, -0.19702148297518723, -0.5831835896065543, 4.0,
            1.0292568487058473, 1.1209602187058474, -2.4844158212941525, 5.0, 0.33630596344635905, -0.6726119268927181,
            -0.6591596883548637, 4.0, 1.5292568487058473, 1.1209602187058474, -1.4844158212941525, 5.0,
            0.7458533939516854, -0.3729266969758427, -0.5519315115242471, 4.0, 1.0292568487058473, 1.6209602187058474,
            -1.9844158212941525, 5.0, 0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0,
            1.5292568487058473, 1.6209602187058474, -1.9844158212941525, 5.0, 0.33630596344635905, -0.6726119268927181,
            -0.6591596883548637, 4.0, 1.5292568487058473, 1.1209602187058474, -1.4844158212941525, 5.0,
            0.5799161682232067, -0.5799161682232067, -0.5721839526468974, 4.0, 1.0292568487058473, 1.1209602187058474,
            -1.4844158212941525, 5.0, 0.7458533939516854, -0.3729266969758427, -0.5519315115242471, 4.0,
            1.0292568487058473, 1.6209602187058474, -1.9844158212941525, 5.0, 0.5799161682232067, -0.5799161682232067,
            -0.5721839526468974, 4.0, 1.0292568487058473, 1.1209602187058474, -1.4844158212941525, 5.0,
            0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.0292568487058473, 1.1209602187058474,
            -1.9844158212941525, 5.0, 0.7458533939516854, -0.3729266969758427, -0.5519315115242471, 4.0,
            1.0292568487058473, 1.6209602187058474, -1.9844158212941525, 5.0, 0.5799161682232067, -0.5799161682232067,
            -0.5721839526468974, 4.0, 1.0292568487058473, 1.1209602187058474, -1.4844158212941525, 5.0,
            0.33630596344635905, -0.6726119268927181, -0.6591596883548637, 4.0, 1.5292568487058473, 1.1209602187058474,
            -1.4844158212941525, 5.0, 0.8218838786411851, -0.41094193932059253, -0.3945042617477688, 4.0,
            1.5292568487058473, 1.1209602187058474, -1.4844158212941525, 5.0, 0.6607608945998119, -0.33038044729990595,
            0.6739761124918081, 4.0, 1.5292568487058473, 1.1209602187058474, -0.4844158212941525, 5.0,
            0.6636648415023736, -0.6636648415023736, 0.34510571758123426, 4.0, 1.5292568487058473, 1.1209602187058474,
            0.015584178705847496, 5.0, 0.5696549391872194, -0.5696549391872194, 0.5924411367547082, 4.0,
            1.0292568487058473, 1.1209602187058474, 0.015584178705847496, 5.0, 0.7000714109260575, 0.0,
            0.7140728391445786, 4.0, 1.5292568487058473, 1.6209602187058474, 0.015584178705847496, 5.0,
            0.7971959671311492, 0.2657319890437164, 0.5420932576491815, 4.0, 1.0292568487058473, 1.6209602187058474,
            0.5155841787058475, 5.0, 0.4816607005330728, -0.4816607005330728, 0.7321242648102707, 4.0,
            1.0292568487058473, 1.1209602187058474, 0.5155841787058475, 5.0, 0.6636648415023736, -0.6636648415023736,
            0.34510571758123426, 4.0, 1.5292568487058473, 1.1209602187058474, 0.015584178705847496, 5.0,
            0.7000714109260575, 0.0, 0.7140728391445786, 4.0, 1.5292568487058473, 1.6209602187058474,
            0.015584178705847496, 5.0, 0.4816607005330728, -0.4816607005330728, 0.7321242648102707, 4.0,
            1.0292568487058473, 1.1209602187058474, 0.5155841787058475, 5.0, 0.6636648415023736, -0.6636648415023736,
            0.34510571758123426, 4.0, 1.5292568487058473, 1.1209602187058474, 0.015584178705847496, 5.0,
            0.4816607005330728, -0.4816607005330728, 0.7321242648102707, 4.0, 1.0292568487058473, 1.1209602187058474,
            0.5155841787058475, 5.0, 0.5735016055486672, -0.5735016055486672, 0.5849716376596406, 4.0,
            1.0292568487058473, 1.1209602187058474, 0.015584178705847496, 5.0, 0.6636648415023736, -0.6636648415023736,
            0.34510571758123426, 4.0, 1.5292568487058473, 1.1209602187058474, 0.015584178705847496, 5.0,
            0.5735016055486672, -0.5735016055486672, 0.5849716376596406, 4.0, 1.0292568487058473, 1.1209602187058474,
            0.015584178705847496, 5.0, 0.5696549391872194, -0.5696549391872194, 0.5924411367547082, 4.0,
            1.0292568487058473, 1.1209602187058474, 0.015584178705847496, 5.0, 0.4816607005330728, -0.4816607005330728,
            0.7321242648102707, 4.0, 1.0292568487058473, 1.1209602187058474, 0.5155841787058475, 5.0,
            0.7971959671311492, 0.2657319890437164, 0.5420932576491815, 4.0, 1.0292568487058473, 1.6209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 1.0292568487058473, 1.6209602187058474, 0.5155841787058475,
            5.0, 0.7880859319007489, 0.19702148297518723, -0.5831835896065543, 4.0, 1.0292568487058473,
            2.1209602187058474, -1.9844158212941525, 5.0, 0.7458533939516854, -0.3729266969758427, -0.5519315115242471,
            4.0, 1.0292568487058473, 1.6209602187058474, -1.9844158212941525, 5.0, 0.6038576879954624, 0.0,
            -0.7970921481540103, 4.0, 1.0292568487058473, 1.6209602187058474, -2.4844158212941525, 5.0,
            0.711836432832338, 0.0, -0.7023452803945736, 4.0, 1.0292568487058473, 2.1209602187058474,
            -2.4844158212941525, 5.0, 0.7880859319007489, 0.19702148297518723, -0.5831835896065543, 4.0,
            1.0292568487058473, 2.1209602187058474, -1.9844158212941525, 5.0, 0.6038576879954624, 0.0,
            -0.7970921481540103, 4.0, 1.0292568487058473, 1.6209602187058474, -2.4844158212941525, 5.0,
            0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0, 1.5292568487058473, 1.6209602187058474,
            -1.9844158212941525, 5.0, 0.7880859319007489, 0.19702148297518723, -0.5831835896065543, 4.0,
            1.0292568487058473, 2.1209602187058474, -1.9844158212941525, 5.0, 0.5811989248480778, 0.5811989248480778,
            -0.5695749463511162, 4.0, 1.5292568487058473, 2.1209602187058474, -1.9844158212941525, 5.0,
            0.7458533939516854, -0.3729266969758427, -0.5519315115242471, 4.0, 1.0292568487058473, 1.6209602187058474,
            -1.9844158212941525, 5.0, 0.7880859319007489, 0.19702148297518723, -0.5831835896065543, 4.0,
            1.0292568487058473, 2.1209602187058474, -1.9844158212941525, 5.0, 0.692606109997351, -0.23086870333245033,
            -0.6833713618640529, 4.0, 1.5292568487058473, 1.6209602187058474, -1.9844158212941525, 5.0,
            0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, 1.5292568487058473, 2.1209602187058474,
            -0.4844158212941525, 5.0, 0.8146761541064845, 0.40733807705324226, 0.41276925141395215, 4.0,
            1.0292568487058473, 2.1209602187058474, 0.015584178705847496, 5.0, 0.5735016055486672, 0.5735016055486672,
            0.5849716376596406, 4.0, 1.5292568487058473, 1.6209602187058474, 0.015584178705847496, 5.0,
            0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, 1.5292568487058473, 1.6209602187058474,
            0.015584178705847496, 5.0, 0.7971959671311492, 0.2657319890437164, 0.5420932576491815, 4.0,
            1.0292568487058473, 1.6209602187058474, 0.5155841787058475, 5.0, 0.7000714109260575, 0.0,
            0.7140728391445786, 4.0, 1.5292568487058473, 1.6209602187058474, 0.015584178705847496, 5.0,
            0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, 1.5292568487058473, 1.6209602187058474,
            0.015584178705847496, 5.0, 0.8146761541064845, 0.40733807705324226, 0.41276925141395215, 4.0,
            1.0292568487058473, 2.1209602187058474, 0.015584178705847496, 5.0, 0.7971959671311492, 0.2657319890437164,
            0.5420932576491815, 4.0, 1.0292568487058473, 1.6209602187058474, 0.5155841787058475, 5.0,
            0.8146761541064845, 0.40733807705324226, 0.41276925141395215, 4.0, 1.0292568487058473, 2.1209602187058474,
            0.015584178705847496, 5.0, 0.9998000599800071, 0.0, 0.01999600119960014, 4.0, 1.0292568487058473,
            2.1209602187058474, 0.5155841787058475, 5.0, 0.7971959671311492, 0.2657319890437164, 0.5420932576491815,
            4.0, 1.0292568487058473, 1.6209602187058474, 0.5155841787058475, 5.0, 0.7971959671311492,
            0.2657319890437164, 0.5420932576491815, 4.0, 1.0292568487058473, 1.6209602187058474, 0.5155841787058475,
            5.0, 0.9998000599800071, 0.0, 0.01999600119960014, 4.0, 1.0292568487058473, 2.1209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 1.0292568487058473, 2.1209602187058474, 0.5155841787058475,
            5.0, 0.0, 0.0, 1.0, 4.0, 1.0292568487058473, 1.6209602187058474, 0.5155841787058475, 5.0,
            0.7971959671311492, 0.2657319890437164, 0.5420932576491815, 4.0, 1.0292568487058473, 1.6209602187058474,
            0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 1.0292568487058473, 2.1209602187058474, 0.5155841787058475,
            5.0, 0.9999500037496877, 0.0, 0.009999500037496877, 4.0, 1.0292568487058473, 2.6209602187058474,
            -1.9844158212941525, 5.0, 0.7880859319007489, 0.19702148297518723, -0.5831835896065543, 4.0,
            1.0292568487058473, 2.1209602187058474, -1.9844158212941525, 5.0, 0.711836432832338, 0.0,
            -0.7023452803945736, 4.0, 1.0292568487058473, 2.1209602187058474, -2.4844158212941525, 5.0,
            0.731020541251032, 0.48734702750068803, -0.47760008695067424, 4.0, 1.0292568487058473, 2.6209602187058474,
            -2.4844158212941525, 5.0, 0.9999500037496877, 0.0, 0.009999500037496877, 4.0, 1.0292568487058473,
            2.6209602187058474, -1.9844158212941525, 5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0,
            1.0292568487058473, 2.1209602187058474, -2.4844158212941525, 5.0, 0.5811989248480778, 0.5811989248480778,
            -0.5695749463511162, 4.0, 1.5292568487058473, 2.1209602187058474, -1.9844158212941525, 5.0,
            0.6884120779323771, 0.5163090584492829, -0.5094249376699591, 4.0, 1.0292568487058473, 2.6209602187058474,
            -1.4844158212941525, 5.0, 0.8218838786411851, 0.41094193932059253, -0.3945042617477688, 4.0,
            1.5292568487058473, 2.1209602187058474, -1.4844158212941525, 5.0, 0.5811989248480778, 0.5811989248480778,
            -0.5695749463511162, 4.0, 1.5292568487058473, 2.1209602187058474, -1.9844158212941525, 5.0,
            0.7880859319007489, 0.19702148297518723, -0.5831835896065543, 4.0, 1.0292568487058473, 2.1209602187058474,
            -1.9844158212941525, 5.0, 0.6884120779323771, 0.5163090584492829, -0.5094249376699591, 4.0,
            1.0292568487058473, 2.6209602187058474, -1.4844158212941525, 5.0, 0.7880859319007489, 0.19702148297518723,
            -0.5831835896065543, 4.0, 1.0292568487058473, 2.1209602187058474, -1.9844158212941525, 5.0,
            0.9999500037496877, 0.0, 0.009999500037496877, 4.0, 1.0292568487058473, 2.6209602187058474,
            -1.9844158212941525, 5.0, 0.6884120779323771, 0.5163090584492829, -0.5094249376699591, 4.0,
            1.0292568487058473, 2.6209602187058474, -1.4844158212941525, 5.0, 0.8218838786411851, 0.41094193932059253,
            -0.3945042617477688, 4.0, 1.5292568487058473, 2.1209602187058474, -1.4844158212941525, 5.0,
            0.6884120779323771, 0.5163090584492829, -0.5094249376699591, 4.0, 1.0292568487058473, 2.6209602187058474,
            -1.4844158212941525, 5.0, 0.5811989248480778, 0.5811989248480778, -0.5695749463511162, 4.0,
            1.5292568487058473, 2.6209602187058474, -1.4844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, 1.5292568487058473, 2.6209602187058474, -0.9844158212941525, 5.0,
            0.8146761541064845, 0.40733807705324226, 0.41276925141395215, 4.0, 1.0292568487058473, 2.6209602187058474,
            -0.4844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            1.5292568487058473, 2.1209602187058474, -0.4844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672,
            0.5849716376596406, 4.0, 1.5292568487058473, 2.1209602187058474, -0.4844158212941525, 5.0,
            0.8146761541064845, 0.40733807705324226, 0.41276925141395215, 4.0, 1.0292568487058473, 2.1209602187058474,
            0.015584178705847496, 5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0,
            1.5292568487058473, 2.1209602187058474, -0.4844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672,
            0.5849716376596406, 4.0, 1.5292568487058473, 2.1209602187058474, -0.4844158212941525, 5.0,
            0.8146761541064845, 0.40733807705324226, 0.41276925141395215, 4.0, 1.0292568487058473, 2.6209602187058474,
            -0.4844158212941525, 5.0, 0.8146761541064845, 0.40733807705324226, 0.41276925141395215, 4.0,
            1.0292568487058473, 2.1209602187058474, 0.015584178705847496, 5.0, 0.8146761541064845, 0.40733807705324226,
            0.41276925141395215, 4.0, 1.0292568487058473, 2.6209602187058474, -0.4844158212941525, 5.0,
            0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.0292568487058473, 2.6209602187058474,
            0.015584178705847496, 5.0, 0.8146761541064845, 0.40733807705324226, 0.41276925141395215, 4.0,
            1.0292568487058473, 2.1209602187058474, 0.015584178705847496, 5.0, 0.5735016055486672, 0.5735016055486672,
            0.5849716376596406, 4.0, 1.0292568487058473, 2.6209602187058474, 0.015584178705847496, 5.0,
            0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, 1.0292568487058473, 2.1209602187058474,
            0.5155841787058475, 5.0, 0.9998000599800071, 0.0, 0.01999600119960014, 4.0, 1.0292568487058473,
            2.1209602187058474, 0.5155841787058475, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406,
            4.0, 1.0292568487058473, 2.6209602187058474, 0.015584178705847496, 5.0, 0.9998000599800071, 0.0,
            0.01999600119960014, 4.0, 1.0292568487058473, 2.1209602187058474, 0.5155841787058475, 5.0,
            0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.0292568487058473, 2.6209602187058474,
            0.015584178705847496, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.0292568487058473,
            2.6209602187058474, 0.015584178705847496, 5.0, 0.9998000599800071, 0.0, 0.01999600119960014, 4.0,
            1.0292568487058473, 2.1209602187058474, 0.5155841787058475, 5.0, 0.8146761541064845, 0.40733807705324226,
            0.41276925141395215, 4.0, 1.0292568487058473, 2.1209602187058474, 0.015584178705847496, 5.0,
            0.9998000599800071, 0.0, 0.01999600119960014, 4.0, 1.0292568487058473, 2.1209602187058474,
            0.5155841787058475, 5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0,
            1.0292568487058473, 2.1209602187058474, 0.5155841787058475, 5.0, 0.0, 0.0, 1.0, 4.0, 1.0292568487058473,
            2.1209602187058474, 0.5155841787058475, 5.0, 0.9999500037496877, 0.0, 0.009999500037496877, 4.0,
            1.0292568487058473, 2.6209602187058474, -1.9844158212941525, 5.0, 0.731020541251032, 0.48734702750068803,
            -0.47760008695067424, 4.0, 1.0292568487058473, 2.6209602187058474, -2.4844158212941525, 5.0,
            0.8218838786411851, 0.41094193932059253, -0.3945042617477688, 4.0, 1.0292568487058473, 2.6209602187058474,
            -1.9844158212941525, 5.0, 0.8218838786411851, 0.41094193932059253, -0.3945042617477688, 4.0,
            1.0292568487058473, 2.6209602187058474, -1.9844158212941525, 5.0, 0.711836432832338, 0.0,
            -0.7023452803945736, 4.0, 1.0292568487058473, 3.1209602187058474, -1.9844158212941525, 5.0,
            0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.0292568487058473, 3.1209602187058474,
            -1.4844158212941525, 5.0, 0.8218838786411851, 0.41094193932059253, -0.3945042617477688, 4.0,
            1.0292568487058473, 2.6209602187058474, -1.9844158212941525, 5.0, 0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, 1.0292568487058473, 3.1209602187058474, -1.4844158212941525, 5.0,
            0.9999500037496877, 0.0, 0.009999500037496877, 4.0, 1.0292568487058473, 2.6209602187058474,
            -1.9844158212941525, 5.0, 0.9999500037496877, 0.0, 0.009999500037496877, 4.0, 1.0292568487058473,
            2.6209602187058474, -1.9844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0,
            1.0292568487058473, 3.1209602187058474, -1.4844158212941525, 5.0, 0.6884120779323771, 0.5163090584492829,
            -0.5094249376699591, 4.0, 1.0292568487058473, 2.6209602187058474, -1.4844158212941525, 5.0,
            0.5811989248480778, 0.5811989248480778, -0.5695749463511162, 4.0, 1.5292568487058473, 2.6209602187058474,
            -1.4844158212941525, 5.0, 0.9191323524178695, 0.39391386532194406, 0.005252184870959259, 4.0,
            1.0292568487058473, 3.1209602187058474, -0.9844158212941525, 5.0, 0.6636648415023736, 0.6636648415023736,
            0.34510571758123426, 4.0, 1.5292568487058473, 2.6209602187058474, -0.9844158212941525, 5.0,
            0.5811989248480778, 0.5811989248480778, -0.5695749463511162, 4.0, 1.5292568487058473, 2.6209602187058474,
            -1.4844158212941525, 5.0, 0.6884120779323771, 0.5163090584492829, -0.5094249376699591, 4.0,
            1.0292568487058473, 2.6209602187058474, -1.4844158212941525, 5.0, 0.9191323524178695, 0.39391386532194406,
            0.005252184870959259, 4.0, 1.0292568487058473, 3.1209602187058474, -0.9844158212941525, 5.0,
            0.6884120779323771, 0.5163090584492829, -0.5094249376699591, 4.0, 1.0292568487058473, 2.6209602187058474,
            -1.4844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.0292568487058473,
            3.1209602187058474, -1.4844158212941525, 5.0, 0.9191323524178695, 0.39391386532194406, 0.005252184870959259,
            4.0, 1.0292568487058473, 3.1209602187058474, -0.9844158212941525, 5.0, 0.6636648415023736,
            0.6636648415023736, 0.34510571758123426, 4.0, 1.5292568487058473, 2.6209602187058474, -0.9844158212941525,
            5.0, 0.8146761541064845, 0.40733807705324226, 0.41276925141395215, 4.0, 1.0292568487058473,
            2.6209602187058474, -0.4844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082,
            4.0, 1.5292568487058473, 2.6209602187058474, -0.9844158212941525, 5.0, 0.6636648415023736,
            0.6636648415023736, 0.34510571758123426, 4.0, 1.5292568487058473, 2.6209602187058474, -0.9844158212941525,
            5.0, 0.9191323524178695, 0.39391386532194406, 0.005252184870959259, 4.0, 1.0292568487058473,
            3.1209602187058474, -0.9844158212941525, 5.0, 0.8146761541064845, 0.40733807705324226, 0.41276925141395215,
            4.0, 1.0292568487058473, 2.6209602187058474, -0.4844158212941525, 5.0, 0.9191323524178695,
            0.39391386532194406, 0.005252184870959259, 4.0, 1.0292568487058473, 3.1209602187058474, -0.9844158212941525,
            5.0, 0.9999500037496877, 0.0, 0.009999500037496877, 4.0, 1.0292568487058473, 3.1209602187058474,
            -0.4844158212941525, 5.0, 0.8146761541064845, 0.40733807705324226, 0.41276925141395215, 4.0,
            1.0292568487058473, 2.6209602187058474, -0.4844158212941525, 5.0, 0.6607608945998119, 0.33038044729990595,
            0.6739761124918081, 4.0, 1.0292568487058473, 3.1209602187058474, -0.4844158212941525, 5.0,
            0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, 1.0292568487058473, 2.6209602187058474,
            0.015584178705847496, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.0292568487058473,
            2.6209602187058474, 0.015584178705847496, 5.0, 0.6607608945998119, 0.33038044729990595, 0.6739761124918081,
            4.0, 1.0292568487058473, 3.1209602187058474, -0.4844158212941525, 5.0, 0.9999111229612074, 0.0,
            0.013332148306149432, 4.0, 1.0292568487058473, 2.6209602187058474, 0.015584178705847496, 5.0,
            0.9999500037496877, 0.0, 0.009999500037496877, 4.0, 1.0292568487058473, 3.1209602187058474,
            -0.4844158212941525, 5.0, 0.9999500037496877, 0.0, 0.009999500037496877, 4.0, 1.0292568487058473,
            3.1209602187058474, -0.4844158212941525, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0,
            1.0292568487058473, 2.6209602187058474, 0.015584178705847496, 5.0, 0.8146761541064845, 0.40733807705324226,
            0.41276925141395215, 4.0, 1.0292568487058473, 2.6209602187058474, -0.4844158212941525, 5.0,
            0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.0292568487058473, 2.6209602187058474,
            0.015584178705847496, 5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0,
            1.0292568487058473, 2.6209602187058474, 0.015584178705847496, 5.0, 0.5735016055486672, 0.5735016055486672,
            0.5849716376596406, 4.0, 1.0292568487058473, 2.6209602187058474, 0.015584178705847496, 5.0,
            0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.0292568487058473, 3.6209602187058474,
            -1.4844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.0292568487058473,
            3.1209602187058474, -1.4844158212941525, 5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0,
            1.0292568487058473, 3.1209602187058474, -1.9844158212941525, 5.0, 0.711836432832338, 0.0,
            -0.7023452803945736, 4.0, 1.0292568487058473, 3.6209602187058474, -1.9844158212941525, 5.0,
            0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.0292568487058473, 3.6209602187058474,
            -1.4844158212941525, 5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0, 1.0292568487058473,
            3.1209602187058474, -1.9844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0,
            1.0292568487058473, 3.1209602187058474, -1.4844158212941525, 5.0, 0.999977778518491, 0.0,
            0.006666518523456607, 4.0, 1.0292568487058473, 3.6209602187058474, -1.4844158212941525, 5.0,
            0.9191323524178695, 0.39391386532194406, 0.005252184870959259, 4.0, 1.0292568487058473, 3.1209602187058474,
            -0.9844158212941525, 5.0, 0.9191323524178695, 0.39391386532194406, 0.005252184870959259, 4.0,
            1.0292568487058473, 3.1209602187058474, -0.9844158212941525, 5.0, 0.999977778518491, 0.0,
            0.006666518523456607, 4.0, 1.0292568487058473, 3.6209602187058474, -1.4844158212941525, 5.0,
            0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.0292568487058473, 3.6209602187058474,
            -0.9844158212941525, 5.0, 0.9191323524178695, 0.39391386532194406, 0.005252184870959259, 4.0,
            1.0292568487058473, 3.1209602187058474, -0.9844158212941525, 5.0, 0.999977778518491, 0.0,
            0.006666518523456607, 4.0, 1.0292568487058473, 3.6209602187058474, -0.9844158212941525, 5.0,
            0.9999500037496877, 0.0, 0.009999500037496877, 4.0, 1.0292568487058473, 3.1209602187058474,
            -0.4844158212941525, 5.0, 0.9999500037496877, 0.0, 0.009999500037496877, 4.0, 1.0292568487058473,
            3.1209602187058474, -0.4844158212941525, 5.0, 0.999977778518491, 0.0, 0.006666518523456607, 4.0,
            1.0292568487058473, 3.6209602187058474, -0.9844158212941525, 5.0, 0.9998000599800071, 0.0,
            0.01999600119960014, 4.0, 1.0292568487058473, 3.6209602187058474, -0.4844158212941525, 5.0,
            0.9999500037496877, 0.0, 0.009999500037496877, 4.0, 1.0292568487058473, 3.1209602187058474,
            -0.4844158212941525, 5.0, 0.9998000599800071, 0.0, 0.01999600119960014, 4.0, 1.0292568487058473,
            3.6209602187058474, -0.4844158212941525, 5.0, 0.6839126923543284, 0.22797089745144278, 0.6930315282523861,
            4.0, 1.0292568487058473, 3.6209602187058474, -0.4844158212941525, 5.0, 0.6607608945998119,
            0.33038044729990595, 0.6739761124918081, 4.0, 1.0292568487058473, 3.1209602187058474, -0.4844158212941525,
            5.0, 0.9999500037496877, 0.0, 0.009999500037496877, 4.0, 1.0292568487058473, 3.1209602187058474,
            -0.4844158212941525, 5.0, 0.6839126923543284, 0.22797089745144278, 0.6930315282523861, 4.0,
            1.0292568487058473, 3.6209602187058474, -0.4844158212941525, 5.0, 0.9999500037496877, 0.0,
            0.009999500037496877, 4.0, 1.0292568487058473, 4.120960218705847, -1.4844158212941525, 5.0,
            0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.0292568487058473, 3.6209602187058474,
            -1.4844158212941525, 5.0, 0.711836432832338, 0.0, -0.7023452803945736, 4.0, 1.0292568487058473,
            3.6209602187058474, -1.9844158212941525, 5.0, 0.5850454715011363, 0.5850454715011363, -0.5616436526410908,
            4.0, 1.0292568487058473, 4.120960218705847, -1.9844158212941525, 5.0, 0.9999500037496877, 0.0,
            0.009999500037496877, 4.0, 1.0292568487058473, 4.120960218705847, -1.4844158212941525, 5.0,
            0.711836432832338, 0.0, -0.7023452803945736, 4.0, 1.0292568487058473, 3.6209602187058474,
            -1.9844158212941525, 5.0, 0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.0292568487058473,
            3.6209602187058474, -1.4844158212941525, 5.0, 0.9999500037496877, 0.0, 0.009999500037496877, 4.0,
            1.0292568487058473, 4.120960218705847, -1.4844158212941525, 5.0, 0.999977778518491, 0.0,
            0.006666518523456607, 4.0, 1.0292568487058473, 3.6209602187058474, -0.9844158212941525, 5.0,
            0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.0292568487058473, 3.6209602187058474,
            -0.9844158212941525, 5.0, 0.9999500037496877, 0.0, 0.009999500037496877, 4.0, 1.0292568487058473,
            4.120960218705847, -1.4844158212941525, 5.0, 0.9998000599800071, 0.0, 0.01999600119960014, 4.0,
            1.0292568487058473, 4.120960218705847, -0.9844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672,
            0.5849716376596406, 4.0, 1.0292568487058473, 4.120960218705847, -0.9844158212941525, 5.0,
            0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0, 1.0292568487058473, 3.6209602187058474,
            -0.4844158212941525, 5.0, 0.9998000599800071, 0.0, 0.01999600119960014, 4.0, 1.0292568487058473,
            3.6209602187058474, -0.4844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406,
            4.0, 1.0292568487058473, 4.120960218705847, -0.9844158212941525, 5.0, 0.9998000599800071, 0.0,
            0.01999600119960014, 4.0, 1.0292568487058473, 3.6209602187058474, -0.4844158212941525, 5.0,
            0.9998000599800071, 0.0, 0.01999600119960014, 4.0, 1.0292568487058473, 4.120960218705847,
            -0.9844158212941525, 5.0, 0.9998000599800071, 0.0, 0.01999600119960014, 4.0, 1.0292568487058473,
            4.120960218705847, -0.9844158212941525, 5.0, 0.9998000599800071, 0.0, 0.01999600119960014, 4.0,
            1.0292568487058473, 3.6209602187058474, -0.4844158212941525, 5.0, 0.999977778518491, 0.0,
            0.006666518523456607, 4.0, 1.0292568487058473, 3.6209602187058474, -0.9844158212941525, 5.0,
            0.9998000599800071, 0.0, 0.01999600119960014, 4.0, 1.0292568487058473, 3.6209602187058474,
            -0.4844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0,
            1.0292568487058473, 3.6209602187058474, -0.4844158212941525, 5.0, 0.6839126923543284, 0.22797089745144278,
            0.6930315282523861, 4.0, 1.0292568487058473, 3.6209602187058474, -0.4844158212941525, 5.0,
            0.9999500037496877, 0.0, 0.009999500037496877, 4.0, 1.0292568487058473, 4.120960218705847,
            -1.4844158212941525, 5.0, 0.5850454715011363, 0.5850454715011363, -0.5616436526410908, 4.0,
            1.0292568487058473, 4.120960218705847, -1.9844158212941525, 5.0, 0.5892374649279242, 0.7856499532372323,
            -0.18855598877693575, 4.0, 1.0292568487058473, 4.120960218705847, -1.4844158212941525, 5.0,
            0.9998000599800071, 0.0, 0.01999600119960014, 4.0, 1.0292568487058473, 4.120960218705847,
            -0.9844158212941525, 5.0, 0.9999500037496877, 0.0, 0.009999500037496877, 4.0, 1.0292568487058473,
            4.120960218705847, -1.4844158212941525, 5.0, 0.5892374649279242, 0.7856499532372323, -0.18855598877693575,
            4.0, 1.0292568487058473, 4.120960218705847, -1.4844158212941525, 5.0, 0.7068241080666424,
            0.7068241080666424, 0.028272964322665697, 4.0, 1.0292568487058473, 4.120960218705847, -0.9844158212941525,
            5.0, 0.9998000599800071, 0.0, 0.01999600119960014, 4.0, 1.0292568487058473, 4.120960218705847,
            -0.9844158212941525, 5.0, 0.5892374649279242, 0.7856499532372323, -0.18855598877693575, 4.0,
            1.0292568487058473, 4.120960218705847, -1.4844158212941525, 5.0, 0.9998000599800071, 0.0,
            0.01999600119960014, 4.0, 1.0292568487058473, 4.120960218705847, -0.9844158212941525, 5.0,
            0.7068241080666424, 0.7068241080666424, 0.028272964322665697, 4.0, 1.0292568487058473, 4.120960218705847,
            -0.9844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            1.0292568487058473, 4.120960218705847, -0.9844158212941525, 5.0, 0.48734702750068803, -0.731020541251032,
            -0.47760008695067424, 4.0, 1.5292568487058473, 0.6209602187058474, -0.9844158212941525, 5.0,
            0.8218838786411851, -0.41094193932059253, -0.3945042617477688, 4.0, 1.5292568487058473, 1.1209602187058474,
            -1.4844158212941525, 5.0, 0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.5292568487058473,
            1.1209602187058474, -0.9844158212941525, 5.0, 0.6867740247905052, -0.6867740247905052, 0.23808166192737512,
            4.0, 1.5292568487058473, 0.6209602187058474, -0.4844158212941525, 5.0, 0.48734702750068803,
            -0.731020541251032, -0.47760008695067424, 4.0, 1.5292568487058473, 0.6209602187058474, -0.9844158212941525,
            5.0, 0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.5292568487058473, 1.1209602187058474,
            -0.9844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.5292568487058473,
            1.1209602187058474, -0.4844158212941525, 5.0, 0.6867740247905052, -0.6867740247905052, 0.23808166192737512,
            4.0, 1.5292568487058473, 0.6209602187058474, -0.4844158212941525, 5.0, 0.999977778518491, 0.0,
            0.006666518523456607, 4.0, 1.5292568487058473, 1.1209602187058474, -0.9844158212941525, 5.0,
            0.6867740247905052, -0.6867740247905052, 0.23808166192737512, 4.0, 1.5292568487058473, 0.6209602187058474,
            -0.4844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.5292568487058473,
            1.1209602187058474, -0.4844158212941525, 5.0, 0.6607608945998119, -0.33038044729990595, 0.6739761124918081,
            4.0, 1.5292568487058473, 1.1209602187058474, -0.4844158212941525, 5.0, 0.33630596344635905,
            -0.6726119268927181, -0.6591596883548637, 4.0, 1.5292568487058473, 1.1209602187058474, -1.4844158212941525,
            5.0, 0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0, 1.5292568487058473,
            1.6209602187058474, -1.9844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0,
            1.5292568487058473, 1.6209602187058474, -1.4844158212941525, 5.0, 0.8218838786411851, -0.41094193932059253,
            -0.3945042617477688, 4.0, 1.5292568487058473, 1.1209602187058474, -1.4844158212941525, 5.0,
            0.33630596344635905, -0.6726119268927181, -0.6591596883548637, 4.0, 1.5292568487058473, 1.1209602187058474,
            -1.4844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.5292568487058473,
            1.6209602187058474, -1.4844158212941525, 5.0, 0.8218838786411851, -0.41094193932059253, -0.3945042617477688,
            4.0, 1.5292568487058473, 1.1209602187058474, -1.4844158212941525, 5.0, 0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, 1.5292568487058473, 1.6209602187058474, -1.4844158212941525, 5.0,
            0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.5292568487058473, 1.1209602187058474,
            -0.9844158212941525, 5.0, 0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.5292568487058473,
            1.1209602187058474, -0.9844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0,
            1.5292568487058473, 1.6209602187058474, -1.4844158212941525, 5.0, 0.999977778518491, 0.0,
            0.006666518523456607, 4.0, 1.5292568487058473, 1.6209602187058474, -0.9844158212941525, 5.0,
            0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.5292568487058473, 1.1209602187058474,
            -0.9844158212941525, 5.0, 0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.5292568487058473,
            1.6209602187058474, -0.9844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0,
            1.5292568487058473, 1.1209602187058474, -0.4844158212941525, 5.0, 0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, 1.5292568487058473, 1.1209602187058474, -0.4844158212941525, 5.0,
            0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.5292568487058473, 1.6209602187058474,
            -0.9844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.5292568487058473,
            1.6209602187058474, -0.4844158212941525, 5.0, 0.6636648415023736, -0.6636648415023736, 0.34510571758123426,
            4.0, 1.5292568487058473, 1.1209602187058474, 0.015584178705847496, 5.0, 0.6607608945998119,
            -0.33038044729990595, 0.6739761124918081, 4.0, 1.5292568487058473, 1.1209602187058474, -0.4844158212941525,
            5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.5292568487058473, 1.1209602187058474,
            -0.4844158212941525, 5.0, 0.6636648415023736, -0.6636648415023736, 0.34510571758123426, 4.0,
            1.5292568487058473, 1.1209602187058474, 0.015584178705847496, 5.0, 0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, 1.5292568487058473, 1.1209602187058474, -0.4844158212941525, 5.0,
            0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.5292568487058473, 1.6209602187058474,
            0.015584178705847496, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.5292568487058473,
            1.6209602187058474, 0.015584178705847496, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0,
            1.5292568487058473, 1.1209602187058474, -0.4844158212941525, 5.0, 0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, 1.5292568487058473, 1.6209602187058474, -0.4844158212941525, 5.0,
            0.6636648415023736, -0.6636648415023736, 0.34510571758123426, 4.0, 1.5292568487058473, 1.1209602187058474,
            0.015584178705847496, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.5292568487058473,
            1.6209602187058474, 0.015584178705847496, 5.0, 0.7000714109260575, 0.0, 0.7140728391445786, 4.0,
            1.5292568487058473, 1.6209602187058474, 0.015584178705847496, 5.0, 0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, 1.5292568487058473, 2.1209602187058474, -1.4844158212941525, 5.0,
            0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.5292568487058473, 1.6209602187058474,
            -1.4844158212941525, 5.0, 0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0,
            1.5292568487058473, 1.6209602187058474, -1.9844158212941525, 5.0, 0.5811989248480778, 0.5811989248480778,
            -0.5695749463511162, 4.0, 1.5292568487058473, 2.1209602187058474, -1.9844158212941525, 5.0,
            0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.5292568487058473, 2.1209602187058474,
            -1.4844158212941525, 5.0, 0.692606109997351, -0.23086870333245033, -0.6833713618640529, 4.0,
            1.5292568487058473, 1.6209602187058474, -1.9844158212941525, 5.0, 0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, 1.5292568487058473, 1.6209602187058474, -1.4844158212941525, 5.0,
            0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.5292568487058473, 2.1209602187058474,
            -1.4844158212941525, 5.0, 0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.5292568487058473,
            1.6209602187058474, -0.9844158212941525, 5.0, 0.999977778518491, 0.0, 0.006666518523456607, 4.0,
            1.5292568487058473, 1.6209602187058474, -0.9844158212941525, 5.0, 0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, 1.5292568487058473, 2.1209602187058474, -1.4844158212941525, 5.0,
            0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.5292568487058473, 2.1209602187058474,
            -0.9844158212941525, 5.0, 0.999977778518491, 0.0, 0.006666518523456607, 4.0, 1.5292568487058473,
            1.6209602187058474, -0.9844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0,
            1.5292568487058473, 2.1209602187058474, -0.9844158212941525, 5.0, 0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, 1.5292568487058473, 1.6209602187058474, -0.4844158212941525, 5.0,
            0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.5292568487058473, 1.6209602187058474,
            -0.4844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.5292568487058473,
            2.1209602187058474, -0.9844158212941525, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0,
            1.5292568487058473, 2.1209602187058474, -0.4844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, 1.5292568487058473, 2.1209602187058474, -0.4844158212941525, 5.0,
            0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0, 1.5292568487058473, 1.6209602187058474,
            0.015584178705847496, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.5292568487058473,
            1.6209602187058474, 0.015584178705847496, 5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082,
            4.0, 1.5292568487058473, 2.1209602187058474, -0.4844158212941525, 5.0, 0.9999111229612074, 0.0,
            0.013332148306149432, 4.0, 1.5292568487058473, 1.6209602187058474, 0.015584178705847496, 5.0,
            0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.5292568487058473, 2.1209602187058474,
            -0.4844158212941525, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.5292568487058473,
            2.1209602187058474, -0.4844158212941525, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0,
            1.5292568487058473, 1.6209602187058474, 0.015584178705847496, 5.0, 0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, 1.5292568487058473, 1.6209602187058474, -0.4844158212941525, 5.0,
            0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.5292568487058473, 1.6209602187058474,
            0.015584178705847496, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            1.5292568487058473, 1.6209602187058474, 0.015584178705847496, 5.0, 0.7000714109260575, 0.0,
            0.7140728391445786, 4.0, 1.5292568487058473, 1.6209602187058474, 0.015584178705847496, 5.0,
            0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.5292568487058473, 2.1209602187058474,
            -1.4844158212941525, 5.0, 0.5811989248480778, 0.5811989248480778, -0.5695749463511162, 4.0,
            1.5292568487058473, 2.1209602187058474, -1.9844158212941525, 5.0, 0.8218838786411851, 0.41094193932059253,
            -0.3945042617477688, 4.0, 1.5292568487058473, 2.1209602187058474, -1.4844158212941525, 5.0,
            0.8218838786411851, 0.41094193932059253, -0.3945042617477688, 4.0, 1.5292568487058473, 2.1209602187058474,
            -1.4844158212941525, 5.0, 0.5811989248480778, 0.5811989248480778, -0.5695749463511162, 4.0,
            1.5292568487058473, 2.6209602187058474, -1.4844158212941525, 5.0, 0.9999111229612074, 0.0,
            0.013332148306149432, 4.0, 1.5292568487058473, 2.6209602187058474, -0.9844158212941525, 5.0,
            0.8218838786411851, 0.41094193932059253, -0.3945042617477688, 4.0, 1.5292568487058473, 2.1209602187058474,
            -1.4844158212941525, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.5292568487058473,
            2.6209602187058474, -0.9844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0,
            1.5292568487058473, 2.1209602187058474, -1.4844158212941525, 5.0, 0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, 1.5292568487058473, 2.1209602187058474, -1.4844158212941525, 5.0,
            0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.5292568487058473, 2.6209602187058474,
            -0.9844158212941525, 5.0, 0.9999680015359181, 0.0, 0.007999744012287346, 4.0, 1.5292568487058473,
            2.1209602187058474, -0.9844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082,
            4.0, 1.5292568487058473, 2.6209602187058474, -0.9844158212941525, 5.0, 0.5735016055486672,
            0.5735016055486672, 0.5849716376596406, 4.0, 1.5292568487058473, 2.1209602187058474, -0.4844158212941525,
            5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.5292568487058473, 2.1209602187058474,
            -0.4844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194, 0.5924411367547082, 4.0,
            1.5292568487058473, 2.6209602187058474, -0.9844158212941525, 5.0, 0.9999111229612074, 0.0,
            0.013332148306149432, 4.0, 1.5292568487058473, 2.1209602187058474, -0.4844158212941525, 5.0,
            0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.5292568487058473, 2.6209602187058474,
            -0.9844158212941525, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.5292568487058473,
            2.6209602187058474, -0.9844158212941525, 5.0, 0.9999111229612074, 0.0, 0.013332148306149432, 4.0,
            1.5292568487058473, 2.1209602187058474, -0.4844158212941525, 5.0, 0.9999680015359181, 0.0,
            0.007999744012287346, 4.0, 1.5292568487058473, 2.1209602187058474, -0.9844158212941525, 5.0,
            0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.5292568487058473, 2.1209602187058474,
            -0.4844158212941525, 5.0, 0.5735016055486672, 0.5735016055486672, 0.5849716376596406, 4.0,
            1.5292568487058473, 2.1209602187058474, -0.4844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, 1.5292568487058473, 2.1209602187058474, -0.4844158212941525, 5.0,
            0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.5292568487058473, 2.6209602187058474,
            -0.9844158212941525, 5.0, 0.5811989248480778, 0.5811989248480778, -0.5695749463511162, 4.0,
            1.5292568487058473, 2.6209602187058474, -1.4844158212941525, 5.0, 0.6636648415023736, 0.6636648415023736,
            0.34510571758123426, 4.0, 1.5292568487058473, 2.6209602187058474, -0.9844158212941525, 5.0,
            0.9999111229612074, 0.0, 0.013332148306149432, 4.0, 1.5292568487058473, 2.6209602187058474,
            -0.9844158212941525, 5.0, 0.6636648415023736, 0.6636648415023736, 0.34510571758123426, 4.0,
            1.5292568487058473, 2.6209602187058474, -0.9844158212941525, 5.0, 0.5696549391872194, 0.5696549391872194,
            0.5924411367547082, 4.0, 1.5292568487058473, 2.6209602187058474, -0.9844158212941525, 3.0]
