# degiro-client
Unofficial Degiro API

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.0.1
- Package version: 0.0.1a0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import degiro_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import degiro_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import degiro_client
from degiro_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: IntAccountAuth
configuration = degiro_client.Configuration()
configuration.api_key['intAccount'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['intAccount'] = 'Bearer'
# Configure API key authorization: SessionIdAuth
configuration = degiro_client.Configuration()
configuration.api_key['sessionId'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['sessionId'] = 'Bearer'

# create an instance of the API class
api_instance = degiro_client.ConfigApi(degiro_client.ApiClient(configuration))

try:
    # Returns the config
    api_response = api_instance.config()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ConfigApi->config: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://trader.degiro.nl*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ConfigApi* | [**config**](docs/ConfigApi.md#config) | **GET** /login/secure/config | Returns the config
*LoginApi* | [**login**](docs/LoginApi.md#login) | **POST** /login/secure/login | Logs in
*PaApi* | [**client**](docs/PaApi.md#client) | **GET** /pa/secure/client | Returns the client
*TradingApi* | [**update**](docs/TradingApi.md#update) | **GET** /trading/secure/v5/update/{intAccount};jsessionid&#x3D;{sessionId} | Returns the config

## Documentation For Models

 - [ClientResponse](docs/ClientResponse.md)
 - [ClientResponseData](docs/ClientResponseData.md)
 - [ClientResponseDataAddress](docs/ClientResponseDataAddress.md)
 - [ClientResponseDataBankAccount](docs/ClientResponseDataBankAccount.md)
 - [ClientResponseDataFirstContact](docs/ClientResponseDataFirstContact.md)
 - [ConfigResponse](docs/ConfigResponse.md)
 - [ConfigResponseData](docs/ConfigResponseData.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [LoginResponse](docs/LoginResponse.md)
 - [OneOfinlineResponse200](docs/OneOfinlineResponse200.md)
 - [PortfolioResponse](docs/PortfolioResponse.md)
 - [PortfolioResponseValue](docs/PortfolioResponseValue.md)
 - [PortfolioResponseValue1](docs/PortfolioResponseValue1.md)

## Documentation For Authorization


## IntAccountAuth

- **Type**: API key
- **API key parameter name**: intAccount
- **Location**: URL query string

## SessionIdAuth

- **Type**: API key
- **API key parameter name**: sessionId
- **Location**: URL query string


## Author


