# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['BillingGroup']


class BillingGroup(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 address_lines: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 billing_currency: Optional[pulumi.Input[str]] = None,
                 billing_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 billing_extra_text: Optional[pulumi.Input[str]] = None,
                 card_id: Optional[pulumi.Input[str]] = None,
                 city: Optional[pulumi.Input[str]] = None,
                 company: Optional[pulumi.Input[str]] = None,
                 country_code: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 vat_id: Optional[pulumi.Input[str]] = None,
                 zip_code: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a BillingGroup resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Account id
        :param pulumi.Input[Sequence[pulumi.Input[str]]] address_lines: Address lines
        :param pulumi.Input[str] billing_currency: Billing currency
        :param pulumi.Input[Sequence[pulumi.Input[str]]] billing_emails: Billing contact emails
        :param pulumi.Input[str] billing_extra_text: Billing extra text
        :param pulumi.Input[str] card_id: Credit card id
        :param pulumi.Input[str] city: City
        :param pulumi.Input[str] company: Company name
        :param pulumi.Input[str] country_code: Country code
        :param pulumi.Input[str] name: Billing Group name
        :param pulumi.Input[str] state: State
        :param pulumi.Input[str] vat_id: VAT id
        :param pulumi.Input[str] zip_code: Zip Code
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['account_id'] = account_id
            __props__['address_lines'] = address_lines
            __props__['billing_currency'] = billing_currency
            __props__['billing_emails'] = billing_emails
            __props__['billing_extra_text'] = billing_extra_text
            __props__['card_id'] = card_id
            __props__['city'] = city
            __props__['company'] = company
            __props__['country_code'] = country_code
            __props__['name'] = name
            __props__['state'] = state
            __props__['vat_id'] = vat_id
            __props__['zip_code'] = zip_code
        super(BillingGroup, __self__).__init__(
            'aiven:index/billingGroup:BillingGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            address_lines: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            billing_currency: Optional[pulumi.Input[str]] = None,
            billing_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            billing_extra_text: Optional[pulumi.Input[str]] = None,
            card_id: Optional[pulumi.Input[str]] = None,
            city: Optional[pulumi.Input[str]] = None,
            company: Optional[pulumi.Input[str]] = None,
            country_code: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            vat_id: Optional[pulumi.Input[str]] = None,
            zip_code: Optional[pulumi.Input[str]] = None) -> 'BillingGroup':
        """
        Get an existing BillingGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Account id
        :param pulumi.Input[Sequence[pulumi.Input[str]]] address_lines: Address lines
        :param pulumi.Input[str] billing_currency: Billing currency
        :param pulumi.Input[Sequence[pulumi.Input[str]]] billing_emails: Billing contact emails
        :param pulumi.Input[str] billing_extra_text: Billing extra text
        :param pulumi.Input[str] card_id: Credit card id
        :param pulumi.Input[str] city: City
        :param pulumi.Input[str] company: Company name
        :param pulumi.Input[str] country_code: Country code
        :param pulumi.Input[str] name: Billing Group name
        :param pulumi.Input[str] state: State
        :param pulumi.Input[str] vat_id: VAT id
        :param pulumi.Input[str] zip_code: Zip Code
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["account_id"] = account_id
        __props__["address_lines"] = address_lines
        __props__["billing_currency"] = billing_currency
        __props__["billing_emails"] = billing_emails
        __props__["billing_extra_text"] = billing_extra_text
        __props__["card_id"] = card_id
        __props__["city"] = city
        __props__["company"] = company
        __props__["country_code"] = country_code
        __props__["name"] = name
        __props__["state"] = state
        __props__["vat_id"] = vat_id
        __props__["zip_code"] = zip_code
        return BillingGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[str]]:
        """
        Account id
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Address lines
        """
        return pulumi.get(self, "address_lines")

    @property
    @pulumi.getter(name="billingCurrency")
    def billing_currency(self) -> pulumi.Output[Optional[str]]:
        """
        Billing currency
        """
        return pulumi.get(self, "billing_currency")

    @property
    @pulumi.getter(name="billingEmails")
    def billing_emails(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Billing contact emails
        """
        return pulumi.get(self, "billing_emails")

    @property
    @pulumi.getter(name="billingExtraText")
    def billing_extra_text(self) -> pulumi.Output[Optional[str]]:
        """
        Billing extra text
        """
        return pulumi.get(self, "billing_extra_text")

    @property
    @pulumi.getter(name="cardId")
    def card_id(self) -> pulumi.Output[Optional[str]]:
        """
        Credit card id
        """
        return pulumi.get(self, "card_id")

    @property
    @pulumi.getter
    def city(self) -> pulumi.Output[Optional[str]]:
        """
        City
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def company(self) -> pulumi.Output[Optional[str]]:
        """
        Company name
        """
        return pulumi.get(self, "company")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Output[Optional[str]]:
        """
        Country code
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Billing Group name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[str]]:
        """
        State
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vatId")
    def vat_id(self) -> pulumi.Output[Optional[str]]:
        """
        VAT id
        """
        return pulumi.get(self, "vat_id")

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> pulumi.Output[Optional[str]]:
        """
        Zip Code
        """
        return pulumi.get(self, "zip_code")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

