import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeMaterializedViewsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/materialized_views#database DataSnowflakeMaterializedViews#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the views from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/materialized_views#schema DataSnowflakeMaterializedViews#schema}
    */
    readonly schema: string;
}
export declare class DataSnowflakeMaterializedViewsMaterializedViews extends cdktf.ComplexComputedList {
    get comment(): string;
    get database(): string;
    get name(): string;
    get schema(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/materialized_views snowflake_materialized_views}
*/
export declare class DataSnowflakeMaterializedViews extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/materialized_views snowflake_materialized_views} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeMaterializedViewsConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeMaterializedViewsConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    materializedViews(index: string): DataSnowflakeMaterializedViewsMaterializedViews;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
