import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeStagesConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/stages#database DataSnowflakeStages#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the stages from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/stages#schema DataSnowflakeStages#schema}
    */
    readonly schema: string;
}
export declare class DataSnowflakeStagesStages extends cdktf.ComplexComputedList {
    get comment(): string;
    get database(): string;
    get name(): string;
    get schema(): string;
    get storageIntegration(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/stages snowflake_stages}
*/
export declare class DataSnowflakeStages extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/stages snowflake_stages} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeStagesConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeStagesConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    stages(index: string): DataSnowflakeStagesStages;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
