import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `CfnDataSource`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export interface CfnDataSourceProps {
    /**
     * The identifier of the index that should be associated with this data source.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-indexid
     */
    readonly indexId: string;
    /**
     * The name of the data source.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-name
     */
    readonly name: string;
    /**
     * The type of the data source.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-type
     */
    readonly type: string;
    /**
     * Configuration information for an Amazon Kendra data source.
     *
     * The contents of the configuration depend on the type of data source. You can only specify one type of data source in the configuration. Choose from one of the following data sources.
     *
     * - Amazon S3
     * - Confluence
     * - Custom
     * - Database
     * - Microsoft OneDrive
     * - Microsoft SharePoint
     * - Salesforce
     * - ServiceNow
     *
     * You can't specify the `Configuration` parameter when the `Type` parameter is set to `CUSTOM` .
     *
     * The `Configuration` parameter is required for all other data sources.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-datasourceconfiguration
     */
    readonly dataSourceConfiguration?: CfnDataSource.DataSourceConfigurationProperty | cdk.IResolvable;
    /**
     * A description of the data source.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-description
     */
    readonly description?: string;
    /**
     * The Amazon Resource Name (ARN) of a role with permission to access the data source.
     *
     * You can't specify the `RoleArn` parameter when the `Type` parameter is set to `CUSTOM` .
     *
     * The `RoleArn` parameter is required for all other data sources.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-rolearn
     */
    readonly roleArn?: string;
    /**
     * Sets the frequency that Amazon Kendra checks the documents in your data source and updates the index.
     *
     * If you don't set a schedule, Amazon Kendra doesn't periodically update the index.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-schedule
     */
    readonly schedule?: string;
    /**
     * An array of key-value pairs to apply to this resource.
     *
     * For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare class CfnDataSource extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Kendra::DataSource";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDataSource;
    /**
     * The Amazon Resource Name (ARN) of the data source. For example:.
     *
     * `arn:aws:kendra:us-west-2:111122223333:index/335c3741-41df-46a6-b5d3-61f85b787884/data-source/b8cae438-6787-4091-8897-684a652bbb0a`
     *
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * The identifier for the data source. For example:.
     *
     * `b8cae438-6787-4091-8897-684a652bbb0a` .
     *
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * The identifier of the index that should be associated with this data source.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-indexid
     */
    indexId: string;
    /**
     * The name of the data source.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-name
     */
    name: string;
    /**
     * The type of the data source.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-type
     */
    type: string;
    /**
     * Configuration information for an Amazon Kendra data source.
     *
     * The contents of the configuration depend on the type of data source. You can only specify one type of data source in the configuration. Choose from one of the following data sources.
     *
     * - Amazon S3
     * - Confluence
     * - Custom
     * - Database
     * - Microsoft OneDrive
     * - Microsoft SharePoint
     * - Salesforce
     * - ServiceNow
     *
     * You can't specify the `Configuration` parameter when the `Type` parameter is set to `CUSTOM` .
     *
     * The `Configuration` parameter is required for all other data sources.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-datasourceconfiguration
     */
    dataSourceConfiguration: CfnDataSource.DataSourceConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * A description of the data source.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-description
     */
    description: string | undefined;
    /**
     * The Amazon Resource Name (ARN) of a role with permission to access the data source.
     *
     * You can't specify the `RoleArn` parameter when the `Type` parameter is set to `CUSTOM` .
     *
     * The `RoleArn` parameter is required for all other data sources.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-rolearn
     */
    roleArn: string | undefined;
    /**
     * Sets the frequency that Amazon Kendra checks the documents in your data source and updates the index.
     *
     * If you don't set a schedule, Amazon Kendra doesn't periodically update the index.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-schedule
     */
    schedule: string | undefined;
    /**
     * An array of key-value pairs to apply to this resource.
     *
     * For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Kendra::DataSource`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDataSourceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Specifies access control list files for the documents in a data source.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-accesscontrollistconfiguration.html
     */
    interface AccessControlListConfigurationProperty {
        /**
         * Path to the AWS S3 bucket that contains the access control list files.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-accesscontrollistconfiguration.html#cfn-kendra-datasource-accesscontrollistconfiguration-keypath
         */
        readonly keyPath?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides information about the column that should be used for filtering the query response by groups.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-aclconfiguration.html
     */
    interface AclConfigurationProperty {
        /**
         * A list of groups, separated by semi-colons, that filters a query response based on user context.
         *
         * The document is only returned to users that are in one of the groups specified in the `UserContext` field of the [Query](https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html) operation.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-aclconfiguration.html#cfn-kendra-datasource-aclconfiguration-allowedgroupscolumnname
         */
        readonly allowedGroupsColumnName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides information about how Amazon Kendra should use the columns of a database in an index.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html
     */
    interface ColumnConfigurationProperty {
        /**
         * One to five columns that indicate when a document in the database has changed.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html#cfn-kendra-datasource-columnconfiguration-changedetectingcolumns
         */
        readonly changeDetectingColumns: string[];
        /**
         * The column that contains the contents of the document.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html#cfn-kendra-datasource-columnconfiguration-documentdatacolumnname
         */
        readonly documentDataColumnName: string;
        /**
         * The column that provides the document's unique identifier.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html#cfn-kendra-datasource-columnconfiguration-documentidcolumnname
         */
        readonly documentIdColumnName: string;
        /**
         * The column that contains the title of the document.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html#cfn-kendra-datasource-columnconfiguration-documenttitlecolumnname
         */
        readonly documentTitleColumnName?: string;
        /**
         * An array of objects that map database column names to the corresponding fields in an index.
         *
         * You must first create the fields in the index using the [UpdateIndex](https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateIndex.html) operation.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html#cfn-kendra-datasource-columnconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Specifies the attachment settings for the Confluence data source.
     *
     * Attachment settings are optional, if you don't specify settings attachments, Amazon Kendra won't index them.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmentconfiguration.html
     */
    interface ConfluenceAttachmentConfigurationProperty {
        /**
         * Defines how attachment metadata fields should be mapped to index fields.
         *
         * Before you can map a field, you must first create an index field with a matching type using the console or the `UpdateIndex` operation.
         *
         * If you specify the `AttachentFieldMappings` parameter, you must specify at least one field mapping.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmentconfiguration.html#cfn-kendra-datasource-confluenceattachmentconfiguration-attachmentfieldmappings
         */
        readonly attachmentFieldMappings?: Array<CfnDataSource.ConfluenceAttachmentToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * Indicates whether Amazon Kendra indexes attachments to the pages and blogs in the Confluence data source.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmentconfiguration.html#cfn-kendra-datasource-confluenceattachmentconfiguration-crawlattachments
         */
        readonly crawlAttachments?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Defines the mapping between a field in the Confluence data source to a Amazon Kendra index field.
     *
     * You must first create the index field using the `UpdateIndex` operation.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmenttoindexfieldmapping.html
     */
    interface ConfluenceAttachmentToIndexFieldMappingProperty {
        /**
         * The name of the field in the data source.
         *
         * You must first create the index field using the `UpdateIndex` operation.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmenttoindexfieldmapping.html#cfn-kendra-datasource-confluenceattachmenttoindexfieldmapping-datasourcefieldname
         */
        readonly dataSourceFieldName: string;
        /**
         * The format for date fields in the data source.
         *
         * If the field specified in `DataSourceFieldName` is a date field you must specify the date format. If the field is not a date field, an exception is thrown.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmenttoindexfieldmapping.html#cfn-kendra-datasource-confluenceattachmenttoindexfieldmapping-datefieldformat
         */
        readonly dateFieldFormat?: string;
        /**
         * The name of the index field to map to the Confluence data source field.
         *
         * The index field type must match the Confluence field type.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmenttoindexfieldmapping.html#cfn-kendra-datasource-confluenceattachmenttoindexfieldmapping-indexfieldname
         */
        readonly indexFieldName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Specifies the blog settings for the Confluence data source.
     *
     * Blogs are always indexed unless filtered from the index by the `ExclusionPatterns` or `InclusionPatterns` fields in the `ConfluenceConfiguration` type.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogconfiguration.html
     */
    interface ConfluenceBlogConfigurationProperty {
        /**
         * Defines how blog metadata fields should be mapped to index fields.
         *
         * Before you can map a field, you must first create an index field with a matching type using the console or the `UpdateIndex` operation.
         *
         * If you specify the `BlogFieldMappings` parameter, you must specify at least one field mapping.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogconfiguration.html#cfn-kendra-datasource-confluenceblogconfiguration-blogfieldmappings
         */
        readonly blogFieldMappings?: Array<CfnDataSource.ConfluenceBlogToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Defines the mapping between a blog field in the Confluence data source to a Amazon Kendra index field.
     *
     * You must first create the index field using the `UpdateIndex` operation.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogtoindexfieldmapping.html
     */
    interface ConfluenceBlogToIndexFieldMappingProperty {
        /**
         * The name of the field in the data source.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogtoindexfieldmapping.html#cfn-kendra-datasource-confluenceblogtoindexfieldmapping-datasourcefieldname
         */
        readonly dataSourceFieldName: string;
        /**
         * The format for date fields in the data source.
         *
         * If the field specified in `DataSourceFieldName` is a date field you must specify the date format. If the field is not a date field, an exception is thrown.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogtoindexfieldmapping.html#cfn-kendra-datasource-confluenceblogtoindexfieldmapping-datefieldformat
         */
        readonly dateFieldFormat?: string;
        /**
         * The name of the index field to map to the Confluence data source field.
         *
         * The index field type must match the Confluence field type.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogtoindexfieldmapping.html#cfn-kendra-datasource-confluenceblogtoindexfieldmapping-indexfieldname
         */
        readonly indexFieldName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides configuration information for data sources that connect to Confluence.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html
     */
    interface ConfluenceConfigurationProperty {
        /**
         * Specifies configuration information for indexing attachments to Confluence blogs and pages.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-attachmentconfiguration
         */
        readonly attachmentConfiguration?: CfnDataSource.ConfluenceAttachmentConfigurationProperty | cdk.IResolvable;
        /**
         * Specifies configuration information for indexing Confluence blogs.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-blogconfiguration
         */
        readonly blogConfiguration?: CfnDataSource.ConfluenceBlogConfigurationProperty | cdk.IResolvable;
        /**
         * A list of regular expression patterns that apply to a URL on the Confluence server.
         *
         * An exclusion pattern can apply to a blog post, a page, a space, or an attachment. Items that match the pattern are excluded from the index. Items that don't match the pattern are included in the index. If a item matches both an exclusion pattern and an inclusion pattern, the item isn't included in the index.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-exclusionpatterns
         */
        readonly exclusionPatterns?: string[];
        /**
         * A list of regular expression patterns that apply to a URL on the Confluence server.
         *
         * An inclusion pattern can apply to a blog post, a page, a space, or an attachment. Items that match the patterns are included in the index. Items that don't match the pattern are excluded from the index. If an item matches both an inclusion pattern and an exclusion pattern, the item isn't included in the index.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-inclusionpatterns
         */
        readonly inclusionPatterns?: string[];
        /**
         * Specifies configuration information for indexing Confluence pages.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-pageconfiguration
         */
        readonly pageConfiguration?: CfnDataSource.ConfluencePageConfigurationProperty | cdk.IResolvable;
        /**
         * The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that contains the key/value pairs required to connect to your Confluence server.
         *
         * The secret must contain a JSON structure with the following keys:
         *
         * - username - The user name or email address of a user with administrative privileges for the Confluence server.
         * - password - The password associated with the user logging in to the Confluence server.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-secretarn
         */
        readonly secretArn: string;
        /**
         * The URL of your Confluence instance.
         *
         * Use the full URL of the server. For example, `https://server.example.com:port/` . You can also use an IP address, for example, `https://192.168.1.113/` .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-serverurl
         */
        readonly serverUrl: string;
        /**
         * Specifies configuration information for indexing Confluence spaces.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-spaceconfiguration
         */
        readonly spaceConfiguration?: CfnDataSource.ConfluenceSpaceConfigurationProperty | cdk.IResolvable;
        /**
         * Specifies the version of the Confluence installation that you are connecting to.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-version
         */
        readonly version: string;
        /**
         * Specifies the information for connecting to an Amazon VPC.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-vpcconfiguration
         */
        readonly vpcConfiguration?: CfnDataSource.DataSourceVpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Specifies the page settings for the Confluence data source.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepageconfiguration.html
     */
    interface ConfluencePageConfigurationProperty {
        /**
         * Defines how page metadata fields should be mapped to index fields.
         *
         * Before you can map a field, you must first create an index field with a matching type using the console or the `UpdateIndex` operation.
         *
         * If you specify the `PageFieldMappings` parameter, you must specify at least one field mapping.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepageconfiguration.html#cfn-kendra-datasource-confluencepageconfiguration-pagefieldmappings
         */
        readonly pageFieldMappings?: Array<CfnDataSource.ConfluencePageToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Defines the mapping between a field in the Confluence data source to a Amazon Kendra index field.
     *
     * You must first create the index field using the `UpdateIndex` operation.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepagetoindexfieldmapping.html
     */
    interface ConfluencePageToIndexFieldMappingProperty {
        /**
         * The name of the field in the data source.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepagetoindexfieldmapping.html#cfn-kendra-datasource-confluencepagetoindexfieldmapping-datasourcefieldname
         */
        readonly dataSourceFieldName: string;
        /**
         * The format for date fields in the data source.
         *
         * If the field specified in `DataSourceFieldName` is a date field you must specify the date format. If the field is not a date field, an exception is thrown.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepagetoindexfieldmapping.html#cfn-kendra-datasource-confluencepagetoindexfieldmapping-datefieldformat
         */
        readonly dateFieldFormat?: string;
        /**
         * The name of the index field to map to the Confluence data source field.
         *
         * The index field type must match the Confluence field type.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepagetoindexfieldmapping.html#cfn-kendra-datasource-confluencepagetoindexfieldmapping-indexfieldname
         */
        readonly indexFieldName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Specifies the configuration for indexing Confluence spaces.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html
     */
    interface ConfluenceSpaceConfigurationProperty {
        /**
         * Specifies whether Amazon Kendra should index archived spaces.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html#cfn-kendra-datasource-confluencespaceconfiguration-crawlarchivedspaces
         */
        readonly crawlArchivedSpaces?: boolean | cdk.IResolvable;
        /**
         * Specifies whether Amazon Kendra should index personal spaces.
         *
         * Users can add restrictions to items in personal spaces. If personal spaces are indexed, queries without user context information may return restricted items from a personal space in their results. For more information, see [Filtering on user context](https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html) .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html#cfn-kendra-datasource-confluencespaceconfiguration-crawlpersonalspaces
         */
        readonly crawlPersonalSpaces?: boolean | cdk.IResolvable;
        /**
         * A list of space keys of Confluence spaces.
         *
         * If you include a key, the blogs, documents, and attachments in the space are not indexed. If a space is in both the `ExcludeSpaces` and the `IncludeSpaces` list, the space is excluded.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html#cfn-kendra-datasource-confluencespaceconfiguration-excludespaces
         */
        readonly excludeSpaces?: string[];
        /**
         * A list of space keys for Confluence spaces.
         *
         * If you include a key, the blogs, documents, and attachments in the space are indexed. Spaces that aren't in the list aren't indexed. A space in the list must exist. Otherwise, Amazon Kendra logs an error when the data source is synchronized. If a space is in both the `IncludeSpaces` and the `ExcludeSpaces` list, the space is excluded.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html#cfn-kendra-datasource-confluencespaceconfiguration-includespaces
         */
        readonly includeSpaces?: string[];
        /**
         * Defines how space metadata fields should be mapped to index fields.
         *
         * Before you can map a field, you must first create an index field with a matching type using the console or the `UpdateIndex` operation.
         *
         * If you specify the `SpaceFieldMappings` parameter, you must specify at least one field mapping.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html#cfn-kendra-datasource-confluencespaceconfiguration-spacefieldmappings
         */
        readonly spaceFieldMappings?: Array<CfnDataSource.ConfluenceSpaceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Defines the mapping between a field in the Confluence data source to a Amazon Kendra index field.
     *
     * You must first create the index field using the `UpdateIndex` operation.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacetoindexfieldmapping.html
     */
    interface ConfluenceSpaceToIndexFieldMappingProperty {
        /**
         * The name of the field in the data source.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacetoindexfieldmapping.html#cfn-kendra-datasource-confluencespacetoindexfieldmapping-datasourcefieldname
         */
        readonly dataSourceFieldName: string;
        /**
         * The format for date fields in the data source.
         *
         * If the field specified in `DataSourceFieldName` is a date field you must specify the date format. If the field is not a date field, an exception is thrown.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacetoindexfieldmapping.html#cfn-kendra-datasource-confluencespacetoindexfieldmapping-datefieldformat
         */
        readonly dateFieldFormat?: string;
        /**
         * The name of the index field to map to the Confluence data source field.
         *
         * The index field type must match the Confluence field type.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacetoindexfieldmapping.html#cfn-kendra-datasource-confluencespacetoindexfieldmapping-indexfieldname
         */
        readonly indexFieldName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides the information necessary to connect to a database.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html
     */
    interface ConnectionConfigurationProperty {
        /**
         * The name of the host for the database.
         *
         * Can be either a string (host.subdomain.domain.tld) or an IPv4 or IPv6 address.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html#cfn-kendra-datasource-connectionconfiguration-databasehost
         */
        readonly databaseHost: string;
        /**
         * The name of the database containing the document data.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html#cfn-kendra-datasource-connectionconfiguration-databasename
         */
        readonly databaseName: string;
        /**
         * The port that the database uses for connections.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html#cfn-kendra-datasource-connectionconfiguration-databaseport
         */
        readonly databasePort: number;
        /**
         * The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager .
         *
         * The credentials should be a user/password pair. For more information, see [Using a Database Data Source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html) . For more information about AWS Secrets Manager , see [What Is AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html) in the *AWS Secrets Manager* user guide.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html#cfn-kendra-datasource-connectionconfiguration-secretarn
         */
        readonly secretArn: string;
        /**
         * The name of the table that contains the document data.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html#cfn-kendra-datasource-connectionconfiguration-tablename
         */
        readonly tableName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Configuration information for an Amazon Kendra data source.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html
     */
    interface DataSourceConfigurationProperty {
        /**
         * Provides configuration information for connecting to a Confluence data source.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-confluenceconfiguration
         */
        readonly confluenceConfiguration?: CfnDataSource.ConfluenceConfigurationProperty | cdk.IResolvable;
        /**
         * Provides information necessary to create a data source connector for a database.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-databaseconfiguration
         */
        readonly databaseConfiguration?: CfnDataSource.DatabaseConfigurationProperty | cdk.IResolvable;
        /**
         * Provides configuration for data sources that connect to Google Drive.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-googledriveconfiguration
         */
        readonly googleDriveConfiguration?: CfnDataSource.GoogleDriveConfigurationProperty | cdk.IResolvable;
        /**
         * Provides configuration for data sources that connect to Microsoft OneDrive.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-onedriveconfiguration
         */
        readonly oneDriveConfiguration?: CfnDataSource.OneDriveConfigurationProperty | cdk.IResolvable;
        /**
         * Provides information to create a data source connector for a document repository in an Amazon S3 bucket.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-s3configuration
         */
        readonly s3Configuration?: CfnDataSource.S3DataSourceConfigurationProperty | cdk.IResolvable;
        /**
         * Provides configuration information for data sources that connect to a Salesforce site.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-salesforceconfiguration
         */
        readonly salesforceConfiguration?: CfnDataSource.SalesforceConfigurationProperty | cdk.IResolvable;
        /**
         * Provides configuration for data sources that connect to ServiceNow instances.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-servicenowconfiguration
         */
        readonly serviceNowConfiguration?: CfnDataSource.ServiceNowConfigurationProperty | cdk.IResolvable;
        /**
         * Provides information necessary to create a data source connector for a Microsoft SharePoint site.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-sharepointconfiguration
         */
        readonly sharePointConfiguration?: CfnDataSource.SharePointConfigurationProperty | cdk.IResolvable;
        /**
         * Provides the configuration information required for Amazon Kendra Web Crawler.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-webcrawlerconfiguration
         */
        readonly webCrawlerConfiguration?: CfnDataSource.WebCrawlerConfigurationProperty | cdk.IResolvable;
        /**
         * Provides the configuration information to connect to WorkDocs as your data source.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-workdocsconfiguration
         */
        readonly workDocsConfiguration?: CfnDataSource.WorkDocsConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Maps a column or attribute in the data source to an index field.
     *
     * You must first create the fields in the index using the [UpdateIndex](https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateIndex.html) operation.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcetoindexfieldmapping.html
     */
    interface DataSourceToIndexFieldMappingProperty {
        /**
         * The name of the column or attribute in the data source.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcetoindexfieldmapping.html#cfn-kendra-datasource-datasourcetoindexfieldmapping-datasourcefieldname
         */
        readonly dataSourceFieldName: string;
        /**
         * The type of data stored in the column or attribute.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcetoindexfieldmapping.html#cfn-kendra-datasource-datasourcetoindexfieldmapping-datefieldformat
         */
        readonly dateFieldFormat?: string;
        /**
         * The name of the field in the index.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcetoindexfieldmapping.html#cfn-kendra-datasource-datasourcetoindexfieldmapping-indexfieldname
         */
        readonly indexFieldName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides information for connecting to an Amazon VPC.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcevpcconfiguration.html
     */
    interface DataSourceVpcConfigurationProperty {
        /**
         * A list of identifiers of security groups within your Amazon VPC.
         *
         * The security groups should enable Amazon Kendra to connect to the data source.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcevpcconfiguration.html#cfn-kendra-datasource-datasourcevpcconfiguration-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * A list of identifiers for subnets within your Amazon VPC.
         *
         * The subnets should be able to connect to each other in the VPC, and they should have outgoing access to the Internet through a NAT device.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcevpcconfiguration.html#cfn-kendra-datasource-datasourcevpcconfiguration-subnetids
         */
        readonly subnetIds: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides the information necessary to connect a database to an index.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html
     */
    interface DatabaseConfigurationProperty {
        /**
         * Information about the database column that provides information for user context filtering.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-aclconfiguration
         */
        readonly aclConfiguration?: CfnDataSource.AclConfigurationProperty | cdk.IResolvable;
        /**
         * Information about where the index should get the document information from the database.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-columnconfiguration
         */
        readonly columnConfiguration: CfnDataSource.ColumnConfigurationProperty | cdk.IResolvable;
        /**
         * The information necessary to connect to a database.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-connectionconfiguration
         */
        readonly connectionConfiguration: CfnDataSource.ConnectionConfigurationProperty | cdk.IResolvable;
        /**
         * The type of database engine that runs the database.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-databaseenginetype
         */
        readonly databaseEngineType: string;
        /**
         * Provides information about how Amazon Kendra uses quote marks around SQL identifiers when querying a database data source.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-sqlconfiguration
         */
        readonly sqlConfiguration?: CfnDataSource.SqlConfigurationProperty | cdk.IResolvable;
        /**
         * Provides information for connecting to an Amazon VPC.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-vpcconfiguration
         */
        readonly vpcConfiguration?: CfnDataSource.DataSourceVpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes.
     *
     * Each metadata file contains metadata about a single document.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-documentsmetadataconfiguration.html
     */
    interface DocumentsMetadataConfigurationProperty {
        /**
         * A prefix used to filter metadata configuration files in the AWS S3 bucket.
         *
         * The S3 bucket might contain multiple metadata files. Use `S3Prefix` to include only the desired metadata files.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-documentsmetadataconfiguration.html#cfn-kendra-datasource-documentsmetadataconfiguration-s3prefix
         */
        readonly s3Prefix?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides configuration information for data sources that connect to Google Drive.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html
     */
    interface GoogleDriveConfigurationProperty {
        /**
         * A list of MIME types to exclude from the index. All documents matching the specified MIME type are excluded.
         *
         * For a list of MIME types, see [Using a Google Workspace Drive data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html) .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-excludemimetypes
         */
        readonly excludeMimeTypes?: string[];
        /**
         * A list of identifiers or shared drives to exclude from the index.
         *
         * All files and folders stored on the shared drive are excluded.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-excludeshareddrives
         */
        readonly excludeSharedDrives?: string[];
        /**
         * A list of email addresses of the users.
         *
         * Documents owned by these users are excluded from the index. Documents shared with excluded users are indexed unless they are excluded in another way.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-excludeuseraccounts
         */
        readonly excludeUserAccounts?: string[];
        /**
         * A list of regular expression patterns that apply to the path on Google Drive.
         *
         * Items that match the pattern are excluded from the index from both shared drives and users' My Drives. Items that don't match the pattern are included in the index. If an item matches both an exclusion pattern and an inclusion pattern, it is excluded from the index.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-exclusionpatterns
         */
        readonly exclusionPatterns?: string[];
        /**
         * Defines mapping between a field in the Google Drive and a Amazon Kendra index field.
         *
         * If you are using the console, you can define index fields when creating the mapping. If you are using the API, you must first create the field using the `UpdateIndex` operation.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A list of regular expression patterns that apply to path on Google Drive.
         *
         * Items that match the pattern are included in the index from both shared drives and users' My Drives. Items that don't match the pattern are excluded from the index. If an item matches both an inclusion pattern and an exclusion pattern, it is excluded from the index.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-inclusionpatterns
         */
        readonly inclusionPatterns?: string[];
        /**
         * The Amazon Resource Name (ARN) of a AWS Secrets Manager secret that contains the credentials required to connect to Google Drive.
         *
         * For more information, see [Using a Google Workspace Drive data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html) .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-secretarn
         */
        readonly secretArn: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides configuration information for data sources that connect to OneDrive.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html
     */
    interface OneDriveConfigurationProperty {
        /**
         * A Boolean value that specifies whether local groups are disabled ( `True` ) or enabled ( `False` ).
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-disablelocalgroups
         */
        readonly disableLocalGroups?: boolean | cdk.IResolvable;
        /**
         * List of regular expressions applied to documents.
         *
         * Items that match the exclusion pattern are not indexed. If you provide both an inclusion pattern and an exclusion pattern, any item that matches the exclusion pattern isn't indexed.
         *
         * The exclusion pattern is applied to the file name.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-exclusionpatterns
         */
        readonly exclusionPatterns?: string[];
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map Microsoft OneDrive fields to custom fields in the Amazon Kendra index.
         *
         * You must first create the index fields before you map OneDrive fields.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A list of regular expression patterns.
         *
         * Documents that match the pattern are included in the index. Documents that don't match the pattern are excluded from the index. If a document matches both an inclusion pattern and an exclusion pattern, the document is not included in the index.
         *
         * The exclusion pattern is applied to the file name.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-inclusionpatterns
         */
        readonly inclusionPatterns?: string[];
        /**
         * A list of user accounts whose documents should be indexed.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-onedriveusers
         */
        readonly oneDriveUsers: CfnDataSource.OneDriveUsersProperty | cdk.IResolvable;
        /**
         * The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that contains the user name and password to connect to OneDrive.
         *
         * The user named should be the application ID for the OneDrive application, and the password is the application key for the OneDrive application.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-secretarn
         */
        readonly secretArn: string;
        /**
         * The Azure Active Directory domain of the organization.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-tenantdomain
         */
        readonly tenantDomain: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * User accounts whose documents should be indexed.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveusers.html
     */
    interface OneDriveUsersProperty {
        /**
         * A list of users whose documents should be indexed.
         *
         * Specify the user names in email format, for example, `username@tenantdomain` . If you need to index the documents of more than 100 users, use the `OneDriveUserS3Path` field to specify the location of a file containing a list of users.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveusers.html#cfn-kendra-datasource-onedriveusers-onedriveuserlist
         */
        readonly oneDriveUserList?: string[];
        /**
         * The S3 bucket location of a file containing a list of users whose documents should be indexed.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveusers.html#cfn-kendra-datasource-onedriveusers-onedriveusers3path
         */
        readonly oneDriveUserS3Path?: CfnDataSource.S3PathProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides the configuration information for a web proxy to connect to website hosts.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-proxyconfiguration.html
     */
    interface ProxyConfigurationProperty {
        /**
         * Your secret ARN, which you can create in [AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html).
         *
         * The credentials are optional. You use a secret if web proxy credentials are required to connect to a website host. Amazon Kendra currently support basic authentication to connect to a web proxy server. The secret stores your credentials.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-proxyconfiguration.html#cfn-kendra-datasource-proxyconfiguration-credentials
         */
        readonly credentials?: string;
        /**
         * The name of the website host you want to connect to via a web proxy server.
         *
         * For example, the host name of https://a.example.com/page1.html is "a.example.com".
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-proxyconfiguration.html#cfn-kendra-datasource-proxyconfiguration-host
         */
        readonly host: string;
        /**
         * The port number of the website host you want to connect to via a web proxy server.
         *
         * For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-proxyconfiguration.html#cfn-kendra-datasource-proxyconfiguration-port
         */
        readonly port: number;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides configuration information for a data source to index documents in an Amazon S3 bucket.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html
     */
    interface S3DataSourceConfigurationProperty {
        /**
         * Provides the path to the S3 bucket that contains the user context filtering files for the data source.
         *
         * For the format of the file, see [Access control for S3 data sources](https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html) .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-accesscontrollistconfiguration
         */
        readonly accessControlListConfiguration?: CfnDataSource.AccessControlListConfigurationProperty | cdk.IResolvable;
        /**
         * The name of the bucket that contains the documents.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-bucketname
         */
        readonly bucketName: string;
        /**
         * Specifies document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes.
         *
         * Each metadata file contains metadata about a single document.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-documentsmetadataconfiguration
         */
        readonly documentsMetadataConfiguration?: CfnDataSource.DocumentsMetadataConfigurationProperty | cdk.IResolvable;
        /**
         * A list of glob patterns for documents that should not be indexed.
         *
         * If a document that matches an inclusion prefix or inclusion pattern also matches an exclusion pattern, the document is not indexed.
         *
         * Some [examples](https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters) are:
         *
         * - **.png , *.jpg* will exclude all PNG and JPEG image files in a directory (files with the extensions .png and .jpg).
         * - **internal** will exclude all files in a directory that contain 'internal' in the file name, such as 'internal', 'internal_only', 'company_internal'.
         * - *** /*internal** will exclude all internal-related files in a directory and its subdirectories.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-exclusionpatterns
         */
        readonly exclusionPatterns?: string[];
        /**
         * A list of glob patterns for documents that should be indexed.
         *
         * If a document that matches an inclusion pattern also matches an exclusion pattern, the document is not indexed.
         *
         * Some [examples](https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters) are:
         *
         * - **.txt* will include all text files in a directory (files with the extension .txt).
         * - *** /*.txt* will include all text files in a directory and its subdirectories.
         * - **tax** will include all files in a directory that contain 'tax' in the file name, such as 'tax', 'taxes', 'income_tax'.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-inclusionpatterns
         */
        readonly inclusionPatterns?: string[];
        /**
         * A list of S3 prefixes for the documents that should be included in the index.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-inclusionprefixes
         */
        readonly inclusionPrefixes?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Information required to find a specific file in an Amazon S3 bucket.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3path.html
     */
    interface S3PathProperty {
        /**
         * The name of the S3 bucket that contains the file.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3path.html#cfn-kendra-datasource-s3path-bucket
         */
        readonly bucket: string;
        /**
         * The name of the file.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3path.html#cfn-kendra-datasource-s3path-key
         */
        readonly key: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Defines configuration for syncing a Salesforce chatter feed.
     *
     * The contents of the object comes from the Salesforce FeedItem table.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedconfiguration.html
     */
    interface SalesforceChatterFeedConfigurationProperty {
        /**
         * The name of the column in the Salesforce FeedItem table that contains the content to index.
         *
         * Typically this is the `Body` column.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedconfiguration.html#cfn-kendra-datasource-salesforcechatterfeedconfiguration-documentdatafieldname
         */
        readonly documentDataFieldName: string;
        /**
         * The name of the column in the Salesforce FeedItem table that contains the title of the document.
         *
         * This is typically the `Title` column.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedconfiguration.html#cfn-kendra-datasource-salesforcechatterfeedconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedconfiguration.html#cfn-kendra-datasource-salesforcechatterfeedconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * Filters the documents in the feed based on status of the user.
         *
         * When you specify `ACTIVE_USERS` only documents from users who have an active account are indexed. When you specify `STANDARD_USER` only documents for Salesforce standard users are documented. You can specify both.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedconfiguration.html#cfn-kendra-datasource-salesforcechatterfeedconfiguration-includefiltertypes
         */
        readonly includeFilterTypes?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides configuration information for connecting to a Salesforce data source.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html
     */
    interface SalesforceConfigurationProperty {
        /**
         * Specifies configuration information for Salesforce chatter feeds.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-chatterfeedconfiguration
         */
        readonly chatterFeedConfiguration?: CfnDataSource.SalesforceChatterFeedConfigurationProperty | cdk.IResolvable;
        /**
         * Indicates whether Amazon Kendra should index attachments to Salesforce objects.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-crawlattachments
         */
        readonly crawlAttachments?: boolean | cdk.IResolvable;
        /**
         * A list of regular expression patterns.
         *
         * Documents that match the patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a document matches both an exclusion pattern and an inclusion pattern, the document is not included in the index.
         *
         * The regex is applied to the name of the attached file.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-excludeattachmentfilepatterns
         */
        readonly excludeAttachmentFilePatterns?: string[];
        /**
         * A list of regular expression patterns.
         *
         * Documents that match the patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a document matches both an inclusion pattern and an exclusion pattern, the document is not included in the index.
         *
         * The regex is applied to the name of the attached file.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-includeattachmentfilepatterns
         */
        readonly includeAttachmentFilePatterns?: string[];
        /**
         * Specifies configuration information for the knowledge article types that Amazon Kendra indexes.
         *
         * Amazon Kendra indexes standard knowledge articles and the standard fields of knowledge articles, or the custom fields of custom knowledge articles, but not both.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-knowledgearticleconfiguration
         */
        readonly knowledgeArticleConfiguration?: CfnDataSource.SalesforceKnowledgeArticleConfigurationProperty | cdk.IResolvable;
        /**
         * The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that contains the key/value pairs required to connect to your Salesforce instance.
         *
         * The secret must contain a JSON structure with the following keys:
         *
         * - authenticationUrl - The OAUTH endpoint that Amazon Kendra connects to get an OAUTH token.
         * - consumerKey - The application public key generated when you created your Salesforce application.
         * - consumerSecret - The application private key generated when you created your Salesforce application.
         * - password - The password associated with the user logging in to the Salesforce instance.
         * - securityToken - The token associated with the user account logging in to the Salesforce instance.
         * - username - The user name of the user logging in to the Salesforce instance.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-secretarn
         */
        readonly secretArn: string;
        /**
         * The instance URL for the Salesforce site that you want to index.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-serverurl
         */
        readonly serverUrl: string;
        /**
         * Provides configuration information for processing attachments to Salesforce standard objects.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-standardobjectattachmentconfiguration
         */
        readonly standardObjectAttachmentConfiguration?: CfnDataSource.SalesforceStandardObjectAttachmentConfigurationProperty | cdk.IResolvable;
        /**
         * Specifies the Salesforce standard objects that Amazon Kendra indexes.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-standardobjectconfigurations
         */
        readonly standardObjectConfigurations?: Array<CfnDataSource.SalesforceStandardObjectConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides configuration information for indexing Salesforce custom articles.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration.html
     */
    interface SalesforceCustomKnowledgeArticleTypeConfigurationProperty {
        /**
         * The name of the field in the custom knowledge article that contains the document data to index.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration-documentdatafieldname
         */
        readonly documentDataFieldName: string;
        /**
         * The name of the field in the custom knowledge article that contains the document title.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * One or more objects that map fields in the custom knowledge article to fields in the Amazon Kendra index.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The name of the configuration.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Specifies configuration information for the knowledge article types that Amazon Kendra indexes.
     *
     * Amazon Kendra indexes standard knowledge articles and the standard fields of knowledge articles, or the custom fields of custom knowledge articles, but not both
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceknowledgearticleconfiguration.html
     */
    interface SalesforceKnowledgeArticleConfigurationProperty {
        /**
         * Provides configuration information for custom Salesforce knowledge articles.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceknowledgearticleconfiguration.html#cfn-kendra-datasource-salesforceknowledgearticleconfiguration-customknowledgearticletypeconfigurations
         */
        readonly customKnowledgeArticleTypeConfigurations?: Array<CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * Specifies the document states that should be included when Amazon Kendra indexes knowledge articles.
         *
         * You must specify at least one state.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceknowledgearticleconfiguration.html#cfn-kendra-datasource-salesforceknowledgearticleconfiguration-includedstates
         */
        readonly includedStates: string[];
        /**
         * Provides configuration information for standard Salesforce knowledge articles.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceknowledgearticleconfiguration.html#cfn-kendra-datasource-salesforceknowledgearticleconfiguration-standardknowledgearticletypeconfiguration
         */
        readonly standardKnowledgeArticleTypeConfiguration?: CfnDataSource.SalesforceStandardKnowledgeArticleTypeConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides configuration information for standard Salesforce knowledge articles.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration.html
     */
    interface SalesforceStandardKnowledgeArticleTypeConfigurationProperty {
        /**
         * The name of the field that contains the document data to index.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration-documentdatafieldname
         */
        readonly documentDataFieldName: string;
        /**
         * The name of the field that contains the document title.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * One or more objects that map fields in the knowledge article to Amazon Kendra index fields.
         *
         * The index field must exist before you can map a Salesforce field to it.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides configuration information for processing attachments to Salesforce standard objects.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectattachmentconfiguration.html
     */
    interface SalesforceStandardObjectAttachmentConfigurationProperty {
        /**
         * The name of the field used for the document title.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectattachmentconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectattachmentconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * One or more objects that map fields in attachments to Amazon Kendra index fields.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectattachmentconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectattachmentconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Specifies configuration information for indexing a single standard object.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfiguration.html
     */
    interface SalesforceStandardObjectConfigurationProperty {
        /**
         * The name of the field in the standard object table that contains the document contents.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectconfiguration-documentdatafieldname
         */
        readonly documentDataFieldName: string;
        /**
         * The name of the field in the standard object table that contains the document title.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * One or more objects that map fields in the standard object to Amazon Kendra index fields.
         *
         * The index field must exist before you can map a Salesforce field to it.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The name of the standard object.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectconfiguration-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides configuration information required to connect to a ServiceNow data source.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html
     */
    interface ServiceNowConfigurationProperty {
        /**
         * Determines the type of authentication used to connect to the ServiceNow instance.
         *
         * If you choose `HTTP_BASIC` , Amazon Kendra is authenticated using the user name and password provided in the AWS Secrets Manager secret in the `SecretArn` field. When you choose `OAUTH2` , Amazon Kendra is authenticated using the OAuth token and secret provided in the Secrets Manager secret, and the user name and password are used to determine which information Amazon Kendra has access to.
         *
         * When you use `OAUTH2` authentication, you must generate a token and a client secret using the ServiceNow console. For more information, see [Using a ServiceNow data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html) .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-authenticationtype
         */
        readonly authenticationType?: string;
        /**
         * The ServiceNow instance that the data source connects to.
         *
         * The host endpoint should look like the following: `{instance}.service-now.com.`
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-hosturl
         */
        readonly hostUrl: string;
        /**
         * Provides configuration information for crawling knowledge articles in the ServiceNow site.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-knowledgearticleconfiguration
         */
        readonly knowledgeArticleConfiguration?: CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty | cdk.IResolvable;
        /**
         * The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the user name and password required to connect to the ServiceNow instance.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-secretarn
         */
        readonly secretArn: string;
        /**
         * Provides configuration information for crawling service catalogs in the ServiceNow site.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-servicecatalogconfiguration
         */
        readonly serviceCatalogConfiguration?: CfnDataSource.ServiceNowServiceCatalogConfigurationProperty | cdk.IResolvable;
        /**
         * The identifier of the release that the ServiceNow host is running.
         *
         * If the host is not running the `LONDON` release, use `OTHERS` .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-servicenowbuildversion
         */
        readonly serviceNowBuildVersion: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides configuration information for crawling knowledge articles in the ServiceNow site.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html
     */
    interface ServiceNowKnowledgeArticleConfigurationProperty {
        /**
         * Indicates whether Amazon Kendra should index attachments to knowledge articles.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-crawlattachments
         */
        readonly crawlAttachments?: boolean | cdk.IResolvable;
        /**
         * The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra index.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-documentdatafieldname
         */
        readonly documentDataFieldName: string;
        /**
         * The name of the ServiceNow field that is mapped to the index document title field.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * List of regular expressions applied to knowledge articles.
         *
         * Items that don't match the inclusion pattern are not indexed. The regex is applied to the field specified in the `PatternTargetField`
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-excludeattachmentfilepatterns
         */
        readonly excludeAttachmentFilePatterns?: string[];
        /**
         * Mapping between ServiceNow fields and Amazon Kendra index fields.
         *
         * You must create the index field before you map the field.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A query that selects the knowledge articles to index.
         *
         * The query can return articles from multiple knowledge bases, and the knowledge bases can be public or private.
         *
         * The query string must be one generated by the ServiceNow console. For more information, see [Specifying documents to index with a query](https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html) .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-filterquery
         */
        readonly filterQuery?: string;
        /**
         * List of regular expressions applied to knowledge articles.
         *
         * Items that don't match the inclusion pattern are not indexed. The regex is applied to the field specified in the `PatternTargetField` .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-includeattachmentfilepatterns
         */
        readonly includeAttachmentFilePatterns?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides configuration information for crawling service catalog items in the ServiceNow site.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html
     */
    interface ServiceNowServiceCatalogConfigurationProperty {
        /**
         * Indicates whether Amazon Kendra should crawl attachments to the service catalog items.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-crawlattachments
         */
        readonly crawlAttachments?: boolean | cdk.IResolvable;
        /**
         * The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra index.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-documentdatafieldname
         */
        readonly documentDataFieldName: string;
        /**
         * The name of the ServiceNow field that is mapped to the index document title field.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * A list of regular expression patterns.
         *
         * Documents that match the patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a document matches both an exclusion pattern and an inclusion pattern, the document is not included in the index.
         *
         * The regex is applied to the file name of the attachment.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-excludeattachmentfilepatterns
         */
        readonly excludeAttachmentFilePatterns?: string[];
        /**
         * Mapping between ServiceNow fields and Amazon Kendra index fields.
         *
         * You must create the index field before you map the field.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A list of regular expression patterns.
         *
         * Documents that match the patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a document matches both an exclusion pattern and an inclusion pattern, the document is not included in the index.
         *
         * The regex is applied to the file name of the attachment.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-includeattachmentfilepatterns
         */
        readonly includeAttachmentFilePatterns?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides configuration information for connecting to a Microsoft SharePoint data source.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html
     */
    interface SharePointConfigurationProperty {
        /**
         * `TRUE` to include attachments to documents stored in your Microsoft SharePoint site in the index;
         *
         * otherwise, `FALSE` .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-crawlattachments
         */
        readonly crawlAttachments?: boolean | cdk.IResolvable;
        /**
         * A Boolean value that specifies whether local groups are disabled ( `True` ) or enabled ( `False` ).
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-disablelocalgroups
         */
        readonly disableLocalGroups?: boolean | cdk.IResolvable;
        /**
         * The Microsoft SharePoint attribute field that contains the title of the document.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * A list of regular expression patterns.
         *
         * Documents that match the patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a document matches both an exclusion pattern and an inclusion pattern, the document is not included in the index.
         *
         * The regex is applied to the display URL of the SharePoint document.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-exclusionpatterns
         */
        readonly exclusionPatterns?: string[];
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map Microsoft SharePoint attributes to custom fields in the Amazon Kendra index.
         *
         * You must first create the index fields using the [UpdateIndex](https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateIndex.html) operation before you map SharePoint attributes. For more information, see [Mapping Data Source Fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html) .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A list of regular expression patterns.
         *
         * Documents that match the patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a document matches both an inclusion pattern and an exclusion pattern, the document is not included in the index.
         *
         * The regex is applied to the display URL of the SharePoint document.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-inclusionpatterns
         */
        readonly inclusionPatterns?: string[];
        /**
         * The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager .
         *
         * The credentials should be a user/password pair. If you use SharePoint Server, you also need to provide the sever domain name as part of the credentials. For more information, see [Using a Microsoft SharePoint Data Source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html) . For more information about AWS Secrets Manager see [What Is AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html) in the *AWS Secrets Manager* user guide.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-secretarn
         */
        readonly secretArn: string;
        /**
         * The version of Microsoft SharePoint that you are using as a data source.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-sharepointversion
         */
        readonly sharePointVersion: string;
        /**
         * Information required to find a specific file in an Amazon S3 bucket.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-sslcertificates3path
         */
        readonly sslCertificateS3Path?: CfnDataSource.S3PathProperty | cdk.IResolvable;
        /**
         * The URLs of the Microsoft SharePoint site that contains the documents that should be indexed.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-urls
         */
        readonly urls: string[];
        /**
         * Set to `TRUE` to use the Microsoft SharePoint change log to determine the documents that need to be updated in the index.
         *
         * Depending on the size of the SharePoint change log, it may take longer for Amazon Kendra to use the change log than it takes it to determine the changed documents using the Amazon Kendra document crawler.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-usechangelog
         */
        readonly useChangeLog?: boolean | cdk.IResolvable;
        /**
         * Provides information for connecting to an Amazon VPC.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-vpcconfiguration
         */
        readonly vpcConfiguration?: CfnDataSource.DataSourceVpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides information that configures Amazon Kendra to use a SQL database.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sqlconfiguration.html
     */
    interface SqlConfigurationProperty {
        /**
         * Determines whether Amazon Kendra encloses SQL identifiers for tables and column names in double quotes (") when making a database query.
         *
         * You can set the value to `DOUBLE_QUOTES` or `NONE` .
         *
         * By default, Amazon Kendra passes SQL identifiers the way that they are entered into the data source configuration. It does not change the case of identifiers or enclose them in quotes.
         *
         * PostgreSQL internally converts uppercase characters to lower case characters in identifiers unless they are quoted. Choosing this option encloses identifiers in quotes so that PostgreSQL does not convert the character's case.
         *
         * For MySQL databases, you must enable the ansi_quotes option when you set this field to `DOUBLE_QUOTES` .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sqlconfiguration.html#cfn-kendra-datasource-sqlconfiguration-queryidentifiersenclosingoption
         */
        readonly queryIdentifiersEnclosingOption?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides the configuration information to connect to websites that require user authentication.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerauthenticationconfiguration.html
     */
    interface WebCrawlerAuthenticationConfigurationProperty {
        /**
         * The list of configuration information that's required to connect to and crawl a website host using basic authentication credentials.
         *
         * The list includes the name and port number of the website host.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerauthenticationconfiguration.html#cfn-kendra-datasource-webcrawlerauthenticationconfiguration-basicauthentication
         */
        readonly basicAuthentication?: Array<CfnDataSource.WebCrawlerBasicAuthenticationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides the configuration information to connect to websites that require basic user authentication.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerbasicauthentication.html
     */
    interface WebCrawlerBasicAuthenticationProperty {
        /**
         * Your secret ARN, which you can create in [AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html).
         *
         * You use a secret if basic authentication credentials are required to connect to a website. The secret stores your credentials of user name and password.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerbasicauthentication.html#cfn-kendra-datasource-webcrawlerbasicauthentication-credentials
         */
        readonly credentials: string;
        /**
         * The name of the website host you want to connect to using authentication credentials.
         *
         * For example, the host name of https://a.example.com/page1.html is "a.example.com".
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerbasicauthentication.html#cfn-kendra-datasource-webcrawlerbasicauthentication-host
         */
        readonly host: string;
        /**
         * The port number of the website host you want to connect to using authentication credentials.
         *
         * For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerbasicauthentication.html#cfn-kendra-datasource-webcrawlerbasicauthentication-port
         */
        readonly port: number;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides the configuration information required for Amazon Kendra Web Crawler.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html
     */
    interface WebCrawlerConfigurationProperty {
        /**
         * Provides configuration information required to connect to websites using authentication.
         *
         * You can connect to websites using basic authentication of user name and password.
         *
         * You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS. You use a secret in [AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html) to store your authentication credentials.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-authenticationconfiguration
         */
        readonly authenticationConfiguration?: CfnDataSource.WebCrawlerAuthenticationConfigurationProperty | cdk.IResolvable;
        /**
         * Specifies the number of levels in a website that you want to crawl.
         *
         * The first level begins from the website seed or starting point URL. For example, if a website has 3 levels – index level (i.e. seed in this example), sections level, and subsections level – and you are only interested in crawling information up to the sections level (i.e. levels 0-1), you can set your depth to 1.
         *
         * The default crawl depth is set to 2.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-crawldepth
         */
        readonly crawlDepth?: number;
        /**
         * The maximum size (in MB) of a webpage or attachment to crawl.
         *
         * Files larger than this size (in MB) are skipped/not crawled.
         *
         * The default maximum size of a webpage or attachment is set to 50 MB.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-maxcontentsizeperpageinmegabytes
         */
        readonly maxContentSizePerPageInMegaBytes?: number;
        /**
         * The maximum number of URLs on a webpage to include when crawling a website. This number is per webpage.
         *
         * As a website’s webpages are crawled, any URLs the webpages link to are also crawled. URLs on a webpage are crawled in order of appearance.
         *
         * The default maximum links per page is 100.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-maxlinksperpage
         */
        readonly maxLinksPerPage?: number;
        /**
         * The maximum number of URLs crawled per website host per minute.
         *
         * A minimum of one URL is required.
         *
         * The default maximum number of URLs crawled per website host per minute is 300.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-maxurlsperminutecrawlrate
         */
        readonly maxUrlsPerMinuteCrawlRate?: number;
        /**
         * Provides configuration information required to connect to your internal websites via a web proxy.
         *
         * You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS.
         *
         * Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in [AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html) .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-proxyconfiguration
         */
        readonly proxyConfiguration?: CfnDataSource.ProxyConfigurationProperty | cdk.IResolvable;
        /**
         * The regular expression pattern to exclude certain URLs to crawl.
         *
         * If there is a regular expression pattern to include certain URLs that conflicts with the exclude pattern, the exclude pattern takes precedence.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-urlexclusionpatterns
         */
        readonly urlExclusionPatterns?: string[];
        /**
         * The regular expression pattern to include certain URLs to crawl.
         *
         * If there is a regular expression pattern to exclude certain URLs that conflicts with the include pattern, the exclude pattern takes precedence.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-urlinclusionpatterns
         */
        readonly urlInclusionPatterns?: string[];
        /**
         * Specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl.
         *
         * You can include website subdomains. You can list up to 100 seed URLs and up to three sitemap URLs.
         *
         * You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling.
         *
         * *When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://docs.aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own webpages, or webpages that you have authorization to index.*
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-urls
         */
        readonly urls: CfnDataSource.WebCrawlerUrlsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides the configuration information of the seed or starting point URLs to crawl.
     *
     * *When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://docs.aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use the Amazon Kendra web crawler to index your own webpages, or webpages that you have authorization to index.*
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerseedurlconfiguration.html
     */
    interface WebCrawlerSeedUrlConfigurationProperty {
        /**
         * The list of seed or starting point URLs of the websites you want to crawl.
         *
         * The list can include a maximum of 100 seed URLs.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerseedurlconfiguration.html#cfn-kendra-datasource-webcrawlerseedurlconfiguration-seedurls
         */
        readonly seedUrls: string[];
        /**
         * You can choose one of the following modes:.
         *
         * - `HOST_ONLY` – crawl only the website host names. For example, if the seed URL is "abc.example.com", then only URLs with host name "abc.example.com" are crawled.
         * - `SUBDOMAINS` – crawl the website host names with subdomains. For example, if the seed URL is "abc.example.com", then "a.abc.example.com" and "b.abc.example.com" are also crawled.
         * - `EVERYTHING` – crawl the website host names with subdomains and other domains that the webpages link to.
         *
         * The default mode is set to `HOST_ONLY` .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerseedurlconfiguration.html#cfn-kendra-datasource-webcrawlerseedurlconfiguration-webcrawlermode
         */
        readonly webCrawlerMode?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides the configuration information of the sitemap URLs to crawl.
     *
     * *When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://docs.aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use the Amazon Kendra web crawler to index your own webpages, or webpages that you have authorization to index.*
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlersitemapsconfiguration.html
     */
    interface WebCrawlerSiteMapsConfigurationProperty {
        /**
         * The list of sitemap URLs of the websites you want to crawl.
         *
         * The list can include a maximum of three sitemap URLs.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlersitemapsconfiguration.html#cfn-kendra-datasource-webcrawlersitemapsconfiguration-sitemaps
         */
        readonly siteMaps: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl.
     *
     * You can include website subdomains. You can list up to 100 seed URLs and up to three sitemap URLs.
     *
     * You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling.
     *
     * *When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://docs.aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use the Amazon Kendra web crawler to index your own webpages, or webpages that you have authorization to index.*
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerurls.html
     */
    interface WebCrawlerUrlsProperty {
        /**
         * Provides the configuration of the seed or starting point URLs of the websites you want to crawl.
         *
         * You can choose to crawl only the website host names, or the website host names with subdomains, or the website host names with subdomains and other domains that the webpages link to.
         *
         * You can list up to 100 seed URLs.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerurls.html#cfn-kendra-datasource-webcrawlerurls-seedurlconfiguration
         */
        readonly seedUrlConfiguration?: CfnDataSource.WebCrawlerSeedUrlConfigurationProperty | cdk.IResolvable;
        /**
         * Provides the configuration of the sitemap URLs of the websites you want to crawl.
         *
         * Only URLs belonging to the same website host names are crawled. You can list up to three sitemap URLs.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerurls.html#cfn-kendra-datasource-webcrawlerurls-sitemapsconfiguration
         */
        readonly siteMapsConfiguration?: CfnDataSource.WebCrawlerSiteMapsConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * Specifies a data source that you use to with an Amazon Kendra index.
 *
 * You specify a name, connector type and description for your data source.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * Provides the configuration information to connect to Amazon WorkDocs as your data source.
     *
     * Amazon WorkDocs connector is available in Oregon, North Virginia, Sydney, Singapore and Ireland regions.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-workdocsconfiguration.html
     */
    interface WorkDocsConfigurationProperty {
        /**
         * `TRUE` to include comments on documents in your index.
         *
         * Including comments in your index means each comment is a document that can be searched on.
         *
         * The default is set to `FALSE` .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-workdocsconfiguration.html#cfn-kendra-datasource-workdocsconfiguration-crawlcomments
         */
        readonly crawlComments?: boolean | cdk.IResolvable;
        /**
         * A list of regular expression patterns to exclude certain files in your Amazon WorkDocs site repository.
         *
         * Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn’t included in the index.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-workdocsconfiguration.html#cfn-kendra-datasource-workdocsconfiguration-exclusionpatterns
         */
        readonly exclusionPatterns?: string[];
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map Amazon WorkDocs field names to custom index field names in Amazon Kendra.
         *
         * You must first create the custom index fields using the `UpdateIndex` operation before you map to Amazon WorkDocs fields. For more information, see [Mapping Data Source Fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html) . The Amazon WorkDocs data source field names need to exist in your Amazon WorkDocs custom metadata.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-workdocsconfiguration.html#cfn-kendra-datasource-workdocsconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A list of regular expression patterns to include certain files in your Amazon WorkDocs site repository.
         *
         * Files that match the patterns are included in the index. Files that don't match the patterns are excluded from the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn’t included in the index.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-workdocsconfiguration.html#cfn-kendra-datasource-workdocsconfiguration-inclusionpatterns
         */
        readonly inclusionPatterns?: string[];
        /**
         * The identifier of the directory corresponding to your Amazon WorkDocs site repository.
         *
         * You can find the organization ID in the [AWS Directory Service](https://docs.aws.amazon.com/directoryservicev2/) by going to *Active Directory* , then *Directories* . Your Amazon WorkDocs site directory has an ID, which is the organization ID. You can also set up a new Amazon WorkDocs directory in the AWS Directory Service console and enable a Amazon WorkDocs site for the directory in the Amazon WorkDocs console.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-workdocsconfiguration.html#cfn-kendra-datasource-workdocsconfiguration-organizationid
         */
        readonly organizationId: string;
        /**
         * `TRUE` to use the change logs to update documents in your index instead of scanning all documents.
         *
         * If you are syncing your Amazon WorkDocs data source with your index for the first time, all documents are scanned. After your first sync, you can use the change logs to update your documents in your index for future syncs.
         *
         * The default is set to `FALSE` .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-workdocsconfiguration.html#cfn-kendra-datasource-workdocsconfiguration-usechangelog
         */
        readonly useChangeLog?: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `CfnFaq`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html
 */
export interface CfnFaqProps {
    /**
     * The identifier of the index that contains the FAQ.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-indexid
     */
    readonly indexId: string;
    /**
     * The name that you assigned the FAQ when you created or updated the FAQ.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-name
     */
    readonly name: string;
    /**
     * The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQ.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-rolearn
     */
    readonly roleArn: string;
    /**
     * The Amazon Simple Storage Service (Amazon S3) location of the FAQ input data.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-s3path
     */
    readonly s3Path: CfnFaq.S3PathProperty | cdk.IResolvable;
    /**
     * A description of the FAQ.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-description
     */
    readonly description?: string;
    /**
     * The format of the input file.
     *
     * You can choose between a basic CSV format, a CSV format that includes customs attributes in a header, and a JSON format that includes custom attributes.
     *
     * The format must match the format of the file stored in the S3 bucket identified in the S3Path parameter.
     *
     * Valid values are:
     *
     * - `CSV`
     * - `CSV_WITH_HEADER`
     * - `JSON`
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-fileformat
     */
    readonly fileFormat?: string;
    /**
     * An array of key-value pairs to apply to this resource.
     *
     * For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Kendra::Faq`.
 *
 * Specifies an new set of frequently asked question (FAQ) questions and answers.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Faq
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html
 */
export declare class CfnFaq extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Kendra::Faq";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFaq;
    /**
     * `arn:aws:kendra:us-west-2:111122223333:index/335c3741-41df-46a6-b5d3-61f85b787884/faq/f61995a6-cd5c-4e99-9cfc-58816d8bfaa7`.
     *
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * The identifier for the FAQ. For example:.
     *
     * `f61995a6-cd5c-4e99-9cfc-58816d8bfaa7`
     *
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * The identifier of the index that contains the FAQ.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-indexid
     */
    indexId: string;
    /**
     * The name that you assigned the FAQ when you created or updated the FAQ.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-name
     */
    name: string;
    /**
     * The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQ.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-rolearn
     */
    roleArn: string;
    /**
     * The Amazon Simple Storage Service (Amazon S3) location of the FAQ input data.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-s3path
     */
    s3Path: CfnFaq.S3PathProperty | cdk.IResolvable;
    /**
     * A description of the FAQ.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-description
     */
    description: string | undefined;
    /**
     * The format of the input file.
     *
     * You can choose between a basic CSV format, a CSV format that includes customs attributes in a header, and a JSON format that includes custom attributes.
     *
     * The format must match the format of the file stored in the S3 bucket identified in the S3Path parameter.
     *
     * Valid values are:
     *
     * - `CSV`
     * - `CSV_WITH_HEADER`
     * - `JSON`
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-fileformat
     */
    fileFormat: string | undefined;
    /**
     * An array of key-value pairs to apply to this resource.
     *
     * For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Kendra::Faq`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFaqProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Kendra::Faq`.
 *
 * Specifies an new set of frequently asked question (FAQ) questions and answers.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Faq
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html
 */
export declare namespace CfnFaq {
    /**
     * Information required to find a specific file in an Amazon S3 bucket.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-faq-s3path.html
     */
    interface S3PathProperty {
        /**
         * The name of the S3 bucket that contains the file.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-faq-s3path.html#cfn-kendra-faq-s3path-bucket
         */
        readonly bucket: string;
        /**
         * The name of the file.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-faq-s3path.html#cfn-kendra-faq-s3path-key
         */
        readonly key: string;
    }
}
/**
 * Properties for defining a `CfnIndex`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export interface CfnIndexProps {
    /**
     * Indicates whether the index is a enterprise edition index or a developer edition index.
     *
     * Valid values are `DEVELOPER_EDITION` and `ENTERPRISE_EDITION` .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-edition
     */
    readonly edition: string;
    /**
     * The name of the index.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-name
     */
    readonly name: string;
    /**
     * An IAM role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics.
     *
     * This is also the role used when you use the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html) operation to index documents from an Amazon S3 bucket.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-rolearn
     */
    readonly roleArn: string;
    /**
     * Specifies capacity units configured for your index.
     *
     * You can add and remove capacity units to tune an index to your requirements. You can set capacity units only for Enterprise edition indexes.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-capacityunits
     */
    readonly capacityUnits?: CfnIndex.CapacityUnitsConfigurationProperty | cdk.IResolvable;
    /**
     * A description of the index.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-description
     */
    readonly description?: string;
    /**
     * Specifies the properties of an index field.
     *
     * You can add either a custom or a built-in field. You can add and remove built-in fields at any time. When a built-in field is removed it's configuration reverts to the default for the field. Custom fields can't be removed from an index after they are added.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-documentmetadataconfigurations
     */
    readonly documentMetadataConfigurations?: Array<CfnIndex.DocumentMetadataConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * The identifier of the AWS KMS customer managed key (CMK) to use to encrypt data indexed by Amazon Kendra.
     *
     * Amazon Kendra doesn't support asymmetric CMKs.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-serversideencryptionconfiguration
     */
    readonly serverSideEncryptionConfiguration?: CfnIndex.ServerSideEncryptionConfigurationProperty | cdk.IResolvable;
    /**
     * An array of key-value pairs to apply to this resource.
     *
     * For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * The user context policy.
     *
     * ATTRIBUTE_FILTER
     *
     * - All indexed content is searchable and displayable for all users. If there is an access control list, it is ignored. You can filter on user and group attributes.
     *
     * USER_TOKEN
     *
     * - Enables SSO and token-based user access control. All documents with no access control and all documents accessible to the user will be searchable and displayable.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usercontextpolicy
     */
    readonly userContextPolicy?: string;
    /**
     * Defines the type of user token used for the index.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usertokenconfigurations
     */
    readonly userTokenConfigurations?: Array<CfnIndex.UserTokenConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * Specifies a new Amazon Kendra index. And index is a collection of documents and associated metadata that you want to search for relevant documents.
 *
 * Once the index is active you can add documents to your index using the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html) operation or using one of the supported data sources.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare class CfnIndex extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Kendra::Index";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnIndex;
    /**
     * The Amazon Resource Name (ARN) of the index.
     *
     * For example: `arn:aws:kendra:us-west-2:111122223333:index/0123456789abcdef` .
     *
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * The identifier for the index.
     *
     * For example: `f4aeaa10-8056-4b2c-a343-522ca0f41234` .
     *
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * Indicates whether the index is a enterprise edition index or a developer edition index.
     *
     * Valid values are `DEVELOPER_EDITION` and `ENTERPRISE_EDITION` .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-edition
     */
    edition: string;
    /**
     * The name of the index.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-name
     */
    name: string;
    /**
     * An IAM role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics.
     *
     * This is also the role used when you use the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html) operation to index documents from an Amazon S3 bucket.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-rolearn
     */
    roleArn: string;
    /**
     * Specifies capacity units configured for your index.
     *
     * You can add and remove capacity units to tune an index to your requirements. You can set capacity units only for Enterprise edition indexes.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-capacityunits
     */
    capacityUnits: CfnIndex.CapacityUnitsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * A description of the index.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-description
     */
    description: string | undefined;
    /**
     * Specifies the properties of an index field.
     *
     * You can add either a custom or a built-in field. You can add and remove built-in fields at any time. When a built-in field is removed it's configuration reverts to the default for the field. Custom fields can't be removed from an index after they are added.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-documentmetadataconfigurations
     */
    documentMetadataConfigurations: Array<CfnIndex.DocumentMetadataConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * The identifier of the AWS KMS customer managed key (CMK) to use to encrypt data indexed by Amazon Kendra.
     *
     * Amazon Kendra doesn't support asymmetric CMKs.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-serversideencryptionconfiguration
     */
    serverSideEncryptionConfiguration: CfnIndex.ServerSideEncryptionConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * An array of key-value pairs to apply to this resource.
     *
     * For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * The user context policy.
     *
     * ATTRIBUTE_FILTER
     *
     * - All indexed content is searchable and displayable for all users. If there is an access control list, it is ignored. You can filter on user and group attributes.
     *
     * USER_TOKEN
     *
     * - Enables SSO and token-based user access control. All documents with no access control and all documents accessible to the user will be searchable and displayable.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usercontextpolicy
     */
    userContextPolicy: string | undefined;
    /**
     * Defines the type of user token used for the index.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usertokenconfigurations
     */
    userTokenConfigurations: Array<CfnIndex.UserTokenConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Kendra::Index`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnIndexProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * Specifies a new Amazon Kendra index. And index is a collection of documents and associated metadata that you want to search for relevant documents.
 *
 * Once the index is active you can add documents to your index using the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html) operation or using one of the supported data sources.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * Specifies capacity units configured for your enterprise edition index.
     *
     * You can add and remove capacity units to tune an index to your requirements.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-capacityunitsconfiguration.html
     */
    interface CapacityUnitsConfigurationProperty {
        /**
         * The amount of extra query capacity for an index and [GetQuerySuggestions](https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html) capacity.
         *
         * A single extra capacity unit for an index provides 0.1 queries per second or approximately 8,000 queries per day.
         *
         * `GetQuerySuggestions` capacity is five times the provisioned query capacity for an index, or the base capacity of 2.5 calls per second, whichever is higher. For example, the base capacity for an index is 0.1 queries per second, and `GetQuerySuggestions` capacity has a base of 2.5 calls per second. If you add another 0.1 queries per second to total 0.2 queries per second for an index, the `GetQuerySuggestions` capacity is 2.5 calls per second (higher than five times 0.2 queries per second).
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-capacityunitsconfiguration.html#cfn-kendra-index-capacityunitsconfiguration-querycapacityunits
         */
        readonly queryCapacityUnits: number;
        /**
         * The amount of extra storage capacity for an index.
         *
         * A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-capacityunitsconfiguration.html#cfn-kendra-index-capacityunitsconfiguration-storagecapacityunits
         */
        readonly storageCapacityUnits: number;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * Specifies a new Amazon Kendra index. And index is a collection of documents and associated metadata that you want to search for relevant documents.
 *
 * Once the index is active you can add documents to your index using the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html) operation or using one of the supported data sources.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * Specifies the properties of a custom index field.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html
     */
    interface DocumentMetadataConfigurationProperty {
        /**
         * The name of the index field.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-name
         */
        readonly name: string;
        /**
         * Provides manual tuning parameters to determine how the field affects the search results.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-relevance
         */
        readonly relevance?: CfnIndex.RelevanceProperty | cdk.IResolvable;
        /**
         * Provides information about how the field is used during a search.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-search
         */
        readonly search?: CfnIndex.SearchProperty | cdk.IResolvable;
        /**
         * The data type of the index field.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * Specifies a new Amazon Kendra index. And index is a collection of documents and associated metadata that you want to search for relevant documents.
 *
 * Once the index is active you can add documents to your index using the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html) operation or using one of the supported data sources.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * Configuration information for the JSON token type.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jsontokentypeconfiguration.html
     */
    interface JsonTokenTypeConfigurationProperty {
        /**
         * The group attribute field.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jsontokentypeconfiguration.html#cfn-kendra-index-jsontokentypeconfiguration-groupattributefield
         */
        readonly groupAttributeField: string;
        /**
         * The user name attribute field.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jsontokentypeconfiguration.html#cfn-kendra-index-jsontokentypeconfiguration-usernameattributefield
         */
        readonly userNameAttributeField: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * Specifies a new Amazon Kendra index. And index is a collection of documents and associated metadata that you want to search for relevant documents.
 *
 * Once the index is active you can add documents to your index using the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html) operation or using one of the supported data sources.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * Configuration information for the JWT token type.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html
     */
    interface JwtTokenTypeConfigurationProperty {
        /**
         * The regular expression that identifies the claim.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-claimregex
         */
        readonly claimRegex?: string;
        /**
         * The group attribute field.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-groupattributefield
         */
        readonly groupAttributeField?: string;
        /**
         * The issuer of the token.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-issuer
         */
        readonly issuer?: string;
        /**
         * The location of the key.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-keylocation
         */
        readonly keyLocation: string;
        /**
         * The Amazon Resource Name (arn) of the secret.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-secretmanagerarn
         */
        readonly secretManagerArn?: string;
        /**
         * The signing key URL.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-url
         */
        readonly url?: string;
        /**
         * The user name attribute field.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-usernameattributefield
         */
        readonly userNameAttributeField?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * Specifies a new Amazon Kendra index. And index is a collection of documents and associated metadata that you want to search for relevant documents.
 *
 * Once the index is active you can add documents to your index using the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html) operation or using one of the supported data sources.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * Provides information for manually tuning the relevance of a field in a search.
     *
     * When a query includes terms that match the field, the results are given a boost in the response based on these tuning parameters.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html
     */
    interface RelevanceProperty {
        /**
         * Specifies the time period that the boost applies to.
         *
         * For example, to make the boost apply to documents with the field value within the last month, you would use "2628000s". Once the field value is beyond the specified range, the effect of the boost drops off. The higher the importance, the faster the effect drops off. If you don't specify a value, the default is 3 months. The value of the field is a numeric string followed by the character "s", for example "86400s" for one day, or "604800s" for one week.
         *
         * Only applies to `DATE` fields.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-duration
         */
        readonly duration?: string;
        /**
         * Indicates that this field determines how "fresh" a document is.
         *
         * For example, if document 1 was created on November 5, and document 2 was created on October 31, document 1 is "fresher" than document 2. You can only set the `Freshness` field on one `DATE` type field. Only applies to `DATE` fields.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-freshness
         */
        readonly freshness?: boolean | cdk.IResolvable;
        /**
         * The relative importance of the field in the search.
         *
         * Larger numbers provide more of a boost than smaller numbers.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-importance
         */
        readonly importance?: number;
        /**
         * Determines how values should be interpreted.
         *
         * When the `RankOrder` field is `ASCENDING` , higher numbers are better. For example, a document with a rating score of 10 is higher ranking than a document with a rating score of 1.
         *
         * When the `RankOrder` field is `DESCENDING` , lower numbers are better. For example, in a task tracking application, a priority 1 task is more important than a priority 5 task.
         *
         * Only applies to `LONG` and `DOUBLE` fields.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-rankorder
         */
        readonly rankOrder?: string;
        /**
         * An array of key-value pairs that contains an array of values that should be given a different boost when they appear in the search result list.
         *
         * For example, if you are boosting query terms that match the department field in the result, query terms that match the department field are boosted in the result. You can add entries from the department field to boost documents with those values higher.
         *
         * For example, you can add entries to the map with names of departments. If you add "HR", 5 and "Legal",3 those departments are given special attention when they appear in the metadata of a document.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-valueimportanceitems
         */
        readonly valueImportanceItems?: Array<CfnIndex.ValueImportanceItemProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * Specifies a new Amazon Kendra index. And index is a collection of documents and associated metadata that you want to search for relevant documents.
 *
 * Once the index is active you can add documents to your index using the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html) operation or using one of the supported data sources.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * Provides information about how a custom index field is used during a search.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html
     */
    interface SearchProperty {
        /**
         * Determines whether the field is returned in the query response.
         *
         * The default is `true` .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-displayable
         */
        readonly displayable?: boolean | cdk.IResolvable;
        /**
         * Indicates that the field can be used to create search facets, a count of results for each value in the field.
         *
         * The default is `false` .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-facetable
         */
        readonly facetable?: boolean | cdk.IResolvable;
        /**
         * Determines whether the field is used in the search.
         *
         * If the `Searchable` field is `true` , you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is `true` for string fields and `false` for number and date fields.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-searchable
         */
        readonly searchable?: boolean | cdk.IResolvable;
        /**
         * Indicates that the field can be used to sort the search results.
         *
         * The default is `false` .
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-sortable
         */
        readonly sortable?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * Specifies a new Amazon Kendra index. And index is a collection of documents and associated metadata that you want to search for relevant documents.
 *
 * Once the index is active you can add documents to your index using the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html) operation or using one of the supported data sources.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt data indexed by Amazon Kendra.
     *
     * We suggest that you use a CMK from your account to help secure your index. Amazon Kendra doesn't support asymmetric CMKs.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-serversideencryptionconfiguration.html
     */
    interface ServerSideEncryptionConfigurationProperty {
        /**
         * The identifier of the AWS KMS customer master key (CMK).
         *
         * Amazon Kendra doesn't support asymmetric CMKs.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-serversideencryptionconfiguration.html#cfn-kendra-index-serversideencryptionconfiguration-kmskeyid
         */
        readonly kmsKeyId?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * Specifies a new Amazon Kendra index. And index is a collection of documents and associated metadata that you want to search for relevant documents.
 *
 * Once the index is active you can add documents to your index using the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html) operation or using one of the supported data sources.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * Provides configuration information for a token configuration.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-usertokenconfiguration.html
     */
    interface UserTokenConfigurationProperty {
        /**
         * Information about the JSON token type configuration.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-usertokenconfiguration.html#cfn-kendra-index-usertokenconfiguration-jsontokentypeconfiguration
         */
        readonly jsonTokenTypeConfiguration?: CfnIndex.JsonTokenTypeConfigurationProperty | cdk.IResolvable;
        /**
         * Information about the JWT token type configuration.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-usertokenconfiguration.html#cfn-kendra-index-usertokenconfiguration-jwttokentypeconfiguration
         */
        readonly jwtTokenTypeConfiguration?: CfnIndex.JwtTokenTypeConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * Specifies a new Amazon Kendra index. And index is a collection of documents and associated metadata that you want to search for relevant documents.
 *
 * Once the index is active you can add documents to your index using the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html) operation or using one of the supported data sources.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * Specifies a key-value pair that determines the search boost value that a document receives when the key is part of the metadata of a document.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitem.html
     */
    interface ValueImportanceItemProperty {
        /**
         * The document metadata value that receives the search boost.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitem.html#cfn-kendra-index-valueimportanceitem-key
         */
        readonly key?: string;
        /**
         * The boost value that a document receives when the key is part of the metadata of a document.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitem.html#cfn-kendra-index-valueimportanceitem-value
         */
        readonly value?: number;
    }
}
