# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.insights.v1.call import CallList


class V1(Version):

    def __init__(self, domain):
        """
        Initialize the V1 version of Insights

        :returns: V1 version of Insights
        :rtype: twilio.rest.insights.v1.V1.V1
        """
        super(V1, self).__init__(domain)
        self.version = 'v1'
        self._calls = None

    @property
    def calls(self):
        """
        :rtype: twilio.rest.insights.v1.call.CallList
        """
        if self._calls is None:
            self._calls = CallList(self)
        return self._calls

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Insights.V1>'
