# coding: utf-8

"""
    Kubernetes

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: v1.10.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from aiokubernetes.api_client import ApiClient


class CustomObjectsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_cluster_custom_object(self, group, version, plural, body, **kwargs):  # noqa: E501
        """create_cluster_custom_object  # noqa: E501

        Creates a cluster scoped Custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_cluster_custom_object(group, version, plural, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param object body: The JSON schema of the Resource to create. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_cluster_custom_object_with_http_info(group, version, plural, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cluster_custom_object_with_http_info(group, version, plural, body, **kwargs)  # noqa: E501
            return data

    def create_cluster_custom_object_with_http_info(self, group, version, plural, body, **kwargs):  # noqa: E501
        """create_cluster_custom_object  # noqa: E501

        Creates a cluster scoped Custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_cluster_custom_object_with_http_info(group, version, plural, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param object body: The JSON schema of the Resource to create. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'body', 'pretty']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cluster_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params or
                params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `create_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `create_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'plural' is set
        if ('plural' not in params or
                params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `create_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_cluster_custom_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501
        if 'plural' in params:
            path_params['plural'] = params['plural']  # noqa: E501

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/{group}/{version}/{plural}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_namespaced_custom_object(self, group, version, namespace, plural, body, **kwargs):  # noqa: E501
        """create_namespaced_custom_object  # noqa: E501

        Creates a namespace scoped Custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_namespaced_custom_object(group, version, namespace, plural, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param object body: The JSON schema of the Resource to create. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_namespaced_custom_object_with_http_info(group, version, namespace, plural, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_namespaced_custom_object_with_http_info(group, version, namespace, plural, body, **kwargs)  # noqa: E501
            return data

    def create_namespaced_custom_object_with_http_info(self, group, version, namespace, plural, body, **kwargs):  # noqa: E501
        """create_namespaced_custom_object  # noqa: E501

        Creates a namespace scoped Custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_namespaced_custom_object_with_http_info(group, version, namespace, plural, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param object body: The JSON schema of the Resource to create. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'body', 'pretty']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params or
                params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `create_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `create_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'plural' is set
        if ('plural' not in params or
                params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `create_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_custom_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'plural' in params:
            path_params['plural'] = params['plural']  # noqa: E501

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/{group}/{version}/namespaces/{namespace}/{plural}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_cluster_custom_object(self, group, version, plural, name, body, **kwargs):  # noqa: E501
        """delete_cluster_custom_object  # noqa: E501

        Deletes the specified cluster scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_cluster_custom_object(group, version, plural, name, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param V1DeleteOptions body: (required)
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_cluster_custom_object_with_http_info(group, version, plural, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_cluster_custom_object_with_http_info(group, version, plural, name, body, **kwargs)  # noqa: E501
            return data

    def delete_cluster_custom_object_with_http_info(self, group, version, plural, name, body, **kwargs):  # noqa: E501
        """delete_cluster_custom_object  # noqa: E501

        Deletes the specified cluster scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_cluster_custom_object_with_http_info(group, version, plural, name, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param V1DeleteOptions body: (required)
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'name', 'body', 'grace_period_seconds', 'orphan_dependents', 'propagation_policy']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cluster_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params or
                params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `delete_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `delete_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'plural' is set
        if ('plural' not in params or
                params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `delete_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_cluster_custom_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501
        if 'plural' in params:
            path_params['plural'] = params['plural']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'grace_period_seconds' in params:
            query_params.append(('gracePeriodSeconds', params['grace_period_seconds']))  # noqa: E501
        if 'orphan_dependents' in params:
            query_params.append(('orphanDependents', params['orphan_dependents']))  # noqa: E501
        if 'propagation_policy' in params:
            query_params.append(('propagationPolicy', params['propagation_policy']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/{group}/{version}/{plural}/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_namespaced_custom_object(self, group, version, namespace, plural, name, body, **kwargs):  # noqa: E501
        """delete_namespaced_custom_object  # noqa: E501

        Deletes the specified namespace scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_namespaced_custom_object(group, version, namespace, plural, name, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param V1DeleteOptions body: (required)
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, **kwargs)  # noqa: E501
            return data

    def delete_namespaced_custom_object_with_http_info(self, group, version, namespace, plural, name, body, **kwargs):  # noqa: E501
        """delete_namespaced_custom_object  # noqa: E501

        Deletes the specified namespace scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param V1DeleteOptions body: (required)
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'name', 'body', 'grace_period_seconds', 'orphan_dependents', 'propagation_policy']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params or
                params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `delete_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `delete_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'plural' is set
        if ('plural' not in params or
                params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `delete_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_custom_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'plural' in params:
            path_params['plural'] = params['plural']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'grace_period_seconds' in params:
            query_params.append(('gracePeriodSeconds', params['grace_period_seconds']))  # noqa: E501
        if 'orphan_dependents' in params:
            query_params.append(('orphanDependents', params['orphan_dependents']))  # noqa: E501
        if 'propagation_policy' in params:
            query_params.append(('propagationPolicy', params['propagation_policy']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_custom_object(self, group, version, plural, name, **kwargs):  # noqa: E501
        """get_cluster_custom_object  # noqa: E501

        Returns a cluster scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_custom_object(group, version, plural, name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cluster_custom_object_with_http_info(group, version, plural, name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_custom_object_with_http_info(group, version, plural, name, **kwargs)  # noqa: E501
            return data

    def get_cluster_custom_object_with_http_info(self, group, version, plural, name, **kwargs):  # noqa: E501
        """get_cluster_custom_object  # noqa: E501

        Returns a cluster scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cluster_custom_object_with_http_info(group, version, plural, name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'name']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params or
                params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `get_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'plural' is set
        if ('plural' not in params or
                params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `get_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_cluster_custom_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501
        if 'plural' in params:
            path_params['plural'] = params['plural']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/{group}/{version}/{plural}/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_namespaced_custom_object(self, group, version, namespace, plural, name, **kwargs):  # noqa: E501
        """get_namespaced_custom_object  # noqa: E501

        Returns a namespace scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_namespaced_custom_object(group, version, namespace, plural, name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, **kwargs)  # noqa: E501
            return data

    def get_namespaced_custom_object_with_http_info(self, group, version, namespace, plural, name, **kwargs):  # noqa: E501
        """get_namespaced_custom_object  # noqa: E501

        Returns a namespace scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'name']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_namespaced_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params or
                params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `get_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `get_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'plural' is set
        if ('plural' not in params or
                params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `get_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_namespaced_custom_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'plural' in params:
            path_params['plural'] = params['plural']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_cluster_custom_object(self, group, version, plural, **kwargs):  # noqa: E501
        """list_cluster_custom_object  # noqa: E501

        list or watch cluster scoped custom objects  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_cluster_custom_object(group, version, plural, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_cluster_custom_object_with_http_info(group, version, plural, **kwargs)  # noqa: E501
        else:
            (data) = self.list_cluster_custom_object_with_http_info(group, version, plural, **kwargs)  # noqa: E501
            return data

    def list_cluster_custom_object_with_http_info(self, group, version, plural, **kwargs):  # noqa: E501
        """list_cluster_custom_object  # noqa: E501

        list or watch cluster scoped custom objects  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_cluster_custom_object_with_http_info(group, version, plural, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'pretty', 'label_selector', 'resource_version', 'watch']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cluster_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params or
                params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `list_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `list_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'plural' is set
        if ('plural' not in params or
                params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `list_cluster_custom_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501
        if 'plural' in params:
            path_params['plural'] = params['plural']  # noqa: E501

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501
        if 'label_selector' in params:
            query_params.append(('labelSelector', params['label_selector']))  # noqa: E501
        if 'resource_version' in params:
            query_params.append(('resourceVersion', params['resource_version']))  # noqa: E501
        if 'watch' in params:
            query_params.append(('watch', params['watch']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/json;stream=watch'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/{group}/{version}/{plural}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_namespaced_custom_object(self, group, version, namespace, plural, **kwargs):  # noqa: E501
        """list_namespaced_custom_object  # noqa: E501

        list or watch namespace scoped custom objects  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_namespaced_custom_object(group, version, namespace, plural, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_namespaced_custom_object_with_http_info(group, version, namespace, plural, **kwargs)  # noqa: E501
        else:
            (data) = self.list_namespaced_custom_object_with_http_info(group, version, namespace, plural, **kwargs)  # noqa: E501
            return data

    def list_namespaced_custom_object_with_http_info(self, group, version, namespace, plural, **kwargs):  # noqa: E501
        """list_namespaced_custom_object  # noqa: E501

        list or watch namespace scoped custom objects  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_namespaced_custom_object_with_http_info(group, version, namespace, plural, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: The custom resource's group name (required)
        :param str version: The custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: The custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'pretty', 'label_selector', 'resource_version', 'watch']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params or
                params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `list_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `list_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'plural' is set
        if ('plural' not in params or
                params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `list_namespaced_custom_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'plural' in params:
            path_params['plural'] = params['plural']  # noqa: E501

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501
        if 'label_selector' in params:
            query_params.append(('labelSelector', params['label_selector']))  # noqa: E501
        if 'resource_version' in params:
            query_params.append(('resourceVersion', params['resource_version']))  # noqa: E501
        if 'watch' in params:
            query_params.append(('watch', params['watch']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/json;stream=watch'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/{group}/{version}/namespaces/{namespace}/{plural}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_cluster_custom_object(self, group, version, plural, name, body, **kwargs):  # noqa: E501
        """patch_cluster_custom_object  # noqa: E501

        patch the specified cluster scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.patch_cluster_custom_object(group, version, plural, name, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to patch. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.patch_cluster_custom_object_with_http_info(group, version, plural, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_cluster_custom_object_with_http_info(group, version, plural, name, body, **kwargs)  # noqa: E501
            return data

    def patch_cluster_custom_object_with_http_info(self, group, version, plural, name, body, **kwargs):  # noqa: E501
        """patch_cluster_custom_object  # noqa: E501

        patch the specified cluster scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.patch_cluster_custom_object_with_http_info(group, version, plural, name, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to patch. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'name', 'body']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_cluster_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params or
                params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `patch_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `patch_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'plural' is set
        if ('plural' not in params or
                params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `patch_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_cluster_custom_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501
        if 'plural' in params:
            path_params['plural'] = params['plural']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/merge-patch+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/{group}/{version}/{plural}/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_namespaced_custom_object(self, group, version, namespace, plural, name, body, **kwargs):  # noqa: E501
        """patch_namespaced_custom_object  # noqa: E501

        patch the specified namespace scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.patch_namespaced_custom_object(group, version, namespace, plural, name, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to patch. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.patch_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, **kwargs)  # noqa: E501
            return data

    def patch_namespaced_custom_object_with_http_info(self, group, version, namespace, plural, name, body, **kwargs):  # noqa: E501
        """patch_namespaced_custom_object  # noqa: E501

        patch the specified namespace scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.patch_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to patch. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'name', 'body']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params or
                params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `patch_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `patch_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'plural' is set
        if ('plural' not in params or
                params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `patch_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_custom_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'plural' in params:
            path_params['plural'] = params['plural']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/merge-patch+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_cluster_custom_object(self, group, version, plural, name, body, **kwargs):  # noqa: E501
        """replace_cluster_custom_object  # noqa: E501

        replace the specified cluster scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.replace_cluster_custom_object(group, version, plural, name, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to replace. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.replace_cluster_custom_object_with_http_info(group, version, plural, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_cluster_custom_object_with_http_info(group, version, plural, name, body, **kwargs)  # noqa: E501
            return data

    def replace_cluster_custom_object_with_http_info(self, group, version, plural, name, body, **kwargs):  # noqa: E501
        """replace_cluster_custom_object  # noqa: E501

        replace the specified cluster scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.replace_cluster_custom_object_with_http_info(group, version, plural, name, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str plural: the custom object's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to replace. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'plural', 'name', 'body']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_cluster_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params or
                params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `replace_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `replace_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'plural' is set
        if ('plural' not in params or
                params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `replace_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_cluster_custom_object`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_cluster_custom_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501
        if 'plural' in params:
            path_params['plural'] = params['plural']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/{group}/{version}/{plural}/{name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_namespaced_custom_object(self, group, version, namespace, plural, name, body, **kwargs):  # noqa: E501
        """replace_namespaced_custom_object  # noqa: E501

        replace the specified namespace scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.replace_namespaced_custom_object(group, version, namespace, plural, name, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to replace. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.replace_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, **kwargs)  # noqa: E501
            return data

    def replace_namespaced_custom_object_with_http_info(self, group, version, namespace, plural, name, body, **kwargs):  # noqa: E501
        """replace_namespaced_custom_object  # noqa: E501

        replace the specified namespace scoped custom object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.replace_namespaced_custom_object_with_http_info(group, version, namespace, plural, name, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str group: the custom resource's group (required)
        :param str version: the custom resource's version (required)
        :param str namespace: The custom resource's namespace (required)
        :param str plural: the custom resource's plural name. For TPRs this would be lowercase plural kind. (required)
        :param str name: the custom object's name (required)
        :param object body: The JSON schema of the Resource to replace. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group', 'version', 'namespace', 'plural', 'name', 'body']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_custom_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in params or
                params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `replace_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or
                params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `replace_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'plural' is set
        if ('plural' not in params or
                params['plural'] is None):
            raise ValueError("Missing the required parameter `plural` when calling `replace_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_custom_object`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_custom_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group' in params:
            path_params['group'] = params['group']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501
        if 'plural' in params:
            path_params['plural'] = params['plural']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerToken']  # noqa: E501

        return self.api_client.call_api(
            '/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
