# Changelog
All notable changes to this project will be documented in this file.

This file is generated by [Semantic Release](https://python-semantic-release.readthedocs.io/en/latest/)
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

<!--next-version-placeholder-->

## v0.9.0 (2021-02-02)
### Feature
* **ArbitrageFinder:** Process trades in parallel ([`6a047e7`](https://github.com/owodunni/arbie/commit/6a047e78767f4850ebf6acbf8ae5a4d26a0e182a))

## v0.8.9 (2021-02-01)
### Fix
* **RedisState:** Delete collection when resusing keys ([`2caa9bc`](https://github.com/owodunni/arbie/commit/2caa9bcdeab1ac36c77b9cd0edf72db813f9145d))

## v0.8.8 (2021-02-01)
### Fix
* **Trader:** Make it possible to dry_run ([`ab4ccce`](https://github.com/owodunni/arbie/commit/ab4ccce1db7f7a4310d8c94f7e479b9220626c96))

## v0.8.7 (2021-01-31)
### Fix
* **Trader:** Account for gas cost when estimating trade profit ([`e8eaeec`](https://github.com/owodunni/arbie/commit/e8eaeecf7f38f29c0c479cb0404d6a9f7d90f6c1))
* **LogTrader:** Account for gas costs when extimating profit ([`c492edd`](https://github.com/owodunni/arbie/commit/c492edd31584d96b33b058cc284777ab7bfefb96))
* **Arbitrage:** Change arbitrage expr to work with +2 pools ([`32baa2a`](https://github.com/owodunni/arbie/commit/32baa2a70c815b0b633a09307a2236a55e063349))
* **Arbitrage:** Allow setting precision ([`bd407ae`](https://github.com/owodunni/arbie/commit/bd407ae7447d045ba833ce18553c4d751604d623))

## v0.8.6 (2021-01-27)
### Fix
* **Trader:** Keep trading after exception ([`404d494`](https://github.com/owodunni/arbie/commit/404d4944617f1c66913fec6656912e0855491ed3))

## v0.8.5 (2021-01-26)
### Fix
* **Whitelist:** Change default settings ([`ec81e39`](https://github.com/owodunni/arbie/commit/ec81e393502a4634ad48f50b045c663946579118))

## v0.8.4 (2021-01-22)
### Fix
* **Coingecko:** Retry response with code 429 ([`e3f94c6`](https://github.com/owodunni/arbie/commit/e3f94c6215f27ef2ee54bdc3c16a62a80b161881))

## v0.8.3 (2021-01-22)
### Fix
* **CircuitBreaker:** Use a CircuitBreaker to not get disconnected ([`ee886e3`](https://github.com/owodunni/arbie/commit/ee886e36665668a6e1211062e89e024bd0c7209e))

## v0.8.2 (2021-01-21)
### Fix
* **Whitelist:** Add config params and logging ([`7f97dd6`](https://github.com/owodunni/arbie/commit/7f97dd6dc97bfa47ead2d0e8b968af94786f0c5e))

## v0.8.1 (2021-01-21)
### Fix
* **Whitelist:** Lower request speed to not be blocked ([`1360c59`](https://github.com/owodunni/arbie/commit/1360c59516dc6e8bd302b4c63e840acead13c96c))

## v0.8.0 (2021-01-21)
### Feature
* **PoolFinder:** Filter pairs with whitelist ([`59dce2d`](https://github.com/owodunni/arbie/commit/59dce2d77023f0a0be89e40ad1bc50cffea15b95))
* **PoolFinder:** Filter tokens with whitelist ([`099c47c`](https://github.com/owodunni/arbie/commit/099c47cd0e6a69e2465c2f878a82298a9dbebded))
* **Whitelist:** Add action for finding whitelist tokens ([`66d0d5c`](https://github.com/owodunni/arbie/commit/66d0d5ce0d4b5c9849d9fd4f3e583bbe635c95e4))

### Documentation
* **readme:** Add getting started instructions ([`e98da45`](https://github.com/owodunni/arbie/commit/e98da45f1334114e5d9a803cb57acc00aa9dffc4))

## v0.7.7 (2020-12-15)
### Fix
* **Node:** Run node against alchemy archive node ([`a5b3082`](https://github.com/owodunni/arbie/commit/a5b30820024a6bf28bc192d912975ddbc7a6c78f))

## v0.7.6 (2020-12-14)
### Fix
* **Trader:** Make it possible to log trades ([`1aa202c`](https://github.com/owodunni/arbie/commit/1aa202c13045dae4f161f2b7c48528b3ba4104cd))

## v0.7.5 (2020-12-14)
### Fix
* **UniswapV2Router:** Add logging when checking value of trades ([`bcb1e12`](https://github.com/owodunni/arbie/commit/bcb1e12f52ccad83644a8bc583c40539ed8f5bd5))

## v0.7.4 (2020-12-14)
### Fix
* **App:** Log stacktrace and exception info ([`1d6a058`](https://github.com/owodunni/arbie/commit/1d6a0581fb0b6ad3a88c640262248983313edc87))

## v0.7.3 (2020-12-13)
### Fix
* **app:** Print exceptions ([`abca2ae`](https://github.com/owodunni/arbie/commit/abca2ae41896d4b0e9d37a5dac0f4e637a853865))

## v0.7.2 (2020-12-13)
### Fix
* **Brig:** Fix issues with Weth address ([`92760f1`](https://github.com/owodunni/arbie/commit/92760f16d1cc1f93e15ea88373e54acd1403a715))

## v0.7.1 (2020-12-13)
### Fix
* **gas-strategy:** Setup web3 to use gas strategy ([`9225823`](https://github.com/owodunni/arbie/commit/9225823070f91ea9344e573f83807d8eeb2840bd))
* **brig:** Update docker-compose ([`140c845`](https://github.com/owodunni/arbie/commit/140c845b7ea7debddb3b759d40775dcfb700737a))
* **Brig:** Update configurations ([`6863108`](https://github.com/owodunni/arbie/commit/68631081142dde5db106ef0826f24657787d8e3b))
* **UniswapV2Router:** Update bytecode and functions ([`3998896`](https://github.com/owodunni/arbie/commit/399889655dea62813daed45ca39446bb7ee218ca))

## v0.7.0 (2020-12-13)
### Feature
* **account:** Make it possible to sign transaction from accounts ([`0ea4a1e`](https://github.com/owodunni/arbie/commit/0ea4a1e4f3686d7cd7e615940be3228ac43e89e1))

### Fix
* **Trader:** Fix app and tests so that trader works ([`4eeca95`](https://github.com/owodunni/arbie/commit/4eeca9598e57db508f14353e4cce9f25b2871403))
* **ActionTree:** Make it possible to subscribe to multiple events ([`efbe4c3`](https://github.com/owodunni/arbie/commit/efbe4c31ee7e3e3653ad9af6d0222fea5be57b5e))

## v0.6.1 (2020-12-08)
### Fix
* **SetUpTrader:** Add action for setting up trader ([`5f2e0c9`](https://github.com/owodunni/arbie/commit/5f2e0c9c21a3737707605adc4e43d0131ddcbb03))
* **weth:** Add real weth contract ([`59aab3a`](https://github.com/owodunni/arbie/commit/59aab3a1d98accdaea1bf29e28b734cca9b8bbc9))

## v0.6.0 (2020-12-06)
### Feature
* **trader:** Add action for trading using arbie ([`8fd32a0`](https://github.com/owodunni/arbie/commit/8fd32a085ad47fcd5ed26a3fc512d7b52edb5381))

## v0.5.0 (2020-12-04)
### Feature
* Add arbie smart contract ([`0457321`](https://github.com/owodunni/arbie/commit/045732115902c6e869342a5bebef224a266feab2))
* Add router smart contract ([`8254646`](https://github.com/owodunni/arbie/commit/8254646e9ee8be1252270c79a80643bf01e9baa2))
* Add Arbie contract and Uniswap router ([`579f913`](https://github.com/owodunni/arbie/commit/579f913c67fee2335dbfc8cd673e629a005a89f5))

## v0.4.4 (2020-11-27)
### Fix
* Prevent arbitrage finder from crashing on imaginary roots ([`9c0d314`](https://github.com/owodunni/arbie/commit/9c0d3146014ebf38bdeea951a8636d4cf89d72f4))
* Remove empty pools ([`5279d8a`](https://github.com/owodunni/arbie/commit/5279d8ae5337963a09afb074597a6c162a175126))
* Fix crash when multiple arbies are running ([`25fe810`](https://github.com/owodunni/arbie/commit/25fe810353acdc3cc3f9a48bf274b26d6f638c57))

## v0.4.3 (2020-11-25)
### Performance
* Add prometheus to async functions ([`b5f462c`](https://github.com/owodunni/arbie/commit/b5f462c4fc33f99cb157e396cd6f76a07ca04229))

## v0.4.2 (2020-11-25)
### Fix
* Remove version configuration ([`7ec1edd`](https://github.com/owodunni/arbie/commit/7ec1edd191c94c1efbd252242a75d8f9de9843f9))

## [0.4.1] - 2020-11-24
### Added
- Add PoolUpdater action for updating pools
- Add Prometheus client for exporting performance metrics
### Changed
- ActionTree now runs actions async.
- Optimize Contracts using async await.
- Optimize PoolFinder using async await.
### Removed
- Remove circuit breaker, trust retry on the request lib to keep us from failing.
### Fixed

## [0.4.0] The Pusher - 2020-11-17
### Added
- Add settings to Path Finder for choosing depth, when searching for cycles.
  So that we don't have to wait untill the heat death of the universe.
- Add possibility to specify variable creation in config.yaml.
- Make it possible to run action tree by subscribing to redis channel.
  Publish to channel when adding varaible state to redis.
### Changed
- How contract factories, web3 and redis connections are created.

### Removed
- No longer possible to save and load store state to disk. We now use redis for
  keeping track of the state.
- Address() we now use str as address representation. This integrates better with
  web3.py

## [0.3.2] - 2020-11-08
### Fixed
- Issue where names would not be added when creating Tokens from contracts.
- Issue where pools with zero balance would not be filtered by PoolFinder.

## [0.3.1] - 2020-11-07
### Added
- Add logging to file. Logging rotated between 5 1mb files.
- Make it possible to load and save arbie state on startup, exit and crash.
- Add CLI option for log path.
- Add CLI option for state save path.
- Add CLI option for state load path.

### Removed
- Move examples to [arbie-examples](https://github.com/owodunni/arbie-examples) to remove repo size and
  make it easier to keep examples up to date.

### Fixed
- Issue with pickeling store containing contracts.
- Issue with pools not normalizing to 1 and being filtered out.

## [0.3.0] - The Scraper - 2020-11-02
### Added
- Find all cycles in a set of Pools. These can then be converted to trading opertunities.
- CLI application structure. Making it possible to configure Actions from yaml config.
- Add logging framework. Making it possible to write info to console.
- Add Action for finding Pools from PoolContracts like Uniswap and Balancer.
- Make it possible to specify address to WETH in config.yaml.
- Add functionality making it possible to find all pools and pairs.

## [0.2.0] - The Base - 2020-10-12
### Added
- Smart contract wrapper for interacting with balancer and uniswap.
- Automated market maker modell called Pool. Can be used to simulate Uniswap or balancer.
- TradingGraph functionality built on top of Networkx.
- Ethereum system tests against Geth

### Changed

### Removed
