# Generated by Django 3.2.9 on 2021-11-25 16:07

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import modelcluster.contrib.taggit
import modelcluster.fields
import wagtail.core.fields
import wagtail_webradio.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        ('wagtailimages', '0023_add_choose_permissions'),
        ('taggit', '0003_taggeditem_add_unique_index'),
    ]

    operations = [
        migrations.CreateModel(
            name='Podcast',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('description', wagtail.core.fields.RichTextField(blank=True, verbose_name='description')),
                ('sound_url', models.URLField(verbose_name='sound URL')),
                ('publish_date', models.DateTimeField(default=django.utils.timezone.now, verbose_name='publish date')),
                ('slug', models.SlugField(max_length=255, unique=True, verbose_name='slug')),
                ('picture', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='picture')),
            ],
            options={
                'verbose_name': 'podcast',
                'verbose_name_plural': 'podcasts',
                'ordering': ['-publish_date'],
            },
            bases=(wagtail_webradio.models.AutoSlugMixin, models.Model),
        ),
        migrations.CreateModel(
            name='TaggedPodcast',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content_object', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='podcast_tags', to='wagtail_webradio.podcast')),
                ('tag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='wagtail_webradio_taggedpodcast_items', to='taggit.tag')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RadioShow',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('description', wagtail.core.fields.RichTextField(blank=True, verbose_name='description')),
                ('contact_phone', models.CharField(blank=True, max_length=20, verbose_name='phone number')),
                ('contact_email', models.EmailField(blank=True, max_length=254, verbose_name='email')),
                ('slug', models.SlugField(max_length=255, unique=True, verbose_name='slug')),
                ('picture', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='picture')),
            ],
            options={
                'verbose_name': 'radio show',
                'verbose_name_plural': 'radio shows',
            },
            bases=(wagtail_webradio.models.AutoSlugMixin, models.Model),
        ),
        migrations.AddField(
            model_name='podcast',
            name='radio_show',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='podcasts', related_query_name='podcast', to='wagtail_webradio.radioshow', verbose_name='radio show'),
        ),
        migrations.AddField(
            model_name='podcast',
            name='tags',
            field=modelcluster.contrib.taggit.ClusterTaggableManager(blank=True, help_text='A comma-separated list of tags.', through='wagtail_webradio.TaggedPodcast', to='taggit.Tag', verbose_name='tags'),
        ),
        migrations.CreateModel(
            name='GroupRadioShowPermission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='radio_show_permissions', to='auth.group', verbose_name='group')),
                ('permission', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='auth.permission', verbose_name='permission')),
                ('radio_show', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='group_permissions', to='wagtail_webradio.radioshow', verbose_name='radio show')),
            ],
            options={
                'verbose_name': 'group radio show permission',
                'verbose_name_plural': 'group radio show permissions',
                'unique_together': {('group', 'radio_show', 'permission')},
            },
        ),
    ]
