import argparse
import logging

from .driver import OpenRgbDriver

def main():
    parser = argparse.ArgumentParser(
        prog="python -m asteria",
        description="Asteria - a framework for driving an OpenRGB server",
    )
    parser.add_argument("config")
    parser.add_argument("--address", default="localhost")
    parser.add_argument("--port", default=6742)
    args = parser.parse_args()

    # TODO: make configurable
    logging.basicConfig(level=logging.INFO)
    driver = OpenRgbDriver(args.config, args.address, args.port)
    driver.run()

if __name__ == "__main__":
    main()
