"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultContainerDefinitionProps = exports.DefaultApplicationTargetGroupProps = exports.DefaultFargateTaskDefinitionProps = exports.DefaultFargateServiceProps = exports.DefaultClusterProps = void 0;
const ecs = require("@aws-cdk/aws-ecs");
const elb = require("@aws-cdk/aws-elasticloadbalancingv2");
function DefaultClusterProps() {
    return {};
}
exports.DefaultClusterProps = DefaultClusterProps;
function DefaultFargateServiceProps() {
    return {
        assignPublicIp: false,
        desiredCount: 2,
        maxHealthyPercent: 150,
        minHealthyPercent: 75,
        platformVersion: ecs.FargatePlatformVersion.LATEST,
    };
}
exports.DefaultFargateServiceProps = DefaultFargateServiceProps;
function DefaultFargateTaskDefinitionProps() {
    return {
        cpu: 256,
        memoryLimitMiB: 512,
    };
}
exports.DefaultFargateTaskDefinitionProps = DefaultFargateTaskDefinitionProps;
function DefaultApplicationTargetGroupProps(vpc) {
    return {
        port: 8080,
        protocol: elb.ApplicationProtocol.HTTP,
        protocolVersion: elb.ApplicationProtocolVersion.HTTP1,
        targetType: elb.TargetType.IP,
        vpc,
        healthCheck: { path: '/' }
    };
}
exports.DefaultApplicationTargetGroupProps = DefaultApplicationTargetGroupProps;
function DefaultContainerDefinitionProps() {
    return {
        memoryReservationMiB: 512,
        portMappings: [{ containerPort: 8080 }],
    };
}
exports.DefaultContainerDefinitionProps = DefaultContainerDefinitionProps;
//# sourceMappingURL=data:application/json;base64,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