"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisEventSourceProps = exports.S3EventSourceProps = exports.DynamoEventSourceProps = void 0;
const lambda = require("@aws-cdk/aws-lambda");
const utils_1 = require("./utils");
const aws_lambda_event_sources_1 = require("@aws-cdk/aws-lambda-event-sources");
const s3 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const sqs_helper_1 = require("./sqs-helper");
function DynamoEventSourceProps(scope, _dynamoEventSourceProps) {
    const baseProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        bisectBatchOnError: true,
        maxRecordAge: core_1.Duration.hours(24),
        retryAttempts: 500
    };
    let extraProps = {};
    if (_dynamoEventSourceProps === undefined || (_dynamoEventSourceProps === null || _dynamoEventSourceProps === void 0 ? void 0 : _dynamoEventSourceProps.deploySqsDlqQueue) === undefined
        || _dynamoEventSourceProps.deploySqsDlqQueue) {
        const [sqsQueue] = sqs_helper_1.buildQueue(scope, 'SqsDlqQueue', {
            queueProps: _dynamoEventSourceProps === null || _dynamoEventSourceProps === void 0 ? void 0 : _dynamoEventSourceProps.sqsDlqQueueProps
        });
        extraProps = {
            onFailure: new aws_lambda_event_sources_1.SqsDlq(sqsQueue),
        };
    }
    const defaultDynamoEventSourceProps = Object.assign(baseProps, extraProps);
    return utils_1.consolidateProps(defaultDynamoEventSourceProps, _dynamoEventSourceProps === null || _dynamoEventSourceProps === void 0 ? void 0 : _dynamoEventSourceProps.eventSourceProps);
}
exports.DynamoEventSourceProps = DynamoEventSourceProps;
function S3EventSourceProps(_s3EventSourceProps) {
    const defaultS3EventSourceProps = {
        events: [s3.EventType.OBJECT_CREATED]
    };
    return utils_1.consolidateProps(defaultS3EventSourceProps, _s3EventSourceProps);
}
exports.S3EventSourceProps = S3EventSourceProps;
function KinesisEventSourceProps(scope, _kinesisEventSourceProps) {
    const baseProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        bisectBatchOnError: true,
        maxRecordAge: core_1.Duration.hours(24),
        retryAttempts: 500
    };
    let extraProps = {};
    if (_kinesisEventSourceProps === undefined || (_kinesisEventSourceProps === null || _kinesisEventSourceProps === void 0 ? void 0 : _kinesisEventSourceProps.deploySqsDlqQueue) === undefined
        || _kinesisEventSourceProps.deploySqsDlqQueue) {
        const [sqsQueue] = sqs_helper_1.buildQueue(scope, 'SqsDlqQueue', {
            queueProps: _kinesisEventSourceProps === null || _kinesisEventSourceProps === void 0 ? void 0 : _kinesisEventSourceProps.sqsDlqQueueProps
        });
        extraProps = {
            onFailure: new aws_lambda_event_sources_1.SqsDlq(sqsQueue),
        };
    }
    const defaultKinesisEventSourceProps = Object.assign(baseProps, extraProps);
    return utils_1.consolidateProps(defaultKinesisEventSourceProps, _kinesisEventSourceProps === null || _kinesisEventSourceProps === void 0 ? void 0 : _kinesisEventSourceProps.eventSourceProps);
}
exports.KinesisEventSourceProps = KinesisEventSourceProps;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLWV2ZW50LXNvdXJjZS1tYXBwaW5nLWRlZmF1bHRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibGFtYmRhLWV2ZW50LXNvdXJjZS1tYXBwaW5nLWRlZmF1bHRzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7Ozs7Ozs7Ozs7R0FXRzs7O0FBRUgsOENBQThDO0FBQzlDLG1DQUEyQztBQUMzQyxnRkFBd0o7QUFDeEosc0NBQXNDO0FBQ3RDLHdDQUFvRDtBQUVwRCw2Q0FBMEM7QUFRMUMsU0FBZ0Isc0JBQXNCLENBQUMsS0FBZ0IsRUFBRSx1QkFBMEM7SUFFakcsTUFBTSxTQUFTLEdBQTJCO1FBQ3hDLGdCQUFnQixFQUFFLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxZQUFZO1FBQ3RELGtCQUFrQixFQUFFLElBQUk7UUFDeEIsWUFBWSxFQUFFLGVBQVEsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDO1FBQ2hDLGFBQWEsRUFBRSxHQUFHO0tBQ25CLENBQUM7SUFFRixJQUFJLFVBQVUsR0FBRyxFQUFFLENBQUM7SUFFcEIsSUFBSSx1QkFBdUIsS0FBSyxTQUFTLElBQUksQ0FBQSx1QkFBdUIsYUFBdkIsdUJBQXVCLHVCQUF2Qix1QkFBdUIsQ0FBRSxpQkFBaUIsTUFBSyxTQUFTO1dBQ2hHLHVCQUF1QixDQUFDLGlCQUFpQixFQUFFO1FBQzlDLE1BQU0sQ0FBQyxRQUFRLENBQUMsR0FBRyx1QkFBVSxDQUFDLEtBQUssRUFBRSxhQUFhLEVBQUU7WUFDbEQsVUFBVSxFQUFFLHVCQUF1QixhQUF2Qix1QkFBdUIsdUJBQXZCLHVCQUF1QixDQUFFLGdCQUFnQjtTQUN0RCxDQUFDLENBQUM7UUFFSCxVQUFVLEdBQUc7WUFDWCxTQUFTLEVBQUUsSUFBSSxpQ0FBTSxDQUFDLFFBQVEsQ0FBQztTQUNoQyxDQUFDO0tBQ0g7SUFFRCxNQUFNLDZCQUE2QixHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUMsU0FBUyxFQUFFLFVBQVUsQ0FBQyxDQUFDO0lBRTNFLE9BQU8sd0JBQWdCLENBQUMsNkJBQTZCLEVBQUUsdUJBQXVCLGFBQXZCLHVCQUF1Qix1QkFBdkIsdUJBQXVCLENBQUUsZ0JBQWdCLENBQUMsQ0FBQztBQUNwRyxDQUFDO0FBekJELHdEQXlCQztBQUVELFNBQWdCLGtCQUFrQixDQUFDLG1CQUF3QztJQUV6RSxNQUFNLHlCQUF5QixHQUF1QjtRQUNwRCxNQUFNLEVBQUUsQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLGNBQWMsQ0FBQztLQUN0QyxDQUFDO0lBRUYsT0FBTyx3QkFBZ0IsQ0FBQyx5QkFBeUIsRUFBRSxtQkFBbUIsQ0FBQyxDQUFDO0FBQzFFLENBQUM7QUFQRCxnREFPQztBQUVELFNBQWdCLHVCQUF1QixDQUFDLEtBQWdCLEVBQUUsd0JBQTJDO0lBQ25HLE1BQU0sU0FBUyxHQUE0QjtRQUN6QyxnQkFBZ0IsRUFBRSxNQUFNLENBQUMsZ0JBQWdCLENBQUMsWUFBWTtRQUN0RCxrQkFBa0IsRUFBRSxJQUFJO1FBQ3hCLFlBQVksRUFBRSxlQUFRLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQztRQUNoQyxhQUFhLEVBQUUsR0FBRztLQUNuQixDQUFDO0lBRUYsSUFBSSxVQUFVLEdBQUcsRUFBRSxDQUFDO0lBRXBCLElBQUksd0JBQXdCLEtBQUssU0FBUyxJQUFJLENBQUEsd0JBQXdCLGFBQXhCLHdCQUF3Qix1QkFBeEIsd0JBQXdCLENBQUUsaUJBQWlCLE1BQUssU0FBUztXQUNsRyx3QkFBd0IsQ0FBQyxpQkFBaUIsRUFBRTtRQUMvQyxNQUFNLENBQUMsUUFBUSxDQUFDLEdBQUcsdUJBQVUsQ0FBQyxLQUFLLEVBQUUsYUFBYSxFQUFFO1lBQ2xELFVBQVUsRUFBRSx3QkFBd0IsYUFBeEIsd0JBQXdCLHVCQUF4Qix3QkFBd0IsQ0FBRSxnQkFBZ0I7U0FDdkQsQ0FBQyxDQUFDO1FBRUgsVUFBVSxHQUFHO1lBQ1gsU0FBUyxFQUFFLElBQUksaUNBQU0sQ0FBQyxRQUFRLENBQUM7U0FDaEMsQ0FBQztLQUNIO0lBRUQsTUFBTSw4QkFBOEIsR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDLFNBQVMsRUFBRSxVQUFVLENBQUMsQ0FBQztJQUU1RSxPQUFPLHdCQUFnQixDQUFDLDhCQUE4QixFQUFFLHdCQUF3QixhQUF4Qix3QkFBd0IsdUJBQXhCLHdCQUF3QixDQUFFLGdCQUFnQixDQUFDLENBQUM7QUFDdEcsQ0FBQztBQXhCRCwwREF3QkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqICBDb3B5cmlnaHQgMjAyMiBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCB7IGNvbnNvbGlkYXRlUHJvcHMgfSBmcm9tICcuL3V0aWxzJztcbmltcG9ydCB7IER5bmFtb0V2ZW50U291cmNlUHJvcHMsIFMzRXZlbnRTb3VyY2VQcm9wcywgS2luZXNpc0V2ZW50U291cmNlUHJvcHMsIFN0cmVhbUV2ZW50U291cmNlUHJvcHMsIFNxc0RscSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEtZXZlbnQtc291cmNlcyc7XG5pbXBvcnQgKiBhcyBzMyBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0IHsgQ29uc3RydWN0LCBEdXJhdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0ICogYXMgc3FzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zcXMnO1xuaW1wb3J0IHsgYnVpbGRRdWV1ZSB9IGZyb20gJy4vc3FzLWhlbHBlcic7XG5cbmV4cG9ydCBpbnRlcmZhY2UgRXZlbnRTb3VyY2VQcm9wcyB7XG4gIHJlYWRvbmx5IGV2ZW50U291cmNlUHJvcHM/OiBTdHJlYW1FdmVudFNvdXJjZVByb3BzLFxuICByZWFkb25seSBkZXBsb3lTcXNEbHFRdWV1ZT86IGJvb2xlYW4sXG4gIHJlYWRvbmx5IHNxc0RscVF1ZXVlUHJvcHM/OiBzcXMuUXVldWVQcm9wc1xufVxuXG5leHBvcnQgZnVuY3Rpb24gRHluYW1vRXZlbnRTb3VyY2VQcm9wcyhzY29wZTogQ29uc3RydWN0LCBfZHluYW1vRXZlbnRTb3VyY2VQcm9wcz86IEV2ZW50U291cmNlUHJvcHMpOiBEeW5hbW9FdmVudFNvdXJjZVByb3BzIHtcblxuICBjb25zdCBiYXNlUHJvcHM6IER5bmFtb0V2ZW50U291cmNlUHJvcHMgPSB7XG4gICAgc3RhcnRpbmdQb3NpdGlvbjogbGFtYmRhLlN0YXJ0aW5nUG9zaXRpb24uVFJJTV9IT1JJWk9OLFxuICAgIGJpc2VjdEJhdGNoT25FcnJvcjogdHJ1ZSxcbiAgICBtYXhSZWNvcmRBZ2U6IER1cmF0aW9uLmhvdXJzKDI0KSxcbiAgICByZXRyeUF0dGVtcHRzOiA1MDBcbiAgfTtcblxuICBsZXQgZXh0cmFQcm9wcyA9IHt9O1xuXG4gIGlmIChfZHluYW1vRXZlbnRTb3VyY2VQcm9wcyA9PT0gdW5kZWZpbmVkIHx8IF9keW5hbW9FdmVudFNvdXJjZVByb3BzPy5kZXBsb3lTcXNEbHFRdWV1ZSA9PT0gdW5kZWZpbmVkXG4gICAgfHwgX2R5bmFtb0V2ZW50U291cmNlUHJvcHMuZGVwbG95U3FzRGxxUXVldWUpIHtcbiAgICBjb25zdCBbc3FzUXVldWVdID0gYnVpbGRRdWV1ZShzY29wZSwgJ1Nxc0RscVF1ZXVlJywge1xuICAgICAgcXVldWVQcm9wczogX2R5bmFtb0V2ZW50U291cmNlUHJvcHM/LnNxc0RscVF1ZXVlUHJvcHNcbiAgICB9KTtcblxuICAgIGV4dHJhUHJvcHMgPSB7XG4gICAgICBvbkZhaWx1cmU6IG5ldyBTcXNEbHEoc3FzUXVldWUpLFxuICAgIH07XG4gIH1cblxuICBjb25zdCBkZWZhdWx0RHluYW1vRXZlbnRTb3VyY2VQcm9wcyA9IE9iamVjdC5hc3NpZ24oYmFzZVByb3BzLCBleHRyYVByb3BzKTtcblxuICByZXR1cm4gY29uc29saWRhdGVQcm9wcyhkZWZhdWx0RHluYW1vRXZlbnRTb3VyY2VQcm9wcywgX2R5bmFtb0V2ZW50U291cmNlUHJvcHM/LmV2ZW50U291cmNlUHJvcHMpO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gUzNFdmVudFNvdXJjZVByb3BzKF9zM0V2ZW50U291cmNlUHJvcHM/OiBTM0V2ZW50U291cmNlUHJvcHMpIHtcblxuICBjb25zdCBkZWZhdWx0UzNFdmVudFNvdXJjZVByb3BzOiBTM0V2ZW50U291cmNlUHJvcHMgPSB7XG4gICAgZXZlbnRzOiBbczMuRXZlbnRUeXBlLk9CSkVDVF9DUkVBVEVEXVxuICB9O1xuXG4gIHJldHVybiBjb25zb2xpZGF0ZVByb3BzKGRlZmF1bHRTM0V2ZW50U291cmNlUHJvcHMsIF9zM0V2ZW50U291cmNlUHJvcHMpO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gS2luZXNpc0V2ZW50U291cmNlUHJvcHMoc2NvcGU6IENvbnN0cnVjdCwgX2tpbmVzaXNFdmVudFNvdXJjZVByb3BzPzogRXZlbnRTb3VyY2VQcm9wcyk6IEtpbmVzaXNFdmVudFNvdXJjZVByb3BzIHtcbiAgY29uc3QgYmFzZVByb3BzOiBLaW5lc2lzRXZlbnRTb3VyY2VQcm9wcyA9IHtcbiAgICBzdGFydGluZ1Bvc2l0aW9uOiBsYW1iZGEuU3RhcnRpbmdQb3NpdGlvbi5UUklNX0hPUklaT04sXG4gICAgYmlzZWN0QmF0Y2hPbkVycm9yOiB0cnVlLFxuICAgIG1heFJlY29yZEFnZTogRHVyYXRpb24uaG91cnMoMjQpLFxuICAgIHJldHJ5QXR0ZW1wdHM6IDUwMFxuICB9O1xuXG4gIGxldCBleHRyYVByb3BzID0ge307XG5cbiAgaWYgKF9raW5lc2lzRXZlbnRTb3VyY2VQcm9wcyA9PT0gdW5kZWZpbmVkIHx8IF9raW5lc2lzRXZlbnRTb3VyY2VQcm9wcz8uZGVwbG95U3FzRGxxUXVldWUgPT09IHVuZGVmaW5lZFxuICAgIHx8IF9raW5lc2lzRXZlbnRTb3VyY2VQcm9wcy5kZXBsb3lTcXNEbHFRdWV1ZSkge1xuICAgIGNvbnN0IFtzcXNRdWV1ZV0gPSBidWlsZFF1ZXVlKHNjb3BlLCAnU3FzRGxxUXVldWUnLCB7XG4gICAgICBxdWV1ZVByb3BzOiBfa2luZXNpc0V2ZW50U291cmNlUHJvcHM/LnNxc0RscVF1ZXVlUHJvcHNcbiAgICB9KTtcblxuICAgIGV4dHJhUHJvcHMgPSB7XG4gICAgICBvbkZhaWx1cmU6IG5ldyBTcXNEbHEoc3FzUXVldWUpLFxuICAgIH07XG4gIH1cblxuICBjb25zdCBkZWZhdWx0S2luZXNpc0V2ZW50U291cmNlUHJvcHMgPSBPYmplY3QuYXNzaWduKGJhc2VQcm9wcywgZXh0cmFQcm9wcyk7XG5cbiAgcmV0dXJuIGNvbnNvbGlkYXRlUHJvcHMoZGVmYXVsdEtpbmVzaXNFdmVudFNvdXJjZVByb3BzLCBfa2luZXNpc0V2ZW50U291cmNlUHJvcHM/LmV2ZW50U291cmNlUHJvcHMpO1xufVxuIl19