"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaStoreContainerProps = void 0;
const cdk = require("@aws-cdk/core");
function MediaStoreContainerProps() {
    return {
        containerName: cdk.Aws.STACK_NAME,
        accessLoggingEnabled: true,
        corsPolicy: [{
                allowedHeaders: ['*'],
                allowedMethods: ['GET'],
                allowedOrigins: ['*'],
                exposeHeaders: ['*'],
                maxAgeSeconds: 3000
            }],
        policy: JSON.stringify({
            Version: '2012-10-17',
            Statement: [{
                    Sid: 'MediaStoreDefaultPolicy',
                    Effect: 'Allow',
                    Principal: '*',
                    Action: [
                        'mediastore:GetObject',
                        'mediastore:DescribeObject'
                    ],
                    Resource: `arn:${cdk.Aws.PARTITION}:mediastore:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:container/${cdk.Aws.STACK_NAME}/*`,
                    Condition: {
                        Bool: {
                            'aws:SecureTransport': 'true'
                        }
                    }
                }]
        }),
        lifecyclePolicy: JSON.stringify({
            rules: [{
                    definition: {
                        path: [
                            { wildcard: '*' }
                        ],
                        days_since_create: [
                            { numeric: ['>', 30] }
                        ]
                    },
                    action: 'EXPIRE'
                }]
        }),
        metricPolicy: {
            containerLevelMetrics: 'ENABLED'
        }
    };
}
exports.MediaStoreContainerProps = MediaStoreContainerProps;
//# sourceMappingURL=data:application/json;base64,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