"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaStoreContainer = void 0;
const cdk = require("@aws-cdk/core");
const mediastore = require("@aws-cdk/aws-mediastore");
const mediastore_defaults_1 = require("./mediastore-defaults");
const utils_1 = require("./utils");
function MediaStoreContainer(scope, mediaStoreContainerProps) {
    const defaultprops = mediastore_defaults_1.MediaStoreContainerProps();
    let mediaStoreProps;
    mediaStoreProps = utils_1.consolidateProps(defaultprops, mediaStoreContainerProps);
    // Create the MediaStore Container
    const mediaStoreContainer = new mediastore.CfnContainer(scope, 'MediaStoreContainer', mediaStoreProps);
    // Add deletion policy to retain because it will fail to delete if the container is not empty.
    mediaStoreContainer.cfnOptions.deletionPolicy = cdk.CfnDeletionPolicy.RETAIN;
    return mediaStoreContainer;
}
exports.MediaStoreContainer = MediaStoreContainer;
//# sourceMappingURL=data:application/json;base64,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