"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultS3NotificationEventTypes = exports.DefaultLoggingBucketProps = exports.DefaultS3Props = void 0;
const s3 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
function DefaultS3Props(loggingBucket, lifecycleRules) {
    return {
        encryption: s3.BucketEncryption.S3_MANAGED,
        versioned: true,
        blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
        removalPolicy: core_1.RemovalPolicy.RETAIN,
        enforceSSL: true,
        ...((lifecycleRules !== undefined) && { lifecycleRules }),
        ...((loggingBucket !== undefined) && { serverAccessLogsBucket: loggingBucket })
    };
}
exports.DefaultS3Props = DefaultS3Props;
function DefaultLoggingBucketProps() {
    return {
        encryption: s3.BucketEncryption.S3_MANAGED,
        versioned: true,
        blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
        removalPolicy: core_1.RemovalPolicy.RETAIN,
        enforceSSL: true,
    };
}
exports.DefaultLoggingBucketProps = DefaultLoggingBucketProps;
// Default event types to trigger S3 notifications
exports.defaultS3NotificationEventTypes = [s3.EventType.OBJECT_CREATED];
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiczMtYnVja2V0LWRlZmF1bHRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiczMtYnVja2V0LWRlZmF1bHRzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7Ozs7Ozs7Ozs7R0FXRzs7O0FBRUgsc0NBQXNDO0FBQ3RDLHdDQUE4QztBQUc5QyxTQUFnQixjQUFjLENBQUMsYUFBc0IsRUFBRSxjQUFtQztJQUN4RixPQUFPO1FBQ0wsVUFBVSxFQUFFLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxVQUFVO1FBQzFDLFNBQVMsRUFBRSxJQUFJO1FBQ2YsaUJBQWlCLEVBQUUsRUFBRSxDQUFDLGlCQUFpQixDQUFDLFNBQVM7UUFDakQsYUFBYSxFQUFFLG9CQUFhLENBQUMsTUFBTTtRQUNuQyxVQUFVLEVBQUUsSUFBSTtRQUNoQixHQUFHLENBQUMsQ0FBQyxjQUFjLEtBQUssU0FBUyxDQUFDLElBQUksRUFBRSxjQUFjLEVBQUUsQ0FBQztRQUN6RCxHQUFHLENBQUMsQ0FBQyxhQUFhLEtBQUssU0FBUyxDQUFDLElBQUksRUFBRSxzQkFBc0IsRUFBRSxhQUFhLEVBQUUsQ0FBQztLQUNqRSxDQUFDO0FBQ25CLENBQUM7QUFWRCx3Q0FVQztBQUVELFNBQWdCLHlCQUF5QjtJQUN2QyxPQUFPO1FBQ0wsVUFBVSxFQUFFLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxVQUFVO1FBQzFDLFNBQVMsRUFBRSxJQUFJO1FBQ2YsaUJBQWlCLEVBQUUsRUFBRSxDQUFDLGlCQUFpQixDQUFDLFNBQVM7UUFDakQsYUFBYSxFQUFFLG9CQUFhLENBQUMsTUFBTTtRQUNuQyxVQUFVLEVBQUUsSUFBSTtLQUNGLENBQUM7QUFDbkIsQ0FBQztBQVJELDhEQVFDO0FBRUQsa0RBQWtEO0FBQ3JDLFFBQUEsK0JBQStCLEdBQUcsQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLGNBQWMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiAgQ29weXJpZ2h0IDIwMjIgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiAgTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZVxuICogIHdpdGggdGhlIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgICBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcbiAqXG4gKiAgb3IgaW4gdGhlICdsaWNlbnNlJyBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiAnQVMgSVMnIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVNcbiAqICBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBleHByZXNzIG9yIGltcGxpZWQuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9uc1xuICogIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG5pbXBvcnQgKiBhcyBzMyBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0IHsgUmVtb3ZhbFBvbGljeSB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQnVja2V0LCBCdWNrZXRQcm9wcyB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1zMyc7XG5cbmV4cG9ydCBmdW5jdGlvbiBEZWZhdWx0UzNQcm9wcyhsb2dnaW5nQnVja2V0PzogQnVja2V0LCBsaWZlY3ljbGVSdWxlcz86IHMzLkxpZmVjeWNsZVJ1bGVbXSk6IHMzLkJ1Y2tldFByb3BzIHtcbiAgcmV0dXJuIHtcbiAgICBlbmNyeXB0aW9uOiBzMy5CdWNrZXRFbmNyeXB0aW9uLlMzX01BTkFHRUQsXG4gICAgdmVyc2lvbmVkOiB0cnVlLFxuICAgIGJsb2NrUHVibGljQWNjZXNzOiBzMy5CbG9ja1B1YmxpY0FjY2Vzcy5CTE9DS19BTEwsXG4gICAgcmVtb3ZhbFBvbGljeTogUmVtb3ZhbFBvbGljeS5SRVRBSU4sXG4gICAgZW5mb3JjZVNTTDogdHJ1ZSxcbiAgICAuLi4oKGxpZmVjeWNsZVJ1bGVzICE9PSB1bmRlZmluZWQpICYmIHsgbGlmZWN5Y2xlUnVsZXMgfSksXG4gICAgLi4uKChsb2dnaW5nQnVja2V0ICE9PSB1bmRlZmluZWQpICYmIHsgc2VydmVyQWNjZXNzTG9nc0J1Y2tldDogbG9nZ2luZ0J1Y2tldCB9KVxuICB9IGFzIEJ1Y2tldFByb3BzO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gRGVmYXVsdExvZ2dpbmdCdWNrZXRQcm9wcygpOiBzMy5CdWNrZXRQcm9wcyB7XG4gIHJldHVybiB7XG4gICAgZW5jcnlwdGlvbjogczMuQnVja2V0RW5jcnlwdGlvbi5TM19NQU5BR0VELFxuICAgIHZlcnNpb25lZDogdHJ1ZSxcbiAgICBibG9ja1B1YmxpY0FjY2VzczogczMuQmxvY2tQdWJsaWNBY2Nlc3MuQkxPQ0tfQUxMLFxuICAgIHJlbW92YWxQb2xpY3k6IFJlbW92YWxQb2xpY3kuUkVUQUlOLFxuICAgIGVuZm9yY2VTU0w6IHRydWUsXG4gIH0gYXMgQnVja2V0UHJvcHM7XG59XG5cbi8vIERlZmF1bHQgZXZlbnQgdHlwZXMgdG8gdHJpZ2dlciBTMyBub3RpZmljYXRpb25zXG5leHBvcnQgY29uc3QgZGVmYXVsdFMzTm90aWZpY2F0aW9uRXZlbnRUeXBlcyA9IFtzMy5FdmVudFR5cGUuT0JKRUNUX0NSRUFURURdOyJdfQ==