"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildSecretsManagerSecret = void 0;
const aws_secretsmanager_1 = require("@aws-cdk/aws-secretsmanager");
const secretsmanager_defaults_1 = require("./secretsmanager-defaults");
const utils_1 = require("./utils");
/**
 * Method to build the default AWS Secrets Manager Secret
 *
 * @param scope
 * @param id
 * @param secretProps
 */
function buildSecretsManagerSecret(scope, id, secretProps) {
    let secret;
    secret = new aws_secretsmanager_1.Secret(scope, id, utils_1.consolidateProps(secretsmanager_defaults_1.DefaultSecretProps, secretProps));
    // suppress warning on build
    utils_1.addCfnSuppressRules(secret, [
        {
            id: 'W77',
            reason: `We allow the use of the AWS account default key aws/secretsmanager for secret encryption.`
        }
    ]);
    return secret;
}
exports.buildSecretsManagerSecret = buildSecretsManagerSecret;
//# sourceMappingURL=data:application/json;base64,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