"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildWebacl = void 0;
const waf = require("@aws-cdk/aws-wafv2");
const waf_defaults_1 = require("./waf-defaults");
const utils_1 = require("./utils");
function buildWebacl(scope, webaclScope, props) {
    let webAcl;
    if (props.existingWebaclObj && !props.webaclProps) { // Existing WAF web ACL
        webAcl = props.existingWebaclObj;
    }
    else { // Create a new WAF web ACL
        let finalWebaclProps;
        finalWebaclProps = utils_1.consolidateProps(waf_defaults_1.DefaultWafwebaclProps(webaclScope), props.webaclProps);
        webAcl = new waf.CfnWebACL(scope, `${scope.node.id}-WebACL`, finalWebaclProps);
    }
    return webAcl;
}
exports.buildWebacl = buildWebacl;
//# sourceMappingURL=data:application/json;base64,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